/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.attachment;

import java.util.Map;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.web.actions.utils.FileTypeUtil;

public class FileTypeMagicNumberPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new FileTypeMagicNumberPluginProvider());
    }

    private static class FileTypeMagicNumberPluginProvider
    extends ListDataProvider {
        private FileTypeMagicNumberPluginProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection mFileTypeDynCollection = super.getData(start, limit);
            TreeSet<String> seatedSet = new TreeSet<String>();
            for (DynamicObject dynamicObject : mFileTypeDynCollection) {
                String fileHeader = dynamicObject.getString("fileheader");
                seatedSet.add(fileHeader);
            }
            DynamicObjectType dt = mFileTypeDynCollection.getDynamicObjectType();
            Map<String, String> mFileTypesMap = FileTypeUtil.getMFileTypes();
            for (Map.Entry<String, String> entry : mFileTypesMap.entrySet()) {
                String magicNumberString = entry.getKey();
                String value = entry.getValue();
                if (seatedSet.contains(magicNumberString)) continue;
                DynamicObject mFileTypeDyn = new DynamicObject(dt);
                mFileTypeDyn.set("fileheader", (Object)magicNumberString);
                mFileTypeDyn.set("filetypes", (Object)value);
                mFileTypeDynCollection.add((Object)mFileTypeDyn);
            }
            return mFileTypeDynCollection;
        }
    }
}

