/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class AttachUploadLimitPlugin
extends AbstractFormPlugin {
    private static final String FIELD_SECONDLIMIT = "secondlimit";
    private static final String FIELD_MINUTELIMIT = "minutelimit";
    private static final String FIELD_HOURLIMIT = "hourlimit";
    private static final String FIELD_DAYLIMIT = "daylimit";
    protected static final String BUTTON_OK = "btnok";
    private static final Pattern PATTERN = Pattern.compile("^[1-9]\\d*$");
    private static final String BOS_ATTACHMENT = "bos-attachment";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_OK});
    }

    public void afterCreateNewData(EventObject e) {
        Map data = this.getView().getFormShowParameter().getCustomParams();
        if (data != null && data.size() > 0) {
            this.getModel().setValue(FIELD_SECONDLIMIT, data.get(FIELD_SECONDLIMIT));
            this.getModel().setValue(FIELD_MINUTELIMIT, data.get(FIELD_MINUTELIMIT));
            this.getModel().setValue(FIELD_HOURLIMIT, data.get(FIELD_HOURLIMIT));
            this.getModel().setValue(FIELD_DAYLIMIT, data.get(FIELD_DAYLIMIT));
        }
    }

    public void click(EventObject evt) {
        if (!(evt.getSource() instanceof Button)) {
            return;
        }
        Button btn = (Button)evt.getSource();
        if (BUTTON_OK.equals(btn.getKey())) {
            this.confirmParam("upload");
        }
    }

    protected void confirmParam(String pageType) {
        String type = this.getType(pageType);
        if (StringUtils.isBlank((String)type)) {
            return;
        }
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        String secondlimit = this.formatZero(String.valueOf(this.getModel().getValue(FIELD_SECONDLIMIT)));
        String minutelimit = this.formatZero(String.valueOf(this.getModel().getValue(FIELD_MINUTELIMIT)));
        String hourlimit = this.formatZero(String.valueOf(this.getModel().getValue(FIELD_HOURLIMIT)));
        String daylimit = this.formatZero(String.valueOf(this.getModel().getValue(FIELD_DAYLIMIT)));
        if (StringUtils.isBlank((String)secondlimit) && StringUtils.isBlank((String)minutelimit) && StringUtils.isBlank((String)hourlimit) && StringUtils.isBlank((String)daylimit)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u6b21\u6570\u9650\u5236\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u81f3\u5c11\u8bbe\u7f6e\u4e00\u79cd\u9650\u5236\u3002", (String)"AttachUploadLimitPlugin_13", (String)BOS_ATTACHMENT, (Object[])new Object[0]), type));
            return;
        }
        if (this.checkLimit(secondlimit)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6bcf\u79d2\u949f\u9650\u5236%s\u6b21\u6570\u201d\u5b57\u6bb5\u503c\u7c7b\u578b\u4e3a\u6b63\u6574\u6570\u3002", (String)"AttachUploadLimitPlugin_5", (String)BOS_ATTACHMENT, (Object[])new Object[0]), type));
            return;
        }
        if (this.checkLimit(minutelimit)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6bcf\u5206\u949f\u9650\u5236%s\u6b21\u6570\u201d\u5b57\u6bb5\u503c\u7c7b\u578b\u4e3a\u6b63\u6574\u6570\u3002", (String)"AttachUploadLimitPlugin_6", (String)BOS_ATTACHMENT, (Object[])new Object[0]), type));
            return;
        }
        if (this.checkLimit(hourlimit)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6bcf\u5c0f\u65f6\u9650\u5236%s\u6b21\u6570\u201d\u5b57\u6bb5\u503c\u7c7b\u578b\u4e3a\u6b63\u6574\u6570\u3002", (String)"AttachUploadLimitPlugin_7", (String)BOS_ATTACHMENT, (Object[])new Object[0]), type));
            return;
        }
        if (this.checkLimit(daylimit)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6bcf\u5929\u9650\u5236%s\u6b21\u6570\u201d\u5b57\u6bb5\u503c\u7c7b\u578b\u4e3a\u6b63\u6574\u6570\u3002", (String)"AttachUploadLimitPlugin_8", (String)BOS_ATTACHMENT, (Object[])new Object[0]), type));
            return;
        }
        if (!StringUtils.isBlank((String)(secondlimit + minutelimit + hourlimit + daylimit))) {
            config.put(FIELD_SECONDLIMIT, secondlimit);
            config.put(FIELD_MINUTELIMIT, minutelimit);
            config.put(FIELD_HOURLIMIT, hourlimit);
            config.put(FIELD_DAYLIMIT, daylimit);
        }
        this.getView().returnDataToParent(config);
        this.getView().close();
    }

    private boolean checkLimit(String timelimit) {
        return !StringUtils.isBlank((String)timelimit) && !this.isMatches(timelimit);
    }

    private boolean isMatches(String secondlimit) {
        Matcher matcher = PATTERN.matcher(secondlimit);
        return matcher.matches();
    }

    private String getType(String pageType) {
        if ("upload".equals(pageType)) {
            return ResManager.loadKDString((String)"\u4e0a\u4f20", (String)"AttachUploadLimitPlugin_9", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
        }
        if ("download".equals(pageType)) {
            return ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"AttachUploadLimitPlugin_10", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
        }
        return "";
    }

    private String formatZero(String numberString) {
        if ("0".equals(numberString)) {
            return "";
        }
        return numberString;
    }
}

