/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.param.util.ParamDealUtil;

public class CheckBoxStatusChangePlugin
extends AbstractFormPlugin {
    private static final String CHECKBOX_FORBIDFILETYPE = "checkforbidfiletype";
    private static final String CHECKBOX_DOWNLOADLIMIT = "checkdownloadlimit";
    private static final String CHECKBOX_MAXUPLOADIMAGESIZE = "checkmaxuploadimagesize";
    private static final String CHECKBOX_COMPRESSPICSIZE = "checkcompresspicsize";
    private static final String CHECKBOX_EDIT_MODE = "checkfile_edit_mode";
    private static final String CHECKBOX_PREVIEWCONFIG_SHOWINFO = "checkpreviewconfig_show";
    private static final String CHECKBOX_SPESYMBOL = "checkspesymbol";
    private static final String CHECKBOX_MANAGERSERVICE = "checkmanagerservice";
    private static final String MAXUPLOADSIZE = "maxuploadsize";
    private static final String FORBIDFILETYPE = "forbidfiletype";
    private static final String UPLOADLIMIT = "uploadlimit";
    private static final String DOWNLOADLIMIT = "downloadlimit";
    private static final String MAXDOWNLOADSIZE = "maxdownloadsize";
    private static final String MAXUPLOADIMAGESIZE = "maxuploadimagesize";
    private static final String COMPRESSPICSIZE = "compresspicsize";
    private static final String EDIT_MODE = "file_edit_mode";
    private static final String PREVIEWCONFIG_SHOWINFO = "previewconfig_show";
    private static final String SPESYMBOL = "spesymbol";
    private static final String MANAGERSERVICE = "managerservice";
    private static final String PREVIEWCONFIG = "previewconfig";
    private static final String PREVIEWTYPE = "previewtype";
    private static final String UPLOADLIMITCONTENT = "uploadlimitcontent";
    private static final long DEFAULT_SIZE = 50L;
    private static final List<String> checkBoxShowParam = Arrays.asList("checkforbidfiletype", "checkdownloadlimit", "checkmaxuploadimagesize", "checkcompresspicsize", "checkfile_edit_mode", "checkpreviewconfig_show", "checkspesymbol", "checkmanagerservice");
    private static final List<String> textInputBox = Arrays.asList("forbidfiletype", "downloadlimit", "maxuploadimagesize", "compresspicsize", "spesymbol", "managerservice");

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (checkBoxShowParam.contains(fieldName)) {
            this.hideOrDisplayTextInput(changeSet, fieldName);
        }
        if (MAXUPLOADSIZE.equals(fieldName)) {
            if ("0".equals(this.getModel().getValue(MAXUPLOADSIZE).toString())) {
                long kb = FileServiceFactory.getAttachmentFileService().maxUploadSize();
                long mb = kb <= 0L ? 50L : kb / 0x100000L;
                this.getModel().setValue(MAXUPLOADSIZE, (Object)mb);
            }
            return;
        }
        if (MAXDOWNLOADSIZE.equals(fieldName) && this.getModel().getProperty(MAXDOWNLOADSIZE) instanceof IntegerProp && "0".equals(this.getModel().getValue(MAXDOWNLOADSIZE).toString())) {
            this.getModel().setValue(MAXDOWNLOADSIZE, ((IntegerProp)this.getModel().getProperty(MAXDOWNLOADSIZE)).getDefValue());
            return;
        }
        if (UPLOADLIMIT.equals(fieldName) && StringUtils.isBlank((Object)this.getModel().getValue(UPLOADLIMIT))) {
            Map<String, String> config = ParamDealUtil.getDefaultUploadLimit();
            this.getModel().setValue(UPLOADLIMITCONTENT, (Object)SerializationUtils.toJsonString(config));
            String configTipsUpload = ParamDealUtil.formatConfigTips(config);
            this.getModel().setValue(UPLOADLIMIT, (Object)configTipsUpload);
            return;
        }
        if (EDIT_MODE.equals(fieldName) && this.getModel().getProperty(EDIT_MODE) instanceof ComboProp && StringUtils.isBlank((Object)this.getModel().getValue(EDIT_MODE))) {
            this.getModel().setValue(EDIT_MODE, ((ComboProp)this.getModel().getProperty(EDIT_MODE)).getDefValue());
            return;
        }
        if (PREVIEWCONFIG_SHOWINFO.equals(fieldName) && StringUtils.isBlank((Object)this.getModel().getValue(PREVIEWCONFIG_SHOWINFO))) {
            HashMap<String, String> defaultConfig = new HashMap<String, String>();
            defaultConfig.put(PREVIEWTYPE, "0");
            String defaultConfigStr = SerializationUtils.toJsonString(defaultConfig);
            this.getModel().setValue(PREVIEWCONFIG, (Object)defaultConfigStr);
            ParamDealUtil.setValue4PreviewConfig(this.getModel(), defaultConfigStr);
        }
    }

    public void beforeBindData(EventObject e) {
        Object previewConfig = this.getModel().getValue(PREVIEWCONFIG);
        for (String textInput : textInputBox) {
            Object value = this.getModel().getValue(textInput);
            if (value instanceof Integer && 0 == Integer.parseInt(value.toString())) {
                this.getModel().setValue("check" + textInput, (Object)false);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{textInput});
            } else if (StringUtils.isBlank((Object)value)) {
                this.getModel().setValue("check" + textInput, (Object)false);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{textInput});
            }
            if (!PREVIEWCONFIG_SHOWINFO.equals(textInput) || !StringUtils.isNotBlank((Object)previewConfig) || !previewConfig.toString().contains(PREVIEWTYPE)) continue;
            ParamDealUtil.setValue4PreviewConfig(this.getModel(), this.getModel().getValue(PREVIEWCONFIG));
        }
        super.beforeBindData(e);
    }

    private void hideOrDisplayTextInput(ChangeData[] changeSet, String checkKey) {
        if (null != changeSet && null != changeSet[0] && null != changeSet[0].getNewValue() && changeSet[0].getNewValue() instanceof Boolean) {
            String inputKey = checkKey.replaceFirst("check", "");
            this.getView().setVisible((Boolean)changeSet[0].getNewValue(), new String[]{inputKey});
            if (!((Boolean)changeSet[0].getNewValue()).booleanValue()) {
                if (this.getModel().getValue(inputKey) instanceof Integer) {
                    this.getModel().setValue(inputKey, (Object)0);
                } else {
                    this.getModel().setValue(inputKey, (Object)"");
                }
            }
        }
    }
}

