/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import kd.bos.attachment.manage.AttachIdentify;
import kd.bos.attachment.manage.AttachInfo;
import kd.bos.attachment.manage.AttachManageService;
import kd.bos.attachment.manage.AttachmentManageUtils;
import kd.bos.attachment.manage.ImageManageService;
import kd.bos.cache.TempTransResult;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.AttachFileException;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FilePathService;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;

public class AttachFileService
implements FileService {
    private int MAX_MEN_SIZE = 314572800;
    protected FileService targetService;
    protected AttachManageService attachManageService;
    private static final Log log = LogFactory.getLog(AttachFileService.class);
    protected static IAttachmentService attachmentService = (IAttachmentService)ServiceFactory.getService(IAttachmentService.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"AttachFileService", (int)2);

    public static boolean enableAttachmentCenter() {
        return AttachmentManageUtils.enableAttachmentCenter();
    }

    public AttachFileService(FileService targetService, AttachManageService attachManageService) {
        this.targetService = targetService;
        this.attachManageService = attachManageService;
    }

    public FileService getTargetService() {
        return this.targetService;
    }

    public String upload(FileItem fileItem) {
        FileItem[] fileItems = new FileItem[]{fileItem};
        List<String> attachNos = this.upload(fileItems);
        return attachNos.get(0);
    }

    public List<String> upload(FileItem[] fileItems) {
        List attachNos;
        List paths = null;
        ArrayList<AttachInfo> attachInfos = new ArrayList<AttachInfo>(fileItems.length);
        try {
            int i;
            for (i = 0; i < fileItems.length; ++i) {
                FileItem fileItem = fileItems[i];
                AttachInfo attachInfo = this.createAttach(fileItem);
                attachInfo.setSize((long)fileItem.getInputStream().available());
                attachInfos.add(attachInfo);
            }
            paths = this.targetService.upload(fileItems);
            for (i = 0; i < fileItems.length; ++i) {
                ((AttachInfo)attachInfos.get(i)).setPath((String)paths.get(i));
            }
            attachNos = this.attachManageService.saveAttach(attachInfos);
            this.computeMd54Save(fileItems, attachNos);
        }
        catch (Throwable throwable) {
            if (paths != null) {
                for (String path : paths) {
                    try {
                        this.targetService.delete(path);
                    }
                    catch (Exception ignore) {
                        log.error((Throwable)ignore);
                    }
                }
            }
            throw new AttachFileException(throwable);
        }
        finally {
            for (FileItem fileItem : fileItems) {
                fileItem.close();
            }
        }
        List<String> fileExts = attachInfos.stream().map(AttachInfo::getExt).collect(Collectors.toList());
        return this.getReturnUpload(attachNos, paths, fileExts);
    }

    public List<TempTransResult> moveTempFile(List<FileItem> persistFileItems) {
        if (CollectionUtils.isNotEmpty(persistFileItems)) {
            List attachNos;
            ArrayList<AttachInfo> attachInfos = new ArrayList<AttachInfo>(persistFileItems.size());
            List tempTransResults = this.targetService.moveTempFile(persistFileItems);
            try {
                for (int i = 0; i < persistFileItems.size(); ++i) {
                    FileItem fileItem = persistFileItems.get(i);
                    TempTransResult tempTransResult = (TempTransResult)tempTransResults.get(i);
                    AttachInfo attachInfo = this.createAttach(fileItem);
                    attachInfo.setPath(tempTransResult.getPath());
                    attachInfos.add(attachInfo);
                }
                attachNos = this.attachManageService.saveAttach(attachInfos);
                this.computeMd54Save(persistFileItems.toArray(new FileItem[0]), attachNos);
            }
            catch (Throwable throwable) {
                throw new AttachFileException(throwable);
            }
            if (attachNos.size() != tempTransResults.size()) {
                return tempTransResults;
            }
            return this.getReturnUpload(attachNos, tempTransResults);
        }
        return new ArrayList<TempTransResult>();
    }

    private List<TempTransResult> getReturnUpload(List<String> attachNos, List<TempTransResult> tempTransResults) {
        if (!this.isEnablePathMaping()) {
            return tempTransResults;
        }
        for (int i = 0; i < tempTransResults.size(); ++i) {
            tempTransResults.get(i).setPath(attachNos.get(i));
        }
        return tempTransResults;
    }

    private void computeMd54Save(FileItem[] fileItems, List<String> attachNos) {
        threadPool.execute(() -> {
            HashMap<String, String> attachNumber2md5Map = new HashMap<String, String>(attachNos.size());
            HashMap<String, Integer> attachNumber2SizeMap = new HashMap<String, Integer>(attachNos.size());
            for (int i = 0; i < attachNos.size(); ++i) {
                FileItemExt fileItemExt;
                FileItem fileItem = fileItems[i];
                if (!(fileItem instanceof FileItemExt) || !(fileItemExt = (FileItemExt)fileItem).isComputeDigest()) continue;
                String path = (String)attachNos.get(i);
                InputStream inputStream = this.getInputStream(path);
                try {
                    int available = inputStream.available();
                    attachNumber2SizeMap.put(path, available);
                    String md5 = DigestUtils.md5Hex((InputStream)inputStream);
                    attachNumber2md5Map.put(path, md5);
                    continue;
                }
                catch (IOException e) {
                    attachNumber2md5Map.put(path, "");
                    log.error("\u8ba1\u7b97\u6587\u4ef6\u6458\u8981\u5931\u8d25\uff1a", (Throwable)e);
                }
            }
            QFilter qFilter = new QFilter("number", "in", (Object)attachNos);
            QFilter[] qFilters = new QFilter[]{qFilter};
            Map attachMap = BusinessDataServiceHelper.loadFromCache((String)"bos_svc_attachment", (QFilter[])qFilters);
            ArrayList attachList = new ArrayList(attachMap.values());
            boolean needUpdateFlag = false;
            for (DynamicObject attachDyn : attachList) {
                String number = attachDyn.getString("number");
                if (StringUtils.isEmpty((CharSequence)number)) continue;
                String md5 = (String)attachNumber2md5Map.get(number);
                Integer size = (Integer)attachNumber2SizeMap.get(number);
                String identify = attachDyn.getString("identify");
                if (size == null) {
                    size = attachDyn.getInt("size");
                }
                attachDyn.set("size", (Object)size);
                if (!StringUtils.isNotEmpty((CharSequence)md5) || !StringUtils.isEmpty((CharSequence)identify)) continue;
                attachDyn.set("identify", (Object)md5);
                needUpdateFlag = true;
            }
            if (needUpdateFlag) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.update((DynamicObject[])attachList.toArray(new DynamicObject[0]), (OperateOption)option);
            }
        });
    }

    public String compressPicUpload(FileItem fileItem, long capacity) {
        String attachNo;
        String path = null;
        AttachInfo attachInfo = this.createAttach(fileItem);
        try {
            attachInfo.setSize((long)fileItem.getInputStream().available());
            path = this.targetService.compressPicUpload(fileItem, capacity);
            attachInfo.setPath(path);
            attachNo = this.attachManageService.saveAttach(attachInfo);
        }
        catch (Throwable throwable) {
            try {
                if (StringUtils.isNotBlank(path)) {
                    this.targetService.delete(path);
                }
            }
            catch (Exception ignore) {
                log.error((Throwable)ignore);
            }
            throw new AttachFileException(throwable);
        }
        finally {
            fileItem.close();
        }
        return this.getReturnUpload(attachNo, path, attachInfo.getExt());
    }

    public void download(String path, OutputStream out, String userAgent) {
        String attachPath = this.getFilePath(path);
        this.targetService.download(attachPath, out, userAgent);
    }

    public void download(String path, HttpServletResponse servletResponse, String userAgent) {
        String attachPath = this.getFilePath(path);
        this.targetService.download(attachPath, servletResponse, userAgent);
    }

    public Map<String, Object> download(String path, String userAgent, String ext) {
        String attachPath = this.getFilePath(path);
        return this.targetService.download(attachPath, userAgent, ext);
    }

    public InputStream download(String path, Map<String, String> header, Map<String, String> resHeader) {
        String attachPath = this.getFilePath(path);
        return this.targetService.download(attachPath, header, resHeader);
    }

    public InputStream getInputStream(String path) {
        String attachPath = this.getFilePath(path);
        return this.targetService.getInputStream(attachPath);
    }

    public void delete(String path) {
        AttachIdentify attachIdentify = this.attachManageService.removeAttach(path);
        if (attachIdentify.getCount() <= 1) {
            this.targetService.delete(attachIdentify.getPath());
        }
    }

    public void batchDownload(BatchDownloadRequest request, OutputStream out, String userAgent) {
        this.handBatchDownloadRequest(request);
        this.targetService.batchDownload(request, out, userAgent);
    }

    public void batchDownload(BatchDownloadRequest request, HttpServletResponse servletResponse, String userAgent) {
        this.handBatchDownloadRequest(request);
        this.targetService.batchDownload(request, servletResponse, userAgent);
    }

    public List<String> getForbiddenExtensions() {
        return this.targetService.getForbiddenExtensions();
    }

    public List<String> getAllowExtensions() {
        return this.targetService.getAllowExtensions();
    }

    public int getMaxUploadSize() {
        return this.targetService.getMaxUploadSize();
    }

    public String getTicket() {
        return this.targetService.getTicket();
    }

    public boolean exists(String path) {
        String attachPath = this.getFilePath(path);
        return this.targetService.exists(attachPath);
    }

    public Map<String, Object> preview(String fileName, String path, String userAgent) {
        String attachPath = this.getFilePath(path);
        return this.targetService.preview(fileName, attachPath, userAgent);
    }

    public void removePreview(String id) {
        id = this.getFilePath(id);
        this.targetService.removePreview(id);
    }

    public Map<String, Object> previewFromCache(String fileName, String path, String userAgent, InputStream cacheIn) {
        String attachPath = this.getFilePath(path);
        return this.targetService.previewFromCache(fileName, attachPath, userAgent, cacheIn);
    }

    public Map<String, Object> previewWPS(String fileName, String path, String userAgent, Map<String, String> config) {
        String attachPath = this.getFilePath(path);
        return this.targetService.previewWPS(fileName, attachPath, userAgent, config);
    }

    public Map<String, Object> previewFromCacheWPS(String fileName, String path, String userAgent, InputStream cacheIn, Map<String, String> config) {
        path = this.getFilePath(path);
        return this.targetService.previewFromCacheWPS(fileName, path, userAgent, cacheIn, config);
    }

    public void deletePreviewCacheWps(String url, Map<String, String> config) {
        url = this.getFilePath(url);
        this.targetService.deletePreviewCacheWps(url, config);
    }

    public void deletePreviewWps(String path, Map<String, String> config) {
        path = this.getFilePath(path);
        this.targetService.deletePreviewCacheWps(path, config);
    }

    private AttachInfo createAttach(FileItem fileItem) {
        AttachInfo attachInfo = new AttachInfo();
        String path = fileItem.getPath();
        String fileExt = path.substring(path.lastIndexOf(".") + 1);
        attachInfo.setName(fileItem.getFileName());
        attachInfo.setExt(fileExt);
        attachInfo.setPath(fileItem.getPath());
        attachInfo.setBizAppId(fileItem.getAppId());
        attachInfo.setIdentify(" ");
        if (fileItem instanceof FileItemExt) {
            FileItemExt fileItemExt = (FileItemExt)fileItem;
            attachInfo.setSource(fileItemExt.getSource().getCode());
            attachInfo.setOrgId(fileItemExt.getOrgId());
            attachInfo.setStatus(fileItemExt.getAttachStatus());
        } else {
            attachInfo.setSource(FileSource.Unknown.getCode());
        }
        return attachInfo;
    }

    private String getFilePath(String path) {
        String attachPath = this.attachManageService.getAttachPath(path);
        if (attachPath == null) {
            attachPath = path;
        }
        return attachPath;
    }

    private boolean isEnablePathMaping() {
        FileServiceExt fileServiceExt = this.targetService.getFileServiceExt();
        if (fileServiceExt == null) {
            return false;
        }
        if (fileServiceExt instanceof FilePathService) {
            return attachmentService.isEncrptyPath();
        }
        if ("kd.bos.service.image.ImageFilePathService".equals(fileServiceExt.getClass().getName())) {
            return attachmentService.isImageEncrptyPath();
        }
        return false;
    }

    private String getReturnUpload(String attachNo, String attachPath, String fileExt) {
        if (!this.isEnablePathMaping()) {
            return attachPath;
        }
        if (this.attachManageService instanceof ImageManageService) {
            return attachNo + "." + fileExt;
        }
        return attachNo;
    }

    private List<String> getReturnUpload(List<String> attachNos, List<String> attachPaths, List<String> fileExts) {
        if (!this.isEnablePathMaping()) {
            return attachPaths;
        }
        if (this.attachManageService instanceof ImageManageService) {
            ArrayList<String> returnUpload = new ArrayList<String>(attachNos.size());
            for (int i = 0; i < attachNos.size(); ++i) {
                returnUpload.add(attachNos.get(i) + "." + fileExts.get(i));
            }
            return returnUpload;
        }
        return attachNos;
    }

    private DigestResult computeDigest(FileItem fileItem) throws IOException {
        String digest;
        InputStream inputStream = fileItem.getInputStream();
        if (inputStream.markSupported()) {
            inputStream.mark(Integer.MAX_VALUE);
            digest = DigestUtils.md5Hex((InputStream)inputStream);
            inputStream.reset();
        } else {
            int len;
            MessageDigest messageDigest = DigestUtils.getMd5Digest();
            byte[] buffer = new byte[1024];
            DeferredFileOutputStream deferredFileOutputStream = new DeferredFileOutputStream(this.MAX_MEN_SIZE, AttachFileService.getTempFile());
            while ((len = inputStream.read(buffer)) > -1) {
                messageDigest.update(buffer, 0, len);
                deferredFileOutputStream.write(buffer, 0, len);
            }
            deferredFileOutputStream.flush();
            fileItem.close();
            if (deferredFileOutputStream.isInMemory()) {
                fileItem = this.copyFileItem(fileItem, new ByteArrayInputStream(deferredFileOutputStream.getData()));
            } else {
                fileItem = this.copyFileItem(fileItem, new FileInputStream(deferredFileOutputStream.getFile()));
                fileItem.setTempFiles(new File[]{deferredFileOutputStream.getFile()});
            }
            digest = Hex.encodeHexString((byte[])messageDigest.digest());
            deferredFileOutputStream.close();
        }
        return new DigestResult(digest, fileItem);
    }

    private FileItem copyFileItem(FileItem fileItem, InputStream inputStream) {
        FileItem copy = null;
        if (fileItem instanceof FileItemExt) {
            FileItemExt copyExt = new FileItemExt(fileItem.getFileName(), fileItem.getPath(), inputStream);
            copy = copyExt;
            FileItemExt fileItemExt = (FileItemExt)fileItem;
            copyExt.setComputeDigest(fileItemExt.isComputeDigest());
            copyExt.setSource(fileItemExt.getSource());
            copyExt.setOrgId(fileItemExt.getOrgId());
        } else {
            copy = new FileItem(fileItem.getFileName(), fileItem.getPath(), inputStream);
        }
        copy.setCreateNewFileWhenExists(fileItem.isCreateNewFileWhenExists());
        copy.setAppId(fileItem.getAppId());
        copy.setFId(fileItem.getFId());
        copy.setType(fileItem.getType());
        copy.setPageId(fileItem.getPageId());
        return copy;
    }

    private static File getTempFile() {
        String tempFileName = String.format("updigest_%s.tmp", UUID.randomUUID().toString().replace("-", ""));
        File tempFile = new File(System.getProperty("java.io.tmpdir"), tempFileName);
        return tempFile;
    }

    private void handBatchDownloadRequest(BatchDownloadRequest request) {
        try {
            BatchDownloadRequest.Dir[] dirs = request.getDirs();
            BatchDownloadRequest.File[] files = request.getFiles();
            this.handBatchDirs(dirs);
            this.handBatchFiles(files);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void handBatchDirs(BatchDownloadRequest.Dir[] dirs) {
        if (dirs == null || dirs.length < 1) {
            return;
        }
        for (BatchDownloadRequest.Dir dir : dirs) {
            if (dir == null) continue;
            BatchDownloadRequest.Dir[] childDirs = dir.getDirs();
            BatchDownloadRequest.File[] files = dir.getFiles();
            this.handBatchFiles(files);
            this.handBatchDirs(childDirs);
        }
    }

    private void handBatchFiles(BatchDownloadRequest.File[] files) {
        if (files == null || files.length < 1) {
            return;
        }
        for (BatchDownloadRequest.File file : files) {
            if (file == null) continue;
            String path = file.getUrl();
            String realFilePath = this.getFilePath(path);
            file.setUrl(realFilePath);
        }
    }

    static {
        File file = new File(System.getProperty("java.io.tmpdir"));
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private static class DigestResult {
        private String digest;
        private FileItem fileItem;

        public DigestResult(String digest, FileItem fileItem) {
            this.digest = digest;
            this.fileItem = fileItem;
        }

        public String getDigest() {
            return this.digest;
        }

        public FileItem getFileItem() {
            return this.fileItem;
        }
    }
}

