/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.attachment.util.AttachmentCommonUtils;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.attachment.common.AttachmentKit;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.svc.attachment.preview.WpsPreviewHandle;
import kd.bos.svc.attachment.wps.pri.WpsPrivateHandle;
import kd.bos.web.actions.utils.AttachmentUtil;

public class PreviewCallBackService {
    private static Log log = LogFactory.getLog(PreviewCallBackService.class);
    private static final String BOS_ATTACHMENT = "bos-attachment";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void onlyOfficeEditCallback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.info("enter onlyOffice edit callback");
        ServletOutputStream outputStream = response.getOutputStream();
        InputStream in = null;
        try (Scanner scanner = new Scanner((InputStream)request.getInputStream()).useDelimiter("\\A");){
            String body = scanner.hasNext() ? scanner.next() : "";
            log.info("request param:" + body);
            JSONObject jsonObject = JSON.parseObject((String)body);
            if ("2".equals(jsonObject.getString("status")) || "6".equals(jsonObject.getString("status"))) {
                log.info("onlyOffice edit callback status is save");
                String fieldKey = request.getParameter("f");
                String key = jsonObject.getString("key");
                if (StringUtils.isBlank((CharSequence)fieldKey) || StringUtils.isBlank((CharSequence)key)) {
                    outputStream.print("{\"error\":request param error}");
                    return;
                }
                byte[] keyByte = key.getBytes();
                int sum = 0;
                for (int i = 0; i < keyByte.length; sum += keyByte[i] * i, ++i) {
                }
                if (!fieldKey.equals(String.valueOf(sum))) {
                    outputStream.print("{\"error\":check sign error}");
                    return;
                }
                String downloadUri = jsonObject.getString("url");
                in = AttachmentKit.getInputStreamByUrl((String)downloadUri, (boolean)true);
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                String tempUrl = cache.saveAsFullUrl("edit.docx", in, 7200);
                String identifyType = request.getParameter("p");
                if (StringUtils.isNotBlank((CharSequence)identifyType)) {
                    log.info("enter send ws message");
                    String message = SerializationUtils.toJsonString(AttachmentUtil.assembleParam(tempUrl, key));
                    log.info("identifyType:" + identifyType + ",send message:" + message);
                    MsgSendFactory.getSender().send(identifyType, message);
                }
            }
            outputStream.print("{\"error\":0}");
            return;
        }
        catch (Exception e) {
            outputStream.print("{\"error\":1}");
            log.error((Throwable)e);
            return;
        }
        finally {
            FileSecurityUtil.safeClose((Closeable)outputStream);
            FileSecurityUtil.safeClose(in);
        }
    }

    public static void onNotifyForWps(HttpServletRequest request) {
        log.info("onNotifyForWps  ... get get get getRequestURL() is " + request.getRequestURL().toString());
        log.info("onNotifyForWps  ... get get get paramMap is " + SerializationUtils.toJsonString((Object)request.getParameterMap()));
    }

    public static void fileInfoForWps(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileInfo;
        if ("1".equals(request.getParameter("isPrivate"))) {
            String fileId = request.getHeader("X-Weboffice-File-Id");
            String isPreview = request.getParameter("isPreview");
            log.info("fileInfoForWpsPrivate  ... get fileId is " + fileId + ",and get isPreview is:" + isPreview);
            boolean preview = StringUtils.equals((CharSequence)isPreview, (CharSequence)"1");
            String token = request.getHeader("X-Wps-Weboffice-Token");
            Map config = ParamUtil.getWpsPrivateParam((boolean)preview);
            String secretKey = (String)config.get("wpsPrivateSecret");
            boolean pass = AttachmentCommonUtils.jwtVerify((String)secretKey, (String)token);
            if (!pass) {
                HashMap<String, Object> errorParam = new HashMap<String, Object>();
                errorParam.put("code", 40003);
                errorParam.put("message", "PermissionDenied");
                errorParam.put("details", ResManager.loadKDString((String)"\u7528\u6237\u65e0\u6743\u9650\u8bbf\u95ee", (String)"WPSPREVIEWANDEDIT_0", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString(errorParam));
                return;
            }
            fileInfo = WpsPrivateHandle.getFileInfoById(fileId, isPreview);
            log.info("fileInfoForWpsPrivate  ... get fileInfo is " + fileInfo);
        } else {
            String id = request.getParameter("_w_id");
            String isPreview = request.getParameter("isPreview");
            log.info("fileInfoForWps  ... get _w_id is " + id + ",and get isPreview is:" + isPreview);
            fileInfo = WpsPreviewHandle.getFileInfoById(id, isPreview);
            log.info("fileInfoForWps  ... get fileInfo is " + fileInfo);
        }
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)fileInfo);
    }
}

