/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.attachment.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.svc.attachment.service.ThirdPreviewAndEditServiceFactory;
import kd.bos.svc.attachment.wps.action.WpsAttachAction;
import kd.bos.web.actions.AttachmentAction;
import org.apache.commons.lang.StringUtils;

public class ThirdPreviewAndEditCommonFilter
implements Filter {
    private static final Log log = LogFactory.getLog(ThirdPreviewAndEditCommonFilter.class);
    private static final String FILE_INFO = "/attachment/v1/3rd/file/info";
    private static final String NOTIFY = "/attachment/v1/3rd/onnotify";
    private static final String ONLY_OFFICE = "/attachment/v1/3rd/file/onlyoffice";
    private static final String NEW = "/attachment/v1/3rd/file/new";
    private static final String USER = "/attachment/v1/3rd/user/info";
    private static final String HISTORY = "/attachment/v1/3rd/file/history";
    private static final String ONLINE = "/attachment/v1/3rd/file/online";
    private static final String RENAME = "/attachment/v1/3rd/file/rename";
    private static final String SAVE = "/attachment/v1/3rd/file/save";
    private static final String VERSION = "/attachment/v1/3rd/file/version";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        String requestUri = httpRequest.getRequestURI();
        try {
            if (StringUtils.isNotEmpty((String)requestUri)) {
                if (requestUri.contains(FILE_INFO)) {
                    AttachmentAction.fileInfoForWps(httpRequest, httpResponse);
                } else if (requestUri.contains(NOTIFY)) {
                    AttachmentAction.onNotifyForWps(httpRequest, httpResponse);
                } else if (requestUri.contains(ONLY_OFFICE)) {
                    new AttachmentAction().onlyOfficeEditCallback(httpRequest, httpResponse);
                } else if (requestUri.contains(NEW)) {
                    WpsAttachAction.createNewFileForWps(httpRequest, httpResponse);
                } else if (requestUri.contains(USER)) {
                    WpsAttachAction.getUserInfoForWps(httpRequest, httpResponse);
                } else if (requestUri.contains(HISTORY)) {
                    WpsAttachAction.history(httpRequest, httpResponse);
                } else if (requestUri.contains(ONLINE)) {
                    WpsAttachAction.online(httpRequest, httpResponse);
                } else if (requestUri.contains(RENAME)) {
                    WpsAttachAction.renameForWps(httpRequest, httpResponse);
                } else if (requestUri.contains(SAVE)) {
                    WpsAttachAction.saveFileForWps(httpRequest, httpResponse);
                } else if (requestUri.contains(VERSION)) {
                    WpsAttachAction.version(httpRequest, httpResponse);
                } else {
                    ThirdPreviewAndEditServiceFactory.getService().execute(httpRequest, httpResponse);
                }
            } else {
                log.error("get request uri is empty");
            }
        }
        catch (Exception e) {
            log.error("ThirdPreviewCommonFilter callback failed", (Throwable)e);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

