/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.attachment.wps.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.svc.attachment.wps.action.WpsV3Action;
import org.apache.commons.lang.StringUtils;

public class WpsV3Filter
implements Filter {
    private static final Log log = LogFactory.getLog(WpsV3Filter.class);
    private static final String DOWNLOAD = "download";
    private static final String PERMISSION = "permission";
    private static final String UPLOAD = "upload";
    private static final String USERS = "users";
    private static final String WATERMARK = "watermark";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        String requestUri = httpRequest.getRequestURI();
        try {
            if (StringUtils.isNotEmpty((String)requestUri)) {
                if (requestUri.contains(DOWNLOAD)) {
                    WpsV3Action.downloadCallBack(httpRequest, httpResponse);
                } else if (requestUri.contains(PERMISSION)) {
                    WpsV3Action.permissionCallBack(httpRequest, httpResponse);
                } else if (requestUri.contains(UPLOAD)) {
                    WpsV3Action.uploadCallBack(httpRequest, httpResponse);
                } else if (requestUri.contains(USERS)) {
                    WpsV3Action.userCallBack(httpRequest, httpResponse);
                } else if (requestUri.contains(WATERMARK)) {
                    WpsV3Action.watermarkCallBack(httpRequest, httpResponse);
                } else {
                    WpsV3Action.fileInfoCallBack(httpRequest, httpResponse);
                }
            } else {
                log.error("get request uri is empty");
            }
        }
        catch (Exception e) {
            log.error("wps v3 callback failed", (Throwable)e);
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

