/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.attachment.wps.pri;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kd.bos.attachment.util.AttachmentCommonUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.form.attachment.util.AttachmentPreviewUtil;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.form.attachment.util.SupportPreviewTypeConstant;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.svc.attachment.preview.WpsPreviewHandle;
import kd.bos.svc.attachment.preview.WpsPreviewInfo;
import kd.bos.svc.attachment.wps.pri.dto.FileInfoRsp;
import kd.bos.svc.attachment.wps.pri.dto.User;
import kd.bos.svc.attachment.wps.pri.dto.Watermark;
import kd.bos.svc.attachment.wps.pri.dto.WpsFileInfo;
import kd.bos.svc.attachment.wps.pri.sign.HMacUtils;
import kd.bos.url.UrlService;
import kd.bos.util.HttpClientUtils;
import kd.bos.web.actions.utils.AttachmentUtil;
import kd.bos.web.actions.utils.FilePathUtil;

public class WpsPrivateHandle
extends WpsPreviewHandle {
    private static final Log log = LogFactory.getLog(WpsPrivateHandle.class);
    private static final DistributeSessionlessCache wpsPrivateCallbackFileInfo = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("wpsPrivateCallbackFileInfo", new DistributeCacheHAPolicy(true, true));

    public static Map<String, Object> createWpsPreViewResult(String path) throws Exception {
        return WpsPrivateHandle.createWpsPreViewResult(path, new Watermark());
    }

    public static Map<String, Object> createWpsPreViewResult(String path, Watermark watermark) throws Exception {
        String wpsPreviewUrl = WpsPrivateHandle.getPreviewUrlForWpsPrivate(path, watermark);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("status", "success");
        resultMap.put("url", wpsPreviewUrl);
        resultMap.put("support", true);
        if ("NOTSUPPORT".equals(wpsPreviewUrl)) {
            resultMap.put("status", "error");
            resultMap.put("support", false);
        } else {
            resultMap.put("token", AttachmentCommonUtils.getWpsJwtToken((boolean)true));
        }
        return resultMap;
    }

    public static String getPreviewUrlForWpsPrivate(String path, Watermark watermark) throws Exception {
        WpsPreviewInfo wpsPreviewInfo = WpsPrivateHandle.queryBillFillMapping(path);
        String fileName = wpsPreviewInfo.getName();
        log.debug("createPreviewUrlForWpsPrivate get filename is:" + fileName);
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (!WpsPrivateHandle.supportPreviewForWpsPrivate(fileExt)) {
            return "NOTSUPPORT";
        }
        String fileId = WpsPrivateHandle.generateFileInfoForWps(wpsPreviewInfo, false, watermark);
        String fileType = WpsPrivateHandle.getWpsFileType(fileExt);
        return WpsPrivateHandle.getPreViewUrlForWpsPrivate(fileId, fileType);
    }

    public static String getEditUrlForWpsPrivate(String url, String rootPageId) throws Exception {
        return WpsPrivateHandle.getEditUrlForWpsPrivate(url, rootPageId, true);
    }

    public static String getEditUrlForWpsPrivate(String url, String rootPageId, Boolean edit) throws Exception {
        log.debug("getEditUrlForWpsPrivate param url is:" + url);
        String path = UrlUtil.getParam((String)url, (String)"path");
        path = FilePathUtil.dealPath((String)URLDecoder.decode(path, "UTF-8"), (String)"attach");
        log.debug("getEditUrlForWpsPrivate path is:" + path);
        if (path.startsWith("//")) {
            path = path.replaceFirst("//", "/");
        }
        WpsPreviewInfo wpsPreviewInfo = WpsPrivateHandle.queryBillFillMapping(path);
        String fileName = wpsPreviewInfo.getName();
        log.debug("getEditUrlForWpsPrivate get filename is:" + fileName);
        String fileId = WpsPrivateHandle.generateFileInfoForWps(wpsPreviewInfo, edit, new Watermark());
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
        String fileType = WpsPrivateHandle.getWpsFileType(fileExt);
        boolean isTempFile = path.contains("tempfile/download.do?configKey");
        String editUrl = WpsPrivateHandle.getEditUrlForWps(fileId, fileType, edit, isTempFile);
        if (StringUtils.isNotBlank((CharSequence)editUrl)) {
            return editUrl + "&p=" + rootPageId;
        }
        return editUrl;
    }

    public static String getNewFileEditUrl(String url, String rootPageId, String name, Integer size) {
        String fileId = UUID.randomUUID().toString().replace("-", "");
        WpsPreviewInfo wpsPreviewInfo = new WpsPreviewInfo(fileId, url, name, size.intValue());
        WpsPrivateHandle.generateFileInfoForWps(wpsPreviewInfo, true, new Watermark());
        String fileExt = name.substring(name.lastIndexOf(".") + 1);
        String type = WpsPrivateHandle.getWpsFileType(fileExt);
        String editUrl = WpsPrivateHandle.getEditUrlForWps(fileId, type, true, true);
        if (StringUtils.isNotBlank((CharSequence)editUrl)) {
            return editUrl + "&p=" + rootPageId;
        }
        return editUrl;
    }

    public static String saveFile(String identifyType, String fileName, InputStream in, String wId) throws IOException {
        return WpsPrivateHandle.saveFile(identifyType, fileName, in, wId, null, false);
    }

    public static String saveFile(String identifyType, String fileName, InputStream in, String wId, String customEditInfo, boolean isTempFile) throws IOException {
        int version = 1;
        if (!isTempFile) {
            version = WpsPrivateHandle.updateFileVersion(wId, "22");
        } else {
            String versionStr = (String)wpsPrivateCallbackFileInfo.get("version" + wId);
            version = StringUtils.isNotBlank((CharSequence)versionStr) ? Integer.parseInt(versionStr) + 1 : 2;
            wpsPrivateCallbackFileInfo.put("version" + wId, (Object)String.valueOf(version), 8, TimeUnit.HOURS);
        }
        return WpsPrivateHandle.saveFileAndSendMessage(identifyType, fileName, in, wId, version, customEditInfo);
    }

    private static String generateFileInfoForWps(WpsPreviewInfo wpsPreviewInfo, boolean isEdit, Watermark watermark) {
        Map customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        String userName = requestContext.getUserName();
        String url = wpsPreviewInfo.getDownloadUrl();
        String fileId = wpsPreviewInfo.getId();
        int currentTime = AttachmentUtil.getSecondTimestamp();
        WpsFileInfo fileInfo = new WpsFileInfo();
        fileInfo.setId(fileId);
        fileInfo.setName(wpsPreviewInfo.getName());
        fileInfo.setSize(Math.toIntExact(wpsPreviewInfo.getSize()));
        int version = WpsPrivateHandle.getCurrentFileVersion(fileId);
        fileInfo.setVersion(version);
        fileInfo.setReadonly(!isEdit);
        fileInfo.setCreator(userId);
        fileInfo.setCreate_time(currentTime);
        fileInfo.setModifier(userId);
        fileInfo.setModify_time(currentTime);
        fileInfo.setPreview_pages(0);
        if (wpsPreviewInfo.getDownloadUrl() != null && wpsPreviewInfo.getDownloadUrl().contains("tempfile/download.do?configKey")) {
            url = AttachmentServiceHelper.getEncreptURL((String)url);
        } else {
            url = AttachmentUtil.encodePath(url);
            url = AttachmentServiceHelper.getEncreptURL((String)UrlService.getAttachmentFullUrl((String)url));
        }
        url = AttachmentUtil.addDownloadSourceParam(url, "&isFromWps=1");
        url = AttachmentPreviewUtil.getReplaceUrl((String)url, (String)"0", (!isEdit ? 1 : 0) != 0);
        fileInfo.setDownload_url(url);
        User user = new User();
        user.setId(userId);
        user.setName(userName);
        if (isEdit) {
            user.setPermission("write");
        } else {
            user.setPermission("read");
        }
        if (!isEdit && StringUtils.isNotBlank((CharSequence)watermark.getValue())) {
            fileInfo.setWatermark(watermark);
        }
        FileInfoRsp response = new FileInfoRsp(fileInfo, user);
        String result = SerializationUtils.toJsonString((Object)response);
        if (Boolean.parseBoolean((String)customParameterFromCache.get("Attachment_LOG_EXT"))) {
            log.debug("generateFileInfoForWps result is:" + result);
        }
        if (isEdit) {
            wpsPrivateCallbackFileInfo.put("EDIT" + fileId, (Object)result, 8, TimeUnit.HOURS);
        } else {
            wpsPrivateCallbackFileInfo.put("PREVIEW" + fileId, (Object)result, 5, TimeUnit.MINUTES);
        }
        return fileId;
    }

    private static String getPreViewUrlForWpsPrivate(String fileId, String fileType) {
        String pathAndUrl = "/open/api/preview/v1/files/" + fileId + "/link?type=" + fileType + "&preview_mode=high_definition&isPrivate=1&isPreview=1&_w_tokentype=1";
        String path = "/api/preview/v1/files/" + fileId + "/link";
        String param = "type=" + fileType + "&preview_mode=high_definition&isPrivate=1&isPreview=1&_w_tokentype=1";
        String customParam = ParamUtil.getParamByType((String)"2", (boolean)true);
        if (StringUtils.isNotBlank((CharSequence)customParam)) {
            param = param + customParam;
            pathAndUrl = pathAndUrl + customParam;
        }
        return WpsPrivateHandle.getPreviewOrEditUrl(path, param, pathAndUrl, true);
    }

    private static String getEditUrlForWps(String fileId, String fileType, Boolean edit, boolean isTempFile) {
        String isPreview = "1";
        if (edit.booleanValue()) {
            isPreview = "0";
        }
        String tempFile = isTempFile ? "1" : "0";
        String pathAndUrl = "/open/api/edit/v1/files/" + fileId + "/link?type=" + fileType + "&isPrivate=1&isPreview=" + isPreview + "&_w_tokentype=1&isTempFile=" + tempFile;
        String path = "/api/edit/v1/files/" + fileId + "/link";
        String param = "type=" + fileType + "&isPrivate=1&isPreview=" + isPreview + "&_w_tokentype=1&isTempFile=" + tempFile;
        String customParam = ParamUtil.getParamByType((String)"2", (boolean)false);
        if (StringUtils.isNotBlank((CharSequence)customParam)) {
            param = param + customParam;
            pathAndUrl = pathAndUrl + customParam;
        }
        return WpsPrivateHandle.getPreviewOrEditUrl(path, param, pathAndUrl, false);
    }

    private static String getPreviewOrEditUrl(String path, String param, String pathAndUrl, boolean isPreview) {
        Map config = ParamUtil.getWpsPrivateParam((boolean)isPreview);
        String accessKey = (String)config.get("wpsPrivateAppId");
        String secretKey = (String)config.get("wpsPrivateSecret");
        String serverUrl = (String)config.get("wpsPrivateServerUrl");
        String url = serverUrl + pathAndUrl;
        if (StringUtils.isNotBlank((CharSequence)param)) {
            path = path + "?" + param;
        }
        if (path.startsWith("/open")) {
            path = path.replace("/open", "");
        }
        String contentType = "application/json";
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = dateFormat.format(new Date());
        String signature = null;
        String method = "GET";
        try {
            signature = HMacUtils.HMACSHA256("WPS-4" + method + path + contentType + date, secretKey);
        }
        catch (Exception e) {
            log.error("wps sign error", (Throwable)e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", contentType);
        headers.put("Wps-Docs-Date", date);
        headers.put("Wps-Docs-Authorization", String.format("WPS-4 %s:%s", accessKey, signature));
        HashMap bodyMap = new HashMap();
        String response = HttpClientUtils.get((String)url, headers, bodyMap);
        if (StringUtils.isBlank((CharSequence)response)) {
            log.error("wps private get response is empty");
            return "";
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        String previewUrl = "";
        if (jsonObject.get((Object)"code") instanceof Integer && (Integer)jsonObject.get((Object)"code") == 200) {
            Object data = jsonObject.get((Object)"data");
            if (data instanceof JSONObject) {
                previewUrl = ((JSONObject)data).getString("link");
                previewUrl = AttachmentPreviewUtil.getReplaceUrl((String)previewUrl, (String)"1", (boolean)isPreview);
                return AttachmentServiceHelper.getEncreptURL((String)previewUrl);
            }
        } else {
            log.error("get wps private edit or preview url error code:" + jsonObject.get((Object)"code") + ",and error info" + jsonObject.getString("msg"));
        }
        return previewUrl;
    }

    public static String getFileInfoById(String id, String preview) {
        String callbackInfo;
        boolean isPreview = StringUtils.equals((CharSequence)preview, (CharSequence)"1");
        if (isPreview) {
            callbackInfo = (String)wpsPrivateCallbackFileInfo.get("PREVIEW" + id);
            wpsPrivateCallbackFileInfo.put("PREVIEW" + id, (Object)callbackInfo, 5, TimeUnit.MINUTES);
        } else {
            log.debug("start callback edit info");
            callbackInfo = (String)wpsPrivateCallbackFileInfo.get("EDIT" + id);
            wpsPrivateCallbackFileInfo.put("EDIT" + id, (Object)callbackInfo, 8, TimeUnit.HOURS);
        }
        log.debug("wps private callback file info is:" + callbackInfo);
        return callbackInfo;
    }

    private static boolean supportPreviewForWpsPrivate(String fileType) {
        for (String type : SupportPreviewTypeConstant.wpsPrivateSupportPreview) {
            if (!type.equalsIgnoreCase(fileType)) continue;
            return true;
        }
        return false;
    }

    private static String getWpsFileType(String fileExt) {
        for (Map.Entry entry : SupportPreviewTypeConstant.wpsPrivateFileTypeMapping.entrySet()) {
            if (!((Set)entry.getValue()).contains(fileExt.toLowerCase(Locale.ENGLISH))) continue;
            return (String)entry.getKey();
        }
        return "w";
    }
}

