/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.attachment.wps.v3;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileItemParser;
import kd.bos.form.attachment.util.AttachmentPreviewUtil;
import kd.bos.form.attachment.util.SupportPreviewTypeConstant;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.svc.attachment.preview.WpsPreviewHandle;
import kd.bos.svc.attachment.preview.WpsPreviewInfo;
import kd.bos.svc.attachment.wps.dto.WpsUserInfo;
import kd.bos.svc.attachment.wps.edit.WpsEditHandle;
import kd.bos.svc.attachment.wps.pri.dto.Watermark;
import kd.bos.svc.attachment.wps.v3.dto.FileDownLoadVo;
import kd.bos.svc.attachment.wps.v3.dto.FileInfoVo;
import kd.bos.svc.attachment.wps.v3.dto.PermissionVo;
import kd.bos.svc.attachment.wps.v3.dto.WpsCacheVo;
import kd.bos.svc.attachment.wps.v3.dto.WpsResponseVo;
import kd.bos.url.UrlService;
import kd.bos.web.actions.utils.AttachmentUtil;
import kd.bos.web.actions.utils.FilePathUtil;
import org.apache.commons.lang.StringUtils;

public class WpsV3Handle
extends WpsPreviewHandle {
    private static final Log log = LogFactory.getLog(WpsV3Handle.class);
    private static final DistributeSessionlessCache wpsV3CallbackFileInfo = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("wpsV3CallbackFileInfo", new DistributeCacheHAPolicy(true, true));

    public static String callBackDispatch(HttpServletRequest request, String method) {
        String cacheInfo;
        String requestUri = request.getRequestURI();
        log.debug("wps v3 callback get requestUri is:" + requestUri);
        String[] splits = requestUri.split("/");
        String fileId = splits[splits.length - 1];
        if (!"1".equals(method)) {
            fileId = splits[splits.length - 2];
        }
        log.debug("wps v3 call back get file id is:" + fileId);
        boolean isPreview = StringUtils.isBlank((String)WpsV3Handle.getIdentifyParam(request));
        if (isPreview) {
            cacheInfo = (String)wpsV3CallbackFileInfo.get("PREVIEW" + fileId);
            if (StringUtils.isNotEmpty((String)cacheInfo)) {
                wpsV3CallbackFileInfo.put("PREVIEW" + fileId, (Object)cacheInfo, 5, TimeUnit.MINUTES);
            }
        } else {
            log.debug("wps v3 get cache info is edit");
            cacheInfo = (String)wpsV3CallbackFileInfo.get("EDIT" + fileId);
            if (StringUtils.isNotEmpty((String)cacheInfo)) {
                wpsV3CallbackFileInfo.put("EDIT" + fileId, (Object)cacheInfo, 8, TimeUnit.HOURS);
            }
        }
        log.debug("wps v3 call back get fileInfo from cache is:" + cacheInfo);
        WpsResponseVo responseVo = new WpsResponseVo();
        if (StringUtils.isNotEmpty((String)cacheInfo)) {
            WpsCacheVo cacheVo = (WpsCacheVo)SerializationUtils.fromJsonString((String)cacheInfo, WpsCacheVo.class);
            responseVo.setCode(0);
            String logStr = "";
            if ("1".equals(method)) {
                logStr = "get file info";
                responseVo.setData(cacheVo.getFileInfoVo());
            } else if ("2".equals(method)) {
                logStr = "get permission info";
                responseVo.setData(cacheVo.getPermissionVo());
            } else if ("3".equals(method)) {
                logStr = "get url info";
                responseVo.setData(cacheVo.getUrl());
            } else if ("4".equals(method)) {
                logStr = "upload file";
                WpsV3Handle.dealEditedFile(request, fileId);
                responseVo.setData(cacheVo.getFileInfoVo());
            } else if ("5".equals(method)) {
                logStr = "users";
                responseVo.setData(WpsV3Handle.getUserInfo(request));
            } else if ("6".equals(method)) {
                logStr = "watermark";
                responseVo.setData(cacheVo.getWatermark());
            }
            log.debug("wps v3 call back " + logStr);
        } else if ("5".equals(method)) {
            log.debug("wps v3 call back users");
            responseVo.setData(WpsV3Handle.getUserInfo(request));
        } else {
            responseVo.setCode(-1);
            responseVo.setData(new FileInfoVo());
        }
        return SerializationUtils.toJsonString((Object)responseVo);
    }

    public static Map<String, Object> getPreviewResult(String path) throws Exception {
        return WpsV3Handle.getPreviewResult(path, new Watermark());
    }

    public static Map<String, Object> getPreviewResult(String path, Watermark watermark) throws Exception {
        String fileId = WpsV3Handle.generateFileInfo(path, true, watermark);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("fileId", fileId);
        result.put("status", "success");
        result.put("support", true);
        if ("NOTSUPPORT".equals(fileId)) {
            result.put("status", "error");
            result.put("support", false);
        }
        return result;
    }

    public static String getWpsV3FileId(String url, Boolean isPreview) throws Exception {
        String path;
        if (url.contains("tempfile/download.do?configKey")) {
            path = url;
        } else {
            path = UrlUtil.getParam((String)url, (String)"path");
            path = FilePathUtil.dealPath((String)URLDecoder.decode(path, "UTF-8"), (String)"attach");
            log.debug("getWpsV3FileId path is:" + path);
            if (path.startsWith("//")) {
                path = path.replaceFirst("//", "/");
            }
        }
        return WpsV3Handle.generateFileInfo(path, isPreview, new Watermark());
    }

    private static String generateFileInfo(String path, boolean isPreview, Watermark watermark) throws Exception {
        WpsPreviewInfo wpsPreviewInfo = WpsV3Handle.queryBillFillMapping(path);
        String fileName = wpsPreviewInfo.getName();
        log.debug("wps v3 generateFileInfo get filename is:" + fileName);
        if (isPreview && !WpsV3Handle.supportWpsV3Preview(fileName.substring(fileName.lastIndexOf(".") + 1))) {
            return "NOTSUPPORT";
        }
        if (path.contains("tempfile/download.do?configKey")) {
            wpsPreviewInfo.setId(UUID.randomUUID().toString().replace("-", ""));
        }
        WpsV3Handle.generateFileInfoAndFillCache(wpsPreviewInfo, isPreview, watermark);
        return wpsPreviewInfo.getId();
    }

    private static void generateFileInfoAndFillCache(WpsPreviewInfo wpsPreviewInfo, boolean isPreview, Watermark watermark) {
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        WpsCacheVo cacheVo = new WpsCacheVo();
        cacheVo.setFileInfoVo(WpsV3Handle.setFileInfo(wpsPreviewInfo, userId));
        cacheVo.setUrl(WpsV3Handle.dealDownloadUrl(wpsPreviewInfo.getDownloadUrl(), isPreview));
        cacheVo.setPermissionVo(WpsV3Handle.setPermissionInfo(userId, isPreview));
        if (isPreview && StringUtils.isNotEmpty((String)watermark.getValue())) {
            cacheVo.setWatermark(watermark);
        }
        String allInfo = SerializationUtils.toJsonString((Object)cacheVo);
        log.debug("wps v3 saved info is:" + allInfo);
        if (isPreview) {
            wpsV3CallbackFileInfo.put("PREVIEW" + wpsPreviewInfo.getId(), (Object)allInfo, 5, TimeUnit.MINUTES);
        } else {
            wpsV3CallbackFileInfo.put("EDIT" + wpsPreviewInfo.getId(), (Object)allInfo, 8, TimeUnit.HOURS);
        }
    }

    private static FileInfoVo setFileInfo(WpsPreviewInfo wpsPreviewInfo, String userId) {
        int timeStamp = AttachmentUtil.getSecondTimestamp();
        FileInfoVo fileInfoVo = new FileInfoVo();
        fileInfoVo.setId(wpsPreviewInfo.getId());
        fileInfoVo.setSize(Math.toIntExact(wpsPreviewInfo.getSize()));
        fileInfoVo.setName(wpsPreviewInfo.getName());
        fileInfoVo.setVersion(timeStamp);
        fileInfoVo.setCreator_id(userId);
        fileInfoVo.setCreate_time(timeStamp);
        fileInfoVo.setModifier_id(userId);
        fileInfoVo.setModify_time(timeStamp);
        return fileInfoVo;
    }

    private static FileDownLoadVo dealDownloadUrl(String path, boolean isPreview) {
        String downloadUrl;
        if (path.contains("tempfile/download.do?configKey")) {
            downloadUrl = path;
        } else {
            path = AttachmentUtil.encodePath(path);
            downloadUrl = UrlService.getAttachmentFullUrl((String)path);
        }
        downloadUrl = AttachmentServiceHelper.getEncreptURL((String)downloadUrl);
        downloadUrl = AttachmentUtil.addDownloadSourceParam(downloadUrl, "&isFromWps=1");
        downloadUrl = AttachmentPreviewUtil.getReplaceUrl((String)downloadUrl, (String)"0", (boolean)isPreview);
        FileDownLoadVo vo = new FileDownLoadVo();
        vo.setUrl(downloadUrl);
        return vo;
    }

    private static PermissionVo setPermissionInfo(String userId, boolean isPreview) {
        PermissionVo permissionVo = new PermissionVo(userId, 1, 0, 0, 0, 0);
        permissionVo.setHistory(0);
        permissionVo.setPrint(1);
        permissionVo.setComment(isPreview ? 0 : 1);
        permissionVo.setUpdate(isPreview ? 0 : 1);
        return permissionVo;
    }

    private static void dealEditedFile(HttpServletRequest request, String fileId) {
        InputStream in = null;
        try {
            FileItem fileItem = FileItemParser.parseHttpRequest((HttpServletRequest)request);
            in = fileItem.getInputStream();
            String fileName = fileItem.getFileName();
            log.debug("wps v3 get file name is:" + fileName);
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String rootPageId = WpsV3Handle.getIdentifyParam(request);
            String tempUrl = cache.saveAsFullUrl(fileName, in, 7200);
            if (StringUtils.isNotBlank((String)rootPageId)) {
                log.debug("wps v3 start send message");
                MsgSendFactory.getSender().send(rootPageId, SerializationUtils.toJsonString(AttachmentUtil.assembleParam(tempUrl, fileId)));
            }
        }
        catch (Exception e) {
            try {
                log.error("wps v3 save file error:", (Throwable)e);
                throw new KDException((Throwable)e, new ErrorCode("WPS V3 ERROR SAVE FILE", e.getMessage()), new Object[0]);
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeClose(in);
                throw throwable;
            }
        }
        FileSecurityUtil.safeClose((Closeable)in);
    }

    private static String getIdentifyParam(HttpServletRequest request) {
        String identifyParam = request.getHeader("X-User-Query");
        log.debug("wps v3 get custom param is:" + identifyParam);
        String rootPageId = "";
        if (StringUtils.isNotEmpty((String)identifyParam)) {
            String[] params;
            for (String param : params = identifyParam.split("&")) {
                String[] kv = param.split("=");
                if (kv.length != 2 || !kv[0].equals("p")) continue;
                rootPageId = kv[1];
            }
        }
        return rootPageId;
    }

    private static List<WpsUserInfo> getUserInfo(HttpServletRequest request) {
        List<WpsUserInfo> list = new ArrayList<WpsUserInfo>();
        Object[] userIds = request.getParameterValues("user_ids");
        log.debug("wps v3 get user info id is:" + Arrays.toString(userIds));
        if (null != userIds) {
            list = WpsEditHandle.getUserInfoList((String[])userIds);
        }
        return list;
    }

    private static boolean supportWpsV3Preview(String fileType) {
        for (String type : SupportPreviewTypeConstant.wpsPublicV3SupportPreview) {
            if (!type.equalsIgnoreCase(fileType)) continue;
            return true;
        }
        return false;
    }
}

