/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgradeservice;

import java.util.Arrays;
import java.util.List;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.constant.PermApiConst;
import kd.bos.permission.model.PermResult;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AttachmentLogAndWaterMarkUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(AttachmentLogAndWaterMarkUpgradeServiceImpl.class);
    private static Long[] adminEntryIds = new Long[]{PermApiConst.THREE_STRATEGY_1_ADMIN_ENTRYID};

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            StringBuilder noPermProcessInfo = new StringBuilder();
            PermResult upgradeByAppPermResult = PermissionServiceHelper.appendPermItemAuthByAppUpgrade(this.noPermItemForm(), (StringBuilder)noPermProcessInfo);
            if (upgradeByAppPermResult.isOk()) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(String.format("appendPermItemAuthByAppUpgrade info:%s", upgradeByAppPermResult));
            }
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setLog(e.getMessage());
            result.setSuccess(false);
            logger.error("AttachmentLogAndWaterMarkUpgradeService error", (Throwable)e);
            throw new KDException((Throwable)e, new ErrorCode("fail", "AttachmentLogAndWaterMarkUpgradeService error"), new Object[0]);
        }
        logger.info("AttachmentLogAndWaterMarkUpgradeService end");
        return result;
    }

    private List<Object[]> noPermItemForm() {
        String sysAppId = "18XSXYEL8//U";
        String ctsAppId = "18XR3MJ0W0ET";
        Object[] attachmentLogArr = new Object[]{new String[]{sysAppId}, "bos_attachment_oplog", "47150e89000000ac", adminEntryIds};
        Object[] watermarkArr = new Object[]{new String[]{ctsAppId}, "bos_watermark", "47150e89000000ac", adminEntryIds};
        Object[] watermarkDeleteArr = new Object[]{new String[]{ctsAppId}, "bos_watermark", "4715e1f1000000ac", adminEntryIds};
        List<Object[]> data = Arrays.asList(attachmentLogArr, watermarkArr, watermarkDeleteArr);
        return data;
    }
}

