/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileItemParser;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.bos.svc.util.print.PrintPermissionUtil;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.utils.AttachmentUtil;
import kd.bos.web.actions.utils.CtsyActionDispatchServiceHelper;
import org.apache.commons.io.IOUtils;

public class PrintAction {
    private static final String MESSAGE = "message";
    private static final String BOS_WEBACTIONS = "bos-webactions";
    private static final String ACCOUNT_ID = "accountId";
    private static final String SERVICE_ID = "serviceId";
    private static final String PRINT_SERVICE = "PrintService";
    private static final String SUCCESSFUL = "successful";
    private static final String STATUS = "status";
    private static final String ERROR = "error";
    private static final String DESCRIPTION = "description";
    private static final String BOS_MANAGEPRINTTPL = "bos_manageprinttpl";
    private static final String PROJECT_NAME = "bos-print-business";
    private static Log log = LogFactory.getLog(PrintAction.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("CachePrtRegion", new DistributeCacheHAPolicy(true, true));
    private static final String BOS_ATTACHMENT = "bos-attachment";

    public void testConfig(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public void getPrintJobs(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkModifyPermission();
        String accountId = request.getParameter(ACCOUNT_ID);
        String serviceId = request.getParameter(SERVICE_ID);
        List jobs = (List)DispatchServiceHelper.invokeBOSService((String)PRINT_SERVICE, (String)"getPrintJobs", (Object[])new Object[]{accountId, serviceId});
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString((Object)jobs));
    }

    public void updateStatus(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkModifyPermission();
        String jobId = request.getParameter("jobId");
        String status = request.getParameter(STATUS);
        log.debug("\u5f00\u59cb\u8c03\u7528\u5fae\u670d\u52a1\u6765\u66f4\u65b0\u72b6\u6001 , job ID: " + jobId);
        boolean isSuccessful = (Boolean)DispatchServiceHelper.invokeBOSService((String)PRINT_SERVICE, (String)"updateStatus", (Object[])new Object[]{jobId, status});
        log.debug("\u7ed3\u675f\u66f4\u65b0\u72b6\u6001 , \u7ed3\u679c\u4e3a: " + isSuccessful);
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("jobId", jobId);
        items.put(STATUS, status);
        items.put(SUCCESSFUL, isSuccessful);
        items.put(MESSAGE, ResManager.loadKDString((String)"\u66f4\u65b0\u72b6\u6001\u6210\u529f\u3002", (String)"PrintAction_1", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString(items));
    }

    public void updatePrintCount(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pkId = request.getParameter("id");
        String formId = request.getParameter("formid");
        String billTypeId = request.getParameter("billtypeid");
        log.debug("\u5f00\u59cb\u8c03\u7528\u5fae\u670d\u52a1\u6765\u66f4\u65b0\u6253\u5370\u6b21\u6570 , pkId: " + pkId);
        boolean successful = (Boolean)DispatchServiceHelper.invokeBOSService((String)PRINT_SERVICE, (String)"UpdatePrintCount", (Object[])new Object[]{pkId, formId, billTypeId});
        log.debug("\u7ed3\u675f\u6253\u5370\u6b21\u6570 , \u7ed3\u679c\u4e3a: " + successful);
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("pkId", pkId);
        items.put("formId", formId);
        items.put("billtypeid", billTypeId);
        items.put(SUCCESSFUL, successful);
        if (successful) {
            items.put(MESSAGE, ResManager.loadKDString((String)"\u66f4\u65b0\u6253\u5370\u6b21\u6570\u6210\u529f\u3002", (String)"PrintAction_4", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
        } else {
            items.put(MESSAGE, ResManager.loadKDString((String)"\u66f4\u65b0\u6253\u5370\u6b21\u6570\u5931\u8d25\u3002", (String)"PrintAction_5", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
        }
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString(items));
    }

    public void registerService(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkModifyPermission();
        String postStr = PrintAction.getRequestPostStr(request);
        Map mp = (Map)SerializationUtils.fromJsonString((String)postStr, Map.class);
        String accountId = (String)mp.get(ACCOUNT_ID);
        String serviceId = (String)mp.get(SERVICE_ID);
        String serviceName = (String)mp.get("serviceName");
        log.debug("\u5f00\u59cb\u6ce8\u518c\u6253\u5370\u670d\u52a1, accountId = " + accountId + ", serviceId = " + serviceId);
        String id = (String)DispatchServiceHelper.invokeBOSService((String)PRINT_SERVICE, (String)"registerService", (Object[])new Object[]{accountId, serviceId, serviceName});
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("id", id);
        items.put("success", !StringUtils.isBlank((CharSequence)id));
        log.debug("\u6ce8\u518c\u6253\u5370\u670d\u52a1\u7ed3\u675f\uff0cService ID\u4e3a\uff1a" + id);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString(items));
    }

    public void syncPrinter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkViewPermission();
        String postStr = PrintAction.getRequestPostStr(request);
        Map mp = (Map)SerializationUtils.fromJsonString((String)postStr, Map.class);
        String serviceId = (String)mp.get(SERVICE_ID);
        Map printers = (Map)SerializationUtils.fromJsonString((String)((String)mp.get("printers")), Map.class);
        log.debug("\u5f00\u59cb\u8c03\u7528\u5fae\u670d\u52a1\u6765\u540c\u6b65\u914d\u7f6e\u3002");
        boolean isSuccessful = (Boolean)DispatchServiceHelper.invokeBOSService((String)PRINT_SERVICE, (String)"syncPrinter", (Object[])new Object[]{serviceId, printers});
        HashMap<String, Object> items = new HashMap<String, Object>();
        if (isSuccessful) {
            items.put(MESSAGE, ResManager.loadKDString((String)"\u540c\u6b65\u6253\u5370\u673a\u6210\u529f\u3002", (String)"PrintAction_2", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        } else {
            items.put(MESSAGE, ResManager.loadKDString((String)"\u540c\u6b65\u6253\u5370\u673a\u5931\u8d25\u3002", (String)"PrintAction_3", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        }
        items.put(SUCCESSFUL, isSuccessful);
        log.debug("\u540c\u6b65\u6253\u5370\u673a\u7ed3\u675f\uff0c\u7ed3\u679c\u4e3a\uff1a" + isSuccessful);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString(items));
    }

    public void syncConfig(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkModifyPermission();
        String postStr = PrintAction.getRequestPostStr(request);
        Map mp = (Map)SerializationUtils.fromJsonString((String)postStr, Map.class);
        String accountId = (String)mp.get(ACCOUNT_ID);
        String serviceId = (String)mp.get(SERVICE_ID);
        Map printers = (Map)SerializationUtils.fromJsonString((String)((String)mp.get("printers")), Map.class);
        log.debug("\u5f00\u59cb\u8c03\u7528\u5fae\u670d\u52a1\u6765\u540c\u6b65\u914d\u7f6e\u3002");
        boolean isSuccessful = (Boolean)DispatchServiceHelper.invokeBOSService((String)PRINT_SERVICE, (String)"syncConfig", (Object[])new Object[]{accountId, serviceId, printers});
        HashMap<String, Object> items = new HashMap<String, Object>();
        if (isSuccessful) {
            items.put(MESSAGE, ResManager.loadKDString((String)"\u540c\u6b65\u914d\u7f6e\u6210\u529f\u3002", (String)"PrintAction_4", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        } else {
            items.put(MESSAGE, ResManager.loadKDString((String)"\u5df2\u540c\u6b65\u914d\u7f6e\u5931\u8d25\u3002", (String)"PrintAction_5", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        }
        items.put(SUCCESSFUL, isSuccessful);
        log.debug("\u540c\u6b65\u914d\u7f6e\u7ed3\u675f\uff0c\u7ed3\u679c\u4e3a\uff1a" + isSuccessful);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString(items));
    }

    private static byte[] getRequestPostBytes(HttpServletRequest request) throws IOException {
        int readlen;
        int contentLength = request.getContentLength();
        if (contentLength < 0) {
            return null;
        }
        byte[] buffer = new byte[contentLength];
        for (int i = 0; i < contentLength && (readlen = request.getInputStream().read(buffer, i, contentLength - i)) != -1; i += readlen) {
        }
        return buffer;
    }

    private static String getRequestPostStr(HttpServletRequest request) throws IOException {
        byte[] buffer = PrintAction.getRequestPostBytes(request);
        String charEncoding = request.getCharacterEncoding();
        if (charEncoding == null) {
            charEncoding = "UTF-8";
        }
        return new String(buffer, charEncoding);
    }

    @Deprecated
    public void open(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    @Deprecated
    public static void downLoadByUrl(String urlStr, String fileName, String savePath) throws IOException {
    }

    @Deprecated
    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    public void getDomainModel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkViewPermission();
        String appId = request.getParameter("appId");
        appId = appId == null ? "bos" : appId;
        String bizType = request.getParameter("bizType");
        String formModel = StringUtils.isNotBlank((CharSequence)bizType) ? (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"BosPrintBusinessService", (String)"getDomainModel", (Object[])new Object[]{bizType}) : (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"BosPrintBusinessService", (String)"getDomainModel", (Object[])new Object[0]);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)formModel);
    }

    public void upload(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkModifyPermission();
        List<String> supportFormat = Arrays.asList(".jpg", ".JPG", ".png", ".PNG", ".jpeg", ".JPEG", ".bmp", ".BMP");
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String printtplid = request.getParameter("printtplid");
            printtplid = printtplid.replaceAll(" ", "\\+");
            FileItem fileItem = FileItemParser.parseHttpRequest((HttpServletRequest)request);
            String fileName = fileItem.getFileName();
            String fileSuffix = fileName.substring(fileName.lastIndexOf("."));
            if (supportFormat.contains(fileSuffix)) {
                String appId = request.getParameter("appId");
                appId = appId == null ? "bos" : appId;
                String FMT_IMAGE = "/%s/%s/%s/%s/%s/%s";
                String tenantId = RequestContext.get().getTenantId();
                String accountId = RequestContext.get().getAccountId();
                String userId = RequestContext.get().getUserId();
                String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
                String path = String.format(FMT_IMAGE, tenantId, accountId, "printtpl", this.getDateStr(), userId, UUID.randomUUID() + "." + suffix);
                FileItemExt fileItemExt = new FileItemExt(fileItem.getFileName(), path, fileItem.getInputStream());
                fileItemExt.setCreateNewFileWhenExists(true);
                fileItemExt.setSource(FileSource.PRINT_TPL_RESOURCE);
                String url = FileServiceFactory.getImageFileService().upload((FileItem)fileItemExt);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("url", url);
                param.put("printtplid", printtplid);
                param.put("fileName", fileName);
                long rcId = (Long)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"BosPrintBusinessService", (String)"saveFile", (Object[])new Object[]{param});
                PrintPermissionUtil.setMetaRcPermission(Collections.singletonList(String.valueOf(rcId)));
                result.put("rcId", String.valueOf(rcId));
                result.put("fileName", fileName);
                result.put(STATUS, "1");
            } else {
                result.put(STATUS, "0");
                result.put(MESSAGE, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4e0a\u4f20.jpg,.jpeg,.png,.bmp\u7c7b\u578b\u7684\u56fe\u7247\u3002", (String)"PrintAction_6", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            result.put(STATUS, "0");
            result.put(MESSAGE, e.getMessage());
        }
        String jsonResult = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
    }

    private String getDateStr() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMM");
        return sf.format(cale.getTime());
    }

    public void download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block6: {
            String rcId = request.getParameter("rcId");
            String attachId = request.getParameter("attachId");
            String taskId = request.getParameter("taskId");
            String seq = request.getParameter("seq");
            try {
                if (CtsyActionDispatchServiceHelper.isCtsyRequest(request)) {
                    CtsyActionDispatchServiceHelper.redirectHttpAction(request, response);
                    return;
                }
                if (StringUtils.isNotEmpty((CharSequence)rcId)) {
                    this.downloadRc(request, response);
                    break block6;
                }
                if (StringUtils.isNotEmpty((CharSequence)attachId) && StringUtils.isNotEmpty((CharSequence)taskId)) {
                    this.downloadAttach(request, response);
                    break block6;
                }
                if (StringUtils.isNotEmpty((CharSequence)attachId) && StringUtils.isEmpty((CharSequence)taskId)) {
                    this.downloadSingleImage(request, response);
                    break block6;
                }
                this.writeErrorMessage(response, "param is illegal, please check.");
                return;
            }
            catch (Exception e) {
                this.writeErrorMessage(response, e.getMessage());
                log.error((Throwable)e);
                return;
            }
        }
    }

    private void downloadSingleImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String attachId = request.getParameter("attachId");
        Tuple tuple = PrtTaskResultServiceHelper.loopGetPrtResult((String)attachId, (long)5000L);
        PrtTaskResult prtResult = (PrtTaskResult)tuple.item1;
        PrtTaskResult.Attach attach = (PrtTaskResult.Attach)tuple.item2;
        if (prtResult == null || attach == null) {
            throw new KDException(new ErrorCode("File Not Exist", ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrintAction_2", (String)BOS_ATTACHMENT, (Object[])new Object[0])), new Object[0]);
        }
        boolean isMobile = StringUtils.equals((CharSequence)request.getParameter("isMobile"), (CharSequence)"true");
        boolean hasPermission = PrintPermissionUtil.checkPermission((boolean)isMobile, (PrtTaskResult)prtResult);
        if (!hasPermission) {
            log.debug("PrtTaskResult:" + SerializationUtils.toJsonString((Object)prtResult));
            throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"AttachmentAction_11", (String)BOS_WEBACTIONS, (Object[])new Object[0])), new Object[0]);
        }
        String filePath = attach.getFilePath();
        String fileName = attach.getFileName();
        this.setDownloadResponseHeader(response, fileName, false);
        this.getAttachmentFromTempFileCache(response, filePath);
    }

    private void downloadAttach(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String taskId = request.getParameter("taskId");
        String attachId = request.getParameter("attachId");
        String tempAttach = request.getParameter("tempAttach");
        boolean isMobile = StringUtils.equals((CharSequence)request.getParameter("isMobile"), (CharSequence)"true");
        PrtTaskResult prtResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId, (boolean)StringUtils.equals((CharSequence)tempAttach, (CharSequence)"true"));
        if (prtResult == null) {
            throw new KDException(new ErrorCode("File Not Exist", ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrintAction_2", (String)BOS_ATTACHMENT, (Object[])new Object[0])), new Object[0]);
        }
        boolean hasPermission = PrintPermissionUtil.checkPermission((boolean)isMobile, (PrtTaskResult)prtResult);
        if (!hasPermission) {
            log.debug("PrtTaskResult:" + SerializationUtils.toJsonString((Object)prtResult));
            throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"AttachmentAction_11", (String)BOS_WEBACTIONS, (Object[])new Object[0])), new Object[0]);
        }
        List attachList = prtResult.getAttach();
        PrtTaskResult.Attach attach = null;
        for (PrtTaskResult.Attach att : attachList) {
            if (!StringUtils.equals((CharSequence)attachId, (CharSequence)att.getAttachId())) continue;
            attach = att;
            break;
        }
        if (attach == null) {
            throw new KDException(new ErrorCode("File Not Exist", ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrintAction_2", (String)BOS_ATTACHMENT, (Object[])new Object[0])), new Object[0]);
        }
        String filePath = attach.getFilePath();
        String fileName = attach.getFileName();
        String forceDownload = request.getParameter("downloadAttach");
        this.setDownloadResponseHeader(response, fileName, "true".equals(forceDownload));
        if ("2".equals(prtResult.getDiskType())) {
            this.getAttachmentFromTempFileCache(response, filePath);
        } else {
            FileServiceFactory.getAttachmentFileService().download(filePath, response, request.getHeader("USER-AGENT"));
        }
    }

    private void getAttachmentFromTempFileCache(HttpServletResponse response, String filePath) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        try (InputStream inputStream = PrintFileUtil.getFileInputStream((String)filePath, (String)"2");){
            if (inputStream == null) {
                throw new KDBizException("Temp File Is Expired or Not Exist.");
            }
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream, (int)2048);
            response.setStatus(200);
        }
    }

    private void setDownloadResponseHeader(HttpServletResponse response, String fileName, boolean forceDownload) throws UnsupportedEncodingException {
        response.setCharacterEncoding("UTF-8");
        String contentType = AttachmentUtil.getFileContentType(fileName);
        if (forceDownload) {
            contentType = "application/octet-stream";
        }
        response.setContentType(contentType);
        response.setDateHeader("Expires", System.currentTimeMillis() + 259200000L);
        String encodeFileName = URLEncoder.encode(fileName, "UTF-8");
        encodeFileName = String.valueOf(encodeFileName).replaceAll("\\+", "%20");
        String contentValue = String.format("inline; filename=\"%s\";filename*=utf-8''%s", encodeFileName, encodeFileName);
        response.setHeader("Content-Disposition", contentValue);
    }

    private void downloadRc(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isImage;
        String rcId;
        long IMAGE_CACHE_MILLSECONDS = 259200000L;
        long FONT_CACHE_SECONDS = 31536000L;
        String appId = request.getParameter("appId");
        appId = appId == null ? "bos" : appId;
        Map rcInfo = (Map)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"BosPrintBusinessService", (String)"getFileInfo", (Object[])new Object[]{Long.parseLong(rcId = request.getParameter("rcId"))});
        if (rcInfo == null || rcInfo.isEmpty()) {
            this.writeErrorMessage(response, ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"PrintAction_1", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
            return;
        }
        String path = (String)rcInfo.get("url");
        String fileName = (String)rcInfo.get("fileName");
        String userAgent = request.getHeader("USER-AGENT");
        response.setCharacterEncoding("UTF-8");
        String contentType = AttachmentUtil.getFileContentType(fileName);
        response.setContentType(contentType);
        if ("application/octet-stream".equals(contentType)) {
            String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
            if (!StringUtils.equalsIgnoreCase((CharSequence)"ttf", (CharSequence)ext) && !StringUtils.equalsIgnoreCase((CharSequence)"ttc", (CharSequence)ext)) {
                throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"AttachmentAction_11", (String)BOS_WEBACTIONS, (Object[])new Object[0])), new Object[0]);
            }
            String STRING = "attachment;filename*=UTF-8''";
            response.addHeader("Content-Disposition", STRING + URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20"));
            response.setDateHeader("Expires", System.currentTimeMillis() + FONT_CACHE_SECONDS * 1000L);
            response.setHeader("Cache-Control", "max-age=" + FONT_CACHE_SECONDS);
            isImage = false;
        } else {
            boolean hasPermission;
            Object powerscope = rcInfo.get("powerscope");
            if (!"1".equals(powerscope) && !(hasPermission = PrintPermissionUtil.checkMetaRcPermission((String)rcId))) {
                throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"AttachmentAction_11", (String)BOS_WEBACTIONS, (Object[])new Object[0])), new Object[0]);
            }
            isImage = true;
            response.setDateHeader("Expires", System.currentTimeMillis() + IMAGE_CACHE_MILLSECONDS);
        }
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = path.replace("..", "");
            if (isImage) {
                FileServiceFactory.getImageFileService().download(path, response, userAgent);
            } else {
                FileServiceFactory.getAttachmentFileService().download(path, response, userAgent);
            }
        } else {
            byte[] bytes = (byte[])rcInfo.get("data");
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(bytes);
        }
    }

    @Deprecated
    public void deleteFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u8bbf\u95ee\u6253\u5370\u6a21\u677f", (String)"PrintAction_3", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
    }

    private void writeErrorMessage(HttpServletResponse response, String errorMessage) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(STATUS, ERROR);
        result.put(DESCRIPTION, errorMessage);
        String jsonResult = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
    }

    public void validatePrintFormula(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkViewPermission();
        String appId = request.getParameter("appId");
        appId = appId == null ? "bos" : appId;
        ServletInputStream is = request.getInputStream();
        int nRead = 1;
        int nTotalRead = 0;
        byte[] bytes = new byte[10240];
        while (nRead > 0) {
            nRead = is.read(bytes, nTotalRead, bytes.length - nTotalRead);
            if (nRead <= 0) continue;
            nTotalRead += nRead;
        }
        String requestParamString = new String(bytes, 0, nTotalRead, "utf-8");
        Map requestParam = (Map)SerializationUtils.fromJsonString((String)requestParamString, Map.class);
        String cellType = (String)requestParam.get("cellType");
        String dataSource = "Detail".equals(cellType) ? (String)requestParam.get("dataSource") : null;
        String tplVersion = (String)requestParam.get("tplVersion");
        List formulaData = (List)requestParam.get("formulaData");
        if (!formulaData.isEmpty()) {
            Map result = (Map)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"BosPrintBusinessService", (String)"validatePrintFormula", (Object[])new Object[]{formulaData, dataSource, tplVersion});
            String jsonResult = SerializationUtils.toJsonString((Object)result);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
        } else {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"do not enter the content.");
        }
    }

    private static boolean checkPermission(String permissionItemId) {
        String limit = SystemPropertyUtils.getProptyByTenant((String)"print.limit", (String)RequestContext.get().getTenantId());
        if (limit != null && "true".equals(limit)) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            int flag = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)0L, (String)BOS_MANAGEPRINTTPL, (String)permissionItemId);
            boolean isHasPermission = flag == 1;
            return isHasPermission;
        }
        return true;
    }

    private void checkModifyPermission() {
        boolean isHasPermisson = PrintAction.checkPermission("4715a0df000000ac");
        if (!isHasPermisson) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u8bbf\u95ee\u6253\u5370\u6a21\u677f", (String)"PrintAction_3", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
        }
    }

    private void checkViewPermission() {
        boolean isHasPermisson = PrintAction.checkPermission("47150e89000000ac");
        if (!isHasPermisson) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u8bbf\u95ee\u6253\u5370\u6a21\u677f", (String)"PrintAction_3", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
        }
    }
}

