/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.list.CtsyListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctsy.CtsyApiDispatchServiceImpl;
import kd.bos.servicehelper.ctsy.CtsyApiDispatchServiceHelper;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class CtsyActionDispatchServiceHelper {
    private static Log log = LogFactory.getLog(CtsyActionDispatchServiceHelper.class);

    public static void redirectHttpAction(HttpServletRequest request, HttpServletResponse response) throws Exception {
        CtsyActionDispatchServiceHelper.redirectHttpAction(request, response, null);
    }

    public static void redirectHttpAction(HttpServletRequest request, HttpServletResponse response, String requestURI) throws Exception {
        Header[] allHeaders;
        String accountId;
        CloseableHttpClient client = HttpClients.createDefault();
        String method = request.getMethod();
        Object httpUrl = "Post".equalsIgnoreCase(method) ? new HttpPost() : new HttpGet();
        String ctsynonce = request.getParameter("ctsynonce");
        if (StringUtils.isBlank((CharSequence)ctsynonce)) {
            response.setStatus(400);
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)"illegal param.");
            return;
        }
        String ctsynonceVal = CtsyListShowParameter.getCtsynonceVal((String)ctsynonce);
        if (StringUtils.isBlank((CharSequence)ctsynonceVal) || ctsynonceVal.indexOf(",") == -1) {
            response.setStatus(400);
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)"illegal param,ctsynonce is not useable.");
            return;
        }
        String[] tenantArray = ctsynonceVal.split(",");
        String tenantCode = tenantArray[0];
        String urlPrefix = CtsyApiDispatchServiceHelper.getUrl((String)tenantCode, (String)(accountId = tenantArray[1]));
        if (StringUtils.isBlank((CharSequence)urlPrefix)) {
            response.setStatus(400);
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)"getTenantUrl error.");
            return;
        }
        if (urlPrefix.endsWith("/")) {
            urlPrefix = urlPrefix.substring(0, urlPrefix.length() - 1);
        }
        if (requestURI == null) {
            requestURI = request.getRequestURI();
            String contextPath = request.getContextPath();
            requestURI = requestURI.substring(contextPath.length());
        }
        if (!requestURI.startsWith("/")) {
            requestURI = "/" + requestURI;
        }
        String requestUrl = urlPrefix + requestURI;
        URIBuilder uriBuilder = new URIBuilder(requestUrl);
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] values;
            for (String param : values = (String[])entry.getValue()) {
                if ("ctsynonce".equals(entry.getKey()) || "kdcdc".equals(entry.getKey())) continue;
                uriBuilder.addParameter((String)entry.getKey(), param);
            }
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerkey = (String)headerNames.nextElement();
            if ("Cookie".equals(headerkey) || "Content-Length".equals(headerkey) || "Transfer-Encoding".equals(headerkey)) continue;
            httpUrl.addHeader(headerkey, request.getHeader(headerkey));
        }
        httpUrl.setURI(new URI(request.getRequestURI()));
        String accessToken = CtsyActionDispatchServiceHelper.getAccessToken(tenantCode, accountId);
        httpUrl.addHeader("accessToken", accessToken);
        uriBuilder.addParameter("access_token", accessToken);
        uriBuilder.addParameter("kdcdc", accountId);
        httpUrl.addHeader("ctsy_request", "true");
        httpUrl.setURI(uriBuilder.build());
        if (httpUrl instanceof HttpPost) {
            HttpPost httpPost = httpUrl;
            InputStreamEntity inputStreamEntity = new InputStreamEntity((InputStream)request.getInputStream());
            httpPost.setEntity((HttpEntity)inputStreamEntity);
        }
        HttpResponse httpResponse = client.execute((HttpUriRequest)httpUrl);
        for (Header header : allHeaders = httpResponse.getAllHeaders()) {
            response.setHeader(header.getName(), header.getValue());
        }
        Header contentTypeHeader = httpResponse.getEntity().getContentType();
        String value = contentTypeHeader.getValue();
        String name = contentTypeHeader.getName();
        response.setHeader(name, value);
        response.setStatus(httpResponse.getStatusLine().getStatusCode());
        InputStream content = httpResponse.getEntity().getContent();
        ServletOutputStream outputStream = response.getOutputStream();
        IOUtils.copy((InputStream)content, (OutputStream)outputStream, (int)2048);
    }

    public static boolean isCtsyRequest(HttpServletRequest request) {
        String ctsynonce = request.getParameter("ctsynonce");
        if (StringUtils.isBlank((CharSequence)ctsynonce)) {
            return false;
        }
        String ctsynonceVal = CtsyListShowParameter.getCtsynonceVal((String)ctsynonce);
        return !StringUtils.isBlank((CharSequence)ctsynonceVal);
    }

    private static String getAccessToken(String tenantCode, String accountId) {
        CtsyApiDispatchServiceImpl dispatchService = new CtsyApiDispatchServiceImpl();
        return dispatchService.getAccessToken(tenantCode, accountId);
    }
}

