/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions.utils;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.web.DispatchServiceHelper;
import org.apache.commons.lang3.time.DateFormatUtils;

public class FileReqLimitUtil {
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("FileReqLimitUtil", new DistributeCacheHAPolicy(true, true));
    private static Log log = LogFactory.getLog(FileReqLimitUtil.class);
    private static final String LIMIT_COUNT_ALLKEY = "limit:count:allkey:";
    private static final String ERROR = "error";
    private static final String BOS_ATTACHMENT = "bos-attachment";
    private static final String STATUS = "status";
    private static final String DESCRIPTION = "description";

    public static boolean checkLimitReq(String checkKey, int fileSize) {
        if ("download".equals(checkKey)) {
            return FileReqLimitUtil.checkReqCountLimit(checkKey);
        }
        return "uploadFile".equals(checkKey) && FileReqLimitUtil.checkReqCountLimit(checkKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkTotalFileSize(HttpServletResponse response, String checkKey, long fileSize, long defaultLimitSize, String fileName, boolean fromAttachment) throws IOException {
        String key;
        Long userId = RequestContext.get().getCurrUserId();
        long limitSize = Long.parseLong(System.getProperty("filesize.minute.limit", String.valueOf(defaultLimitSize)));
        String time = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmm");
        String string = key = "limit:size:" + RequestContext.get().getTenantId() + ":" + checkKey + ":" + userId + ":" + time;
        synchronized (string) {
            log.info("\u547d\u4e2dkey : " + key + " \uff0c checkLimitReq-------\u5f53\u524d\u6587\u4ef6\u5927\u5c0f\u4e3a : " + fileSize + " ,\u603b\u5bb9\u91cf \uff1a " + limitSize);
            if (redisCache.contains(key)) {
                fileSize += Long.parseLong((String)redisCache.get(key));
            }
            redisCache.put(key, (Object)String.valueOf(fileSize), 60);
            log.info("checkLimitReq-------\u6b64\u65f6\u95f4 ( " + time + " ) \u5269\u4f59\u4e0a\u4f20\u5bb9\u91cf\u4e3a : " + (limitSize - fileSize));
            if (fileSize > limitSize && fromAttachment) {
                FileReqLimitUtil.writeOverMaxSize(response, fileSize, limitSize);
                return false;
            }
            if (fileSize > limitSize && !fromAttachment) {
                FileReqLimitUtil.writeOverMaxSize(response, fileName, fileSize, limitSize);
                return false;
            }
            return true;
        }
    }

    public static void writeOverMaxSize(HttpServletResponse response, long size, long maxSize) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        BigDecimal sizeMB = new BigDecimal(size).divide(new BigDecimal(0x100000), 2, 5);
        BigDecimal maxSizeMB = new BigDecimal(maxSize).divide(new BigDecimal(0x100000), 5);
        String msg = String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u5927\u5c0f\uff08%1$sMB\uff09\u8d85\u8fc7\u6700\u5927\u503c\uff08%2$sMB\uff09\u9650\u5236\uff0c\u53ef\u524d\u5f80\u516c\u5171\u8bbe\u7f6e-\u7cfb\u7edf\u53c2\u6570-\u9644\u4ef6\u56fe\u7247\u53c2\u6570-\u9644\u4ef6\u4e0a\u4f20\u9650\u5236-\u9644\u4ef6\u4e0a\u4f20\u5927\u5c0f\u9650\u5236\u6216MC\u53c2\u6570\u4fee\u6539\u8bbe\u7f6e\u503c\u3002", (String)"AttachmentAction_5", (String)BOS_ATTACHMENT, (Object[])new Object[0]), sizeMB, maxSizeMB);
        result.put(STATUS, ERROR);
        result.put(DESCRIPTION, msg);
        String jsonResult = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
    }

    public static void writeOverMaxSize(HttpServletResponse response, String fileName, long size, long maxSize) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        double sizeMb = (double)size / 1024.0 / 1024.0;
        double maxSizeMb = (double)maxSize / 1024.0 / 1024.0;
        String msg = String.format(ResManager.loadKDString((String)"%1$s\u5927\u5c0f(%2$sM)\u8d85\u8fc7\u6700\u5927\u503c(%3$sM)\u9650\u5236\uff0c\u53ef\u524d\u5f80\u516c\u5171\u8bbe\u7f6e-\u7cfb\u7edf\u53c2\u6570-\u9644\u4ef6\u56fe\u7247\u53c2\u6570-\u56fe\u7247\u9650\u5236-\u56fe\u7247\u4e0a\u4f20\u5927\u5c0f\u9650\u5236\u3001 MC\u53c2\u6570\u3001\u8bbe\u8ba1\u5668\u4e2d\u56fe\u7247\u5b57\u6bb5\u7684\u6700\u5927\u56fe\u7247\u5927\u5c0f\u6216\u4e0a\u4f20\u63a7\u4ef6\u7684\u4e0a\u4f20\u914d\u7f6e\u4fee\u6539\u8bbe\u7f6e\u503c\u3002", (String)"AttachmentAction_7", (String)BOS_ATTACHMENT, (Object[])new Object[0]), fileName, new BigDecimal(Double.toString(sizeMb)).setScale(2, RoundingMode.HALF_UP), new BigDecimal(Double.toString(maxSizeMb)).setScale(2, RoundingMode.HALF_UP));
        result.put(STATUS, ERROR);
        result.put(DESCRIPTION, msg);
        String jsonResult = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkReqCountLimit(String checkKey) {
        String refKeys;
        String fieldKey;
        String keyExt = ":" + RequestContext.get().getTenantId() + ":" + RequestContext.get().getAccountId() + ":";
        if ("uploadFile".equals(checkKey)) {
            fieldKey = "uploadlimitcontent";
        } else if ("download".equals(checkKey)) {
            fieldKey = "downloadlimitcontent";
        } else {
            return false;
        }
        Object setStr = DispatchServiceHelper.invokeBOSService((String)"SystemParamService", (String)"loadPublicParameterFromCache", (Object[])new Object[]{fieldKey});
        String string = refKeys = LIMIT_COUNT_ALLKEY + fieldKey + keyExt;
        synchronized (string) {
            String fieldRedisKey = fieldKey + keyExt;
            String oldSetStr = (String)redisCache.get(fieldRedisKey);
            if (oldSetStr == null || !oldSetStr.equals(setStr)) {
                String redisKeyList = (String)redisCache.get(refKeys);
                List keyList = redisKeyList == null ? new ArrayList() : SerializationUtils.fromJsonStringToList((String)redisKeyList, String.class);
                String[] needDelKeys = new String[keyList.size()];
                keyList.toArray(needDelKeys);
                if (needDelKeys.length > 0) {
                    redisCache.remove(needDelKeys);
                }
                redisCache.remove(refKeys);
                redisCache.put(fieldRedisKey, (Object)String.valueOf(setStr));
            }
        }
        Map setting = new HashMap();
        if (StringUtils.isNotBlank((Object)setStr)) {
            setting = (Map)SerializationUtils.fromJsonString((String)setStr.toString(), Map.class);
        }
        Long userId = RequestContext.get().getCurrUserId();
        for (Map.Entry entry : setting.entrySet()) {
            String key;
            int timeoutSecond;
            String data;
            if ("secondlimit".equals(entry.getKey())) {
                data = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
                timeoutSecond = 1;
            } else if ("minutelimit".equals(entry.getKey())) {
                data = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmm");
                timeoutSecond = 60;
            } else if ("hourlimit".equals(entry.getKey())) {
                data = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHH");
                timeoutSecond = 3600;
            } else if ("daylimit".equals(entry.getKey())) {
                timeoutSecond = 86400;
                data = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            } else {
                return false;
            }
            Long limitCount = 0L;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) {
                limitCount = Long.parseLong((String)entry.getValue());
            }
            if (limitCount == 0L) continue;
            log.info("checkReqCountLimit-------limitCount\u6b21\u6570\u4e3a : " + limitCount);
            String string2 = key = "limit:count" + keyExt + checkKey + ":" + userId + ":" + data + ":";
            synchronized (string2) {
                if (redisCache.contains(key)) {
                    long time = redisCache.decr(key);
                    log.info("\u547d\u4e2dkey : " + key + " \uff0c userId : " + userId + ", " + data + "\u5185\u5269\u4f59\u8bf7\u6c42\u6b21\u6570\u4e3a  " + time);
                    if (time < 0L) {
                        log.info("userId : " + userId + ", " + data + "\u5185\u5269\u4f59\u8bf7\u6c42\u6b21\u6570\u5c0f\u4e8e0\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                        return true;
                    }
                } else {
                    redisCache.put(key, (Object)String.valueOf(limitCount - 1L), timeoutSecond);
                    String redisKeyList = (String)redisCache.get(refKeys);
                    List<String> keyList = redisKeyList == null ? new ArrayList() : SerializationUtils.fromJsonStringToList((String)redisKeyList, String.class);
                    keyList.add(key);
                    redisCache.put(refKeys, (Object)SerializationUtils.toJsonString(keyList));
                    log.info("userId : " + userId + ", \u7b2c\u4e00\u6b21\u8bf7\u6c42\uff0c" + data + "\u5185\u5269\u4f59\u8bf7\u6c42\u6b21\u6570\u4e3a  " + (String)redisCache.get(key));
                }
            }
        }
        return false;
    }
}

