/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.export.util;

import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.BillParam;
import kd.bos.form.IPageCache;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ExportListUtil {
    private static final String TWO_PLACEHOLDER = "%s_%s";
    private static Log log = LogFactory.getLog(ExportListUtil.class);

    public static final int getListCacheBillCount(BillList billList, IPageCache pageCache) {
        String listDataCountPrefix = String.format(TWO_PLACEHOLDER, billList.getKey(), "bdc");
        String listDataCount = pageCache.get(listDataCountPrefix);
        if (StringUtils.isNumeric((CharSequence)listDataCount)) {
            return Integer.parseInt(listDataCount);
        }
        return 0;
    }

    public static int getBillDataCount(BillList billList, IPageCache pageCache, String entityNumber) {
        int listDataCount = ExportListUtil.getListCacheBillCount(billList, pageCache);
        int sysParamListMaxLimit = ExportListUtil.getSysParamListMaxLimit(entityNumber);
        String lineCountCountPrefix = String.format(TWO_PLACEHOLDER, billList.getKey(), "dc");
        String lineCount = pageCache.get(lineCountCountPrefix);
        boolean isCacheUseable = StringUtils.isNumeric((CharSequence)lineCount) && Integer.parseInt(lineCount) != 0 && Integer.parseInt(lineCount) < sysParamListMaxLimit && listDataCount > 0;
        log.debug("[\u5217\u8868\u5bfc\u51fa\uff1a\u7f13\u5b58\u4e2d\u83b7\u53d6\u7684\u5355\u636e\u6570\uff1a]" + listDataCount + "\u7f13\u5b58\u4e2d\u83b7\u53d6\u7684\u5355\u636e\u884c\u6570\uff1a" + lineCount);
        int billDataCount = isCacheUseable ? listDataCount : billList.queryBillDataCount();
        return billDataCount;
    }

    public static int getBillDataLineCount(BillList billList, IPageCache pageCache, String entityNumber) {
        int sysParamListMaxLimit = ExportListUtil.getSysParamListMaxLimit(entityNumber);
        String lineCountCountPrefix = String.format(TWO_PLACEHOLDER, billList.getKey(), "dc");
        String lineCount = pageCache.get(lineCountCountPrefix);
        boolean isCacheUseable = StringUtils.isNumeric((CharSequence)lineCount) && Integer.parseInt(lineCount) != 0 && Integer.parseInt(lineCount) < sysParamListMaxLimit;
        log.debug("[\u5217\u8868\u5bfc\u51fa\uff1a\u7f13\u5b58\u4e2d\u83b7\u53d6\u7684\u5355\u636e\u603b\u884c\u6570\uff1a]" + lineCount + "\u7f13\u5b58\u4e2d\u83b7\u53d6\u7684\u5355\u636e\u6570\uff1a" + lineCount + " \u8be5\u5b9e\u4f53\u5355\u636e\u53c2\u6570\u5c55\u793a\u503c\u4e3a" + sysParamListMaxLimit);
        return isCacheUseable ? Integer.parseInt(lineCount) : 0;
    }

    public static int getSysParamListMaxLimit(String entityNumber) {
        BillParam billParam = ParameterHelper.getBillParam((String)entityNumber);
        if (billParam == null || billParam.getOverallParam() == null) {
            return 100000;
        }
        int maxReturnData = billParam.getOverallParam().getMaxReturnData();
        if (maxReturnData > 100000) {
            maxReturnData = 100000;
        }
        return maxReturnData;
    }
}

