/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.exportentry;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.dto.ExportEntryByTemplateForSort;
import kd.bos.form.dto.ExportEntryProcess;
import kd.bos.form.dto.ExportEntryTemplateResult;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.util.ExportEntryUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.service.metadata.export.ExportWriterFormat;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportEntryTemplateThread
implements Callable<ExportEntryTemplateResult> {
    private static final Log log = LogFactory.getLog(ExportEntryTemplateThread.class);
    public static final String DATAINDEX = "dataindex";
    public static final String EXPORT_PROCESS = "export_process_";
    private static final int MAX_CELLCONTENT_LENGTH = Short.MAX_VALUE;
    private CountDownLatch countDownLatch;
    private SXSSFWorkbook workbook;
    private EntryGrid entryGrid;
    private IPageCache pageCache;
    private ExportWriterFormat writerFormat;
    private SXSSFSheet sheet;
    private boolean isSplitEntry;
    private int total;
    private NumberFormatProvider numberFormatProvider = null;
    private ReferenceInteger subEntryEntityRowCount = new ReferenceInteger(0);
    private Map<String, List<ExportEntryByTemplateForSort>> templateFieldSortMap = new HashMap<String, List<ExportEntryByTemplateForSort>>();
    private int entryIndex;
    private int process;
    private ExportSheetStyle styles;
    private static final String BOS_IMPORT = "bos-import";
    private static final String BOS_EXPORT = "bos-export";

    public ExportEntryTemplateThread(RequestContext requestContext, CountDownLatch countDownLatch, SXSSFWorkbook workbook, EntryGrid entryGrid, IPageCache pageCache, ExportWriterFormat writerFormat, SXSSFSheet sheet, boolean isSplitEntry, int total, int entryIndex) {
        RequestContext.copyAndSet((RequestContext)requestContext);
        this.countDownLatch = countDownLatch;
        this.workbook = workbook;
        this.entryGrid = entryGrid;
        this.pageCache = pageCache;
        this.writerFormat = writerFormat;
        this.sheet = sheet;
        this.isSplitEntry = isSplitEntry;
        this.total = total;
        this.styles = new ExportSheetStyle(workbook);
        this.entryIndex = entryIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExportEntryTemplateResult doExport() {
        if (this.total >= 0x100000 || this.subEntryEntityRowCount.getValue() >= 0x100000) {
            String tooLargeErrMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faExcel\u6587\u4ef6\u6700\u5927\u884c\u6570%s\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ExportDataTask_3", (String)BOS_EXPORT, (Object[])new Object[0]), 0x100000);
            return new ExportEntryTemplateResult(this.entryGrid.getEntryKey(), tooLargeErrMsg);
        }
        try {
            List<ExportEntryByTemplateForSort> templateFieldSort = this.reSortToTemplate(this.entryGrid, this.writerFormat);
            ExportEntryTemplateResult templateFieldResult = this.isTemplateFieldInEntry(templateFieldSort);
            if (templateFieldResult != null) {
                ExportEntryTemplateResult exportEntryTemplateResult = templateFieldResult;
                return exportEntryTemplateResult;
            }
            this.exportEntry2Excel(this.entryGrid, templateFieldSort, this.writerFormat, this.total, 4);
            this.pageCache.put(EXPORT_PROCESS + this.entryIndex, SerializationUtils.toJsonString((Object)new ExportEntryProcess(this.total, this.total)));
        }
        catch (Exception e) {
            String detailMsg = "";
            try {
                detailMsg = Arrays.stream(e.getStackTrace()).map(item -> item.toString()).collect(Collectors.joining());
            }
            catch (Exception ex) {
                log.error(String.format(ResManager.loadKDString((String)"[\u6309\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u9519\u8bef\uff1a\u62a5\u9519\u5806\u6808\u65e0\u6cd5\u8f6c\u6362]%s", (String)"BOS_IMPORT_22", (String)BOS_IMPORT, (Object[])new Object[0]), ex));
            }
            log.error(String.format(ResManager.loadKDString((String)"[\u6309\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u9519\u8bef\uff1a\u5f53\u524d\u7ebf\u7a0b\uff1a]%1$s\uff0c\u9519\u8bef\u5806\u6808\uff1a%2$s", (String)"BOS_EXPORT_8", (String)BOS_EXPORT, (Object[])new Object[0]), Thread.currentThread().getName(), detailMsg));
            ExportEntryTemplateResult exportEntryTemplateResult = new ExportEntryTemplateResult(this.entryGrid.getEntryKey(), e.toString());
            return exportEntryTemplateResult;
        }
        finally {
            this.countDownLatch.countDown();
        }
        return new ExportEntryTemplateResult(true, this.entryGrid.getEntryKey(), this.total, this.isSplitEntry);
    }

    private int exportEntry2Excel(EntryGrid entryGrid, List<ExportEntryByTemplateForSort> templateFieldSort, ExportWriterFormat writerFormat, int total, int currentRowIndex) {
        boolean hasSelectedRows;
        boolean bl = hasSelectedRows = entryGrid.getSelectRows().length > 0;
        if (hasSelectedRows) {
            return this.exportEntryHasSelected(entryGrid, templateFieldSort, writerFormat, currentRowIndex);
        }
        return this.exportEntryNotSelected(entryGrid, templateFieldSort, writerFormat, total, currentRowIndex);
    }

    private ExportEntryTemplateResult isTemplateFieldInEntry(List<ExportEntryByTemplateForSort> templateFieldSort) {
        if (templateFieldSort == null) {
            String unKnownError = String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5355\u636e\u4f53%1%s\u5931\u8d25\uff0c\u8bf7\u6392\u67e5\u5f53\u524d\u5206\u5f55\u5143\u6570\u636e\u662f\u5426\u6b63\u5e38", (String)"ExportEntryTemplateThread_1", (String)BOS_EXPORT, (Object[])new Object[0]), this.writerFormat.displayName);
            return new ExportEntryTemplateResult(this.entryGrid.getEntryKey(), unKnownError);
        }
        if (templateFieldSort.isEmpty()) {
            String notHasTemplateFieldToExport = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53%1%s\u4e0d\u5b58\u5728\u6a21\u677f\u6240\u9700\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5b58\u5728\u8868\u5355\u63d2\u4ef6\u52a8\u6001\u9690\u85cf\u5355\u636e\u4f53\u5217", (String)"ExportEntryTemplateThread_2", (String)BOS_EXPORT, (Object[])new Object[0]), this.writerFormat.displayName);
            return new ExportEntryTemplateResult(this.entryGrid.getEntryKey(), notHasTemplateFieldToExport);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exportEntryNotSelected(EntryGrid entryGrid, List<ExportEntryByTemplateForSort> templateFieldSort, ExportWriterFormat writerFormat, int total, int currentRowIndex) {
        int pageRows = this.isSplitEntry ? entryGrid.getModel().getEntryPageSize() : 50000;
        int startIndex = 0;
        int endIndex = pageRows;
        int batchCount = total / pageRows + (total % pageRows == 0 ? 0 : 1);
        String entryKey = entryGrid.getEntryKey();
        IFormView view = entryGrid.getView();
        if (batchCount == 1) {
            endIndex = total;
        }
        for (int i = 0; i < batchCount; ++i) {
            EntryData entryData = null;
            if (this.isSplitEntry && !(entryGrid instanceof SubEntryGrid)) {
                DynamicObjectCollection coll = entryGrid.getModel().getEntryEntity(entryGrid.getEntryKey());
                coll.fetchEntryRows(startIndex, entryGrid.getModel().getEntryPageSize());
                ArrayList<List> rows = new ArrayList<List>(10);
                for (int j = 0; j < coll.size(); ++j) {
                    BindingContext bindCtx = new BindingContext((IDataEntityType)coll.getDynamicObjectType(), (DynamicObject)coll.get(j), startIndex + j, null);
                    List rowBindValue = entryGrid.getRowBindValue(bindCtx);
                    rows.add(rowBindValue);
                }
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("rows", rows);
                data.put("pagerows", pageRows);
                data.put(DATAINDEX, entryGrid.getDataIndex());
                Map<String, Object> fmtInfo = this.getFmtInfo((DynamicObject[])coll.toArray((Object[])new DynamicObject[0]), startIndex, entryGrid.getView(), entryGrid, entryKey);
                entryData = new EntryData(entryKey, startIndex, endIndex, pageRows, (DynamicObject[])coll.toArray((Object[])new DynamicObject[0]), data, fmtInfo);
            } else {
                boolean retry = true;
                int retryCount = 0;
                while (retry) {
                    try {
                        entryData = entryGrid.getEntryData(pageRows, startIndex, endIndex, batchCount, pageRows, i, Boolean.TRUE);
                        retry = false;
                    }
                    catch (Exception e) {
                        log.error("[\u6309\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa,\u591a\u7ebf\u7a0b\u5e76\u53d1\u83b7\u53d6\u5206\u5f55\u6570\u636e\u5f02\u5e38]" + e);
                        try {
                            Thread.sleep(4L);
                        }
                        catch (InterruptedException ex) {
                            log.error("[\u6309\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa,\u591a\u7ebf\u7a0b\u5e76\u53d1\u83b7\u53d6\u5206\u5f55\u6570\u636e\uff0c\u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38]" + e);
                        }
                        retry = true;
                        ++retryCount;
                    }
                    finally {
                        if (retryCount <= 20) continue;
                        retry = false;
                    }
                }
            }
            endIndex = i == batchCount - 1 ? total : (endIndex += pageRows);
            if (entryData == null || MapUtils.isEmpty((Map)entryData.getData()) || entryData.getData().get("rows") == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u5bfc\u51fa\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u53d6\u5206\u5f55\u6570\u636e", (String)"ExportEntryTemplateThread_0", (String)BOS_EXPORT, (Object[])new Object[0]));
            }
            List rows = (List)entryData.getData().get("rows");
            for (List rowObjectList : rows) {
                DynamicObject dataEntity = entryData.getDataEntitys()[(Integer)rowObjectList.get(0) - entryData.getStartIndex()];
                Object pkValue = dataEntity.getPkValue();
                if (pkValue == null || StringUtils.equals((CharSequence)pkValue.toString(), (CharSequence)"0")) {
                    pkValue = dataEntity.getDataEntityState().getInstanceId();
                }
                this.writeRowDataNotSelected(currentRowIndex, writerFormat.col, rowObjectList, templateFieldSort, pkValue, entryGrid, entryData, writerFormat);
                ++currentRowIndex;
                this.updateProcess(entryGrid);
                if (writerFormat.next.isEmpty() || entryGrid instanceof SubEntryGrid) continue;
                entryGrid.getEntryState().setFocusRow((Integer)rowObjectList.get(0) - entryData.getStartIndex());
                int subEntryRowIndex = currentRowIndex - 1;
                for (int t = 0; t < writerFormat.next.size(); ++t) {
                    ExportWriterFormat exportWriterFormat = writerFormat.next.get(t);
                    SubEntryGrid subEntryGrid = (SubEntryGrid)view.getControl(exportWriterFormat.name);
                    int subEntryColIndex = writerFormat.col;
                    int tmpRowIndex = this.exportEntry2Excel((EntryGrid)subEntryGrid, this.reSortToTemplate((EntryGrid)subEntryGrid, exportWriterFormat), exportWriterFormat, this.getTotal(view, subEntryGrid.getEntryKey()), subEntryRowIndex);
                    if (tmpRowIndex <= currentRowIndex) continue;
                    currentRowIndex = tmpRowIndex;
                }
            }
            startIndex += pageRows;
        }
        return currentRowIndex;
    }

    private void updateProcess(EntryGrid entryGrid) {
        if (!(entryGrid instanceof SubEntryGrid)) {
            ++this.process;
            if (this.process % 1000 == 0) {
                this.pageCache.put(EXPORT_PROCESS + this.entryIndex, SerializationUtils.toJsonString((Object)new ExportEntryProcess(this.process, this.total)));
                this.pageCache.saveChanges();
            }
        }
    }

    private void writeRowDataNotSelected(int currentRowIndex, int currentColIndex, List<Object> rowObjectList, List<ExportEntryByTemplateForSort> templateFieldSort, Object pkValue, EntryGrid entryGrid, EntryData entryData, ExportWriterFormat exportWriterFormat) {
        IFormView view = entryGrid.getView();
        Map fmtInfo = entryData.getFmtInfo();
        Map dataIndex = entryGrid.getDataIndex();
        SXSSFRow row = this.sheet.getRow(currentRowIndex) == null ? this.sheet.createRow(currentRowIndex) : this.sheet.getRow(currentRowIndex);
        this.formatAndWriteToCell(currentColIndex, rowObjectList, templateFieldSort, pkValue, entryData, exportWriterFormat, row, entryGrid);
    }

    private void formatAndWriteToCell(int currentColIndex, List<Object> rowObjectList, List<ExportEntryByTemplateForSort> templateFieldSort, Object pkValue, EntryData entryData, ExportWriterFormat exportWriterFormat, SXSSFRow row, EntryGrid entryGrid) {
        int excelColForEntry = 0;
        IDataModel model = this.entryGrid.getView().getModel();
        for (ExportEntryByTemplateForSort exportEntryByTemplateForSort : templateFieldSort) {
            String finalValueDate;
            String inputTypeStr;
            String finalValue;
            Integer indexInEntry = exportEntryByTemplateForSort.getIndexInEntry();
            List<String> flexColumns = exportEntryByTemplateForSort.getFlexColumns();
            if (indexInEntry != null && indexInEntry == -1) {
                if (pkValue instanceof Long && (Long)pkValue != 0L) {
                    SXSSFCell cell = row.createCell(excelColForEntry + currentColIndex);
                    cell.setCellStyle(this.styles.getTextStyle());
                    cell.setCellValue(pkValue.toString());
                    if (this.pageCache.get("hasMatchId") == null) {
                        this.pageCache.put("hasMatchId", "true");
                    }
                }
                ++excelColForEntry;
                continue;
            }
            if (indexInEntry == null || null == rowObjectList.get(indexInEntry)) {
                if (CollectionUtils.isNotEmpty(flexColumns)) {
                    excelColForEntry += flexColumns.size();
                    continue;
                }
                ++excelColForEntry;
                continue;
            }
            String fieldName = exportEntryByTemplateForSort.getFieldName();
            Map<String, Object> propertyInputMessageMap = exportWriterFormat.properties.get(fieldName);
            Object valueInEntryData = rowObjectList.get(indexInEntry);
            Object inputType = propertyInputMessageMap.get("InputType");
            if (null == inputType) {
                String finalValue2 = this.formatNoTypeValue(propertyInputMessageMap, valueInEntryData);
                CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex), (String)finalValue2, (CellStyle)this.styles.getTextStyle());
                ++excelColForEntry;
                continue;
            }
            if (propertyInputMessageMap.get("PropType") != null && inputType instanceof String[]) {
                String[] comboItemArr = (String[])inputType;
                if (StringUtils.equals((CharSequence)propertyInputMessageMap.get("PropType").toString(), (CharSequence)"ComboProp")) {
                    String valueInEntryDataTmp = valueInEntryData.toString();
                    String[] first = Arrays.stream(comboItemArr).filter(item -> item.split(" # ")[1].equals(valueInEntryDataTmp)).findFirst();
                    if (first.isPresent()) {
                        String finalValue3 = first.get().split(" # ")[0];
                        CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex), (String)finalValue3, (CellStyle)this.styles.getTextStyle());
                        ++excelColForEntry;
                        continue;
                    }
                }
                if (StringUtils.equals((CharSequence)propertyInputMessageMap.get("PropType").toString(), (CharSequence)"MulComboProp")) {
                    StringBuilder finalValueSb = new StringBuilder();
                    for (String valueCombo : valueInEntryData.toString().split(",")) {
                        Optional<String> first = Arrays.stream(comboItemArr).filter(item -> item.split(" # ")[1].equals(valueCombo)).findFirst();
                        if (!first.isPresent()) continue;
                        finalValueSb.append(",");
                        finalValueSb.append(first.get().split(" # ")[0]);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)finalValueSb.toString())) {
                        String finalValue4 = finalValueSb.substring(1);
                        CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex), (String)finalValue4, (CellStyle)this.styles.getTextStyle());
                        ++excelColForEntry;
                        continue;
                    }
                }
                if (StringUtils.equals((CharSequence)propertyInputMessageMap.get("PropType").toString(), (CharSequence)"BooleanProp") && valueInEntryData instanceof Boolean) {
                    finalValue = (Boolean)valueInEntryData != false ? comboItemArr[0] : comboItemArr[1];
                    CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex), (String)finalValue, (CellStyle)this.styles.getTextStyle());
                    ++excelColForEntry;
                    continue;
                }
            }
            if (StringUtils.equals((CharSequence)(inputTypeStr = inputType.toString()), (CharSequence)"basedata")) {
                finalValue = this.formatBaseDataValue(propertyInputMessageMap, valueInEntryData);
                CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex), (String)finalValue, (CellStyle)this.styles.getTextStyle());
                ++excelColForEntry;
                continue;
            }
            if (StringUtils.equals((CharSequence)inputType.toString(), (CharSequence)"flex")) {
                List<String> finalFlexValues = this.formatFlexValue(propertyInputMessageMap, valueInEntryData);
                int flexPropGroups = ExportEntryUtil.getFlexPropGroups(this.pageCache.get("BillFormId"));
                int flexPropGropusSplit = flexPropGroups * 3;
                if (finalFlexValues.size() > flexPropGropusSplit) {
                    finalFlexValues = finalFlexValues.subList(0, flexPropGropusSplit);
                }
                for (int i = 0; i < finalFlexValues.size(); ++i) {
                    CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex + i), (String)finalFlexValues.get(i), (CellStyle)this.styles.getTextStyle());
                }
                excelColForEntry += flexColumns.size();
                continue;
            }
            if (StringUtils.equals((CharSequence)inputType.toString(), (CharSequence)"largetext")) {
                String finalValueTag;
                if (valueInEntryData != null && StringUtils.isNotEmpty((CharSequence)valueInEntryData.toString())) {
                    CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex), (String)valueInEntryData.toString(), (CellStyle)this.styles.getTextStyle());
                }
                if ((finalValueTag = entryData.getDataEntitys()[(Integer)rowObjectList.get(0) - entryData.getStartIndex()].getString(fieldName + "_tag")).length() >= Short.MAX_VALUE) {
                    finalValueTag = String.format(ResManager.loadKDString((String)"\u6570\u636e\u957f\u5ea6\u8d85\u8fc7\u5355\u5143\u683c\u652f\u6301\u7684\u6700\u5927\u957f\u5ea6%s\u3002", (String)"ExportToExcel_1", (String)BOS_EXPORT, (Object[])new Object[0]), Short.MAX_VALUE);
                }
                CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex + 1), (String)finalValueTag, (CellStyle)this.styles.getTextStyle());
                excelColForEntry += flexColumns.size();
                continue;
            }
            if (StringUtils.equals((CharSequence)inputType.toString(), (CharSequence)"multilang")) {
                List<String> finalMultiLangValues = this.formatMultiLangValue(propertyInputMessageMap, valueInEntryData, flexColumns);
                for (int i = 0; i < finalMultiLangValues.size(); ++i) {
                    CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex + i), (String)finalMultiLangValues.get(i), (CellStyle)this.styles.getTextStyle());
                }
                excelColForEntry += flexColumns.size();
                continue;
            }
            IDataEntityProperty property = model.getProperty(exportEntryByTemplateForSort.getFieldName());
            if (property instanceof AdminDivisionProp) {
                Object adminDivisionFullName;
                if (valueInEntryData instanceof Object[] && ((Object[])valueInEntryData).length > 2 && (adminDivisionFullName = ORMUtil.getAdminDivisionFullName((String)((Object[])valueInEntryData)[0].toString())) != null) {
                    CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex), (String)adminDivisionFullName.toString(), (CellStyle)this.styles.getTextStyle());
                }
                ++excelColForEntry;
                continue;
            }
            if (StringUtils.equals((CharSequence)inputType.toString(), (CharSequence)"decimal")) {
                if (property instanceof AmountProp) {
                    if (valueInEntryData.getClass().isArray() && ((Object[])valueInEntryData).length >= 2) {
                        valueInEntryData = ((Object[])valueInEntryData)[0];
                    }
                    valueInEntryData = ExportEntryUtil.formatAmount(property, rowObjectList, entryGrid.getDataIndex(), entryData.getFmtInfo(), entryData.getDataEntitys()[(Integer)rowObjectList.get(0) - entryData.getStartIndex()], valueInEntryData);
                } else if (property instanceof QtyProp) {
                    if (valueInEntryData.getClass().isArray() && ((Object[])valueInEntryData).length >= 2) {
                        valueInEntryData = ((Object[])valueInEntryData)[0];
                    }
                    Integer cppropIndex = (Integer)entryGrid.getDataIndex().get("cprop");
                    Map cpprop = (Map)rowObjectList.get(cppropIndex);
                    Map materialFmtinfo = (Map)cpprop.get("fmtinfo");
                    valueInEntryData = ExportEntryUtil.formatQty(property, rowObjectList, entryGrid.getDataIndex(), materialFmtinfo, entryData.getFmtInfo(), entryData.getDataEntitys()[(Integer)rowObjectList.get(0) - entryData.getStartIndex()], valueInEntryData);
                }
                if (valueInEntryData == null || kd.bos.util.StringUtils.isEmpty((String)valueInEntryData.toString()) || !((DecimalProp)property).isZeroShow() && BigDecimal.ZERO.compareTo(new BigDecimal(valueInEntryData.toString().replace(",", ""))) == 0) {
                    valueInEntryData = null;
                    ++excelColForEntry;
                    continue;
                }
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                BigDecimal bigDecimalValue = new BigDecimal(valueInEntryData.toString());
                int scale = 0;
                scale = property instanceof QtyProp || property instanceof AmountProp ? bigDecimalValue.scale() : ((DecimalProp)property).getScale();
                dataMap.put("precision", scale);
                SXSSFCell cell = row.createCell(excelColForEntry + currentColIndex);
                cell.setCellValue(bigDecimalValue.doubleValue());
                cell.setCellStyle(this.styles.getDecimalStyle(this.workbook, dataMap));
                ++excelColForEntry;
                continue;
            }
            if (StringUtils.equals((CharSequence)inputType.toString(), (CharSequence)"date")) {
                finalValueDate = null;
                if (propertyInputMessageMap.get("PropType") != null && propertyInputMessageMap.get("isStart") != null) {
                    String datetimeRangeFieldName = propertyInputMessageMap.get("PropType").toString();
                    if (valueInEntryData.toString().indexOf(44) != -1) {
                        finalValueDate = StringUtils.equals((CharSequence)propertyInputMessageMap.get("isStart").toString(), (CharSequence)"true") ? ((String)valueInEntryData).split(",")[0] : ((String)valueInEntryData).split(",")[1].trim();
                    }
                }
                SXSSFCell cell = row.createCell(excelColForEntry + currentColIndex);
                cell.setCellValue(StringUtils.isEmpty((CharSequence)finalValueDate) ? (StringUtils.equals((CharSequence)valueInEntryData.toString(), (CharSequence)", ") ? "" : valueInEntryData.toString()) : finalValueDate);
                cell.setCellStyle(this.styles.getDateStyle());
                ++excelColForEntry;
                continue;
            }
            if (StringUtils.equals((CharSequence)inputType.toString(), (CharSequence)"datetime")) {
                finalValueDate = null;
                if (propertyInputMessageMap.get("PropType") != null && propertyInputMessageMap.get("isStart") != null) {
                    String datetimeRangeFieldName = propertyInputMessageMap.get("PropType").toString();
                    if (valueInEntryData.toString().indexOf(44) != -1) {
                        finalValueDate = StringUtils.equals((CharSequence)propertyInputMessageMap.get("isStart").toString(), (CharSequence)"true") ? ((String)valueInEntryData).split(",")[0] : ((String)valueInEntryData).split(",")[1];
                    }
                }
                SXSSFCell cell = row.createCell(excelColForEntry + currentColIndex);
                cell.setCellValue(StringUtils.isEmpty((CharSequence)finalValueDate) ? (StringUtils.equals((CharSequence)valueInEntryData.toString(), (CharSequence)", ") ? "" : valueInEntryData.toString()) : finalValueDate);
                cell.setCellStyle(this.styles.getDatetimeStyle());
                ++excelColForEntry;
                continue;
            }
            if (StringUtils.equals((CharSequence)inputType.toString(), (CharSequence)"time")) {
                finalValueDate = "";
                if (valueInEntryData instanceof Integer) {
                    finalValueDate = ExportEntryUtil.formatTimeStr((Integer)valueInEntryData);
                } else if (propertyInputMessageMap.get("PropType") != null && propertyInputMessageMap.get("isStart") != null) {
                    String datetimeRangeFieldName = propertyInputMessageMap.get("PropType").toString();
                    if (valueInEntryData.toString().indexOf(44) != -1) {
                        finalValueDate = StringUtils.equals((CharSequence)propertyInputMessageMap.get("isStart").toString(), (CharSequence)"true") ? ((String)valueInEntryData).split(",")[0] : ((String)valueInEntryData).split(",")[1];
                        finalValueDate = ExportEntryUtil.formatTimeStr(Integer.valueOf(finalValueDate.trim()));
                    }
                }
                if (StringUtils.equals((CharSequence)finalValueDate, (CharSequence)", ")) {
                    finalValueDate = "";
                }
                SXSSFCell cell = row.createCell(excelColForEntry + currentColIndex);
                cell.setCellValue(finalValueDate);
                cell.setCellStyle(this.styles.getTextStyle());
                ++excelColForEntry;
                continue;
            }
            if (valueInEntryData != null) {
                if (valueInEntryData instanceof Object[]) {
                    CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex), (String)((Object[])valueInEntryData)[0].toString(), (CellStyle)this.styles.getTextStyle());
                } else {
                    CellUtil.createCell((Row)row, (int)(excelColForEntry + currentColIndex), (String)valueInEntryData.toString(), (CellStyle)this.styles.getTextStyle());
                }
            }
            ++excelColForEntry;
        }
    }

    private List<String> formatMultiLangValue(Map<String, Object> propertyInputMessageMap, Object valueInEntryData, List<String> flexColumns) {
        if (!(valueInEntryData instanceof OrmLocaleValue)) {
            return new ArrayList<String>();
        }
        ArrayList<String> langKeyList = new ArrayList<String>(flexColumns.size());
        ArrayList<String> langValueList = new ArrayList<String>(flexColumns.size());
        for (String flexColumn : flexColumns) {
            String[] split = flexColumn.split("\\.", 2);
            langKeyList.add(split[1]);
        }
        OrmLocaleValue ormLocaleValue = (OrmLocaleValue)valueInEntryData;
        for (String langKey : langKeyList) {
            String langValue = ormLocaleValue.get((Object)langKey);
            langValueList.add(langValue);
        }
        return langValueList;
    }

    private List<String> formatFlexValue(Map<String, Object> propertyInputMessageMap, Object valueInEntryData) {
        ArrayList<String> formatFlexValueList = new ArrayList<String>(8);
        if (!(valueInEntryData instanceof List)) {
            return formatFlexValueList;
        }
        List flexValueList = (List)valueInEntryData;
        for (Map flexValueMap : flexValueList) {
            String alias = flexValueMap.get("alias").toString();
            if (StringUtils.isEmpty((CharSequence)alias)) continue;
            String flexName = alias.split(":")[0];
            Object v = flexValueMap.get("v");
            String flexValueKey = "";
            String flexValueName = "";
            if (v instanceof String) {
                flexValueName = v.toString();
            } else if (v instanceof Object[]) {
                Object[] valueArr = (Object[])flexValueMap.get("v");
                flexValueKey = valueArr[0].toString();
                flexValueName = valueArr[1].toString();
            }
            formatFlexValueList.add(flexName);
            formatFlexValueList.add(flexValueKey);
            formatFlexValueList.add(flexValueName);
        }
        return formatFlexValueList;
    }

    private String formatNoTypeValue(Map<String, Object> propertyInputMessageMap, Object valueInEntryData) {
        return valueInEntryData.toString();
    }

    private String formatBaseDataValue(Map<String, Object> propertyInputMessageMap, Object valueInEntryData) {
        Object importProp = propertyInputMessageMap.get("ImportProp");
        if (importProp == null) {
            return "";
        }
        String importPropStr = ((ArrayList)importProp).get(0).toString();
        StringBuilder sb = new StringBuilder();
        if (valueInEntryData instanceof List) {
            for (Object valueInEntryDataArrObj : (List)valueInEntryData) {
                Object[] valueBasedataArr;
                if (StringUtils.equals((CharSequence)importPropStr, (CharSequence)"number")) {
                    valueBasedataArr = (Object[])valueInEntryDataArrObj;
                    sb.append(valueBasedataArr[0].toString());
                    sb.append(",");
                }
                if (!StringUtils.equals((CharSequence)importPropStr, (CharSequence)"name")) continue;
                valueBasedataArr = (Object[])valueInEntryDataArrObj;
                sb.append(valueBasedataArr[1].toString());
                sb.append(",");
            }
            return sb.substring(0, sb.length() - 1);
        }
        if (StringUtils.equals((CharSequence)importPropStr, (CharSequence)"number")) {
            Object[] valueBasedataArr = (Object[])valueInEntryData;
            return valueBasedataArr[0].toString();
        }
        if (StringUtils.equals((CharSequence)importPropStr, (CharSequence)"name")) {
            Object[] valueBasedataArr = (Object[])valueInEntryData;
            return valueBasedataArr[1].toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exportEntryHasSelected(EntryGrid entryGrid, List<ExportEntryByTemplateForSort> templateFieldSort, ExportWriterFormat writerFormat, int currentRowIndex) {
        int[] selectRows = entryGrid.getSelectRows();
        int startIndex = selectRows[0];
        int endIndex = selectRows[selectRows.length - 1];
        int pageRow = entryGrid.getPageRow();
        if ((endIndex - startIndex) / selectRows.length > 100) {
            List<Integer[]> selectRowsSetList = this.intStep(selectRows, 100);
            for (Integer[] selectRowsArr : selectRowsSetList) {
                Integer currentPageIndex = entryGrid.getEntryState().getCurrentPageIndex();
                boolean retry = true;
                int retryCount = 0;
                EntryData entryData = null;
                while (retry) {
                    try {
                        entryData = entryGrid.getEntryData(selectRowsArr.length, selectRowsArr[0].intValue(), selectRowsArr[selectRowsArr.length - 1] + 1, selectRowsArr.length, pageRow, currentPageIndex.intValue(), Boolean.valueOf(true));
                        retry = false;
                    }
                    catch (Exception e) {
                        log.error("[\u6309\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa,\u591a\u7ebf\u7a0b\u5e76\u53d1\u83b7\u53d6\u5206\u5f55\u6570\u636e\u5f02\u5e38]" + e);
                        try {
                            Thread.sleep(4L);
                        }
                        catch (InterruptedException ex) {
                            log.error("[\u6309\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa,\u591a\u7ebf\u7a0b\u5e76\u53d1\u83b7\u53d6\u5206\u5f55\u6570\u636e\uff0c\u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38]" + e);
                        }
                        retry = true;
                        ++retryCount;
                    }
                    finally {
                        if (retryCount <= 20) continue;
                        retry = false;
                    }
                }
                if (entryData == null || MapUtils.isEmpty((Map)entryData.getData()) || entryData.getData().get("rows") == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u5bfc\u51fa\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u53d6\u5206\u5f55\u6570\u636e", (String)"ExportEntryTemplateThread_0", (String)BOS_EXPORT, (Object[])new Object[0]));
                }
                List rows = (List)entryData.getData().get("rows");
                for (Integer selectRow : selectRowsArr) {
                    this.writeToExcelForHasSelected(entryData, selectRowsArr, templateFieldSort, currentRowIndex, writerFormat, selectRow, rows);
                    ++currentRowIndex;
                    if (writerFormat.next.isEmpty() || entryGrid instanceof SubEntryGrid) continue;
                    int subEntryRowIndex = currentRowIndex - 1;
                    entryGrid.getEntryState().setFocusRow(selectRow.intValue());
                    for (ExportWriterFormat subExportWriterFormat : writerFormat.next) {
                        IFormView view = entryGrid.getView();
                        SubEntryGrid subEntryGrid = (SubEntryGrid)view.getControl(subExportWriterFormat.name);
                        int tmpRowIndex = this.exportEntry2Excel((EntryGrid)subEntryGrid, this.reSortToTemplate((EntryGrid)subEntryGrid, subExportWriterFormat), subExportWriterFormat, this.getTotal(view, subEntryGrid.getEntryKey()), subEntryRowIndex);
                        if (tmpRowIndex <= currentRowIndex) continue;
                        currentRowIndex = tmpRowIndex;
                    }
                }
            }
        } else {
            Integer currentPageIndex = entryGrid.getEntryState().getCurrentPageIndex();
            int rowCount = selectRows[selectRows.length - 1] - selectRows[0] + 1;
            EntryData entryData = null;
            boolean retry = true;
            int retryCount = 0;
            while (retry) {
                try {
                    entryData = entryGrid.getEntryData(rowCount, selectRows[0], selectRows[selectRows.length - 1] + 1, selectRows.length, pageRow, currentPageIndex.intValue(), Boolean.valueOf(true));
                    retry = false;
                }
                catch (Exception e) {
                    log.error("[\u6309\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa,\u591a\u7ebf\u7a0b\u5e76\u53d1\u83b7\u53d6\u5206\u5f55\u6570\u636e\u5f02\u5e38]" + e);
                    try {
                        Thread.sleep(4L);
                    }
                    catch (InterruptedException ex) {
                        log.error("[\u6309\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa,\u591a\u7ebf\u7a0b\u5e76\u53d1\u83b7\u53d6\u5206\u5f55\u6570\u636e\uff0c\u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38]" + e);
                    }
                    retry = true;
                    ++retryCount;
                }
                finally {
                    if (retryCount <= 20) continue;
                    retry = false;
                }
            }
            List rows = (List)entryData.getData().get("rows");
            for (int selectRow : selectRows) {
                this.writeToExcelForHasSelected(entryData, (Integer[])Arrays.stream(selectRows).boxed().toArray(Integer[]::new), templateFieldSort, currentRowIndex, writerFormat, selectRow, rows);
                ++currentRowIndex;
                if (writerFormat.next.isEmpty() || entryGrid instanceof SubEntryGrid) continue;
                entryGrid.getEntryState().setFocusRow(selectRow);
                int subEntryRowIndex = currentRowIndex - 1;
                for (ExportWriterFormat subExportWriterFormat : writerFormat.next) {
                    IFormView view = entryGrid.getView();
                    SubEntryGrid subEntryGrid = (SubEntryGrid)view.getControl(subExportWriterFormat.name);
                    int tmpRowIndex = this.exportEntry2Excel((EntryGrid)subEntryGrid, this.reSortToTemplate((EntryGrid)subEntryGrid, subExportWriterFormat), subExportWriterFormat, this.getTotal(view, subEntryGrid.getEntryKey()), subEntryRowIndex);
                    if (tmpRowIndex <= currentRowIndex) continue;
                    currentRowIndex = tmpRowIndex;
                }
            }
        }
        return currentRowIndex;
    }

    private void writeToExcelForHasSelected(EntryData entryData, Integer[] selectRowsArr, List<ExportEntryByTemplateForSort> templateFieldSort, int currentRowIndex, ExportWriterFormat writerFormat, Integer selectRow, List<Object> rows) {
        int startIndex = selectRowsArr[0];
        int realIndex = selectRow - startIndex;
        List rowObjectList = (List)rows.get(realIndex);
        DynamicObject dataEntity = entryData.getDataEntitys()[realIndex];
        Object pkValue = dataEntity.getPkValue();
        if (pkValue == null || StringUtils.equals((CharSequence)pkValue.toString(), (CharSequence)"0")) {
            pkValue = dataEntity.getDataEntityState().getInstanceId();
        }
        SXSSFRow row = this.sheet.getRow(currentRowIndex) == null ? this.sheet.createRow(currentRowIndex) : this.sheet.getRow(currentRowIndex);
        this.formatAndWriteToCell(writerFormat.col, rowObjectList, templateFieldSort, pkValue, entryData, writerFormat, row, this.entryGrid);
        this.updateProcess(this.entryGrid);
    }

    private List<Integer[]> intStep(int[] numbers, int size) {
        int count = 1;
        ArrayList<Integer[]> setList = new ArrayList<Integer[]>();
        TreeSet<Integer> integerSet = new TreeSet<Integer>();
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] <= size * count) {
                integerSet.add(numbers[i]);
                continue;
            }
            Integer[] integerArrTmp = new TreeSet(integerSet).toArray(new Integer[0]);
            setList.add(integerArrTmp);
            integerSet.clear();
            count = numbers[i] / size + 1;
            --i;
        }
        setList.add(integerSet.toArray(new Integer[0]));
        return setList;
    }

    private List<ExportEntryByTemplateForSort> reSortToTemplate(EntryGrid entryGrid, ExportWriterFormat writerFormat) {
        ArrayList<ExportEntryByTemplateForSort> templateFieldSort = new ArrayList<ExportEntryByTemplateForSort>(writerFormat.fields.size());
        if (entryGrid == null || MapUtils.isEmpty((Map)entryGrid.getDataIndex())) {
            return null;
        }
        if (this.templateFieldSortMap.get(entryGrid.getEntryKey()) != null) {
            return this.templateFieldSortMap.get(entryGrid.getEntryKey());
        }
        Map dataIndexMap = entryGrid.getDataIndex();
        for (String field : writerFormat.fields) {
            Map<String, Object> propertyInputMessageMap;
            if (StringUtils.equals((CharSequence)field, (CharSequence)(writerFormat.name + ".$matchid$"))) {
                templateFieldSort.add(ExportEntryByTemplateForSort.ExportEntryByTemplateForSortBuilder.anExportEntryByTemplateForSort().withIsPk(true).withIndexInEntry(-1).withFieldName(field).build());
                continue;
            }
            Integer indexInEntry = (Integer)dataIndexMap.get(field);
            List<String> flexColumnList = writerFormat.flexColumn.get(field);
            if (flexColumnList != null) {
                templateFieldSort.add(ExportEntryByTemplateForSort.ExportEntryByTemplateForSortBuilder.anExportEntryByTemplateForSort().withFieldName(indexInEntry == null ? null : field).withFlexColumns(flexColumnList).withIndexInEntry(indexInEntry).withFlexColumns(flexColumnList).build());
                continue;
            }
            IDataEntityProperty property = this.entryGrid.getModel().getProperty(field);
            if (indexInEntry == null && (property instanceof DateTimeProp || property instanceof TimeProp) && MapUtils.isNotEmpty(propertyInputMessageMap = writerFormat.properties.get(field)) && propertyInputMessageMap.get("PropType") != null) {
                String dateTimeRangeFieldName = propertyInputMessageMap.get("PropType").toString();
                indexInEntry = (Integer)dataIndexMap.get(dateTimeRangeFieldName);
                templateFieldSort.add(ExportEntryByTemplateForSort.ExportEntryByTemplateForSortBuilder.anExportEntryByTemplateForSort().withFieldName(field).withFlexColumns(flexColumnList).withIndexInEntry(indexInEntry).build());
                continue;
            }
            templateFieldSort.add(ExportEntryByTemplateForSort.ExportEntryByTemplateForSortBuilder.anExportEntryByTemplateForSort().withFieldName(indexInEntry == null ? null : field).withIndexInEntry(indexInEntry).build());
        }
        this.templateFieldSortMap.putIfAbsent(entryGrid.getEntryKey(), templateFieldSort);
        return templateFieldSort;
    }

    @Override
    public ExportEntryTemplateResult call() {
        return this.doExport();
    }

    private Map<String, Object> getFmtInfo(DynamicObject[] dataEntitys, int rowStartIndex, IFormView view, EntryGrid entryGrid, String entryKey) {
        NumberFormatProvider numberFormatProvider = this.getNumberFormatProvider(dataEntitys, rowStartIndex, false, view, entryGrid, entryKey);
        HashMap<String, Object> numFmtInfo = new HashMap<String, Object>();
        numFmtInfo.put("colfmt", numberFormatProvider.getColfmt());
        numFmtInfo.put("currencyfmt", numberFormatProvider.getCurrencyfmt());
        numFmtInfo.put("unitfmt", numberFormatProvider.getUnitfmt());
        numFmtInfo.put("timezonefmt", numberFormatProvider.getTimeZoneFmt());
        return numFmtInfo;
    }

    private NumberFormatProvider getNumberFormatProvider(DynamicObject[] dataEntitys, int rowStartIndex, boolean reuse, IFormView view, EntryGrid entryGrid, String entryKey) {
        if (this.numberFormatProvider != null && reuse) {
            return this.numberFormatProvider;
        }
        IDataModel model = view.getModel();
        IDataEntityType entryType = ((ICollectionProperty)model.getProperty(entryKey)).getItemType();
        ArrayList<FmtField> fmtFields = new ArrayList<FmtField>();
        for (FieldEdit ctl : entryGrid.getFieldEdits()) {
            FmtField fmtField;
            IDataEntityProperty prop;
            if (ctl.isFlatField()) continue;
            if (ctl instanceof DecimalEdit) {
                prop = (IDataEntityProperty)entryType.getProperties().get((Object)ctl.getFieldKey());
                String propName = ((DecimalEdit)ctl).getControlPropName();
                FmtField fmtField2 = new FmtField(prop, ctl.getKey(), propName);
                fmtFields.add(fmtField2);
                continue;
            }
            if (ctl instanceof DateTimeEdit) {
                prop = (IDataEntityProperty)entryType.getProperties().get((Object)ctl.getFieldKey());
                fmtField = new FmtField(prop, ctl.getKey(), ctl instanceof DateEdit ? null : ((DateTimeProp)prop).getRelateOrg());
                fmtFields.add(fmtField);
                continue;
            }
            if (!(ctl instanceof DateRangeEdit)) continue;
            prop = (IDataEntityProperty)entryType.getProperties().get((Object)((DateRangeEdit)ctl).getStartDateFieldKey());
            fmtField = new FmtField(prop, ctl.getKey(), null);
            fmtFields.add(fmtField);
        }
        DynamicCollectionProperty entryProp = (DynamicCollectionProperty)view.getModel().getProperty(entryKey);
        List<DynamicObject> dynamicObjects = Arrays.asList(dataEntitys);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(entryProp.getDynamicCollectionItemPropertyType(), (Object)entryProp.getParent(), dynamicObjects);
        NumberFormatProvider numberFormatProvider = new NumberFormatProvider(fmtFields, dynamicObjectCollection, view.getModel().getDataEntity(), rowStartIndex);
        if (reuse) {
            this.numberFormatProvider = numberFormatProvider;
        }
        return numberFormatProvider;
    }

    private int getTotal(IFormView view, String entryKey) {
        EntryGrid grid = (EntryGrid)view.getControl(entryKey);
        int row = view.getModel().getEntryRowCount(entryKey);
        if (grid.getEntryState().getSelectedRows().length > 0) {
            row = grid.getEntryState().getSelectedRows().length;
        }
        return row;
    }

    static class ReferenceInteger {
        Integer value;

        public ReferenceInteger(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public Integer increase() {
            Integer n = this.value;
            Integer n2 = this.value = Integer.valueOf(this.value + 1);
            return this.value;
        }
    }
}

