/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.formop;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.attachment.util.AttachmentManageUtil;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.svc.util.permission.datarule.DataRulePermissionUtil;

public class ExportEntryByTemplate
extends DefaultDynamicFormOperate
implements ICloseCallBack,
IConfirmCallBack {
    private static final String TOPPAGEID = "topPageId";
    public static final String BOS_EXPORT = "bos-export";
    public static final String BOS_EXPORTINGENTRY_TPL = "bos_exportingentry_tpl";
    public static final String BOS_IMPORTENTRY_TEMPLATE = "bos_importentry_template";
    public static final String BOS_DOWNLOADENTRYTEMPLATE = "bos_downloadentrytemplate";
    public static final String SELECTEXPORTENTRYTEMPLATE = "selectexportentrytemplate";
    public static final String SERVICE_APP_ID = "ServiceAppId";
    public static final String CHECK_RIGHT_APP_ID = "CheckRightAppId";
    public static final String BILL_FORM_ID = "BillFormId";
    public static final String OPERATE_KEY = "OperateKey";
    public static final String PERMISSION_ITEM_ID = "PermissionItemId";
    public static final String REAL_PERMISSION_ENTITY_ID = "RealPermissionEntityId";
    public static final String OPERATE_NAME = "OperateName";
    public static final String TEMPLATE_ID = "templateId";
    public static final String EXPORT_ENTRY_TEMPLATE_CONFIRM_CALL_BACK = "ExportEntryTemplateConfirmCallBack";
    private static final String BTN_NEWTEMPLATE = "newtemplate";
    public static final String IS_FOR_EXPORT_ENTRY = "isForExportEntry";
    public static final String ENCRYPT_EXPORT_ENTRY_FILE = "encrypt_export_entry_file";

    protected int checkRightInListForm(MainEntityType mainEntityType, OperationResult result) {
        if (this.getView() instanceof IBillView) {
            this.doPermission(result, this.getPermissionItemId(), this.mainOrgId != null ? this.mainOrgId : 0L);
        }
        return 1;
    }

    public boolean needSelectData() {
        return false;
    }

    public OperationResult invokeOperation() {
        List pkIds;
        if (!(this.getView() instanceof IBillView)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5217\u8868\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\u3002", (String)"ExportEntryByTemplate_1", (String)BOS_EXPORT, (Object[])new Object[0]));
            return new OperationResult();
        }
        Map allEntities = this.getView().getModel().getDataEntityType().getAllEntities();
        Optional<EntityType> anyEntry = allEntities.values().stream().filter(i -> i instanceof EntryType).findAny();
        if (!anyEntry.isPresent()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u5b58\u5728\u5355\u636e\u4f53\uff0c\u4e0d\u652f\u6301\u5355\u636e\u4f53\u5bfc\u51fa\u3002", (String)"ExportEntryByTemplate_0", (String)BOS_EXPORT, (Object[])new Object[0]));
            return new OperationResult();
        }
        IFormView view = this.getView();
        String billFormId = view.getEntityId();
        this.setCustomParamToPageCache();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("bizobject.number", "=", (Object)billFormId));
        String appId = this.getView().getFormShowParameter().getCheckRightAppId();
        QFilter dataRule = DataRulePermissionUtil.getDataRule((long)RequestContext.get().getCurrUserId(), (String)appId, (String)BOS_IMPORTENTRY_TEMPLATE);
        if (dataRule != null) {
            filters.add(dataRule);
        }
        if ((pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)BOS_IMPORTENTRY_TEMPLATE, (QFilter[])filters.toArray(new QFilter[0]), (String)"", (int)2)).isEmpty()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\uff0c\u662f\u5426\u524d\u5f80\u65b0\u589e\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\uff1f", (String)"ExportEntryTemplate_1", (String)BOS_EXPORT, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(EXPORT_ENTRY_TEMPLATE_CONFIRM_CALL_BACK, (IConfirmCallBack)this));
            return new OperationResult();
        }
        filters.add(new QFilter("enable", "=", (Object)"1"));
        pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)BOS_IMPORTENTRY_TEMPLATE, (QFilter[])filters.toArray(new QFilter[0]), (String)"", (int)2);
        if (pkIds.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\uff0c\u8bf7\u542f\u7528\u5df2\u6709\u6216\u65b0\u589e\u53ef\u7528\u7684\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\u3002", (String)"ExportEntryTemplate_0", (String)BOS_EXPORT, (Object[])new Object[0]));
            return new OperationResult();
        }
        if (pkIds.size() == 1) {
            this.showExportProgressForm((Long)pkIds.get(0), true, null);
            return new OperationResult();
        }
        this.showSelectTemplate();
        return new OperationResult();
    }

    private void setCustomParamToPageCache() {
        IPageCache pageCache = this.getView().getPageCache();
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String billFormId = view.getEntityId();
        String topPageId = view.getPageId();
        pageCache.put(SERVICE_APP_ID, formShowParameter.getServiceAppId());
        pageCache.put(CHECK_RIGHT_APP_ID, formShowParameter.getCheckRightAppId());
        pageCache.put(PERMISSION_ITEM_ID, this.getPermissionItemId());
        pageCache.put(REAL_PERMISSION_ENTITY_ID, this.getRealPermissionEntityId());
        pageCache.put(OPERATE_KEY, this.getOperateKey());
        pageCache.put(OPERATE_NAME, this.getOperateName().getLocaleValue());
        pageCache.put(TOPPAGEID, topPageId);
        pageCache.put(BILL_FORM_ID, billFormId);
    }

    private void showSelectTemplate() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(BOS_DOWNLOADENTRYTEMPLATE);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), SELECTEXPORTENTRYTEMPLATE);
        showParameter.setCloseCallBack(closeCallBack);
        this.setCustomParam(showParameter);
        showParameter.setCustomParam(IS_FOR_EXPORT_ENTRY, (Object)"true");
        this.getView().showForm(showParameter);
    }

    private void setCustomParam(FormShowParameter showParameter) {
        IPageCache pageCache = this.getView().getPageCache();
        showParameter.setCustomParam(SERVICE_APP_ID, (Object)pageCache.get(SERVICE_APP_ID));
        showParameter.setCustomParam(CHECK_RIGHT_APP_ID, (Object)pageCache.get(CHECK_RIGHT_APP_ID));
        showParameter.setCustomParam(PERMISSION_ITEM_ID, (Object)pageCache.get(PERMISSION_ITEM_ID));
        showParameter.setCustomParam(REAL_PERMISSION_ENTITY_ID, (Object)pageCache.get(REAL_PERMISSION_ENTITY_ID));
        ArrayList<Long> mainOrgIds = null;
        if (this.mainOrgId != null) {
            mainOrgIds = new ArrayList<Long>();
            mainOrgIds.add(this.mainOrgId);
        }
        if (mainOrgIds != null && !mainOrgIds.isEmpty()) {
            showParameter.setCustomParam("MainOrgIds", (Object)JSONArray.toJSONString(mainOrgIds));
        }
        showParameter.setCustomParam(OPERATE_KEY, (Object)pageCache.get(OPERATE_KEY));
        showParameter.setCustomParam(OPERATE_NAME, (Object)pageCache.get(OPERATE_NAME));
        showParameter.setCustomParam(TOPPAGEID, (Object)pageCache.get(TOPPAGEID));
        showParameter.setCustomParam(BILL_FORM_ID, (Object)pageCache.get(BILL_FORM_ID));
    }

    private void showExportProgressForm(Long templateId) {
        this.showExportProgressForm(templateId, true, null);
    }

    private void showExportProgressForm(Long templateId, boolean showEncrypt, String password) {
        if (AttachmentManageUtil.needEncrypt((IFormView)this.getView(), (boolean)true) && showEncrypt) {
            this.showEncryptConfirm(templateId);
            return;
        }
        FormShowParameter showParameter = this.createShowParameter();
        showParameter.setCustomParam(TEMPLATE_ID, (Object)templateId);
        showParameter.setCustomParam("password", (Object)password);
        this.getView().showForm(showParameter);
    }

    protected FormShowParameter createShowParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(BOS_EXPORTINGENTRY_TPL);
        Map parameter = this.getParameter();
        if (parameter != null && !parameter.isEmpty()) {
            showParameter.setCustomParams(parameter);
        }
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        this.setCustomParam(showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getView() == null) {
            return;
        }
        this.setView(e.getView());
        if (e.getReturnData() == null) {
            return;
        }
        if (SELECTEXPORTENTRYTEMPLATE.equals(e.getActionId())) {
            try {
                this.handleCancelDataRight();
                this.handleCancelRight();
            }
            catch (KDBizException ex) {
                this.getView().showErrorNotification(ex.getMessage());
                return;
            }
        }
        if (ENCRYPT_EXPORT_ENTRY_FILE.equals(e.getActionId()) && e.getReturnData() instanceof Map) {
            Map params = (Map)e.getReturnData();
            String password = params.get("password").toString();
            Long templateId = (Long)params.get(TEMPLATE_ID);
            if (templateId == null) {
                templateId = 0L;
            }
            this.showExportProgressForm(templateId, false, password);
            return;
        }
        Object[] templates = (Object[])e.getReturnData();
        this.showExportProgressForm((Long)templates[0]);
    }

    private void handleCancelDataRight() {
        if (!this.getView().getFormShowParameter().isCancelDataRight()) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExportList_2", (String)BOS_EXPORT, (Object[])new Object[0]));
    }

    private void handleCancelRight() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCancelRight() == 0) {
            return;
        }
        FormConfig config = formShowParameter.getFormConfig();
        String formName = config.getCaption().toString();
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\"%1$s\"\u529f\u80fd\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExportList_1", (String)BOS_EXPORT, (Object[])new Object[0]), formName));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (EXPORT_ENTRY_TEMPLATE_CONFIRM_CALL_BACK.equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(BOS_IMPORTENTRY_TEMPLATE);
            parameter.setCustomParam("bindEntityId", (Object)this.getView().getFormShowParameter().getFormId());
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), BTN_NEWTEMPLATE));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void showEncryptConfirm(Long templateId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("bos_file_encrypt_confirm");
        showParameter.setCustomParam("encryptType", (Object)"1");
        if (null != templateId) {
            showParameter.setCustomParam(TEMPLATE_ID, (Object)templateId);
        }
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), ENCRYPT_EXPORT_ENTRY_FILE));
        this.getView().showForm(showParameter);
    }
}

