/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.listop;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.KDBizException;
import kd.bos.export.util.ExportListUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.attachment.util.AttachmentManageUtil;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.mservice.ImportPermissionService;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.imp.ImportPluginUtils;
import kd.bos.imp.events.TemplateFilterArgs;
import kd.bos.limiter.DuplicateLimiter;
import kd.bos.limiter.exception.AcquireFailedException;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.svc.util.permission.datarule.DataRulePermissionUtil;
import org.apache.commons.collections4.MapUtils;

public class ExportList
extends DefaultDynamicFormOperate
implements ICloseCallBack,
IConfirmCallBack {
    private static final String EXPORTPARAMETER = "ExportParameter";
    private static final String ENTITYNUMBER = "EntityNumber";
    private static final String BILLLISTAP = "billlistap";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String BOS_IMPORT_TEMPLATE = "bos_importtemplate";
    private static final String BOS_EXPORT = "bos-export";
    private static final String CONCURRENTID = "concurrentID";
    private static Log log = LogFactory.getLog(ExportList.class);
    private static final String EXPORTAPP = "imp-exp";
    private ImportPermissionService importPermissionService = new ImportPermissionService();

    private boolean isBillView() {
        return this.getView() instanceof IBillView;
    }

    public boolean needSelectData() {
        return false;
    }

    protected String getTemplateType() {
        return "IMPT";
    }

    protected String getAchieveKey() {
        if (!this.isBillView()) {
            IListView listview = (IListView)this.getView();
            BillList billList = (BillList)listview.getControl(BILLLISTAP);
            String achiveKey = billList.getListModel().getAchiveKey();
            return achiveKey;
        }
        return null;
    }

    protected String getRouteKey() {
        if (!this.isBillView()) {
            IListView listview = (IListView)this.getView();
            BillList billList = (BillList)listview.getControl(BILLLISTAP);
            String routeKey = billList.getListModel().getRouteKey();
            return routeKey;
        }
        return null;
    }

    protected long getBlankTemplateId() {
        return 0L;
    }

    protected int checkRightInListForm(MainEntityType mainEntityType, OperationResult result) {
        this.checkPermission(result);
        return 1;
    }

    private void checkPermission(OperationResult result) {
        if (this.getView() instanceof IListView) {
            List mainOrgIds = ((IListView)this.getView()).getSelectedMainOrgIds();
            mainOrgIds.removeIf(id -> id == null);
            if (mainOrgIds.isEmpty()) {
                this.doPermission(result, this.getPermissionItemId(), 0L);
            } else {
                this.doPermission(result, this.getPermissionItemId(), mainOrgIds);
            }
        } else {
            this.doPermission(result, this.getPermissionItemId(), this.mainOrgId != null ? this.mainOrgId : 0L);
        }
    }

    protected boolean beforeInvokeOperation(OperationResult e) {
        boolean pass = super.beforeInvokeOperation(e);
        return pass;
    }

    public OperationResult invokeOperation() {
        if (!this.isBillView() && !(this.getView() instanceof IListView)) {
            return new OperationResult();
        }
        Boolean opExist = this.checkOperationExist();
        if (!opExist.booleanValue()) {
            return new OperationResult();
        }
        boolean isDuplicate = DuplicateLimiter.acquire((String)"EXPORT_DUPLICATE", (String)this.getEntityId(), (String)this.getView().getPageId());
        if (!isDuplicate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExportList_18", (String)BOS_EXPORT, (Object[])new Object[0]));
            return new OperationResult();
        }
        if (this.isBillView()) {
            IBillView billView = (IBillView)this.getView();
            if (this.isByListExport()) {
                billView.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5728\u8868\u5355\u754c\u9762\u6309\u5217\u8868\u5bfc\u51fa\u5f53\u524d\u6570\u636e\uff0c\u8bf7\u5728\u5217\u8868\u754c\u9762\u5bfc\u51fa\u3002", (String)"ExportList_9", (String)BOS_EXPORT, (Object[])new Object[0]));
                return new OperationResult();
            }
            boolean isFormDB = billView.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            boolean isChange = billView.getModel().getDataChanged();
            if (isFormDB) {
                this.saveCacheForPermission(billView.getPageCache());
                billView.getPageCache().put(EXPORTPARAMETER, SerializationUtils.toJsonString((Object)this.getParameter()));
                billView.getPageCache().put(ENTITYNUMBER, this.getEntityId());
                billView.getPageCache().put("CurFormIdImport", billView.getFormShowParameter().getFormId());
                String description = this.getExportConfirmMsg(1, isChange);
                billView.showConfirm(description, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ExportListConfirmCallBack", (IConfirmCallBack)this));
            } else {
                billView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u540e\u518d\u5bfc\u51fa\u3002", (String)"ExportList_8", (String)BOS_EXPORT, (Object[])new Object[0]));
            }
            return new OperationResult();
        }
        String concurrentID = null;
        String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
        if (!StringUtils.isNotBlank((CharSequence)routeAppId) || !ServiceLookup.hasDeployedAppId((String)EXPORTAPP)) {
            ConcurrencyLimiter acquire = null;
            try {
                acquire = ConcurrencyLimiter.acquire((String)"EXPORT_LIMIT", (String)"exportListTask");
            }
            catch (AcquireFailedException e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4e86\u4fdd\u969c\u60a8\u7684\u4e1a\u52a1\u987a\u5229\uff0c\u7cfb\u7edf\u5bf9\u5bfc\u51fa\u64cd\u4f5c\u8fdb\u884c\u4e86\u9650\u6d41\u3002\u5f53\u524d\u5bfc\u51fa\u64cd\u4f5c\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u7b49\u5019\u5176\u4ed6\u7528\u6237\u5bfc\u51fa\u64cd\u4f5c\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"ExportList_17", (String)BOS_EXPORT, (Object[])new Object[0]));
                return new OperationResult();
            }
            concurrentID = acquire.getConcurrentID();
        }
        IListView listview = (IListView)this.getView();
        BillList billList = (BillList)listview.getControl(BILLLISTAP);
        int selectRows = billList.getSelectedRows().getPrimaryKeyValues().length;
        listview.getPageCache().put(EXPORTPARAMETER, SerializationUtils.toJsonString((Object)this.getParameter()));
        listview.getPageCache().put(ENTITYNUMBER, this.getEntityId());
        listview.getPageCache().put("CurFormIdImport", listview.getBillFormId());
        if (StringUtils.isNotEmpty((CharSequence)concurrentID)) {
            listview.getPageCache().put(CONCURRENTID, concurrentID);
        }
        if (selectRows == 0) {
            int billCount = ExportListUtil.getBillDataCount(billList, this.getView().getPageCache(), this.getEntityId());
            if (this.isDefaultExportListAll() && billCount > 0) {
                this.saveCacheForPermission(listview.getPageCache());
                Map customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
                String maxExportDataSize = (String)customParameterFromCache.get("EXPORT_MAX_EXPORT_DATA_SIZE");
                if (!StringUtils.isNumeric((CharSequence)maxExportDataSize)) {
                    int modeType = LicenseServiceHelper.getModeType();
                    maxExportDataSize = modeType == 2 || modeType == 4 ? String.valueOf(1000000) : String.valueOf(10000000);
                }
                Integer maxExportDataSizeInt = Integer.valueOf(maxExportDataSize);
                String showMsg = this.getExportConfirmMsg(billCount, false);
                int billDataLineCount = ExportListUtil.getBillDataLineCount(billList, this.getView().getPageCache(), this.getEntityId());
                if (billDataLineCount > maxExportDataSizeInt) {
                    showMsg = String.format(ResManager.loadKDString((String)"\u516c\u5171\u8bbe\u7f6e->\u53c2\u6570\u914d\u7f6e->\u7cfb\u7edf\u53c2\u6570->\u81ea\u5b9a\u4e49\u53c2\u6570\u4e2dEXPORT_MAX_EXPORT_DATA_SIZE\u9650\u5236\u5bfc\u51fa\u884c\u6570\u4e3a%1$s\uff0c\u5f53\u524d\u5217\u8868\u5b58\u5728%2$s\u884c\u6570\u636e\uff0c\u5c06\u65e0\u6cd5\u5168\u90e8\u5bfc\u51fa\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"ExportList_13", (String)BOS_EXPORT, (Object[])new Object[0]), maxExportDataSizeInt, billDataLineCount);
                }
                this.getView().showConfirm(showMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ExportListConfirmCallBack", (IConfirmCallBack)this));
                return new OperationResult();
            }
            if (billCount > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ExportList_12", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"ExportList_0", (String)BOS_EXPORT, (Object[])new Object[0]));
            }
        } else {
            this.export();
        }
        return new OperationResult();
    }

    private boolean isByListExport() {
        return Boolean.TRUE.equals(this.getParameter().get("byList"));
    }

    private Boolean checkOperationExist() {
        String operateType = this.getType();
        if (operateType == null) {
            log.warn("OpExistChecker.check opType is null ");
            return Boolean.TRUE;
        }
        List opMetaList = ((MetadataService)ServiceFactory.getService(MetadataService.class)).loadEntityAllOperationMeta(this.getEntityId());
        if (MapUtils.isNotEmpty((Map)this.getParameter()) && this.getParameter().get("byList") != null && ((Boolean)this.getParameter().get("byList")).booleanValue()) {
            for (String opMetaString : opMetaList) {
                Map op = (Map)SerializationUtils.fromJsonString((String)opMetaString, Map.class);
                if (!operateType.equals(op.get("type")) || !(op.get("parameter") instanceof Map) || !(((Map)op.get("parameter")).get("byList") instanceof Boolean) || !((Boolean)((Map)op.get("parameter")).get("byList")).booleanValue()) continue;
                return Boolean.TRUE;
            }
        } else {
            for (String opMetaString : opMetaList) {
                Map op = (Map)SerializationUtils.fromJsonString((String)opMetaString, Map.class);
                if (!operateType.equals(op.get("type")) || op.get("parameter") != null) continue;
                return Boolean.TRUE;
            }
        }
        String errorTips = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e0a\u6ca1\u6709\u6ca1\u6709\u8be5\u64cd\u4f5c", (String)"ExportList_16", (String)BOS_EXPORT, (Object[])new Object[0]), this.getEntityId());
        this.getView().showErrorNotification(errorTips);
        return Boolean.FALSE;
    }

    private String getExportConfirmMsg(int billNum, boolean isChanged) {
        String displayName = ResManager.loadKDString((String)"\u5355\u636e", (String)"ExportList_6", (String)BOS_EXPORT, (Object[])new Object[0]);
        MainEntityType entityType = null;
        if (this.isBillView()) {
            IBillView billView = (IBillView)this.getView();
            entityType = billView.getModel().getDataEntityType();
            displayName = this.getShowEntityName();
            if (isChanged) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d%s\u4fee\u6539\u540e\u672a\u4fdd\u5b58\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"ExportList_7", (String)BOS_EXPORT, (Object[])new Object[0]), displayName);
            }
        } else if (this.getView() instanceof IListView) {
            IListView listview = (IListView)this.getView();
            entityType = listview.getListModel().getDataEntityType();
            displayName = this.getShowEntityName();
        }
        String unit = entityType instanceof BasedataEntityType ? ResManager.loadKDString((String)"\u6761", (String)"ExportList_10", (String)BOS_EXPORT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f20", (String)"ExportList_11", (String)BOS_EXPORT, (Object[])new Object[0]);
        String message = ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%1$s%2$s%3$s\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"ExportList_3", (String)BOS_EXPORT, (Object[])new Object[0]);
        return String.format(message, billNum, unit, displayName);
    }

    private void saveCacheForPermission(IPageCache pageCache) {
        String entityId = null;
        String listName = null;
        String curFormId = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (view instanceof IListView) {
            IListView listview = (IListView)view;
            FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
            entityId = config.getEntityTypeId();
            curFormId = listview.getBillFormId();
            listName = config.getCaption().toString();
            pageCache.put("BillTypeId", "" + ((ListShowParameter)formShowParameter).getBillTypeId());
        } else if (this.isBillView()) {
            entityId = view.getEntityId();
            curFormId = view.getFormShowParameter().getFormId();
            String caption = formShowParameter.getCaption();
            listName = StringUtils.isNotBlank((CharSequence)caption) ? caption : (formShowParameter.getFormConfig() != null ? formShowParameter.getFormConfig().getCaption().toString() : "");
            pageCache.put("BillTypeId", "" + this.getView().getEntityId());
        }
        pageCache.put("ServiceAppId", formShowParameter.getServiceAppId());
        pageCache.put("CheckRightAppId", formShowParameter.getCheckRightAppId());
        pageCache.put("BillFormId", entityId);
        pageCache.put("CurFormIdImport", curFormId);
        pageCache.put("ListName", listName);
        pageCache.put("OperateKey", this.getOperateKey());
        pageCache.put("PermissionItemId", this.getPermissionItemId());
        pageCache.put("RealPermissionEntityId", this.getRealPermissionEntityId());
        ArrayList<Long> mainOrgIds = null;
        if (view instanceof IListView) {
            mainOrgIds = ((IListView)this.getView()).getSelectedMainOrgIds();
        } else if (this.mainOrgId != null) {
            mainOrgIds = new ArrayList<Long>();
            mainOrgIds.add(this.mainOrgId);
        }
        if (mainOrgIds != null && !mainOrgIds.isEmpty()) {
            pageCache.put("MainOrgIds", JSONArray.toJSONString(mainOrgIds));
        }
        pageCache.put("OperateName", this.getOperateName().toString());
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getView() == null) {
            this.releaseLimitLock();
            return;
        }
        this.setView(event.getView());
        if (event.getReturnData() == null) {
            this.releaseLimitLock();
            return;
        }
        if ("selectexporttemplate".equals(event.getActionId())) {
            try {
                this.handleCancelDataRight();
                this.handleCancelRight();
            }
            catch (KDBizException e) {
                this.getView().showErrorNotification(e.getMessage());
                this.releaseLimitLock();
                return;
            }
            if (!this.checkPermission()) {
                this.releaseLimitLock();
                return;
            }
        }
        if ("encryptexportfile".equals(event.getActionId()) && event.getReturnData() instanceof Map) {
            Map params = (Map)event.getReturnData();
            String password = params.get("password").toString();
            Long templateId = (Long)params.get("templateId");
            String entityNumber = this.getView().getPageCache().get(ENTITYNUMBER);
            if (templateId == null) {
                templateId = 0L;
            }
            this.showProgressForm(entityNumber, templateId, password, false);
            return;
        }
        Object[] templates = (Object[])event.getReturnData();
        String entitynumber = this.getView().getPageCache().get(ENTITYNUMBER);
        this.showProgressForm(entitynumber, (Long)templates[0]);
    }

    private boolean isDefaultExportListAll() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            ListUserOption listOption = listShowParameter.getListUserOption();
            if (listOption == null) {
                listOption = new ListUserOption();
            }
            return listOption.isDefaultExportListAll();
        }
        return false;
    }

    private void showSelectTemplate(QFilter customFilter, QFilter applyLayoutFilter) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_selectexporttemplate");
        showParameter.setCustomParam("TemplateType", (Object)this.getTemplateType());
        if (!this.isBillView()) {
            showParameter.setCustomParam("BillTypeId", (Object)((ListShowParameter)this.getView().getFormShowParameter()).getBillTypeId());
        } else {
            showParameter.setCustomParam("BillTypeId", (Object)((BillShowParameter)this.getView().getFormShowParameter()).getBillTypeId());
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "selectexporttemplate");
        showParameter.setCloseCallBack(closeCallBack);
        IFormView view = this.getView();
        showParameter.setCustomParam("ServiceAppId", (Object)view.getPageCache().get("ServiceAppId"));
        showParameter.setCustomParam("CheckRightAppId", (Object)view.getPageCache().get("CheckRightAppId"));
        showParameter.setCustomParam("BillFormId", (Object)view.getPageCache().get("BillFormId"));
        showParameter.setCustomParam("ListName", (Object)view.getPageCache().get("ListName"));
        showParameter.setCustomParam("OperateKey", (Object)view.getPageCache().get("OperateKey"));
        showParameter.setCustomParam("PermissionItemId", (Object)view.getPageCache().get("PermissionItemId"));
        showParameter.setCustomParam("RealPermissionEntityId", (Object)view.getPageCache().get("RealPermissionEntityId"));
        showParameter.setCustomParam("MainOrgIds", (Object)view.getPageCache().get("MainOrgIds"));
        showParameter.setCustomParam("OperateName", (Object)view.getPageCache().get("OperateName"));
        if (customFilter != null) {
            applyLayoutFilter.and(customFilter);
        }
        showParameter.setCustomParam("TemplateListAddFilter", (Object)applyLayoutFilter.toSerializedString());
        this.getView().showForm(showParameter);
    }

    private void showProgressForm(String entitynumber, long templateId) {
        this.showProgressForm(entitynumber, templateId, null, true);
    }

    private void showProgressForm(String entitynumber, long templateId, String password, boolean showEncrypt) {
        if (AttachmentManageUtil.needEncrypt((IFormView)this.getView(), (boolean)true) && showEncrypt) {
            this.showEncryptConfirm(templateId);
            this.releaseLimitLock();
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_exportdataprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map parameter = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get(EXPORTPARAMETER), Map.class);
        Map customParams = showParameter.getCustomParams();
        customParams.put("ServiceAppId", this.getView().getFormShowParameter().getServiceAppId());
        customParams.put("entitynumber", entitynumber);
        customParams.put("entityname", this.getShowEntityName());
        customParams.put("templateId", String.valueOf(templateId));
        customParams.put("fillparent", String.valueOf("EXPT".equals(this.getTemplateType())));
        customParams.put("byList", String.valueOf(parameter.get("byList")));
        customParams.put("billViewExport", this.isBillView());
        customParams.put("EXPORT_LIST_TYPE", this.getTemplateType());
        customParams.put("achieveKey", this.getAchieveKey());
        customParams.put("routeKey", this.getRouteKey());
        customParams.put("hasDownloadAttachmentPerm", this.checkAttDownloadPermission(parameter.get("byList")));
        customParams.put("password", password);
        customParams.put("PermissionItemId", this.getView().getPageCache().get("PermissionItemId"));
        if (StringUtils.isNotEmpty((CharSequence)this.getView().getPageCache().get(CONCURRENTID))) {
            customParams.put(CONCURRENTID, this.getView().getPageCache().get(CONCURRENTID));
        }
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) {
            this.releaseLimitLock();
            return;
        }
        try {
            this.handleCancelDataRight();
            this.handleCancelRight();
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            this.releaseLimitLock();
            return;
        }
        if (!this.checkPermission()) {
            this.releaseLimitLock();
            return;
        }
        this.export();
    }

    private void releaseLimitLock() {
        if (StringUtils.isNotEmpty((CharSequence)this.getView().getPageCache().get(CONCURRENTID))) {
            ConcurrencyLimiter.release((String)this.getView().getPageCache().get(CONCURRENTID));
        }
    }

    private void showEncryptConfirm(Long templateId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("bos_file_encrypt_confirm");
        showParameter.setCustomParam("encryptType", (Object)"1");
        if (null != templateId) {
            showParameter.setCustomParam("templateId", (Object)templateId);
        }
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "encryptexportfile"));
        this.getView().showForm(showParameter);
    }

    private boolean checkAttDownloadPermission(Object byList) {
        if (null != byList) {
            return false;
        }
        IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
        Optional settingOfExportAtt = exportService.getSettingOfExportAtt(this.getEntityId());
        boolean isExportAtt = settingOfExportAtt.map(item -> Boolean.valueOf((String)item.get("forattexport"))).orElse(Boolean.FALSE);
        if (!isExportAtt) {
            return true;
        }
        HashSet<String> permSet = new HashSet<String>();
        permSet.add("2NJ5XVVCMBCL");
        Map permMap = PermissionServiceHelper.checkMultiPermItemInfos((long)RequestContext.get().getCurrUserId(), (String)this.getView().getPageCache().get(ENTITYNUMBER), permSet);
        if (permMap.get("2NJ5XVVCMBCL") != null && ((Boolean)permMap.get("2NJ5XVVCMBCL")).booleanValue()) {
            return true;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s\u7684\u201c\u4e0b\u8f7d\u6587\u4ef6\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002\u6b64\u64cd\u4f5c\u5c06\u53ea\u5bfc\u51fa\u6570\u636e\uff0c\u5e76\u4e0d\u4f1a\u540c\u65f6\u5bfc\u51fa\u9644\u4ef6\u538b\u7f29\u5305\u3002", (String)"ExportList_14", (String)BOS_EXPORT, (Object[])new Object[0]), StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getCaption()) ? this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue() : this.getView().getFormShowParameter().getCaption()));
        return false;
    }

    private boolean checkPermission() {
        OperationResult result = new OperationResult();
        IFormView view = this.getView();
        String orgIdsStr = view.getPageCache().get("MainOrgIds");
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId(view.getPageCache().get("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSONObject.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId(view.getPageCache().get("RealPermissionEntityId")).setCurrentEntityId(view.getPageCache().get("BillFormId")).setOperateName(view.getPageCache().get("OperateName")).setPermissionItemId(view.getPageCache().get("PermissionItemId")).setResult(result);
        if (!this.importPermissionService.validatePermission(importPermissionParamBuidler.build())) {
            this.importPermissionService.doFailCheckRight(this.getView(), result);
            return false;
        }
        return true;
    }

    private void handleCancelRight() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCancelRight() == 0) {
            return;
        }
        FormConfig config = formShowParameter.getFormConfig();
        String formName = config.getCaption().toString();
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\"%1$s\"\u529f\u80fd\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExportList_1", (String)BOS_EXPORT, (Object[])new Object[0]), formName));
    }

    private void handleCancelDataRight() {
        if (!this.getView().getFormShowParameter().isCancelDataRight()) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExportList_2", (String)BOS_EXPORT, (Object[])new Object[0]));
    }

    private void export() {
        List pkIds;
        String entityNumber = this.getView().getPageCache().get(ENTITYNUMBER);
        String curFormId = this.getView().getPageCache().get("CurFormIdImport");
        Map parameter = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get(EXPORTPARAMETER), Map.class);
        if (Boolean.TRUE.equals(parameter.get("byList"))) {
            this.showProgressForm(entityNumber, this.getBlankTemplateId(), null, true);
            return;
        }
        Long userId = Long.parseLong(RequestContext.getOrCreate().getUserId());
        QFilter validScope = new QFilter("applyscope", "=", (Object)"0").or("creator", "=", (Object)userId).or(new QFilter("applyscope", "=", (Object)"1").and("users.fbasedataid.id", "in", (Object)userId));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("bizobject.number", "=", (Object)entityNumber));
        filters.add(new QFilter("templatetype", "=", (Object)this.getTemplateType()).and(new QFilter("enable", "=", (Object)"1")).or(new QFilter("templatetype", "is null", null)));
        filters.add(validScope);
        String appId = this.getView().getPageCache().get("CheckRightAppId");
        QFilter dataRule = DataRulePermissionUtil.getDataRule((long)RequestContext.get().getCurrUserId(), (String)appId, (String)BOS_IMPORT_TEMPLATE);
        if (dataRule != null) {
            filters.add(dataRule);
        }
        QFilter applyLayoutFilter = new QFilter("applylayout", "=", (Object)curFormId).or("applylayout", "=", (Object)"");
        filters.add(applyLayoutFilter);
        QFilter customFilter = ImportPluginUtils.fireGetTemplateCustomFilter((TemplateFilterArgs)new TemplateFilterArgs(entityNumber, curFormId), (String)entityNumber);
        if (customFilter != null) {
            filters.add(customFilter);
        }
        if ((pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)BOS_IMPORT_TEMPLATE, (QFilter[])filters.toArray(new QFilter[0]), (String)"", (int)2)).isEmpty()) {
            this.showProgressForm(entityNumber, this.getBlankTemplateId(), null, true);
            return;
        }
        if (pkIds.size() == 1) {
            this.showProgressForm(entityNumber, (Long)pkIds.get(0), null, true);
            return;
        }
        this.showSelectTemplate(customFilter, applyLayoutFilter);
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        if (this.isLogEnable()) {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            opResult.setCancelWriteLog(true);
            String msg = String.format(ResManager.loadKDString((String)"\u70b9\u51fb\u201c%s\u201d\u6309\u94ae\u6267\u884c\u6210\u529f\u3002", (String)"ExportList_15", (String)BOS_EXPORT, (Object[])new Object[0]), this.getOperateName().getLocaleValue());
            AppLogInfo logInfo = this.buildLogInfo(msg, this.mainOrgId);
            OpLogAppInfo opLogAppInfo = ImportOperationLog.getInstance().reBuildAppInfo(this.getOperateKey(), this.getOperateName(), logInfo);
            logService.addLog((AppLogInfo)opLogAppInfo);
        }
        super.afterInvokeOperation(opResult);
    }

    private String getShowEntityName() {
        String caption = this.getView().getFormShowParameter().getCaption();
        return StringUtils.isBlank((CharSequence)caption) ? this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue() : caption;
    }
}

