/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.parameter;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.parameter.AbstractImptAndExptConfigPlugin;
import kd.bos.form.plugin.parameter.ImportAndExportConfigCache;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.service.ServiceFactory;

public class ExportConfigForMultiLangPlugin
extends AbstractImptAndExptConfigPlugin {
    private static final Log log = LogFactory.getLog(ExportConfigForMultiLangPlugin.class);
    private static final String FLEXPANELAP_KEY = "flexpanelap51";
    private ImportAndExportConfigCache importAndExportConfigCache = new ImportAndExportConfigCache();

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(FLEXPANELAP_KEY);
        this.buildFieldAp(flexPanelAp.getItems());
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", FLEXPANELAP_KEY);
        mapHead.put("items", (String)flexPanelAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    private void buildFieldAp(List<ControlAp<?>> items) {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List enableLangs = service.getMultiLangEnabledLang();
        for (EnabledLang lang : enableLangs) {
            FieldAp langAp = new FieldAp();
            langAp.setKey("lang_" + lang.getNumber().toLowerCase());
            langAp.setId("lang_" + lang.getNumber().toLowerCase());
            langAp.setName(new LocaleString(lang.getName()));
            langAp.setHeight(new LocaleString("30px"));
            if (lang.isDefault.booleanValue()) {
                langAp.setLock("new,edit");
            }
            CheckBoxField langField = new CheckBoxField();
            langField.setKey("lang_" + lang.getNumber().toLowerCase());
            langField.setId("lang_" + lang.getNumber().toLowerCase());
            langField.setName(new LocaleString(lang.getName()));
            langField.setDefValue(true);
            langField.setShowStyle(2);
            langAp.setField((Field)langField);
            langAp.setFireUpdEvt(true);
            items.add((ControlAp<?>)langAp);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (e.getKey().startsWith("lang_")) {
            FieldEdit textEdit = new FieldEdit();
            textEdit.setKey(e.getKey());
            textEdit.setFieldKey(e.getKey());
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException ex) {
            log.info(ex.getMessage());
        }
        this.buildFieldProp(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void buildFieldProp(MainEntityType newMainEntityType) {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List enableLangs = service.getMultiLangEnabledLang();
        for (EnabledLang lang : enableLangs) {
            BooleanProp langProp = new BooleanProp();
            langProp.setName("lang_" + lang.getNumber().toLowerCase());
            langProp.setDisplayName(new LocaleString(lang.getName()));
            langProp.setDbIgnore(true);
            langProp.setAlias("");
            langProp.setDefValue((Object)Boolean.TRUE);
            newMainEntityType.registerSimpleProperty((DynamicSimpleProperty)langProp);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Container flexPanel = (Container)this.getView().getControl(FLEXPANELAP_KEY);
        this.buildEdit(flexPanel.getItems());
        this.getView().createControlIndex(flexPanel.getItems());
    }

    private void buildEdit(List<Control> items) {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List enableLangs = service.getMultiLangEnabledLang();
        for (EnabledLang lang : enableLangs) {
            FieldEdit fieldEdit = new FieldEdit();
            fieldEdit.setKey("lang_" + lang.getNumber().toLowerCase());
            fieldEdit.setFieldKey("lang_" + lang.getNumber().toLowerCase());
            fieldEdit.setView(this.getView());
            fieldEdit.setCaption(new LocaleString(lang.getName()));
            items.add((Control)fieldEdit);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map<String, Boolean> multilangConfig = this.importAndExportConfigCache.getMultilangConfig((String)this.getView().getFormShowParameter().getCustomParam("entityId"));
        DataEntityPropertyCollection properties = this.getView().getModel().getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            Boolean selectStatu;
            if (!property.getName().contains("lang_") || !multilangConfig.containsKey(property.getName()) || !Boolean.FALSE.equals(selectStatu = multilangConfig.get(property.getName()))) continue;
            this.getModel().setValue(property.getName(), (Object)Boolean.FALSE);
        }
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List enableLangs = service.getMultiLangEnabledLang();
        Optional<EnabledLang> defaultEnabledLang = enableLangs.stream().filter(EnabledLang::getIsDefault).findFirst();
        String propertyName = "lang_" + defaultEnabledLang.get().getNumber().toLowerCase();
        this.getModel().setValue(propertyName, (Object)Boolean.TRUE);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            this.save();
        }
    }

    private void save() {
        StringBuilder exportMultilangBuilder = new StringBuilder();
        DataEntityPropertyCollection properties = this.getView().getModel().getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (!property.getName().contains("lang_")) continue;
            Object value = property.getValue((Object)this.getModel().getDataEntity());
            boolean b = Boolean.parseBoolean(value.toString());
            exportMultilangBuilder.append(property.getName()).append(":").append(b).append(",");
        }
        if (exportMultilangBuilder.length() > 0) {
            exportMultilangBuilder.deleteCharAt(exportMultilangBuilder.length() - ",".length());
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("export_multilang", exportMultilangBuilder.toString());
        this.importAndExportConfigCache.save((String)this.getView().getFormShowParameter().getCustomParam("entityId"), params);
    }
}

