/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.TreeListBizAppsPlugin;
import kd.bos.form.util.DeleteImpExtFileUtil;
import kd.bos.form.util.LogPath;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.svc.util.ImportLogDeleteFileUtil;
import kd.bos.svc.util.TreeNodeFilter;

public class ExportLogDeleteFileTreeListPlugin
extends TreeListBizAppsPlugin {
    private static final String BOS_EXPORT = "bos-export";
    private static final String IS_FROM_LOG_MENU = "isfromlogmenu";
    private static final String BT_DELETE_DATA = "deletedata";
    private static final String BT_DELETE_FILE = "deletefile";
    private static final String IS_DELETED = "isdeleted";
    private static final String FORM_ID = "bos_exportlog";
    private static final String BIZOBJECT = "sourceobj";
    private static final String DELETE_PERM_ITEM = "4715e1f1000000ac";
    private static final Log log = LogFactory.getLog(ExportLogDeleteFileTreeListPlugin.class);

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void initializeTree(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.createRootNode();
        treeModel.setRoot(root);
        treeModel.setCurrentNodeId((Object)root.getId());
        root.setIsOpened(true);
        root.setChildren(new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_CLOUD).getCloudNodes());
    }

    protected List<TreeNode> getAppNodesBy(String cloudNodeId) {
        List treeNodes = super.getAppNodesBy(cloudNodeId);
        return new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_APP).filterAppTreeNode(treeNodes);
    }

    public void setFilter(SetFilterEvent e) {
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_APP);
        QFilter appFilter = treeNodeFilter.getAppFilter("sourceobj.bizappid.id");
        if (appFilter != null) {
            e.addCustomQFilter(appFilter);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode node = root.getTreeNode(nodeId, 20);
        QFilter filter = this.getFilter(node);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private QFilter getFilter(TreeNode node) {
        if (node == null) {
            return null;
        }
        String nodeId = node.getId();
        if (this.isTopNode(nodeId)) {
            return null;
        }
        switch ((String)node.getData()) {
            case "cloud": {
                return new QFilter(BIZOBJECT, "in", (Object)this.getBillIdInCloud(nodeId));
            }
            case "app": {
                return new QFilter(BIZOBJECT, "in", (Object)this.getBillIdInApp(nodeId));
            }
        }
        return new QFilter(BIZOBJECT, "=", (Object)nodeId);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (!ImportLogDeleteFileUtil.isFromLogMenu((FormShowParameter)this.getView().getFormShowParameter())) {
            return;
        }
        super.beforeShowBill(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        e.getParameter().getCustomParams().put(IS_FROM_LOG_MENU, formShowParameter.getCustomParam(IS_FROM_LOG_MENU));
        e.getParameter().getCustomParams().put("ParentEntityId", FORM_ID);
    }

    public void registerListener(EventObject e) {
        if (!ImportLogDeleteFileUtil.isFromLogMenu((FormShowParameter)this.getView().getFormShowParameter())) {
            return;
        }
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BT_DELETE_FILE, BT_DELETE_DATA});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        if (!ImportLogDeleteFileUtil.isFromLogMenu((FormShowParameter)this.getView().getFormShowParameter())) {
            return;
        }
        switch (itemKey = evt.getItemKey()) {
            case "deletefile": {
                this.toDeleteFile();
                break;
            }
            case "deletedata": {
                this.toDeleteFileAndData();
            }
        }
    }

    private void toDeleteFileAndData() {
        if (!ImportLogDeleteFileUtil.isCanDeleteFile()) {
            return;
        }
        if (!ImportLogDeleteFileUtil.checkDeletePermission((String)this.getView().getFormShowParameter().getAppId(), (String)FORM_ID, (String)DELETE_PERM_ITEM)) {
            String msg = ImportLogDeleteFileUtil.getNoDeletePermissionMsg((String)FORM_ID);
            this.getView().showErrorNotification(msg);
            return;
        }
        BillList billList = this.getBillList();
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (this.validateSelectCount(selectedRows)) {
            return;
        }
        String confirmMsg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ExportLogDeleteFileListPlugin_11", (String)BOS_EXPORT, (Object[])new Object[0]), selectedRows.size());
        this.getView().showConfirm(String.format(confirmMsg, selectedRows.size()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BT_DELETE_DATA, (IFormPlugin)this));
    }

    private void toDeleteFile() {
        if (!ImportLogDeleteFileUtil.isCanDeleteFile()) {
            return;
        }
        if (!ImportLogDeleteFileUtil.checkDeletePermission((String)this.getView().getFormShowParameter().getAppId(), (String)FORM_ID, (String)DELETE_PERM_ITEM)) {
            String msg = ImportLogDeleteFileUtil.getNoDeletePermissionMsg((String)FORM_ID);
            this.getView().showErrorNotification(msg);
            return;
        }
        BillList billList = this.getBillList();
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (this.validateSelectCount(selectedRows)) {
            return;
        }
        String confirmMsg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u4e2d\u7684\u6587\u4ef6\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ExportLogDeleteFileListPlugin_7", (String)BOS_EXPORT, (Object[])new Object[0]);
        this.getView().showConfirm(String.format(confirmMsg, selectedRows.size()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BT_DELETE_FILE, (IFormPlugin)this));
    }

    private boolean validateSelectCount(ListSelectedRowCollection selectedRows) {
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ExportLogDeleteFileListPlugin_5", (String)BOS_EXPORT, (Object[])new Object[0]));
            return true;
        }
        if (selectedRows.size() > 1000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8d85\u8fc71000\u884c\u9650\u5236\u3002", (String)"ExportLogDeleteFileListPlugin_6", (String)BOS_EXPORT, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        if (!ImportLogDeleteFileUtil.isFromLogMenu((FormShowParameter)this.getView().getFormShowParameter())) {
            return;
        }
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "deletefile": {
                this.confirmDeleteFile(messageBoxClosedEvent);
                break;
            }
            case "deletedata": {
                this.confirmDeleteFileAndData(messageBoxClosedEvent);
            }
        }
    }

    private void confirmDeleteFileAndData(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (result != MessageBoxResult.Yes) {
            return;
        }
        this.deleteSelectFileAndData();
        this.getBillList().refreshData();
        this.getBillList().clearSelection();
    }

    private void confirmDeleteFile(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (result != MessageBoxResult.Yes) {
            return;
        }
        Map<Object, DynamicObject> logObjMap = this.getDynamicObjectMap();
        this.deleteSelectFile(logObjMap);
    }

    private void deleteSelectFile(Map<Object, DynamicObject> logObjMap) {
        if (logObjMap == null) {
            return;
        }
        ArrayList<DynamicObject> needUpdateLogDynS = new ArrayList<DynamicObject>(16);
        List<LogPath> logPaths = DeleteImpExtFileUtil.collectPathsAndNeedUpdateLogS(logObjMap.values().toArray(new DynamicObject[0]), needUpdateLogDynS, false);
        if (CollectionUtils.isEmpty(logPaths)) {
            String msg = ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u5220\u9664\u3002", (String)"ExportLogPlugin_0", (String)BOS_EXPORT, (Object[])new Object[0]);
            this.getView().showTipNotification(msg, Integer.valueOf(3000));
            return;
        }
        if (!CollectionUtils.isEmpty(logPaths)) {
            String bizAppId = ImportLogDeleteFileUtil.getBizAppId((String)this.getView().getFormShowParameter().getAppId(), (String)FORM_ID);
            Set<Object> failDeletePks = DeleteImpExtFileUtil.deleteFileInFileServer(logPaths, true, ResManager.loadKDString((String)"\u5220\u9664\u6587\u4ef6", (String)"ExportLogDeleteFileListPlugin_15", (String)BOS_EXPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u5220\u9664\u6587\u4ef6\u6210\u529f\u3002", (String)"ExportLogDeleteFileListPlugin_16", (String)BOS_EXPORT, (Object[])new Object[0]), FORM_ID, bizAppId);
            DeleteImpExtFileUtil.updateDeletedLogS(needUpdateLogDynS, failDeletePks);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ExportLogDeleteFileListPlugin_12", (String)BOS_EXPORT, (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private Map<Object, DynamicObject> getDynamicObjectMap() {
        if (!ImportLogDeleteFileUtil.checkDeletePermission((String)this.getView().getFormShowParameter().getAppId(), (String)FORM_ID, (String)DELETE_PERM_ITEM)) {
            String msg = ImportLogDeleteFileUtil.getNoDeletePermissionMsg((String)FORM_ID);
            this.getView().showErrorNotification(msg);
            return null;
        }
        BillList billList = this.getBillList();
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        Map logObjMap = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (String)FORM_ID);
        if (CollectionUtils.isEmpty((Map)logObjMap)) {
            return null;
        }
        return logObjMap;
    }

    private void deleteSelectFileAndData() {
        Map<Object, DynamicObject> logObjMap = this.getDynamicObjectMap();
        if (logObjMap == null) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)FORM_ID);
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])logObjMap.keySet().toArray());
        List<LogPath> logPaths = DeleteImpExtFileUtil.collectPathsAndNeedUpdateLogS(logObjMap.values().toArray(new DynamicObject[0]), new ArrayList<DynamicObject>(), false);
        if (!CollectionUtils.isEmpty(logPaths)) {
            DeleteImpExtFileUtil.deleteFileInFileServer(logPaths, false, null, null, null, null);
        }
        String bizAppId = ImportLogDeleteFileUtil.getBizAppId((String)this.getView().getFormShowParameter().getAppId(), (String)FORM_ID);
        for (DynamicObject logObj : logObjMap.values()) {
            ImportLogDeleteFileUtil.createAppLog((String)FORM_ID, (String)bizAppId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664", "ExportLogDeleteFileListPlugin_13", BOS_EXPORT), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7%s\uff0c\u5bfc\u51fa\u7ed3\u679c\u548c\u5bfc\u51fa\u6587\u4ef6\u5220\u9664\u6210\u529f\u3002", "ExportLogDeleteFileListPlugin_17", BOS_EXPORT), (String[])new String[]{String.valueOf(logObj.get("billno"))});
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ExportLogDeleteFileListPlugin_12", (String)BOS_EXPORT, (Object[])new Object[0]), Integer.valueOf(3000));
    }

    private BillList getBillList() {
        return (BillList)this.getControl("billlistap");
    }
}

