/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.FileSource;
import kd.bos.svc.util.FileServerUtil;
import kd.bos.util.FileNameUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.FilenameUtils;

public class ExportCsvWriter {
    public static final String CSV = ".csv";
    public static final String TIME_FORMAT = "yyyyMMdd";
    public static final String FORMAT_STR = "/%s/%s/%s/%s/%s";
    public static final String UTF8 = "UTF-8";
    private CSVPrinter csvPrinter;
    private File csvFile;
    private final String[] headNames;
    private final Charset charset;
    private final MainEntityType mainEntityType;
    private static final int MAX_FILE_NAME_LENGTH = 50;
    public static final int MAX_ROW_SIZE = 10000000;
    private final String BOS_EXPORT = "bos-export";
    protected static Log log = LogFactory.getLog(ExportCsvWriter.class);

    @Deprecated
    public ExportCsvWriter(String[] headNames, Charset charset, MainEntityType mainEntityType) {
        if (headNames == null || headNames.length == 0) {
            log.error("CSV\u8868\u5934\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"CSV\u8868\u5934\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExportToCsv_0", (String)"bos-export", (Object[])new Object[0]));
        }
        if (mainEntityType == null) {
            log.error("CSV\u5355\u636e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"CSV\u5355\u636e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExportToCsv_1", (String)"bos-export", (Object[])new Object[0]));
        }
        if (charset == null) {
            charset = Charset.forName(UTF8);
        }
        this.headNames = headNames;
        this.charset = charset;
        this.mainEntityType = mainEntityType;
        this.initCsvUtil(UUID.randomUUID().toString(), new File(UUID.randomUUID().toString() + "dir"));
    }

    public ExportCsvWriter(String[] headNames, Charset charset, MainEntityType mainEntityType, String fileName, File saveDir) {
        if (headNames == null || headNames.length == 0) {
            log.error("CSV\u8868\u5934\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"CSV\u8868\u5934\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExportToCsv_0", (String)"bos-export", (Object[])new Object[0]));
        }
        if (mainEntityType == null) {
            log.error("CSV\u5355\u636e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"CSV\u5355\u636e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExportToCsv_1", (String)"bos-export", (Object[])new Object[0]));
        }
        if (charset == null) {
            charset = Charset.forName(UTF8);
        }
        this.headNames = headNames;
        this.charset = charset;
        this.mainEntityType = mainEntityType;
        this.initCsvUtil(fileName, saveDir);
    }

    private void initCsvUtil(String fileName, File saveDir) {
        try {
            this.csvFile = File.createTempFile(FilenameUtils.getName((String)fileName), CSV, saveDir);
            PrintWriter printWriter = new PrintWriter(this.csvFile, this.charset.displayName());
            byte[] bs = new byte[]{-17, -69, -65};
            printWriter.append(new String(bs));
            this.csvPrinter = CSVFormat.EXCEL.withHeader(this.headNames).print((Appendable)printWriter);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"CSV\u6807\u9898\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExportListTask_1", (String)"bos-export", (Object[])new Object[0]));
        }
    }

    public void lists2csv(List<List<Object>> rowsData) throws IOException {
        if (rowsData == null) {
            return;
        }
        for (List<Object> rowData : rowsData) {
            this.csvPrinter.printRecord(rowData);
        }
    }

    public void list2csv(Object[] rowData) throws IOException {
        if (rowData == null) {
            return;
        }
        this.csvPrinter.printRecord(rowData);
    }

    public void flush() throws IOException {
        this.csvPrinter.flush();
    }

    public void close() throws IOException {
        this.csvPrinter.close();
    }

    public String upload(String fileName) throws IOException {
        String string;
        FileService service = FileServiceFactory.getAttachmentFileService();
        RequestContext ctx = RequestContext.getOrCreate();
        fileName = this.inciseFileName(fileName);
        String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)this.mainEntityType.getAppId(), (String)(this.mainEntityType.getName() + Uuid8.generateShortUuid()), (String)(fileName + CSV));
        FileInputStream fis = null;
        try {
            String url;
            fis = new FileInputStream(this.csvFile);
            string = url = service.upload((FileItem)FileServerUtil.createFileItem((String)fileName, (String)path, (InputStream)fis, (FileSource)FileSource.EXCEL_EXPORT));
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeClose(fis);
                throw throwable;
            }
        }
        FileSecurityUtil.safeClose((Closeable)fis);
        return string;
    }

    private String inciseFileName(String fileName) {
        if (fileName.length() <= 50) {
            return fileName;
        }
        int trimLength = fileName.length() - 50;
        int suffixIndex = fileName.lastIndexOf(46);
        String suffix = fileName.substring(suffixIndex);
        fileName = fileName.substring(0, fileName.length() - trimLength - suffix.length()) + suffix;
        return fileName;
    }

    public File getCsvFile() {
        return this.csvFile;
    }
}

