/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.attachment.FileTypeEnum;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.bill.IBillView;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ExchangeRateProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.export.po.ExportFileInfo;
import kd.bos.export.util.ExportListUtil;
import kd.bos.export.util.ExportZipMaker;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.field.ExRateConfigUtil;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.util.ExportLogUtil;
import kd.bos.lang.Lang;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListViewPluginProxy;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mservice.svc.attach.IAttachmentModelProxy;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.mvc.export.ExportDataContext;
import kd.bos.mvc.export.ExportModelTypeEnum;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.export.ExportProgressImpl;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.mvc.export.ListExporter;
import kd.bos.mvc.export.dataconvert.ExportDataConvert;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.form.IFormController;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.QueryBuilderFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.svc.util.FileHandlerUtil;
import kd.bos.svc.util.PermissionParam;
import kd.bos.url.UrlService;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.ReflectUtil;

public class ExportDataTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ExportDataTask.class);
    public static final String CUSTPARAM_CONTEXT = "requestcontext";
    public static final String CUSTPARAM_PARENTPAGEID = "parentpageid";
    public static final String CUSTPARAM_BYLIST = "byList";
    public static final String CUSTPARAM_EXPTTYPE = "expttype";
    public static final String CUSTPARAM_ENTITYNAME = "entityname";
    public static final String CUSTPARAM_ENTITYNUMBER = "entitynumber";
    public static final String CUSTPARAM_TEMPLATEID = "templateId";
    public static final String CUSTPARAM_FILLPARENT = "fillparent";
    private static final String SYS_PARAM_EXPORT_MOTHED = "exportdatatask.exportmothed";
    private static final String EXPORT_MOTHED_TO_JSONARRAY = "tojson";
    private static final String EXPORT_MOTHED_TO_EXCEL = "toexcel";
    private static final String EXPORT_MOTHED_BOTH = "both";
    private static final String BOS_EXPORT = "bos-export";
    private static final String ACHIEVE_KEY = "achieveKey";
    private static final String ROUTE_KEY = "routeKey";
    private static final String TWO_PLACEHOLDER = "%s_%s";
    protected String archiveKey;
    protected String routeKey;
    private Map<String, Object> params = new HashMap<String, Object>();
    private ExportProgress exportProgress;
    private IFormView parentView;
    private BillEntityType mainType;
    private BillEntityType subMainType;
    private ExportDataContext context;
    private List<Object> allPkIds;
    private int total;
    private ExportWriterFormat formator;
    private ListDataExporter exporter;
    private ExportDataConvert exportDataConvert;
    private ExportTimer exportTimer = new ExportTimer();
    private DynamicObject exportLogObj;
    private BeforeQueryOfExportEvent beforeQueryEventArgs;
    protected ExportFileEvent exportEventArgs;
    private Boolean isFillParent;
    private Boolean isExptType;
    private Boolean isExportCsv;
    private static final IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
    private Boolean isExportPictureProp;
    private Integer exportPicturePropNameType;
    private Boolean isExportAttAndPanelProp;
    private Integer exportAttNameType;
    protected static Pattern FileNamePattern = Pattern.compile("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]");
    protected static Pattern BlankPattern = Pattern.compile(" ");

    public IFormView getParentView() {
        if (this.parentView == null) {
            String parentPageId = (String)this.params.get(CUSTPARAM_PARENTPAGEID);
            if (StringUtils.isBlank((CharSequence)parentPageId)) {
                return null;
            }
            this.parentView = SessionManager.getCurrent().getView(parentPageId);
            IFormController srv = (IFormController)this.parentView.getService(IFormController.class);
            srv.registerListener();
        }
        return this.parentView;
    }

    public boolean isDefaultExportListAll() {
        ListShowParameter showParameter = (ListShowParameter)this.getParentView().getFormShowParameter();
        if (showParameter == null) {
            return false;
        }
        ListUserOption listOption = showParameter.getListUserOption();
        if (listOption == null) {
            listOption = new ListUserOption();
        }
        return listOption.isDefaultExportListAll();
    }

    public BillList getBillList() {
        BillList billList = (BillList)this.getParentView().getControl("billlistap");
        if (StringUtils.isNotEmpty((CharSequence)this.archiveKey)) {
            billList.getListModel().setAchiveKey(this.archiveKey);
            billList.getContext().setArchiveKey(this.archiveKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.routeKey)) {
            billList.getListModel().setRouteKey(this.routeKey);
            billList.getContext().setRouteKey(this.routeKey);
        }
        return billList;
    }

    public FilterContainer getFilterContainer() {
        return (FilterContainer)this.getParentView().getControl("filtercontainerap");
    }

    public String getEntityNumber() {
        return (String)this.getParams().get(CUSTPARAM_ENTITYNUMBER);
    }

    public String getExportSuspendCacheKey() {
        String taskId = StringUtils.isNotBlank((CharSequence)this.taskId) ? "_" + this.taskId : "";
        return "EXPT_SUSPEND_" + this.getEntityNumber() + taskId;
    }

    public IAppCache getExportSuspendAppCache() {
        return AppCache.get((String)EntityMetadataCache.getDataEntityType((String)this.getEntityNumber()).getAppId());
    }

    public String getListCaption() {
        return (String)this.getParams().get(CUSTPARAM_ENTITYNAME);
    }

    public BillEntityType getMainType() {
        if (this.mainType == null) {
            String entityNumber = this.getEntityNumber();
            this.mainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (this.mainType instanceof QueryEntityType) {
                this.mainType = (BillEntityType)((QueryEntityType)this.mainType).getMainEntityType();
            }
        }
        return this.mainType;
    }

    public ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new ExportProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    private long getTemplateId() {
        Object templateId = this.getParams().getOrDefault(CUSTPARAM_TEMPLATEID, 0L);
        return templateId instanceof Long ? (Long)templateId : Long.valueOf(String.valueOf(templateId));
    }

    private boolean isExptType() {
        if (this.isExptType != null) {
            return this.isExptType;
        }
        Optional<ExportModelTypeEnum> exportModelType = this.getExportModelType();
        if (exportModelType.isPresent() && exportModelType.get() == ExportModelTypeEnum.MODEL_FOR_EXPT) {
            this.isExptType = true;
            return true;
        }
        this.isExptType = false;
        return false;
    }

    private boolean isFillParent() {
        if (this.isFillParent != null) {
            return this.isFillParent;
        }
        Object entityNumber = this.getParams().get(CUSTPARAM_ENTITYNUMBER);
        if (entityNumber == null) {
            this.isFillParent = false;
            return false;
        }
        IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
        Optional<ExportModelTypeEnum> exportModelType = this.getExportModelType();
        if (exportModelType.isPresent() && exportModelType.get() == ExportModelTypeEnum.MODEL_FOR_IMPT) {
            Optional autoFullSuperInfoAtImportTemplate = exportService.getSettingOfAutoFullSuperInfoAtImportTemplate(entityNumber.toString());
            if (autoFullSuperInfoAtImportTemplate.isPresent()) {
                this.isFillParent = (Boolean)autoFullSuperInfoAtImportTemplate.get();
                return this.isFillParent;
            }
            this.isFillParent = false;
            return false;
        }
        if (exportModelType.isPresent() && exportModelType.get() == ExportModelTypeEnum.MODEL_FOR_EXPT) {
            Optional autoFullSuperInfoAtExportTemplate = exportService.getSettingOfAutoFullSuperInfoAtExportTemplate(entityNumber.toString());
            if (autoFullSuperInfoAtExportTemplate.isPresent()) {
                this.isFillParent = (Boolean)autoFullSuperInfoAtExportTemplate.get();
                return this.isFillParent;
            }
            this.isFillParent = true;
            return true;
        }
        this.isFillParent = false;
        return false;
    }

    private Optional<ExportModelTypeEnum> getExportModelType() {
        Object exportListType = this.getParams().get("EXPORT_LIST_TYPE");
        if (exportListType == null) {
            return Optional.empty();
        }
        if ("IMPT".equals(exportListType.toString())) {
            return Optional.of(ExportModelTypeEnum.MODEL_FOR_IMPT);
        }
        if ("EXPT".equals(exportListType.toString())) {
            return Optional.of(ExportModelTypeEnum.MODEL_FOR_EXPT);
        }
        return Optional.empty();
    }

    private boolean getByList() {
        String byList = this.getParams().get(CUSTPARAM_BYLIST).toString();
        if (StringUtils.isBlank((CharSequence)byList)) {
            return false;
        }
        return Boolean.parseBoolean(byList);
    }

    public String getExptType() {
        if (this.getParams().containsKey(CUSTPARAM_EXPTTYPE)) {
            return (String)this.getParams().get(CUSTPARAM_EXPTTYPE);
        }
        return this.getParams().get("EXPORT_LIST_TYPE").equals("EXPT") ? "3" : "2";
    }

    protected Boolean isExportCsv() {
        if (this.isExportCsv == null) {
            this.isExportCsv = this.isExportCsvFromCache();
        }
        return this.isExportCsv;
    }

    protected Boolean isExportCsvFromCache() {
        Object entityNumber = this.getParams().get(CUSTPARAM_ENTITYNUMBER);
        if (StringUtils.isBlank((Object)entityNumber)) {
            return Boolean.FALSE;
        }
        Optional exportCsvConfig = this.isExptType() ? exportService.getSettingOfIsCsvFileAtExportTemplate(entityNumber.toString()) : exportService.getSettingOfIsCsvFileAtList(entityNumber.toString());
        return exportCsvConfig.orElse(Boolean.FALSE);
    }

    public DynamicObject getExportLogObj() {
        return this.exportLogObj;
    }

    private String getExportMothed() {
        return System.getProperty(SYS_PARAM_EXPORT_MOTHED, EXPORT_MOTHED_TO_EXCEL);
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDBizException {
        IFormView parentView;
        if (params != null) {
            this.params.putAll(params);
            Object custCtx = params.get(CUSTPARAM_CONTEXT);
            if (custCtx instanceof RequestContext) {
                RequestContext.set((RequestContext)((RequestContext)custCtx));
            } else if (custCtx != null) {
                RequestContext reqctx = (RequestContext)JSONObject.parseObject((String)custCtx.toString(), RequestContext.class);
                RequestContext.set((RequestContext)reqctx);
            }
        }
        if (params != null && params.get(ACHIEVE_KEY) != null) {
            this.archiveKey = params.get(ACHIEVE_KEY).toString();
        }
        if (params != null && params.get(ROUTE_KEY) != null) {
            this.routeKey = params.get(ROUTE_KEY).toString();
        }
        if (!((parentView = this.getParentView()) instanceof IListView) && !(parentView instanceof IBillView)) {
            this.getExportProgress().fail(ResManager.loadKDString((String)"\u7236\u5217\u8868\u5df2\u7ecf\u5173\u95ed\uff0c\u65e0\u6cd5\u83b7\u53d6\u9700\u8981\u5bfc\u51fa\u7684\u5355\u636e\u3002", (String)"ExportDataTask_0", (String)BOS_EXPORT, (Object[])new Object[0]));
            return;
        }
        this.exportLogObj = this.buildExportLogObj();
        boolean success = false;
        try (EntityTraceSpan entityTraceSpan = EntityTracer.create((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"exportByData");){
            this.export();
            success = true;
        }
        catch (Throwable e) {
            log.error(e);
            String errMsg = null;
            if (e instanceof KDException) {
                errMsg = e.getMessage();
            } else if (SystemParamServiceHelper.isShowStackTrace()) {
                errMsg = ListExporter.formatException(e);
            }
            if (StringUtils.isBlank((CharSequence)errMsg)) {
                errMsg = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ExportDataTask_1", (String)BOS_EXPORT, (Object[])new Object[0]);
            }
            this.exportLogObj.set("logs", (Object)errMsg);
            throw new KDBizException(e, new ErrorCode("exportdataerror", ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5f02\u5e38", (String)"ExportDataTask_2", (String)BOS_EXPORT, (Object[])new Object[0])), new Object[0]);
        }
        finally {
            ExportLogUtil.saveExportLog(this.exportLogObj);
            this.getExportProgress().feedbackLogId(this.exportLogObj.getPkValue());
            this.getExportProgress().complete();
            if (this.getParams().get("concurrentID") != null && StringUtils.isNotEmpty((CharSequence)this.getParams().get("concurrentID").toString())) {
                ConcurrencyLimiter.release((String)this.getParams().get("concurrentID").toString());
            }
            log.debug(this.exportTimer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() throws Exception {
        try {
            this.formator = this.loadExportFormat();
            this.context = this.buildContext();
            this.allPkIds = this.getAllPkIds();
            this.total = this.allPkIds.size();
            this.exportLogObj.set("total", (Object)this.total);
            this.context.setAllPkIds(this.allPkIds);
            Set<String> selectFields = this.getListSelectColumns();
            this.context.setSelectFields(selectFields);
            this.subMainType = this.buildExportSubType();
            ArrayList<ExportWriterFormat> formats = new ArrayList<ExportWriterFormat>();
            formats.add(this.formator);
            this.context.setSubMainType(this.subMainType);
            this.context.setFormats(formats);
            if (this.context.getExportAttPropAndPanel().booleanValue() && this.context.getFormats() != null && this.context.getFormats().size() > 0) {
                List<ExportWriterFormat> exportWriterEntryFormats = this.context.getFormats().get((int)0).next;
                Set attachmentPanelS = exportWriterEntryFormats.stream().filter(ExportWriterFormat::isAttachPanel).map(item -> item.name).collect(Collectors.toSet());
                this.context.getAttachmentPanelS().addAll(attachmentPanelS);
            }
            String appId = ShowFormHelper.getBizAppId((FormShowParameter)this.getParentView().getFormShowParameter());
            FieldControlRules fieldControlRules = this.getFieldControlRules(appId, this.context.getMainEntityType().getName());
            this.context.setFieldControlRules(fieldControlRules);
            this.getExportProgress().feedbackProgress(this.total, 0);
            String defaultFileName = this.genListDataExportFileName();
            this.exportEventArgs = new ExportFileEvent(this.getParentView(), this.getMainType(), defaultFileName);
            SensitiveArgs sensitiveArgs = new SensitiveArgs((Object)this);
            AbstractListViewPluginProxy proxy = this.getListPluginProxy();
            if (proxy != null) {
                proxy.fireBeforeExportFile((BeforeExportFileEvent)this.exportEventArgs);
                proxy.fireBeforeDesensitive(sensitiveArgs);
                this.context.setSensitiveArgs(sensitiveArgs);
            }
            this.exporter = new ListDataExporter("sheet1", formats, this.exportEventArgs.getCustomHeaderMap(), this.isExptType(), this.mainType.getName());
            this.context.setExcelWriter(this.exporter);
            FormatObject format = FormatFactory.getFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
            this.context.setFormatObject(format);
            this.context.setApplyMaterialPrecision(FmtInfoUtils.applyMaterialPrecision());
            if (this.isExportCsv().booleanValue() && this.isExptType()) {
                this.exportCsv();
            } else {
                this.exportDatas();
            }
        }
        finally {
            if (null != this.exporter && null != this.exporter.wb) {
                this.exporter.wb.dispose();
            }
        }
    }

    public void exportCsv() {
        String fileUrl;
        int complete = 0;
        int rowIndex = 1;
        List<List<Object>> pkIdGroups = this.splitBatch(this.allPkIds, this.formator);
        for (List<Object> subPkIds : pkIdGroups) {
            if (this.getExportSuspendAppCache().get(this.getExportSuspendCacheKey(), String.class) != null) {
                this.getExportSuspendAppCache().remove(this.getExportSuspendCacheKey());
                return;
            }
            List<DynamicObject> dynamicObjects = this.load(subPkIds);
            HashMap<Object, List<Map<String, Object>>> attachArr = new HashMap<Object, List<Map<String, Object>>>();
            if (this.context.getExportAttPropAndPanel().booleanValue() && this.context.getAttachmentPanelS().size() > 0) {
                this.loadAttachment(dynamicObjects, attachArr, this.context.getAttachmentPanelS());
                this.context.getAttachArr().putAll(attachArr);
            }
            rowIndex = this.toCsvFile(dynamicObjects, rowIndex);
            this.exportLogObj.set("complete", (Object)(complete += subPkIds.size()));
            boolean isDataCompletedButFileOrPicNot = (this.isExportAttAndPanelProp != false || this.isExportPictureProp != false) && complete == this.total;
            this.getExportProgress().feedbackProgress(this.total, isDataCompletedButFileOrPicNot ? complete - 1 : complete);
        }
        ArrayList<ExportFileInfo> fileList = new ArrayList<ExportFileInfo>(1);
        try {
            String csvFileUrl = this.exportDataConvert.flushToLocal();
            ExportFileInfo csvFileInfo = new ExportFileInfo();
            csvFileInfo.setUrl(csvFileUrl);
            fileList.add(csvFileInfo);
            this.addPictureAndAttZip(fileList, this.context.getSaveDir());
            fileUrl = this.getFinalUrl(this.exporter, this.getMainType(), fileList, this.exportEventArgs.getFileName());
            this.getExportProgress().feedbackProgress(this.total, this.total);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51faCSV\u6587\u4ef6\u6570\u636e\u5f02\u5e38\u3002", (String)"ExportDataTask_9", (String)BOS_EXPORT, (Object[])new Object[0]));
        }
        this.parseDownloadUrl(fileUrl);
    }

    private List<List<Object>> splitBatch(List<Object> allPKIds, ExportWriterFormat exportColFormats) {
        Date beginTime = new Date();
        int billBatchSize = 1000;
        int rowBatchSize = 100000;
        int maxRowSize = 10000000;
        ArrayList<List<Object>> pkIdGroups = new ArrayList<List<Object>>(1);
        int allRowCount = 0;
        int rowCount = 0;
        ArrayList<Object> oneBatchPKIds = new ArrayList<Object>(billBatchSize);
        ArrayList<Object> otherPKIds = new ArrayList<Object>(allPKIds);
        while (!otherPKIds.isEmpty()) {
            if (this.getExportSuspendAppCache().get(this.getExportSuspendCacheKey(), String.class) != null) {
                this.getExportSuspendAppCache().remove(this.getExportSuspendCacheKey());
                return new ArrayList<List<Object>>();
            }
            List<Object> subPkIds = otherPKIds.subList(0, Math.min(otherPKIds.size(), billBatchSize));
            Map<Object, Integer> billRowCounts = this.getMaxEntryRowCount(subPkIds, this.subMainType);
            for (int i = 0; i < subPkIds.size(); ++i) {
                Object pkId = subPkIds.get(i);
                Integer billRowCount = billRowCounts.get(pkId);
                if (billRowCount == null) {
                    billRowCount = 1;
                }
                if ((allRowCount += billRowCount.intValue()) > maxRowSize) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faCSV\u6587\u4ef6\u6700\u5927\u884c\u6570\u9650\u523610000000\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ListDataExporter_10", (String)BOS_EXPORT, (Object[])new Object[0]), maxRowSize));
                }
                if (billRowCount >= rowBatchSize) {
                    if (!oneBatchPKIds.isEmpty()) {
                        pkIdGroups.add(oneBatchPKIds);
                        oneBatchPKIds = new ArrayList(1);
                    }
                    oneBatchPKIds.add(pkId);
                    pkIdGroups.add(oneBatchPKIds);
                    oneBatchPKIds = new ArrayList(billBatchSize);
                    rowCount = 0;
                } else {
                    oneBatchPKIds.add(pkId);
                    rowCount += billRowCount.intValue();
                }
                if (rowCount < rowBatchSize && oneBatchPKIds.size() < billBatchSize) continue;
                pkIdGroups.add(oneBatchPKIds);
                oneBatchPKIds = new ArrayList(billBatchSize);
                rowCount = 0;
            }
            subPkIds.clear();
        }
        if (!oneBatchPKIds.isEmpty()) {
            pkIdGroups.add(oneBatchPKIds);
        }
        this.exportTimer.addTimeSplitBatch(beginTime);
        return pkIdGroups;
    }

    private Object safeConvert(int dbType, Object value) {
        if (null == value) {
            return null;
        }
        if (12 == dbType || -9 == dbType || 1 == dbType) {
            return value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    private void exportDatas() throws Exception {
        HashMap<Object, List<Map<String, Object>>> attachArr = new HashMap<Object, List<Map<String, Object>>>();
        List<ExportFileInfo> fileList = this.splitFile(this.allPkIds, this.formator);
        File saveDir = this.context.getSaveDir();
        if (CollectionUtils.isEmpty(fileList = this.splitBatchWriteToExcel(fileList, attachArr))) {
            return;
        }
        this.addPictureAndAttZip(fileList, saveDir);
        String url = this.getFinalUrl(this.exporter, this.getMainType(), fileList, this.exportEventArgs.getFileName());
        this.getExportProgress().feedbackProgress(this.total, this.total);
        this.parseDownloadUrl(url);
    }

    private void addPictureAndAttZip(List<ExportFileInfo> fileList, File saveDir) {
        if (this.isExportPictureProp().booleanValue() && MapUtils.isNotEmpty(this.context.getExportPictureMessageMap())) {
            String pictureZipUrl = ExportZipMaker.batchDownloadPictureOrAtt(FileTypeEnum.IMAGE, this.context.getExportPictureMessageMap(), this.getMainType().getDisplayName().getLocaleValue(), saveDir, null);
            ExportFileInfo pictureFileInfo = new ExportFileInfo();
            pictureFileInfo.setUrl(pictureZipUrl);
            fileList.add(pictureFileInfo);
        }
        if (this.isExportAttAndPanelProp().booleanValue() && MapUtils.isNotEmpty(this.context.getExportAttMessageMap())) {
            String attZipUrl = ExportZipMaker.batchDownloadPictureOrAtt(FileTypeEnum.ATTACHMENT, this.context.getExportAttMessageMap(), this.getMainType().getDisplayName().getLocaleValue(), saveDir, this.context.getAttZipFileName());
            ExportFileInfo attFileInfo = new ExportFileInfo();
            attFileInfo.setUrl(attZipUrl);
            fileList.add(attFileInfo);
        }
    }

    private List<ExportFileInfo> splitBatchWriteToExcel(List<ExportFileInfo> fileList, Map<Object, List<Map<String, Object>>> attachArr) throws Exception {
        int rowIndex = this.isExptType() ? 1 : 4;
        boolean firstBatch = true;
        int complete = 0;
        String exportMothed = this.getExportMothed();
        for (ExportFileInfo fileInfo : fileList) {
            boolean isNewFile = true;
            for (List<Object> subPkIds : fileInfo.getPkIdGroups()) {
                this.context.setBigBillComplete(fileInfo.getBigBillComplete());
                if (this.getExportSuspendAppCache().get(this.getExportSuspendCacheKey(), String.class) != null) {
                    this.getExportSuspendAppCache().remove(this.getExportSuspendCacheKey());
                    return new ArrayList<ExportFileInfo>();
                }
                List<DynamicObject> objs = this.load(subPkIds);
                if (this.context.getExportAttPropAndPanel().booleanValue() && this.context.getAttachmentPanelS().size() > 0) {
                    this.loadAttachment(objs, attachArr, this.context.getAttachmentPanelS());
                    this.context.getAttachArr().putAll(attachArr);
                }
                if (StringUtils.equals((CharSequence)exportMothed, (CharSequence)EXPORT_MOTHED_TO_JSONARRAY) || StringUtils.equals((CharSequence)exportMothed, (CharSequence)EXPORT_MOTHED_BOTH)) {
                    boolean existAttachments = firstBatch && !attachArr.isEmpty() && !this.isFillParent();
                    rowIndex = this.toExcelBySerTool(objs, rowIndex, existAttachments);
                }
                if (!StringUtils.equals((CharSequence)exportMothed, (CharSequence)EXPORT_MOTHED_TO_JSONARRAY)) {
                    rowIndex = this.toExcelByLocalTool(objs, rowIndex, attachArr, isNewFile);
                }
                if (fileInfo.getBigBillComplete().booleanValue()) {
                    this.exportLogObj.set("complete", (Object)(complete += subPkIds.size()));
                    boolean isDataCompletedButFileOrPicNot = (this.isExportAttAndPanelProp != false || this.isExportPictureProp != false) && complete == this.total;
                    this.getExportProgress().feedbackProgress(this.total, isDataCompletedButFileOrPicNot ? complete - 1 : complete);
                }
                firstBatch = false;
                isNewFile = false;
            }
            this.creatSensitiveFieldsSheet();
            this.exporter.clear();
            String url = this.exporter.flushToLocal(this.getListPluginProxy(), this.exportEventArgs, this.context.getSaveDir());
            fileInfo.setUrl(url);
            this.subMainType = this.buildExportSubType();
            ArrayList<ExportWriterFormat> formats = new ArrayList<ExportWriterFormat>();
            formats.add(this.formator);
            this.exporter = new ListDataExporter("sheet1", formats, this.isExptType(), this.mainType.getName());
            this.context.setSubMainType(this.subMainType);
            this.context.setFormats(formats);
            this.context.setExcelWriter(this.exporter);
            rowIndex = this.isExptType() ? 1 : 4;
        }
        return fileList;
    }

    private void creatSensitiveFieldsSheet() {
        if (this.isExptType()) {
            return;
        }
        SXSSFSheet sensitiveSheet = this.exporter.wb.createSheet("sensitive_fields_sheet");
        sensitiveSheet.setRandomAccessWindowSize(-1);
        Set<String> sensitiveFields = this.context.getSensitiveFields();
        int index = 0;
        for (String sensitiveField : sensitiveFields) {
            SXSSFRow row = sensitiveSheet.createRow(index);
            SXSSFCell cell = row.createCell(0);
            cell.setCellValue(sensitiveField);
            ++index;
        }
        int sheetIndex = this.exporter.wb.getSheetIndex("sensitive_fields_sheet");
        if (sheetIndex >= 0) {
            this.exporter.wb.setSheetHidden(sheetIndex, true);
        }
    }

    @Deprecated
    private int toExcelBySerTool(List<DynamicObject> objs, int rowIndex, boolean existAttachments) throws Exception {
        Date beginTime = new Date();
        String json = SerializationUtils.toJsonString(objs);
        JSONArray jsonArr = JSONArray.parseArray((String)json);
        if (!objs.isEmpty()) {
            ArrayList<DynamicObject> lstMainOrg = new ArrayList<DynamicObject>();
            for (DynamicObject obj : objs) {
                MainOrgProp mainOrgProp = this.subMainType.getMainOrgProperty();
                lstMainOrg.add(mainOrgProp == null ? null : (DynamicObject)mainOrgProp.getValueFast((Object)obj));
            }
            for (int i = 0; i < jsonArr.size(); ++i) {
                DynamicObject mainOrg = (DynamicObject)lstMainOrg.get(i);
                this.exporter.handleData(jsonArr.getJSONObject(i), (DynamicObjectType)this.subMainType, mainOrg);
            }
            DynamicObjectCollection coll = new DynamicObjectCollection((DynamicObjectType)this.subMainType, null, objs);
            this.exporter.formatData(coll, this.subMainType, jsonArr);
        }
        for (int i = 0; i < objs.size(); ++i) {
            int offset = this.exporter.writeData(jsonArr.getJSONObject(i), rowIndex, this.formator, existAttachments, this.exportEventArgs.getFileName(), this.isFillParent());
            if (offset > 1) {
                rowIndex += offset;
                continue;
            }
            ++rowIndex;
        }
        this.exportTimer.addTimeBySerTool(beginTime);
        return rowIndex;
    }

    private FieldControlRules getFieldControlRules(String appId, String formId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, appId, formId);
        if (fieldControlRules == null || fieldControlRules.getFieldControlRuleDtos() == null || fieldControlRules.getFieldControlRuleDtos().isEmpty()) {
            return null;
        }
        return fieldControlRules;
    }

    private int toExcelByLocalTool(List<DynamicObject> objs, int rowIndex, Map<Object, List<Map<String, Object>>> attachArr, boolean isNewFile) throws Exception {
        Date beginTime = new Date();
        if (this.exportDataConvert == null || isNewFile) {
            this.exportDataConvert = new ExportDataConvert(this.context, ExportFileType.Excel);
            this.exportDataConvert.setExportProgress(this.exportProgress);
            this.exportDataConvert.setTotal(this.total);
            this.exportDataConvert.setAttachArr(attachArr);
        }
        int currRowIndex = rowIndex;
        int rowCount = this.exportDataConvert.export(objs.toArray(new DynamicObject[0]), currRowIndex);
        this.exportDataConvert.getExportResult();
        objs.clear();
        objs = null;
        this.exportTimer.addTimeByLocalTool(beginTime);
        return currRowIndex + rowCount;
    }

    private int toCsvFile(List<DynamicObject> objs, int rowIndex) {
        Date beginTime = new Date();
        this.context.setFileName(this.exportEventArgs.getFileName());
        if (this.exportDataConvert == null) {
            this.exportDataConvert = new ExportDataConvert(this.context, ExportFileType.CsvFile);
        }
        this.exportDataConvert.setExportProgress(this.exportProgress);
        this.exportDataConvert.setTotal(this.total);
        int currRowIndex = rowIndex;
        int rowCount = this.exportDataConvert.export(objs.toArray(new DynamicObject[0]), currRowIndex);
        this.exportTimer.addTimeByLocalTool(beginTime);
        objs.clear();
        return currRowIndex + rowCount;
    }

    private void parseDownloadUrl(String fileUrl) {
        Object encryptPassword;
        BillEntityType dataEntityType;
        DynamicObject dataEntity;
        String attachId;
        boolean checkFilePermission = ((IAttachmentService)ServiceFactory.getService(IAttachmentService.class)).checkFilePermission();
        String entityNum = this.context.getMainEntityType().getName();
        String appId = EntityMetadataCache.getDataEntityType((String)entityNum).getAppId();
        if (checkFilePermission) {
            String logEntityNum = "bos_exportlog";
            Object logPkId = this.context.getLogId();
            String fileType = "";
            String permissionItemId = this.getParams().get("PermissionItemId") == null ? null : this.getParams().get("PermissionItemId").toString();
            attachId = PermissionParam.genAttacId((String)appId, (String)entityNum, (String)logEntityNum, (Object)logPkId, (String)fileType, (String)permissionItemId);
        } else {
            attachId = this.context.getLogId() + "@bos_exportlog";
            attachId = Base64.getEncoder().encodeToString(attachId.getBytes(StandardCharsets.UTF_8));
        }
        fileUrl = UrlService.getAttachmentFullUrl((String)fileUrl);
        String downloadUrl = UrlService.getDomainContextUrl() + "/attachment/download.do?attachId=";
        downloadUrl = downloadUrl + attachId + "&fId=" + this.getEntityNumber() + "&appId=" + appId;
        if (this.context.isBillViewExport() && (dataEntity = this.getParentView().getModel().getDataEntity()).containsProperty((dataEntityType = this.getBillEntitytype(true)).getBillNo())) {
            downloadUrl = downloadUrl + "&billNo=" + this.getParentView().getModel().getValue(this.getMainType().getBillNo());
        }
        if (StringUtils.isNotBlank((Object)(encryptPassword = this.getParams().get("password")))) {
            downloadUrl = downloadUrl + "&password=" + encryptPassword;
        }
        this.getExportProgress().feedbackFileUrl(downloadUrl);
        this.exportLogObj.set("downloadurl", (Object)fileUrl);
    }

    private void loadAttachment(List<DynamicObject> objs, Map<Object, List<Map<String, Object>>> attachArr, Set<String> attachmentPanelS) {
        ArrayList<Object> pkIds = new ArrayList<Object>(10);
        for (DynamicObject obj : objs) {
            int dbType = obj.getDataEntityType().getPrimaryKey().getDbType();
            Object pkValue = this.safeConvert(dbType, obj.getPkValue());
            pkIds.add(pkValue);
        }
        IAttachmentModelProxy attachmentModel = (IAttachmentModelProxy)ServiceFactory.getService(IAttachmentModelProxy.class);
        Set attachPkIds = attachmentModel.filterExistAttachmentByExport(this.subMainType.getName(), new HashSet(pkIds));
        pkIds.removeIf(pk -> !attachPkIds.contains(pk.toString()));
        Object[] attachPkIdsArr = attachPkIds.toArray(new Object[0]);
        for (String attachmentPanel : attachmentPanelS) {
            Map attachments = AttachmentServiceHelper.getAttachmentsByExport((String)this.subMainType.getName(), (Object[])attachPkIdsArr, (String)attachmentPanel);
            attachArr.putAll(attachments);
        }
    }

    protected List<Object> getAllPkIds() {
        Object[] selectIdsArr;
        List listPkIds;
        Map customParameterFromCache;
        String maxExportDataSize;
        Date beginTime = new Date();
        BillList billList = this.getBillList();
        if (this.context != null && this.context.isBillViewExport()) {
            ArrayList<Object> pkIdList = new ArrayList<Object>();
            pkIdList.add(this.getParentView().getModel().getValue("id"));
            return pkIdList;
        }
        FilterContainer filterContainer = this.getFilterContainer();
        if (filterContainer != null) {
            filterContainer.refresh();
        }
        IListModel listModel = ((IListView)this.getParentView()).getListModel();
        listModel.setNeedKeyFields(true);
        listModel.setListFields(billList.getListFields());
        IListDataProvider provider = listModel.getProvider();
        FilterParameter filterParameter = billList.generalFilterParameter();
        boolean isRegisterProperty = this.isRegisterProperty(provider);
        QueryBuilder qb = QueryBuilderFactory.createQueryBuilder((IListDataProvider)provider, (int)0, (int)1, (provider.isCustomListDataProvider() && provider instanceof ListDataProvider && !isRegisterProperty ? 1 : 0) != 0);
        qb.setFilters(filterParameter.getQFilters().toArray(new QFilter[0]));
        if (StringUtils.isNotBlank((CharSequence)filterParameter.getOrderBy())) {
            qb.setOrderBys(filterParameter.getOrderBy());
        }
        Set<String> selectFields = this.getListSelectColumns();
        this.beforeQueryEventArgs = this.fireBeforeQueryEvent(selectFields, qb.getOrderBys(), qb.getFilters());
        String orderBy = this.beforeQueryEventArgs.getOrderBys();
        if (orderBy != null && orderBy.trim().equals(",")) {
            orderBy = " ";
        }
        if (!StringUtils.isNumeric((CharSequence)(maxExportDataSize = (String)(customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam())).get("EXPORT_MAX_EXPORT_DATA_SIZE")))) {
            maxExportDataSize = String.valueOf(10000000);
        }
        try (ArchiveRoute mr = ArchiveRoute.mapRoute((String)billList.getContext().getRouteKey(), (String)billList.getContext().getArchiveKey());){
            listPkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (IDataEntityType)qb.getEntityType(), (QFilter[])this.beforeQueryEventArgs.getFilters(), (String)orderBy, (int)Integer.parseInt(maxExportDataSize));
        }
        if (!this.checkIsExportAll() && (selectIdsArr = billList.getSelectedRows().getPrimaryKeyValues()) != null && selectIdsArr.length != 0) {
            ArrayList<Object> selectedIds = new ArrayList<Object>(selectIdsArr.length);
            Collections.addAll(selectedIds, selectIdsArr);
            selectedIds.sort((o1, o2) -> {
                int io1 = listPkIds.indexOf(o1);
                int io2 = listPkIds.indexOf(o2);
                if (io1 != -1) {
                    io1 = selectedIds.size() - io1;
                }
                if (io2 != -1) {
                    io2 = selectedIds.size() - io2;
                }
                return io2 - io1;
            });
            return selectedIds;
        }
        if (!this.isDefaultExportListAll()) {
            return new ArrayList<Object>(0);
        }
        this.exportTimer.addTimeGetAllPKIds(beginTime);
        LinkedHashSet set = new LinkedHashSet(listPkIds);
        listPkIds.clear();
        listPkIds.addAll(set);
        return listPkIds;
    }

    protected boolean isRegisterProperty(IListDataProvider provider) {
        Object isRegisterPropertyObj = null;
        try {
            isRegisterPropertyObj = ReflectUtil.getField((Object)provider, (String)"isRegisterProperty");
        }
        catch (BuildException e) {
            log.info("[ExportDataTask\uff1a\u53cd\u5c04\u83b7\u53d6\u5217\u6807\u63a7\u4ef6probider#isRegisterProperty\u5c5e\u6027\u5931\u8d25]");
        }
        if (isRegisterPropertyObj instanceof Boolean) {
            return (Boolean)isRegisterPropertyObj;
        }
        return false;
    }

    private boolean checkIsExportAll() {
        BillList billList = this.getBillList();
        AbstractGrid.GridState state = billList.getEntryState();
        boolean isSelectAll = state.isSelectAllRows();
        if (!isSelectAll) {
            return false;
        }
        int selectRowSize = billList.getSelectedRows().size();
        int sysParamListMaxLimit = ExportListUtil.getSysParamListMaxLimit(this.getEntityNumber());
        int billDataCount = ExportListUtil.getBillDataCount(billList, this.getParentView().getPageCache(), this.getEntityNumber());
        if (billDataCount < sysParamListMaxLimit) {
            return selectRowSize >= billDataCount;
        }
        return selectRowSize >= sysParamListMaxLimit;
    }

    private List<ExportFileInfo> splitFile(List<Object> allPKIds, ExportWriterFormat exportColFormats) {
        Date beginTime = new Date();
        int billBatchSize = 1000;
        int rowBatchSize = 100000;
        int curBatchRowCount = 0;
        int curFileRowCount = 0;
        long totalRowCount = 0L;
        ArrayList<Object> curBatchPKIds = new ArrayList<Object>(billBatchSize);
        ArrayList<List<Object>> pkIdGroups = new ArrayList<List<Object>>(1);
        ArrayList<ExportFileInfo> fileList = new ArrayList<ExportFileInfo>(1);
        ArrayList<Object> otherPKIds = new ArrayList<Object>(allPKIds);
        while (!otherPKIds.isEmpty()) {
            Map<Object, Integer> billRowCounts;
            if (this.getExportSuspendAppCache().get(this.getExportSuspendCacheKey(), String.class) != null) {
                this.getExportSuspendAppCache().remove(this.getExportSuspendCacheKey());
                return new ArrayList<ExportFileInfo>();
            }
            List<Object> subPkIds = otherPKIds.subList(0, Math.min(otherPKIds.size(), billBatchSize));
            if ((totalRowCount += (long)this.getCurrentBatchTotalRow(subPkIds, billRowCounts = this.getMaxEntryRowCount(subPkIds, this.subMainType))) > 10000000L) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51fa\u7cfb\u7edf\u6700\u5927\u884c\u6570\u9650\u5236\uff1a%s\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ExportDataTask_8", (String)BOS_EXPORT, (Object[])new Object[0]), 10000000));
            }
            for (int i = 0; i < subPkIds.size(); ++i) {
                boolean bigBill;
                Object pkId = subPkIds.get(i);
                Integer billRowCount = billRowCounts.getOrDefault(pkId, 1);
                if (billRowCount == 0) {
                    billRowCount = 1;
                }
                boolean bl = bigBill = billRowCount >= rowBatchSize || billRowCount >= ExportFileInfo.maxFileRowSize;
                if (bigBill) {
                    if (billRowCount >= ExportFileInfo.maxFileRowSize) {
                        if (CollectionUtils.isNotEmpty(curBatchPKIds)) {
                            pkIdGroups.add(curBatchPKIds);
                            fileList.add(this.createExportFileInfo(pkIdGroups, Boolean.TRUE));
                            curFileRowCount = 0;
                            curBatchPKIds = new ArrayList(billBatchSize);
                            pkIdGroups = new ArrayList(1);
                            curBatchRowCount = 0;
                        }
                        int fileCount = ExportFileInfo.getFileCount(billRowCount);
                        for (int j = 0; j < fileCount; ++j) {
                            curBatchPKIds.add(pkId);
                            pkIdGroups.add(curBatchPKIds);
                            boolean bigBillComplete = j == fileCount - 1;
                            fileList.add(this.createExportFileInfo(pkIdGroups, bigBillComplete));
                            curFileRowCount = 0;
                            pkIdGroups = new ArrayList(1);
                            curBatchPKIds = new ArrayList(billBatchSize);
                            curBatchRowCount = 0;
                        }
                        continue;
                    }
                    if (!curBatchPKIds.isEmpty()) {
                        pkIdGroups.add(curBatchPKIds);
                        curBatchPKIds = new ArrayList(1);
                    }
                    curBatchPKIds.add(pkId);
                    pkIdGroups.add(curBatchPKIds);
                    curBatchPKIds = new ArrayList(billBatchSize);
                    curBatchRowCount = 0;
                    curFileRowCount += billRowCount.intValue();
                    continue;
                }
                curBatchRowCount += billRowCount.intValue();
                if ((curFileRowCount += billRowCount.intValue()) > ExportFileInfo.maxFileRowSize) {
                    pkIdGroups.add(curBatchPKIds);
                    fileList.add(this.createExportFileInfo(pkIdGroups, Boolean.TRUE));
                    curFileRowCount = billRowCount;
                    curBatchPKIds = new ArrayList(billBatchSize);
                    pkIdGroups = new ArrayList(1);
                    curBatchRowCount = billRowCount;
                }
                curBatchPKIds.add(pkId);
                if (curBatchRowCount < rowBatchSize && curBatchPKIds.size() < billBatchSize) continue;
                pkIdGroups.add(curBatchPKIds);
                curBatchPKIds = new ArrayList(billBatchSize);
                curBatchRowCount = 0;
            }
            subPkIds.clear();
        }
        if (CollectionUtils.isNotEmpty(curBatchPKIds)) {
            pkIdGroups.add(curBatchPKIds);
        }
        if (CollectionUtils.isNotEmpty(pkIdGroups)) {
            fileList.add(this.createExportFileInfo(pkIdGroups, Boolean.TRUE));
        }
        this.exportTimer.addTimeSplitBatch(beginTime);
        return fileList;
    }

    private Map<Object, Integer> getMaxEntryRowCount(List<Object> subPkIds, BillEntityType subMainType) {
        if (StringUtils.isEmpty((CharSequence)subMainType.getAlias()) || subMainType.getPrimaryKey() == null || StringUtils.isEmpty((CharSequence)subMainType.getPrimaryKey().getAlias())) {
            return new HashMap<Object, Integer>();
        }
        Map allEntities = subMainType.getAllEntities();
        HashMap<EntryType, List<SubEntryType>> entryTypeMap = new HashMap<EntryType, List<SubEntryType>>();
        for (EntityType entityType : allEntities.values()) {
            if (StringUtils.isEmpty((CharSequence)entityType.getAlias()) || entityType.getPrimaryKey() == null || StringUtils.isEmpty((CharSequence)entityType.getPrimaryKey().getAlias())) continue;
            if (entityType instanceof SubEntryType && entityType.getParent() instanceof EntryType) {
                entryTypeMap.computeIfAbsent((EntryType)entityType.getParent(), i -> new ArrayList()).add((SubEntryType)entityType);
                continue;
            }
            if (entityType instanceof SubEntryType || entityType instanceof MainEntityType) continue;
            entryTypeMap.putIfAbsent((EntryType)entityType, new ArrayList());
        }
        LinkedHashMap<Object, Integer> entryRowCount = new LinkedHashMap<Object, Integer>(subPkIds.size());
        this.batchCountExcelRow(subPkIds, subMainType, entryTypeMap, entryRowCount);
        return entryRowCount;
    }

    private Map<Object, Integer> batchCountExcelRow(List<Object> subPkIds, BillEntityType subMainType, Map<EntryType, List<SubEntryType>> entryTypeMap, Map<Object, Integer> entryRowCount) {
        if (subPkIds.size() > 10000) {
            ArrayList<Object> copyPKIds = new ArrayList<Object>(subPkIds);
            while (true) {
                List<Object> oneBatchPkList = copyPKIds.subList(0, Math.min(10000, copyPKIds.size()));
                if (copyPKIds.size() == 0) break;
                Map<Object, Integer> curBatchRowCount = this.batchCountExcelRow(oneBatchPkList, subMainType, entryTypeMap, entryRowCount);
                entryRowCount.putAll(curBatchRowCount);
                oneBatchPkList.clear();
            }
            return entryRowCount;
        }
        for (Map.Entry<EntryType, List<SubEntryType>> entryTypeListEntry : entryTypeMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)entryTypeListEntry.getValue())) {
                Map<Object, Integer> entryRowCountTmp = this.getEntryRowCount(subPkIds, (EntityType)entryTypeListEntry.getKey());
                this.reBuildMapValue(entryRowCount, entryRowCountTmp);
                continue;
            }
            if (entryTypeListEntry.getValue().size() < 1) continue;
            this.countWitchSubEntry(subMainType, subPkIds, entryTypeListEntry.getKey(), entryTypeListEntry.getValue(), entryRowCount);
        }
        return entryRowCount;
    }

    private void countWitchSubEntry(BillEntityType subMainType, List<Object> subPkIds, EntryType key, List<SubEntryType> value, Map<Object, Integer> entryRowCount) {
        boolean isLongPKType = subMainType.getPrimaryKey() instanceof LongProp;
        String mainEntityPkAlias = subMainType.getPrimaryKey().getAlias();
        if (value.size() == 1) {
            this.countRowCountWithOneSubEntry(subMainType, subPkIds, key, value, entryRowCount, isLongPKType, mainEntityPkAlias);
            return;
        }
        this.countEntryRowWithMulSubEntry(subMainType, subPkIds, key, value, entryRowCount, isLongPKType, mainEntityPkAlias);
    }

    private void countEntryRowWithMulSubEntry(BillEntityType subMainType, List<Object> subPkIds, EntryType key, List<SubEntryType> value, Map<Object, Integer> entryRowCount, boolean isLongPKType, String mainEntityPkAlias) {
        String subEntryAlias;
        int i;
        StringBuilder sqlBuilder = new StringBuilder();
        String entryPkAlias = key.getPrimaryKey().getAlias();
        String entryAlias = key.getAlias();
        sqlBuilder.append("SELECT ").append(mainEntityPkAlias).append(',');
        for (i = 0; i < value.size(); ++i) {
            subEntryAlias = value.get(i).getAlias();
            sqlBuilder.append(" SUM((CASE WHEN count").append(i).append(" = 0 THEN 1 ELSE count").append(i).append(" end)) as ").append(subEntryAlias).append("_sum,");
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append(" FROM (SELECT a.").append(mainEntityPkAlias).append(',');
        for (i = 0; i < value.size(); ++i) {
            subEntryAlias = value.get(i).getAlias();
            sqlBuilder.append("(SELECT COUNT(b.").append(entryPkAlias).append(") FROM ").append(subEntryAlias).append(" b where b.").append(entryPkAlias).append(" = a.").append(entryPkAlias).append(") as count").append(i).append(',');
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append(" FROM ").append(entryAlias).append(" a");
        sqlBuilder.append(" WHERE a.").append(mainEntityPkAlias).append(" in(? ");
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FID0", isLongPKType ? -5 : 12, subPkIds.get(0)));
        for (int i2 = 1; i2 < subPkIds.size(); ++i2) {
            sqlBuilder.append(",?");
            params.add(new SqlParameter(":FID0" + String.valueOf(i2), isLongPKType ? -5 : 12, subPkIds.get(i2)));
        }
        sqlBuilder.append("))t");
        sqlBuilder.append(" GROUP BY ").append(mainEntityPkAlias);
        Map<Object, Integer> tmpMap = this.execSqlForCountRow(subPkIds, subMainType.getDBRouteKey(), params, isLongPKType, sqlBuilder, value.size() + 1);
        this.reBuildMapValue(entryRowCount, tmpMap);
    }

    private void countRowCountWithOneSubEntry(BillEntityType subMainType, List<Object> subPkIds, EntryType key, List<SubEntryType> value, Map<Object, Integer> entryRowCount, boolean isLongPKType, String mainEntityPkAlias) {
        StringBuilder sqlBuilder = new StringBuilder();
        String entryPkAlias = key.getPrimaryKey().getAlias();
        String subEntryAlias = value.get(0).getAlias();
        String subEntryPkAlias = value.get(0).getPrimaryKey().getAlias();
        String entryAlias = key.getAlias();
        sqlBuilder.append("SELECT a.").append(mainEntityPkAlias).append(',');
        sqlBuilder.append("count(1)").append(' ');
        sqlBuilder.append("FROM  ").append(entryAlias).append(" a LEFT JOIN ");
        sqlBuilder.append(subEntryAlias).append(" b ON a.").append(entryPkAlias).append(" = b.").append(entryPkAlias).append(' ');
        sqlBuilder.append("WHERE a.");
        sqlBuilder.append(mainEntityPkAlias).append(" in (?");
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FID0", isLongPKType ? -5 : 12, subPkIds.get(0)));
        for (int i = 1; i < subPkIds.size(); ++i) {
            sqlBuilder.append(",?");
            params.add(new SqlParameter(":FID0" + String.valueOf(i), isLongPKType ? -5 : 12, subPkIds.get(i)));
        }
        sqlBuilder.append(')');
        sqlBuilder.append(" GROUP BY a.").append(mainEntityPkAlias);
        Map<Object, Integer> tmpMap = this.execSqlForCountRow(subPkIds, subMainType.getDBRouteKey(), params, isLongPKType, sqlBuilder, 2);
        this.reBuildMapValue(entryRowCount, tmpMap);
    }

    private void reBuildMapValue(Map<Object, Integer> entryRowCount, Map<Object, Integer> tmpMap) {
        tmpMap.forEach((k, v) -> {
            Integer oldCount = (Integer)entryRowCount.get(k);
            if (oldCount == null || v > oldCount) {
                entryRowCount.put(k, (Integer)v);
            }
        });
    }

    private int getCurrentBatchTotalRow(List<Object> subPkIds, Map<Object, Integer> billRowCounts) {
        int currentBatchTotalRow = 0;
        for (Object subPkId : subPkIds) {
            int tmp = billRowCounts.getOrDefault(subPkId, 1);
            if (tmp == 0) {
                tmp = 1;
            }
            currentBatchTotalRow += tmp;
        }
        return currentBatchTotalRow;
    }

    private ExportFileInfo createExportFileInfo(List<List<Object>> pkIdGroups, boolean bigBillComplete) {
        ExportFileInfo fileInfo = new ExportFileInfo();
        fileInfo.setPkIdGroups(pkIdGroups);
        fileInfo.setBigBillComplete(bigBillComplete);
        return fileInfo;
    }

    @Deprecated
    protected Map<Object, Integer> getEntryRowCount(List<Object> subPKIds, BillEntityType billEntityType, EntityType entryType, EntityType subEntityType) {
        if (entryType == null || StringUtils.isBlank((CharSequence)entryType.getAlias()) || entryType.getPrimaryKey() == null || StringUtils.isBlank((CharSequence)entryType.getPrimaryKey().getAlias()) || billEntityType.getPrimaryKey() == null || StringUtils.isBlank((CharSequence)billEntityType.getPrimaryKey().getAlias())) {
            return new HashMap<Object, Integer>();
        }
        HashMap<EntryType, List<SubEntryType>> entryTypeListMap = new HashMap<EntryType, List<SubEntryType>>();
        if (null == subEntityType) {
            entryTypeListMap.put((EntryType)entryType, null);
        } else {
            ArrayList<SubEntryType> subEntryTypes = new ArrayList<SubEntryType>(1);
            subEntryTypes.add((SubEntryType)subEntityType);
            entryTypeListMap.put((EntryType)entryType, subEntryTypes);
        }
        LinkedHashMap<Object, Integer> entryRowCount = new LinkedHashMap<Object, Integer>(subPKIds.size());
        this.batchCountExcelRow(subPKIds, billEntityType, entryTypeListMap, entryRowCount);
        return entryRowCount;
    }

    private Map<Object, Integer> execSqlForCountRow(final List<Object> subPKIds, String dbRouteKey, List<SqlParameter> params, final boolean isLongPKType, StringBuilder sql, final int reslutCount) {
        Map billRowCounts;
        ResultSetHandler<Map<Object, Integer>> action = new ResultSetHandler<Map<Object, Integer>>(){

            public Map<Object, Integer> handle(ResultSet rs) throws Exception {
                HashMap<Object, Integer> rowCounts = new HashMap<Object, Integer>(subPKIds.size());
                while (rs.next()) {
                    Integer subEntryRowCount = 0;
                    Object id = null;
                    for (int i = 1; i <= reslutCount; ++i) {
                        if (i == 1) {
                            id = isLongPKType ? Long.valueOf(rs.getLong(1)) : rs.getString(1);
                            continue;
                        }
                        Integer rowCount = rs.getInt(i);
                        if (rowCount <= subEntryRowCount) continue;
                        subEntryRowCount = rowCount;
                    }
                    rowCounts.put(id, subEntryRowCount);
                }
                return rowCounts;
            }
        };
        String tableName = this.getMainType().getAlias();
        String pkFieldName = this.getMainType().getPrimaryKey().getAlias();
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)tableName, (HintCondition[])new HintCondition[]{new HintCondition(pkFieldName, FilterType.in_range, subPKIds)});){
            billRowCounts = (Map)DB.query((DBRoute)new DBRoute(dbRouteKey), (String)sql.toString(), (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        }
        return billRowCounts;
    }

    private Map<Object, Integer> getEntryRowCount(final List<Object> subPKIds, EntityType entryType) {
        IDataEntityType mainEntityType = entryType.getParent();
        HashMap<Object, Integer> billRowCounts = new HashMap(subPKIds.size());
        final boolean isLongPKType = mainEntityType.getPrimaryKey() instanceof LongProp;
        StringBuilder sBuilder = new StringBuilder();
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder.append("SELECT ").append(mainEntityType.getPrimaryKey().getAlias()).append(',');
        sBuilder.append("count(").append(entryType.getPrimaryKey().getAlias()).append(')').append(' ');
        sBuilder.append("FROM  ").append(entryType.getAlias()).append(' ');
        sBuilder.append("WHERE ");
        sBuilder.append(mainEntityType.getPrimaryKey().getAlias()).append(" in (? ");
        params.add(new SqlParameter(":FID0", isLongPKType ? -5 : 12, subPKIds.get(0)));
        for (int i = 1; i < subPKIds.size(); ++i) {
            sBuilder.append(",?");
            params.add(new SqlParameter(":FID0" + String.valueOf(i), isLongPKType ? -5 : 12, subPKIds.get(i)));
        }
        sBuilder.append(')');
        sBuilder.append(" GROUP BY ").append(mainEntityType.getPrimaryKey().getAlias());
        ResultSetHandler<Map<Object, Integer>> action = new ResultSetHandler<Map<Object, Integer>>(){

            public Map<Object, Integer> handle(ResultSet rs) throws Exception {
                HashMap<Object, Integer> rowCounts = new HashMap<Object, Integer>(subPKIds.size());
                while (rs.next()) {
                    Object id = isLongPKType ? Long.valueOf(rs.getLong(1)) : rs.getString(1);
                    Integer rowCount = rs.getInt(2);
                    rowCounts.put(id, rowCount);
                }
                return rowCounts;
            }
        };
        String tableName = this.getMainType().getAlias();
        String pkFieldName = this.getMainType().getPrimaryKey().getAlias();
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)tableName, (HintCondition[])new HintCondition[]{new HintCondition(pkFieldName, FilterType.in_range, subPKIds)});){
            billRowCounts = (Map)DB.query((DBRoute)new DBRoute(mainEntityType.getDBRouteKey()), (String)sBuilder.toString(), (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        }
        return billRowCounts;
    }

    private ExportDataContext buildContext() {
        long templateId = this.getTemplateId();
        boolean fillParent = this.isFillParent();
        BillList billList = this.getBillList();
        boolean billViewExport = (Boolean)this.getParams().get("billViewExport");
        BillEntityType mainEntityType = this.getBillEntitytype(billViewExport);
        String mainEntityDisplayName = mainEntityType.getDisplayName().toString();
        String readOriginalNumString = System.getProperty("import.readOriginalNum", Boolean.toString(false));
        Boolean readOriginalNum = Boolean.parseBoolean(readOriginalNumString);
        ExportDataContext expCtx = new ExportDataContext().setLogId(this.exportLogObj.getPkValue()).setMainEntityDisplayName(mainEntityDisplayName).setExptType(this.getExptType()).setBillList(billList).setMainEntityType(mainEntityType).setOrderby("").setFillParent(fillParent).setTemplateId(templateId).setListPageId(this.getParentView().getPageId()).setReadOriginalNum(readOriginalNum);
        File saveDir = FileHandlerUtil.createSaveDir((String)"data_excel_writer");
        expCtx.setSaveDir(saveDir);
        expCtx.setBillViewExport(billViewExport);
        expCtx.setExportPictureProp(this.isExportPictureProp());
        expCtx.setExportPictureType(this.exportPictureNameType());
        Boolean exportAttAndPanelProp = this.isExportAttAndPanelProp();
        expCtx.setExportAttPropAndPanel(this.isExportAttAndPanelProp());
        expCtx.setExportAttType(this.exportAttNameType());
        expCtx.setAttZipFileName(ExportZipMaker.genAttZipFileName(this.getMainType().getDisplayName().getLocaleValue()));
        Map<String, String> dateFieldFormatMapping = this.getExportFormat(this.formator);
        expCtx.setDateFieldFormatMapping(dateFieldFormatMapping);
        return expCtx;
    }

    private Map<String, String> getExportFormat(ExportWriterFormat formator) {
        HashMap<String, String> dateFieldFormatMapping = new HashMap<String, String>();
        for (Map<String, Object> prop : formator.properties.values()) {
            if (!prop.containsKey("InputFormat")) continue;
            dateFieldFormatMapping.put((String)prop.get("propName"), prop.get("InputFormat").toString());
        }
        if (formator.next != null) {
            for (int i = 0; i < formator.next.size(); ++i) {
                ExportWriterFormat nextformator = formator.next.get(i);
                dateFieldFormatMapping.putAll(this.getExportFormat(nextformator));
            }
        }
        return dateFieldFormatMapping;
    }

    private BillEntityType getBillEntitytype(boolean billViewExport) {
        BillEntityType billEntityType = billViewExport ? (BillEntityType)this.getParentView().getModel().getDataEntityType() : (BillEntityType)this.getBillList().getEntityType();
        return billEntityType;
    }

    private DynamicObject buildExportLogObj() {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject obj = (DynamicObject)objType.createInstance();
        obj.set("bizobject", (Object)this.getListCaption());
        obj.set("billstatus", (Object)"C");
        obj.set("exportstatus", (Object)"0");
        obj.set("createtime", (Object)TimeServiceHelper.now());
        obj.set("creator", (Object)RequestContext.get().getUserId());
        obj.set(CUSTPARAM_EXPTTYPE, (Object)this.getExptType());
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber("bos_exportlog", obj, null);
        obj.set("billno", (Object)billno);
        obj.set("id", (Object)DBServiceHelper.genGlobalLongId());
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            obj.set("sourceObj_id", (Object)entityNumber);
        }
        return obj;
    }

    private ExportWriterFormat loadExportFormat() {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter(this.getEntityNumber(), this.getTemplateId(), null, null);
        List formats = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
        ExportWriterFormat format = (ExportWriterFormat)formats.get(0);
        return format;
    }

    protected Set<String> getListSelectColumns() {
        BillEntityType mainType = this.getMainType();
        List<String> list = this.getListFields();
        HashSet<String> selectFields = new HashSet<String>(list);
        for (String fieldKey : list) {
            IDataEntityProperty prop = (IDataEntityProperty)mainType.getAllFields().get(fieldKey);
            if (prop instanceof ExchangeRateProp) {
                if (!ExRateConfigUtil.isEnableExRatePrecisionControl()) continue;
                selectFields.add(((ExchangeRateProp)prop).getOriginalCurrencyFieldKey());
                selectFields.add(((ExchangeRateProp)prop).getTargetCurrencyFieldKey());
                continue;
            }
            if (prop instanceof DecimalProp) {
                String controlPropName = ((DecimalProp)prop).getControlPropName();
                if (!StringUtils.isNotBlank((CharSequence)controlPropName)) continue;
                selectFields.add(controlPropName);
                continue;
            }
            if (!(prop instanceof LargeTextProp)) continue;
            selectFields.add(fieldKey + "_tag");
        }
        String mainOrgKey = mainType.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrgKey)) {
            selectFields.add(mainOrgKey);
        }
        return selectFields;
    }

    protected List<String> getListFields() {
        return this.formator.listFields(new ArrayList<String>());
    }

    private BillEntityType buildExportSubType() {
        HashSet<String> selectFields = new HashSet<String>(16);
        String[] fields = this.context.isBillViewExport() ? this.getListSelectColumns().toArray(new String[0]) : StringUtils.split((String)this.beforeQueryEventArgs.getSelectFields(), (String)",");
        for (String field : fields) {
            if (!StringUtils.isNotBlank((CharSequence)field)) continue;
            selectFields.add(field);
        }
        if (this.isExportPictureProp().booleanValue() && this.exportPictureNameType() == 1 || this.isExportAttAndPanelProp().booleanValue() && this.exportAttNameType() == 1) {
            selectFields.add(this.mainType.getBillNo());
        }
        BillEntityType subMainType = (BillEntityType)this.mainType.getSubEntityType(selectFields);
        return subMainType;
    }

    private String genListDataExportFileName() {
        long templateId = this.getTemplateId();
        DynamicObject templateData = templateId > 0L ? BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"bos_importtemplate") : null;
        String fileName = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_", (String)"ExportDataTask_5", (String)BOS_EXPORT, (Object[])new Object[0]);
        if (templateData != null) {
            fileName = fileName + templateData.getLocaleString("name");
        } else {
            Object entityName = this.getParams().get(CUSTPARAM_ENTITYNAME);
            if (entityName != null) {
                fileName = fileName + entityName;
            }
        }
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("MMddHHmmss");
        String nowDateFormat = format.format(now);
        fileName = fileName + String.format("_%s", nowDateFormat);
        fileName = RequestContext.get().getLang() == Lang.zh_CN || RequestContext.get().getLang() == Lang.zh_TW ? BlankPattern.matcher(FileNamePattern.matcher(fileName).replaceAll("")).replaceAll("_") : FileNamePattern.matcher(fileName).replaceAll("");
        int length = fileName.getBytes().length;
        if (length >= 250) {
            fileName = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_", (String)"ExportDataTask_5", (String)BOS_EXPORT, (Object[])new Object[0]);
            Object entityNumber = this.getParams().get(CUSTPARAM_ENTITYNUMBER);
            if (entityNumber != null) {
                fileName = fileName + entityNumber;
            }
            fileName = fileName + String.format("_%s", nowDateFormat);
            fileName = RequestContext.get().getLang() == Lang.zh_CN || RequestContext.get().getLang() == Lang.zh_TW ? BlankPattern.matcher(FileNamePattern.matcher(fileName).replaceAll("")).replaceAll("_") : FileNamePattern.matcher(fileName).replaceAll("");
        }
        return fileName;
    }

    private List<DynamicObject> load(List<Object> subPkIds) {
        DynamicObject[] arr = BusinessDataServiceHelper.load((Object[])subPkIds.toArray(), (DynamicObjectType)this.subMainType);
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(arr.length);
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject obj : arr) {
            map.put(obj.getPkValue(), obj);
        }
        for (Object e : subPkIds) {
            DynamicObject obj = (DynamicObject)map.get(e);
            if (obj == null) continue;
            objs.add(obj);
        }
        AbstractListViewPluginProxy proxy = this.getListPluginProxy();
        if (proxy != null) {
            AfterQueryOfExportEvent afterQueryOfExportEvent = new AfterQueryOfExportEvent((Object)this.getParentView(), objs.toArray(new DynamicObject[0]));
            proxy.fireAfterQueryOfExport(afterQueryOfExportEvent);
            if (afterQueryOfExportEvent.isCustomOrder()) {
                objs.clear();
                for (DynamicObject obj : afterQueryOfExportEvent.getQueryValues()) {
                    objs.add(obj);
                }
            }
        }
        return objs;
    }

    private String zipExportFiles(ListDataExporter exporter, BillEntityType mainEntityType, String url, List<List<Map<String, Object>>> attachArr, String fileName) {
        BatchDownloadRequest attachReq = new BatchDownloadRequest(fileName + ".zip");
        BatchDownloadRequest.Dir[] attDirs = new BatchDownloadRequest.Dir[attachArr.size()];
        for (int i = 0; i < attachArr.size(); ++i) {
            List<Map<String, Object>> attachs = attachArr.get(i);
            if (attachs.isEmpty()) continue;
            BatchDownloadRequest.Dir dir = new BatchDownloadRequest.Dir(String.format(ResManager.loadKDString((String)"\u9644\u4ef6-%s", (String)"ExportDataTask_6", (String)BOS_EXPORT, (Object[])new Object[0]), attachs.get(0).get("pkId")));
            BatchDownloadRequest.File[] files = new BatchDownloadRequest.File[attachs.size()];
            for (int j = 0; j < files.length; ++j) {
                Map<String, Object> att = attachs.get(j);
                files[j] = new BatchDownloadRequest.File((String)att.get("name"), (String)att.get("url"));
            }
            dir.setFiles(files);
            attDirs[i] = dir;
        }
        attachReq.setDirs(attDirs);
        attachReq.setFiles(new BatchDownloadRequest.File[]{new BatchDownloadRequest.File(fileName + ".xlsx", url)});
        File temp = null;
        try {
            temp = File.createTempFile(UUID.randomUUID().toString(), ".zip");
            FileOutputStream fos = new FileOutputStream(temp);
            FileService service = FileServiceFactory.getAttachmentFileService();
            service.batchDownload(attachReq, (OutputStream)fos, null);
            ((OutputStream)fos).close();
            FileInputStream fin = new FileInputStream(temp);
            url = exporter.upload((MainEntityType)mainEntityType, fileName + ".zip", fin);
            ((InputStream)fin).close();
        }
        catch (IOException e) {
            try {
                throw new KDException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u751f\u6210\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff1a%s\u3002", (String)"ExportDataTask_7", (String)BOS_EXPORT, (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeDeleteFile(temp);
                throw throwable;
            }
        }
        FileSecurityUtil.safeDeleteFile((File)temp);
        return url;
    }

    private BeforeQueryOfExportEvent fireBeforeQueryEvent(Set<String> selectFields, String orderby, QFilter[] filters) {
        String selectfieldsStr = StringUtils.join((Object[])selectFields.toArray(), (String)",");
        BeforeQueryOfExportEvent e = new BeforeQueryOfExportEvent((Object)this.getParentView(), selectfieldsStr, orderby, filters);
        AbstractListViewPluginProxy pluginProxy = this.getListPluginProxy();
        if (pluginProxy == null) {
            return e;
        }
        ((ListViewPluginProxy)pluginProxy).fireBeforeQueryOfExport(e);
        return e;
    }

    protected AbstractListViewPluginProxy getListPluginProxy() {
        IFormView view = this.getParentView();
        if (view instanceof ListView) {
            return (AbstractListViewPluginProxy)view.getService(FormViewPluginProxy.class);
        }
        return null;
    }

    protected String getFinalUrl(ExcelWriter exporter, BillEntityType mainType, List<ExportFileInfo> fileList, String fileName) {
        String downloadUrl;
        String url;
        FileInputStream fis = null;
        File file = null;
        File saveDir = this.getSaveDir();
        if (fileList.size() > 1) {
            url = FileHandlerUtil.createZipForLocal((String)fileName, (String)".zip", (File)saveDir, (boolean)true);
            fileName = fileName + ".zip";
        } else {
            url = fileList.get(0).getUrl();
            File[] suffix = ".xlsx";
            if (this.isExportCsv().booleanValue() && (this.getByList() || this.isExptType())) {
                suffix = ".csv";
            }
            fileName = fileName + (String)suffix;
        }
        try {
            file = new File(FilenameUtils.getFullPath((String)url), FilenameUtils.getName((String)url));
            fis = new FileInputStream(FilenameUtils.getFullPath((String)url).concat(FilenameUtils.getName((String)url)));
            downloadUrl = exporter.upload((MainEntityType)mainType, fileName, fis);
        }
        catch (FileNotFoundException e) {
            try {
                log.error("[\u5bfc\u51fa]\u4e0a\u4f20\u6700\u7ec8\u538b\u7f29\u5305\u5f02\u5e38 " + e);
                throw new KDException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u5bfc\u51fa\u6587\u4ef6\u5f02\u5e38", (String)"ExportDataTask_10", (String)BOS_EXPORT, (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeClose(fis);
                FileSecurityUtil.safeDeleteFileWithOutException(file);
                for (File dirFile : saveDir.listFiles()) {
                    FileSecurityUtil.safeDeleteFile((File)dirFile);
                }
                FileSecurityUtil.safeDeleteFile((File)saveDir);
                if (fileList.size() > 1) {
                    FileSecurityUtil.safeDeleteFile((File)new File(url));
                }
                throw throwable;
            }
        }
        FileSecurityUtil.safeClose((Closeable)fis);
        FileSecurityUtil.safeDeleteFileWithOutException((File)file);
        for (File dirFile : saveDir.listFiles()) {
            FileSecurityUtil.safeDeleteFile((File)dirFile);
        }
        FileSecurityUtil.safeDeleteFile((File)saveDir);
        if (fileList.size() > 1) {
            FileSecurityUtil.safeDeleteFile((File)new File(url));
        }
        return downloadUrl;
    }

    protected Boolean isExportPictureProp() {
        if (this.isExportPictureProp == null) {
            this.isExportPictureProp = this.isExportPicturePropFromCache();
        }
        return this.isExportPictureProp;
    }

    protected Boolean isExportPicturePropFromCache() {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return Boolean.FALSE;
        }
        Optional settingOfExportImg = exportService.getSettingOfExportImg(entityNumber);
        return settingOfExportImg.map(item -> Boolean.valueOf((String)item.get("forimgexport"))).orElse(Boolean.FALSE);
    }

    protected int exportPictureNameType() {
        if (this.exportPicturePropNameType == null) {
            this.exportPicturePropNameType = this.exportPictureNameTypeFromCache();
        }
        return this.exportPicturePropNameType;
    }

    protected int exportPictureNameTypeFromCache() {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return 0;
        }
        Optional settingOfExportImg = exportService.getSettingOfExportImg(entityNumber);
        return settingOfExportImg.map(item -> Integer.valueOf((String)item.get("combofieldpicname"))).orElse(0);
    }

    protected Boolean isExportAttAndPanelProp() {
        if (this.isExportAttAndPanelProp == null) {
            this.isExportAttAndPanelProp = this.isExportAttAndPanelFromCache();
        }
        return this.isExportAttAndPanelProp;
    }

    protected Boolean isExportAttAndPanelFromCache() {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return Boolean.FALSE;
        }
        Optional settingOfExportAtt = exportService.getSettingOfExportAtt(entityNumber);
        Object hasDownloadAttachmentPermValue = this.getParams().get("hasDownloadAttachmentPerm");
        boolean hasDownloadAttachmentPerm = hasDownloadAttachmentPermValue != null && Boolean.parseBoolean(hasDownloadAttachmentPermValue.toString());
        boolean isExportAtt = settingOfExportAtt.map(item -> Boolean.valueOf((String)item.get("forattexport"))).orElse(Boolean.FALSE);
        return isExportAtt && hasDownloadAttachmentPerm;
    }

    protected int exportAttNameType() {
        if (this.exportAttNameType == null) {
            this.exportAttNameType = this.exportAttNameTypeFromCache();
        }
        return this.exportAttNameType;
    }

    protected int exportAttNameTypeFromCache() {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return 0;
        }
        Optional settingOfExportAtt = exportService.getSettingOfExportAtt(entityNumber);
        return settingOfExportAtt.map(item -> Integer.valueOf((String)item.get("combofieldattname"))).orElse(0);
    }

    protected File getSaveDir() {
        return this.context.getSaveDir();
    }

    class ExportTimer {
        private long timeBySerTool = 0L;
        private long timeByLocalTool = 0L;
        private long timeGetAllPKIds = 0L;
        private long timeSplitBatch = 0L;

        ExportTimer() {
        }

        public long getTimeBySerTool() {
            return this.timeBySerTool;
        }

        public long getTimeByLocalTool() {
            return this.timeByLocalTool;
        }

        public long getTimeGetAllPKIds() {
            return this.timeGetAllPKIds;
        }

        public long getTimeSplitBatch() {
            return this.timeSplitBatch;
        }

        public void addTimeBySerTool(Date beginTime) {
            Date endTime = new Date();
            this.timeBySerTool = endTime.getTime() - beginTime.getTime() + this.timeBySerTool;
        }

        public void addTimeByLocalTool(Date beginTime) {
            Date endTime = new Date();
            this.timeByLocalTool = endTime.getTime() - beginTime.getTime() + this.timeByLocalTool;
        }

        public void addTimeGetAllPKIds(Date beginTime) {
            Date endTime = new Date();
            this.timeGetAllPKIds = endTime.getTime() - beginTime.getTime() + this.timeGetAllPKIds;
        }

        public void addTimeSplitBatch(Date beginTime) {
            Date endTime = new Date();
            this.timeSplitBatch = endTime.getTime() - beginTime.getTime() + this.timeSplitBatch;
        }

        public String toString() {
            return String.format("get all pkids: %s; split batch: %s; export by JsonArray: %s; export by local tool: %s", this.timeGetAllPKIds, this.timeSplitBatch, this.timeBySerTool, this.timeByLocalTool);
        }
    }
}

