/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.service.ServiceFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportSheetStyle {
    private static final String DEFAULT = "default";
    private SXSSFRow entityRow;
    private SXSSFRow nameRow;
    private Map<Integer, String> entities;
    private Map<Integer, String> fieldnames;
    private SXSSFWorkbook wb;
    private Map<String, CellStyle> decimalStyles = new HashMap<String, CellStyle>();
    private Map<String, CellStyle> textStyles = new HashMap<String, CellStyle>();
    private Font redFont;
    private boolean autoLine = true;

    public Map<Integer, String> getEntities() {
        return this.entities;
    }

    public void setEntities(Map<Integer, String> entities) {
        this.entities = entities;
    }

    public Map<Integer, String> getFieldnames() {
        return this.fieldnames;
    }

    public void setFieldnames(Map<Integer, String> fieldnames) {
        this.fieldnames = fieldnames;
    }

    public ExportSheetStyle(SXSSFWorkbook wb, String entityId) {
        this.wb = wb;
        this.redFont = wb.createFont();
        this.redFont.setColor(IndexedColors.RED.getIndex());
        if (entityId != null) {
            IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
            this.autoLine = exportService.getSettingOfAutoLine(entityId);
        }
    }

    @Deprecated
    public ExportSheetStyle(SXSSFWorkbook wb) {
        this(wb, null);
    }

    public void reference(SXSSFRow entityRow, SXSSFRow nameRow) {
        this.setEntityRow(entityRow);
        this.setNameRow(nameRow);
    }

    public CellStyle getTextStyle() {
        return this.getTextStyle(DEFAULT);
    }

    public CellStyle getTextStyle(String align) {
        String style = "TEXT_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            this.setVerticalAlignment(cs, VerticalAlignment.CENTER);
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setDataFormat(this.wb.createDataFormat().getFormat("@"));
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        cs.setWrapText(this.autoLine);
        return cs;
    }

    private void setVerticalAlignment(CellStyle cs, VerticalAlignment verticalAlignment) {
        cs.setVerticalAlignment(verticalAlignment);
    }

    public CellStyle getDateStyle() {
        return this.getDateStyle(DEFAULT);
    }

    public CellStyle getDateStyle(String align) {
        String style;
        CellStyle cs;
        if (StringUtils.isBlank((CharSequence)align) || DEFAULT.equalsIgnoreCase(align)) {
            align = "left";
        }
        if ((cs = this.textStyles.get(style = "DATE_" + align)) == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat("yyyy-mm-dd"));
            this.setVerticalAlignment(cs, VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getDatetimeStyle() {
        return this.getDatetimeStyle(DEFAULT);
    }

    public CellStyle getDatetimeStyle(String align) {
        String style;
        CellStyle cs;
        if (StringUtils.isBlank((CharSequence)align) || DEFAULT.equalsIgnoreCase(align)) {
            align = "left";
        }
        if ((cs = this.textStyles.get(style = "DATETIME_" + align)) == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat("yyyy-mm-dd H:mm:ss"));
            this.setVerticalAlignment(cs, VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getHlinkStyle() {
        return this.getHlinkStyle(DEFAULT);
    }

    public CellStyle getHlinkStyle(String align) {
        String style = "HLINK_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            Font hlink_font = this.wb.createFont();
            hlink_font.setUnderline((byte)1);
            hlink_font.setColor(IndexedColors.BLUE.getIndex());
            cs.setFont(hlink_font);
            this.setVerticalAlignment(cs, VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getTitleStyle() {
        String style = "TITLE_";
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            this.setVerticalAlignment(cs, VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(DEFAULT));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getTitleStyle(String align) {
        String style = "TITLE_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.setVerticalAlignment(cs, VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getNameStyle() {
        return this.getTitleStyle();
    }

    public CellStyle getNameStyle(String align) {
        String style = "NAME_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.setVerticalAlignment(cs, VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    public Font getRedFont() {
        return this.redFont;
    }

    public CellStyle getTitleMustInputStyle() {
        return this.getTitleMustInputStyle(DEFAULT);
    }

    public CellStyle getTitleMustInputStyle(String align) {
        String style = "TITLEMUSTINPUT_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs.setFont(this.redFont);
            this.setVerticalAlignment(cs, VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getTextHighLightStyle() {
        return this.getTextHighLightStyle(DEFAULT);
    }

    public CellStyle getTextHighLightStyle(String align) {
        String style = "TEXTHIGHLIGHT_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat("@"));
            cs.setFont(this.redFont);
            this.setVerticalAlignment(cs, VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public SXSSFRow getEntityRow() {
        return this.entityRow;
    }

    public void setEntityRow(SXSSFRow entityRow) {
        this.entityRow = entityRow;
        this.entities = new LinkedHashMap<Integer, String>();
        for (Cell cell : entityRow) {
            if (cell == null || !StringUtils.isNotBlank((CharSequence)cell.getStringCellValue())) continue;
            this.entities.put(cell.getColumnIndex(), cell.getStringCellValue());
        }
    }

    public SXSSFRow getNameRow() {
        return this.nameRow;
    }

    public void setNameRow(SXSSFRow nameRow) {
        this.nameRow = nameRow;
        this.fieldnames = new LinkedHashMap<Integer, String>();
        for (Cell cell : nameRow) {
            if (cell == null || !StringUtils.isNotBlank((CharSequence)cell.getStringCellValue())) continue;
            this.fieldnames.put(cell.getColumnIndex(), cell.getStringCellValue());
        }
    }

    public CellStyle getDecimalStyle(SXSSFWorkbook wb, Map<String, Object> dataMap) {
        return this.getDecimalStyle(wb, dataMap, DEFAULT);
    }

    public CellStyle getDecimalStyle(SXSSFWorkbook wb, Map<String, Object> dataMap, String align) {
        if (StringUtils.isBlank((CharSequence)align) || DEFAULT.equalsIgnoreCase(align)) {
            align = "right";
        }
        CellStyle style = null;
        if (dataMap == null) {
            style = this.decimalStyles.get(" " + align);
            if (style == null) {
                style = wb.createCellStyle();
                style.setDataFormat((short)0);
                this.setVerticalAlignment(style, VerticalAlignment.CENTER);
                style.setAlignment(this.getAlignment(align));
                this.decimalStyles.put(" " + align, style);
            }
        } else if (dataMap.containsKey("sign") || dataMap.containsKey("precision")) {
            String sign = Boolean.TRUE.equals(dataMap.get("showSign")) ? (String)dataMap.get("sign") : "";
            int precision = (Integer)dataMap.get("precision");
            style = this.decimalStyles.get(sign + " " + precision + " " + align);
            if (style == null) {
                String format = sign.length() == 1 ? "_(<ccy> #,##0.00_);_(<ccy> -#,##0.00_)".replace("<ccy>", "") : "#,##0.00";
                format = format.replaceAll("\\.00", precision > 0 ? String.format(".%0" + precision + "d", 0) : "");
                style = wb.createCellStyle();
                style.setDataFormat(wb.createDataFormat().getFormat(format));
                this.setVerticalAlignment(style, VerticalAlignment.CENTER);
                style.setAlignment(this.getAlignment(align));
                this.decimalStyles.put(sign + " " + precision + " " + align, style);
            }
        }
        return style;
    }
}

