/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListViewPluginProxy;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.export.ExportDataContext;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;

@Deprecated
public class ListDataExportRunnable
implements Runnable {
    private static final String BOS_EXPORT = "bos-export";
    private static Log log = LogFactory.getLog(ListDataExportRunnable.class);
    private ExportDataContext ctx;

    @Deprecated
    public ListDataExportRunnable(BillList billList, BillEntityType mainEntityType, List<Object> allPkIds, String orderby, List<ExportWriterFormat> formats, String fileName, boolean fillParent, Object logId) {
        this(new ExportDataContext().setLogId(logId).setFileName(fileName).setBillList(billList).setMainEntityType(mainEntityType).setAllPkIds(allPkIds).setOrderby(orderby).setFormats(formats).setFillParent(fillParent));
    }

    @Deprecated
    public ListDataExportRunnable(BillList billList, BillEntityType mainEntityType, List<Object> allPkIds, String orderby, boolean fillParent, Object logId, long templateId) {
        this(billList, mainEntityType, allPkIds, orderby, null, null, fillParent, logId);
        this.ctx.setTemplateId(templateId);
    }

    public ListDataExportRunnable(ExportDataContext expCtx) {
        this.ctx = expCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BillList billList = this.ctx.getBillList();
        BillEntityType mainEntityType = this.ctx.getMainEntityType();
        List<Object> allPkIds = this.ctx.getAllPkIds();
        String orderby = this.ctx.getOrderby();
        boolean fillParent = this.ctx.isFillParent();
        Object logId = this.ctx.getLogId();
        long templateId = this.ctx.getTemplateId();
        String pageId = this.ctx.getListPageId();
        PageCache listCache = new PageCache(pageId);
        try {
            String fileName = this.genListDataExportFileName(billList, LocalDate.now(), templateId);
            ExportLogHelper.create((Object)logId, (String)this.ctx.getMainEntityDisplayName(), (int)allPkIds.size(), (String)this.ctx.getExptType());
            log.debug("----\u5f00\u59cb\u6267\u884c\u6570\u636e\u5bfc\u51fa----");
            MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
            String formatJson = metaService.getExportWriter(mainEntityType.getName(), templateId, null, null);
            List formats = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
            ExportWriterFormat format = (ExportWriterFormat)formats.get(0);
            ListDataExporter exporter = new ListDataExporter("sheet1", formats, fillParent);
            log.debug("----\u5f00\u59cb\u6267\u884c\u6570\u636e\u5bfc\u51fa----\u751f\u6210\u8868\u5934\u5b8c\u6210");
            String selectFields = this.buildSelectFields(mainEntityType, format);
            this.exportDatas(mainEntityType, format, exporter, listCache, allPkIds, selectFields, orderby, pageId, fileName, logId, fillParent);
        }
        catch (Throwable e) {
            log.error(e);
            listCache.put(logId.toString(), "error");
            ExportLogHelper.logAll((Object)logId, null, (String)(e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ListDataExportRunnable_0", (String)BOS_EXPORT, (Object[])new Object[0])));
        }
        finally {
            listCache.remove("CacheKey_LIST_EXPORT_RUNNING");
        }
    }

    private void exportDatas(BillEntityType mainEntityType, ExportWriterFormat format, ListDataExporter exporter, PageCache listCache, List<Object> allPkIds, String selectFields, String orderby, String pageId, String fileName, Object logId, boolean fillParent) throws Throwable {
        int rowIndex;
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ListViewPluginProxy proxy = this.getListViewPluginProxy(view);
        ExportFileEvent exportEvt = new ExportFileEvent(view, mainEntityType, fileName);
        if (proxy != null) {
            proxy.fireBeforeExportFile((BeforeExportFileEvent)exportEvt);
        }
        ArrayList<List<Map<String, Object>>> attachArr = new ArrayList<List<Map<String, Object>>>();
        List<Object> subPkIds = allPkIds.subList(0, Math.min(allPkIds.size(), 10));
        int rowFlush = rowIndex = fillParent ? 1 : 3;
        boolean firstBatch = true;
        int complete = 0;
        LinkedList<DynamicObject> allListValue = new LinkedList<DynamicObject>();
        while (!subPkIds.isEmpty()) {
            log.debug("----\u5f00\u59cb\u6267\u884c\u6570\u636e\u5bfc\u51fa----\u51c6\u5907\u4e00\u4e2a\u6279\u6b21\u7684\u6570\u636e\uff0csize=" + subPkIds.size());
            QFilter[] filters = new QFilter[]{new QFilter(mainEntityType.getPrimaryKey().getName(), "in", subPkIds)};
            if (proxy != null) {
                BeforeQueryOfExportEvent e = new BeforeQueryOfExportEvent((Object)view, selectFields, orderby, filters);
                proxy.fireBeforeQueryOfExport(e);
                selectFields = e.getSelectFields();
                orderby = e.getOrderBys();
                filters = e.getFilters();
            }
            DynamicObject[] arr = BusinessDataServiceHelper.load((String)mainEntityType.getName(), (String)selectFields, (QFilter[])filters, (String)orderby);
            allListValue.clear();
            if (proxy != null) {
                int fromIndex = 0;
                while (fromIndex < arr.length) {
                    int toIndex = fromIndex + 1000 < arr.length ? fromIndex + 1000 : arr.length;
                    DynamicObject[] subArray = Arrays.copyOfRange(arr, fromIndex, toIndex);
                    fromIndex = toIndex;
                    AfterQueryOfExportEvent e = new AfterQueryOfExportEvent((Object)view, subArray);
                    proxy.fireAfterQueryOfExport(e);
                    allListValue.addAll(Arrays.asList(e.getQueryValues()));
                }
            }
            arr = allListValue.toArray(arr);
            String json = SerializationUtils.toJsonString((Object)arr);
            JSONArray jsonArr = JSONArray.parseArray((String)json);
            if (arr.length > 0) {
                log.debug("----\u5f00\u59cb\u6267\u884c\u6570\u636e\u5bfc\u51fa----\u5f00\u59cb\u5904\u7406\u4e00\u4e2a\u6279\u6b21\u7684\u6570\u636e\uff1a" + arr.length);
                BillEntityType entityType = (BillEntityType)arr[0].getDataEntityType();
                ArrayList<DynamicObject> lstMainOrg = new ArrayList<DynamicObject>(10);
                for (DynamicObject obj : arr) {
                    MainOrgProp mainOrgProp = entityType.getMainOrgProperty();
                    lstMainOrg.add(mainOrgProp == null ? null : (DynamicObject)mainOrgProp.getValueFast((Object)obj));
                }
                for (int i = 0; i < jsonArr.size(); ++i) {
                    DynamicObject mainOrg = (DynamicObject)lstMainOrg.get(i);
                    exporter.handleData(jsonArr.getJSONObject(i), (DynamicObjectType)entityType, mainOrg);
                }
                DynamicObjectCollection coll = new DynamicObjectCollection((DynamicObjectType)entityType, null, Arrays.asList(arr));
                exporter.formatData(coll, entityType, jsonArr);
            }
            for (int i = 0; i < arr.length; ++i) {
                int offset = exporter.writeData(jsonArr.getJSONObject(i), rowIndex, format, !fillParent && firstBatch && !attachArr.isEmpty(), exportEvt.getFileName(), fillParent);
                rowIndex = offset > 1 ? (rowIndex += offset) : ++rowIndex;
                if (rowIndex - rowFlush <= 5000) continue;
                exporter.flush();
            }
            log.debug("----\u5f00\u59cb\u6267\u884c\u6570\u636e\u5bfc\u51fa----\u751f\u6210\u5f53\u524d\u6279\u6b21\u8868\u683c\u6570\u636e\u5b8c\u6210");
            listCache.put(logId.toString(), Integer.toString(complete += subPkIds.size()));
            subPkIds.clear();
            subPkIds = allPkIds.subList(0, Math.min(allPkIds.size(), 500));
            firstBatch = false;
        }
        listCache.put(logId.toString(), Integer.toString(complete));
        ExportLogHelper.log((Object)logId, (int)complete);
        exporter.clear();
        String url = exporter.flush((AbstractListViewPluginProxy)proxy, exportEvt);
        log.debug("----\u5f00\u59cb\u6267\u884c\u6570\u636e\u5bfc\u51fa----\u6587\u4ef6\u751f\u6210\u5b8c\u6210");
        if (!attachArr.isEmpty()) {
            url = this.zipExportFiles(exporter, mainEntityType, url, attachArr, fileName);
        }
        url = UrlService.getAttachmentFullUrl((String)url);
    }

    private ListViewPluginProxy getListViewPluginProxy(IFormView view) {
        if (view instanceof ListView) {
            return (ListViewPluginProxy)view.getService(FormViewPluginProxy.class);
        }
        return null;
    }

    private String buildSelectFields(BillEntityType mainEntityType, ExportWriterFormat format) {
        StringBuilder selectFields = new StringBuilder(String.join((CharSequence)",", format.listFields(new ArrayList<String>())));
        if (StringUtils.isBlank((CharSequence)selectFields)) {
            selectFields = new StringBuilder("*");
        } else {
            HashSet<String> appendControlProps = new HashSet<String>(16);
            List<String> fieldKeyArr = Arrays.asList(selectFields.toString().split(","));
            for (String fieldKey : fieldKeyArr) {
                String controlPropName;
                IDataEntityProperty prop = (IDataEntityProperty)mainEntityType.getAllFields().get(fieldKey);
                if (!(prop instanceof DecimalProp) || !StringUtils.isNotBlank((CharSequence)(controlPropName = ((DecimalProp)prop).getControlPropName())) || fieldKeyArr.contains(controlPropName) || !appendControlProps.add(controlPropName)) continue;
                selectFields.append(',').append(controlPropName);
            }
            String mainOrgKey = mainEntityType.getMainOrg();
            if (StringUtils.isNotBlank((CharSequence)mainOrgKey) && !fieldKeyArr.contains(mainOrgKey)) {
                StringBuilder temp = new StringBuilder(mainOrgKey);
                temp.append(',').append((CharSequence)selectFields);
                selectFields = temp;
            }
        }
        log.debug("----\u5f00\u59cb\u6267\u884c\u6570\u636e\u5bfc\u51fa----\u51c6\u5907selectfields\u5b8c\u6210");
        return selectFields.toString();
    }

    private void notifyDownload(Object logId, BillEntityType mainEntityType, String url, Long uid) {
        ExportLogHelper.logAll((Object)logId, (String)url, (String)"");
        MessageInfo messageInfo = new MessageInfo();
        StringBuilder yzjMessage = new StringBuilder();
        yzjMessage.append(url);
        messageInfo.setTitle(ResManager.loadKDString((String)"\u5bfc\u51fa\u5df2\u5b8c\u6210\uff0c\u8bf7\u590d\u5236\u4e0b\u8f7d\u94fe\u63a5\u5728\u65b0\u9875\u7b7e\u4e2d\u6253\u5f00\u3002", (String)"ListDataExportRunnable_1", (String)BOS_EXPORT, (Object[])new Object[0]));
        messageInfo.setTag(mainEntityType.getDisplayName().toString());
        messageInfo.setContent(yzjMessage.toString());
        messageInfo.setMessageType("message");
        messageInfo.setUserIds(Collections.singletonList(uid));
        messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/ierp/index.html?formId=bos_exportlog&pkId=" + logId);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private String genListDataExportFileName(BillList billList, LocalDate now, long templateId) {
        DynamicObject templateData = templateId > 0L ? BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"bos_importtemplate") : null;
        String fileName = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_", (String)"ListDataExportRunnable_2", (String)BOS_EXPORT, (Object[])new Object[0]);
        if (templateData != null) {
            fileName = fileName + templateData.get("name");
        } else {
            BillEntityType listEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)FormMetadataCache.getFormConfig((String)billList.getEntityId()).getEntityTypeId());
            fileName = fileName + listEntityType.getDisplayName();
        }
        fileName = fileName + String.format("_%02d%02d", now.getMonthValue(), now.getDayOfMonth());
        return fileName.replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "").replaceAll(" ", "_");
    }

    private String zipExportFiles(ListDataExporter exporter, BillEntityType mainEntityType, String url, List<List<Map<String, Object>>> attachArr, String fileName) {
        BatchDownloadRequest attachReq = new BatchDownloadRequest(fileName + ".zip");
        BatchDownloadRequest.Dir[] attDirs = new BatchDownloadRequest.Dir[attachArr.size()];
        for (int i = 0; i < attachArr.size(); ++i) {
            List<Map<String, Object>> attachs = attachArr.get(i);
            if (attachs.isEmpty()) continue;
            BatchDownloadRequest.Dir dir = new BatchDownloadRequest.Dir(String.format(ResManager.loadKDString((String)"\u9644\u4ef6-%s", (String)"ListDataExportRunnable_3", (String)BOS_EXPORT, (Object[])new Object[0]), attachs.get(0).get("pkId")));
            BatchDownloadRequest.File[] files = new BatchDownloadRequest.File[attachs.size()];
            for (int j = 0; j < files.length; ++j) {
                Map<String, Object> att = attachs.get(j);
                files[j] = new BatchDownloadRequest.File((String)att.get("name"), (String)att.get("url"));
            }
            dir.setFiles(files);
            attDirs[i] = dir;
        }
        attachReq.setDirs(attDirs);
        attachReq.setFiles(new BatchDownloadRequest.File[]{new BatchDownloadRequest.File(fileName + ".xlsx", url)});
        try {
            File temp = File.createTempFile(UUID.randomUUID().toString(), ".zip");
            FileOutputStream fos = new FileOutputStream(temp);
            FileService service = FileServiceFactory.getAttachmentFileService();
            service.batchDownload(attachReq, (OutputStream)fos, null);
            ((OutputStream)fos).close();
            FileInputStream fin = new FileInputStream(temp);
            url = exporter.upload((MainEntityType)mainEntityType, fileName + ".zip", fin);
            ((InputStream)fin).close();
            Files.delete(temp.toPath());
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        return url;
    }
}

