/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.webapi.FlexEntityTypeReader;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.mvc.export.ExportDecimalFieldFormat;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.service.InteTimeZone;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.ExcelHelper;
import kd.bos.web.actions.export.ExportWriter;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class ListDataExporter
extends ExcelWriter {
    private static final String DEFAULT = "default";
    private static final String BOS_EXPORT = "bos-export";
    private static Log log = LogFactory.getLog(ListDataExporter.class);
    private static final String[] sources = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final int MAX_CELLCONTENT_LENGTH = Short.MAX_VALUE;
    private ExportDecimalFieldFormat decimalFieldFormat = new ExportDecimalFieldFormat();
    private FlexEntityTypeReader flexEntityTypeReader;
    private Map<String, BasedataEntityType> flexRefBDTypes = new HashMap<String, BasedataEntityType>();
    private Map<String, Map<Object, DynamicObject>> flexBasedataObjs = new HashMap<String, Map<Object, DynamicObject>>();
    private SXSSFSheet sheet;
    private SXSSFSheet dropdownSheet;
    private ExportSheetStyle styles;
    private int headerOffset = 0;
    private static final String NUMBER = "number";
    private static final String COLWIDTH_KEY = "ColWidth";
    private Map<String, String> headerMap = new HashMap<String, String>(16);
    private SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ListDataExporter(String sheetName, List<ExportWriterFormat> formats, Map<String, String> headerMap, boolean fillParent, String entityId) {
        this.innit(sheetName, formats, headerMap, fillParent, entityId);
    }

    public ListDataExporter(String sheetName, List<ExportWriterFormat> formats, boolean isExptType, String entityId) {
        this.innit(sheetName, formats, new HashMap<String, String>(16), isExptType, entityId);
    }

    private void innit(String sheetName, List<ExportWriterFormat> formats, Map<String, String> headerMap, boolean isExptType, String entityId) {
        int dropdownItemsSheetIndex;
        this.wb = new SXSSFWorkbook(-1);
        this.wb.setCompressTempFiles(true);
        this.styles = new ExportSheetStyle(this.wb, entityId);
        if (headerMap != null) {
            this.headerMap = headerMap;
        }
        this.sheet = this.wb.createSheet(sheetName);
        this.dropdownSheet = this.wb.createSheet("dropdown_items_sheet");
        this.dropdownSheet.setRandomAccessWindowSize(-1);
        HashMap<Integer, String> propDisplayNames = new HashMap<Integer, String>();
        for (ExportWriterFormat format : formats) {
            this.headerOffset = this.writeHeader(this.wb, this.sheet, this.dropdownSheet, this.styles, format, propDisplayNames, this.headerOffset, isExptType);
        }
        if (this.styles.getEntities() == null || this.styles.getFieldnames() == null) {
            this.styles.reference(ListDataExporter.getRow(this.sheet, isExptType ? 2 : 0), ListDataExporter.getRow(this.sheet, isExptType ? 0 : 2));
        }
        if ((dropdownItemsSheetIndex = this.wb.getSheetIndex("dropdown_items_sheet")) >= 0) {
            this.wb.setSheetHidden(dropdownItemsSheetIndex, true);
        }
        if (isExptType) {
            this.sheet.removeRow((Row)this.sheet.getRow(1));
            this.sheet.removeRow((Row)this.sheet.getRow(2));
        }
    }

    @Deprecated
    public ListDataExporter(String sheetName, List<ExportWriterFormat> formats, boolean isExptType) {
        this(sheetName, formats, isExptType, null);
    }

    public ExportSheetStyle getStyles() {
        return this.styles;
    }

    public CellStyle getDecimalStyle(Map<String, Object> dataMap) {
        return this.styles.getDecimalStyle(this.wb, dataMap);
    }

    public SXSSFRow getRow(int rowIndex) {
        if (rowIndex >= 0x100000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faExcel\u6587\u4ef6\u6700\u5927\u884c\u65701048576\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ListDataExporter_14", (String)BOS_EXPORT, (Object[])new Object[0]));
        }
        SXSSFRow row = this.sheet.getRow(rowIndex);
        if (row == null) {
            row = this.sheet.createRow(rowIndex);
        }
        return row;
    }

    public SXSSFCell createCell(SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    private List<String> getLangEndFix() {
        ArrayList<String> langs = new ArrayList<String>(10);
        for (Lang lang : Lang.values()) {
            langs.add("." + lang.name());
        }
        return langs;
    }

    private int writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropdownSheet, ExportSheetStyle styles, ExportWriterFormat format, Map<Integer, String> propDisplayNames, int preOffset, boolean isExptType) {
        SXSSFRow entityRow = ListDataExporter.getRow(sheet, 0);
        SXSSFRow commentRow = ListDataExporter.getRow(sheet, 1);
        SXSSFRow nameRow = ListDataExporter.getRow(sheet, 2);
        int titleRowIndex = isExptType ? 0 : 3;
        SXSSFRow titleRow = ListDataExporter.getRow(sheet, titleRowIndex);
        if (format.getHideFieldRow().booleanValue()) {
            entityRow.setHidden(Boolean.TRUE);
            commentRow.setHidden(Boolean.TRUE);
            nameRow.setHidden(Boolean.TRUE);
        }
        CellStyle cellStyle = format.displayName != null && format.displayName.startsWith("*") ? styles.getTextHighLightStyle() : styles.getTitleStyle();
        ListDataExporter.createCell(wb, entityRow, format.col + preOffset, cellStyle).setCellValue(format.displayName + " # " + format.name);
        int offset = preOffset;
        for (int i = 0; i < format.fields.size(); ++i) {
            String fieldName = format.fields.get(i);
            Map<String, Object> property = format.properties.get(fieldName);
            boolean mustInput = false;
            Object inputType = null;
            int defaultColWidth = 0;
            if (property != null) {
                mustInput = Boolean.TRUE.equals(property.get("MustInput"));
                inputType = property.get("InputType");
                if ("id".equals(inputType) || "pid".equals(inputType)) {
                    fieldName = fieldName.replace('.', '_');
                } else if (inputType instanceof JSONArray) {
                    ArrayList<String> items = new ArrayList<String>();
                    ((JSONArray)inputType).forEach(obj -> items.add(obj.toString().split(" # ", -1)[0]));
                    if (!items.isEmpty() && !"MulComboProp".equals(property.get("PropType"))) {
                        int currCol = format.col + offset;
                        for (int j = 0; j < items.size(); ++j) {
                            ListDataExporter.getRow(dropdownSheet, j).createCell(currCol).setCellValue((String)items.get(j));
                        }
                        ListDataExporter.createDropdownList(sheet, currCol, items, isExptType);
                    }
                } else if ("date".equals(inputType)) {
                    defaultColWidth = 60;
                    sheet.setDefaultColumnStyle(format.col + offset, styles.getDateStyle());
                } else if ("datetime".equals(inputType)) {
                    defaultColWidth = 80;
                    sheet.setDefaultColumnStyle(format.col + offset, styles.getDatetimeStyle());
                } else if ("decimal".equals(inputType)) {
                    sheet.setDefaultColumnStyle(format.col + offset, styles.getDecimalStyle(wb, (Map)property.get("DecimalFormat")));
                } else {
                    if ("basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType) || "refbilldata".equals(inputType) || "geoPointField".equals(inputType)) {
                        offset = this.splitColumn(wb, sheet, nameRow, titleRow, commentRow, styles, format, property, fieldName, offset, titleRowIndex, propDisplayNames, mustInput, isExptType, defaultColWidth);
                        continue;
                    }
                    sheet.setDefaultColumnStyle(format.col + offset, styles.getTitleStyle());
                }
                String propName = property.get("propName") instanceof String ? (String)property.get("propName") : "";
                ListDataExporter.writeComment(wb, commentRow, format, styles, property, propName, null, offset);
            }
            String caption = "";
            if (property != null) {
                String displayName = (String)property.get("DisplayName");
                if (format.getExchangeNameAndMark().booleanValue() && StringUtils.isNotBlank((Object)property.get("EntityDescription"))) {
                    String description = (String)property.get("EntityDescription");
                    displayName = ExportWriter.getRealDescByInputType(description, property, null, fieldName);
                }
                if (this.headerMap.containsKey(fieldName)) {
                    displayName = this.headerMap.get(fieldName);
                }
                caption = (mustInput ? "*" : "") + displayName;
            }
            if (!isExptType) {
                ListDataExporter.createCell(wb, nameRow, format.col + offset, styles.getTitleStyle()).setCellValue(fieldName);
            }
            SXSSFCell cell = ListDataExporter.createCell(wb, titleRow, format.col + offset, mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle(DEFAULT));
            cell.setCellValue(caption);
            if (format.col + offset != 0 && property != null) {
                Object colWidth = property.get(COLWIDTH_KEY);
                int designatedColWidth = colWidth instanceof Integer ? (Integer)colWidth : 0;
                sheet.setColumnWidth(format.col + offset, ListDataExporter.calcColumnWidth(caption, defaultColWidth, designatedColWidth));
            }
            if (property != null && property.containsKey("InputDesc")) {
                String tip = (String)property.getOrDefault("InputDesc", "");
                ListDataExporter.bindCellTip(sheet, cell, format.col + offset, titleRowIndex, tip);
            }
            ++offset;
        }
        for (ExportWriterFormat wr : format.next) {
            offset += this.writeHeader(wb, sheet, dropdownSheet, styles, wr, propDisplayNames, preOffset, isExptType);
        }
        return offset;
    }

    private int splitColumn(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFRow nameRow, SXSSFRow titleRow, SXSSFRow commentRow, ExportSheetStyle styles, ExportWriterFormat format, Map<String, Object> property, String fieldName, int offset, int titleRowIndex, Map<Integer, String> propDisplayNames, boolean mustInput, boolean isExptType, int defaultColWidth) {
        List<String> splitCols = format.flexColumn.get(fieldName);
        List<String> splitColDisplayNames = format.flexColumnDisplay.get(fieldName);
        List<String> splitColDesc = format.flexColumnDesc.get(fieldName);
        List<String> propList = ExportWriter.getPropList(splitCols);
        if (splitCols != null) {
            for (int j = 0; j < splitCols.size(); ++j) {
                Object colWidth;
                String displayName = ExportWriter.dealDisplayName(j, format.getExchangeNameAndMark(), property, splitCols, splitColDisplayNames);
                int colIndex = format.col + offset;
                String colsName = splitCols.get(j);
                if (this.headerMap.containsKey(colsName)) {
                    displayName = this.headerMap.get(colsName);
                }
                propDisplayNames.put(colIndex, displayName);
                String caption = (j == 0 && mustInput ? "*" : "") + displayName;
                sheet.setDefaultColumnStyle(colIndex, styles.getTitleStyle());
                if (!isExptType) {
                    ListDataExporter.createCell(wb, nameRow, format.col + offset, styles.getNameStyle()).setCellValue(colsName);
                }
                SXSSFCell cell = ListDataExporter.createCell(wb, titleRow, colIndex, j == 0 && mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle(DEFAULT));
                cell.setCellValue(caption);
                if (j < splitColDesc.size()) {
                    ListDataExporter.bindCellTip(sheet, cell, format.col + offset, titleRowIndex, splitColDesc.get(j));
                }
                int designatedColWidth = (colWidth = property.get(COLWIDTH_KEY)) instanceof Integer ? (Integer)colWidth : 0;
                sheet.setColumnWidth(format.col + offset, ListDataExporter.calcColumnWidth(caption, defaultColWidth, designatedColWidth));
                ListDataExporter.writeComment(wb, commentRow, format, styles, property, colsName, propList, offset);
                ++offset;
            }
        }
        return offset;
    }

    private static void createDropdownList(SXSSFSheet sheet, int currCol, List<String> items, boolean isExptType) {
        String currColLabel = ListDataExporter.getColumnLabel(currCol + 1);
        String strFormula = String.format("dropdown_items_sheet!$%s$%d:$%s$%d", currColLabel, 1, currColLabel, items.size());
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(isExptType ? 1 : 4, 10000, currCol, currCol);
        DataValidationConstraint constraint = helper.createFormulaListConstraint(strFormula);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    private static void bindCellTip(SXSSFSheet sheet, SXSSFCell cell, int colSeq, int rowSeq, String tip) {
        if (StringUtils.isBlank((CharSequence)tip)) {
            return;
        }
        SXSSFDrawing p = sheet.createDrawingPatriarch();
        Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)colSeq), rowSeq, (short)colSeq + 2, rowSeq + 3));
        comment.setString((RichTextString)new XSSFRichTextString(tip));
        cell.setCellComment(comment);
    }

    private static void writeComment(SXSSFWorkbook wb, SXSSFRow commentRow, ExportWriterFormat format, ExportSheetStyle styles, Map<String, Object> property, String columnNumber, List<String> propList, int offset) {
        String entityDesc = (String)property.get("EntityDescription");
        if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            entityDesc = ExportWriter.getRealDescByInputType(entityDesc, property, propList, columnNumber);
        }
        if (format.getExchangeNameAndMark().booleanValue() && StringUtils.isNotBlank((CharSequence)entityDesc)) {
            String string = entityDesc = StringUtils.isNotBlank((Object)property.get("splitColumnName")) ? (String)property.get("splitColumnName") : (String)property.get("DisplayName");
        }
        if (format.col + offset == 0) {
            StringBuilder tips = ListDataExporter.buildTips(format, commentRow, entityDesc, property);
            CellStyle textHighLightStyle = styles.getTextHighLightStyle();
            textHighLightStyle.setVerticalAlignment(VerticalAlignment.TOP);
            textHighLightStyle.setWrapText(true);
            ListDataExporter.createCell(wb, commentRow, 0, textHighLightStyle).setCellValue(tips.toString());
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            ListDataExporter.createCell(wb, commentRow, format.col + offset, styles.getTextStyle()).setCellValue(entityDesc);
        }
    }

    private static StringBuilder buildTips(ExportWriterFormat format, SXSSFRow commentRow, String entityDesc, Map<String, Object> property) {
        StringBuilder strb = new StringBuilder();
        ArrayList<String> tips = new ArrayList<String>(8);
        tips.add(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"ListDataExporter_1", (String)BOS_EXPORT, (Object[])new Object[0]));
        tips.add(ResManager.loadKDString((String)"2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"ListDataExporter_2", (String)BOS_EXPORT, (Object[])new Object[0]));
        tips.add(ResManager.loadKDString((String)"3\u3001\u5982\u9700\u66f4\u65b0\u5df2\u6709\u6570\u636e\uff0c\u8bf7\u5148\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u8be5\u6570\u636e\uff0c\u4fee\u6539\u540e\u518d\u6b21\u5bfc\u5165\u3002", (String)"ListDataExporter_11", (String)BOS_EXPORT, (Object[])new Object[0]));
        tips.add(ResManager.loadKDString((String)"4\u3001\u5982\u9700\u540c\u65f6\u66f4\u65b0\u5355\u636e\u4f53\u6570\u636e\uff0c\u57fa\u4e8e\u7cfb\u7edf\u81ea\u52a8\u6839\u636e\u5355\u636e\u4f53\u5185\u7801\u5339\u914d\u66f4\u65b0\u6574\u884c\u5355\u636e\u4f53\uff0c\u8bf7\u5148\u5f00\u542f\u5bfc\u5165\u6a21\u677f\u4e2d\u5355\u636e\u4f53\u201c\u5185\u7801\u201d\u7684\u201c\u662f\u5426\u5bfc\u5165\u201d\u5c5e\u6027\uff0c\u5e76\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u9700\u66f4\u65b0\u7684\u6570\u636e\u3002", (String)"ListDataExporter_12", (String)BOS_EXPORT, (Object[])new Object[0]));
        if (format.getEnableSetNull().booleanValue()) {
            tips.add(ResManager.loadKDString((String)"#SetNULL\uff08\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5\uff09", (String)"ListDataExporter_9", (String)BOS_EXPORT, (Object[])new Object[0]));
        }
        if (format.getSplitSubEntries().booleanValue()) {
            tips.add("#SplitSubEntries");
        }
        if (format.getForUpdateMultiLangFields().booleanValue()) {
            tips.add("#ForUpdateMultiLangFields");
        }
        if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            tips.add("-----------");
            tips.add(entityDesc);
        }
        int radit = ListDataExporter.addTips(strb, tips);
        commentRow.setHeightInPoints((float)radit * commentRow.getSheet().getDefaultRowHeightInPoints());
        Object colWidth = property.get(COLWIDTH_KEY);
        int designatedColWidth = colWidth instanceof Integer ? (Integer)colWidth : 0;
        commentRow.getSheet().setColumnWidth(0, designatedColWidth > 0 ? designatedColWidth * 32 : 11500);
        commentRow.setHeightInPoints(-1.0f);
        return strb;
    }

    private static int addTips(StringBuilder strb, List<String> tips) {
        for (String tip : tips) {
            strb.append(tip).append("\r\n");
        }
        strb.delete(strb.length() - "\r\n".length(), strb.length());
        return tips.size();
    }

    public static String getColumnLabel(int columnNo) {
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append('Z');
            remainder = 26;
        } else {
            sb.append(sources[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(sources[remainder]);
        }
        return sb.reverse().toString();
    }

    private static int calcColumnWidth(String caption, int defColWidth, int designatedColWidth) {
        if (designatedColWidth > 0) {
            return designatedColWidth * 32;
        }
        int colWidth = 0;
        try {
            colWidth = Math.max(256 * defColWidth / 8 * 2, 256 * (caption.getBytes("GBK").length + 12));
        }
        catch (UnsupportedEncodingException e) {
            colWidth = 256 * (caption.getBytes(StandardCharsets.UTF_8).length + 8);
        }
        return Math.min(colWidth, 51200);
    }

    public int writeData(JSONObject data, int rowIndex, ExportWriterFormat format, boolean existAttachments, String attachment, boolean fillParent) throws Exception {
        Map<Integer, String> entities = this.styles.getEntities();
        Map<Integer, String> fieldnames = this.styles.getFieldnames();
        SXSSFRow row = ListDataExporter.getRow(this.sheet, rowIndex);
        int flexRowCount = 0;
        int last = ListDataExporter.getLastCellNum(this.sheet, entities, format.col + 1, this.getLastFieldNameCellNum(fieldnames));
        int startCol = format.col;
        while (startCol < last && !format.properties.isEmpty() && fieldnames.get(startCol) != null) {
            String fullName;
            String fullFieldName = fullName = fieldnames.get(startCol);
            String fieldName = fullName;
            if (StringUtils.isNotBlank((CharSequence)fullName) && (fieldName = fullFieldName.split("\\.")[0]).endsWith("_id")) {
                fieldName = fieldName.substring(0, fieldName.length() - 3) + ".id";
            }
            Map<String, Object> property = format.properties.get(fieldName);
            Object dataKeyObj = property.get("DataKey");
            Object inputType = property.get("InputType");
            Object dataObj = "id".equals(inputType) ? data.get((Object)"id") : data.get((Object)fieldName);
            String val = "";
            if (dataObj != null) {
                String dataKey;
                if (dataObj instanceof Boolean) {
                    val = Boolean.TRUE.equals(dataObj) ? ResManager.loadKDString((String)"\u662f", (String)"ListDataExporter_4", (String)BOS_EXPORT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ListDataExporter_5", (String)BOS_EXPORT, (Object[])new Object[0]);
                } else if (dataObj instanceof BigDecimal) {
                    val = ((BigDecimal)dataObj).toPlainString();
                } else if (StringUtils.isBlank((Object)dataKeyObj)) {
                    val = dataObj.toString();
                    if (inputType instanceof JSONArray) {
                        JSONArray inputArrType = (JSONArray)inputType;
                        ArrayList<String> valDesc = new ArrayList<String>();
                        List<String> valSplit = Arrays.asList(val.split(","));
                        String propType = (String)property.get("PropType");
                        boolean isMulCombo = "MulComboProp".equals(propType);
                        for (int i = 0; i < inputArrType.size(); ++i) {
                            String[] item = inputArrType.getString(i).split(" # ", -1);
                            if (item.length <= 1 || !(isMulCombo ? valSplit.contains(item[1]) : item[1].equals(val))) continue;
                            valDesc.add(item[0]);
                            if (!isMulCombo) break;
                        }
                        if (!valDesc.isEmpty()) {
                            val = String.join((CharSequence)",", valDesc);
                        }
                    }
                } else if (dataObj instanceof Map) {
                    dataKey = "";
                    if (dataKeyObj instanceof String) {
                        dataKey = (String)dataKeyObj;
                    } else if (fullFieldName.indexOf(46) > 0) {
                        dataKey = fullFieldName.substring(fullFieldName.indexOf(46) + 1);
                    }
                    if (dataKey.indexOf(46) >= 0) {
                        String[] dkeys = dataKey.split("\\.");
                        Object tempVal = ((Map)dataObj).get(dkeys[0]);
                        for (int i = 1; i < dkeys.length && tempVal instanceof Map; ++i) {
                            tempVal = ((Map)tempVal).get(dkeys[i]);
                        }
                        val = (String)tempVal;
                    } else {
                        Object dataVal = ((Map)dataObj).get(dataKey);
                        if ("flex".equals(inputType)) {
                            HashMap flexData = (HashMap)dataObj;
                            int flexStartCol = startCol;
                            for (Map.Entry entry : flexData.entrySet()) {
                                ListDataExporter.createCell(this.wb, row, flexStartCol, this.styles.getTextStyle()).setCellValue((String)entry.getKey());
                                ++flexStartCol;
                                Object flexValue = entry.getValue();
                                if (flexValue instanceof Map) {
                                    Map flexMap = (Map)flexValue;
                                    ListDataExporter.createCell(this.wb, row, flexStartCol, this.styles.getTextStyle()).setCellValue(flexMap.get(NUMBER) == null ? "" : flexMap.get(NUMBER).toString());
                                    ListDataExporter.createCell(this.wb, row, ++flexStartCol, this.styles.getTextStyle()).setCellValue(flexMap.get("name") == null ? "" : flexMap.get("name").toString());
                                    ++flexStartCol;
                                    continue;
                                }
                                ListDataExporter.createCell(this.wb, row, ++flexStartCol, this.styles.getTextStyle()).setCellValue((String)entry.getKey());
                                ++flexStartCol;
                            }
                            startCol += 24;
                            continue;
                        }
                        if ("multilang".equals(inputType)) {
                            dataVal = ((Map)dataObj).get(fullName.split("\\.")[1]);
                        }
                        val = dataVal == null ? "" : "" + dataVal;
                    }
                } else if (dataObj instanceof List && dataObj != null && !((List)dataObj).isEmpty()) {
                    dataKey = "";
                    if (dataKeyObj instanceof String) {
                        dataKey = (String)dataKeyObj;
                    } else if (dataKeyObj instanceof JSONArray && ((JSONArray)dataKeyObj).size() > 1) {
                        dataKey = fullName.endsWith(".name") ? ((JSONArray)dataKeyObj).getString(1) : ((JSONArray)dataKeyObj).getString(0);
                    }
                    List listData = (List)dataObj;
                    String[] subKeys = dataKey.split("\\.");
                    StringBuilder sb = new StringBuilder(val);
                    for (Object item : listData) {
                        sb.append(',').append(item instanceof Map ? ListDataExporter.get((Map)item, subKeys) : item);
                    }
                    val = sb.toString();
                    if (val.startsWith(",")) {
                        val = val.substring(1);
                    }
                }
            }
            if ("time".equals(inputType)) {
                ListDataExporter.createCell(this.wb, row, startCol, this.styles.getTextStyle()).setCellValue(ListDataExporter.formatTimeStr((Integer)dataObj));
            } else if ("date".equals(inputType)) {
                ListDataExporter.createCell(this.wb, row, startCol, this.styles.getDateStyle()).setCellValue((String)dataObj);
            } else if ("datetime".equals(inputType)) {
                ListDataExporter.createCell(this.wb, row, startCol, this.styles.getDatetimeStyle()).setCellValue((String)dataObj);
            } else if ("decimal".equals(inputType)) {
                if (dataObj instanceof NumberPrecision || dataObj instanceof Map) {
                    JSONObject dataMap = (JSONObject)JSONObject.toJSON((Object)dataObj);
                    BigDecimal decimal = new BigDecimal(dataMap.getOrDefault((Object)"result", (Object)0).toString());
                    if (!ListDataExporter.isDecimalTooBig(decimal.toString())) {
                        ListDataExporter.createCell(this.wb, row, startCol, this.styles.getDecimalStyle(this.wb, (Map<String, Object>)dataMap)).setCellValue(decimal.doubleValue());
                        dataObj = null;
                    } else if (dataObj instanceof Map) {
                        dataObj = decimal;
                    }
                }
                if (dataObj != null) {
                    ListDataExporter.createCell(this.wb, row, startCol, this.styles.getTextStyle()).setCellValue(dataObj.toString());
                }
            } else {
                if (val != null && val.length() >= Short.MAX_VALUE) {
                    val = String.format(ResManager.loadKDString((String)"\u6570\u636e\u957f\u5ea6\u8d85\u8fc7\u5355\u5143\u683c\u652f\u6301\u7684\u6700\u5927\u957f\u5ea6%s\u3002", (String)"ListDataExporter_6", (String)BOS_EXPORT, (Object[])new Object[0]), Short.MAX_VALUE);
                }
                ListDataExporter.createCell(this.wb, row, startCol, this.styles.getTextStyle()).setCellValue(val);
            }
            ++startCol;
        }
        if (existAttachments && StringUtils.isNotBlank((CharSequence)attachment)) {
            SXSSFCell cell = ListDataExporter.createCell(this.wb, row, this.getLastFieldNameCellNum(fieldnames) + 1, this.styles.getTextStyle());
            String zip_attach_url = String.format(ResManager.loadKDString((String)"\u9644\u4ef6-%s", (String)"ListDataExporter_7", (String)BOS_EXPORT, (Object[])new Object[0]), data.getString("id"));
            cell.setCellValue(zip_attach_url);
            XSSFHyperlink link = (XSSFHyperlink)this.wb.getCreationHelper().createHyperlink(HyperlinkType.FILE);
            link.setAddress(zip_attach_url);
            cell.setHyperlink((Hyperlink)link);
            ListDataExporter.bindCellTip(this.sheet, cell, this.getLastFieldNameCellNum(fieldnames) + 1, rowIndex, ResManager.loadKDString((String)"\u9884\u89c8\u65f6\u8bf7\u5c06\u9644\u4ef6\u538b\u7f29\u5305\u89e3\u538b\u4e3a\u5f53\u524d\u76ee\u5f55\u4e0b\u7684\u540c\u540d\u6587\u4ef6\u5939\u3002", (String)"ListDataExporter_8", (String)BOS_EXPORT, (Object[])new Object[0]));
            cell.setCellStyle(this.styles.getHlinkStyle());
        }
        int maxOffset = 0;
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (ExportWriterFormat wr : format.next) {
            String entityName = entities.get(wr.col);
            if (entityName != null) {
                entityName = entityName.split(" # ")[1];
            }
            if (!data.containsKey((Object)entityName)) continue;
            JSONArray subData = data.getJSONArray(entityName);
            int offset = 0;
            for (int i = 0; i < subData.size(); ++i) {
                int subOffset = this.writeData(subData.getJSONObject(i), rowIndex + offset, wr, false, null, fillParent);
                if (subOffset == 0) {
                    ++offset;
                    continue;
                }
                offset += subOffset;
            }
            if (maxOffset >= offset) continue;
            maxOffset = offset;
        }
        int rowCount = Math.max(flexRowCount, maxOffset);
        if (fillParent && rowCount > 1) {
            for (int f = 1; f < rowCount; ++f) {
                SXSSFRow fillRow = ListDataExporter.getRow(this.sheet, rowIndex + f);
                for (int t = format.col; t < last; ++t) {
                    this.copyCell(fillRow, t, row.getCell(t));
                }
            }
        }
        return rowCount;
    }

    public void writeAttachLink(int rowIndex, int col, String linkText) {
        SXSSFRow row = ListDataExporter.getRow(this.sheet, rowIndex);
        SXSSFCell cell = ListDataExporter.createCell(this.wb, row, col, this.styles.getTextStyle());
        cell.setCellValue(linkText);
        XSSFHyperlink link = (XSSFHyperlink)this.wb.getCreationHelper().createHyperlink(HyperlinkType.FILE);
        link.setAddress(linkText);
        cell.setHyperlink((Hyperlink)link);
        ListDataExporter.bindCellTip(this.sheet, cell, col, rowIndex, ResManager.loadKDString((String)"\u9884\u89c8\u65f6\u8bf7\u5c06\u9644\u4ef6\u538b\u7f29\u5305\u89e3\u538b\u4e3a\u5f53\u524d\u76ee\u5f55\u4e0b\u7684\u540c\u540d\u6587\u4ef6\u5939\u3002", (String)"ListDataExporter_8", (String)BOS_EXPORT, (Object[])new Object[0]));
        cell.setCellStyle(this.styles.getHlinkStyle());
    }

    private Integer getLastFieldNameCellNum(Map<Integer, String> fieldnames) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field tail = fieldnames.getClass().getDeclaredField("tail");
        ReflectionUtils.makeAccessible((Field)tail);
        return (Integer)((Map.Entry)tail.get(fieldnames)).getKey() + 1;
    }

    public void copyCell(SXSSFRow fillRow, int col, SXSSFCell oldCell) {
        if (oldCell == null) {
            return;
        }
        SXSSFCell newCell = ListDataExporter.createCell(this.wb, fillRow, col, oldCell.getCellStyle());
        if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.STRING)) {
            newCell.setCellValue(oldCell.getStringCellValue());
        } else if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.NUMERIC)) {
            if (DateUtil.isCellDateFormatted((Cell)oldCell)) {
                Date dt = DateUtil.getJavaDate((double)oldCell.getNumericCellValue());
                newCell.setCellValue(this.sFormat.format(dt));
            } else {
                newCell.setCellValue(oldCell.getNumericCellValue());
            }
        } else if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.BOOLEAN)) {
            newCell.setCellValue(oldCell.getBooleanCellValue());
        } else if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.FORMULA)) {
            newCell.setCellValue(oldCell.getCellFormula());
        }
    }

    private static String formatTimeStr(Integer timeObj) {
        if (timeObj == null || timeObj < 0) {
            return null;
        }
        int time = timeObj;
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    private static Object get(Map<String, Object> map, String[] keys) {
        Map tempMap = map;
        for (int i = 0; i < keys.length - 1 && tempMap instanceof Map; ++i) {
            tempMap = (Map)tempMap.get(keys[i]);
        }
        return tempMap != null ? tempMap.get(keys[keys.length - 1]) : null;
    }

    private static int getLastCellNum(SXSSFSheet sheet, Map<Integer, String> entityRow, int col, int last) {
        while (col < last) {
            String nextEntityName = entityRow.get(col);
            if (StringUtils.isNotBlank((CharSequence)nextEntityName)) {
                return col;
            }
            ++col;
        }
        return last;
    }

    public void handleData(JSONObject jsonObject, DynamicObjectType entityType, DynamicObject mainOrg) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            Object obj;
            if (prop instanceof DateTimeProp) {
                obj = jsonObject.get((Object)prop.getName());
                if (!StringUtils.isNotBlank((Object)obj)) continue;
                try {
                    Date datetime = InteTimeZone.getSysTimeZone().parse((String)obj);
                    if (prop instanceof DateProp) {
                        obj = ((DateProp)prop).getDateFormat().format(datetime);
                    } else {
                        InteTimeZone zone = ((DateTimeProp)prop).getTimeZone(Long.valueOf(mainOrg != null ? (Long)mainOrg.getPkValue() : 0L));
                        obj = zone.format(datetime);
                    }
                    jsonObject.put(prop.getName(), obj);
                }
                catch (ParseException e) {
                    log.error((Throwable)e);
                }
                continue;
            }
            if (prop instanceof AdminDivisionProp) {
                obj = jsonObject.get((Object)prop.getName());
                if (!StringUtils.isNotBlank((Object)obj)) continue;
                Object fullname = ORMUtil.getAdminDivisionFullName((String)obj.toString());
                jsonObject.put(prop.getName(), StringUtils.isNotBlank((Object)fullname) ? fullname.toString().replace('_', '/') : null);
                continue;
            }
            if (prop instanceof FlexProp) {
                this.handleFlexField(jsonObject, entityType, mainOrg, (FlexProp)prop);
                continue;
            }
            if (prop instanceof BasedataProp) {
                this.handleBaseDataField(jsonObject, entityType, mainOrg, (BasedataProp)prop);
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            JSONArray coll = jsonObject.getJSONArray(prop.getName());
            for (int i = 0; i < coll.size(); ++i) {
                JSONObject entryDataEntity = coll.getJSONObject(i);
                this.handleData(entryDataEntity, ((EntryProp)prop).getDynamicCollectionItemPropertyType(), mainOrg);
            }
        }
    }

    private void handleBaseDataField(JSONObject jsonObject, DynamicObjectType entityType, DynamicObject mainOrg, BasedataProp bdProp) {
        BasedataEntityType bdType = (BasedataEntityType)bdProp.getComplexType();
        if (bdType == null) {
            return;
        }
        if (bdType.getMasteridType() == 2) {
            MasterBasedataProp masterIdProp = (MasterBasedataProp)bdType.findProperty(bdType.getMasteridPropName());
            if (masterIdProp == null || masterIdProp.getComplexType() == null) {
                return;
            }
            BasedataEntityType refMasterType = (BasedataEntityType)masterIdProp.getComplexType();
            Map bdObj = (Map)jsonObject.get((Object)bdProp.getName());
            if (bdObj == null || !bdObj.containsKey(masterIdProp.getName())) {
                return;
            }
            Map refMasterObj = (Map)bdObj.get(masterIdProp.getName());
            if (refMasterObj == null) {
                return;
            }
            if (refMasterObj.containsKey(refMasterType.getNameProperty())) {
                String nameKey = StringUtils.isBlank((CharSequence)bdType.getNameProperty()) ? "name" : bdType.getNameProperty();
                bdObj.put(nameKey, refMasterObj.get(refMasterType.getNameProperty()));
            }
            if (refMasterObj.containsKey(refMasterType.getNumberProperty())) {
                String numberKey = StringUtils.isBlank((CharSequence)bdType.getNumberProperty()) ? NUMBER : bdType.getNumberProperty();
                bdObj.put(numberKey, refMasterObj.get(refMasterType.getNumberProperty()));
            }
        }
        DataEntityPropertyCollection properties = bdProp.getDynamicComplexPropertyType().getProperties();
        if (jsonObject.containsKey((Object)bdProp.getName()) && jsonObject.get((Object)bdProp.getName()) != null && jsonObject.get((Object)bdProp.getName()) instanceof Map) {
            Map bdObj = (Map)jsonObject.get((Object)bdProp.getName());
            for (Map.Entry entry : bdObj.entrySet()) {
                IDataEntityProperty property = (IDataEntityProperty)properties.get(entry.getKey());
                if (property instanceof MuliLangTextProp) {
                    Map map = (Map)entry.getValue();
                    String curLang = RequestContext.get().getLang().toString();
                    bdObj.put(entry.getKey(), map.get(curLang));
                }
                if (!(property instanceof ComboProp)) continue;
            }
        }
    }

    private void handleFlexField(JSONObject jsonObject, DynamicObjectType entityType, DynamicObject mainOrg, FlexProp flexProp) {
        if (this.flexEntityTypeReader == null) {
            String billEntityNumber = entityType.getName();
            for (IDataEntityType parentType = entityType.getParent(); parentType != null; parentType = parentType.getParent()) {
                billEntityNumber = parentType.getName();
            }
            this.flexEntityTypeReader = new FlexEntityTypeReader(billEntityNumber);
        }
        DynamicProperty refProp = entityType.getProperty(flexProp.getBasePropertyKey());
        JSONObject flexVal = jsonObject.getJSONObject(flexProp.getName());
        JSONObject refVal = jsonObject.getJSONObject(refProp.getName());
        if (flexVal != null && refVal != null) {
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)flexVal.getString("value"), Map.class);
            BasedataProp baseProp = (BasedataProp)refProp;
            FlexEntityType flexEntityType = this.flexEntityTypeReader.read(flexProp, baseProp, (Map)refVal);
            HashMap flexValMap = new HashMap();
            for (IDataEntityProperty flexObjectProp : flexEntityType.getProperties()) {
                String name = flexObjectProp.getName();
                String[] nameSplit = name.split("__");
                if (nameSplit.length <= 1) continue;
                try {
                    Object baseValue = valueMap.get(nameSplit[1]);
                    if (baseValue == null) continue;
                    if (flexObjectProp instanceof BasedataProp) {
                        String numPropKey;
                        if (baseValue instanceof Integer) {
                            baseValue = ((Integer)baseValue).longValue();
                        }
                        DynamicObject basedata = this.loadFlexBasedataObj(flexProp, (BasedataProp)flexObjectProp, baseValue);
                        String flexValKey = ((BasedataProp)flexObjectProp).getDisplayName().toString();
                        HashMap<String, Object> flexPropValMap = new HashMap<String, Object>();
                        String namePropKeys = ((BasedataProp)flexObjectProp).getDisplayProp();
                        if (StringUtils.isNotBlank((CharSequence)namePropKeys)) {
                            ArrayList<String> caption = new ArrayList<String>();
                            for (String propKey : namePropKeys.split(",")) {
                                Object propV = basedata.get(propKey);
                                if (!StringUtils.isNotBlank((Object)propV)) continue;
                                caption.add(propV.toString());
                            }
                            flexPropValMap.put("name", String.join((CharSequence)",", caption));
                        }
                        if (StringUtils.isNotBlank((CharSequence)(numPropKey = ((BasedataProp)flexObjectProp).getNumberProp()))) {
                            flexPropValMap.put(NUMBER, basedata.get(numPropKey));
                        }
                        flexValMap.put(flexValKey, flexPropValMap);
                        continue;
                    }
                    if (!(flexObjectProp instanceof TextProp)) continue;
                    String flexValKey = ((TextProp)flexObjectProp).getDisplayName().toString();
                    flexValMap.put(flexValKey, baseValue);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            jsonObject.put(flexProp.getName(), flexValMap);
        }
    }

    private DynamicObject loadFlexBasedataObj(FlexProp flexProp, BasedataProp bdProp, Object id) {
        String subExtName;
        String typeKey = flexProp.getName() + "_" + bdProp.getName();
        BasedataEntityType refBDType = this.flexRefBDTypes.get(typeKey);
        if (refBDType == null) {
            String namePropKeys = bdProp.getDisplayProp();
            HashSet<String> selectedFields = new HashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)bdProp.getNumberProp())) {
                selectedFields.add(bdProp.getNumberProp());
            }
            if (!StringUtils.isBlank((CharSequence)namePropKeys)) {
                String[] propKeys;
                for (String propKey : propKeys = namePropKeys.split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)propKey)) continue;
                    selectedFields.add(propKey);
                }
            }
            refBDType = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)bdProp.getBaseEntityId(), selectedFields);
            this.flexRefBDTypes.put(typeKey, refBDType);
        }
        String string = subExtName = StringUtils.isBlank((CharSequence)refBDType.getExtendName()) ? refBDType.getName() : refBDType.getExtendName();
        if (!this.flexBasedataObjs.containsKey(subExtName)) {
            this.flexBasedataObjs.put(subExtName, new HashMap());
        }
        if (this.flexBasedataObjs.get(subExtName).containsKey(id)) {
            return this.flexBasedataObjs.get(subExtName).get(id);
        }
        DynamicObject basedata = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (DynamicObjectType)refBDType);
        this.flexBasedataObjs.get(subExtName).put(id, basedata);
        return basedata;
    }

    public void formatData(DynamicObjectCollection coll, BillEntityType entityType, JSONArray jsonArr) {
        this.decimalFieldFormat.formatData(coll, entityType, jsonArr);
    }

    public void flush() throws IOException {
        this.sheet.flushRows();
    }

    public int getLastRowNum() {
        return this.sheet.getLastRowNum();
    }

    @Override
    public void clear() {
        try {
            this.flush();
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        CTWorksheet ctSheet = this.wb.getXSSFWorkbook().getSheet(this.sheet.getSheetName()).getCTWorksheet();
        ctSheet.getDimension().setRef("A1:" + ListDataExporter.getColumnLabel(this.headerOffset) + this.sheet.getPhysicalNumberOfRows());
    }

    public static boolean isDecimalTooBig(String decimalStr) {
        int i = decimalStr.lastIndexOf(46);
        int j = decimalStr.length();
        if (i >= 0) {
            --j;
            while (j > i && decimalStr.charAt(j) == '0') {
                --j;
            }
        }
        if (decimalStr.startsWith("-")) {
            --j;
        }
        return j > 15;
    }
}

