/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.DynamicTextListField;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.FormatRowData;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.AmountColumnDesc;
import kd.bos.entity.list.column.BaseDataColumnDesc;
import kd.bos.entity.list.column.BigIntColumnDesc;
import kd.bos.entity.list.column.BooleanColumnDesc;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.entity.list.column.DateTimeColumnDesc;
import kd.bos.entity.list.column.DecimalColumnDesc;
import kd.bos.entity.list.column.FlexColumnDesc;
import kd.bos.entity.list.column.IconColumnDesc;
import kd.bos.entity.list.column.IntegerColumnDesc;
import kd.bos.entity.list.column.NumberColumnDesc;
import kd.bos.entity.list.column.TimeColumnDesc;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IconProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.export.ExportListContext;
import kd.bos.mvc.export.ListExporter;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;

@Deprecated
public class ListExportRunnable
implements Runnable {
    private static Log log = LogFactory.getLog(ListExportRunnable.class);
    private ExportListContext ctx;
    private ListExporter exporter;

    @Deprecated
    public ListExportRunnable(BillList billList, ListExporter exporter, MainEntityType listEntityType, Set<String> zeroShow, List<KeyValue> fieldCaptions, String fileName, List<ListField> listFields, Object logId) {
        this(new ExportListContext().setLogId(logId).setFileName(fileName).setBillList(billList).setListEntityType(listEntityType).setZeroShow(zeroShow).setFieldCaptions(fieldCaptions).setListFields(listFields));
        this.exporter = exporter;
    }

    @Deprecated
    public ListExportRunnable(BillList billList, MainEntityType listEntityType, Set<String> zeroShow, List<KeyValue> fieldCaptions, String fileName, List<ListField> listFields, Object logId) {
        this(billList, null, listEntityType, zeroShow, fieldCaptions, fileName, listFields, logId);
    }

    public ListExportRunnable(ExportListContext expCtx) {
        this.ctx = expCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object logId = this.ctx.getLogId();
        String mainEntityDisplayName = this.ctx.getMainEntityDisplayName();
        int billDataCount = this.ctx.getBillDataCount();
        String expttype = this.ctx.getExptType();
        String fileName = this.ctx.getFileName();
        List<ListField> listFields = this.ctx.getListFields();
        BillList billList = this.ctx.getBillList();
        MainEntityType listEntityType = this.ctx.getListEntityType();
        Set<String> zeroShow = this.ctx.getZeroShow();
        List<KeyValue> fieldCaptions = this.ctx.getFieldCaptions();
        PageCache listCache = new PageCache(this.ctx.getListPageId());
        try {
            ExportLogHelper.create((Object)logId, (String)mainEntityDisplayName, (int)billDataCount, (String)expttype);
            log.debug("----\u5f00\u59cb\u6267\u884c\u5217\u8868\u5bfc\u51fa----" + fileName);
            if (this.exporter == null) {
                this.exporter = new ListExporter(ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e", (String)"ListExportRunnable_0", (String)"bos-export", (Object[])new Object[0]), fieldCaptions, true);
                log.debug("----\u5f00\u59cb\u6267\u884c\u5217\u8868\u5bfc\u51fa----\u6784\u9020exporter");
            }
            this.exportRows(billList, listEntityType, listFields, zeroShow, fieldCaptions, listCache, logId);
            String string = this.exporter.flush(listEntityType, fileName);
        }
        catch (Throwable e) {
            log.error(e);
            listCache.put(logId.toString(), "error");
            ExportLogHelper.logAll((Object)logId, null, (String)(e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ListExportRunnable_1", (String)"bos-export", (Object[])new Object[0])));
        }
        finally {
            listCache.remove("CacheKey_LIST_EXPORT_RUNNING");
        }
    }

    private void exportRows(BillList billList, MainEntityType listEntityType, List<ListField> listFields, Set<String> zeroShow, List<KeyValue> fieldCaptions, PageCache listCache, Object logId) {
        int start;
        int batchSize = 500;
        int selectedRowCount = this.ctx.getSelectedRows().size();
        QueryResult rows = null;
        HashSet<Object> idSet = new HashSet<Object>(16);
        if (listFields != null) {
            ListSelectedRowCollection subRowSelection = new ListSelectedRowCollection();
            for (start = 0; start < selectedRowCount; start += batchSize) {
                for (ListSelectedRow selectRow : this.ctx.getSelectedRows().subList(start, Math.min(start + batchSize, selectedRowCount))) {
                    subRowSelection.add((Object)selectRow);
                }
                log.debug("----\u5f00\u59cb\u6267\u884c\u5217\u8868\u5bfc\u51fa----\u52fe\u9009");
                rows = billList.getSelectedRowDatas(listFields, subRowSelection);
                if (rows != null && rows.getCollection() != null) {
                    log.debug("----\u5f00\u59cb\u6267\u884c\u5217\u8868\u5bfc\u51fa----\u4ece\u5217\u8868\u53d6\u6570" + rows.getCollection().size());
                    this.exporter.write(ListExportRunnable.formatRows(listEntityType, billList, zeroShow, rows, fieldCaptions, idSet));
                }
                int idSetSize = idSet.size();
                listCache.put(logId.toString(), Integer.toString(this.ctx.getBillDataCount() == idSetSize ? idSetSize - 1 : idSetSize));
                subRowSelection.clear();
            }
        } else {
            while (true) {
                log.debug("----\u5f00\u59cb\u6267\u884c\u5217\u8868\u5bfc\u51fa----\u5168\u90e8");
                rows = billList.queryBatchData(start, batchSize);
                if (rows == null || rows.getCollection().isEmpty()) break;
                start += rows.getCollection().size();
                log.debug("----\u5f00\u59cb\u6267\u884c\u5217\u8868\u5bfc\u51fa----\u683c\u5f0f\u5316" + rows.getCollection().size());
                List<List<Object>> dataRows = ListExportRunnable.formatRows(listEntityType, billList, zeroShow, rows, fieldCaptions, idSet);
                log.debug("----\u5f00\u59cb\u6267\u884c\u5217\u8868\u5bfc\u51fa----\u683c\u5f0f\u5316\u5b8c\u6210");
                this.exporter.write(dataRows);
                listCache.put(logId.toString(), Integer.toString(idSet.size()));
            }
        }
        listCache.put(logId.toString(), Integer.toString(this.ctx.getBillDataCount()));
        ExportLogHelper.log((Object)logId, (int)this.ctx.getBillDataCount());
    }

    private void notifyDownload(Object logId, MainEntityType mainEntityType, String url, Long uid) {
        log.debug("----\u5f00\u59cb\u6267\u884c\u5217\u8868\u5bfc\u51fa----\u5199\u65e5\u5fd7");
        ExportLogHelper.logAll((Object)logId, (String)url, (String)"");
        log.debug("----\u5f00\u59cb\u6267\u884c\u5217\u8868\u5bfc\u51fa----\u5199\u65e5\u5fd7\u5b8c\u6210");
        MessageInfo messageInfo = new MessageInfo();
        StringBuilder yzjMessage = new StringBuilder();
        yzjMessage.append(url);
        messageInfo.setTitle(ResManager.loadKDString((String)"\u5bfc\u51fa\u5df2\u5b8c\u6210\uff0c\u8bf7\u590d\u5236\u4e0b\u8f7d\u94fe\u63a5\u5728\u65b0\u9875\u7b7e\u4e2d\u6253\u5f00\u3002", (String)"ListExportRunnable_2", (String)"bos-export", (Object[])new Object[0]));
        messageInfo.setTag(mainEntityType.getDisplayName().toString());
        messageInfo.setContent(yzjMessage.toString());
        messageInfo.setMessageType("message");
        messageInfo.setUserIds(Collections.singletonList(uid));
        messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/ierp/index.html?formId=bos_exportlog&pkId=" + logId);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private static List<List<Object>> formatRows(MainEntityType listEntityType, BillList billList, Set<String> zeroShow, QueryResult rows, List<KeyValue> fieldCaptions, Set<Object> idSet) {
        ArrayList<List<Object>> dataRows = new ArrayList<List<Object>>();
        List formatRowDatas = rows.getFormatRowDatas();
        Map<String, ListField> fieldMapping = ListExportRunnable.buildFieldMapping(billList.getListModel().getProvider().getVisibleSelectFieldList());
        int i = 0;
        FormatObject format = InteServiceHelper.getUserFormat((Long)Long.parseLong(RequestContext.get().getUserId()));
        for (DynamicObject row : rows.getCollection()) {
            idSet.add(row.get("id"));
            NumberFormatProvider numFormat = rows.getNumberFormatProvider();
            ArrayList<Object> rowData = new ArrayList<Object>(10);
            for (KeyValue kv : fieldCaptions) {
                ListField f = fieldMapping.get(kv.key);
                Object value = null;
                if (f == null) {
                    value = ListExportRunnable.formatComplexColumn(listEntityType, formatRowDatas, format, numFormat, zeroShow, kv, fieldMapping, row, i);
                } else if (f instanceof DynamicTextListField) {
                    String formatExp = ((DynamicTextListField)f).getFormatExpression();
                    value = ListExportRunnable.formatDynamicTextListColumn(listEntityType, formatRowDatas, format, numFormat, zeroShow, kv, fieldMapping, row, i, formatExp);
                } else {
                    value = ListExportRunnable.formatNormalColumn(listEntityType, formatRowDatas, format, numFormat, zeroShow, kv, f, row, i);
                }
                if (value instanceof String) {
                    value = ((String)value).replaceAll("[\\p{C}&&[^\\s]&&[^\n]&&[^\r][^\t]]", "");
                }
                rowData.add(value);
            }
            dataRows.add(rowData);
            ++i;
        }
        return dataRows;
    }

    @Deprecated
    public static List<List<Object>> formatRows(MainEntityType listEntityType, BillList billList, Set<String> zeroShow, QueryResult rows, List<KeyValue> fieldCaptions) {
        return ListExportRunnable.formatRows(listEntityType, billList, zeroShow, rows, fieldCaptions, new HashSet<Object>(16));
    }

    private static Object formatNormalColumn(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, Set<String> zeroShow, KeyValue kv, ListField f, DynamicObject row, int i) {
        FormatRowData formatRow;
        AbstractColumnDesc columnDesc = f.getColumnDesc(row.getDynamicObjectType(), listEntityType.getMainOrg(), ListExportRunnable.isSpecialFormat(f));
        columnDesc.setUserFormat(format);
        Object value = ListExportRunnable.formatExportValue(row, columnDesc, numFormat, zeroShow.contains(kv.key));
        if (value == null && StringUtils.isNotBlank((Object)(value = (formatRow = formatRowDatas.get(i)).get(kv.key).getFieldValue()))) {
            if (columnDesc instanceof BaseDataColumnDesc) {
                columnDesc = ((BaseDataColumnDesc)columnDesc).getColumnDesc();
            }
            if (columnDesc instanceof TimeColumnDesc) {
                value = ListExportRunnable.formatTimeStr((Integer)value);
            } else if ((columnDesc instanceof DecimalColumnDesc || columnDesc instanceof AmountColumnDesc || columnDesc instanceof BigIntColumnDesc || columnDesc instanceof IntegerColumnDesc) && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0 && !zeroShow.contains(kv.key)) {
                value = null;
            } else if (columnDesc instanceof DateTimeColumnDesc && value.getClass().isArray() && ((Object[])value).length >= 2) {
                value = ((Object[])value)[0];
            }
        }
        return value;
    }

    private static String formatTimeStr(int time) {
        if (time < 0) {
            return null;
        }
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    private static Object formatComplexColumn(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, Set<String> zeroShow, KeyValue kv, Map<String, ListField> fieldMapping, DynamicObject row, int i) {
        Object value = null;
        if (kv.value instanceof KeyValue) {
            String v = "";
            for (String k : (List)((KeyValue)kv.value).value) {
                AbstractColumnDesc columnDesc = fieldMapping.get(k).getColumnDesc(row.getDynamicObjectType(), listEntityType.getMainOrg(), ListExportRunnable.isSpecialFormat(fieldMapping.get(k)));
                columnDesc.setUserFormat(format);
                value = ListExportRunnable.formatExportValue(row, columnDesc, numFormat, zeroShow.contains(k));
                if (value != null) {
                    v = v + " " + value;
                    continue;
                }
                value = formatRowDatas.get(i).get(k).getFieldValue();
                if (StringUtils.isNotBlank((Object)value)) {
                    if (columnDesc instanceof BaseDataColumnDesc) {
                        columnDesc = ((BaseDataColumnDesc)columnDesc).getColumnDesc();
                    }
                    if (columnDesc instanceof DecimalColumnDesc || columnDesc instanceof AmountColumnDesc || columnDesc instanceof BigIntColumnDesc || columnDesc instanceof IntegerColumnDesc) {
                        if (value.getClass().isArray() && ((Object[])value).length >= 2) {
                            value = ((Object[])value)[1];
                        }
                        if (BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0 && !zeroShow.contains(kv.key)) {
                            value = null;
                        }
                    } else if (columnDesc instanceof DateTimeColumnDesc && value.getClass().isArray() && ((Object[])value).length >= 2) {
                        value = ((Object[])value)[0];
                    }
                }
                if (value == null) continue;
                v = v + " " + value;
            }
            value = v;
        } else {
            FormatRowData formatRow = formatRowDatas.get(i);
            value = formatRow.get(kv.key).getFieldValue();
        }
        return value;
    }

    private static Object formatDynamicTextListColumn(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, Set<String> zeroShow, KeyValue kv, Map<String, ListField> fieldMapping, DynamicObject row, int i, String formatExp) {
        Object value = null;
        String v = formatExp == null ? "" : formatExp;
        for (String k : (List)((KeyValue)kv.value).value) {
            AbstractColumnDesc columnDesc = fieldMapping.get(k).getColumnDesc(row.getDynamicObjectType(), listEntityType.getMainOrg(), ListExportRunnable.isSpecialFormat(fieldMapping.get(k)));
            columnDesc.setUserFormat(format);
            value = ListExportRunnable.formatExportValue(row, columnDesc, numFormat, zeroShow.contains(k));
            if (value != null) {
                v = v.replace(String.format("{%s}", k), value.toString());
                continue;
            }
            value = formatRowDatas.get(i).get(k).getFieldValue();
            if (StringUtils.isNotBlank((Object)value)) {
                if (columnDesc instanceof BaseDataColumnDesc) {
                    columnDesc = ((BaseDataColumnDesc)columnDesc).getColumnDesc();
                }
                if (columnDesc instanceof DecimalColumnDesc || columnDesc instanceof AmountColumnDesc || columnDesc instanceof BigIntColumnDesc || columnDesc instanceof IntegerColumnDesc) {
                    if (value.getClass().isArray() && ((Object[])value).length >= 2) {
                        value = ((Object[])value)[1];
                    }
                    if (BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0 && !zeroShow.contains(kv.key)) {
                        value = null;
                    }
                } else if (columnDesc instanceof DateTimeColumnDesc && value.getClass().isArray() && ((Object[])value).length >= 2) {
                    value = ((Object[])value)[0];
                }
            }
            v = v.replace(String.format("{%s}", k), value != null ? value.toString() : "");
        }
        return v;
    }

    private static Object formatExportValue(DynamicObject dr, AbstractColumnDesc col, NumberFormatProvider numberFormatProvider, boolean zeroShow) {
        Object value = col.getValue(dr);
        if (StringUtils.isNotBlank((Object)value)) {
            if (col instanceof FlexColumnDesc) {
                FlexColumnDesc flexColumnDesc = (FlexColumnDesc)col;
                List flexValues = (List)FlexValueFormatUtils.getListDisplayValue((DynamicObject)dr, (FlexProp)((FlexProp)flexColumnDesc.getFieldProp()), (String)flexColumnDesc.getBasePropKey());
                ArrayList<String> displayValues = new ArrayList<String>();
                for (Map item : flexValues) {
                    String alias = (String)item.get("alias");
                    if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                    displayValues.add(alias);
                }
                value = String.join((CharSequence)"; ", displayValues);
            } else if (col instanceof ComboColumnDesc) {
                value = ListExportRunnable.formatComboItems((ComboColumnDesc)col, value);
            } else if (col instanceof TimeColumnDesc) {
                value = ListExportRunnable.formatTimeStr((Integer)value);
            } else if (col instanceof DecimalColumnDesc || col instanceof AmountColumnDesc || col instanceof BigIntColumnDesc || col instanceof IntegerColumnDesc) {
                NumberPrecision numberPrecision;
                if (value instanceof Object[] && ((Object[])value).length >= 2) {
                    value = ((Object[])value)[1];
                }
                value = StringUtils.isBlank((Object)value) || !zeroShow && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0 ? "" : ((numberPrecision = numberFormatProvider.getFormatPrecision(((ColumnDesc)col).getFieldProp().getName(), dr)) != null ? numberPrecision : new NumberPrecision((BigDecimal)value));
            } else if (col instanceof DateTimeColumnDesc && value.getClass().isArray()) {
                if (((Object[])value).length >= 2) {
                    value = ((Object[])value)[0];
                }
            } else if (col instanceof IconColumnDesc || col instanceof ColumnDesc && ((ColumnDesc)col).getSrcFieldProp() instanceof PictureProp) {
                value = "";
            } else if (col instanceof BooleanColumnDesc) {
                value = ListExportRunnable.formatBooleanColumn(value);
            } else if (col instanceof BaseDataColumnDesc) {
                AbstractColumnDesc columnDesc = ((BaseDataColumnDesc)col).getColumnDesc();
                if (columnDesc instanceof ComboColumnDesc) {
                    value = ListExportRunnable.formatComboItems((ComboColumnDesc)columnDesc, value);
                }
                if (columnDesc instanceof BooleanColumnDesc) {
                    value = ListExportRunnable.formatBooleanColumn(value);
                } else if (columnDesc instanceof ColumnDesc && ((ColumnDesc)columnDesc).getSrcFieldProp() instanceof PictureProp) {
                    value = "";
                } else if (columnDesc instanceof DateTimeColumnDesc && value.getClass().isArray()) {
                    if (((Object[])value).length >= 2) {
                        value = ((Object[])value)[0];
                    }
                } else if (columnDesc instanceof NumberColumnDesc) {
                    DynamicObject basedataObj = (DynamicObject)((BaseDataColumnDesc)col).getFieldProp().getValue((Object)dr);
                    value = ListExportRunnable.formatBasedataNumberColumn((NumberColumnDesc)columnDesc, basedataObj, zeroShow);
                }
            }
        }
        return value;
    }

    private static Object formatBooleanColumn(Object value) {
        if (value instanceof Boolean) {
            return Boolean.TRUE.equals(value) ? ResManager.loadKDString((String)"\u662f", (String)"ListExportRunnable_3", (String)"bos-export", (Object[])new Object[0]) : "";
        }
        return value;
    }

    private static Object formatBasedataNumberColumn(NumberColumnDesc numberCol, DynamicObject dr, boolean zeroShow) {
        IDataEntityProperty prop = numberCol.getFieldProp();
        Object value = null;
        if (prop != null && dr != null) {
            value = prop.getValueFast((Object)dr);
        }
        if (StringUtils.isBlank(value) || !zeroShow && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
            value = "";
        } else if ((value = numberCol.formatCell(dr, value, true)) instanceof Object[] && ((Object[])value).length >= 2) {
            value = ((Object[])value)[1];
        }
        return value;
    }

    private static Object formatComboItems(ComboColumnDesc col, Object value) {
        ArrayList<String> desc = new ArrayList<String>();
        boolean isMulCombo = col.getComboProp() instanceof MulComboProp;
        for (ValueMapItem item : col.getComboProp().getComboItems()) {
            if (!(isMulCombo ? ((String)value).contains(item.getValue()) : item.getValue().equals(value))) continue;
            desc.add(item.getName().toString());
        }
        return !desc.isEmpty() ? String.join((CharSequence)" ", desc) : value;
    }

    private static Map<String, ListField> buildFieldMapping(List<ListField> listFields) {
        HashMap<String, ListField> mapping = new HashMap<String, ListField>(16);
        for (ListField f : listFields) {
            mapping.put(f.getKey(), f);
        }
        return mapping;
    }

    private static boolean isSpecialFormat(ListField listField) {
        IDataEntityProperty srcProp = listField.getSrcFieldProp();
        boolean isSpecial = srcProp instanceof DecimalProp || srcProp instanceof IconProp || srcProp instanceof PictureProp || srcProp instanceof FlexProp;
        return isSpecial;
    }
}

