/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.exception.KDBizException;
import kd.bos.list.ListColumnType;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.service.metadata.export.MaxRow;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class ListExporter
extends ExcelWriter {
    private static final String CELLSTYLE_ALIGN_DEFAULT = "default";
    private SXSSFSheet sheet;
    private ExportSheetStyle styles;
    private List<KeyValue> fieldCaptions;
    public static final Pattern PATTERN_NUMERIC = Pattern.compile("^-{0,1}[0-9]+([.]{1}[0-9]+){0,1}$");
    private int rowCount = 0;
    private int totalOffset = 0;

    @Deprecated
    public ListExporter(String sheetName, List<KeyValue> fieldCaptions) {
        this.sheet = this.wb.createSheet(sheetName);
        this.styles = new ExportSheetStyle(this.wb);
        this.fieldCaptions = fieldCaptions;
        int col = 0;
        for (int i = 0; i < fieldCaptions.size(); ++i) {
            KeyValue colInfo = fieldCaptions.get(i);
            int colWidth = 0;
            String align = CELLSTYLE_ALIGN_DEFAULT;
            Object value = colInfo.value;
            if (colInfo.extend != null) {
                colWidth = (Integer)colInfo.extend[1];
                if (colInfo.extend[0].equals(3) && colWidth < 80) {
                    colWidth = 80;
                }
                align = (String)colInfo.extend[2];
            } else {
                value = ((KeyValue)value).key;
            }
            SXSSFCell cell = ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, 0), col, this.styles.getTitleStyle(align));
            cell.setCellValue((String)value);
            this.sheet.setColumnWidth(col, Math.min(256 * Math.max(colWidth / 8, Math.max(((String)value).length(), 8)) * 2, 51200));
            ++col;
        }
    }

    public ListExporter(String sheetName, List<KeyValue> fieldCaptions, boolean forList, String entityId) {
        if (!forList) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u6682\u65f6\u4e0d\u652f\u6301\u878d\u5408\u5217\u5bfc\u51fa\u3002", (String)"ListExporter_0", (String)"bos-export", (Object[])new Object[0]));
        }
        this.sheet = this.wb.createSheet(sheetName);
        this.styles = new ExportSheetStyle(this.wb, entityId);
        this.fieldCaptions = fieldCaptions;
        HashMap<Integer, MaxRow> cellSpanRow = new HashMap<Integer, MaxRow>();
        this.createHeader(fieldCaptions, 0, cellSpanRow);
        for (Map.Entry entry : cellSpanRow.entrySet()) {
            int col = (Integer)entry.getKey();
            MaxRow maxRow = (MaxRow)entry.getValue();
            Integer rowIndex = maxRow.getRowIndex();
            if (this.rowCount - rowIndex <= 0) continue;
            this.addMergedRegion(maxRow, this.rowCount, col, col);
        }
    }

    @Deprecated
    public ListExporter(String sheetName, List<KeyValue> fieldCaptions, boolean forList) {
        if (!forList) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u6682\u65f6\u4e0d\u652f\u6301\u878d\u5408\u5217\u5bfc\u51fa\u3002", (String)"ListExporter_0", (String)"bos-export", (Object[])new Object[0]));
        }
        this.sheet = this.wb.createSheet(sheetName);
        this.styles = new ExportSheetStyle(this.wb);
        this.fieldCaptions = fieldCaptions;
        HashMap<Integer, MaxRow> cellSpanRow = new HashMap<Integer, MaxRow>();
        this.createHeader(fieldCaptions, 0, cellSpanRow);
        for (Map.Entry entry : cellSpanRow.entrySet()) {
            int col = (Integer)entry.getKey();
            MaxRow maxRow = (MaxRow)entry.getValue();
            Integer rowIndex = maxRow.getRowIndex();
            if (this.rowCount - rowIndex <= 0) continue;
            this.addMergedRegion(maxRow, this.rowCount, col, col);
        }
    }

    private int[] createHeader(List<KeyValue> captions, int rowIndex, Map<Integer, MaxRow> cellSpanRow) {
        KeyValue colInfo;
        int i;
        int[] span = new int[]{1, 0};
        HashMap<Integer, Integer> newCol = new HashMap<Integer, Integer>();
        for (i = 0; i < captions.size(); ++i) {
            colInfo = captions.get(i);
            if (!(colInfo.value instanceof KeyValue)) {
                newCol.put(i, this.totalOffset);
                this.creatHeaderCell((String)colInfo.value, colInfo.extend, rowIndex);
                ++this.totalOffset;
                span[1] = span[1] + 1;
                continue;
            }
            this.creatHeaderCell(((KeyValue)colInfo.value).key, colInfo.extend, rowIndex);
            if (colInfo.extend != null && (((Integer)colInfo.extend[0]).intValue() == ListColumnType.MergeColumn.getValue() || ((Integer)colInfo.extend[0]).intValue() == ListColumnType.DynamicTextList.getValue())) {
                newCol.put(i, this.totalOffset);
                ++this.totalOffset;
                span[1] = span[1] + 1;
                continue;
            }
            int col = this.totalOffset;
            int[] subSpan = this.createHeader((List)((KeyValue)colInfo.value).value, rowIndex + 1, cellSpanRow);
            if (span[0] < subSpan[0] + 1) {
                span[0] = subSpan[0] + 1;
            }
            span[1] = span[1] + subSpan[1];
            if (subSpan[1] <= 1) continue;
            this.addMergedRegion(new MaxRow(rowIndex, HorizontalAlignment.CENTER), rowIndex, col, col + Math.max(0, subSpan[1] - 1));
        }
        for (i = 0; i < captions.size(); ++i) {
            colInfo = captions.get(i);
            if (colInfo.value instanceof KeyValue && (colInfo.extend == null || ((Integer)colInfo.extend[0]).intValue() != ListColumnType.MergeColumn.getValue() && ((Integer)colInfo.extend[0]).intValue() != ListColumnType.DynamicTextList.getValue())) continue;
            Object[] extend = colInfo.extend;
            String align = "center";
            if (extend != null && extend.length >= 3) {
                align = (String)extend[2];
            }
            cellSpanRow.put((Integer)newCol.get(i), new MaxRow(rowIndex, this.getAlignment(align)));
        }
        if (this.rowCount < rowIndex) {
            this.rowCount = rowIndex;
        }
        return span;
    }

    private void addMergedRegion(MaxRow maxRow, int lastRow, int firstCol, int lastCol) {
        Integer firstRow = maxRow.getRowIndex();
        HorizontalAlignment alignment = maxRow.getAlignment();
        CellRangeAddress cellRange = new CellRangeAddress(firstRow.intValue(), lastRow, firstCol, lastCol);
        this.sheet.addMergedRegion(cellRange);
        SXSSFCell cell = this.sheet.getRow(firstRow.intValue()).getCell(firstCol);
        CellStyle cellstyle = cell.getCellStyle();
        cellstyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellstyle.setAlignment(alignment);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)this.sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)this.sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)this.sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)this.sheet);
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.CENTER;
        }
    }

    private void creatHeaderCell(String caption, Object[] extend, int r) {
        int colWidth = 0;
        String align = CELLSTYLE_ALIGN_DEFAULT;
        if (extend != null && extend.length >= 3) {
            colWidth = (Integer)extend[1];
            if (extend[0].equals(3) && colWidth < 80) {
                colWidth = 80;
            }
            align = (String)extend[2];
        }
        CellStyle cellStyle = this.styles.getTitleStyle(align);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        SXSSFCell cell = ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, r), this.totalOffset, cellStyle);
        cell.setCellValue(caption);
        this.sheet.setColumnWidth(this.totalOffset, Math.min(256 * Math.max(colWidth / 8, Math.max(caption.length(), 8)) * 2, 30720));
    }

    public void write(List<List<Object>> dataRows) {
        for (List<Object> row : dataRows) {
            this.totalOffset = 0;
            this.writeLine(this.fieldCaptions, row, ++this.rowCount);
        }
    }

    public void writeLine(List<Object> dataRow) {
        this.totalOffset = 0;
        this.writeLine(this.fieldCaptions, dataRow, ++this.rowCount);
    }

    public void writeLine(List<KeyValue> captions, List<Object> row, int r) {
        for (int i = 0; i < captions.size(); ++i) {
            boolean isDynamicTextList;
            if (row.size() <= this.totalOffset) continue;
            KeyValue colInfo = captions.get(i);
            Object value = row.get(this.totalOffset);
            boolean bl = isDynamicTextList = colInfo.extend != null && ((Integer)colInfo.extend[0]).intValue() == ListColumnType.DynamicTextList.getValue();
            if (colInfo.value instanceof KeyValue && !isDynamicTextList) {
                if (colInfo.extend != null && ((Integer)colInfo.extend[0]).intValue() == ListColumnType.MergeColumn.getValue()) {
                    this.creatValueCell(value, colInfo.extend, r);
                    continue;
                }
                this.writeLine((List)((KeyValue)colInfo.value).value, row, r);
                continue;
            }
            this.creatValueCell(value, colInfo.extend, r);
        }
    }

    private void creatValueCell(Object value, Object[] extend, int r) {
        if (StringUtils.isBlank((Object)value)) {
            ++this.totalOffset;
            return;
        }
        String align = CELLSTYLE_ALIGN_DEFAULT;
        if (extend != null && extend.length >= 3) {
            align = (String)extend[2];
            if (extend[0].equals(2)) {
                if (value instanceof NumberPrecision || value instanceof Map) {
                    Map<String, Object> dataMap = new HashMap<String, BigDecimal>();
                    if (value instanceof NumberPrecision) {
                        dataMap.put("result", ((NumberPrecision)value).getResult() == null ? new BigDecimal(0) : ((NumberPrecision)value).getResult());
                        dataMap.put("sign", ((NumberPrecision)value).getSign());
                        dataMap.put("precision", ((NumberPrecision)value).getPrecision());
                        dataMap.put("showSign", ((NumberPrecision)value).isShowSign());
                        dataMap.put("groupingUsed", ((NumberPrecision)value).isGroupingUsed());
                        dataMap.put("stripTrailingZeros", ((NumberPrecision)value).isStripTrailingZeros());
                    } else if (value instanceof Map) {
                        dataMap = (Map)value;
                    }
                    BigDecimal decimal = new BigDecimal(((Object)dataMap.getOrDefault("result", 0)).toString());
                    ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, r), this.totalOffset++, this.styles.getDecimalStyle(this.wb, dataMap, align)).setCellValue(decimal.doubleValue());
                    return;
                }
                if (value instanceof BigDecimal || value instanceof String && ListExporter.isNumeric(value.toString()) && !ListDataExporter.isDecimalTooBig(value.toString())) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    BigDecimal bigDecimalValue = new BigDecimal(value.toString());
                    int scale = bigDecimalValue.scale();
                    dataMap.put("precision", scale);
                    ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, r), this.totalOffset++, this.styles.getDecimalStyle(this.wb, dataMap, align)).setCellValue(bigDecimalValue.doubleValue());
                    return;
                }
                ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, r), this.totalOffset++, this.styles.getTextStyle(align)).setCellValue(value.toString());
                return;
            }
            if (extend[0].equals(3) || extend[0].equals(4)) {
                ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, r), this.totalOffset++, this.styles.getDateStyle(align)).setCellValue(value.toString());
                return;
            }
        }
        ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, r), this.totalOffset++, this.styles.getTextStyle(align)).setCellValue(value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : (value == null ? "" : value.toString()));
    }

    public static boolean isNumeric(String str) {
        if (str == null || "".equals(str)) {
            return false;
        }
        return PATTERN_NUMERIC.matcher(str).matches();
    }

    public void writeLine(List<Object> row, int r) {
        int col = 0;
        for (int i = 0; i < this.fieldCaptions.size(); ++i) {
            Object value = row.get(i);
            if (StringUtils.isBlank((Object)value)) {
                ++col;
                continue;
            }
            Object[] colExtend = this.fieldCaptions.get((int)i).extend;
            String align = CELLSTYLE_ALIGN_DEFAULT;
            if (colExtend != null) {
                align = (String)colExtend[2];
                if (colExtend[0].equals(2)) {
                    if (value instanceof NumberPrecision || value instanceof Map) {
                        Map<String, Object> dataMap = new HashMap<String, BigDecimal>();
                        if (value instanceof NumberPrecision) {
                            dataMap.put("result", ((NumberPrecision)value).getResult() == null ? new BigDecimal(0) : ((NumberPrecision)value).getResult());
                            dataMap.put("sign", ((NumberPrecision)value).getSign());
                            dataMap.put("precision", ((NumberPrecision)value).getPrecision());
                            dataMap.put("showSign", ((NumberPrecision)value).isShowSign());
                            dataMap.put("groupingUsed", ((NumberPrecision)value).isGroupingUsed());
                            dataMap.put("stripTrailingZeros", ((NumberPrecision)value).isStripTrailingZeros());
                        } else if (value instanceof Map) {
                            dataMap = (Map)value;
                        }
                        BigDecimal decimal = new BigDecimal(((Object)dataMap.getOrDefault("result", 0)).toString());
                        ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, r), col++, this.styles.getDecimalStyle(this.wb, dataMap, align)).setCellValue(decimal.doubleValue());
                        continue;
                    }
                    ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, r), col++, this.styles.getTextStyle(align)).setCellValue(value.toString());
                    continue;
                }
                if (colExtend[0].equals(3)) {
                    try {
                        Date datetime = value instanceof Long ? new Date((Long)value) : new SimpleDateFormat("yyyy-MM-dd H:m:s").parse(value.toString());
                        ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, r), col++, this.styles.getDatetimeStyle(align)).setCellValue(datetime);
                    }
                    catch (ParseException e) {
                        ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, r), col++, this.styles.getDateStyle(align)).setCellValue(value.toString());
                    }
                    continue;
                }
            }
            ListExporter.createCell(this.wb, ListExporter.getRow(this.sheet, r), col++, this.styles.getTextStyle(align)).setCellValue(value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : (value == null ? "" : value.toString()));
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void dispose() {
        this.getWb().dispose();
    }
}

