/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.mvc.export.ExportDataContext;
import kd.bos.mvc.export.dataconvert.IExportDataConvert;
import kd.bos.mvc.export.dataconvert.IExportPropConvert;

abstract class AbstractExportDataConvert
implements IExportDataConvert {
    private ExportDataContext context;
    private Map<String, IExportPropConvert> propConverts = new HashMap<String, IExportPropConvert>();

    AbstractExportDataConvert() {
    }

    public ExportDataContext getContext() {
        return this.context;
    }

    public IExportPropConvert getPropConvert(IDataEntityProperty prop) {
        String fullPropName = prop.getParent().getName() + "." + prop.getName();
        IExportPropConvert propConvert = this.propConverts.get(fullPropName);
        if (propConvert == null && (propConvert = IExportPropConvert.get(prop)) != null) {
            propConvert.initialize(this.getContext(), this);
            this.propConverts.put(fullPropName, propConvert);
        }
        return propConvert;
    }

    @Override
    public void initialize(ExportDataContext context) {
        this.context = context;
    }

    @Override
    public boolean beginBatch(DynamicObject[] billObjs, int rowIndex) {
        return true;
    }

    @Override
    public boolean beginBill(DynamicObject billObj) {
        return true;
    }

    @Override
    public boolean beginEntryRow(IDataEntityType entryType, DynamicObject entryRow) {
        return true;
    }

    @Override
    public void convertValue(IDataEntityProperty prop, Object value) {
    }

    @Override
    public void endEntryRow(IDataEntityType entryType, DynamicObject entryRow) {
    }

    @Override
    public void endBill(DynamicObject billObj) {
    }

    @Override
    public int endBatch(DynamicObject[] billObjs) {
        return 0;
    }

    @Override
    public void finished() {
    }
}

