/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.dataconvert.DesensitiveResult;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.export.dataconvert.ExportPropConvert;

class ExportDateTimeProp
extends ExportPropConvert {
    private static Log log = LogFactory.getLog(ExportDateTimeProp.class);

    public ExportDateTimeProp(IDataEntityProperty prop) {
        super(prop);
    }

    public DateTimeProp getDateTimeProp() {
        return (DateTimeProp)this.getProp();
    }

    @Override
    public Object formatValue(DynamicObject activeRow, Object value, ExportFileType exportFileType) {
        Object dateValue = this.formatDateValue(activeRow, this.getProp(), value);
        if (dateValue != null) {
            return dateValue;
        }
        if (value instanceof Date) {
            String timestamp = String.valueOf(((Date)value).getTime());
            if (timestamp.endsWith("000")) {
                return this.getDateTimeProp().format((Object)activeRow, (Date)value);
            }
            return this.getDateTimeProp().customFormat((Object)activeRow, (Date)value, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS"));
        }
        return value;
    }

    @Override
    protected void exportSubPropValue(DynamicObject activeRow, Object value) {
        Object formatValue = this.formatValue(activeRow, value, ExportFileType.JSArray);
        DesensitiveResult result = this.getSensitiveValue((IDataEntityProperty)this.getDateTimeProp(), formatValue, activeRow, null, this.getProp().getName());
        this.writeValue(result.getValue());
    }

    @Override
    protected Object formatDateValue(DynamicObject activeRow, IDataEntityProperty prop, Object value) {
        Map<String, String> dateFieldFormatMapping = this.getContext().getDateFieldFormatMapping();
        if (value instanceof Date && dateFieldFormatMapping.containsKey(prop.getName())) {
            String dateFormat = dateFieldFormatMapping.get(prop.getName());
            try {
                return this.getDateTimeProp().customFormat((Object)activeRow, (Date)value, new SimpleDateFormat(dateFormat.replace('Y', 'y')));
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return null;
    }
}

