/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportDataContext;
import kd.bos.mvc.export.dataconvert.DesensitiveResult;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.export.dataconvert.IExportDataConvert;
import kd.bos.mvc.export.dataconvert.IExportPropConvert;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;

class ExportPropConvert
implements IExportPropConvert {
    private static Log log = LogFactory.getLog(ExportPropConvert.class);
    private ExportDataContext context;
    private IExportDataConvert exportDataConvert;
    private IDataEntityProperty prop;
    private Map<Integer, Map<String, Object>> exportCols = new LinkedHashMap<Integer, Map<String, Object>>(1);
    private int col;

    public ExportPropConvert(IDataEntityProperty prop) {
        this.prop = prop;
    }

    public ExportDataContext getContext() {
        return this.context;
    }

    public IExportDataConvert getExportDataConvert() {
        return this.exportDataConvert;
    }

    @Override
    public IDataEntityProperty getProp() {
        return this.prop;
    }

    public Map<Integer, Map<String, Object>> getExportCols() {
        return this.exportCols;
    }

    @Override
    public void initialize(ExportDataContext context, IExportDataConvert exportDataConvert) {
        this.context = context;
        this.exportDataConvert = exportDataConvert;
    }

    @Override
    public int initColHeader(ExportWriterFormat colFormats, int col) {
        this.col = col;
        if (colFormats == null) {
            return col;
        }
        Map<String, Object> propertys = colFormats.properties.get(this.getProp().getName());
        if (propertys == null) {
            String fullPropName = this.getProp().getParent().getName() + "." + this.getProp().getName();
            propertys = colFormats.properties.get(fullPropName);
        }
        if (propertys == null) {
            return col;
        }
        return this.createColHeader(colFormats, propertys, col);
    }

    protected int createColHeader(ExportWriterFormat colFormats, Map<String, Object> propertys, int col) {
        int offset = 0;
        List<String> subCols = colFormats.flexColumn.get(this.getProp().getName());
        List<String> subColsDisplay = colFormats.flexColumn.get(this.getProp().getName());
        List<String> subColDesc = colFormats.flexColumnDesc.get(this.getProp().getName());
        boolean mustInput = Boolean.TRUE.equals(propertys.get("MustInput"));
        if (subCols == null || subCols.isEmpty()) {
            HashMap<String, Object> colPropertys = new HashMap<String, Object>(propertys);
            String caption = (mustInput ? "*" : "") + colPropertys.get("DisplayName") + " # " + this.getProp().getName();
            this.getExportDataConvert().writeColHeader(col, caption, colPropertys);
            this.exportCols.put(col, colPropertys);
            offset = 1;
        } else {
            for (int i = 0; i < subCols.size(); ++i) {
                int currCol = col + i;
                HashMap<String, Object> cellPropertys = new HashMap<String, Object>(propertys);
                String caption = (i == 0 && mustInput ? "*" : "") + subCols.get(i);
                cellPropertys.put("DataKey", this.getChildPropName(subColsDisplay.get(i)));
                if (subColDesc.size() > i) {
                    cellPropertys.put("InputDesc", subColDesc.get(i));
                }
                this.getExportDataConvert().writeColHeader(currCol, caption, cellPropertys);
                this.exportCols.put(currCol, cellPropertys);
            }
            offset = subCols.size();
        }
        return col + offset;
    }

    protected String getChildPropName(String colCaption) {
        if (StringUtils.isNotBlank((CharSequence)colCaption) && colCaption.indexOf(46) > 0) {
            return colCaption.substring(colCaption.indexOf(46) + 1);
        }
        return colCaption;
    }

    @Override
    public Object formatValue(DynamicObject activeRow, Object value, ExportFileType exportFileType) {
        return value;
    }

    @Override
    public void exportValue(DynamicObject activeRow, Object value) {
        if (!this.getExportDataConvert().isCanExport(this.getProp().getName())) {
            this.exportCanNotExportPropValue();
            return;
        }
        if (this.exportCols.isEmpty()) {
            return;
        }
        if (value == null) {
            this.deSensitiveNullValue(activeRow, value);
            return;
        }
        this.exportSubPropValue(activeRow, value);
    }

    protected void deSensitiveNullValue(DynamicObject activeRow, Object value) {
        for (Map.Entry<Integer, Map<String, Object>> colItem : this.getExportCols().entrySet()) {
            int col = colItem.getKey();
            Map<String, Object> cellPropertys = colItem.getValue();
            DesensitiveResult result = this.getSensitiveValue(this.getProp(), value, activeRow, null, this.getCurrentFieldName(cellPropertys));
            if (!result.isSensitive()) continue;
            this.writeValue(col, result.getValue(), cellPropertys);
        }
    }

    protected String getCurrentFieldName(Map<String, Object> cellProperties) {
        return this.getProp().getName();
    }

    protected void exportSubPropValue(DynamicObject activeRow, Object value) {
        if (value == null) {
            return;
        }
        for (Map.Entry<Integer, Map<String, Object>> colItem : this.getExportCols().entrySet()) {
            int col = colItem.getKey();
            Map<String, Object> cellPropertys = colItem.getValue();
            DesensitiveResult result = this.deSensitive(this.getProp().getName(), value, activeRow);
            this.writeValue(col, result.getValue().toString(), cellPropertys);
        }
    }

    protected void exportCanNotExportPropValue() {
        for (Map.Entry<Integer, Map<String, Object>> colItem : this.getExportCols().entrySet()) {
            int col = colItem.getKey();
            Map<String, Object> cellPropertys = colItem.getValue();
            this.writeValue(col, "******", cellPropertys);
        }
    }

    protected void writeValue(Object value) {
        this.getExportDataConvert().writeValue(this.col, value, this.getExportCols().get(this.col));
    }

    protected void writeValue(int col, Object value, Map<String, Object> cellPropertys) {
        this.getExportDataConvert().writeValue(col, value, cellPropertys);
    }

    protected DesensitiveResult deSensitive(String field, Object value, DynamicObject activeRow) {
        SensitiveArgs sensitiveArgs = this.getContext().getSensitiveArgs();
        DesensitiveResult result = new DesensitiveResult(value, false);
        if (sensitiveArgs == null || value == null) {
            return result;
        }
        if (sensitiveArgs.contain(field)) {
            SensitiveArgs.SensitiveRule rule = this.getContext().getSensitiveArgs().getRule(field);
            String exportVal = value.toString();
            exportVal = rule != null && Pattern.matches(rule.regex, exportVal) ? exportVal.replaceAll(rule.regex, rule.replacement) : this.getContext().getSensitiveArgs().getDesensitiveFun().handle(field, exportVal);
            result.setPluginSensitive(true);
            result.setValue(exportVal);
            return result;
        }
        return this.getSensitiveValue(this.getProp(), value, activeRow, null, field);
    }

    protected DesensitiveResult getSensitiveValue(IDataEntityProperty prop, Object value, DynamicObject activeRow, String localId, String fieldName) {
        DesensitiveResult result = new DesensitiveResult(value, false);
        if (StringUtils.isBlank((CharSequence)localId)) {
            localId = Lang.get().getLocale().toString();
        }
        Object desensitizeValue = value;
        try {
            boolean isDesensitizeField = PrivacyCenterServiceHelper.isDesensitizeField((IDataEntityProperty)prop, (String)localId, (String)"EXPORT", (DynamicObject)activeRow);
            if (!isDesensitizeField) {
                return result;
            }
            desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)prop, (String)localId, (String)"EXPORT", (DynamicObject)activeRow, (Object)value);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return result;
        }
        this.context.addSensitiveField(fieldName);
        result.setSensitive(true);
        result.setValue(desensitizeValue);
        return result;
    }

    protected Object formatDateValue(DynamicObject activeRow, IDataEntityProperty prop, Object value) {
        return value;
    }
}

