/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.NameVersionEntryType;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportDataContext;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.mvc.export.dataconvert.AbstractExportDataConvert;
import kd.bos.mvc.export.dataconvert.IExportPropConvert;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.service.metadata.export.ExportWriterFormat;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFRow;

class ExportToExcel
extends AbstractExportDataConvert {
    private static final int MAX_CELLCONTENT_LENGTH = Short.MAX_VALUE;
    private static final int MAX_MEMORY_ROW_HOLD_COUNT = 5000;
    private static final Log log = LogFactory.getLog(ExportToExcel.class);
    private boolean firstBatch = true;
    private int currBatchBeginRowIndex = 0;
    private int currBatchRowCount = 0;
    private int lastFlushEndRowIndex = 0;
    private RowMapper currBill;
    private int currBillBeginRowIndex = 0;
    private int lastCol;
    private RowMapper activeRow;
    private ExportWriterFormat headFormat = null;
    private Map<String, ExportWriterFormat> entryFormats = new HashMap<String, ExportWriterFormat>();
    private Map<String, Integer> entryLastCols = new HashMap<String, Integer>();
    private long mainOrgId;
    private Map<String, Integer> startEntryRowIndex = new HashMap<String, Integer>(4);
    private static final String REGEXATTACHMENT = "\n";

    ExportToExcel() {
    }

    public ListDataExporter getExcelWrite() {
        return (ListDataExporter)this.getContext().getExcelWriter();
    }

    @Override
    public void initialize(ExportDataContext context) {
        super.initialize(context);
    }

    private void flushRows() {
        try {
            this.getExcelWrite().flush();
            this.lastFlushEndRowIndex = this.currBillBeginRowIndex;
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDException((Throwable)e, new ErrorCode("ERROR FLUSH ROWS TO DISK", e.getMessage()), new Object[0]);
        }
    }

    @Override
    public boolean beginBatch(DynamicObject[] billObjs, int rowIndex) {
        this.currBatchBeginRowIndex = rowIndex;
        this.currBillBeginRowIndex = rowIndex;
        this.currBatchRowCount = 0;
        if (this.firstBatch) {
            this.initExcelHeader();
            this.lastFlushEndRowIndex = rowIndex;
        }
        return true;
    }

    @Override
    public int endBatch(DynamicObject[] billObjs) {
        this.firstBatch = false;
        return this.currBatchRowCount;
    }

    @Override
    public boolean beginBill(DynamicObject billObj) {
        SXSSFRow row = this.getExcelWrite().getRow(this.currBillBeginRowIndex);
        MainOrgProp mainOrgProp = this.getContext().getMainEntityType().getMainOrgProperty();
        long mainOrgId = 0L;
        if (mainOrgProp != null) {
            DynamicObject mainOrgObj = (DynamicObject)mainOrgProp.getValue((Object)billObj);
            mainOrgId = mainOrgObj != null ? (Long)mainOrgObj.getPkValue() : 0L;
        }
        this.mainOrgId = mainOrgId;
        this.activeRow = this.currBill = new RowMapper(null, billObj, this.headFormat, row, this.currBillBeginRowIndex);
        return true;
    }

    @Override
    public void writeAttachPanelMessage(Object pkValue) {
        List<Map<String, Object>> attachmentPanelAttS = this.getContext().getAttachArr().get(pkValue.toString());
        if (attachmentPanelAttS == null) {
            return;
        }
        this.writeAttachmentPanelAttNames(attachmentPanelAttS, this.entryFormats);
    }

    private void writeAttachmentPanelAttNames(List<Map<String, Object>> attachmentPanelAttS, Map<String, ExportWriterFormat> entryFormats) {
        List attachmentPanelFormatList = entryFormats.values().stream().filter(ExportWriterFormat::isAttachPanel).collect(Collectors.toList());
        for (ExportWriterFormat attachmentPanelFormat : attachmentPanelFormatList) {
            if (MapUtils.isEmpty(attachmentPanelFormat.properties) || attachmentPanelFormat.properties.size() > 1) continue;
            String attachmentPanelName = attachmentPanelFormat.name;
            LinkedHashSet<String> attachmentPanelNameSet = new LinkedHashSet<String>();
            for (Map<String, Object> attachmentPanelAtt : attachmentPanelAttS) {
                if (attachmentPanelName == null || attachmentPanelAtt.get("fattachmentpanel") == null || !StringUtils.equals((CharSequence)attachmentPanelAtt.get("fattachmentpanel").toString(), (CharSequence)attachmentPanelName)) continue;
                String attUrl = (String)attachmentPanelAtt.get("url");
                String attName = (String)this.getContext().getExportAttMessageMap().get((Object)attUrl);
                if (!StringUtils.isNotEmpty((CharSequence)attName)) continue;
                attachmentPanelNameSet.add(attName);
            }
            String attachmentPanelValue = String.join((CharSequence)REGEXATTACHMENT, attachmentPanelNameSet);
            int attachmentPanelCol = attachmentPanelFormat.col;
            CellStyle textStyle = this.getExcelWrite().getStyles().getTextStyle();
            this.getExcelWrite().createCell(this.activeRow.getExcelRow(), attachmentPanelCol, textStyle).setCellValue(attachmentPanelValue);
        }
    }

    @Override
    @Deprecated
    public void writeAttachLink() {
        this.getExcelWrite().writeAttachLink(this.currBillBeginRowIndex, this.lastCol + 1, this.getContext().getAttZipFileName());
    }

    @Override
    public void endBill(DynamicObject billObj) {
        int rowCount = this.currBill.getChildMaxRowCount();
        this.currBatchRowCount += rowCount;
        this.currBillBeginRowIndex += rowCount;
        this.fillParentCellValue(rowCount);
        this.activeRow.activeRow = null;
        this.activeRow.excelRow = null;
        this.activeRow.colFormats = null;
        this.activeRow.parent = null;
        this.activeRow = null;
        this.currBill.excelRow = null;
        this.currBill.activeRow = null;
        this.currBill.colFormats = null;
        this.currBill = null;
        if (this.currBillBeginRowIndex - this.lastFlushEndRowIndex >= 5000 || this.getExcelWrite().getLastRowNum() >= 5000) {
            this.flushRows();
        }
    }

    @Override
    public boolean beginEntryRow(IDataEntityType entryType, DynamicObject entryRow) {
        if (entryType instanceof LinkEntryType || entryType instanceof NameVersionEntryType) {
            return false;
        }
        RowMapper parentRow = this.activeRow;
        int rowIndex = parentRow.genChildCurrRowIndex(entryType.getName());
        SXSSFRow row = this.getExcelWrite().getRow(rowIndex);
        this.activeRow = new RowMapper(parentRow, entryRow, this.entryFormats.get(entryType.getName()), row, rowIndex);
        return true;
    }

    @Override
    public void endEntryRow(IDataEntityType entryType, DynamicObject entryRow) {
        Integer rowCount = this.activeRow.getChildMaxRowCount();
        this.activeRow.getParent().addChildRowCount(entryType.getName(), rowCount);
        this.fillParentCellValue(rowCount);
        this.activeRow = this.activeRow.getParent();
    }

    @Override
    public void convertValue(IDataEntityProperty prop, Object value) {
        IExportPropConvert propConvert = this.getPropConvert(prop);
        propConvert.exportValue(this.activeRow.getActiveRow(), value);
    }

    @Override
    public void writeColHeader(int col, String caption, Map<String, Object> cellPropertys) {
        if (col > this.lastCol) {
            this.lastCol = col;
        }
    }

    @Override
    public void writeValue(int col, Object value, Map<String, Object> cellPropertys) {
        if (value == null) {
            return;
        }
        if (cellPropertys == null) {
            this.getExcelWrite().createCell(this.activeRow.getExcelRow(), col, this.getExcelWrite().getStyles().getTextStyle()).setCellValue(value.toString());
            return;
        }
        Object inputType = cellPropertys.get("InputType");
        if ("time".equals(inputType)) {
            this.getExcelWrite().createCell(this.activeRow.getExcelRow(), col, this.getExcelWrite().getStyles().getTextStyle()).setCellValue((String)value);
        } else if ("date".equals(inputType)) {
            this.getExcelWrite().createCell(this.activeRow.getExcelRow(), col, this.getExcelWrite().getStyles().getDateStyle()).setCellValue((String)value);
        } else if ("datetime".equals(inputType)) {
            this.getExcelWrite().createCell(this.activeRow.getExcelRow(), col, this.getExcelWrite().getStyles().getDatetimeStyle()).setCellValue((String)value);
        } else if ("decimal".equals(inputType)) {
            Object dataObj = value;
            if (dataObj instanceof NumberPrecision || dataObj instanceof Map) {
                Map<String, Object> dataMap = new HashMap<String, BigDecimal>();
                if (dataObj instanceof NumberPrecision) {
                    dataMap.put("result", ((NumberPrecision)dataObj).getResult() == null ? new BigDecimal(0) : ((NumberPrecision)dataObj).getResult());
                    dataMap.put("sign", ((NumberPrecision)dataObj).getSign());
                    dataMap.put("precision", ((NumberPrecision)dataObj).getPrecision());
                    dataMap.put("showSign", ((NumberPrecision)dataObj).isShowSign());
                    dataMap.put("groupingUsed", ((NumberPrecision)dataObj).isGroupingUsed());
                    dataMap.put("stripTrailingZeros", ((NumberPrecision)dataObj).isStripTrailingZeros());
                } else if (dataObj instanceof Map) {
                    dataMap = (Map)dataObj;
                }
                BigDecimal decimal = new BigDecimal(((Object)dataMap.getOrDefault("result", 0)).toString());
                if (!ListDataExporter.isDecimalTooBig(decimal.toString())) {
                    this.getExcelWrite().createCell(this.activeRow.getExcelRow(), col, this.getExcelWrite().getDecimalStyle(dataMap)).setCellValue(decimal.doubleValue());
                    dataObj = null;
                } else if (dataObj instanceof Map) {
                    dataObj = decimal;
                }
            } else if (dataObj instanceof Number && !ListDataExporter.isDecimalTooBig(dataObj.toString())) {
                this.getExcelWrite().createCell(this.activeRow.getExcelRow(), col, this.getExcelWrite().getDecimalStyle(null)).setCellValue(Double.parseDouble(dataObj.toString()));
                dataObj = null;
            }
            if (dataObj != null) {
                this.getExcelWrite().createCell(this.activeRow.getExcelRow(), col, this.getExcelWrite().getStyles().getTextStyle()).setCellValue(dataObj.toString());
            }
        } else {
            String val;
            if (value instanceof BigDecimal) {
                value = new BigDecimal(((BigDecimal)value).stripTrailingZeros().toPlainString());
            }
            if ((val = value.toString()) != null && val.length() >= Short.MAX_VALUE) {
                val = String.format(ResManager.loadKDString((String)"\u6570\u636e\u957f\u5ea6\u8d85\u8fc7\u5355\u5143\u683c\u652f\u6301\u7684\u6700\u5927\u957f\u5ea6%s\u3002", (String)"ExportToExcel_1", (String)"bos-export", (Object[])new Object[0]), Short.MAX_VALUE);
            }
            this.getExcelWrite().createCell(this.activeRow.getExcelRow(), col, this.getExcelWrite().getStyles().getTextStyle()).setCellValue(val);
        }
    }

    @Override
    public boolean isCanExport(String field) {
        DynamicProperty property = this.getDynamicProperty(field);
        if (property instanceof TextProp && ((TextProp)property).isPassword()) {
            return false;
        }
        FieldControlRule fieldControlRule = this.getFieldControlRule(this.mainOrgId);
        if (fieldControlRule == null) {
            return true;
        }
        return !fieldControlRule.getCanNotReadFields().contains(field);
    }

    private DynamicProperty getDynamicProperty(String fieldName) {
        BillEntityType mainEntityType = this.getContext().getMainEntityType();
        Map entities = mainEntityType.getAllEntities();
        for (Map.Entry entry : entities.entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            DynamicProperty property = entityType.getProperty(fieldName);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    @Override
    public void finished() {
        super.finished();
    }

    @Override
    public Object getExportResult() {
        return null;
    }

    @Override
    public Integer getStartEntryRowIndex(String prop) {
        this.startEntryRowIndex.putIfAbsent(prop, 0);
        return this.startEntryRowIndex.get(prop);
    }

    @Override
    public void setStartEntryRowIndex(String prop, Integer startEntryRowIndex) {
        this.startEntryRowIndex.put(prop, startEntryRowIndex);
    }

    private void initExcelHeader() {
        this.headFormat = this.getContext().getFormats().get(0);
        int lastCol = this.initColHeader(this.headFormat);
        this.entryLastCols.put(this.headFormat.name, lastCol);
        this.initEntryFormats(this.headFormat.next);
    }

    private void initEntryFormats(List<ExportWriterFormat> nextEntryFormats) {
        if (nextEntryFormats == null || nextEntryFormats.isEmpty()) {
            return;
        }
        for (ExportWriterFormat entryFormat : nextEntryFormats) {
            int lastCol = this.initColHeader(entryFormat);
            this.entryFormats.put(entryFormat.name, entryFormat);
            this.entryLastCols.put(entryFormat.name, lastCol);
            this.initEntryFormats(entryFormat.next);
        }
    }

    private int initColHeader(ExportWriterFormat entryFormat) {
        int col = entryFormat.col;
        if (entryFormat.isAttachPanel()) {
            if (col > this.lastCol) {
                this.lastCol = col;
            }
            return col;
        }
        EntityType entityType = (EntityType)this.getContext().getSubMainType().getAllEntities().get(entryFormat.name);
        for (String propName : entryFormat.fields) {
            IExportPropConvert propConvert;
            IDataEntityProperty prop = (IDataEntityProperty)entityType.getProperties().get((Object)propName);
            if (prop == null) {
                String[] keys = propName.split("\\.");
                if (keys.length > 1) {
                    prop = (IDataEntityProperty)entityType.getProperties().get((Object)keys[keys.length - 1]);
                }
                if (prop == null) continue;
            }
            if ((propConvert = this.getPropConvert(prop)) == null) continue;
            col = propConvert.initColHeader(entryFormat, col);
        }
        return col > entryFormat.col ? col - 1 : entryFormat.col;
    }

    private void fillParentCellValue(int rowCount) {
        if (!this.getContext().isFillParent()) {
            return;
        }
        if (rowCount <= 1) {
            return;
        }
        int lastCol = this.entryLastCols.get(this.activeRow.getColFormats().name);
        for (int i = 1; i < rowCount; ++i) {
            int toRowIndex = this.activeRow.getRowIndex() + i;
            SXSSFRow toRow = this.getExcelWrite().getRow(toRowIndex);
            for (int col = this.activeRow.getColFormats().col; col <= lastCol; ++col) {
                this.getExcelWrite().copyCell(toRow, col, this.activeRow.excelRow.getCell(col));
            }
        }
    }

    private FieldControlRule getFieldControlRule(long orgId) {
        FieldControlRules fieldControlRules = this.getContext().getFieldControlRules();
        if (fieldControlRules == null) {
            return null;
        }
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        if (orgId != 0L) {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                if (!Objects.equals(listField.getMainOrgId(), orgId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(orgId)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        } else {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp = listField.getFieldControlRule();
                if (temp == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        }
        return fieldControlRule;
    }

    class RowMapper {
        private RowMapper parent;
        private DynamicObject activeRow;
        private ExportWriterFormat colFormats;
        private int rowIndex;
        private int lastCol;
        private SXSSFRow excelRow;
        private Map<String, Integer> childRowCounts = new HashMap<String, Integer>();

        public RowMapper(RowMapper parent, DynamicObject activeRow, ExportWriterFormat colFormats, SXSSFRow excelRow, int rowIndex) {
            this.parent = parent;
            this.activeRow = activeRow;
            this.colFormats = colFormats;
            this.excelRow = excelRow;
            this.rowIndex = rowIndex;
        }

        public RowMapper getParent() {
            return this.parent;
        }

        public DynamicObject getActiveRow() {
            return this.activeRow;
        }

        public ExportWriterFormat getColFormats() {
            return this.colFormats;
        }

        public SXSSFRow getExcelRow() {
            return this.excelRow;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public int getLastCol() {
            return this.lastCol;
        }

        public void setLastCol(int lastCol) {
            this.lastCol = lastCol;
        }

        public int genChildCurrRowIndex(String childEntryKey) {
            Integer rowCount = this.childRowCounts.get(childEntryKey);
            if (rowCount == null) {
                rowCount = 0;
            }
            return this.rowIndex + rowCount;
        }

        public int getChildMaxRowCount() {
            if (this.childRowCounts.isEmpty()) {
                return 1;
            }
            Integer rowCount = 1;
            for (Map.Entry<String, Integer> childEntry : this.childRowCounts.entrySet()) {
                if (Integer.compare(rowCount, childEntry.getValue()) >= 0) continue;
                rowCount = childEntry.getValue();
            }
            return rowCount;
        }

        public void addChildRowCount(String childEntryKey, Integer rowCount) {
            Integer oldRowCount = this.childRowCounts.get(childEntryKey);
            if (oldRowCount == null) {
                this.childRowCounts.put(childEntryKey, rowCount);
            } else {
                this.childRowCounts.put(childEntryKey, oldRowCount + rowCount);
            }
        }
    }
}

