/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.IImportServicePlugin;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.NameVersionEntryProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.RichTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.export.util.ImpExpAttachmentUtil;
import kd.bos.form.plugin.BeforeDownloadImportTemplateEvent;
import kd.bos.form.plugin.ImportTemplateListener;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.kingscript.host.ScriptProxyFactory;

public class ExportWriterBuilder {
    private static final String BOS_EXPORT = "bos-export";
    private static final String NUMBER = "number";
    public static final String BIZOBJECT = "bizobject";
    private static Log log = LogFactory.getLog(ExportWriterBuilder.class);
    private static final String INPUT_TYPE_KEY = "InputType";
    private static final String INPUT_FORMAT = "InputFormat";
    private static final String INPUT_PROPKEY = "ImportProp";
    private static final String INPUT_PROPNAME = "ImportPropName";
    private static final String INPUT_VALUES = "InputValues";
    private static final String INPUT_DESC_KEY = "InputDesc";
    private static final String INPUT_DATA_KEY = "DataKey";
    private static final String INPUT_DECIMAL_FORMAT = "DecimalFormat";
    private static final String COLWIDTH_KEY = "ColWidth";
    private static final String FLEX_PROP_GROUPS = "flexpropgroups";
    private static final String ENTITY_TEMP_LATEDESCKEY = "EntityDescription";
    private String kdName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExportWriterBuilder_2", (String)"bos-export", (Object[])new Object[0]);
    private String kdCode = ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExportWriterBuilder_1", (String)"bos-export", (Object[])new Object[0]);
    private String kdId = ResManager.loadKDString((String)"\u5185\u7801", (String)"ExportWriterBuilder_0", (String)"bos-export", (Object[])new Object[0]);
    private Map<String, String> defaultFieldNameMap = this.getDefaultFieldNameMap();

    public String build(String formId, long templateId, String pluginClassName, String extenddata) {
        return this.build(formId, templateId, pluginClassName, "", extenddata);
    }

    public String build(String formId, long templateId, String pluginClassName, String importPluginType, String extenddata) {
        HashMap fieldSetMapping = new HashMap();
        HashMap<String, Integer> fieldSeqMap = new HashMap<String, Integer>();
        boolean isForImport = templateId == 0L;
        DynamicObject templateData = null;
        if (templateId > 0L) {
            templateData = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"bos_importtemplate");
        }
        Object billEntity = null;
        if (StringUtils.isNotBlank((CharSequence)pluginClassName)) {
            try {
                IImportDataPlugin p = null;
                p = StringUtils.equals((CharSequence)importPluginType, (CharSequence)String.valueOf(4)) ? (IImportDataPlugin)ScriptProxyFactory.createPluginProxy((String)pluginClassName, ProjectInitializerManager::getEngineAutoDebug) : (IImportDataPlugin)TypesContainer.createInstance((String)pluginClassName);
                if (p instanceof IImportPlugin) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("ExtendData", extenddata);
                    ((IImportPlugin)p).init(params);
                }
                billEntity = p instanceof IImportServicePlugin ? ((IImportPlugin)p).getImportMainEntityType(formId) : p.getExportMainEntityType(formId, templateData);
            }
            catch (KDBizException e2) {
                log.error((Throwable)e2);
                throw new KDBizException((Throwable)e2, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6%1$s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff1a%2$s", (String)"MetadataServiceImpl_5", (String)BOS_EXPORT, (Object[])new Object[0]), pluginClassName, e2.getMessage())), new Object[0]);
            }
            catch (Exception e3) {
                log.error((Throwable)e3);
                throw new KDBizException((Throwable)e3, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6%1$s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff1a%2$s", (String)"MetadataServiceImpl_5", (String)BOS_EXPORT, (Object[])new Object[0]), pluginClassName, ResManager.loadKDString((String)"\u63d2\u4ef6\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ExportWriterBuilder_7", (String)BOS_EXPORT, (Object[])new Object[0]))), new Object[0]);
            }
        }
        DynamicObjectCollection templateEntry = null;
        List plugins = new ArrayList();
        if (templateData != null) {
            isForImport = !"EXPT".equalsIgnoreCase(templateData.getString("templatetype"));
            templateEntry = templateData.getDynamicObjectCollection("treeentryentity");
            String importTemplatePlugins = templateData.getString("plugin");
            List pluginsTmp = JSONObject.parseArray((String)importTemplatePlugins, Plugin.class);
            if (pluginsTmp != null) {
                plugins = pluginsTmp;
            }
            LinkedHashMap<String, DynamicObject> fieldSet = null;
            for (DynamicObject row : templateEntry) {
                String entityNumber = row.getString("entitynumber");
                if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
                    if (row.get("pid") == null || row.getLong("pid") == 0L) {
                        fieldSet = new LinkedHashMap<String, DynamicObject>();
                        fieldSetMapping.put(entityNumber, fieldSet);
                    } else if (fieldSet != null && Boolean.TRUE.compareTo(row.getBoolean("isimport")) == 0) {
                        fieldSet.put(entityNumber, row);
                    }
                }
                fieldSeqMap.put(entityNumber, (Integer)row.get("seq"));
            }
        }
        if (billEntity == null) {
            billEntity = (BillEntityType)EntityMetadataCache.getDataEntityType((String)formId);
        }
        List<Object> entityTypes = new ArrayList<Object>();
        Map<String, Map<String, IDataEntityProperty>> acrossProps = null;
        boolean isQueryEntity = false;
        if (billEntity instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)billEntity;
            entityTypes.add(queryType.getMainEntityType());
            entityTypes.addAll(queryType.getAllJoinEntityType());
            Map<String, MainEntityType> mainEntityMap = entityTypes.stream().collect(Collectors.toMap(DynamicObjectType::getName, entityType -> entityType));
            acrossProps = this.getAcrossPropMapping(templateEntry, mainEntityMap);
            isQueryEntity = true;
            entityTypes = entityTypes.stream().filter(e -> fieldSetMapping.isEmpty() || ((Map)fieldSetMapping.getOrDefault(e.getName(), new HashMap())).size() > 0).collect(Collectors.toList());
        } else {
            entityTypes.add(billEntity);
        }
        List<EnabledLang> enableLangs = this.getEnabledLangs(formId);
        int flexGroups = this.getFlexPropGroups(formId);
        ArrayList<ExportWriterFormat> formatlist = new ArrayList<ExportWriterFormat>(10);
        for (MainEntityType mainEntityType : entityTypes) {
            ExportWriterFormat writer = new ExportWriterFormat(mainEntityType.getName(), mainEntityType.getDisplayName().toString(), 0);
            int col = this.parse((DynamicObjectType)mainEntityType, fieldSetMapping.getOrDefault(mainEntityType.getName(), new HashMap()), writer, enableLangs, isForImport, flexGroups, acrossProps, isQueryEntity);
            this.setImportTemplateProp(writer, templateData);
            List<ExportWriterFormat> entryFormatList = writer.next;
            if (entryFormatList.size() > 0 && fieldSeqMap.size() > 0) {
                this.sortEntryFormat(entryFormatList, fieldSeqMap);
            }
            this.parseAttachmentPanel(templateId, templateData, ImpExpAttachmentUtil.getAttachmentPanelAps(mainEntityType.getName()), writer, mainEntityType.getName(), col);
            this.setImportTemplateProp(writer, templateData);
            formatlist.add(writer.ready(((Map)fieldSetMapping.getOrDefault(mainEntityType.getName(), new HashMap())).keySet()));
        }
        HashMap<String, List<String>> baseDataDropDownValues = new HashMap<String, List<String>>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Plugin plugin : plugins) {
            if (!plugin.isEnabled()) continue;
            ImportTemplateListener importTemplatePlugin = null;
            try {
                importTemplatePlugin = plugin.getType() == 4 ? (ImportTemplateListener)ScriptProxyFactory.createPluginProxy((String)plugin.getClassName(), ProjectInitializerManager::getEngineAutoDebug) : (ImportTemplateListener)TypesContainer.createInstance((String)plugin.getClassName());
            }
            catch (Exception e4) {
                log.error((Throwable)e4);
                String billNumber = ((DynamicObject)templateData.get(BIZOBJECT)).getString(NUMBER);
                String templateNumber = templateData.getString(NUMBER);
                throw new KDBizException((Throwable)e4, new ErrorCode("", String.format(ResManager.loadKDString((String)"%1$s\u7684\u5bfc\u5165\u6a21\u677f\uff1a%2$s\uff0c\u7ed1\u5b9a\u7684\u63d2\u4ef6%3$s\u65e0\u6cd5\u89e3\u6790\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"ExportWriterBuilder_3", (String)BOS_EXPORT, (Object[])new Object[0]), billNumber, templateNumber, plugin.getClassName(), ResManager.loadKDString((String)"\u63d2\u4ef6\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ExportWriterBuilder_7", (String)BOS_EXPORT, (Object[])new Object[0]))), new Object[0]);
            }
            for (ExportWriterFormat format : formatlist) {
                this.setBaseDataImportType(format, hashMap);
            }
            importTemplatePlugin.beforeSetBaseData(new BeforeDownloadImportTemplateEvent(entityTypes, baseDataDropDownValues, hashMap));
            for (ExportWriterFormat format : formatlist) {
                this.setBaseDataImportValues(format, baseDataDropDownValues);
            }
        }
        return JSON.toJSONString(formatlist);
    }

    private void parseAttachmentPanel(long templateId, DynamicObject templateData, List<AttachmentPanelAp> attachmentPanelAps, ExportWriterFormat writer, String entityNumber, int col) {
        if (CollectionUtils.isEmpty(attachmentPanelAps)) {
            return;
        }
        HashMap<String, DynamicObject> attPanelData = new HashMap<String, DynamicObject>();
        if (templateData != null) {
            DynamicObjectCollection attPanelTreeEntry = templateData.getDynamicObjectCollection("attpanel_treeentry");
            long pkId = 0L;
            for (DynamicObject dynamicObject : attPanelTreeEntry) {
                long pid = dynamicObject.getLong("pid");
                String attNumber = dynamicObject.getString("att_number");
                if (pid == 0L && StringUtils.equals((CharSequence)attNumber, (CharSequence)entityNumber)) {
                    pkId = (Long)dynamicObject.getPkValue();
                    continue;
                }
                if (pkId != pid || !dynamicObject.getBoolean("att_isimport")) continue;
                attPanelData.put(attNumber, dynamicObject);
            }
        }
        for (AttachmentPanelAp attachmentPanelAp : attachmentPanelAps) {
            String key = attachmentPanelAp.getKey();
            DynamicObject dynamicObject = (DynamicObject)attPanelData.get(key);
            if (dynamicObject == null) continue;
            LocaleString displayName = attachmentPanelAp.getName();
            ExportWriterFormat attPanelFormat = new ExportWriterFormat(key, displayName.getLocaleValue(), col);
            attPanelFormat.setAttachPanel(true);
            HashMap<String, Object> property = new HashMap<String, Object>(16);
            property.put("propName", key);
            property.put("DisplayName", displayName.getLocaleValue());
            property.put(INPUT_TYPE_KEY, "varchar");
            if (dynamicObject != null) {
                property.put("MustInput", dynamicObject.getBoolean("att_isinput"));
                property.put(ENTITY_TEMP_LATEDESCKEY, dynamicObject.getString("att_description"));
                property.put(COLWIDTH_KEY, dynamicObject.getInt("att_colwidth"));
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u540c\u4e00\u5355\u636e\u7684\u591a\u6587\u4ef6\uff0c\u5728\u540c\u4e00\u4e2a\u5355\u5143\u683c\u5185\u4ee5\u6362\u884c\u8fdb\u884c\u5206\u9694\u3002", (String)"ExportWriterBuilder_9", (String)BOS_EXPORT, (Object[])new Object[0]));
            }
            attPanelFormat.fields.add(key);
            attPanelFormat.properties.put(key, property);
            writer.next.add(attPanelFormat);
        }
    }

    private void sortEntryFormat(List<ExportWriterFormat> entryFormatList, Map<String, Integer> fieldSeqMap) {
        entryFormatList.sort(Comparator.comparingInt(format -> (Integer)fieldSeqMap.get(format.name)));
        for (ExportWriterFormat curEntryFormat : entryFormatList) {
            if (curEntryFormat.next.size() <= 0) continue;
            this.sortEntryFormat(curEntryFormat.next, fieldSeqMap);
        }
    }

    private void setBaseDataImportType(ExportWriterFormat format, Map<String, String> baseDataImportType) {
        if (format == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> property : format.properties.entrySet()) {
            Object importProp;
            Object inputType = property.getValue().get(INPUT_TYPE_KEY);
            if (inputType == null || !inputType.toString().equals("basedata") || !((importProp = property.getValue().get(INPUT_PROPKEY)) instanceof List) || ((List)importProp).isEmpty()) continue;
            baseDataImportType.put(property.getKey(), ((List)importProp).get(0).toString());
        }
        for (ExportWriterFormat exportWriterFormat : format.next) {
            this.setBaseDataImportType(exportWriterFormat, baseDataImportType);
        }
    }

    private void setBaseDataImportValues(ExportWriterFormat format, Map<String, List<String>> baseDataDropDownValues) {
        if (format == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> property : format.properties.entrySet()) {
            Object importProp;
            Object inputType = property.getValue().get(INPUT_TYPE_KEY);
            if (inputType == null || !inputType.toString().equals("basedata") || !((importProp = property.getValue().get(INPUT_PROPKEY)) instanceof List) || ((List)importProp).isEmpty()) continue;
            property.getValue().put(INPUT_VALUES, baseDataDropDownValues.getOrDefault(property.getKey(), new ArrayList()));
        }
        for (ExportWriterFormat exportWriterFormat : format.next) {
            this.setBaseDataImportValues(exportWriterFormat, baseDataDropDownValues);
        }
    }

    private Map<String, Map<String, IDataEntityProperty>> getAcrossPropMapping(DynamicObjectCollection templateEntry, Map<String, MainEntityType> mainEntityMap) {
        HashMap<String, Map<String, IDataEntityProperty>> acrossProps = new HashMap<String, Map<String, IDataEntityProperty>>();
        if (templateEntry == null) {
            return null;
        }
        LinkedHashMap<String, IDataEntityProperty> fieldSource = null;
        for (DynamicObject row : templateEntry) {
            String curMainEntity;
            String sourceEntity;
            String entityNumber = row.getString("entitynumber");
            if (!StringUtils.isNotBlank((CharSequence)entityNumber)) continue;
            if (row.get("pid") == null || row.getLong("pid") == 0L) {
                fieldSource = new LinkedHashMap<String, IDataEntityProperty>();
                acrossProps.put(entityNumber, fieldSource);
                continue;
            }
            if (fieldSource == null || Boolean.TRUE.compareTo(row.getBoolean("isimport")) != 0 || StringUtils.isBlank((CharSequence)(sourceEntity = row.getString("sourceentity"))) || !mainEntityMap.containsKey(curMainEntity = StringUtils.split((String)sourceEntity, (String)".")[0])) continue;
            fieldSource.put(entityNumber, mainEntityMap.get(curMainEntity).findProperty(entityNumber));
        }
        return acrossProps.isEmpty() ? null : acrossProps;
    }

    private void setImportTemplateProp(ExportWriterFormat writerFormat, DynamicObject templateData) {
        if (templateData != null) {
            writerFormat.setDescription(templateData.getString("comment"));
            writerFormat.setEnableSetNull(templateData.getBoolean("enablesetnull"));
            writerFormat.setHideFieldRow(templateData.getBoolean("hidefieldrow"));
            writerFormat.setExchangeNameAndMark(templateData.getBoolean("exchangenameandmark"));
            writerFormat.setSplitSubEntries(templateData.getBoolean("splitsubentries"));
            writerFormat.setForUpdateMultiLangFields(templateData.getBoolean("forupdatemultilangfields"));
            for (ExportWriterFormat nextWriterFormat : writerFormat.next) {
                this.setImportTemplateProp(nextWriterFormat, templateData);
            }
        }
    }

    private int getFlexPropGroups(String formId) {
        int groups = 16;
        DynamicObject billParameter = ParameterReader.getBillParameter((String)formId);
        if (null != billParameter && ((groups = billParameter.getInt(FLEX_PROP_GROUPS)) < 1 || groups > 50)) {
            return 16;
        }
        return groups;
    }

    private List<EnabledLang> getEnabledLangs(String formId) {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List multiLangEnabledLang = service.getMultiLangEnabledLang();
        IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
        Map settingOfMultilang = exportService.getSettingOfMultilang(formId);
        if (CollectionUtils.isEmpty((Map)settingOfMultilang)) {
            return multiLangEnabledLang;
        }
        ArrayList<EnabledLang> result = new ArrayList<EnabledLang>(multiLangEnabledLang.size());
        for (EnabledLang enabledLang : multiLangEnabledLang) {
            if (enabledLang.getIsDefault().booleanValue()) {
                result.add(enabledLang);
                continue;
            }
            String key = enabledLang.getNumber().toLowerCase();
            if (!settingOfMultilang.getOrDefault(key, Boolean.TRUE).booleanValue()) continue;
            result.add(enabledLang);
        }
        return result;
    }

    private boolean isSysParamExportId() {
        Map map = ParameterReader.loadPublicParameterFromCache();
        if (CollectionUtils.isEmpty((Map)map)) {
            return false;
        }
        if (map.containsKey("importtrmplatehasid")) {
            return (Boolean)map.get("importtrmplatehasid");
        }
        return false;
    }

    private int parse(DynamicObjectType entityType, Map<String, DynamicObject> fieldSet, ExportWriterFormat writer, List<EnabledLang> enableLangs, boolean isForImport, int flexGroups, Map<String, Map<String, IDataEntityProperty>> acrossProps, boolean isQueryEntity) {
        int col = writer.col;
        String ID2 = "id";
        String PID = "pid";
        DataEntityPropertyCollection properties = entityType.getProperties();
        String entityTypeName = entityType.getName();
        if (isQueryEntity && isForImport && acrossProps != null) {
            properties = new DataEntityPropertyCollection((List)properties, (IDataEntityType)entityType, false);
            this.handleAcrossProperties(properties, entityTypeName, acrossProps);
        }
        for (IDataEntityProperty prop : properties) {
            boolean isdate;
            Set<String> acrossPropNames;
            boolean isID = ID2.equalsIgnoreCase(prop.getName());
            boolean isPID = PID.equalsIgnoreCase(prop.getName());
            Set<String> set = acrossPropNames = acrossProps != null && acrossProps.containsKey(entityTypeName) ? acrossProps.get(entityType.getName()).keySet() : null;
            if ((fieldSet.isEmpty() || !isID && !isPID) && (prop instanceof FieldProp && ((FieldProp)prop).isSysField() ? !this.checkToExportId(fieldSet, prop, isID, isPID) : prop instanceof LongProp || prop instanceof DynamicLocaleProperty || prop instanceof IFieldHandle && !this.isFieldExportable(prop, isForImport) || prop instanceof FlexProp && !this.isControlFieldExportable((IDataEntityType)entityType, ((FlexProp)prop).getBasePropertyKey(), isForImport) && !this.isQueryEntityAcrossField(acrossPropNames, isQueryEntity, isForImport, prop.getName()) || prop instanceof ItemClassProp && !this.isControlFieldExportable((IDataEntityType)entityType, ((ItemClassProp)prop).getTypePropName(), isForImport) && !this.isQueryEntityAcrossField(acrossPropNames, isQueryEntity, isForImport, prop.getName()))) continue;
            String propName = prop.getName();
            if ((isID || isPID) && !(entityType instanceof MainEntityType)) {
                propName = prop.getParent().getName() + "." + propName;
            }
            if (prop instanceof LinkEntryProp || prop instanceof NameVersionEntryProp || prop instanceof RichTextProp) continue;
            if (prop instanceof EntryProp) {
                ExportWriterFormat subWriter = new ExportWriterFormat(propName, (((EntryProp)prop).isEntryMustInput() ? "*" : "") + ((EntryProp)prop).getDisplayName().toString(), col + 1);
                int subCol = this.parse(((EntryProp)prop).getDynamicCollectionItemPropertyType(), fieldSet, subWriter, enableLangs, isForImport, flexGroups, null, false);
                if (subCol - col >= 1 && subWriter.fields.size() > 0) {
                    writer.next.add(subWriter);
                    col = subCol;
                    continue;
                }
                col += 2;
                continue;
            }
            if (!(prop instanceof IFieldHandle) || (!isID && !isPID || !isForImport) && !((IFieldHandle)prop).isImportable() && !((IFieldHandle)prop).isExportable() || !fieldSet.isEmpty() && !fieldSet.containsKey(propName)) continue;
            String currLang = RequestContext.getOrCreate().getLang().name();
            DynamicObject templateRow = fieldSet.get(propName);
            ArrayList<String> props = new ArrayList<String>();
            HashMap<String, String> dateFieldFormatMapping = new HashMap<String, String>();
            ArrayList<String> dataKeyProps = new ArrayList<String>();
            ArrayList<String> propDisplayNames = new ArrayList<String>();
            boolean isBasedata = prop instanceof IBasedataField && !(prop instanceof AttachmentProp);
            boolean isRefbilldate = prop instanceof RefBillProp;
            boolean isMultiLang = prop instanceof MuliLangTextProp;
            boolean isLargeText = prop instanceof LargeTextProp;
            boolean isGeoPointField = prop instanceof GeoPointProp;
            boolean bl = isdate = prop instanceof DateTimeProp || prop instanceof TimeProp;
            if (isBasedata && templateRow != null) {
                this.prepareBasedataProps(props, dataKeyProps, propDisplayNames, templateRow, prop, currLang);
            } else if (isLargeText) {
                this.prepareLargeTextProps(props, propDisplayNames, prop, propName);
            } else if (isGeoPointField) {
                this.prepareGeoPointField(props, propDisplayNames, prop, propName);
            } else if (isdate && templateRow != null) {
                this.prepareDateFormat(dateFieldFormatMapping, templateRow, isForImport);
            }
            HashMap<String, Object> property = new HashMap<String, Object>(16);
            property.put("propName", propName);
            LocaleString displayName = null;
            if (isID) {
                displayName = new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"ExportWriterBuilder_0", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (isPID) {
                displayName = new LocaleString(ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ExportWriterBuilder_4", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof FieldProp) {
                displayName = ((FieldProp)prop).getDisplayName();
            } else if (prop instanceof BasedataProp) {
                displayName = ((BasedataProp)prop).getDisplayName();
            } else if (prop instanceof RefBillProp) {
                displayName = ((RefBillProp)prop).getDisplayName();
            } else if (prop instanceof MulBasedataProp) {
                displayName = ((MulBasedataProp)prop).getDisplayName();
            }
            property.put("DisplayName", displayName == null ? "" : displayName.toString());
            if (isID) {
                property.put(INPUT_TYPE_KEY, ID2);
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u5185\u7801\u662f\u5339\u914d\u5b9e\u4f53\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u5982\u9700\u66f4\u65b0\u5355\u636e\u4f53\u6216\u5b50\u5355\u636e\u4f53\uff0c\u8bf7\u5728\u5bfc\u5165\u6a21\u677f\u5f00\u542f\u5bf9\u5e94\u5185\u7801\u7684\u201c\u662f\u5426\u5bfc\u5165\u201d\u5c5e\u6027\u3002", (String)"ExportWriterBuilder_11", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (isPID) {
                property.put(INPUT_TYPE_KEY, PID);
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801\u662f\u6811\u5f62\u5355\u636e\u4f53\u4e0a\u7ea7\u884c\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u7528\u4e8e\u786e\u5b9a\u6570\u636e\u7684\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u3002", (String)"ExportWriterBuilder_5", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (isLargeText) {
                property.put(INPUT_TYPE_KEY, "largetext");
            } else if (isGeoPointField) {
                property.put(INPUT_TYPE_KEY, "geoPointField");
            } else if (isMultiLang) {
                property.put(INPUT_TYPE_KEY, "multilang");
            } else if (prop instanceof TextProp || prop instanceof VarcharProp) {
                property.put(INPUT_TYPE_KEY, "varchar");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u6587\u672c", (String)"ExportWriterBuilder_12", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof AdminDivisionProp) {
                property.put(INPUT_TYPE_KEY, "varchar");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u6587\u672c\uff0c\u6309\u7cfb\u7edf\u4e2d\u884c\u653f\u533a\u5212\u5b9e\u9645\u7684\u540d\u79f0\u586b\u5199\uff0c\u793a\u4f8b\uff1a\u4e2d\u56fd/\u5e7f\u4e1c\u7701/\u6df1\u5733\u5e02/\u5357\u5c71\u533a", (String)"MetadataServiceImpl_7", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof DecimalProp) {
                property.put(INPUT_TYPE_KEY, "decimal");
                HashMap<String, Integer> decimalformat = new HashMap<String, Integer>();
                decimalformat.put("precision", ((DecimalProp)prop).getScale());
                property.put(INPUT_DECIMAL_FORMAT, decimalformat);
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u6570\u5b57", (String)"ExportWriterBuilder_13", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof AttachmentProp) {
                property.put(INPUT_TYPE_KEY, "varchar");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u540c\u4e00\u5355\u636e\u7684\u591a\u6587\u4ef6\uff0c\u5728\u540c\u4e00\u4e2a\u5355\u5143\u683c\u5185\u4ee5\u6362\u884c\u8fdb\u884c\u5206\u9694\u3002", (String)"ExportWriterBuilder_9", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof PictureProp) {
                property.put(INPUT_TYPE_KEY, "varchar");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u82e5\u9700\u5bfc\u5165\u56fe\u7247\uff0c\u8bf7\u5728\u5355\u5143\u683c\u5f55\u5165\u201c\u56fe\u7247\u540d\u79f0+\u540e\u7f00\u201d\u6216\u201c\u56fe\u7247\u670d\u52a1\u5668\u8def\u5f84\u201d\u3002", (String)"ExportWriterBuilder_10", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (isBasedata) {
                property.put(INPUT_TYPE_KEY, prop instanceof FlexProp ? "flex" : "basedata");
                property.put(INPUT_PROPKEY, props);
                property.put(INPUT_PROPNAME, propDisplayNames);
            } else if (isRefbilldate) {
                property.put(INPUT_TYPE_KEY, prop instanceof FlexProp ? "flex" : "refbilldata");
                property.put(INPUT_PROPKEY, props);
                property.put(INPUT_PROPNAME, propDisplayNames);
            } else if (prop instanceof TimeProp) {
                property.put(INPUT_TYPE_KEY, "time");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a12:00:00", (String)"ExportWriterBuilder_14", (String)BOS_EXPORT, (Object[])new Object[0]));
                property.put(INPUT_FORMAT, dateFieldFormatMapping.get(propName));
            } else if (prop instanceof DateProp) {
                property.put(INPUT_TYPE_KEY, "date");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u65e5\u671f\uff0c\u793a\u4f8b\uff1a2018-05-01", (String)"ExportWriterBuilder_15", (String)BOS_EXPORT, (Object[])new Object[0]));
                property.put(INPUT_FORMAT, dateFieldFormatMapping.get(propName));
            } else if (prop instanceof DateTimeProp) {
                property.put(INPUT_TYPE_KEY, "datetime");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a2018-05-01 12:00:00", (String)"ExportWriterBuilder_16", (String)BOS_EXPORT, (Object[])new Object[0]));
                property.put(INPUT_FORMAT, dateFieldFormatMapping.get(propName));
            } else if (prop instanceof BooleanProp) {
                property.put(INPUT_TYPE_KEY, new String[]{ResManager.loadKDString((String)"\u662f", (String)"ExportWriterBuilder_17", (String)BOS_EXPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5426", (String)"ExportWriterBuilder_18", (String)BOS_EXPORT, (Object[])new Object[0])});
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u9009\u9879\uff0c\u662f/\u5426", (String)"ExportWriterBuilder_19", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof ComboProp) {
                try {
                    ArrayList itemList = new ArrayList(((ComboProp)prop).getComboItems());
                    Iterator iterator = itemList.iterator();
                    while (iterator.hasNext()) {
                        ValueMapItem next = (ValueMapItem)iterator.next();
                        if (next.isItemVisible()) continue;
                        iterator.remove();
                    }
                    String[] items = new String[itemList.size()];
                    CharSequence[] itemDesc = new String[itemList.size()];
                    for (int index = 0; index < itemList.size(); ++index) {
                        items[index] = ((ValueMapItem)itemList.get(index)).getName() + " # " + ((ValueMapItem)itemList.get(index)).getValue();
                        itemDesc[index] = ((ValueMapItem)itemList.get(index)).getName().toString();
                    }
                    property.put(INPUT_TYPE_KEY, items);
                    if (prop instanceof MulComboProp) {
                        property.put("PropType", "MulComboProp");
                        if (itemDesc.length == 0) {
                            property.put(INPUT_DESC_KEY, String.format(ResManager.loadKDString((String)"\u591a\u4e2a\u9009\u9879\u4ee5\u2018,\u2019\u5206\u9694", (String)"MetadataServiceImpl_15", (String)BOS_EXPORT, (Object[])new Object[0]), new Object[0]));
                        } else {
                            property.put(INPUT_DESC_KEY, String.format(ResManager.loadKDString((String)"\u53ef\u9009\u9879\uff1a%s\uff0c\u591a\u4e2a\u9009\u9879\u4ee5\u201c,\u201d\u5206\u9694\u3002", (String)"MetadataServiceImpl_14", (String)BOS_EXPORT, (Object[])new Object[0]), String.join((CharSequence)"\u3001", itemDesc)));
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0b\u62c9\u5217\u8868%1$s\u7684\u9009\u9879\u5931\u8d25\uff1akey=%2$s", (String)"ExportWriterBuilder_6", (String)BOS_EXPORT, (Object[])new Object[0]), prop.getDisplayName(), prop.getName()));
                }
            }
            if (isMultiLang) {
                property.put(INPUT_DATA_KEY, currLang);
            } else if (isLargeText) {
                property.put(INPUT_DATA_KEY, "largetext");
            } else if (isGeoPointField) {
                property.put(INPUT_DATA_KEY, "geoPointField");
            } else if (prop instanceof FlexProp) {
                property.put(INPUT_DATA_KEY, "value");
            } else if (prop instanceof IBasedataField && !(prop instanceof AttachmentProp)) {
                ArrayList<String> mulDataKey = null;
                if (prop instanceof MulBasedataProp) {
                    mulDataKey = new ArrayList<String>(props.size());
                    for (String p : props) {
                        mulDataKey.add("fbasedataid." + p);
                    }
                }
                property.put(INPUT_DATA_KEY, mulDataKey == null ? dataKeyProps : mulDataKey);
            }
            if (fieldSet.containsKey(propName)) {
                DynamicObject tprop = fieldSet.get(propName);
                property.put("MustInput", tprop.getBoolean("ismustinput"));
                property.put(ENTITY_TEMP_LATEDESCKEY, tprop.getString("entitydescription"));
                property.put(COLWIDTH_KEY, tprop.getInt("colwidth"));
            } else if (prop instanceof FieldProp) {
                property.put("MustInput", ((FieldProp)prop).isMustInput());
            } else if (prop instanceof BasedataProp) {
                property.put("MustInput", ((BasedataProp)prop).isMustInput());
            } else if (prop instanceof RefBillProp) {
                property.put("MustInput", ((RefBillProp)prop).isMustInput());
            } else if (prop instanceof AttachmentProp) {
                property.put("MustInput", ((AttachmentProp)prop).isMustInput());
            } else if (prop instanceof MulBasedataProp) {
                property.put("MustInput", ((MulBasedataProp)prop).isMustInput());
            }
            if (isBasedata || isMultiLang || isLargeText || isRefbilldate || isGeoPointField) {
                ArrayList<String> items = new ArrayList<String>();
                ArrayList<String> display = new ArrayList<String>();
                ArrayList<String> desc = new ArrayList<String>();
                if (prop instanceof FlexProp) {
                    for (int i = 0; i < flexGroups; ++i) {
                        items.add(propName);
                        display.add(prop.getDisplayName().getLocaleValue());
                        desc.add("");
                        items.add(propName + ".number");
                        display.add(this.codeToName(NUMBER));
                        desc.add(ResManager.loadKDString((String)"\u5982\u679c\u5f39\u6027\u57df\u7c7b\u578b\u4e3a\u6587\u672c\u6216\u6570\u503c\u7c7b\u578b\uff0c\u4e0d\u9700\u8981\u7ef4\u62a4\u8be5\u5217\u6570\u636e", (String)"ExportWriterBuilder_20", (String)BOS_EXPORT, (Object[])new Object[0]));
                        items.add(propName + ".name");
                        display.add(this.codeToName("name"));
                        desc.add("");
                    }
                } else if (prop instanceof BasedataProp || prop instanceof MulBasedataProp && !(prop instanceof AttachmentProp) || prop instanceof RefBillProp) {
                    boolean isMulBasedata = prop instanceof MulBasedataProp;
                    String basedataColumnKey = propName;
                    String basedataColumnName = prop.getDisplayName().getLocaleValue();
                    if (props.isEmpty()) {
                        if (prop instanceof ItemClassProp) {
                            this.setItemClassProps(propName, basedataColumnName, items, display, desc);
                        } else if (prop instanceof RefBillProp) {
                            this.setDefaultRefBilldataProps(propName, prop, items, display, desc);
                        } else {
                            this.setDefaultBasedataProps(propName, prop, items, display, desc);
                        }
                    } else {
                        for (String p : props) {
                            items.add(basedataColumnKey + "." + p);
                            if (!desc.isEmpty()) continue;
                            desc.add(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u652f\u6301\u5f55\u5165%2$s", (String)"MetadataServiceImpl_25", (String)BOS_EXPORT, (Object[])new Object[0]), isMulBasedata ? ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u9017\u53f7\u5206\u9694", (String)"ExportWriterBuilder_21", (String)BOS_EXPORT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ExportWriterBuilder_22", (String)BOS_EXPORT, (Object[])new Object[0]), "name".equals(p) ? this.kdName : this.kdCode));
                        }
                        for (int i = 0; i < propDisplayNames.size(); ++i) {
                            display.add(basedataColumnName + "." + (String)propDisplayNames.get(i));
                        }
                    }
                } else if (isMultiLang) {
                    String comment = ResManager.loadKDString((String)"\u6587\u672c", (String)"ExportWriterBuilder_12", (String)BOS_EXPORT, (Object[])new Object[0]);
                    for (EnabledLang lang : enableLangs) {
                        if (lang.number.equals(currLang)) {
                            items.add(0, propName + "." + lang.number);
                            display.add(0, this.getDisplayName(prop) + "." + lang.name);
                            desc.add(0, comment);
                            continue;
                        }
                        items.add(propName + "." + lang.number);
                        display.add(this.getDisplayName(prop) + "." + lang.name);
                        desc.add(comment);
                    }
                } else if (isLargeText) {
                    for (String p : props) {
                        items.add(p);
                    }
                    for (int i = 0; i < propDisplayNames.size(); ++i) {
                        display.add((String)propDisplayNames.get(i));
                    }
                } else if (isGeoPointField) {
                    for (String p : props) {
                        items.add(p);
                    }
                    for (int i = 0; i < propDisplayNames.size(); ++i) {
                        display.add((String)propDisplayNames.get(i));
                    }
                }
                writer.flexColumn.put(propName, items);
                writer.flexColumnDisplay.put(propName, display);
                writer.flexColumnDesc.put(propName, desc);
                col += items.size();
            } else {
                ++col;
            }
            writer.fields.add(propName);
            writer.properties.put(propName, property);
        }
        return col;
    }

    private boolean checkToExportId(Map<String, DynamicObject> fieldSet, IDataEntityProperty prop, boolean isID, boolean isPID) {
        return fieldSet.isEmpty() && prop instanceof PKFieldProp && (isID || isPID) && this.isSysParamExportId();
    }

    private void handleAcrossProperties(DataEntityPropertyCollection properties, String entityTypeNum, Map<String, Map<String, IDataEntityProperty>> acrossProps) {
        if (acrossProps == null) {
            return;
        }
        for (Map.Entry<String, Map<String, IDataEntityProperty>> entry : acrossProps.entrySet()) {
            String mainEntityNum = entry.getKey();
            Map<String, IDataEntityProperty> iDataEntityPropertyMap = entry.getValue();
            if (!StringUtils.equals((CharSequence)mainEntityNum, (CharSequence)entityTypeNum)) {
                for (IDataEntityProperty property : iDataEntityPropertyMap.values()) {
                    properties.remove((Object)property);
                }
                continue;
            }
            properties.addAll(iDataEntityPropertyMap.values());
        }
    }

    private boolean isQueryEntityAcrossField(Set<String> acrossPropNames, boolean isQueryEntity, boolean isForImport, String propName) {
        return acrossPropNames != null && isQueryEntity && isForImport && acrossPropNames.contains(propName);
    }

    private void setDefaultBasedataProps(String propName, IDataEntityProperty prop, List<String> items, List<String> display, List<String> desc) {
        boolean isMulBasedata = prop instanceof MulBasedataProp;
        String basedataColumnName = prop.getDisplayName().getLocaleValue();
        String bdNumProp = this.getBasedataNumberProp((IBasedataField)prop);
        String bdNameProp = this.getBasedataNameProp((IBasedataField)prop);
        String disPlayNumber = basedataColumnName + this.appendName((IBasedataField)prop, bdNumProp);
        String disPlayName = basedataColumnName + this.appendName((IBasedataField)prop, bdNameProp);
        items.add(propName + "." + bdNumProp);
        display.add(disPlayNumber);
        desc.add(String.format(ResManager.loadKDString((String)"%s\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801", (String)"ExportWriterBuilder_23", (String)BOS_EXPORT, (Object[])new Object[0]), isMulBasedata ? ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u9017\u53f7\u5206\u9694", (String)"ExportWriterBuilder_21", (String)BOS_EXPORT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ExportWriterBuilder_22", (String)BOS_EXPORT, (Object[])new Object[0])));
        items.add(propName + "." + bdNameProp);
        display.add(disPlayName);
        desc.add(String.format(ResManager.loadKDString((String)"%s\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0", (String)"ExportWriterBuilder_24", (String)BOS_EXPORT, (Object[])new Object[0]), isMulBasedata ? ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u9017\u53f7\u5206\u9694", (String)"ExportWriterBuilder_21", (String)BOS_EXPORT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ExportWriterBuilder_22", (String)BOS_EXPORT, (Object[])new Object[0])));
    }

    private void setDefaultRefBilldataProps(String propName, IDataEntityProperty prop, List<String> items, List<String> display, List<String> desc) {
        String RefBilldataColumnName = prop.getDisplayName().getLocaleValue();
        String rbdNumProp = this.getRefBilldataNumberProp((RefBillProp)prop);
        String disPlayNumber = RefBilldataColumnName + this.appendName((IRefBillField)prop, rbdNumProp);
        items.add(propName + "." + rbdNumProp);
        display.add(disPlayNumber);
        desc.add(String.format(ResManager.loadKDString((String)"%s\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801", (String)"ExportWriterBuilder_23", (String)BOS_EXPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5", (String)"ExportWriterBuilder_25", (String)BOS_EXPORT, (Object[])new Object[0])));
    }

    private void setItemClassProps(String propName, String basedataColumnName, List<String> items, List<String> display, List<String> desc) {
        String bdNumProp = NUMBER;
        String bdNameProp = "name";
        String disPlayNumber = String.format(ResManager.loadKDString((String)"%s.\u7f16\u7801", (String)"MetadataServiceImpl_20", (String)BOS_EXPORT, (Object[])new Object[0]), basedataColumnName);
        String disPlayName = String.format(ResManager.loadKDString((String)"%s.\u540d\u79f0", (String)"MetadataServiceImpl_19", (String)BOS_EXPORT, (Object[])new Object[0]), basedataColumnName);
        items.add(propName + "." + bdNumProp);
        display.add(disPlayNumber);
        desc.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801", (String)"ExportWriterBuilder_26", (String)BOS_EXPORT, (Object[])new Object[0]));
        items.add(propName + "." + bdNameProp);
        display.add(disPlayName);
        desc.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0", (String)"ExportWriterBuilder_27", (String)BOS_EXPORT, (Object[])new Object[0]));
    }

    private void prepareLargeTextProps(List<String> props, List<String> propDisplayNames, IDataEntityProperty prop, String propName) {
        props.add(propName);
        propDisplayNames.add(this.getDisplayName(prop));
        props.add(propName + "_tag");
        propDisplayNames.add(this.getDisplayName((IDataEntityProperty)prop.getParent().getProperties().get((Object)(propName + "_tag"))));
    }

    private void prepareGeoPointField(List<String> props, List<String> propDisplayNames, IDataEntityProperty prop, String propName) {
        props.add(propName);
        propDisplayNames.add(this.getDisplayName(prop));
        if (prop == null) {
            return;
        }
        props.add(propName + "_lo");
        propDisplayNames.add(this.getDisplayName((IDataEntityProperty)prop.getParent().getProperties().get((Object)(propName + "_lo"))));
        props.add(propName + "_la");
        propDisplayNames.add(this.getDisplayName((IDataEntityProperty)prop.getParent().getProperties().get((Object)(propName + "_la"))));
        props.add(propName + "_ad");
        propDisplayNames.add(this.getDisplayName((IDataEntityProperty)prop.getParent().getProperties().get((Object)(propName + "_ad"))));
    }

    private void prepareBasedataProps(List<String> props, List<String> dataKeyProps, List<String> propDisplayNames, DynamicObject templateRow, IDataEntityProperty prop, String currLang) {
        String imptPropName = templateRow.getString("importprop");
        String exptProp = templateRow.getString("exportprop");
        if (prop instanceof ItemClassProp) {
            this.prepareItemClassProps(props, dataKeyProps, propDisplayNames, imptPropName, exptProp, currLang);
            return;
        }
        BasedataEntityType refPropType = (BasedataEntityType)((IBasedataField)prop).getComplexType();
        switch (imptPropName) {
            case "number": {
                if (imptPropName.equals(refPropType.getNumberProperty())) break;
                imptPropName = refPropType.getNumberProperty();
                break;
            }
            case "name": {
                if (imptPropName.equals(refPropType.getNameProperty())) break;
                imptPropName = refPropType.getNameProperty();
                break;
            }
        }
        DataEntityPropertyCollection properties = refPropType.getProperties();
        IDataEntityProperty refprop = (IDataEntityProperty)properties.get((Object)imptPropName);
        if (StringUtils.isNotBlank((CharSequence)imptPropName)) {
            props.add(imptPropName);
            dataKeyProps.add(refprop instanceof MuliLangTextProp ? imptPropName + "." + currLang : imptPropName);
            propDisplayNames.add(refprop != null ? this.getDisplayName(refprop) : imptPropName);
        }
        for (String p : exptProp != null ? exptProp.split(",") : new String[]{}) {
            if (StringUtils.isBlank((CharSequence)p)) continue;
            refprop = (IDataEntityProperty)properties.get((Object)p);
            if (refprop == null) {
                if ("name".equals(p) && refPropType.getNameProperty() != null) {
                    p = refPropType.getNameProperty();
                } else if (NUMBER.equals(p) && refPropType.getNumberProperty() != null) {
                    p = refPropType.getNumberProperty();
                }
                refprop = (IDataEntityProperty)properties.get((Object)p);
            }
            if (props.contains(p)) continue;
            props.add(p);
            dataKeyProps.add(refprop instanceof MuliLangTextProp ? p + "." + currLang : p);
            propDisplayNames.add(refprop != null ? this.getDisplayName(refprop) : this.getRefDisplayName(prop, p));
        }
    }

    private void prepareDateFormat(Map<String, String> dateFieldFormatMapping, DynamicObject templateRow, boolean isForImport) {
        if (isForImport) {
            return;
        }
        String exportformatname = templateRow.getString("exportformatname");
        if (StringUtils.isNotBlank((CharSequence)exportformatname)) {
            dateFieldFormatMapping.put(templateRow.getString("entitynumber"), exportformatname);
        }
    }

    private void prepareItemClassProps(List<String> props, List<String> dataKeyProps, List<String> propDisplayNames, String imptPropName, String exptProp, String currLang) {
        if (StringUtils.isNotEmpty((CharSequence)imptPropName)) {
            props.add(imptPropName);
            dataKeyProps.add("name".equals(imptPropName) ? imptPropName + "." + currLang : imptPropName);
            propDisplayNames.add(this.defaultFieldNameMap.getOrDefault(imptPropName, imptPropName));
        }
        for (String p : exptProp != null ? exptProp.split(",") : new String[]{}) {
            if (!StringUtils.isNotBlank((CharSequence)p) || props.contains(p)) continue;
            props.add(p);
            dataKeyProps.add("name".equals(p) ? p + "." + currLang : p);
            propDisplayNames.add("name".equals(p) ? this.kdName : this.kdCode);
        }
    }

    private String getBasedataNumberProp(IBasedataField prop) {
        BasedataEntityType entityType = (BasedataEntityType)prop.getComplexType();
        return entityType.getNumberProperty();
    }

    private String getBasedataNameProp(IBasedataField prop) {
        BasedataEntityType entityType = (BasedataEntityType)prop.getComplexType();
        return entityType.getNameProperty();
    }

    private String getRefBilldataNumberProp(RefBillProp prop) {
        return prop.getNumberProp();
    }

    private boolean isFieldExportable(IDataEntityProperty prop, boolean isForImport) {
        return isForImport ? ((IFieldHandle)prop).isImportable() : ((IFieldHandle)prop).isExportable();
    }

    private boolean isControlFieldExportable(IDataEntityType entityType, String propName, boolean isForImport) {
        if (StringUtils.isNotBlank((CharSequence)propName)) {
            if (entityType == null) {
                return false;
            }
            IFieldHandle prop = (IFieldHandle)entityType.getProperties().get((Object)propName);
            if (prop == null) {
                return this.isControlFieldExportable(entityType.getParent(), propName, isForImport);
            }
            return isForImport ? prop.isImportable() : prop.isExportable();
        }
        return true;
    }

    private String appendName(IBasedataField prop, String propName) {
        BasedataEntityType entityType = (BasedataEntityType)prop.getComplexType();
        DynamicProperty bdProp = entityType.getProperty(propName);
        if (entityType.getProperty(propName) != null) {
            return "." + bdProp.getDisplayName();
        }
        return "." + propName;
    }

    private String appendName(IRefBillField prop, String propName) {
        IDataEntityType entityType = prop.getComplexType();
        entityType.getProperties().get((Object)propName);
        IDataEntityProperty bdProp = (IDataEntityProperty)entityType.getProperties().get((Object)propName);
        if (entityType.getProperties().get((Object)propName) != null) {
            return "." + bdProp.getDisplayName();
        }
        return "." + propName;
    }

    private String codeToName(String code) {
        String columnName = code;
        if (NUMBER.equals(code)) {
            columnName = this.kdCode;
        } else if ("name".equals(code)) {
            columnName = this.kdName;
        }
        return columnName;
    }

    private String getDisplayName(IDataEntityProperty prop) {
        if (prop == null) {
            return "";
        }
        if ("id".equals(prop.getName())) {
            return this.kdId;
        }
        LocaleString displayName = prop.getDisplayName();
        if (StringUtils.isBlank((Object)displayName)) {
            return prop.getName();
        }
        return displayName.toString();
    }

    private String getRefDisplayName(IDataEntityProperty parProp, String propName) {
        String[] splitName;
        IDataEntityProperty masterProp;
        boolean isMaterielRef;
        BasedataEntityType refPropType = (BasedataEntityType)((IBasedataField)parProp).getComplexType();
        boolean bl = isMaterielRef = parProp instanceof MaterielProp && 2 == refPropType.getMasteridType();
        if (isMaterielRef && propName.contains(".") && (masterProp = refPropType.findProperty((splitName = StringUtils.split((String)propName, (String)"."))[0])) instanceof MasterBasedataProp) {
            IDataEntityProperty prop = (IDataEntityProperty)((MasterBasedataProp)masterProp).getComplexType().getProperties().get((Object)splitName[1]);
            return this.getDisplayName(masterProp) + "." + this.getDisplayName(prop);
        }
        return propName;
    }

    private Map<String, String> getDefaultFieldNameMap() {
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("id", this.kdId);
        map.put("name", this.kdName);
        map.put(NUMBER, this.kdCode);
        return map;
    }
}

