/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.events.ConvertPkEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.impt.AbstractSave;
import kd.bos.form.impt.SingleBillResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.utils.ImportCreateViewUtil;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.http.client.utils.CloneUtils;

public class ImportDataSave
extends AbstractSave {
    private static final String OPTION = "option";
    private static final String BOS_IMPORT = "bos-import";
    private static final String IMPORT_TYPE = "importtype";
    private static final String IMPORT_PROP = "importprop";
    private static final String NUMBER = "number";
    private static final Log log = LogFactory.getLog(ImportDataSave.class);
    private DynamicObject blankDataEntity;
    private static final String CREATEORGKEY = "createorg";

    private List<Map<String, Object>> getSourceDatas() {
        if (this.requestData.containsKey("data")) {
            Map dataObject = (Map)this.requestData.get("data");
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            list.add(dataObject);
            return list;
        }
        if (this.requestData.containsKey("datas")) {
            return (List)this.requestData.get("datas");
        }
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public Map<String, Object> getOption() {
        HashMap option = (HashMap)this.requestData.get(OPTION);
        if (option == null) {
            option = new HashMap();
            this.requestData.put(OPTION, option);
        }
        return option;
    }

    protected FormShowParameter createShowParameter() {
        FormShowParameter showParameter = super.createShowParameter();
        showParameter.setAppId(this.getAppId());
        return showParameter;
    }

    protected Object getBlankDataEntity(IDataModel model, int indexOfData) {
        return ImportCreateViewUtil.getBlankDataEntity(model, this.blankDataEntity, false);
    }

    public ApiResult execute() {
        List<Map<String, Object>> sourceDatas = this.getSourceDatas();
        Map<String, Object> customOption = this.getOption();
        boolean isForUpdateMultiLang = Boolean.TRUE.equals(customOption.get("ForUpdateMultiLangFields"));
        if (sourceDatas.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5728\u8f93\u5165\u53c2\u6570\u5b57\u5178\u4e2d\uff0c\u6ca1\u6709\u627e\u5230\u6570\u636e\u53c2\u6570data\u6216datas\u8282\u70b9", (String)"ImportDataSave_0", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        IDataModel model = this.getView().getModel();
        model.putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)Boolean.TRUE);
        try {
            int defaultSize = sourceDatas.size();
            ArrayList<SingleBillResult> convResults = new ArrayList<SingleBillResult>(defaultSize);
            LinkedHashSet<String> pkIds = new LinkedHashSet<String>(defaultSize);
            this.fillPkIds(model, sourceDatas);
            ModelEventProxy eventProxy = (ModelEventProxy)model.getService(ModelEventProxy.class);
            this.clearInitImportDataArgs();
            if (eventProxy != null && !isForUpdateMultiLang) {
                InitImportDataEventArgs eventArgs = new InitImportDataEventArgs((Object)model, sourceDatas, customOption, this.dataConvertOrder);
                eventProxy.fireInitImportData(eventArgs);
                this.setInitImportDataEventArgs(eventArgs);
            }
            List<Map<String, Object>> cloneDatas = this.getNewDatas(model, sourceDatas);
            OperationResult saveResult = this.executeSave(model, cloneDatas, convResults, pkIds);
            return this.buildApiResult(model, convResults, pkIds, saveResult);
        }
        catch (Throwable e) {
            log.warn(e);
            return ApiResult.ex((Throwable)e, (boolean)SystemParamServiceHelper.isShowStackTrace());
        }
    }

    protected List<Map<String, Object>> getNewDatas(IDataModel model, List<Map<String, Object>> sourceDatas) throws CloneNotSupportedException {
        return (List)CloneUtils.cloneObject(sourceDatas);
    }

    private OperationResult executeSave(IDataModel model, List<Map<String, Object>> cloneDatas, List<SingleBillResult> convResults, Set<String> pkIds) {
        Map<String, Object> customOption = this.getOption();
        ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>();
        PKFieldProp pkProp = (PKFieldProp)model.getDataEntityType().getPrimaryKey();
        int len = cloneDatas.size();
        for (int i = 0; i < len; ++i) {
            SingleBillResult billResult = new SingleBillResult();
            billResult.setDIndex(i);
            convResults.add(billResult);
            OperationResult convResult = this.resovleData(model, cloneDatas, i);
            if (convResult.isSuccess()) {
                billResult.setSuccess(true);
                DynamicObject billObj = model.getDataEntity(true);
                billResult.setId(pkProp.getValueFast((Object)billObj));
                billObjs.add(model.getDataEntity(true));
                pkIds.add(billResult.getId().toString());
                continue;
            }
            billResult.setSuccess(false);
            String msg = convResult.getMessage();
            if (msg != null && msg.startsWith("{") && msg.endsWith("}")) {
                try {
                    billResult.setConvertResult(JSONObject.parseObject((String)msg, HashMap.class));
                }
                catch (Exception e) {
                    log.warn(String.format("appid:%s", this.getAppId()), (Throwable)e);
                    billResult.setMessage(msg);
                }
                continue;
            }
            billResult.setMessage(msg);
        }
        if (!billObjs.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue(IMPORT_TYPE, String.valueOf(customOption.get(IMPORT_TYPE)));
            option.setVariableValue("autogeneratebillno", String.valueOf(true));
            option.setVariableValue("currbizappid", this.getAppId());
            option.setVariableValue("ignorewarn", String.valueOf(true));
            option.setVariableValue("ignoreinteraction", String.valueOf(true));
            option.setVariableValue("importtag_of_datasource", String.valueOf(true));
            try {
                return OperationServiceHelper.executeOperate((String)this.getOperationNumber(), (String)model.getDataEntityType().getName(), (DynamicObject[])billObjs.toArray(new DynamicObject[billObjs.size()]), (OperateOption)option);
            }
            catch (Throwable e) {
                log.warn(e);
                OperationResult errResult = new OperationResult();
                errResult.setSuccess(false);
                Throwable cause = e.getCause();
                if (cause instanceof KDException && ((KDException)cause).getErrorCode() != null && "bos.sQLDuplicateKey".equals(((KDException)cause).getErrorCode().getCode())) {
                    log.debug(e.getMessage());
                    String errMsg = ResManager.loadKDString((String)"\u5206\u5f55\u5185\u7801\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u6570\u636e\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ImportDataSave_15", (String)BOS_IMPORT, (Object[])new Object[0]);
                    errResult.setMessage(errMsg);
                    return errResult;
                }
                if (cause instanceof RuntimeException && (cause = cause.getCause()) instanceof SQLException) {
                    e = cause;
                }
                if (e instanceof KDBizException || e instanceof SQLException || !SystemParamServiceHelper.isShowStackTrace()) {
                    errResult.setMessage(e.getMessage());
                } else if (SystemParamServiceHelper.isShowStackTrace()) {
                    errResult.setMessage(ImportLogger.formatException((Throwable)e));
                }
                return errResult;
            }
        }
        return null;
    }

    protected OperationResult resovleData(IDataModel model, List<Map<String, Object>> cloneDatas, int indexOfData) {
        return this.resolve(model, cloneDatas.get(indexOfData), indexOfData);
    }

    private String getAppId() {
        return (String)this.requestData.get("formShowParameterAppId");
    }

    private void fillPkIds(IDataModel model, List<Map<String, Object>> sourceDatas) throws ParseException, CloneNotSupportedException {
        HashMap<Integer, Map<String, Object>> rowMappings;
        String entityName = model.getDataEntityType().getName();
        Map option = (Map)this.requestData.get(OPTION);
        if (option == null) {
            String errMsg = ResManager.loadKDString((String)"BatchImportPlugin \u672a\u4f20\u9012 option \u64cd\u4f5c\u53c2\u6570, \u8bf7\u68c0\u67e5\uff01", (String)"ImportDataSave_16", (String)BOS_IMPORT, (Object[])new Object[0]);
            throw new RuntimeException(errMsg);
        }
        String importType = (String)option.get(IMPORT_TYPE);
        if ("new".equals(importType) || importType == null && option.get("KeyFields") == null) {
            return;
        }
        BillEntityType dt = (BillEntityType)model.getDataEntityType();
        Map<String, Set<Object>> params = this.prepareKeyFields(dt, option, sourceDatas, rowMappings = new HashMap<Integer, Map<String, Object>>());
        if (!params.isEmpty()) {
            Set colIds = (Set)this.requestData.get("colIds");
            if (!this.validateKeyFieldsInExcel(colIds, params.keySet()) && !this.validateKeyFieldsInExcel(sourceDatas.get(0).keySet(), params.keySet())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\uff0c\u5339\u914d\u4e0d\u5230\u6570\u636e\uff0c\u53ef\u80fd\u662f\u6a21\u677f\u4e2d\u6ca1\u6709\u8be5\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6\u6216\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c", (String)"ImportDataSave_14", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
            QFilter filters = this.buildKeyFilters(params);
            HashSet<String> selectFields = new HashSet<String>(params.keySet());
            String masterIdKey = null;
            OrgProp createOrgProp = null;
            boolean isBasedata = dt instanceof BasedataEntityType;
            if (isBasedata) {
                BasedataEntityType bdt = (BasedataEntityType)dt;
                DynamicProperty orgProp = bdt.getProperty(CREATEORGKEY);
                if (orgProp instanceof OrgProp && StringUtils.isNotBlank((CharSequence)orgProp.getAlias())) {
                    selectFields.add(CREATEORGKEY);
                    createOrgProp = (OrgProp)orgProp;
                }
                if (StringUtils.isNotBlank((CharSequence)bdt.getMasteridPropName())) {
                    masterIdKey = bdt.getMasteridPropName();
                    selectFields.add(masterIdKey);
                }
            }
            String selectkey = selectFields.contains("id") ? String.join((CharSequence)",", selectFields) : "id," + String.join((CharSequence)",", selectFields);
            try (DataSet dataset = QueryServiceHelper.queryDataSet((String)("importdata." + entityName), (String)entityName, (String)selectkey, (QFilter[])new QFilter[]{filters}, (String)"");){
                this.fillPkIdsByDataSet(dataset, params, rowMappings, createOrgProp, masterIdKey, sourceDatas, isBasedata);
            }
        }
    }

    private boolean validateKeyFieldsInExcel(Set<String> excelColumnFields, Set<String> updateKeyFields) {
        for (String updateKeyField : updateKeyFields) {
            String[] updateKeySplit = updateKeyField.split("\\.");
            String master = updateKeySplit[0];
            if (excelColumnFields.contains(master)) continue;
            return false;
        }
        return true;
    }

    private Map<String, String> getSelectField(BillEntityType dt, Map<String, Object> option) {
        HashMap<String, String> fields = new HashMap<String, String>();
        List<Object> fieldkeys = new ArrayList<String>();
        String keyfields = (String)option.get("KeyFields");
        if (StringUtils.isBlank((CharSequence)keyfields)) {
            if (StringUtils.isNotBlank((CharSequence)dt.getMainOrg())) {
                fieldkeys.add(dt.getMainOrg());
            }
            if (StringUtils.isNotBlank((CharSequence)dt.getBillNo())) {
                fieldkeys.add(dt.getBillNo());
            }
            if (StringUtils.isNotBlank((CharSequence)dt.getBillStatus())) {
                fieldkeys.add(dt.getBillStatus());
            }
        } else {
            fieldkeys = Arrays.asList(keyfields.split(","));
        }
        if (fieldkeys == null || fieldkeys.isEmpty()) {
            return fields;
        }
        for (int i = 0; i < fieldkeys.size(); ++i) {
            LocaleString displayName;
            DynamicProperty prop;
            String field = (String)fieldkeys.get(i);
            if (!StringUtils.isNotBlank((CharSequence)field) || (prop = dt.getProperty(field)) == null) continue;
            String fieldName = null;
            fieldName = "id".equals(field) ? ResManager.loadKDString((String)"\u5185\u7801", (String)"ImportDataSave_1", (String)BOS_IMPORT, (Object[])new Object[0]) : ("pid".equals(field) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ImportDataSave_2", (String)BOS_IMPORT, (Object[])new Object[0]) : ((displayName = prop.getDisplayName()) != null && StringUtils.isNotBlank((CharSequence)displayName.toString()) ? displayName.toString() : field));
            fields.put(field, fieldName);
        }
        return fields;
    }

    private void fillPkIdsByDataSet(DataSet dataset, Map<String, Set<Object>> params, Map<Integer, Map<String, Object>> rowMappings, OrgProp createOrgProp, String masterIdKey, List<Map<String, Object>> sourceDatas, boolean isBasedata) throws CloneNotSupportedException {
        ArrayList<Object[]> rows;
        HashMap<String, ArrayList<Object[]>> pkIdMapping = new HashMap<String, ArrayList<Object[]>>();
        for (Row data : dataset) {
            KeyParams kp = this.buildQueryKey(params.keySet(), createOrgProp, masterIdKey, data);
            rows = (ArrayList<Object[]>)pkIdMapping.get(kp.key);
            if (rows == null) {
                rows = new ArrayList<Object[]>();
                pkIdMapping.put(kp.key, rows);
            }
            rows.add(new Object[]{kp.id, kp.masterId, kp.createOrgNumber, kp.createOrgName});
        }
        for (Map.Entry<Integer, Map<String, Object>> entry : rowMappings.entrySet()) {
            String queryKey = JSON.toJSONString(entry.getValue());
            if (!pkIdMapping.containsKey(queryKey)) continue;
            rows = (List)pkIdMapping.get(queryKey);
            Map<String, Object> dataObject = sourceDatas.get(entry.getKey());
            if (isBasedata) {
                if (this.basedataFillPkIdsByDataSet(rows, createOrgProp, masterIdKey, dataObject)) continue;
                continue;
            }
            if (rows.size() == 1) {
                dataObject.put("id", ((Object[])rows.get(0))[0]);
                continue;
            }
            if (rows.size() <= 1) continue;
            StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u6839\u636e\u5339\u914d\u5b57\u6bb5\u5339\u914d\u5230\u4e86\u591a\u6761\u6570\u636e\uff0c\u5185\u7801\u5206\u522b\u4e3a\uff1a", (String)"ImportDataSave_3", (String)BOS_IMPORT, (Object[])new Object[0]));
            int idTipCount = 0;
            int idTipCountMax = 3;
            for (Object[] obj : rows) {
                if (idTipCount >= idTipCountMax) break;
                if (obj.length > 0) {
                    sb.append(obj[0]);
                }
                if (sb.length() != 0) {
                    sb.append('\uff0c');
                }
                ++idTipCount;
            }
            if (sb.length() != 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (rows.size() > idTipCount) {
                sb.append('\u2026');
            }
            dataObject.put("id", null);
            dataObject.put("_errMsg_", sb.toString());
        }
    }

    private boolean basedataFillPkIdsByDataSet(List<Object[]> rows, OrgProp createOrgProp, String masterIdKey, Map<String, Object> dataObject) {
        StringBuilder sb;
        String dataType;
        Object val;
        Map createOrgMap;
        boolean idFound = true;
        HashSet<Object> tempPks = new HashSet<Object>();
        if (createOrgProp != null && (createOrgMap = (Map)dataObject.get(createOrgProp.getName())) != null && StringUtils.isNotBlank(val = createOrgMap.get(dataType = createOrgMap.containsKey(IMPORT_PROP) ? (String)createOrgMap.get(IMPORT_PROP) : (createOrgMap.containsKey(NUMBER) ? NUMBER : "name")))) {
            tempPks.clear();
            if (!CollectionUtils.isEmpty(rows)) {
                for (Object[] row : rows) {
                    if (!val.equals(row[NUMBER.equals(dataType) ? 2 : 3])) continue;
                    tempPks.add(row[0]);
                }
            }
        }
        int idTipCount = 0;
        int idTipCountMax = 3;
        if (tempPks.isEmpty()) {
            sb = new StringBuilder();
            if (!CollectionUtils.isEmpty(rows)) {
                for (Object[] row : rows) {
                    boolean add = false;
                    if (StringUtils.isNotBlank((CharSequence)masterIdKey)) {
                        if (row[0].equals(row[1]) || StringUtils.isBlank((Object)row[1])) {
                            add = tempPks.add(row[0]);
                        }
                    } else {
                        add = tempPks.add(row[0]);
                    }
                    if (!add || idTipCount >= idTipCountMax) continue;
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(row[0]);
                    ++idTipCount;
                }
            }
            if (tempPks.size() == 1) {
                dataObject.put("id", tempPks.iterator().next());
            } else if (tempPks.size() > 1) {
                if (tempPks.size() > idTipCount) {
                    sb.append('\u2026');
                }
                sb.insert(0, ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\uff1a", (String)"ImportDataSave_4", (String)BOS_IMPORT, (Object[])new Object[0]));
                dataObject.put("id", null);
                dataObject.put("_errMsg_", sb.toString());
            } else if (rows != null && !rows.isEmpty()) {
                sb.insert(0, ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e0d\u5408\u6cd5\uff1a", (String)"ImportDataSave_5", (String)BOS_IMPORT, (Object[])new Object[0]));
                dataObject.put("id", null);
                dataObject.put("_errMsg_", sb.toString());
            } else {
                idFound = false;
            }
        } else if (tempPks.size() == 1) {
            dataObject.put("id", tempPks.iterator().next());
        } else {
            sb = new StringBuilder(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\uff1a", (String)"ImportDataSave_4", (String)BOS_IMPORT, (Object[])new Object[0]));
            for (Object obj : tempPks) {
                if (idTipCount >= idTipCountMax) break;
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(obj);
                ++idTipCount;
            }
            if (tempPks.size() > idTipCount) {
                sb.append('\u2026');
            }
            dataObject.put("id", null);
            dataObject.put("_errMsg_", sb.toString());
        }
        return idFound;
    }

    private QFilter buildKeyFilters(Map<String, Set<Object>> params) {
        QFilter filter = null;
        for (Map.Entry<String, Set<Object>> entry : params.entrySet()) {
            String fieldKey = entry.getKey();
            Set<Object> value = entry.getValue();
            if (filter == null) {
                filter = new QFilter(fieldKey, "in", value);
                continue;
            }
            filter.and(fieldKey, "in", value);
        }
        return filter;
    }

    private Map<String, Set<Object>> prepareKeyFields(BillEntityType dt, Map<String, Object> option, List<Map<String, Object>> sourceDatas, Map<Integer, Map<String, Object>> rowMappings) throws ParseException {
        Map<String, String> fields = this.getSelectField(dt, option);
        HashMap<String, Set<Object>> params = new HashMap<String, Set<Object>>();
        for (int i = 0; i < sourceDatas.size(); ++i) {
            Map<String, Object> dataObject = sourceDatas.get(i);
            dataObject.put("_dindex_", i);
            ConvertPkEvent e = new ConvertPkEvent((Object)this.getView(), this.getOperationNumber(), dataObject);
            this.fireConvertPkEvent(e);
            if (e.getPK() == null) {
                Object pkId = dataObject.get("id");
                if (StringUtils.isNotBlank((Object)pkId) && pkId.getClass() != dt.getPrimaryKey().getPropertyType()) {
                    dataObject.put("_source_id_", pkId);
                    pkId = ConvertUtils.convert((Object)pkId, (Class)dt.getPrimaryKey().getPropertyType());
                    dataObject.put("id", pkId);
                }
                HashMap<String, Object> rowMapping = new HashMap<String, Object>();
                for (String field : fields.keySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)field)) continue;
                    DynamicProperty fieldProperty = dt.getProperty(field);
                    boolean isBaseData = fieldProperty instanceof BasedataProp;
                    Object tempVal = dataObject.get(field);
                    if (isBaseData) {
                        if (tempVal != null) {
                            Map tempMap = (Map)tempVal;
                            String dataType = tempMap.containsKey("id") ? "id" : (tempMap.containsKey(IMPORT_PROP) ? (String)tempMap.get(IMPORT_PROP) : (tempMap.containsKey(NUMBER) ? NUMBER : "name"));
                            tempVal = tempMap.get(dataType);
                            field = field + "." + dataType;
                        } else {
                            BasedataProp basedataProp = (BasedataProp)fieldProperty;
                            PKFieldProp baseatePK = (PKFieldProp)basedataProp.getDynamicComplexPropertyType().getPrimaryKey();
                            tempVal = baseatePK.getDefValue();
                        }
                    } else if (tempVal == null) {
                        tempVal = fieldProperty.getDefaultValue();
                    } else if (fieldProperty instanceof MuliLangTextProp) {
                        tempVal = LocaleString.fromMap((Map)((Map)tempVal)).toString();
                    } else if (fieldProperty instanceof DateTimeProp) {
                        if (!(tempVal instanceof Date)) {
                            tempVal = ((DateTimeProp)fieldProperty).getDateFormat().parse(tempVal.toString());
                        }
                    } else if (fieldProperty instanceof TimeProp) {
                        tempVal = TimeProp.timeToSecond((Object)tempVal.toString(), (String)field);
                    } else if (fieldProperty instanceof DecimalProp && tempVal instanceof String) {
                        tempVal = new BigDecimal(new BigDecimal((String)tempVal).stripTrailingZeros().toPlainString());
                    }
                    HashSet<Object> values = (HashSet<Object>)params.get(field);
                    if (values == null) {
                        values = new HashSet<Object>();
                        params.put(field, values);
                    }
                    values.add(tempVal);
                    rowMapping.put(field, tempVal);
                }
                rowMappings.put(i, rowMapping);
                continue;
            }
            dataObject.put("id", e.getPK());
        }
        return params;
    }

    private KeyParams buildQueryKey(Set<String> keys, OrgProp createOrgProp, String masterIdKey, Row row) {
        Object pk;
        DynamicObject createOrg;
        KeyParams qk = new KeyParams();
        HashMap<String, Object> keysObj = new HashMap<String, Object>(16);
        Object v = null;
        for (String key : keys) {
            v = row.get(key);
            if (v instanceof BigDecimal) {
                v = new BigDecimal(((BigDecimal)v).stripTrailingZeros().toPlainString());
            }
            keysObj.put(key, v);
        }
        if (createOrgProp != null && (createOrg = BusinessDataServiceHelper.loadSingleFromCache(pk = keys.contains(createOrgProp.getName()) ? keysObj.get(createOrgProp.getName()) : row.get(createOrgProp.getName()), (DynamicObjectType)createOrgProp.getDynamicComplexPropertyType())) != null) {
            qk.createOrgNumber = createOrg.getString(createOrgProp.getNumberProp());
            qk.createOrgName = createOrg.getString(createOrgProp.getDisplayProp());
        }
        if (StringUtils.isNotBlank((CharSequence)masterIdKey)) {
            qk.masterId = keys.contains(masterIdKey) ? keysObj.get(masterIdKey) : row.get(masterIdKey);
        }
        qk.id = row.get("id");
        qk.key = JSON.toJSONString(keysObj);
        return qk;
    }

    public String getOperationNumber() {
        String submit = (String)this.requestData.get("forcedsubmit");
        if (StringUtils.isEmpty((CharSequence)submit)) {
            return super.getOperationNumber();
        }
        return submit;
    }

    @Override
    protected OperationResult prepareDataEntity(IDataModel model, Map<String, Object> dataObject, int indexOfData, Supplier<OperationResult> initializer) {
        OperationResult result = new OperationResult();
        if (dataObject == null) {
            return null;
        }
        Map option = (Map)this.requestData.get(OPTION);
        String importType = option != null ? (String)option.get(IMPORT_TYPE) : null;
        boolean existData = dataObject.containsKey("id");
        if ("new".equals(importType)) {
            if (existData && StringUtils.isNotBlank((Object)dataObject.get("id"))) {
                Object pkId = dataObject.get("id");
                BillEntityType dt = (BillEntityType)model.getDataEntityType();
                if (StringUtils.isNotBlank((Object)pkId) && pkId.getClass() != dt.getPrimaryKey().getPropertyType() && "0".equals((pkId = ConvertUtils.convert((Object)pkId, (Class)dt.getPrimaryKey().getPropertyType())).toString())) {
                    result.setSuccess(false);
                    result.setMessage(ResManager.loadKDString((String)"\u5185\u7801\u8d85\u8fc719\u4f4d\u957f\u5ea6\u9650\u5236\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ImportDataSave_13", (String)BOS_IMPORT, (Object[])new Object[0]));
                    return result;
                }
                if (QueryServiceHelper.exists((String)model.getDataEntityType().getName(), (Object)dataObject.get("id"))) {
                    result.setSuccess(false);
                    result.setMessage(String.format(ResManager.loadKDString((String)"\u5185\u7801\u5df2\u5b58\u5728\u65e0\u6cd5\u65b0\u589e\uff1a%s", (String)"ImportDataSave_6", (String)BOS_IMPORT, (Object[])new Object[0]), dataObject.get("id")));
                    return result;
                }
            }
            model.beginInit();
            model.createNewData(this.getBlankDataEntity(model, indexOfData), initializer);
            model.endInit();
        } else {
            Object pkId = dataObject.get("id");
            if (existData && pkId != null) {
                if (QueryServiceHelper.exists((String)model.getDataEntityType().getName(), (Object)dataObject.get("id"))) {
                    if (!this.isFirePropChanged()) {
                        model.beginInit();
                    }
                    this.loadData(model, pkId, initializer, result, option != null && Boolean.TRUE.equals(option.get("ForUpdateMultiLangFields")));
                    if (!this.isFirePropChanged()) {
                        model.endInit();
                    }
                } else if ("overridenew".equals(importType)) {
                    model.beginInit();
                    model.createNewData(this.getBlankDataEntity(model, indexOfData), initializer);
                    model.endInit();
                } else {
                    result.setSuccess(false);
                    result.setMessage(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\u5185\u7801ID\uff1a%s", (String)"ImportDataSave_8", (String)BOS_IMPORT, (Object[])new Object[0]), dataObject.get("_source_id_")));
                }
            } else if (existData) {
                result.setSuccess(false);
                result.setMessage((String)dataObject.remove("_errMsg_"));
            } else if ("override".equals(importType)) {
                result.setSuccess(false);
                result.setMessage(String.format(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u7cfb\u7edf\u627e\u4e0d\u5230\u201c%s\u201d\u7684\u6570\u636e\u884c\u3002", (String)"ImportDataSave_7", (String)BOS_IMPORT, (Object[])new Object[0]), this.getFilterDesc(model, option, dataObject)));
            } else {
                model.beginInit();
                model.createNewData(this.getBlankDataEntity(model, indexOfData), initializer);
                model.endInit();
            }
        }
        return result;
    }

    private String getFilterDesc(IDataModel model, Map<String, Object> option, Map<String, Object> dataObject) {
        Map<String, String> keyFields = this.getSelectField((BillEntityType)model.getDataEntityType(), option);
        StringBuilder sb = new StringBuilder();
        Map<String, Object> sourceData = this.getSourceDatas().get((Integer)dataObject.get("_dindex_"));
        for (Map.Entry<String, String> entry : keyFields.entrySet()) {
            if (sb.length() != 0) {
                sb.append(ResManager.loadKDString((String)"\u4e14", (String)"ImportDataSave_9", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
            sb.append(entry.getValue());
            Object sourceValue = sourceData.get(entry.getKey());
            if ("id".equals(entry.getKey()) && StringUtils.isNotBlank((Object)sourceData.get("_source_id_"))) {
                sb.append('=').append(sourceData.get("_source_id_"));
                continue;
            }
            if (StringUtils.isNotBlank((Object)sourceValue)) {
                if (sourceValue instanceof Map) {
                    Map sourceValueMap = (Map)sourceValue;
                    if (CollectionUtils.isEmpty((Map)sourceValueMap)) continue;
                    sb.append('=').append('{');
                    for (Map.Entry entryTmp : sourceValueMap.entrySet()) {
                        sb.append(entry.getKey()).append('.').append(entryTmp.getKey()).append('=').append(entryTmp.getValue()).append(',');
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append('}');
                    continue;
                }
                sb.append('=').append(sourceValue);
                continue;
            }
            sb.append(ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"ImportDataSave_10", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        return sb.toString();
    }

    private void loadData(IDataModel model, Object pkId, Supplier<OperationResult> initializer, OperationResult result, boolean forUpdateMultiLangFields) {
        ((IBillModel)model).load(pkId, () -> {
            BillEntityType dt = (BillEntityType)model.getDataEntityType();
            String billStatusKey = dt.getBillStatus();
            if (!forUpdateMultiLangFields && StringUtils.isNotBlank((CharSequence)billStatusKey) && !dt.getProperty(billStatusKey).isDbIgnore()) {
                Object status = model.getValue(billStatusKey);
                if (BillStatus.B.name().equals(status)) {
                    result.setSuccess(false);
                    result.setMessage(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"ImportDataSave_11", (String)BOS_IMPORT, (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.B)));
                    return result;
                }
                if (BillStatus.C.name().equals(status)) {
                    String masterIdProp;
                    boolean isDefaultAudit;
                    boolean allowOverrideAudit = isDefaultAudit = BillStatus.C.name().equals(((FieldProp)dt.getProperty(billStatusKey)).getDefValue());
                    if (!isDefaultAudit && dt instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(masterIdProp = ((BasedataEntityType)dt).getMasteridPropName()))) {
                        Object masterId = model.getValue(masterIdProp);
                        if (this.isHashCtrlStrategy(dt) && pkId.equals(masterId)) {
                            allowOverrideAudit = true;
                        }
                    }
                    if (!allowOverrideAudit) {
                        result.setSuccess(false);
                        result.setMessage(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"ImportDataSave_11", (String)BOS_IMPORT, (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.C)));
                        return result;
                    }
                }
            }
            return (OperationResult)initializer.get();
        });
    }

    private Object getStatusCaption(BillEntityType dt, String billStatusKey, BillStatus status) {
        BillStatusProp statusProp = (BillStatusProp)dt.getProperty(billStatusKey);
        for (ValueMapItem item : statusProp.getComboItems()) {
            if (!status.name().equals(item.getValue())) continue;
            return item.getName();
        }
        return status.getValue();
    }

    private boolean isHashCtrlStrategy(BillEntityType dt) {
        return dt.getProperty(CREATEORGKEY) != null && dt.getProperty("ctrlstrategy") != null;
    }

    protected ApiResult buildApiResult(IDataModel model, List<SingleBillResult> convResults, Set<String> pkIds, OperationResult saveResult) {
        if (this.requestData.containsKey("data")) {
            if (saveResult != null && saveResult.isSuccess()) {
                return ApiResult.success((Object)saveResult);
            }
            ApiResult apiResult = new ApiResult();
            apiResult.setSuccess(false);
            if (saveResult != null) {
                apiResult.setData((Object)saveResult);
            } else if (convResults.size() > 0) {
                apiResult.setMessage(convResults.get(0).getMessage());
                apiResult.setData(SingleBillResult.toMap(convResults.get(0)));
            }
            return apiResult;
        }
        ApiResult apiResult = new ApiResult();
        ArrayList<Map<String, Object>> billResults = new ArrayList<Map<String, Object>>();
        if (saveResult == null) {
            for (SingleBillResult item : convResults) {
                billResults.add(SingleBillResult.toMap(item));
            }
            apiResult.setSuccess(false);
            apiResult.setData(billResults);
        } else {
            HashSet<String> successIds = new HashSet<String>();
            Map<Object, Object> fromDB = new HashMap();
            BillEntityType mainType = (BillEntityType)model.getDataEntityType();
            IDataEntityProperty numberProp = StringUtils.isBlank((CharSequence)mainType.getBillNo()) ? null : mainType.findProperty(mainType.getBillNo());
            MainOrgProp orgProp = mainType.getMainOrgProperty();
            if (saveResult.getSuccessPkIds() != null) {
                for (Object pk : saveResult.getSuccessPkIds()) {
                    if (pk == null) continue;
                    successIds.add(pk.toString());
                }
                fromDB = this.loadSuccessObjs(saveResult.getSuccessPkIds(), mainType, numberProp, (IDataEntityProperty)orgProp);
            }
            ArrayList<IOperateInfo> opFailInfos = new ArrayList<IOperateInfo>();
            HashMap<String, List<IOperateInfo>> billErrors = new HashMap<String, List<IOperateInfo>>();
            this.splitErrorInfoByBill(pkIds, saveResult, opFailInfos, billErrors);
            int successCount = successIds.size();
            for (SingleBillResult item : convResults) {
                DynamicObject obj = null;
                if (this.isIdExist(item.getId(), successIds) || item.isSuccess() && !this.isIdExist(item.getId(), billErrors.keySet())) {
                    successIds.remove(item.getId().toString());
                    item.setSuccess(true);
                    obj = (DynamicObject)fromDB.get(item.getId().toString());
                }
                if (obj != null) {
                    DynamicObject org;
                    if (numberProp != null) {
                        item.setNumber((String)numberProp.getValue(obj));
                    }
                    if (orgProp != null && (org = (DynamicObject)orgProp.getValue(obj)) != null) {
                        item.setOrgNumber(org.getString(NUMBER));
                    }
                } else {
                    item.setSuccess(false);
                    if (this.isIdExist(item.getId(), billErrors.keySet())) {
                        item.setData(billErrors.get(item.getId().toString()));
                    } else {
                        item.setData(opFailInfos);
                    }
                }
                billResults.add(SingleBillResult.toMap(item));
            }
            apiResult.setSuccess(successCount == billResults.size());
            apiResult.setData(billResults);
        }
        return apiResult;
    }

    protected boolean isIdExist(Object id, Set<String> successIds) {
        if (StringUtils.isBlank((Object)id)) {
            return false;
        }
        return successIds.contains(id.toString());
    }

    protected void splitErrorInfoByBill(Set<String> pkIds, OperationResult saveResult, List<IOperateInfo> opFailInfos, Map<String, List<IOperateInfo>> billErrors) {
        OperateErrorInfo errInfo;
        if (saveResult.getSuccessPkIds() != null && saveResult.getSuccessPkIds().isEmpty() && StringUtils.isNotBlank((CharSequence)saveResult.getMessage())) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(saveResult.getMessage());
            opFailInfos.add((IOperateInfo)errInfo);
        }
        for (IOperateInfo info : saveResult.getAllErrorOrValidateInfo()) {
            Object pkValue = info.getPkValue();
            if (!this.isIdExist(pkValue, pkIds)) {
                opFailInfos.add(info);
                continue;
            }
            if (!this.isIdExist(pkValue, billErrors.keySet())) {
                billErrors.put(pkValue.toString(), new ArrayList());
            }
            billErrors.get(pkValue.toString()).add(info);
        }
        if (!saveResult.isSuccess() && opFailInfos.isEmpty()) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u7684\u4fdd\u5b58\u5931\u8d25\u3002", (String)"ImportDataSave_12", (String)BOS_IMPORT, (Object[])new Object[0]));
            opFailInfos.add((IOperateInfo)errInfo);
        }
    }

    protected Map<String, DynamicObject> loadSuccessObjs(List<Object> successIds, BillEntityType mainType, IDataEntityProperty numberProp, IDataEntityProperty orgProp) {
        ArrayList<String> selectedFields = new ArrayList<String>();
        selectedFields.add(mainType.getPrimaryKey().getName());
        if (numberProp != null) {
            selectedFields.add(numberProp.getName());
        }
        if (orgProp != null) {
            selectedFields.add(orgProp.getName());
        }
        MainEntityType subType = (MainEntityType)mainType.getSubEntityType(selectedFields);
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])successIds.toArray(), (DynamicObjectType)subType);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        if (objs != null) {
            for (DynamicObject obj : objs) {
                Object pkValue = subType.getPrimaryKey().getValueFast((Object)obj);
                map.put(pkValue.toString(), obj);
            }
        }
        return map;
    }

    public void clear() {
        this.updateLocaleCache(null);
    }

    private static class KeyParams {
        private String key;
        private Object id;
        private Object masterId;
        private String createOrgNumber;
        private String createOrgName;

        private KeyParams() {
        }
    }
}

