/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.basecache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.form.impt.ImportBillData;
import kd.bos.form.operate.imptapi.ApiPropConvertContext;
import kd.bos.form.operate.webapi.BizBasedataPk;

public class ApiPropConverterContextPlus
extends ApiPropConvertContext {
    private List<ImportBillData> importBillDatas;
    private ImportBillData currentImportBillData;
    private final Map<ImportBillData, Long> mainOrgIdAtImportBill = new HashMap<ImportBillData, Long>();
    private final Map<ImportBillData, Map<BasedataItem, Set<String>>> searchItemsAtImportBill = new HashMap<ImportBillData, Map<BasedataItem, Set<String>>>();
    private final Map<ImportBillData, Map<BasedataEntityType, Set<Object>>> searchPKsAtImportBill = new HashMap<ImportBillData, Map<BasedataEntityType, Set<Object>>>();
    private final Map<ImportBillData, Map<BasedataItem, Object>> basePKsAtImportBill = new HashMap<ImportBillData, Map<BasedataItem, Object>>();
    private final Map<ImportBillData, Map<BasedataItem, BizBasedataPk>> bizBasePKsAtImportBill = new HashMap<ImportBillData, Map<BasedataItem, BizBasedataPk>>();
    private final Map<Long, Map<String, String>> orgInfoMap = new HashMap<Long, Map<String, String>>();

    public ApiPropConverterContextPlus(IDataModel model, ModelEventProxy modelEventProxy, Map<BasedataItem, Object> basePKs, Map<String, Map<Object, DynamicObject>> baseObjs) {
        super(model, modelEventProxy, basePKs, baseObjs);
    }

    @Override
    public void setMainOrgId(Long mainOrgId) {
        super.setMainOrgId(mainOrgId);
        this.mainOrgIdAtImportBill.putIfAbsent(this.currentImportBillData, mainOrgId);
    }

    @Override
    public Long getMainOrgId() {
        Long orgId;
        if (this.currentImportBillData != null && (orgId = this.mainOrgIdAtImportBill.get(this.currentImportBillData)) != null) {
            return orgId;
        }
        return super.getMainOrgId();
    }

    public Map<BasedataItem, Object> getBasePksByImportBill(ImportBillData importBillData) {
        return this.getBasePKsAtImportBill().computeIfAbsent(importBillData, s -> new HashMap());
    }

    public Map<BasedataItem, BizBasedataPk> getBizBasePksByImportBill(ImportBillData importBillData) {
        return this.getBizBasePKsAtImportBill().computeIfAbsent(importBillData, s -> new HashMap());
    }

    public Map<BasedataItem, Set<String>> getSearchItemByImportBill(ImportBillData importBillData) {
        return this.getSearchItemsAtImportBill().computeIfAbsent(importBillData, s -> new HashMap());
    }

    public Map<BasedataEntityType, Set<Object>> getSearchPksByImportBill(ImportBillData importBillData) {
        return this.getSearchPKsAtImportBill().computeIfAbsent(importBillData, s -> new HashMap());
    }

    public Map<ImportBillData, Map<BasedataItem, Object>> getBasePKsAtImportBill() {
        return this.basePKsAtImportBill;
    }

    public Map<ImportBillData, Map<BasedataItem, BizBasedataPk>> getBizBasePKsAtImportBill() {
        return this.bizBasePKsAtImportBill;
    }

    public Map<ImportBillData, Map<BasedataItem, Set<String>>> getSearchItemsAtImportBill() {
        return this.searchItemsAtImportBill;
    }

    public Map<ImportBillData, Map<BasedataEntityType, Set<Object>>> getSearchPKsAtImportBill() {
        return this.searchPKsAtImportBill;
    }

    public void setCurrentImportBillData(ImportBillData currentImportBillData) {
        this.currentImportBillData = currentImportBillData;
    }

    public void setImportBillDatas(List<ImportBillData> importBillDatas) {
        this.importBillDatas = importBillDatas;
    }

    public Map<Long, Map<String, String>> getOrgInfoMap() {
        return this.orgInfoMap;
    }

    public void clear() {
        this.mainOrgIdAtImportBill.clear();
        this.searchItemsAtImportBill.clear();
        this.searchPKsAtImportBill.clear();
        this.basePKsAtImportBill.clear();
        this.bizBasePKsAtImportBill.clear();
    }
}

