/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.basecache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.impt.ImportBillData;
import kd.bos.form.impt.basecache.ApiPropConverterContextPlus;
import kd.bos.form.impt.basecache.BasedataItemUtil;
import kd.bos.form.impt.basecache.ImportCacheBasedata;
import kd.bos.form.impt.context.MetadataContext;
import kd.bos.form.operate.imptapi.ApiFilter;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.form.operate.webapi.BizBasedataPk;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.utils.ConvertResult;
import kd.bos.utils.ImportConvertUtils;
import kd.bos.utils.ImportFilterUtil;
import kd.bos.utils.ImportNameVersionHandler;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class BasedataPropCache {
    private static final Log log = LogFactory.getLog(BasedataPropCache.class);
    private final MetadataContext metadataContext;
    private final ApiPropConverterContextPlus context;
    private final PKFieldProp pkFieldProp;
    private static final String BOS_IMPORT = "bos-import";

    public BasedataPropCache(MetadataContext metadataContext, ApiPropConverterContextPlus context, PKFieldProp pkFieldProp) {
        this.context = context;
        this.pkFieldProp = pkFieldProp;
        this.metadataContext = metadataContext;
    }

    public void buildRowMapperCache(List<ImportCacheBasedata> importBasedatas) {
        try {
            List importCacheBasedatasFromMainOrg = importBasedatas.stream().filter(x -> MainOrgProp.class == x.getProp().getClass()).collect(Collectors.toList());
            List importCacheBasedatasFromOrg = importBasedatas.stream().filter(x -> OrgProp.class == x.getProp().getClass()).collect(Collectors.toList());
            ArrayList<ImportCacheBasedata> collect = new ArrayList<ImportCacheBasedata>(importCacheBasedatasFromMainOrg);
            collect.addAll(importCacheBasedatasFromOrg);
            this.parseAndCacheOrgId(collect);
            for (ImportCacheBasedata importBasedata : importBasedatas) {
                this.context.setCurrentImportBillData(importBasedata.getImportBillData());
                if (this.checkMasterIdFromBasedataObj(importBasedata)) {
                    this.cacheBasedataId(importBasedata);
                    continue;
                }
                this.cacheBasedataItem(importBasedata);
            }
            for (ImportCacheBasedata importBasedata : importBasedatas) {
                this.cacheCurId(importBasedata);
            }
            this.batchLoadBasePKsFromDB();
            this.batchLoadBaseObjsFromDB();
            this.collectionBasePk();
        }
        catch (KDBizException bizException) {
            this.getContext().addErrorInfo(bizException.getMessage());
        }
    }

    private void parseAndCacheOrgId(List<ImportCacheBasedata> importCacheBasedatas) {
        for (ImportCacheBasedata importCacheBasedata : importCacheBasedatas) {
            Object basedataObj;
            if (!this.validateImportportForOrg(importCacheBasedata, basedataObj = importCacheBasedata.getBasedataObj()) || !(basedataObj instanceof Map)) continue;
            this.context.setCurrentImportBillData(importCacheBasedata.getImportBillData());
            Long orgId = this.parseSourceDataIfMap(importCacheBasedata, basedataObj);
            if (orgId == null || orgId <= 0L) continue;
            ((Map)basedataObj).put("id", orgId);
            if (!(importCacheBasedata.getProp() instanceof MainOrgProp)) continue;
            this.context.setMainOrgId(orgId);
        }
    }

    private boolean validateImportportForOrg(ImportCacheBasedata importCacheBasedata, Object basedataObj) {
        if (!(basedataObj instanceof Map)) {
            return false;
        }
        Map valueMap = (Map)basedataObj;
        String importprop = (String)valueMap.get("importprop");
        if (StringUtils.isBlank((CharSequence)importprop)) {
            importprop = valueMap.containsKey("number") ? "number" : "name";
            BasedataEntityType refPropType = (BasedataEntityType)((BasedataProp)importCacheBasedata.getProp()).getComplexType();
            if (refPropType == null) {
                return false;
            }
            importprop = this.convertDefaultImportProp(refPropType, importprop);
        }
        return valueMap.containsKey("id") || !StringUtils.isBlank((CharSequence)((CharSequence)valueMap.get(importprop)));
    }

    private String convertDefaultImportProp(BasedataEntityType refPropType, String importprop) {
        importprop = "name".equals(importprop) ? refPropType.getNameProperty() : refPropType.getNumberProperty();
        return importprop;
    }

    private Long parseSourceDataIfMap(ImportCacheBasedata importCacheBasedata, Object basedataObj) {
        Long[] orgId = new Long[]{0L};
        if (!(basedataObj instanceof Map)) {
            return orgId[0];
        }
        Map orgVal = (Map)basedataObj;
        Optional<BasedataItem> orgItem = this.buildBasedataItemFromOrg(importCacheBasedata, orgVal);
        if (!orgItem.isPresent()) {
            this.tryParseOrgIdFormSourceData(orgVal, orgId);
        }
        orgItem.ifPresent(basedataItem -> this.tryParseOrgIdFormOrgItem((BasedataItem)basedataItem, orgId));
        return orgId[0];
    }

    private Optional<BasedataItem> buildBasedataItemFromOrg(ImportCacheBasedata importCacheBasedata, Map<String, String> orgVal) {
        String importprop;
        if (orgVal.containsKey("id")) {
            return Optional.empty();
        }
        BasedataEntityType refPropType = (BasedataEntityType)((BasedataProp)importCacheBasedata.getProp()).getComplexType();
        String dataType = importprop = orgVal.get("importprop");
        if (StringUtils.isBlank((CharSequence)importprop)) {
            importprop = orgVal.containsKey("number") ? "number" : "name";
            dataType = this.convertDefaultImportProp(refPropType, importprop);
        }
        MasterBasedataProp masterIdProp = null;
        BasedataEntityType refMasterType = null;
        if (refPropType.getMasteridType() == 2 && (masterIdProp = (MasterBasedataProp)refPropType.findProperty(refPropType.getMasteridPropName())) != null) {
            refMasterType = (BasedataEntityType)masterIdProp.getComplexType();
        }
        String searchKey = dataType;
        String searchValue = orgVal.get(importprop);
        if (refMasterType != null) {
            searchKey = masterIdProp.getName() + "." + dataType;
        }
        if (StringUtils.isBlank((CharSequence)searchKey)) {
            return Optional.empty();
        }
        String controlVersionDate = ImportNameVersionHandler.getVersionControl(BasedataItemUtil.getDataEntityType(importCacheBasedata), BasedataItemUtil.getImportSourceObject(importCacheBasedata));
        return Optional.of(new BasedataItem(importCacheBasedata.getProp().getName(), refPropType.getName(), refPropType, Long.valueOf(0L), searchKey, searchValue, controlVersionDate));
    }

    private void tryParseOrgIdFormSourceData(Map<String, String> orgVal, Long[] orgId) {
        String id;
        if (orgVal.containsKey("id") && (id = orgVal.get("id")) != null) {
            orgId[0] = Long.valueOf(id.toString());
        }
    }

    private void tryParseOrgIdFormOrgItem(BasedataItem orgItem, Long[] orgId) {
        if (this.context.getBasePKs().containsKey(orgItem)) {
            orgId[0] = (Long)this.context.getBasePKs().get(orgItem);
            return;
        }
        if (StringUtils.isBlank((CharSequence)orgItem.getSearchValue())) {
            return;
        }
        ArrayList<String> orgNumbers = new ArrayList<String>();
        orgNumbers.add(orgItem.getSearchValue());
        ApiFilter filter = this.buildBaseDataFilter(orgItem, orgNumbers);
        IBaseDataService baseDataService = (IBaseDataService)this.getContext().getModel().getService(IBaseDataService.class);
        DynamicObjectCollection objColl = baseDataService.queryBaseData(orgItem.getEntityNumber(), Long.valueOf(0L), filter.toQFilter(), "id," + orgItem.getSearchKey());
        if (objColl != null && !objColl.isEmpty()) {
            orgId[0] = (Long)((DynamicObject)objColl.get(0)).get("id");
            this.getContext().getBasePKs().put(orgItem, orgId[0]);
            this.getContext().getOrgInfoMap().computeIfAbsent(orgId[0], map -> new HashMap(1)).put(orgItem.getSearchKey(), orgItem.getSearchValue());
        }
    }

    private boolean checkMasterIdFromBasedataObj(ImportCacheBasedata importBasedata) {
        Object value = importBasedata.getBasedataObj();
        if (!(value instanceof Map)) {
            return false;
        }
        Map map = (Map)value;
        Object id = map.get("id");
        if (StringUtils.isBlank(id)) {
            return false;
        }
        BasedataEntityType complexType = (BasedataEntityType)((BasedataProp)importBasedata.getProp()).getComplexType();
        return complexType != null;
    }

    private void cacheBasedataId(ImportCacheBasedata importBasedata) {
        Map map = (Map)importBasedata.getBasedataObj();
        Object id = map.get("id");
        BasedataEntityType complexType = (BasedataEntityType)((BasedataProp)importBasedata.getProp()).getComplexType();
        Map<BasedataEntityType, Set<Object>> searchPKs = this.getContext().getSearchPksByImportBill(importBasedata.getImportBillData());
        if (!searchPKs.containsKey(complexType)) {
            searchPKs.put(complexType, new HashSet());
        }
        searchPKs.get(complexType).add(id);
    }

    private void cacheBasedataItem(ImportCacheBasedata importBasedata) {
        BasedataItem item = BasedataItemUtil.buildBasedataItem(this.context, importBasedata);
        if (item == null) {
            return;
        }
        if (this.getContext().getBasePksByImportBill(importBasedata.getImportBillData()).containsKey(item)) {
            return;
        }
        String searchValue = item.getSearchValue();
        item.setSearchValue(null);
        Map<BasedataItem, Set<String>> searchItems = this.getContext().getSearchItemByImportBill(importBasedata.getImportBillData());
        if (!searchItems.containsKey(item)) {
            HashSet searchValues = new HashSet();
            searchItems.put(item, searchValues);
        }
        searchItems.get(item).add(searchValue);
    }

    private void cacheCurId(ImportCacheBasedata importBasedata) {
        DynamicObject targetObj = this.metadataContext.getDataEntityByImportRowMapper(importBasedata.getImportBillData());
        IDataEntityType dataEntityType = targetObj.getDataEntityType();
        if (!(dataEntityType instanceof BasedataEntityType)) {
            return;
        }
        BasedataEntityType bdType = (BasedataEntityType)dataEntityType;
        Object pkValue = this.pkFieldProp.getValueFast((Object)targetObj);
        if (this.pkFieldProp.getValueComparator().compareValue(pkValue)) {
            pkValue = this.pkFieldProp instanceof VarcharProp ? DB.genStringIds((String)"", (int)1)[0] : Long.valueOf(DB.genGlobalLongId());
            this.pkFieldProp.setValueFast((Object)targetObj, pkValue);
        }
        String searchKey = null;
        String searchValue = null;
        Map<String, Object> sourceObj = importBasedata.getImportBillData().getSourceObj();
        String controlVersionDate = ImportNameVersionHandler.getVersionControl(BasedataItemUtil.getDataEntityType(importBasedata), BasedataItemUtil.getImportSourceObject(importBasedata));
        if (sourceObj.containsKey("number")) {
            searchKey = bdType.getNumberProperty();
            searchValue = (String)sourceObj.get("number");
            BasedataItem currItem = new BasedataItem(bdType.getName(), bdType.getName(), bdType, this.getContext().getMainOrgId(), searchKey, searchValue, controlVersionDate);
            this.getContext().getBasePksByImportBill(importBasedata.getImportBillData()).put(currItem, pkValue);
        }
        if (sourceObj.containsKey("name")) {
            searchKey = bdType.getNameProperty();
            Object nameObj = sourceObj.get("name");
            searchValue = nameObj instanceof Map ? LocaleString.fromMap((Map)((Map)nameObj)).toString() : String.valueOf(nameObj);
            BasedataItem currItem = new BasedataItem(bdType.getName(), bdType.getName(), bdType, this.getContext().getMainOrgId(), searchKey, searchValue, controlVersionDate);
            this.getContext().getBasePksByImportBill(importBasedata.getImportBillData()).put(currItem, pkValue);
        }
    }

    public ApiPropConverterContextPlus getContext() {
        return this.context;
    }

    private void batchLoadBasePKsFromDB() {
        if (this.getContext().getSearchItemsAtImportBill().isEmpty()) {
            return;
        }
        HashMap<BasedataItem, Map<String, ImportBillData>> searchInDBAtBasedataItem = new HashMap<BasedataItem, Map<String, ImportBillData>>();
        HashMap<BasedataItem, Map<ImportBillData, List<String>>> searchInCacheAtBasedataItem = new HashMap<BasedataItem, Map<ImportBillData, List<String>>>();
        this.buildSearchStruct(searchInDBAtBasedataItem, searchInCacheAtBasedataItem);
        HashMap<BasedataItem, ApiFilter> filtersAtBaseItemCache = new HashMap<BasedataItem, ApiFilter>();
        Map<ImportBillData, Map<BasedataItem, List<Object>>> searchResultAtRowMapper = this.searchAndBuildResult(searchInDBAtBasedataItem, searchInCacheAtBasedataItem, filtersAtBaseItemCache);
        HashMap<ImportBillData, Map<BasedataEntityType, List<Object>>> pkIdsFromEntityTypeAtRowMapper = new HashMap<ImportBillData, Map<BasedataEntityType, List<Object>>>();
        this.collectionPkIdFromSearchResult(searchResultAtRowMapper, pkIdsFromEntityTypeAtRowMapper);
        for (Map.Entry<ImportBillData, Map<BasedataItem, List<Object>>> entry : searchResultAtRowMapper.entrySet()) {
            this.fireEventForConfirmUnionPkId(entry.getKey(), entry.getValue());
        }
        this.collectionBizPkIdFromSearchResult(searchResultAtRowMapper, pkIdsFromEntityTypeAtRowMapper, filtersAtBaseItemCache);
        this.injectSearchPks(pkIdsFromEntityTypeAtRowMapper);
    }

    private void buildSearchStruct(Map<BasedataItem, Map<String, ImportBillData>> searchInDBAtBasedataItem, Map<BasedataItem, Map<ImportBillData, List<String>>> searchInCacheAtBasedataItem) {
        for (Map.Entry<ImportBillData, Map<BasedataItem, Set<String>>> entryAtRowMapper : this.getContext().getSearchItemsAtImportBill().entrySet()) {
            ImportBillData rowMapper = entryAtRowMapper.getKey();
            Map<BasedataItem, Set<String>> searchValuesAtBaseItem = entryAtRowMapper.getValue();
            for (Map.Entry<BasedataItem, Set<String>> searchValuesAtBaseItemEntry : searchValuesAtBaseItem.entrySet()) {
                BasedataItem basedataItem = searchValuesAtBaseItemEntry.getKey();
                List searchValues = searchValuesAtBaseItemEntry.getValue().stream().filter(searchValue -> {
                    BasedataItem basedataItemWithSearchValue = BasedataItemUtil.createInstanceWithCopy(basedataItem, searchValue);
                    Map<BasedataItem, Object> basePKs = this.getContext().getBasePKsAtImportBill().get(rowMapper);
                    if (StringUtils.isBlank((CharSequence)searchValue)) {
                        basePKs.put(basedataItemWithSearchValue, null);
                        return false;
                    }
                    return !basePKs.containsKey(basedataItemWithSearchValue);
                }).collect(Collectors.toList());
                for (String searchValue2 : searchValues) {
                    Map searchInDB = searchInDBAtBasedataItem.computeIfAbsent(basedataItem, s -> new HashMap());
                    if (!searchInDB.containsKey(searchValue2)) {
                        searchInDB.put(searchValue2, rowMapper);
                        continue;
                    }
                    searchInCacheAtBasedataItem.computeIfAbsent(basedataItem, s -> new HashMap()).computeIfAbsent(rowMapper, s -> new ArrayList()).add(searchValue2);
                }
            }
        }
    }

    private Map<ImportBillData, Map<BasedataItem, List<Object>>> searchAndBuildResult(Map<BasedataItem, Map<String, ImportBillData>> searchInDBAtBasedataItem, Map<BasedataItem, Map<ImportBillData, List<String>>> searchInCacheAtBasedataItem, Map<BasedataItem, ApiFilter> filtersAtBaseItemCache) {
        HashMap<ImportBillData, Map<BasedataItem, List<Object>>> searchResultAtRowMapper = new HashMap<ImportBillData, Map<BasedataItem, List<Object>>>();
        for (Map.Entry<BasedataItem, Map<String, ImportBillData>> searchInDBEntry : searchInDBAtBasedataItem.entrySet()) {
            BasedataItem basedataItem = searchInDBEntry.getKey();
            Map<String, ImportBillData> searchValueInDB = searchInDBEntry.getValue();
            ApiFilter filters = this.buildBaseDataFilter(basedataItem, new ArrayList<String>(searchValueInDB.keySet()));
            filtersAtBaseItemCache.putIfAbsent(basedataItem, filters);
            Map<String, List<Object>> pkIdsAtSearchValue = this.queryBasePksFromBaseItem(basedataItem, filters);
            this.buildSearchResultFormSearchInDB(searchResultAtRowMapper, basedataItem, pkIdsAtSearchValue, searchValueInDB);
            this.buildSearchResultFormSearchInCache(searchResultAtRowMapper, basedataItem, pkIdsAtSearchValue, searchInCacheAtBasedataItem.get(basedataItem));
        }
        return searchResultAtRowMapper;
    }

    private Map<String, List<Object>> queryBasePksFromBaseItem(BasedataItem basedataItem, ApiFilter filters) {
        IDataEntityProperty baseProp;
        Set bdIdsForOrg = null;
        QFilter orgFilter = null;
        if (basedataItem.getOrgId() != null && basedataItem.getOrgId() != 0L && (baseProp = this.getContext().getModel().getProperty(basedataItem.getFieldKey())) instanceof AssistantProp) {
            AssistantProp assistantProp = (AssistantProp)baseProp;
            orgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)Long.parseLong(assistantProp.getAsstTypeId()), (Long)basedataItem.getOrgId());
        }
        if (CollectionUtils.isNotEmpty(filters.getFilters())) {
            for (int i = 0; i < filters.getFilters().size(); ++i) {
                QFilter qFilter = filters.getFilters().get(i);
                if (qFilter == null) continue;
                log.info("[\u5bfc\u5165\u57fa\u7840\u8d44\u6599\u7f13\u5b58\u67e5\u8be2\u6761\u4ef6" + i + "\uff1a] " + qFilter);
            }
        }
        if (orgFilter != null && StringUtils.equals((CharSequence)orgFilter.getProperty(), (CharSequence)"id") && StringUtils.equals((CharSequence)orgFilter.getCP(), (CharSequence)"in") && orgFilter.getValue() instanceof Set) {
            bdIdsForOrg = (Set)orgFilter.getValue();
            orgFilter = null;
        }
        if (orgFilter != null) {
            filters.getFilters().add(orgFilter);
            List<String> useOrgInfo = this.getUseOrgInfo(basedataItem.getOrgId());
            filters.getCommonfilterDesc().add(String.format(ResManager.loadKDString((String)"\u5728\u201c%1$s=%2$s\u201c\u7684\u4f7f\u7528\u7ec4\u7ec7\u4e2d", (String)"BasedataPropCache_0", (String)BOS_IMPORT, (Object[])new Object[0]), useOrgInfo.get(0), useOrgInfo.get(1)));
        }
        HashMap<String, List<Object>> pkIdsAtSearchValue = new HashMap<String, List<Object>>();
        String fields = "id," + basedataItem.getSearchKey();
        IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        DynamicObjectCollection objColl = baseDataService.queryBaseDataByDate(basedataItem.getEntityNumber(), basedataItem.getOrgId(), filters.toQFilter(), fields, ImportNameVersionHandler.parseVersionControlDate(basedataItem.getVersionControl()));
        for (DynamicObject dynamicObject : objColl) {
            List curSearchResult;
            Object pkValue = dynamicObject.get("id");
            String searchValue = dynamicObject.getString(basedataItem.getSearchKey());
            if (bdIdsForOrg != null && !bdIdsForOrg.contains(pkValue) || (curSearchResult = (List)pkIdsAtSearchValue.get(searchValue)) != null && curSearchResult.contains(pkValue)) continue;
            pkIdsAtSearchValue.computeIfAbsent(searchValue, s -> new ArrayList(1)).add(pkValue);
        }
        return pkIdsAtSearchValue;
    }

    private List<String> getUseOrgInfo(Long orgId) {
        ArrayList<String> nameNumber = new ArrayList<String>(2);
        Map<Long, Map<String, String>> orgInfoMap = this.getContext().getOrgInfoMap();
        if (MapUtils.isEmpty(orgInfoMap) || !orgInfoMap.containsKey(orgId)) {
            nameNumber.add(ResManager.loadKDString((String)"\u5185\u7801", (String)"BasedataPropCache_1", (String)BOS_IMPORT, (Object[])new Object[0]));
            nameNumber.add(String.valueOf(orgId));
            return nameNumber;
        }
        Map<String, String> orgInfo = orgInfoMap.get(orgId);
        if (MapUtils.isNotEmpty(orgInfo) && orgInfo.containsKey("number")) {
            nameNumber.add(ResManager.loadKDString((String)"\u7f16\u7801", (String)"BasedataPropCache_2", (String)BOS_IMPORT, (Object[])new Object[0]));
            nameNumber.add(orgInfo.get("number"));
            return nameNumber;
        }
        if (MapUtils.isNotEmpty(orgInfo) && orgInfo.containsKey("name")) {
            nameNumber.add(ResManager.loadKDString((String)"\u540d\u79f0", (String)"BasedataPropCache_3", (String)BOS_IMPORT, (Object[])new Object[0]));
            nameNumber.add(orgInfo.get("name"));
            return nameNumber;
        }
        nameNumber.add(ResManager.loadKDString((String)"\u5185\u7801", (String)"BasedataPropCache_1", (String)BOS_IMPORT, (Object[])new Object[0]));
        nameNumber.add(String.valueOf(orgId));
        return nameNumber;
    }

    private void buildSearchResultFormSearchInDB(Map<ImportBillData, Map<BasedataItem, List<Object>>> searchResultAtRowMapper, BasedataItem basedataItem, Map<String, List<Object>> pkIdsAtSearchValue, Map<String, ImportBillData> searchValueInDB) {
        for (Map.Entry<String, ImportBillData> entry : searchValueInDB.entrySet()) {
            String searchValue = entry.getKey();
            ImportBillData rowMapper = entry.getValue();
            this.injectSearchResultAtRomMapper(searchResultAtRowMapper, basedataItem, pkIdsAtSearchValue, rowMapper, searchValue);
        }
    }

    private void buildSearchResultFormSearchInCache(Map<ImportBillData, Map<BasedataItem, List<Object>>> searchResultAtRowMapper, BasedataItem basedataItem, Map<String, List<Object>> pkIdsAtSearchValue, Map<ImportBillData, List<String>> rowMapperListMap) {
        if (rowMapperListMap == null || rowMapperListMap.isEmpty()) {
            return;
        }
        for (Map.Entry<ImportBillData, List<String>> entry : rowMapperListMap.entrySet()) {
            ImportBillData rowMapper = entry.getKey();
            List<String> searchValues = entry.getValue();
            for (String searchValue : searchValues) {
                this.injectSearchResultAtRomMapper(searchResultAtRowMapper, basedataItem, pkIdsAtSearchValue, rowMapper, searchValue);
            }
        }
    }

    private void injectSearchResultAtRomMapper(Map<ImportBillData, Map<BasedataItem, List<Object>>> searchResultAtRowMapper, BasedataItem basedataItem, Map<String, List<Object>> pkIdsAtSearchValue, ImportBillData rowMapper, String searchValue) {
        BasedataItem basedataItemWithSearchValue = BasedataItemUtil.createInstanceWithCopy(basedataItem, searchValue);
        List<Object> pkIds = pkIdsAtSearchValue.get(searchValue);
        if (CollectionUtils.isEmpty(pkIds)) {
            searchResultAtRowMapper.computeIfAbsent(rowMapper, s -> new HashMap()).putIfAbsent(basedataItemWithSearchValue, new ArrayList(1));
            return;
        }
        searchResultAtRowMapper.computeIfAbsent(rowMapper, s -> new HashMap()).putIfAbsent(basedataItemWithSearchValue, pkIds);
    }

    private void collectionPkIdFromSearchResult(Map<ImportBillData, Map<BasedataItem, List<Object>>> searchResultAtRowMapper, Map<ImportBillData, Map<BasedataEntityType, List<Object>>> pkIdsFromEntityTypeAtRowMapper) {
        for (Map.Entry<ImportBillData, Map<BasedataItem, List<Object>>> entry : searchResultAtRowMapper.entrySet()) {
            ImportBillData rowMapper = entry.getKey();
            Map<BasedataItem, List<Object>> searchResult = entry.getValue();
            Iterator<Map.Entry<BasedataItem, List<Object>>> searchResultEntryIterator = searchResult.entrySet().iterator();
            while (searchResultEntryIterator.hasNext()) {
                Map.Entry<BasedataItem, List<Object>> searchResultEntry = searchResultEntryIterator.next();
                BasedataItem basedataItem = searchResultEntry.getKey();
                List<Object> searchPkIds = searchResultEntry.getValue();
                if (searchPkIds == null || searchPkIds.size() != 1) continue;
                pkIdsFromEntityTypeAtRowMapper.computeIfAbsent(rowMapper, s -> new HashMap()).computeIfAbsent(basedataItem.getRefBDType(), s -> new ArrayList()).add(searchPkIds.get(0));
                this.getContext().getBasePksByImportBill(rowMapper).putIfAbsent(basedataItem, searchPkIds.get(0));
                searchResultEntryIterator.remove();
            }
        }
    }

    private void fireEventForConfirmUnionPkId(ImportBillData importBillData, Map<BasedataItem, List<Object>> searchResult) {
        ModelEventProxy modelEventProxy = this.getContext().getModelEventProxy();
        if (modelEventProxy != null) {
            RowMapper rowMapper = new RowMapper(importBillData.getSourceObj(), this.metadataContext.getDataEntityByImportRowMapper(importBillData), null, importBillData.getRowIndex());
            RowMapper entryRowMapper = new RowMapper(importBillData.getSourceObj(), this.metadataContext.getDataEntityByImportRowMapper(importBillData), rowMapper, importBillData.getRowIndex());
            RowMapper subEntryRowMapper = new RowMapper(importBillData.getSourceObj(), this.metadataContext.getDataEntityByImportRowMapper(importBillData), entryRowMapper, importBillData.getRowIndex());
            QueryImportBasedataEventArgs evt = new QueryImportBasedataEventArgs((Object)subEntryRowMapper, searchResult);
            this.metadataContext.getImportMonitor().addPluginMonitor("before queryImportBasedata", this.metadataContext.getImportMonitor().safeToJsonStrng(evt.getSearchResult()));
            modelEventProxy.fireQueryImportBasedata(evt);
            this.metadataContext.getImportMonitor().addPluginMonitor("after queryImportBasedata", this.metadataContext.getImportMonitor().safeToJsonStrng(evt.getSearchResult()));
        }
    }

    private void collectionBizPkIdFromSearchResult(Map<ImportBillData, Map<BasedataItem, List<Object>>> searchResultAtRowMapper, Map<ImportBillData, Map<BasedataEntityType, List<Object>>> pkIdsFromEntityTypeAtRowMapper, Map<BasedataItem, ApiFilter> filtersAtBaseItemCache) {
        for (Map.Entry<ImportBillData, Map<BasedataItem, List<Object>>> entry : searchResultAtRowMapper.entrySet()) {
            ImportBillData importBillData = entry.getKey();
            Map<BasedataItem, List<Object>> searchResult = entry.getValue();
            for (Map.Entry<BasedataItem, List<Object>> searchResultEntry : searchResult.entrySet()) {
                BasedataItem basedataItem = searchResultEntry.getKey();
                List<Object> searchPkIds = searchResultEntry.getValue();
                if (searchPkIds == null) continue;
                if (searchPkIds.size() == 1) {
                    this.getContext().getBizBasePksByImportBill(importBillData).put(basedataItem, new BizBasedataPk(searchPkIds.get(0)));
                    pkIdsFromEntityTypeAtRowMapper.computeIfAbsent(importBillData, s -> new HashMap()).computeIfAbsent(basedataItem.getRefBDType(), s -> new ArrayList()).add(searchPkIds.get(0));
                    continue;
                }
                if (searchPkIds.size() > 1) {
                    this.getContext().getBizBasePksByImportBill(importBillData).put(basedataItem, new BizBasedataPk(searchPkIds, this.buildRepeatError(searchResultEntry, filtersAtBaseItemCache.get(BasedataItemUtil.createInstanceWithCopy(basedataItem, null)))));
                    continue;
                }
                this.getContext().getBizBasePksByImportBill(importBillData).put(basedataItem, new BizBasedataPk(searchPkIds, this.buildExistError(searchResultEntry, filtersAtBaseItemCache.get(BasedataItemUtil.createInstanceWithCopy(basedataItem, null)))));
            }
        }
    }

    private void injectSearchPks(Map<ImportBillData, Map<BasedataEntityType, List<Object>>> pkIdsFromEntityTypeAtRowMapper) {
        for (Map.Entry<ImportBillData, Map<BasedataEntityType, List<Object>>> entry : pkIdsFromEntityTypeAtRowMapper.entrySet()) {
            ImportBillData rowMapper = entry.getKey();
            Map<BasedataEntityType, List<Object>> pkIdsFromEntityType = entry.getValue();
            for (Map.Entry<BasedataEntityType, List<Object>> entityTypeListEntry : pkIdsFromEntityType.entrySet()) {
                BasedataEntityType entityType = entityTypeListEntry.getKey();
                List<Object> pkIds = entityTypeListEntry.getValue();
                this.getContext().getSearchPksByImportBill(rowMapper).computeIfAbsent(entityType, s -> new HashSet()).addAll(pkIds);
            }
        }
    }

    private void batchLoadBaseObjsFromDB() {
        if (this.getContext().getSearchPKsAtImportBill().isEmpty()) {
            return;
        }
        Map<ImportBillData, Map<BasedataEntityType, Set<Object>>> searchPKsAtRowMapper = this.getContext().getSearchPKsAtImportBill();
        HashMap<BasedataEntityType, Set> tempSearchPks = new HashMap<BasedataEntityType, Set>();
        for (Map.Entry<ImportBillData, Map<BasedataEntityType, Set<Object>>> entry : searchPKsAtRowMapper.entrySet()) {
            Map<BasedataEntityType, Set<Object>> searchPKs = entry.getValue();
            for (Map.Entry<BasedataEntityType, Set<Object>> searchPKsEntry : searchPKs.entrySet()) {
                BasedataEntityType basedataEntityType = searchPKsEntry.getKey();
                Set<Object> pkIds = searchPKsEntry.getValue();
                tempSearchPks.computeIfAbsent(basedataEntityType, s -> new HashSet()).addAll(pkIds);
            }
        }
        HashSet ids = new HashSet(1000);
        for (Map.Entry item : tempSearchPks.entrySet()) {
            BasedataEntityType bdType = (BasedataEntityType)item.getKey();
            Set pks = (Set)item.getValue();
            if (!this.getContext().getBaseObjs().containsKey(bdType.getName())) {
                ids.addAll(pks);
            } else {
                for (Object id : (Set)item.getValue()) {
                    if (this.getContext().getBaseObjs().get(bdType.getName()).containsKey(id)) continue;
                    ids.add(id);
                }
            }
            if (ids.isEmpty()) continue;
            ISimpleProperty primaryKey = bdType.getPrimaryKey();
            String disPlayName = bdType.getDisplayName() != null ? bdType.getDisplayName().toString() : bdType.getName();
            ConvertResult convertResult = ImportConvertUtils.convertIds(Arrays.asList(ids.toArray()), primaryKey.getPropertyType(), disPlayName);
            if (StringUtils.isNotBlank((CharSequence)convertResult.getErrMsg())) {
                throw new KDBizException(convertResult.getErrMsg());
            }
            Map objs = BusinessDataReader.loadFromCache((Object[])convertResult.getIds().toArray(), (DynamicObjectType)bdType);
            if (!this.getContext().getBaseObjs().containsKey(bdType.getName())) {
                this.getContext().getBaseObjs().put(bdType.getName(), new HashMap(objs.size()));
            }
            this.getContext().getBaseObjs().get(bdType.getName()).putAll(objs);
            ids.clear();
        }
    }

    private void collectionBasePk() {
        for (Map.Entry<ImportBillData, Map<BasedataItem, Object>> entry : this.getContext().getBasePKsAtImportBill().entrySet()) {
            Map<BasedataItem, Object> basedataItemPkMap = entry.getValue();
            for (Map.Entry<BasedataItem, Object> entry2 : basedataItemPkMap.entrySet()) {
                this.getContext().getBasePKs().putIfAbsent(entry2.getKey(), entry2.getValue());
            }
        }
        for (Map.Entry<ImportBillData, Map<BasedataItem, Object>> entry : this.getContext().getBizBasePKsAtImportBill().entrySet()) {
            Map<BasedataItem, Object> bizBasedataItemPkMap = entry.getValue();
            for (Map.Entry<BasedataItem, Object> entry2 : bizBasedataItemPkMap.entrySet()) {
                this.getContext().getBizBasePKs().putIfAbsent(entry2.getKey(), (BizBasedataPk)entry2.getValue());
            }
        }
    }

    private String buildRepeatError(Map.Entry<BasedataItem, List<Object>> searchResult, ApiFilter filters) {
        StringBuilder sb = new StringBuilder();
        BasedataItem item = searchResult.getKey();
        sb.append("\u201c");
        sb.append(filters.getFilterDesc().get(item));
        sb.append("\u201d");
        for (String msg : filters.getCommonfilterDesc()) {
            sb.append(msg);
        }
        sb.append('\uff0c').append(ResManager.loadKDString((String)"\u7b26\u5408\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6", (String)"ApiBasedataPropConverter_7", (String)BOS_IMPORT, (Object[])new Object[0]));
        String displayName = this.getDisplayName((EntityType)this.getContext().getModel().getDataEntityType(), item.getFieldKey());
        return String.format(ResManager.loadKDString((String)"%1$s\u7684\u201c%2$s\u201d\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230\u91cd\u590d\u7684\u201c%3$s\u201d\uff0c\u91cd\u590d\u7684\u5185\u7801\u4e3a\uff1a%4$s\u3002", (String)"ApiBasedataPropConverter_18", (String)BOS_IMPORT, (Object[])new Object[0]), sb, displayName, displayName, searchResult.getValue().size() > 3 ? searchResult.getValue().subList(0, 3) + "\u2026\u2026" : searchResult.getValue());
    }

    private String getDisplayName(EntityType entityType, String propKey) {
        if ("id".equals(propKey)) {
            return ResManager.loadKDString((String)"\u5185\u7801", (String)"ApiBasedataPropConverter_13", (String)BOS_IMPORT, (Object[])new Object[0]);
        }
        if ("pid".equals(propKey)) {
            return ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ApiBasedataPropConverter_14", (String)BOS_IMPORT, (Object[])new Object[0]);
        }
        IDataEntityProperty prop = EntityTypeUtil.getDataEntityProperty((String)propKey, (EntityType)entityType, (boolean)false);
        if (prop == null) {
            return propKey;
        }
        LocaleString displayName = prop.getDisplayName();
        return displayName != null && StringUtils.isNotBlank((CharSequence)displayName.toString()) ? displayName.toString() : propKey;
    }

    private String buildExistError(Map.Entry<BasedataItem, List<Object>> searchResult, ApiFilter filters) {
        BasedataItem item = searchResult.getKey();
        StringBuilder errorMsg = new StringBuilder();
        String bdName = this.getDisplayName((EntityType)this.getContext().getModel().getDataEntityType(), item.getFieldKey());
        String filterDesc = filters.getFilterDesc().get(item);
        String searchName = filters.getSearchName().get(item);
        errorMsg.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u65f6\u627e\u4e0d\u5230%1$s\u7684%2$s\u3002", (String)"BasedataPropCache_4", (String)BOS_IMPORT, (Object[])new Object[0]), filterDesc, bdName));
        return errorMsg.toString();
    }

    private ApiFilter buildBaseDataFilter(BasedataItem basedataItem, List<String> searchValues) {
        ApiFilter apiFilter = new ApiFilter();
        StringBuilder sb = new StringBuilder();
        for (String value : searchValues) {
            BasedataEntityType baseType = basedataItem.getRefBDType();
            BasedataItem item = new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), value, basedataItem.getBizTag(), basedataItem.getVersionControl());
            sb.setLength(0);
            sb.append(this.getDisplayName((EntityType)baseType, basedataItem.getSearchKey()));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                sb.append('=').append(value);
            } else {
                sb.append(ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"ApiBasedataPropConverter_12", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
            apiFilter.getSearchName().put(item, this.getDisplayName((EntityType)baseType, basedataItem.getSearchKey()));
            apiFilter.getFilterDesc().put(item, sb.toString());
        }
        if (searchValues.size() == 1) {
            apiFilter.getFilters().add(new QFilter(basedataItem.getSearchKey(), "=", (Object)searchValues.get(0)));
        } else {
            apiFilter.getFilters().add(new QFilter(basedataItem.getSearchKey(), "in", searchValues));
        }
        if (this.getContext().isCheckBasedataPerm()) {
            String formShowParameterAppId = this.getContext().getFormShowParameterAppId();
            IDataModel model = this.getContext().getModel();
            model.putContextVariable("APPID", (Object)formShowParameterAppId);
            IDataEntityProperty baseProp = model.getProperty(basedataItem.getFieldKey());
            List<QFilter> fieldFilters = ImportFilterUtil.buildBaseDataF7QFilters((IBasedataField)baseProp, model, formShowParameterAppId, basedataItem.getEntityNumber(), new ArrayList<QFilter>(), "47150e89000000ac", true);
            QFilter qfilter = this.getDataRuleFilter(basedataItem, model, formShowParameterAppId);
            if (qfilter != null) {
                fieldFilters.add(qfilter);
            }
            if (fieldFilters != null) {
                apiFilter.getFilters().addAll(fieldFilters);
            }
        }
        return apiFilter;
    }

    private QFilter getDataRuleFilter(BasedataItem basedataItem, IDataModel model, String appId) {
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        if (permissionService.hasEnableOldDataRule()) {
            return permissionService.getDataPermission(RequestContext.get().getCurrUserId(), appId, basedataItem.getEntityNumber());
        }
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(basedataItem.getOrgId());
        return permissionService.getDataRuleForBdProp(RequestContext.get().getCurrUserId(), appId, (IDataEntityType)model.getDataEntityType(), basedataItem.getFieldKey(), "4730fc9f000003ae", orgIdList, new HashMap());
    }
}

