/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.process.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.form.IFormView;
import kd.bos.form.impt.ApiServiceLocalCache;
import kd.bos.form.impt.ImportBillData;
import kd.bos.form.impt.basecache.ImportApiControl;
import kd.bos.form.impt.basecache.ImportCacheBasedata;
import kd.bos.form.impt.basecache.ImportSourceObject;
import kd.bos.form.impt.context.MetadataContext;
import kd.bos.form.impt.context.ResultContext;
import kd.bos.form.impt.process.impl.ConvertDataEntityProcess;
import kd.bos.form.operate.imptapi.OperateDataConverter;

public class ConvertDataEntityProcessFast
extends ConvertDataEntityProcess {
    private ImportApiControl importApiControl;
    private List<ImportCacheBasedata> importBasedatas;

    @Override
    public void init(IFormView formView, MetadataContext metadataContext, ResultContext resultContext) {
        super.init(formView, metadataContext, resultContext);
        this.initImportApiControl();
    }

    @Override
    protected void initForSingleBatch(IFormView formView, MetadataContext metadataContext, ResultContext resultContext) {
        super.initForSingleBatch(formView, metadataContext, resultContext);
        this.importApiControl.initForSingleBatch(metadataContext);
        this.importBasedatas = new ArrayList<ImportCacheBasedata>();
    }

    @Override
    protected void convertData() {
        this.cacheBasedatas();
        super.convertData();
    }

    @Override
    protected OperateDataConverter getOperateDataConverter() {
        return (OperateDataConverter)this.funcGetDataConverter.apply(this.formView.getModel(), this.importApiControl.getApiPropConverterContext());
    }

    @Override
    protected boolean convertMapToDataEntityWithException(ImportBillData rowMapper) {
        this.importApiControl.getApiPropConverterContext().setCurrentImportBillData(rowMapper);
        return super.convertMapToDataEntityWithException(rowMapper);
    }

    private void cacheBasedatas() {
        this.createImportBasedatas();
        this.formView.getModel().beginInit();
        this.importApiControl.getBasedataPropCache().buildRowMapperCache(this.importBasedatas);
        this.formView.getModel().endInit();
    }

    private void initImportApiControl() {
        String entityNumber = this.formView.getModel().getDataEntityType().getName();
        Map<BasedataItem, Object> cacheBasePKs = ApiServiceLocalCache.getBasePKs(entityNumber);
        Map<String, Map<Object, DynamicObject>> cacheBaseObjs = ApiServiceLocalCache.getBaseOBJs(entityNumber);
        this.importApiControl = new ImportApiControl(this.formView.getModel(), cacheBasePKs, cacheBaseObjs);
        this.importApiControl.getApiPropConverterContext().setAttDirPath(this.metadataContext.getAttDirPath());
        this.importApiControl.getApiPropConverterContext().setAttachmentPanelAps(this.metadataContext.getAttachmentPanelAps());
        boolean importMode = this.metadataContext.getOptions() != null && (Boolean)this.metadataContext.getOptions().getOrDefault("importmode", false) != false;
        this.importApiControl.setImportMode(importMode);
        this.importApiControl.setHasPermResult(this.metadataContext.getAbstractSave().getHasPermOrgResult());
        this.importApiControl.setRowMappers(this.metadataContext.getImportBillDatas());
        this.importApiControl.setFormShowParameterAppId(this.metadataContext.getFormShowParameterAppId());
    }

    private void createImportBasedatas() {
        for (ImportBillData importBillData : this.metadataContext.getImportBillDatas()) {
            Map<String, Object> sourceObj = importBillData.getSourceObj();
            this.buildImportBasedataAtHead(importBillData, sourceObj);
        }
    }

    private void buildImportBasedataAtHead(ImportBillData importBillData, Map<String, Object> sourceObj) {
        for (Map.Entry<String, Object> entry : sourceObj.entrySet()) {
            String propName = entry.getKey();
            IDataEntityProperty prop = this.formView.getModel().getProperty(propName);
            ImportSourceObject importSourceObject = new ImportSourceObject(sourceObj, null);
            this.tryAddImportBasedata(importBillData, this.metadataContext.getDataEntityByImportRowMapper(importBillData), prop, entry.getValue(), importSourceObject);
            this.buildImportBasedataAtEntry(importBillData, prop, entry.getValue(), importSourceObject);
        }
    }

    private void buildImportBasedataAtEntry(ImportBillData importBillData, IDataEntityProperty prop, Object value, ImportSourceObject parentImportSourceObject) {
        if (!(prop instanceof EntryProp)) {
            return;
        }
        List sourceObjs = (List)value;
        EntryType entityType = (EntryType)((EntryProp)prop).getItemType();
        for (Map sourceObj : sourceObjs) {
            for (Map.Entry entry : sourceObj.entrySet()) {
                String propName = (String)entry.getKey();
                if ("id".equals(propName)) {
                    propName = entityType.getName() + propName;
                }
                DynamicProperty entryProp = entityType.getProperty(propName);
                ImportSourceObject importSourceObject = new ImportSourceObject(sourceObj, parentImportSourceObject);
                this.tryAddImportBasedata(importBillData, this.metadataContext.getDataEntityByImportRowMapper(importBillData), (IDataEntityProperty)entryProp, entry.getValue(), importSourceObject);
                this.buildImportBasedataAtSubEntry(importBillData, entryProp, entry.getValue(), importSourceObject);
            }
        }
    }

    private void buildImportBasedataAtSubEntry(ImportBillData importBillData, DynamicProperty prop, Object value, ImportSourceObject parentImportSourceObject) {
        if (!(prop instanceof SubEntryProp)) {
            return;
        }
        List sourceObjs = (List)value;
        EntryType entityType = (EntryType)((EntryProp)prop).getItemType();
        for (Map sourceObj : sourceObjs) {
            for (Map.Entry entry : sourceObj.entrySet()) {
                String propName = (String)entry.getKey();
                if ("id".equals(propName)) {
                    propName = entityType.getName() + propName;
                }
                DynamicProperty entryProp = entityType.getProperty(propName);
                ImportSourceObject importSourceObject = new ImportSourceObject(sourceObj, parentImportSourceObject);
                this.tryAddImportBasedata(importBillData, this.metadataContext.getDataEntityByImportRowMapper(importBillData), (IDataEntityProperty)entryProp, entry.getValue(), importSourceObject);
            }
        }
    }

    private void tryAddImportBasedata(ImportBillData importBillData, DynamicObject dataEntity, IDataEntityProperty property, Object value, ImportSourceObject importSourceObject) {
        if (property != null && this.supportCacheClass(property)) {
            ImportCacheBasedata importCacheBasedata = new ImportCacheBasedata(property, importBillData, dataEntity, value, importSourceObject);
            this.importBasedatas.add(importCacheBasedata);
        }
    }

    private boolean supportCacheClass(IDataEntityProperty prop) {
        return prop.getClass() == BasedataProp.class || prop.getClass() == OrgProp.class || prop.getClass() == MainOrgProp.class || prop.getClass() == MaterielProp.class || prop.getClass() == UnitProp.class || prop.getClass() == CurrencyProp.class || StringUtils.equals((CharSequence)prop.getClass().getName(), (CharSequence)"kd.bos.ext.bd.entity.property.SupplierProp") || StringUtils.equals((CharSequence)prop.getClass().getName(), (CharSequence)"kd.bos.ext.bd.entity.property.CustomerProp");
    }
}

