/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.process.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.impt.ApiServiceLocalCache;
import kd.bos.form.impt.ImportBillData;
import kd.bos.form.impt.ImportBillResult;
import kd.bos.form.impt.ImportDataUtil;
import kd.bos.form.impt.process.AbstractImportDataProcess;
import kd.bos.form.impt.process.ImportDataProcessPriority;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections4.MapUtils;

public class CreateDataEntityProcess
extends AbstractImportDataProcess {
    private DynamicObject blankDataEntity;

    @Override
    public ImportDataProcessPriority priority() {
        return ImportDataProcessPriority.CREATE_DATA_ENTITY;
    }

    @Override
    public final void doProcess() {
        this.createData();
        for (ImportBillData rowMapper : this.metadataContext.getImportBillDatas()) {
            DynamicObject dataEntity = this.metadataContext.getDataEntityByImportRowMapper(rowMapper);
            if (dataEntity != null) continue;
            this.addBlankDataEntity(rowMapper);
        }
        this.formView.getModel().beginInit();
        this.formView.getModel().createNewData((Object)this.getBlankDataEntity(this.formView.getModel()));
        this.formView.getModel().endInit();
    }

    protected void createData() {
        if ("new".equals(this.metadataContext.getImportType())) {
            this.validateForNewType();
            return;
        }
        this.validateForUpdateOrNewAndUpdateType();
    }

    private void validateForUpdateOrNewAndUpdateType() {
        HashMap<Iterator<Map.Entry<Class, List<Object>>>, ImportBillData> pksNeedToBeSelectedMap = new HashMap<Iterator<Map.Entry<Class, List<Object>>>, ImportBillData>(this.metadataContext.getImportBillDatas().size());
        for (ImportBillData rowMapper : this.metadataContext.getImportBillDatas()) {
            Iterator<Map.Entry<Class, List<Object>>> pkId = rowMapper.getSourceObj().get("id");
            if (pkId == null) continue;
            pksNeedToBeSelectedMap.put(pkId, rowMapper);
        }
        HashSet<Object> pkExistList = new HashSet<Object>();
        if (MapUtils.isNotEmpty(pksNeedToBeSelectedMap)) {
            Map<Class, List<Object>> pkIdsGroupByType = pksNeedToBeSelectedMap.keySet().stream().collect(Collectors.groupingBy(Object::getClass));
            for (Map.Entry<Class, List<Object>> pkIdListEntry : pkIdsGroupByType.entrySet()) {
                List<Object> pkList = pkIdListEntry.getValue();
                DynamicObject[] pkDynamicObjects = BusinessDataServiceHelper.load((String)this.formView.getModel().getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
                pkExistList.add(Arrays.stream(pkDynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
            }
        }
        for (ImportBillData rowMapper : this.metadataContext.getImportBillDatas()) {
            boolean existData = rowMapper.getSourceObj().containsKey("id");
            Object pkId = rowMapper.getSourceObj().get("id");
            this.validateForLoadData(rowMapper, existData, pkId, pkExistList);
            this.loadData(rowMapper, pkId);
        }
    }

    private void validateForNewType() {
        HashMap<Object, ImportBillData> pksNeedToBeSelectedMap = new HashMap<Object, ImportBillData>(this.metadataContext.getImportBillDatas().size());
        for (ImportBillData importBillData : this.metadataContext.getImportBillDatas()) {
            this.validatePkIdFromSourceData(importBillData, pksNeedToBeSelectedMap);
            this.addBlankDataEntity(importBillData);
        }
        if (MapUtils.isNotEmpty(pksNeedToBeSelectedMap)) {
            Map<Class, List<Object>> pkIdsGroupByType = pksNeedToBeSelectedMap.keySet().stream().collect(Collectors.groupingBy(Object::getClass));
            for (Map.Entry<Class, List<Object>> pkIdListEntry : pkIdsGroupByType.entrySet()) {
                List<Object> pkList = pkIdListEntry.getValue();
                DynamicObject[] pkDynamicObjects = BusinessDataServiceHelper.load((String)this.formView.getModel().getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
                List pkExistList = Arrays.stream(pkDynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                for (Object pkExist : pkExistList) {
                    this.dealPkMsgForNewType((ImportBillData)pksNeedToBeSelectedMap.get(pkExist), pkExist);
                }
            }
        }
    }

    private void validatePkIdFromSourceData(ImportBillData rowMapper, Map<Object, ImportBillData> pksNeedToBeSelectedMap) {
        Object pkId = rowMapper.getSourceObj().get("id");
        if (pkId == null || StringUtils.isBlank((Object)pkId)) {
            this.resultContext.addResultsForCreateDataEntity(rowMapper.getRowIndex(), ImportBillResult.createSuccess());
            return;
        }
        Class pkIdType = this.formView.getModel().getDataEntityType().getPrimaryKey().getPropertyType();
        if (pkId.getClass() != pkIdType && "0".equals((pkId = ConvertUtils.convert((Object)pkId, (Class)pkIdType)).toString())) {
            Object source_id_ = rowMapper.getSourceObj().get("_source_id_");
            this.resultContext.addResultsForCreateDataEntity(rowMapper.getRowIndex(), ImportBillResult.createError(String.format(ResManager.loadKDString((String)"\u5185\u7801\uff1a\u201c%s\u201d\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u5fc5\u987b\u4e3a10-19\u4f4d\u6570\u5b57\u3002", (String)"ApiPkPropConverter_1", (String)"bos-import", (Object[])new Object[0]), source_id_)));
            return;
        }
        pksNeedToBeSelectedMap.put(pkId, rowMapper);
        this.resultContext.addResultsForCreateDataEntity(rowMapper.getRowIndex(), ImportBillResult.createSuccess());
    }

    private void dealPkMsgForNewType(ImportBillData rowMapper, Object pkId) {
        this.resultContext.addResultsForCreateDataEntity(rowMapper.getRowIndex(), ImportBillResult.createError(String.format(ResManager.loadKDString((String)"\u5185\u7801\u5df2\u5b58\u5728\u65e0\u6cd5\u65b0\u589e\uff1a%s", (String)"ImportDataSave_6", (String)"bos-import", (Object[])new Object[0]), pkId)));
    }

    protected void loadData(ImportBillData rowMapper, Object pkId) {
        this.initModel(() -> {
            ImportBillResult importResult = this.modelLoadData(this.formView.getModel(), pkId);
            this.resultContext.addResultsForCreateDataEntity(rowMapper.getRowIndex(), importResult);
            if (importResult.isSuccess()) {
                this.metadataContext.addDataEntity(rowMapper.getRowIndex(), this.formView.getModel().getDataEntity());
                return null;
            }
            return null;
        });
    }

    private void addBlankDataEntity(ImportBillData rowMapper) {
        DynamicObject dataEntity = this.getBlankDataEntity(this.formView.getModel());
        this.metadataContext.addDataEntity(rowMapper.getRowIndex(), dataEntity);
    }

    private void initModel(Supplier<Void> supplier) {
        if (!this.metadataContext.isFirePropChanged()) {
            this.formView.getModel().beginInit();
            supplier.get();
            this.formView.getModel().endInit();
            return;
        }
        supplier.get();
    }

    private boolean validateForLoadData(ImportBillData rowMapper, boolean existData, Object pkId, Set<Object> pkExistList) {
        if (existData && pkId == null) {
            this.resultContext.addResultsForCreateDataEntity(rowMapper.getRowIndex(), ImportBillResult.createError((String)rowMapper.getSourceObj().remove("_errMsg_")));
            return false;
        }
        if (!existData && "override".equals(this.metadataContext.getImportType())) {
            this.resultContext.addResultsForCreateDataEntity(rowMapper.getRowIndex(), ImportBillResult.createError(String.format(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u7cfb\u7edf\u627e\u4e0d\u5230\u201c%s\u201d\u7684\u6570\u636e\u884c\u3002", (String)"ImportDataSave_7", (String)"bos-import", (Object[])new Object[0]), ImportDataUtil.getFilterDesc(this.formView.getModel(), this.metadataContext.getOptions(), rowMapper.getSourceObj(), this.metadataContext.getSourceDatas()))));
            return false;
        }
        if (!this.validatePkIdExistForLoadData(existData, pkId, pkExistList)) {
            if ("overridenew".equals(this.metadataContext.getImportType())) {
                this.resultContext.addResultsForCreateDataEntity(rowMapper.getRowIndex(), ImportBillResult.createSuccess());
                return false;
            }
            if ("override".equals(this.metadataContext.getImportType())) {
                this.resultContext.addResultsForCreateDataEntity(rowMapper.getRowIndex(), ImportBillResult.createError(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\u5185\u7801ID\uff1a%s", (String)"ImportDataSave_8", (String)"bos-import", (Object[])new Object[0]), rowMapper.getSourceObj().get("_source_id_"))));
                return false;
            }
        }
        return true;
    }

    private boolean validatePkIdExistForLoadData(boolean existData, Object pkId, Set<Object> pkExistList) {
        if (existData && pkId != null) {
            return pkExistList.contains(pkId);
        }
        return false;
    }

    private ImportBillResult modelLoadData(IDataModel model, Object pkId) {
        ImportBillResult[] importResults = new ImportBillResult[1];
        ((IBillModel)model).load(pkId, () -> this.validateLoadData(model, pkId, importResults));
        return importResults[0];
    }

    protected OperationResult validateLoadData(IDataModel model, Object pkId, ImportBillResult[] importResults) {
        BillEntityType dt = (BillEntityType)model.getDataEntityType();
        String billStatusKey = dt.getBillStatus();
        if (!this.metadataContext.isForUpdateMultiLangFields() && StringUtils.isNotBlank((CharSequence)billStatusKey) && !dt.getProperty(billStatusKey).isDbIgnore()) {
            Object status = model.getValue(billStatusKey);
            if (BillStatus.B.name().equals(status)) {
                importResults[0] = ImportBillResult.createError(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"ImportDataSave_11", (String)"bos-import", (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.B)));
                return importResults[0].convertToOperationResult();
            }
            if (BillStatus.C.name().equals(status)) {
                String masterIdProp;
                boolean isDefaultAudit;
                boolean allowOverrideAudit = isDefaultAudit = BillStatus.C.name().equals(((FieldProp)dt.getProperty(billStatusKey)).getDefValue());
                int modeType = LicenseServiceHelper.getModeType();
                boolean isXk = false;
                if (modeType == 2 || modeType == 4) {
                    isXk = true;
                }
                if (!isXk && !isDefaultAudit && dt instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(masterIdProp = ((BasedataEntityType)dt).getMasteridPropName()))) {
                    Object masterId = model.getValue(masterIdProp);
                    if (this.isHashCtrlStrategy(dt) && pkId.equals(masterId)) {
                        allowOverrideAudit = true;
                    }
                }
                if (!allowOverrideAudit) {
                    importResults[0] = ImportBillResult.createError(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"ImportDataSave_11", (String)"bos-import", (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.C)));
                    return importResults[0].convertToOperationResult();
                }
            }
        }
        importResults[0] = ImportBillResult.createSuccess();
        return importResults[0].convertToOperationResult();
    }

    private Object getStatusCaption(BillEntityType dt, String billStatusKey, BillStatus status) {
        BillStatusProp statusProp = (BillStatusProp)dt.getProperty(billStatusKey);
        for (ValueMapItem item : statusProp.getComboItems()) {
            if (!status.name().equals(item.getValue())) continue;
            return item.getName();
        }
        return status.getValue();
    }

    private boolean isHashCtrlStrategy(BillEntityType dt) {
        return dt.getProperty("createorg") != null && dt.getProperty("ctrlstrategy") != null;
    }

    protected DynamicObject getBlankDataEntity(IDataModel model) {
        if (this.blankDataEntity == null) {
            this.blankDataEntity = ApiServiceLocalCache.getBlankDataEntity(model.getDataEntityType().getName(), String.valueOf(RequestContext.get().getOrgId()), RequestContext.get().getUserId());
        }
        if (this.blankDataEntity != null && !StringUtils.equals((CharSequence)this.blankDataEntity.getDataEntityType().getVersion(), (CharSequence)model.getDataEntityType().getVersion())) {
            this.blankDataEntity = null;
        }
        if (this.blankDataEntity == null) {
            model.beginInit();
            model.createNewData();
            model.endInit();
            this.blankDataEntity = model.getDataEntity();
            ApiServiceLocalCache.putBlankDataEntity(model.getDataEntityType().getName(), String.valueOf(RequestContext.get().getOrgId()), RequestContext.get().getUserId(), this.blankDataEntity);
        } else {
            IDataEntityType dt = this.blankDataEntity.getDataEntityType();
            for (IDataEntityProperty property : dt.getProperties()) {
                if (!(property instanceof CreateDateProp)) continue;
                property.setValue((Object)this.blankDataEntity, (Object)new Date());
                break;
            }
        }
        return (DynamicObject)OrmUtils.clone((IDataEntityBase)this.blankDataEntity, (boolean)false, (boolean)true);
    }
}

