/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.process.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.impt.ImportBillData;
import kd.bos.form.impt.context.MetadataContext;
import kd.bos.form.impt.context.ResultContext;
import kd.bos.form.impt.process.AbstractImportDataProcess;
import kd.bos.form.impt.process.ImportDataProcessPriority;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class SearchAndFillPkIdProcess
extends AbstractImportDataProcess {
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String IMPORTPROP = "importprop";
    private Map<String, Set<Object>> fieldAndValsOfSqlWhere;
    private static final String BOS_IMPORT = "bos-import";

    @Override
    public ImportDataProcessPriority priority() {
        return ImportDataProcessPriority.SEARCH_AND_FILL_PKID;
    }

    @Override
    public final void doProcess() {
        if (!this.canFillPk()) {
            return;
        }
        if (BaseDataServiceHelper.checkBaseDataCtrl((String)this.formView.getModel().getDataEntityType().getName()).booleanValue()) {
            this.metadataContext.getImportMonitor().addImportLog("BaseDataServiceHelper.checkBaseDataCtrl", String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u7ed3\u679c\u4e3atrue\uff0c\u6821\u9a8c\u65b9\u6cd5\u53c2\u6570 \uff1a %s", (String)"SearchAndFillPkIdProcess_0", (String)BOS_IMPORT, (Object[])new Object[0]), this.formView.getModel().getDataEntityType().getName()));
            return;
        }
        QFilter qFilter = this.createQFilterForSearchPkId();
        Set<String> selectField = this.createSelectFieldForSearchPkId();
        this.executeSQL(qFilter, selectField, (Consumer<DataSet>)((Consumer)this::fillPkIdsByDataSet));
    }

    @Override
    protected void initForSingleBatch(IFormView formView, MetadataContext metadataContext, ResultContext resultContext) {
        super.initForSingleBatch(formView, metadataContext, resultContext);
        this.fieldAndValsOfSqlWhere = null;
    }

    private boolean canFillPk() {
        return !"new".equals(this.metadataContext.getImportType()) && (this.metadataContext.getImportType() != null || this.metadataContext.getKeyFields() != null);
    }

    private QFilter createQFilterForSearchPkId() {
        Set<String> fieldsOfSqlWhere = this.buildFieldForQFilter();
        this.fieldAndValsOfSqlWhere = this.buildFieldAndValsForQFilter(fieldsOfSqlWhere);
        this.validateKeyFieldsInExcel(this.fieldAndValsOfSqlWhere.keySet());
        return this.convertQFilterForSearchPkId();
    }

    private Set<String> buildFieldForQFilter() {
        Optional<Set<String>> optional = this.buildFieldForQFilterIfNoKeyField();
        return optional.orElseGet(() -> Arrays.stream(this.metadataContext.getKeyFields().split(",")).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    private Optional<Set<String>> buildFieldForQFilterIfNoKeyField() {
        if (StringUtils.isBlank((CharSequence)this.metadataContext.getKeyFields())) {
            BillEntityType entityType = (BillEntityType)this.formView.getModel().getDataEntityType();
            LinkedHashSet<String> fieldKeys = new LinkedHashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)entityType.getMainOrg())) {
                fieldKeys.add(entityType.getMainOrg());
            }
            if (StringUtils.isNotBlank((CharSequence)entityType.getBillNo())) {
                fieldKeys.add(entityType.getBillNo());
            }
            if (StringUtils.isNotBlank((CharSequence)entityType.getBillStatus())) {
                fieldKeys.add(entityType.getBillStatus());
            }
            return Optional.of(fieldKeys);
        }
        return Optional.empty();
    }

    private void validateKeyFieldsInExcel(Set<String> updateKeyFields) {
        if (CollectionUtils.isEmpty(updateKeyFields)) {
            return;
        }
        List<ImportBillData> rowMappers = this.metadataContext.getImportBillDatas();
        if (CollectionUtils.isEmpty(rowMappers)) {
            return;
        }
        Set excelColumnFields = (Set)this.metadataContext.getRequestData().get("colIds");
        if (!this.validateKeyFieldsInExcel(updateKeyFields, excelColumnFields) && !this.validateKeyFieldsInExcel(updateKeyFields, rowMappers.get(0).getSourceObj().keySet())) {
            String errMsg = ResManager.loadKDString((String)"\u6839\u636e\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\uff0c\u5339\u914d\u4e0d\u5230\u6570\u636e\uff0c\u53ef\u80fd\u662f\u6a21\u677f\u4e2d\u6ca1\u6709\u8be5\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6\u6216\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c", (String)"ImportDataSave_14", (String)BOS_IMPORT, (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
    }

    private boolean validateKeyFieldsInExcel(Set<String> updateKeyFields, Set<String> excelColumnFields) {
        for (String updateKeyField : updateKeyFields) {
            String[] updateKeySplit = updateKeyField.split("\\.");
            String master = updateKeySplit[0];
            if (excelColumnFields.contains(master)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Set<Object>> buildFieldAndValsForQFilter(Set<String> fieldsOfSqlWhere) {
        LinkedHashMap<String, Set<Object>> params = new LinkedHashMap<String, Set<Object>>();
        for (ImportBillData rowMapper : this.metadataContext.getImportBillDatas()) {
            for (String field : fieldsOfSqlWhere) {
                if (StringUtils.isBlank((CharSequence)field)) continue;
                Object propertyVal = this.getPropertyVal(rowMapper, field);
                String rebuildField = this.tryRebuildFieldForQFilter(rowMapper, field);
                params.computeIfAbsent(rebuildField, s -> new HashSet()).add(propertyVal);
                rowMapper.addConditionForSearchPk(rebuildField, propertyVal);
            }
        }
        return params;
    }

    private QFilter convertQFilterForSearchPkId() {
        QFilter filter = null;
        for (Map.Entry<String, Set<Object>> entry : this.fieldAndValsOfSqlWhere.entrySet()) {
            String fieldKey = entry.getKey();
            Set<Object> fieldValues = entry.getValue();
            if (filter == null) {
                filter = new QFilter(fieldKey, "in", fieldValues);
                continue;
            }
            filter.and(fieldKey, "in", fieldValues);
        }
        if (filter == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6267\u884c\u5185\u7801\u586b\u5145\u65f6\uff0c\u672a\u68c0\u6d4b\u5230\u5339\u914d\u6761\u4ef6\uff01", (String)"SearchAndFillPkIdProcess_1", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        return filter;
    }

    private Object getPropertyVal(ImportBillData rowMapper, String field) {
        BillEntityType entityType = (BillEntityType)this.formView.getModel().getDataEntityType();
        DynamicProperty property = entityType.getProperty(field);
        Object propertyVal = rowMapper.getSourceObj().get(field);
        Optional<Object> defaultPropertyVal = this.tryGetDefaultPropertyValIfNotFindPropertyVal(propertyVal, property);
        if (defaultPropertyVal.isPresent()) {
            return defaultPropertyVal.get();
        }
        if (propertyVal == null) {
            return propertyVal;
        }
        Optional<Object> formatPropertyVal = this.tryGetFormatPropertyVal(propertyVal, property, field);
        if (formatPropertyVal.isPresent()) {
            return formatPropertyVal.get();
        }
        return propertyVal;
    }

    private Optional<Object> tryGetDefaultPropertyValIfNotFindPropertyVal(Object propertyVal, DynamicProperty property) {
        if (property == null) {
            return Optional.empty();
        }
        if (propertyVal == null && property instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)property;
            PKFieldProp basedatePk = (PKFieldProp)basedataProp.getDynamicComplexPropertyType().getPrimaryKey();
            return Optional.ofNullable(basedatePk.getDefValue());
        }
        if (propertyVal != null && property instanceof BasedataProp) {
            Map basedataMap = (Map)propertyVal;
            String dataType = this.getBasedataPropertyForQFilter(basedataMap);
            return Optional.ofNullable(basedataMap.get(dataType));
        }
        if (propertyVal != null && property instanceof RefBillProp) {
            Map refdataMap = (Map)propertyVal;
            String dataType = this.getBasedataPropertyForQFilter(refdataMap);
            return Optional.ofNullable(refdataMap.get(dataType));
        }
        if (propertyVal == null) {
            return Optional.ofNullable(property.getDefaultValue());
        }
        return Optional.empty();
    }

    private Optional<Object> tryGetFormatPropertyVal(Object propertyVal, DynamicProperty property, String field) {
        if (property instanceof MuliLangTextProp) {
            return Optional.of(LocaleString.fromMap((Map)((Map)propertyVal)).toString());
        }
        if (property instanceof DateTimeProp && !(propertyVal instanceof Date)) {
            try {
                return Optional.of(((DateTimeProp)property).getDateFormat(String.valueOf(propertyVal)).parse(propertyVal.toString()));
            }
            catch (ParseException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ApiDateTimePropConverter_0", (String)BOS_IMPORT, (Object[])new Object[0]), property.getDisplayName(), propertyVal));
            }
        }
        if (property instanceof TimeProp) {
            return Optional.of(TimeProp.timeToSecond((Object)propertyVal.toString(), (String)field));
        }
        if (property instanceof DecimalProp && propertyVal instanceof String) {
            try {
                return Optional.of(new BigDecimal(new BigDecimal((String)propertyVal).stripTrailingZeros().toPlainString()));
            }
            catch (NumberFormatException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u503c\u5b57\u6bb5\u201c%1$s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a%2$s", (String)"DecimalProp_1", (String)BOS_IMPORT, (Object[])new Object[0]), property.getDisplayName(), propertyVal));
            }
        }
        return Optional.empty();
    }

    private String tryRebuildFieldForQFilter(ImportBillData rowMapper, String field) {
        BillEntityType entityType = (BillEntityType)this.formView.getModel().getDataEntityType();
        DynamicProperty property = entityType.getProperty(field);
        Object propertyVal = rowMapper.getSourceObj().get(field);
        if (propertyVal != null && (property instanceof BasedataProp || property instanceof RefBillProp)) {
            String dataType = this.getBasedataPropertyForQFilter((Map)propertyVal);
            field = field + "." + dataType;
        }
        return field;
    }

    private String getBasedataPropertyForQFilter(Map<String, Object> basedataMap) {
        if (basedataMap.containsKey("id")) {
            return "id";
        }
        if (basedataMap.containsKey(IMPORTPROP)) {
            return (String)basedataMap.get(IMPORTPROP);
        }
        if (basedataMap.containsKey(NUMBER)) {
            return NUMBER;
        }
        return NAME;
    }

    private Set<String> createSelectFieldForSearchPkId() {
        HashSet<String> selectField = new HashSet<String>(this.fieldAndValsOfSqlWhere.keySet());
        this.getOrgProp().ifPresent(orgProp -> selectField.add("createorg"));
        this.getMasterIdKey().ifPresent(selectField::add);
        return selectField;
    }

    private Optional<OrgProp> getOrgProp() {
        BasedataEntityType basedataEntityType;
        DynamicProperty orgProp;
        BillEntityType billEntityType = (BillEntityType)this.formView.getModel().getDataEntityType();
        if (billEntityType instanceof BasedataEntityType && (orgProp = (basedataEntityType = (BasedataEntityType)billEntityType).getProperty("createorg")) instanceof OrgProp && StringUtils.isNotBlank((CharSequence)orgProp.getAlias())) {
            return Optional.of((OrgProp)orgProp);
        }
        return Optional.empty();
    }

    private Optional<String> getMasterIdKey() {
        BasedataEntityType basedataEntityType;
        BillEntityType billEntityType = (BillEntityType)this.formView.getModel().getDataEntityType();
        if (billEntityType instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(basedataEntityType = (BasedataEntityType)billEntityType).getMasteridPropName())) {
            return Optional.of(basedataEntityType.getMasteridPropName());
        }
        return Optional.empty();
    }

    private void executeSQL(QFilter qFilter, Set<String> selectFields, Consumer<DataSet> consumer) {
        String selectStr = String.join((CharSequence)",", selectFields);
        if (!selectFields.contains("id")) {
            selectStr = "id," + selectStr;
        }
        String entityName = this.formView.getModel().getDataEntityType().getName();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)("importdata." + entityName), (String)entityName, (String)selectStr, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            consumer.accept((Object)dataSet);
        }
    }

    private void fillPkIdsByDataSet(DataSet dataSet) {
        List<KeyParam> keyParams = this.buildKeyParamsByDataSet(dataSet, this.fieldAndValsOfSqlWhere.keySet());
        Map<String, Set<KeyParam>> keyParamsMap = this.convertKeyParams(keyParams);
        for (ImportBillData rowMapper : this.metadataContext.getImportBillDatas()) {
            String queryKey = JSON.toJSONString(rowMapper.getConditionForSearchPk());
            Set<KeyParam> keyParamsByKey = keyParamsMap.get(queryKey);
            if (CollectionUtils.isEmpty(keyParamsByKey) || this.tryFillPkidsToBasedata(keyParamsByKey, rowMapper)) continue;
            if (keyParamsByKey.size() == 1) {
                rowMapper.getSourceObj().put("id", keyParamsByKey.iterator().next().id);
                continue;
            }
            if (keyParamsByKey.size() <= 1) continue;
            StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u6839\u636e\u5339\u914d\u5b57\u6bb5\u5339\u914d\u5230\u4e86\u591a\u6761\u6570\u636e\uff0c\u5185\u7801\u5206\u522b\u4e3a\uff1a", (String)"ImportDataSave_3", (String)BOS_IMPORT, (Object[])new Object[0]));
            int idTipCount = 0;
            int idTipCountMax = 3;
            for (KeyParam keyParam : keyParamsByKey) {
                if (idTipCount >= idTipCountMax) break;
                sb.append(keyParam.id);
                sb.append("\uff0c");
                ++idTipCount;
            }
            if (idTipCount > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (keyParamsByKey.size() > idTipCount) {
                sb.append('\u2026');
            }
            rowMapper.getSourceObj().put("id", null);
            rowMapper.getSourceObj().put("_errMsg_", sb.toString());
        }
    }

    private Map<String, Set<KeyParam>> convertKeyParams(List<KeyParam> keyParams) {
        LinkedHashMap<String, Set<KeyParam>> keyParamsMap = new LinkedHashMap<String, Set<KeyParam>>(keyParams.size());
        for (KeyParam keyParam : keyParams) {
            keyParamsMap.computeIfAbsent(keyParam.key, x -> new HashSet()).add(keyParam);
        }
        return keyParamsMap;
    }

    private List<KeyParam> buildKeyParamsByDataSet(DataSet dataSet, Set<String> allFields) {
        LinkedList<KeyParam> keyParams = new LinkedList<KeyParam>();
        for (Row row : dataSet) {
            KeyParam qk = new KeyParam();
            keyParams.add(qk);
            qk.id = row.get("id");
            HashMap<String, Object> keysObj = new HashMap<String, Object>(16);
            for (String field : allFields) {
                Object fieldVal = row.get(field);
                fieldVal = this.tryConvertVal(fieldVal);
                keysObj.put(field, fieldVal);
            }
            qk.key = JSON.toJSONString(keysObj);
            this.getOrgProp().ifPresent(orgProp -> {
                Object createOrgPkId = row.get(orgProp.getName());
                DynamicObject createOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)createOrgPkId, (DynamicObjectType)orgProp.getDynamicComplexPropertyType());
                if (createOrg != null) {
                    qk.createOrgNumber = createOrg.getString(orgProp.getNumberProp());
                    qk.createOrgName = createOrg.getString(NAME);
                }
            });
            this.getMasterIdKey().ifPresent(masterId -> qk.masterId = row.get(masterId));
        }
        return keyParams;
    }

    private Object tryConvertVal(Object fieldVal) {
        if (fieldVal instanceof BigDecimal) {
            fieldVal = new BigDecimal(((BigDecimal)fieldVal).stripTrailingZeros().toPlainString());
        }
        return fieldVal;
    }

    private boolean tryFillPkidsToBasedata(Set<KeyParam> keyParams, ImportBillData rowMapper) {
        BillEntityType billEntityType = (BillEntityType)this.formView.getModel().getDataEntityType();
        if (!(billEntityType instanceof BasedataEntityType)) {
            return false;
        }
        HashSet<Object> tempPks = new HashSet<Object>();
        int idTipCountMax = 3;
        this.getOrgProp().ifPresent(orgProp -> {
            Map createOrgMap = (Map)rowMapper.getSourceObj().get(orgProp.getName());
            if (createOrgMap == null) {
                return;
            }
            String dataType = this.getBasedataPropertyForCreateOrg(createOrgMap);
            Object val = createOrgMap.get(dataType);
            if (StringUtils.isBlank(val)) {
                return;
            }
            if (!CollectionUtils.isEmpty((Collection)keyParams)) {
                for (KeyParam keyParam : keyParams) {
                    if (tempPks.size() > idTipCountMax) break;
                    if (!val.equals(NUMBER.equals(dataType) ? keyParam.createOrgNumber : keyParam.createOrgName)) continue;
                    tempPks.add(keyParam.id);
                }
            }
        });
        boolean idFound = true;
        int idTipCount = 0;
        if (tempPks.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            if (!CollectionUtils.isEmpty(keyParams)) {
                for (KeyParam keyParam : keyParams) {
                    boolean add = false;
                    if (tempPks.size() > idTipCountMax) break;
                    if (!this.getMasterIdKey().isPresent()) {
                        if (keyParam.id.equals(keyParam.masterId) || StringUtils.isBlank((Object)keyParam.masterId)) {
                            add = tempPks.add(keyParam.id);
                        }
                    } else {
                        add = tempPks.add(keyParam.id);
                    }
                    if (!add || idTipCount >= idTipCountMax) continue;
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(keyParam.id);
                    ++idTipCount;
                }
            }
            if (tempPks.size() == 1) {
                rowMapper.getSourceObj().put("id", tempPks.iterator().next());
            } else if (tempPks.size() > 1) {
                if (tempPks.size() > idTipCount) {
                    sb.append('\u2026');
                }
                sb.insert(0, ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\uff1a", (String)"ImportDataSave_4", (String)BOS_IMPORT, (Object[])new Object[0]));
                rowMapper.getSourceObj().put("id", null);
                rowMapper.getSourceObj().put("_errMsg_", sb.toString());
            } else if (keyParams != null && !keyParams.isEmpty()) {
                sb.insert(0, ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e0d\u5408\u6cd5\uff1a", (String)"ImportDataSave_5", (String)BOS_IMPORT, (Object[])new Object[0]));
                rowMapper.getSourceObj().put("id", null);
                rowMapper.getSourceObj().put("_errMsg_", sb.toString());
            } else {
                idFound = false;
            }
        } else if (tempPks.size() == 1) {
            rowMapper.getSourceObj().put("id", tempPks.iterator().next());
        } else {
            StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\uff1a", (String)"ImportDataSave_4", (String)BOS_IMPORT, (Object[])new Object[0]));
            for (Object e : tempPks) {
                if (idTipCount >= idTipCountMax) break;
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(e);
                ++idTipCount;
            }
            if (tempPks.size() > idTipCount) {
                sb.append('\u2026');
            }
            rowMapper.getSourceObj().put("id", null);
            rowMapper.getSourceObj().put("_errMsg_", sb.toString());
        }
        return idFound;
    }

    private String getBasedataPropertyForCreateOrg(Map<String, Object> basedataMap) {
        if (basedataMap.containsKey(IMPORTPROP)) {
            return (String)basedataMap.get(IMPORTPROP);
        }
        if (basedataMap.containsKey(NUMBER)) {
            return NUMBER;
        }
        return NAME;
    }

    private static class KeyParam {
        private String key;
        private Object id;
        private Object masterId;
        private String createOrgNumber;
        private String createOrgName;

        private KeyParam() {
        }
    }
}

