/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.impt.basecache.ImportSourceObject;
import kd.bos.form.operate.imptapi.ApiFilter;
import kd.bos.form.operate.imptapi.ApiPropConvertSeq;
import kd.bos.form.operate.imptapi.ApiPropConverter;
import kd.bos.form.operate.imptapi.AssignmentIdResult;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.form.operate.webapi.BizBasedataPk;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.utils.ConvertResult;
import kd.bos.utils.ImportConvertUtils;
import kd.bos.utils.ImportFilterUtil;
import kd.bos.utils.ImportNameVersionHandler;

class ApiBasedataPropConverter
extends ApiPropConverter {
    protected static final String NUMBER = "number";
    private static final String ORG_NUMBER = "number";
    private static final String ORG_NAME = "name";
    protected static final String BOS_IMPORT = "bos-import";
    protected Map<BasedataItem, Set<String>> searchItems = new ConcurrentHashMap<BasedataItem, Set<String>>();
    protected Map<BasedataEntityType, Set<Object>> searchPKs = new ConcurrentHashMap<BasedataEntityType, Set<Object>>();

    ApiBasedataPropConverter() {
    }

    public BasedataProp getBasedataProp() {
        return (BasedataProp)this.getProp();
    }

    public BasedataEntityType getRefBDType(RowMapper row) {
        return (BasedataEntityType)((BasedataProp)this.getProp()).getComplexType();
    }

    public Map<BasedataItem, Set<String>> getSearchItems() {
        return this.searchItems;
    }

    public Map<BasedataEntityType, Set<Object>> getSearchPKs() {
        return this.searchPKs;
    }

    @Deprecated
    public Map<BasedataItem, Map<Object, DynamicObject>> getBaseObjs() {
        return new HashMap<BasedataItem, Map<Object, DynamicObject>>();
    }

    public String getUserOrgPropName() {
        if (this.getProp() instanceof IBasedataField) {
            return ((IBasedataField)this.getProp()).getOrgProp();
        }
        return null;
    }

    public Long getUseOrgId(RowMapper row) {
        Map mapVal;
        String useOrgPropKey = this.getUserOrgPropName();
        if (StringUtils.isBlank((CharSequence)useOrgPropKey)) {
            useOrgPropKey = this.getContext().getModel().getDataEntityType().getMainOrg();
        }
        if (StringUtils.isBlank((CharSequence)useOrgPropKey)) {
            return 0L;
        }
        if (StringUtils.equals((CharSequence)useOrgPropKey, (CharSequence)this.getContext().getModel().getDataEntityType().getMainOrg())) {
            return this.getContext().getMainOrgId();
        }
        Object orgVal = row.getValueFromSourceObj(useOrgPropKey, true);
        if (orgVal == null) {
            return 0L;
        }
        if (orgVal instanceof DynamicObject) {
            return (Long)((DynamicObject)orgVal).getPkValue();
        }
        if (orgVal instanceof Map && (mapVal = (Map)orgVal).containsKey("id")) {
            Object id = mapVal.get("id");
            if (id instanceof Long) {
                return (Long)id;
            }
            if (id != null) {
                return Long.valueOf(id.toString());
            }
        }
        return 0L;
    }

    public String getUseOrgNumber(RowMapper row) {
        Map mapVal;
        String useOrgPropKey = this.getUserOrgPropName();
        if (StringUtils.isBlank((CharSequence)useOrgPropKey)) {
            useOrgPropKey = this.getContext().getModel().getDataEntityType().getMainOrg();
        }
        if (StringUtils.isBlank((CharSequence)useOrgPropKey)) {
            return "";
        }
        if (StringUtils.equals((CharSequence)useOrgPropKey, (CharSequence)this.getContext().getModel().getDataEntityType().getMainOrg())) {
            return this.getContext().getMainOrgNumber();
        }
        Object orgVal = row.getValueFromSourceObj(useOrgPropKey, true);
        if (orgVal == null) {
            return "";
        }
        if (orgVal instanceof DynamicObject) {
            return (String)((DynamicObject)orgVal).get("number");
        }
        if (orgVal instanceof Map && (mapVal = (Map)orgVal).containsKey("number")) {
            Object number = mapVal.get("number");
            return String.valueOf(number);
        }
        return "";
    }

    @Override
    public int getConvertSeq() {
        return ApiPropConvertSeq.BasedataProp.getValue();
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        this.rowMapper = rowMapper;
        this.addSearchItem(rowMapper, value);
    }

    @Override
    public void endParseValue() {
        try {
            this.loadBasePKsFromDB();
            this.loadBaseObjsFromDB();
            this.searchItems.clear();
            this.searchPKs.clear();
        }
        catch (KDBizException bizException) {
            this.getContext().addErrorInfo(bizException.getMessage());
        }
    }

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object srcVal) {
        try {
            Object targetVal = this.convertWebApiValue(rowMapper, srcVal);
            if (targetVal == null || targetVal instanceof DynamicObject) {
                this.getContext().getModel().setFieldValueForWebApi(this.getProp(), activeRow, targetVal, this.getContext().isCheckImportable());
            }
        }
        catch (KDBizException bizException) {
            if (bizException.getErrorCode() != null && StringUtils.equals((CharSequence)"NOT_FOUND_VALUE", (CharSequence)bizException.getErrorCode().getCode())) {
                return;
            }
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), bizException.getMessage());
        }
    }

    protected BasedataItem buildBasedataItem(RowMapper rowMapper, Object val) {
        if (val == null || !(val instanceof Map)) {
            return null;
        }
        BasedataEntityType bdType = this.getRefBDType(rowMapper);
        if (bdType == null) {
            return null;
        }
        String searchKey = null;
        String searchValue = null;
        String dataType = "number";
        if (val instanceof Map) {
            Map map = (Map)val;
            if (map.containsKey("id")) {
                return null;
            }
            String importprop = (String)map.get("importprop");
            if (StringUtils.isBlank((CharSequence)importprop)) {
                importprop = map.containsKey("number") ? "number" : ORG_NAME;
                BasedataEntityType refPropType = this.getEntityType();
                dataType = this.convertDefaultImportProp(refPropType, importprop);
            } else {
                dataType = importprop;
            }
            searchValue = (String)map.get(importprop);
        }
        MasterBasedataProp masterIdProp = null;
        BasedataEntityType refMasterType = null;
        if (bdType.getMasteridType() == 2 && (masterIdProp = (MasterBasedataProp)bdType.findProperty(bdType.getMasteridPropName())) != null) {
            refMasterType = (BasedataEntityType)masterIdProp.getComplexType();
        }
        if (StringUtils.isBlank((CharSequence)(searchKey = refMasterType == null ? dataType : masterIdProp.getName() + "." + dataType))) {
            return null;
        }
        Long useOrgId = this.getUseOrgId(rowMapper);
        String controlVersionDate = ImportNameVersionHandler.getVersionControl(rowMapper.getTargetObj().getDataEntityType(), new ImportSourceObject(rowMapper.getSourceObj(), null));
        BasedataItem item = new BasedataItem(this.getProp().getName(), bdType.getName(), bdType, useOrgId, searchKey, searchValue, null, controlVersionDate);
        return item;
    }

    protected BasedataEntityType getEntityType() {
        return (BasedataEntityType)this.getBasedataProp().getComplexType();
    }

    protected String convertDefaultImportProp(BasedataEntityType refPropType, String importprop) {
        importprop = ORG_NAME.equals(importprop) ? refPropType.getNameProperty() : refPropType.getNumberProperty();
        return importprop;
    }

    protected void addSearchItem(RowMapper rowMapper, Object value) {
        if (this.addSerchId(rowMapper, value)) {
            return;
        }
        BasedataItem item = this.buildBasedataItem(rowMapper, value);
        if (item == null) {
            return;
        }
        if (this.getContext().getBasePKs().containsKey(item)) {
            return;
        }
        String searchValue = item.getSearchValue();
        item.setSearchValue(null);
        if (!this.getSearchItems().containsKey(item)) {
            HashSet searchValues = new HashSet();
            this.getSearchItems().put(item, searchValues);
        }
        this.getSearchItems().get(item).add(searchValue);
    }

    protected boolean addSerchId(RowMapper rowMapper, Object value) {
        Map map;
        if (!(value instanceof Map)) {
            return false;
        }
        Object id = null;
        if (value instanceof Map && StringUtils.isBlank(id = (Object)(map = (Map)value).get("id"))) {
            return false;
        }
        BasedataEntityType bdType = this.getRefBDType(rowMapper);
        if (bdType == null) {
            return false;
        }
        if (!this.getSearchPKs().containsKey(bdType)) {
            this.getSearchPKs().put(bdType, new HashSet());
        }
        this.getSearchPKs().get(bdType).add(id);
        return true;
    }

    private void loadBasePKsFromDB() {
        if (this.getSearchItems().isEmpty()) {
            return;
        }
        IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        ArrayList<Object> ids = new ArrayList<Object>(200);
        HashMap<BasedataItem, List<Object>> map = new HashMap<BasedataItem, List<Object>>(200);
        ArrayList<String> searchValues2 = new ArrayList<String>(200);
        HashMap<BasedataItem, Set<String>> tempSearchItems = new HashMap<BasedataItem, Set<String>>(this.getSearchItems());
        for (Map.Entry item : tempSearchItems.entrySet()) {
            BasedataItem basedataItem = (BasedataItem)item.getKey();
            Set searchValues = (Set)item.getValue();
            for (String searchValue : searchValues) {
                BasedataItem basedataItem2 = new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), searchValue, basedataItem.getBizTag(), basedataItem.getVersionControl());
                if (StringUtils.isBlank((CharSequence)searchValue)) {
                    this.getContext().getBasePKs().put(basedataItem2, null);
                    continue;
                }
                if (this.getContext().getBasePKs().containsKey(basedataItem2)) continue;
                searchValues2.add(searchValue);
            }
            if (searchValues2.isEmpty()) continue;
            this.queryBasePk(baseDataService, basedataItem, map, ids, searchValues2);
            searchValues2.clear();
            ids.clear();
            map.clear();
        }
    }

    private void queryBasePk(IBaseDataService baseDataService, BasedataItem basedataItem, Map<BasedataItem, List<Object>> searchResult, List<Object> ids, List<String> searchValues) {
        ApiFilter filters = this.buildBaseDataFilter(basedataItem, searchValues);
        Set bdIdsForOrg = null;
        Object orgFilter = null;
        if (orgFilter != null && StringUtils.equals((CharSequence)orgFilter.getProperty(), (CharSequence)"id") && StringUtils.equals((CharSequence)orgFilter.getCP(), (CharSequence)"in") && orgFilter.getValue() instanceof Set) {
            bdIdsForOrg = (Set)orgFilter.getValue();
            orgFilter = null;
        }
        if (orgFilter != null) {
            filters.getFilters().add(orgFilter);
            filters.getCommonfilterDesc().add(String.format(ResManager.loadKDString((String)"\u5728\u7f16\u7801=%s\u7684\u4f7f\u7528\u7ec4\u7ec7\u4e2d", (String)"ApiBasedataPropConverter_6", (String)BOS_IMPORT, (Object[])new Object[0]), this.getUseOrgNumber(this.rowMapper)));
        }
        Map<BasedataItem, Object> basePKs = this.getContext().getBasePKs();
        Map<BasedataItem, BizBasedataPk> bizBasePKs = this.getContext().getBizBasePKs();
        String fields = "id," + basedataItem.getSearchKey();
        DynamicObjectCollection objColl = baseDataService.queryBaseDataByDate(basedataItem.getEntityNumber(), basedataItem.getOrgId(), filters.toQFilter(), fields, ImportNameVersionHandler.parseVersionControlDate(basedataItem.getVersionControl()));
        HashSet<String> notExistValues = new HashSet<String>(searchValues);
        for (DynamicObject dynamicObject : objColl) {
            List<Object> curSearchResult;
            Object pkValue = dynamicObject.get("id");
            String searchValue = dynamicObject.getString(basedataItem.getSearchKey());
            if (bdIdsForOrg != null && !bdIdsForOrg.contains(pkValue)) continue;
            BasedataItem basedataItem2 = new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), searchValue, basedataItem.getBizTag(), basedataItem.getVersionControl());
            if (!searchResult.containsKey(basedataItem2)) {
                searchResult.put(basedataItem2, new ArrayList(4));
            }
            if ((curSearchResult = searchResult.get(basedataItem2)).contains(pkValue)) continue;
            curSearchResult.add(pkValue);
            notExistValues.remove(searchValue);
        }
        Iterator<Map.Entry<BasedataItem, List<Object>>> searchResultIterator = searchResult.entrySet().iterator();
        while (searchResultIterator.hasNext()) {
            Map.Entry<BasedataItem, List<Object>> entry = searchResultIterator.next();
            List pkIds = (List)entry.getValue();
            if (pkIds.size() != 1) continue;
            ids.add(pkIds.get(0));
            basePKs.put((BasedataItem)entry.getKey(), pkIds.get(0));
            searchResultIterator.remove();
        }
        for (String v : notExistValues) {
            BasedataItem basedataItem2 = new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), v, basedataItem.getBizTag(), basedataItem.getVersionControl());
            searchResult.put(basedataItem2, new ArrayList());
        }
        ModelEventProxy modelEventProxy = this.getContext().getModelEventProxy();
        if (modelEventProxy != null) {
            QueryImportBasedataEventArgs evt = new QueryImportBasedataEventArgs((Object)this.rowMapper, searchResult);
            modelEventProxy.fireQueryImportBasedata(evt);
        }
        for (Map.Entry<BasedataItem, List<Object>> item : searchResult.entrySet()) {
            List<Object> pkIds = item.getValue();
            if (pkIds == null) continue;
            if (pkIds.size() == 1) {
                bizBasePKs.put(item.getKey(), new BizBasedataPk(pkIds.get(0)));
                ids.add(pkIds.get(0));
                continue;
            }
            if (pkIds.size() > 1) {
                bizBasePKs.put(item.getKey(), new BizBasedataPk(pkIds, this.buildRepeatError(item, filters)));
                continue;
            }
            bizBasePKs.put(item.getKey(), new BizBasedataPk(pkIds, this.buildExistError(item, filters)));
        }
        if (!this.getSearchPKs().containsKey(basedataItem.getRefBDType())) {
            this.getSearchPKs().put(basedataItem.getRefBDType(), new HashSet(ids.size()));
        }
        this.getSearchPKs().get(basedataItem.getRefBDType()).addAll(ids);
    }

    private void loadBaseObjsFromDB() {
        if (this.getSearchPKs().isEmpty()) {
            return;
        }
        HashSet ids = new HashSet(1000);
        HashMap<BasedataEntityType, Set<Object>> tempSearchPKs = new HashMap<BasedataEntityType, Set<Object>>(this.getSearchPKs());
        for (Map.Entry item : tempSearchPKs.entrySet()) {
            BasedataEntityType bdType = (BasedataEntityType)item.getKey();
            Set pks = (Set)item.getValue();
            if (!this.getContext().getBaseObjs().containsKey(bdType.getName())) {
                ids.addAll(pks);
            } else {
                for (Object id : (Set)item.getValue()) {
                    if (this.getContext().getBaseObjs().get(bdType.getName()).containsKey(id)) continue;
                    ids.add(id);
                }
            }
            if (ids.isEmpty()) continue;
            ISimpleProperty primaryKey = bdType.getPrimaryKey();
            String disPlayName = this.getBaseDataPropDisplayName();
            ConvertResult convertResult = ImportConvertUtils.convertIds(Arrays.asList(ids.toArray()), primaryKey.getPropertyType(), disPlayName);
            if (StringUtils.isNotBlank((CharSequence)convertResult.getErrMsg())) {
                throw new KDBizException(convertResult.getErrMsg());
            }
            Map objs = BusinessDataReader.loadFromCache((Object[])convertResult.getIds().toArray(), (DynamicObjectType)bdType);
            if (!this.getContext().getBaseObjs().containsKey(bdType.getName())) {
                this.getContext().getBaseObjs().put(bdType.getName(), new HashMap(objs.size()));
            }
            this.getContext().getBaseObjs().get(bdType.getName()).putAll(objs);
            ids.clear();
        }
    }

    protected DynamicObject loadFromLocalCache(BasedataEntityType refBDType, Object id, int rowIndex) {
        String disPlayName = refBDType.getDisplayName() != null ? refBDType.getDisplayName().toString() : refBDType.getName();
        ConvertResult convertResult = ImportConvertUtils.convertId(id, refBDType.getPrimaryKey().getPropertyType(), disPlayName);
        String errMsg = convertResult.getErrMsg();
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            this.getContext().addErrorInfo(rowIndex, errMsg);
            return null;
        }
        Object pkId = this.getPKid(refBDType, id);
        if (this.getContext().getBaseObjs().containsKey(refBDType.getName()) && this.getContext().getBaseObjs().get(refBDType.getName()).containsKey(pkId)) {
            return this.getContext().getBaseObjs().get(refBDType.getName()).get(pkId);
        }
        if (this.getContext().existPkIdsWithOutInDB((MainEntityType)refBDType, pkId)) {
            return null;
        }
        Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{pkId}, (DynamicObjectType)refBDType);
        if (!this.getContext().getBaseObjs().containsKey(refBDType.getName())) {
            this.getContext().getBaseObjs().put(refBDType.getName(), new HashMap());
        }
        this.getContext().getBaseObjs().get(refBDType.getName()).putAll(objs);
        if (objs.containsKey(pkId)) {
            return (DynamicObject)objs.get(pkId);
        }
        this.getContext().recordPkIdsWithOutInDB((MainEntityType)refBDType, pkId);
        return null;
    }

    protected Object getPKid(BasedataEntityType refBDType, Object id) {
        return this.getBasedataProp().convertPKValueType((DynamicObjectType)refBDType, id);
    }

    protected ApiFilter buildBaseDataFilter(BasedataItem basedataItem, List<String> searchValues2) {
        ApiFilter apiFilter = new ApiFilter();
        StringBuilder sb = new StringBuilder();
        for (String value : searchValues2) {
            BasedataEntityType baseType = basedataItem.getRefBDType();
            BasedataItem item = this.rebulidBaseDataItem(basedataItem, value);
            sb.setLength(0);
            sb.append(this.getBaseDataPropDisplayName()).append('.');
            sb.append(this.getDisplayName((EntityType)baseType, basedataItem.getSearchKey()));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                sb.append('=').append(value);
            } else {
                sb.append(ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"ApiBasedataPropConverter_12", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
            apiFilter.getSearchName().put(item, this.getDisplayName((EntityType)baseType, basedataItem.getSearchKey()));
            apiFilter.getFilterDesc().put(item, sb.toString());
        }
        if (searchValues2.size() == 1) {
            apiFilter.getFilters().add(new QFilter(basedataItem.getSearchKey(), "=", (Object)searchValues2.get(0)));
        } else {
            apiFilter.getFilters().add(new QFilter(basedataItem.getSearchKey(), "in", searchValues2));
        }
        if (this.getContext().isCheckBasedataPerm()) {
            String formShowParameterAppId = this.getContext().getFormShowParameterAppId();
            IDataModel model = this.getContext().getModel();
            IDataEntityProperty baseProp = model.getProperty(basedataItem.getFieldKey());
            model.putContextVariable("APPID", (Object)formShowParameterAppId);
            List<QFilter> fieldFilters = this.getF7QFilter(baseProp, model, formShowParameterAppId, basedataItem);
            QFilter qfilter = this.getDataRuleFilter(basedataItem, model, formShowParameterAppId);
            if (qfilter != null) {
                fieldFilters.add(qfilter);
            }
            if (fieldFilters != null) {
                apiFilter.getFilters().addAll(fieldFilters);
            }
        }
        return apiFilter;
    }

    protected BasedataItem rebulidBaseDataItem(BasedataItem basedataItem, String searchValue) {
        return new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), searchValue, basedataItem.getBizTag(), basedataItem.getVersionControl());
    }

    protected List<QFilter> getF7QFilter(IDataEntityProperty baseProp, IDataModel model, String formShowParameterAppId, BasedataItem basedataItem) {
        return ImportFilterUtil.buildBaseDataF7QFilters((IBasedataField)baseProp, model, formShowParameterAppId, basedataItem.getEntityNumber(), new ArrayList<QFilter>(), "47150e89000000ac", true);
    }

    protected String getBaseDataPropDisplayName() {
        IDataEntityProperty prop = this.getProp();
        LocaleString displayName = prop.getDisplayName();
        if (displayName == null) {
            return prop.getName();
        }
        if (StringUtils.isNotBlank((CharSequence)displayName.toString())) {
            return displayName.toString();
        }
        return prop.getName();
    }

    protected QFilter getDataRuleFilter(BasedataItem basedataItem, IDataModel model, String appId) {
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        if (permissionService.hasEnableOldDataRule()) {
            return permissionService.getDataPermission(RequestContext.get().getCurrUserId(), appId, basedataItem.getEntityNumber());
        }
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(basedataItem.getOrgId());
        return permissionService.getDataRuleForBdProp(RequestContext.get().getCurrUserId(), appId, (IDataEntityType)model.getDataEntityType(), basedataItem.getFieldKey(), "4730fc9f000003ae", orgIdList, new HashMap());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object convertWebApiValue(RowMapper rowMapper, Object srcVal) {
        BasedataItem basedataItem;
        DynamicObject obj;
        Object id;
        block15: {
            if (srcVal == null || !(srcVal instanceof Map)) {
                return srcVal;
            }
            id = null;
            obj = null;
            basedataItem = this.bulidItem(rowMapper, srcVal);
            if (basedataItem == null) {
                if (srcVal instanceof Map && ((Map)srcVal).containsKey("id")) {
                    id = ((Map)srcVal).get("id");
                    break block15;
                } else {
                    String basedataEntityNum = (String)rowMapper.getValueFromSourceObj(((ItemClassProp)this.getProp()).getTypePropName(), false);
                    if (basedataEntityNum == null) {
                        return null;
                    }
                    String errMsg = ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u4f20\u5165\u5408\u6cd5\u503c\uff0c\u8bf7\u4f20\u5165id\u3001number\u6216name", (String)"ApiBasedataPropConverter_1", (String)BOS_IMPORT, (Object[])new Object[0]);
                    this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(errMsg, this.getProp().getDisplayName().toString()));
                    return null;
                }
            }
            if (this.isContainsItem(basedataItem)) {
                id = this.getPKFromItem(basedataItem);
            } else {
                String oldFieldKey = null;
                if (StringUtils.equalsIgnoreCase((CharSequence)basedataItem.getEntityNumber(), (CharSequence)this.getContext().getModel().getDataEntityType().getName())) {
                    oldFieldKey = basedataItem.getFieldKey();
                    basedataItem.setFieldKey(this.getContext().getModel().getDataEntityType().getName());
                    Boolean isRefSelf = this.isRefSelf(rowMapper, basedataItem);
                    if (isRefSelf.booleanValue()) {
                        String displayName = this.getDisplayName((EntityType)this.getContext().getModel().getDataEntityType(), oldFieldKey);
                        String errMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b57\u6bb5\uff0c\u7f16\u7801=\u201c%2$s\u201d\uff0c\u5bfc\u5165\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u5f53\u524d\u6b63\u5728\u5bfc\u5165\u7684\u57fa\u7840\u8d44\u6599\u7f16\u7801", (String)"ApiBasedataPropConverter_17", (String)BOS_IMPORT, (Object[])new Object[0]), displayName, basedataItem.getSearchValue());
                        this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(errMsg, this.getProp().getDisplayName().toString()));
                        throw new KDBizException(new ErrorCode("NOT_FOUND_VALUE", ""), new Object[0]);
                    }
                    if (this.getContext().getBasePKs().containsKey(basedataItem)) {
                        id = this.getContext().getBasePKs().get(basedataItem);
                    }
                }
                if (id == null) {
                    AssignmentIdResult assignmentIdResult = this.assignmentId(rowMapper, null, basedataItem, oldFieldKey);
                    if (assignmentIdResult.isContainsError()) {
                        throw new KDBizException(new ErrorCode("NOT_FOUND_VALUE", ""), new Object[0]);
                    }
                    id = assignmentIdResult.getId();
                }
            }
        }
        BasedataEntityType bdType = null;
        bdType = basedataItem == null ? this.getRefBDType(rowMapper) : basedataItem.getRefBDType();
        if (id != null) {
            obj = this.loadFromLocalCache(bdType, id, rowMapper.getExcelRowIndex());
        }
        if (obj != null) {
            return obj;
        }
        if (id != null && StringUtils.isBlank((CharSequence)ImportConvertUtils.convertId(id, bdType.getPrimaryKey().getPropertyType(), bdType.getName()).getErrMsg())) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"%1$s\u7684\u5185\u7801\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ApiBasedataPropConverter_15", (String)BOS_IMPORT, (Object[])new Object[0]), this.getProp().getDisplayName(), id));
        }
        return id;
    }

    protected BasedataItem bulidItem(RowMapper rowMapper, Object srcVal) {
        return this.buildBasedataItem(rowMapper, srcVal);
    }

    protected boolean isContainsItem(BasedataItem basedataItem) {
        return this.getContext().getBasePKs().containsKey(basedataItem);
    }

    protected Object getPKFromItem(BasedataItem basedataItem) {
        return this.getContext().getBasePKs().get(basedataItem);
    }

    protected AssignmentIdResult assignmentId(RowMapper rowMapper, Object id, BasedataItem basedataItem, String oldFieldKey) {
        boolean isContainsError = false;
        BizBasedataPk bizPk = this.getContext().getBizBasePKs().get(basedataItem);
        if (bizPk == null && oldFieldKey != null) {
            basedataItem.setFieldKey(oldFieldKey);
            bizPk = this.getContext().getBizBasePKs().get(basedataItem);
        }
        if (bizPk != null) {
            if (bizPk.getError() == null) {
                id = bizPk.getPk();
            } else {
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), bizPk.getError());
                isContainsError = true;
            }
        }
        return new AssignmentIdResult(id, isContainsError);
    }

    protected Boolean isRefSelf(RowMapper rowMapper, BasedataItem basedataItem) {
        String searchKey = basedataItem.getSearchKey();
        Object currentVal = this.getSearchValue(searchKey, rowMapper);
        String searchValue = basedataItem.getSearchValue();
        if (StringUtils.isNotEmpty((CharSequence)searchKey) && currentVal != null && StringUtils.isNotEmpty((CharSequence)searchKey)) {
            return currentVal.toString().equals(searchValue);
        }
        return Boolean.FALSE;
    }

    private Object getSearchValue(String searchKey, RowMapper rowMapper) {
        if (rowMapper != null && rowMapper.getSourceObj() != null) {
            Object currentVal = rowMapper.getSourceObj().get(searchKey);
            if (currentVal != null) {
                return currentVal;
            }
            this.getSearchValue(searchKey, rowMapper.getParent());
        }
        return null;
    }

    private String buildRepeatError(Map.Entry<BasedataItem, List<Object>> searchResult, ApiFilter filters) {
        StringBuilder sb = new StringBuilder();
        BasedataItem item = searchResult.getKey();
        sb.append("\u201c");
        sb.append(filters.getFilterDesc().get(item));
        sb.append("\u201d");
        for (String msg : filters.getCommonfilterDesc()) {
            sb.append('\uff0c').append(msg);
        }
        sb.append('\uff0c').append(ResManager.loadKDString((String)"\u7b26\u5408\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6", (String)"ApiBasedataPropConverter_7", (String)BOS_IMPORT, (Object[])new Object[0]));
        String displayName = this.getDisplayName((EntityType)this.getContext().getModel().getDataEntityType(), item.getFieldKey());
        return String.format(ResManager.loadKDString((String)"%1$s\u7684\u201c%2$s\u201d\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230\u91cd\u590d\u7684\u201c%3$s\u201d\uff0c\u91cd\u590d\u7684\u5185\u7801\u4e3a\uff1a%4$s\u3002", (String)"ApiBasedataPropConverter_18", (String)BOS_IMPORT, (Object[])new Object[0]), sb, displayName, displayName, searchResult.getValue().size() > 3 ? searchResult.getValue().subList(0, 3) + "\u2026\u2026" : searchResult.getValue());
    }

    private String getUseOrgPropNameOrDefault() {
        String useOrgPropKey = this.getUserOrgPropName();
        if (StringUtils.isBlank((CharSequence)useOrgPropKey)) {
            useOrgPropKey = this.getContext().getModel().getDataEntityType().getMainOrg();
        }
        return useOrgPropKey;
    }

    protected String getDisplayName(EntityType entityType, String propKey) {
        if ("id".equals(propKey)) {
            return ResManager.loadKDString((String)"\u5185\u7801", (String)"ApiBasedataPropConverter_13", (String)BOS_IMPORT, (Object[])new Object[0]);
        }
        if ("pid".equals(propKey)) {
            return ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ApiBasedataPropConverter_14", (String)BOS_IMPORT, (Object[])new Object[0]);
        }
        IDataEntityProperty prop = EntityTypeUtil.getDataEntityProperty((String)propKey, (EntityType)entityType, (boolean)false);
        if (prop == null) {
            return propKey;
        }
        LocaleString displayName = prop.getDisplayName();
        return displayName != null && StringUtils.isNotBlank((CharSequence)displayName.toString()) ? displayName.toString() : propKey;
    }

    private String buildExistError(Map.Entry<BasedataItem, List<Object>> searchResult, ApiFilter filters) {
        BasedataItem item = searchResult.getKey();
        StringBuilder errorMsg = new StringBuilder();
        String bdName = this.getDisplayName((EntityType)this.getContext().getModel().getDataEntityType(), item.getFieldKey());
        String filterDesc = filters.getFilterDesc().get(item);
        String searchName = filters.getSearchName().get(item);
        errorMsg.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u65f6\u627e\u4e0d\u5230%1$s\u7684%2$s\u3002", (String)"BasedataPropCache_4", (String)BOS_IMPORT, (Object[])new Object[0]), filterDesc, bdName));
        return errorMsg.toString();
    }
}

