/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.operate.imptapi.ApiPropConvertItem;
import kd.bos.form.operate.imptapi.ApiPropConvertSeq;
import kd.bos.form.operate.imptapi.ApiPropConverter;
import kd.bos.form.operate.imptapi.EntyRowMatchStyle;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.form.plugin.importentry.model.ImportEntryTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

class ApiEntryPropConverter
extends ApiPropConverter {
    private static final String KEY_ENTRYID = "id";
    private static final String KEY_ENTRYROWINDEX = "rk";
    private static final String BOS_IMPORT = "bos-import";

    ApiEntryPropConverter() {
    }

    public EntryProp getEntryProp() {
        return (EntryProp)super.getProp();
    }

    public EntryType getEntryType() {
        return (EntryType)this.getEntryProp().getItemType();
    }

    @Override
    public int getConvertSeq() {
        return ApiPropConvertSeq.EntryProp.getValue();
    }

    @Override
    public void setValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        if (value == null) {
            return;
        }
        if (!this.hasFieldWriteControl()) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u65e0\u5b57\u6bb5\u5bfc\u5165\u6743\u9650\u3002", (String)"ApiPropConverter_0", (String)BOS_IMPORT, (Object[])new Object[0]), this.getProp().getDisplayName().toString()));
            return;
        }
        this.execSetValue(rowMapper, activeRow, value);
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        List<RowMapper> mappers = this.buildSubRowMapper(rowMapper, value, Boolean.TRUE);
        if (mappers == null || mappers.isEmpty()) {
            return;
        }
        for (RowMapper subRowMapper : mappers) {
            this.getContext().getModel().setEntryCurrentRowIndex(this.getProp().getName(), subRowMapper.getRowIndex());
            List<ApiPropConvertItem> fieldItems = this.getContext().sortPropConverters((EntityType)this.getEntryType(), subRowMapper.getSourceObj());
            for (ApiPropConvertItem fieldItem : fieldItems) {
                fieldItem.getPropConverter().beginParseValue(subRowMapper, fieldItem.getValue());
            }
        }
    }

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        List<RowMapper> mappers = this.buildSubRowMapper(rowMapper, value, false);
        if (mappers == null || mappers.isEmpty()) {
            return;
        }
        for (RowMapper subRowMapper : mappers) {
            this.getContext().getModel().setEntryCurrentRowIndex(this.getProp().getName(), subRowMapper.getRowIndex());
            List<ApiPropConvertItem> fieldItems = this.getContext().sortPropConverters((EntityType)this.getEntryType(), subRowMapper.getSourceObj());
            for (ApiPropConvertItem fieldItem : fieldItems) {
                fieldItem.getPropConverter().setValue(subRowMapper, subRowMapper.getTargetObj(), fieldItem.getValue());
            }
        }
    }

    private List<RowMapper> buildSubRowMapper(RowMapper rowMapper, Object value, Boolean isCreateRow) {
        List<Object> mappers = new ArrayList();
        List sourceRows = (List)value;
        EntryType entity = this.getEntryType();
        mappers = !this.getContext().isModify() || this.getContext().getEntyRowMatchStyle() == EntyRowMatchStyle.Postion ? this.getEntryRowMapByPostion(entity, sourceRows, rowMapper) : (this.getContext().getEntyRowMatchStyle() == EntyRowMatchStyle.PrimaryKey ? this.getEntryRowMapByPrimaryKey(entity, sourceRows, rowMapper) : (this.getContext().getEntyRowMatchStyle() == EntyRowMatchStyle.OnlyEntry ? this.getEntryRowMapForOnlyEntry(entity, sourceRows, rowMapper, isCreateRow) : this.getEntryRowMapBySeq(entity, sourceRows, rowMapper)));
        return mappers;
    }

    private List<RowMapper> getEntryRowMapByPrimaryKey(EntryType entity, List<Map<String, Object>> sourceRows, RowMapper parent) {
        boolean isNullParentPk;
        IDataModel model = this.getContext().getModel();
        model.setEntryCurrentRowIndex(parent.getTargetObj().getDataEntityType().getName(), parent.getRowIndex());
        DynamicObjectCollection targetRows = model.getEntryEntity(entity.getName());
        HashMap<String, DynamicObject> entryRows = new HashMap<String, DynamicObject>();
        HashMap<String, Integer> entryRowIndex = new HashMap<String, Integer>();
        Object parentPk = parent.getTargetObj().getPkValue();
        boolean bl = parentPk instanceof Long ? 0L == (Long)parentPk : (isNullParentPk = StringUtils.isBlank((Object)parentPk));
        if (!isNullParentPk) {
            DynamicObject row = null;
            int size = targetRows.size();
            for (int i = 0; i < size; ++i) {
                row = (DynamicObject)targetRows.get(i);
                entryRows.put(row.get(KEY_ENTRYID).toString(), row);
                entryRowIndex.put(row.get(KEY_ENTRYID).toString(), i);
            }
        }
        boolean errorOccur = false;
        ArrayList<RowMapper> mappers = new ArrayList<RowMapper>(sourceRows.size());
        ArrayList<Integer> newRowIndexes = new ArrayList<Integer>();
        HashMap<Object, Integer> pkSet = new HashMap<Object, Integer>();
        for (int i = 0; i < sourceRows.size(); ++i) {
            Map<String, Object> row = sourceRows.get(i);
            Object pk = row.get(KEY_ENTRYID);
            if (row.containsKey(KEY_ENTRYROWINDEX)) {
                int rk = (Integer)row.get(KEY_ENTRYROWINDEX);
                mappers.add(new RowMapper(row, (DynamicObject)targetRows.get(rk), parent, rk));
            } else if (StringUtils.isBlank((Object)pk) || isNullParentPk) {
                newRowIndexes.add(i);
            } else if (entryRowIndex.get(pk.toString()) == null) {
                this.addPkNotExistError(parent, entity, row, pk, i);
                errorOccur = true;
            } else {
                mappers.add(new RowMapper(sourceRows.get(i), (DynamicObject)entryRows.get(pk.toString()), parent, (Integer)entryRowIndex.get(pk.toString()) + targetRows.getStartRowIndex()));
            }
            if (!StringUtils.isNotBlank((Object)pk)) continue;
            Object r = pkSet.get(pk);
            if (r != null) {
                this.addPkRepeatError(parent, entity, row, pk, r, i);
                errorOccur = true;
            }
            pkSet.put(pk, (Integer)row.getOrDefault("rowNum", i) + 1);
        }
        if (errorOccur) {
            return null;
        }
        if (!newRowIndexes.isEmpty()) {
            if (isNullParentPk) {
                model.deleteEntryData(entity.getName());
            }
            int[] newRows = model.batchCreateNewEntryRow(entity.getName(), newRowIndexes.size());
            int targetStartRk = targetRows.size() - newRowIndexes.size();
            for (int i = 0; i < newRowIndexes.size(); ++i) {
                Map<String, Object> row = sourceRows.get((Integer)newRowIndexes.get(i));
                row.put(KEY_ENTRYROWINDEX, targetStartRk + i);
                mappers.add(new RowMapper(row, (DynamicObject)targetRows.get(targetStartRk + i), parent, newRows[i]));
            }
        }
        return mappers;
    }

    private void addPkRepeatError(RowMapper parent, EntryType entity, Map<String, Object> row, Object pk, Object r, int i) {
        if (row.containsKey("rowNum")) {
            this.getContext().addErrorInfo((Integer)row.get("rowNum"), String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u5185\u7801\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\uff1aid=%3$s", (String)"ApiEntryPropConverter_3", (String)BOS_IMPORT, (Object[])new Object[0]), entity.getDisplayName(), r, pk));
        } else {
            String entryMsg = ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u7b2c%2$s\u884c\u7684", (String)"ApiEntryPropConverter_5", (String)BOS_IMPORT, (Object[])new Object[0]);
            String subentryMsg = ResManager.loadKDString((String)"\u5b50\u5206\u5f55%1$s\u7684\u7b2c%2$s\u884c\u7684", (String)"ApiEntryPropConverter_6", (String)BOS_IMPORT, (Object[])new Object[0]);
            String msg = String.format(ResManager.loadKDString((String)"\u5185\u7801\u4e0e\u7b2c%1$s\u884c\u91cd\u590d\uff1aid=%2$s", (String)"ApiEntryPropConverter_1", (String)BOS_IMPORT, (Object[])new Object[0]), r, pk);
            msg = this.getEntryProp() instanceof SubEntryProp ? String.format(entryMsg, entity.getParent().getDisplayName(), parent.getRowIndex()) + String.format(subentryMsg, entity.getDisplayName(), i + 1) + msg : String.format(entryMsg, entity.getDisplayName(), i + 1) + msg;
            this.getContext().addErrorInfo(msg);
        }
    }

    private void addPkNotExistError(RowMapper parent, EntryType entity, Map<String, Object> row, Object pk, int i) {
        if (row.containsKey("rowNum")) {
            this.getContext().addErrorInfo((Integer)row.get("rowNum"), String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u5185\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff1aid=%2$s", (String)"ApiEntryPropConverter_4", (String)BOS_IMPORT, (Object[])new Object[0]), entity.getDisplayName(), pk));
        } else {
            String entryMsg = ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u7b2c%2$s\u884c\u7684", (String)"ApiEntryPropConverter_5", (String)BOS_IMPORT, (Object[])new Object[0]);
            String subentryMsg = ResManager.loadKDString((String)"\u5b50\u5206\u5f55%1$s\u7684\u7b2c%2$s\u884c\u7684", (String)"ApiEntryPropConverter_6", (String)BOS_IMPORT, (Object[])new Object[0]);
            String msg = String.format(ResManager.loadKDString((String)"\u5185\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff1aid=%s", (String)"ApiEntryPropConverter_0", (String)BOS_IMPORT, (Object[])new Object[0]), pk);
            msg = this.getEntryProp() instanceof SubEntryProp ? String.format(entryMsg, entity.getParent().getDisplayName(), parent.getRowIndex()) + String.format(subentryMsg, entity.getDisplayName(), i + 1) + msg : String.format(entryMsg, entity.getDisplayName(), i + 1) + msg;
            this.getContext().addErrorInfo(msg);
        }
    }

    private List<RowMapper> getEntryRowMapBySeq(EntryType entity, List<Map<String, Object>> sourceRows, RowMapper parent) {
        return this.getEntryRowMapByPrimaryKey(entity, sourceRows, parent);
    }

    private List<RowMapper> getEntryRowMapByPostion(EntryType entity, List<Map<String, Object>> sourceRows, RowMapper parent) {
        this.getContext().getModel().deleteEntryData(entity.getName());
        if (sourceRows.size() > 0) {
            this.getContext().getModel().batchCreateNewEntryRow(entity.getName(), sourceRows.size() + 1);
            this.getContext().getModel().deleteEntryRow(entity.getName(), 0);
        }
        DynamicObjectCollection targetRows = this.getContext().getModel().getEntryEntity(entity.getName());
        ArrayList<RowMapper> mappers = new ArrayList<RowMapper>(sourceRows.size());
        for (int i = 0; i < sourceRows.size(); ++i) {
            RowMapper rowMapper = new RowMapper(sourceRows.get(i), (DynamicObject)targetRows.get(i), parent, i + targetRows.getStartRowIndex());
            mappers.add(rowMapper);
        }
        return mappers;
    }

    private List<RowMapper> getEntryRowMapForOnlyEntry(EntryType entity, List<Map<String, Object>> sourceRows, RowMapper parent, Boolean isCreateRow) {
        int i;
        ArrayList<Map<String, Object>> insertRows = new ArrayList<Map<String, Object>>(sourceRows);
        ArrayList<Map<String, Object>> updateRows = new ArrayList<Map<String, Object>>();
        HashMap<Object, DynamicObject> updateData = new HashMap<Object, DynamicObject>();
        this.divideSourceRows(entity, sourceRows, parent, insertRows, updateRows, updateData);
        int startEntryRow = 0;
        int totalRowSize = insertRows.size() + updateRows.size();
        if (totalRowSize > 0) {
            if (isCreateRow.booleanValue()) {
                IDataModel model = this.getContext().getModel();
                startEntryRow = model.getEntryEntity(entity.getName()).size();
                model.beginInit();
                int[] ints = model.batchCreateNewEntryRow(entity.getName(), totalRowSize + 1);
                model.deleteEntryRow(entity.getName(), ints[0]);
                model.endInit();
                if (!(entity instanceof SubEntryType)) {
                    DualHashBidiMap entryRowMappingExcel = new DualHashBidiMap();
                    for (int i2 = 0; i2 < insertRows.size(); ++i2) {
                        entryRowMappingExcel.put((Object)ints[i2], (Object)((Integer)((Map)insertRows.get(i2)).get("rowNum")));
                    }
                    this.getContext().addEntryRowMappingExcelRowNum(entity.getName(), (Map<Integer, Integer>)entryRowMappingExcel);
                    DynamicObjectCollection entryEntity = model.getEntryEntity(entity.getName());
                    for (int i3 = 0; i3 < updateRows.size(); ++i3) {
                        Map updateRowMap = (Map)updateRows.get(i3);
                        entryRowMappingExcel.put((Object)ints[i3 + insertRows.size()], (Object)((Integer)updateRowMap.get("rowNum")));
                        entryEntity.set(i3 + insertRows.size(), updateData.get(updateRowMap.get("$matchid$")));
                    }
                }
            } else {
                startEntryRow = this.getContext().getModel().getEntryEntity(entity.getName()).size() - totalRowSize;
            }
        }
        DynamicObjectCollection targetRows = this.getContext().getModel().getEntryEntity(entity.getName());
        ArrayList<RowMapper> mappers = new ArrayList<RowMapper>(sourceRows.size());
        for (i = 0; i < insertRows.size(); ++i) {
            RowMapper rowMapper = new RowMapper((Map)insertRows.get(i), (DynamicObject)targetRows.get(i + startEntryRow), parent, i + startEntryRow);
            mappers.add(rowMapper);
        }
        for (i = 0; i < updateRows.size(); ++i) {
            Map updateRow = (Map)updateRows.get(i);
            DynamicObject dynamicObject = (DynamicObject)updateData.get(updateRow.get("$matchid$"));
            RowMapper rowMapper = new RowMapper(updateRow, dynamicObject, parent, i + startEntryRow + insertRows.size());
            mappers.add(rowMapper);
        }
        return mappers;
    }

    private void divideSourceRows(EntryType entity, List<Map<String, Object>> sourceRows, RowMapper parent, List<Map<String, Object>> insertRows, List<Map<String, Object>> updateRows, Map<Object, DynamicObject> updateData) {
        ImportEntryTypeEnum importEntryType = this.getContext().getImportEntryType();
        if (CollectionUtils.isNotEmpty(sourceRows) && (ImportEntryTypeEnum.OVERRIDE == importEntryType || ImportEntryTypeEnum.OVERRIDE_AND_NEW == importEntryType)) {
            DynamicObjectCollection currentEntryList = this.getContext().getCurrentEntryList();
            Iterator<Map<String, Object>> iterator = insertRows.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                ++index;
                Map<String, Object> row = iterator.next();
                Object id = row.get("$matchid$");
                if (ImportEntryTypeEnum.OVERRIDE_AND_NEW == importEntryType && StringUtils.isBlank((Object)id)) continue;
                DynamicObject existRow = this.getRowDynamicObject(id, currentEntryList, parent, entity);
                if (existRow == null) {
                    this.addUnableToUpdateError(parent, entity, row, id, index);
                    iterator.remove();
                    continue;
                }
                updateRows.add(row);
                updateData.put(id, existRow);
                iterator.remove();
            }
        }
    }

    private void addUnableToUpdateError(RowMapper parent, EntryType entity, Map<String, Object> row, Object id, int index) {
        if (row.containsKey("rowNum")) {
            if (entity instanceof SubEntryType) {
                String msg = String.format(ResManager.loadKDString((String)"\u5b50\u5206\u5f55%1$s\u7684\u5339\u914did\u4e3a\u7a7a", (String)"ApiEntryPropConverter_7", (String)BOS_IMPORT, (Object[])new Object[0]), entity.getDisplayName().toString());
                if (StringUtils.isNotBlank((Object)id)) {
                    msg = String.format(ResManager.loadKDString((String)"\u5b50\u5206\u5f55%1$s\u7684\u5339\u914did\uff1a%2$s\u65e0\u6cd5\u5339\u914d\u5230\u6570\u636e", (String)"ApiEntryPropConverter_8", (String)BOS_IMPORT, (Object[])new Object[0]), entity.getDisplayName().toString(), id);
                }
                this.getContext().addErrorInfo((Integer)row.get("rowNum"), msg);
                return;
            }
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u5339\u914did\u4e3a\u7a7a", (String)"ApiEntryPropConverter_9", (String)BOS_IMPORT, (Object[])new Object[0]), entity.getDisplayName().toString());
            if (StringUtils.isNotBlank((Object)id)) {
                msg = String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u5339\u914did\uff1a%2$s\u65e0\u6cd5\u5339\u914d\u5230\u6570\u636e", (String)"ApiEntryPropConverter_10", (String)BOS_IMPORT, (Object[])new Object[0]), entity.getDisplayName().toString(), id);
            }
            this.getContext().addErrorInfo((Integer)row.get("rowNum"), msg);
            return;
        }
        if (entity instanceof SubEntryType) {
            String subEntryMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7b2c%2$s\u884c\u7684\u5b50\u5206\u5f55%3$s\u7b2c%4$s\u884c\u7684\u5339\u914did\u4e3a\u7a7a", (String)"ApiEntryPropConverter_11", (String)BOS_IMPORT, (Object[])new Object[0]), entity.getParent().getDisplayName().toString(), parent.getRowIndex(), entity.getDisplayName().toString(), index + 1);
            if (StringUtils.isNotBlank((Object)id)) {
                subEntryMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7b2c%2$s\u884c\u7684\u5b50\u5206\u5f55%3$s\u7b2c%4$s\u884c\u7684\u5339\u914did\uff1a%5$s\u65e0\u6cd5\u5339\u914d\u5230\u6570\u636e", (String)"ApiEntryPropConverter_12", (String)BOS_IMPORT, (Object[])new Object[0]), entity.getParent().getDisplayName().toString(), parent.getRowIndex(), entity.getDisplayName().toString(), index + 1, id);
            }
            this.getContext().addErrorInfo(subEntryMsg);
            return;
        }
        String entryMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7b2c%2$s\u884c\u7684\u5339\u914did\u4e3a\u7a7a", (String)"ApiEntryPropConverter_13", (String)BOS_IMPORT, (Object[])new Object[0]), entity.getDisplayName().toString(), index + 1);
        if (StringUtils.isNotBlank((Object)id)) {
            entryMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7b2c%2$s\u884c\u7684\u5339\u914did\uff1a%3$s\u65e0\u6cd5\u5339\u914d\u5230\u6570\u636e", (String)"ApiEntryPropConverter_14", (String)BOS_IMPORT, (Object[])new Object[0]), entity.getDisplayName().toString(), index + 1, id);
        }
        this.getContext().addErrorInfo(entryMsg);
    }

    private DynamicObject getRowDynamicObject(Object matchId, DynamicObjectCollection collection, RowMapper parent, EntryType entity) {
        if (StringUtils.isBlank((Object)matchId) || StringUtils.equals((CharSequence)matchId.toString(), (CharSequence)"0") || CollectionUtils.isEmpty((Collection)collection)) {
            return null;
        }
        for (DynamicObject dynamicObject : collection) {
            if (entity instanceof SubEntryType) {
                if (parent.getTargetObj() == null || dynamicObject != parent.getTargetObj()) continue;
                DynamicObjectCollection subEntryCollection = dynamicObject.getDynamicObjectCollection(entity.getName());
                for (DynamicObject subRow : subEntryCollection) {
                    if (!this.valueEquals(matchId.toString(), subRow)) continue;
                    return subRow;
                }
                continue;
            }
            if (!this.valueEquals(matchId.toString(), dynamicObject)) continue;
            return dynamicObject;
        }
        return null;
    }

    private boolean valueEquals(String matchId, DynamicObject dynamicObject) {
        String pkValue = String.valueOf(dynamicObject.getPkValue());
        long instanceId = dynamicObject.getDataEntityState().getInstanceId();
        return !StringUtils.equals((CharSequence)pkValue, (CharSequence)"0") && StringUtils.equals((CharSequence)matchId, (CharSequence)pkValue) || StringUtils.equals((CharSequence)matchId, (CharSequence)Long.toString(instanceId));
    }
}

