/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.imptapi.ApiOrgPropConverter;
import kd.bos.form.operate.imptapi.ApiPropConvertSeq;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.permission.api.HasPermDimObjResult;

public class ApiMainOrgPropConverter
extends ApiOrgPropConverter {
    @Override
    public int getConvertSeq() {
        return ApiPropConvertSeq.MainOrgProp.getValue();
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        boolean valueExist = true;
        if (value == null) {
            valueExist = false;
        } else if (value instanceof Map) {
            Map valueMap = (Map)value;
            String importprop = (String)valueMap.get("importprop");
            if (StringUtils.isBlank((CharSequence)importprop)) {
                importprop = valueMap.containsKey("number") ? "number" : "name";
                BasedataEntityType refPropType = (BasedataEntityType)this.getBasedataProp().getComplexType();
                importprop = this.convertDefaultImportProp(refPropType, importprop);
            }
            if (!valueMap.containsKey("id") && StringUtils.isBlank(valueMap.get(importprop))) {
                valueExist = false;
            }
        }
        if (!valueExist) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"ApiMainOrgPropConverter_1", (String)"bos-form-core", (Object[])new Object[0]), this.getPropDisplayName()));
        }
        super.beginParseValue(rowMapper, value);
        Map mainOrgVal = (Map)value;
        Long mainOrgId = 0L;
        if (mainOrgVal != null && mainOrgVal.containsKey("id")) {
            Object id = mainOrgVal.get("id");
            if (id instanceof Long) {
                mainOrgId = (Long)id;
            } else if (id != null) {
                mainOrgId = Long.valueOf(id.toString());
            }
        }
        this.getContext().setMainOrgId(mainOrgId);
        HasPermDimObjResult hasPermResult = this.getContext().getHasPermResult();
        if (mainOrgId != 0L && !hasPermResult.hasAllDimObjPerm()) {
            List orgs = hasPermResult.getHasPermDimObjs();
            if (orgs.contains(mainOrgId)) {
                return;
            }
            LocaleString disp = this.getProp().getDisplayName();
            String importprop = mainOrgVal.getOrDefault("importprop", "number");
            Object inputVal = mainOrgVal.get(importprop);
            String orgImportPropName = String.valueOf(importprop);
            try {
                orgImportPropName = this.getOrgImportPropName(rowMapper, orgImportPropName);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            String errmsg = String.format(ResManager.loadKDString((String)"%1$s.%2$s\uff1a%3$s\uff0c\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8be5\u7ec4\u7ec7\u7684\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (String)"ApiMainOrgPropConverter_2", (String)"bos-import", (Object[])new Object[0]), StringUtils.isNotBlank((Object)disp) ? disp.toString() : this.getProp().getName(), orgImportPropName, inputVal);
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), errmsg);
        }
    }

    private String getOrgImportPropName(RowMapper rowMapper, String orgImportPropName) {
        DynamicObject targetObj = rowMapper.getTargetObj();
        DynamicObject orgDynamicObj = targetObj.getDynamicObject(this.getProp().getName());
        DataEntityPropertyCollection properties = orgDynamicObj.getDataEntityType().getProperties();
        if (!orgDynamicObj.getDataEntityType().getProperties().containsKey((Object)orgImportPropName)) {
            return orgImportPropName;
        }
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)orgImportPropName);
        LocaleString displayName = property.getDisplayName();
        if (displayName == null) {
            return orgImportPropName;
        }
        return displayName.toString();
    }
}

