/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.imptapi.ApiBasedataPropConverter;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.utils.ConvertResult;
import kd.bos.utils.ImportConvertUtils;

public class ApiMulBasedataPropConverter
extends ApiBasedataPropConverter {
    private static final String NUMBER = "number";
    private static final String IMPORTPROP = "importprop";

    @Override
    public BasedataProp getBasedataProp() {
        MulBasedataProp mulBasedataProp = (MulBasedataProp)this.getProp();
        return (BasedataProp)mulBasedataProp.getRefBaseProp();
    }

    @Override
    public BasedataEntityType getRefBDType(RowMapper row) {
        MulBasedataProp mulBasedataProp = (MulBasedataProp)this.getProp();
        return (BasedataEntityType)mulBasedataProp.getRefBaseProp().getComplexType();
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        this.rowMapper = rowMapper;
        Map val = (Map)value;
        if (val == null || val.containsKey("id")) {
            return;
        }
        String dataType = val.containsKey(IMPORTPROP) ? (String)val.get(IMPORTPROP) : (val.containsKey(NUMBER) ? NUMBER : "name");
        String[] datas = StringUtils.split((String)((String)val.get(dataType)), (String)",");
        if (datas == null) {
            return;
        }
        for (String data : datas) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(dataType, data);
            map.put(IMPORTPROP, dataType);
            BasedataItem item = this.buildBasedataItem(rowMapper, map);
            if (item == null) continue;
            String searchValue = item.getSearchValue();
            item.setSearchValue(null);
            if (!this.getSearchItems().containsKey(item)) {
                HashSet searchValues = new HashSet();
                this.getSearchItems().put(item, searchValues);
            }
            ((Set)this.getSearchItems().get(item)).add(searchValue);
        }
    }

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        try {
            List<Object> realVal = null;
            Map val = (Map)value;
            StringBuilder errIds = new StringBuilder();
            if (val == null || val.isEmpty()) {
                realVal = null;
            } else if (val.containsKey("id")) {
                realVal = (List<Object>)val.get("id");
                if (realVal instanceof String && StringUtils.isNotBlank(realVal)) {
                    ConvertResult convertResult = this.convertToCorrectTypeValue(realVal);
                    String errMsg = convertResult.getErrMsg();
                    if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                        this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), errMsg);
                        return;
                    }
                    this.checkIdInDbAndSetErrIds(rowMapper, convertResult.getIds(), errIds);
                    realVal = convertResult.getIds();
                }
            } else {
                String dataType = val.containsKey(IMPORTPROP) ? (String)val.get(IMPORTPROP) : (val.containsKey(NUMBER) ? NUMBER : "name");
                String[] datas = StringUtils.split((String)((String)val.get(dataType)), (String)",");
                ArrayList<Object> ids = new ArrayList<Object>();
                if (datas != null) {
                    for (String data : datas) {
                        HashMap<String, String> item = new HashMap<String, String>();
                        item.put(dataType, data);
                        item.put(IMPORTPROP, dataType);
                        try {
                            Object targetVal = this.convertWebApiValue(rowMapper, item);
                            if (targetVal instanceof DynamicObject) {
                                ids.add(((DynamicObject)targetVal).getPkValue());
                                continue;
                            }
                            if (!StringUtils.isNotBlank((Object)targetVal)) continue;
                            ids.add(targetVal);
                        }
                        catch (KDBizException e) {
                            if (e.getErrorCode() != null && StringUtils.equals((CharSequence)"NOT_FOUND_VALUE", (CharSequence)e.getErrorCode().getCode())) continue;
                            throw e;
                        }
                    }
                }
                realVal = ids;
            }
            String errIdsString = errIds.toString();
            int errIdsStringLen = errIdsString.length();
            if (errIdsStringLen >= 1) {
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"%1$s\u7684\u5185\u7801\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ApiBasedataPropConverter_15", (String)"bos-import", (Object[])new Object[0]), this.getProp().getDisplayName(), errIdsString.substring(0, errIdsStringLen - 1)));
                return;
            }
            this.getContext().getModel().setFieldValueForWebApi(this.getProp(), activeRow, realVal, this.getContext().isCheckImportable());
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), e.getMessage());
            }
            throw e;
        }
    }

    private void checkIdInDbAndSetErrIds(RowMapper rowMapper, List<Object> realVal, StringBuilder errIds) {
        BasedataEntityType bdType = this.getRefBDType(rowMapper);
        for (Object id : realVal) {
            DynamicObject dynamicObject = this.loadFromLocalCache(bdType, id, rowMapper.getExcelRowIndex());
            if (dynamicObject != null) continue;
            errIds.append(id).append(",");
        }
    }

    private ConvertResult convertToCorrectTypeValue(Object realVal) throws KDBizException {
        realVal = Arrays.asList(StringUtils.split((String)((String)((Object)realVal)), (String)","));
        MulBasedataProp prop = (MulBasedataProp)this.getProp();
        BasedataEntityType refBDType = this.getRefBDType(this.rowMapper);
        String disPlayName = this.getBaseDataPropDisplayName();
        return ImportConvertUtils.convertIds(realVal, refBDType.getPrimaryKey().getPropertyType(), disPlayName);
    }
}

