/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.listop;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.limiter.DuplicateLimiter;
import kd.bos.limiter.exception.AcquireFailedException;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.list.ListController;
import kd.bos.service.ServiceFactory;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.svc.util.OpExistChecker;

public class ImportData
extends DefaultDynamicFormOperate
implements ICloseCallBack {
    private static final Log log = LogFactory.getLog(ImportData.class);
    private static final String BOS_IMPORT = "bos-import";
    private static final String EXPORTAPP = "imp-exp";
    public static final String CONCURRENTID = "concurrentID";

    public boolean needSelectData() {
        return false;
    }

    protected int checkRightInListForm(MainEntityType mainEntityType, OperationResult result) {
        if (this.getView() instanceof IListView) {
            List mainOrgIds = ((IListView)this.getView()).getSelectedMainOrgIds();
            mainOrgIds.removeIf(id -> id == null);
            if (mainOrgIds.isEmpty()) {
                this.doPermission(result, this.getPermissionItemId(), 0L);
            } else {
                this.doPermission(result, this.getPermissionItemId(), mainOrgIds);
            }
        } else {
            this.doPermission(result, this.getPermissionItemId(), this.mainOrgId != null ? this.mainOrgId : 0L);
        }
        return 1;
    }

    public OperationResult invokeOperation() {
        Boolean opExist = OpExistChecker.check((String)this.getEntityId(), (String)this.getType(), (IFormView)this.getView());
        if (!opExist.booleanValue()) {
            return null;
        }
        boolean isDuplicate = DuplicateLimiter.acquire((String)"IMPORT_DUPLICATE", (String)this.getEntityId(), (String)this.getView().getPageId());
        if (!isDuplicate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ImportDataSave_18", (String)BOS_IMPORT, (Object[])new Object[0]));
            return new OperationResult();
        }
        FormShowParameter showParameter = this.createShowParameter();
        String concurrentID = null;
        String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
        if (!StringUtils.isNotBlank((CharSequence)routeAppId) || !ServiceLookup.hasDeployedAppId((String)EXPORTAPP)) {
            ConcurrencyLimiter acquire;
            try {
                acquire = ConcurrencyLimiter.acquire((String)"IMPORT_LIMIT", (String)"importList");
            }
            catch (AcquireFailedException e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4e86\u4fdd\u969c\u60a8\u7684\u4e1a\u52a1\u987a\u5229\uff0c\u7cfb\u7edf\u5bf9\u5bfc\u5165\u64cd\u4f5c\u8fdb\u884c\u4e86\u9650\u6d41\u3002\u5f53\u524d\u5bfc\u5165\u64cd\u4f5c\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u7b49\u5019\u5176\u4ed6\u7528\u6237\u5bfc\u5165\u64cd\u4f5c\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"ImportDataSave_17", (String)BOS_IMPORT, (Object[])new Object[0]));
                return new OperationResult();
            }
            concurrentID = acquire.getConcurrentID();
        }
        if (StringUtils.isNotEmpty(concurrentID)) {
            showParameter.setCustomParam(CONCURRENTID, (Object)concurrentID);
        }
        this.getView().showForm(showParameter);
        return new OperationResult();
    }

    protected FormShowParameter createShowParameter() {
        List preinsfiles;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        Map parameter = this.getParameter();
        if (parameter != null && !parameter.isEmpty()) {
            showParameter.setCustomParams(parameter);
        }
        String entityId = null;
        String listName = null;
        String curFormId = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (view instanceof IListView) {
            IListView listview = (IListView)view;
            FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
            entityId = config.getEntityTypeId();
            curFormId = listview.getBillFormId();
            listName = config.getCaption().toString();
            showParameter.setCustomParam("BillTypeId", (Object)((ListShowParameter)formShowParameter).getBillTypeId());
        } else if (view instanceof IBillView) {
            entityId = view.getEntityId();
            curFormId = view.getFormShowParameter().getFormId();
            String caption = formShowParameter.getCaption();
            listName = StringUtils.isNotBlank((CharSequence)caption) ? caption : (formShowParameter.getFormConfig() != null ? formShowParameter.getFormConfig().getCaption().toString() : "");
        }
        showParameter.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
        showParameter.setCustomParam("CheckRightAppId", (Object)formShowParameter.getCheckRightAppId());
        showParameter.setCustomParam("BillFormId", (Object)entityId);
        showParameter.setCustomParam("CurFormIdImport", (Object)curFormId);
        showParameter.setCustomParam("ListName", (Object)listName);
        showParameter.setCustomParam("OperateKey", (Object)this.getOperateKey());
        showParameter.setCustomParam("PermissionItemId", (Object)this.getPermissionItemId());
        showParameter.setCustomParam("RealPermissionEntityId", (Object)this.getRealPermissionEntityId());
        ArrayList<Long> mainOrgIds = null;
        if (view instanceof IListView) {
            mainOrgIds = ((IListView)this.getView()).getSelectedMainOrgIds();
        } else if (this.mainOrgId != null) {
            mainOrgIds = new ArrayList<Long>();
            mainOrgIds.add(this.mainOrgId);
        }
        if (mainOrgIds != null && !mainOrgIds.isEmpty()) {
            showParameter.setCustomParam("MainOrgIds", (Object)JSONArray.toJSONString(mainOrgIds));
        }
        showParameter.setCustomParam("OperateName", (Object)this.getOperateName().toString());
        log.debug("before-show-import-data------billformid=" + entityId + ", appid=" + formShowParameter.getAppId() + ", service_appid=" + formShowParameter.getServiceAppId());
        List plugins = (List)this.getParameter().get("plugins");
        if (plugins != null && plugins.size() > 0) {
            for (Map p2 : plugins) {
                if (!Boolean.TRUE.equals(p2.get("Enabled"))) continue;
                showParameter.setCustomParam("ImportPlugin", p2.get("ClassName"));
                showParameter.setCustomParam("ImportPlugin_type", (Object)String.valueOf(p2.get("Type")));
                break;
            }
        }
        if ((preinsfiles = (List)this.getParameter().get("preinsfiles")) != null && !preinsfiles.isEmpty()) {
            preinsfiles.removeIf(p -> !Boolean.TRUE.equals(p.get("enabled")));
            if (!preinsfiles.isEmpty()) {
                showParameter.setCustomParam("PreInsFiles", (Object)preinsfiles);
            }
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listoperation");
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }

    public void closedCallBack(ClosedCallBackEvent closedcallbackevent) {
        Object controller = closedcallbackevent.getSource();
        if (controller instanceof ListController) {
            IListView listView = (IListView)((ListController)closedcallbackevent.getSource()).getView();
            ITreeListView treeListView = listView.getTreeListView();
            if (treeListView != null) {
                treeListView.getTreeView().setRootVisible(true);
                treeListView.refresh();
            } else {
                listView.clearSelection();
                listView.refresh();
            }
        } else if (controller instanceof FormController) {
            ((FormController)controller).getView().updateView();
        }
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        if (this.isLogEnable()) {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            opResult.setCancelWriteLog(true);
            String msg = String.format(ResManager.loadKDString((String)"\u70b9\u51fb\u201c%s\u201d\u6309\u94ae\u6267\u884c\u6210\u529f\u3002", (String)"ImportData_1", (String)BOS_IMPORT, (Object[])new Object[0]), this.getOperateName().getLocaleValue());
            AppLogInfo logInfo = this.buildLogInfo(msg, this.mainOrgId);
            OpLogAppInfo opLogAppInfo = ImportOperationLog.getInstance().reBuildAppInfo(this.getOperateKey(), this.getOperateName(), logInfo);
            logService.addLog((AppLogInfo)opLogAppInfo);
        }
        super.afterInvokeOperation(opResult);
    }
}

