/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.dto.ExportPermissionParam;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.mservice.ExportPermissionService;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.imp.ImportPluginUtils;
import kd.bos.imp.events.TemplateFilterArgs;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.svc.util.EncryptUtils;
import kd.bos.svc.util.permission.datarule.DataRulePermissionUtil;
import kd.bos.url.UrlService;
import kd.bos.web.actions.utils.FilePremissionUtil;
import kd.sdk.kingscript.host.ScriptProxyFactory;

public class DownloadTemplatePlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
CreateListDataProviderListener {
    private static final Log log = LogFactory.getLog(DownloadTemplatePlugin.class);
    private static final String BILLLISTAP = "billlistap";
    private static final String ENTRY_IMPORTTPL = "importtpl";
    private static final String BOS_BILLTYPE = "bos_billtype";
    private static final String BOS_IMPORT_TEMPLATE = "bos_importtemplate";
    private static final String BOS_IMPORT = "bos-import";
    private static final String FIELD_TEMPORARYFIELD = "temporaryfield";
    private static final String FIELD_ATTACHMENTFIELD = "attachmentfield";
    private static final String FIELD_BIZOBJ_NUMBER = "bizobject.number";
    private static final String FIELD_BASEDATA_ID = "fbasedataid";
    private static final String FIELD_BASEDATA_ID_ID = "fbasedataid_id";
    private static final String FIELD_ID = "id";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_URL = "url";
    private static final String FIELD_COMMENT = "comment";
    private static final String PLUGIN = "plugin";
    private static final String APPLY_LAYOUT = "applylayout";
    private static final String BTN_OK = "btnok";
    private static final String BTN_NEWTEMPLATE = "newtemplate";
    private static final String PARAM_BINDENTITYID = "BillFormId";
    private static final String PARAM_TEMPLATETYPE = "TemplateType";
    private static final String PARAM_BILLTYPEID = "BillTypeId";
    private final String RES_TEMPLATE_PREFIX = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"DownloadTemplatePlugin_0", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_TYPE_NOT_SUPPORT = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"DownloadTemplatePlugin_1", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_FULL_TEMPLATE_NOT_EDITABLE = ResManager.loadKDString((String)"\u52a8\u6001\u751f\u6210\u7684\u5168\u91cf\u6a21\u677f\u4e0d\u652f\u6301\u7f16\u8f91", (String)"DownloadTemplatePlugin_2", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_SAMPLE = ResManager.loadKDString((String)"\u793a\u4f8b", (String)"DownloadTemplatePlugin_3", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_FULL_TEMPLATE = ResManager.loadKDString((String)"\u5168\u91cf\u6a21\u677f", (String)"DownloadTemplatePlugin_4", (String)"bos-import", (Object[])new Object[0]);

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.addPackageDataListener(pkg -> {
            if (FIELD_TEMPORARYFIELD.equalsIgnoreCase(((AbstractColumnDesc)pkg.getSource()).getKey()) && !pkg.getRowData().getDynamicObjectCollection(FIELD_ATTACHMENTFIELD).isEmpty()) {
                pkg.setFormatValue((Object)this.RES_SAMPLE);
            }
        });
        list.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, BTN_NEWTEMPLATE});
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BINDENTITYID);
        if (!StringUtils.isBlank((CharSequence)entityId)) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            FilterParameter filterParameter = new FilterParameter();
            String templateType = (String)showParameter.getCustomParam(PARAM_TEMPLATETYPE);
            Long billTypeId = (Long)showParameter.getCustomParam(PARAM_BILLTYPEID);
            String curFormId = (String)showParameter.getCustomParam("CurFormIdImport");
            QFilter filter = this.buildQFilter(entityId, templateType, billTypeId, curFormId);
            filterParameter.setFilter(filter);
            list.setQueryFilterParameter(filterParameter);
        }
    }

    private QFilter buildQFilter(String entityId, String templateType, Long billTypeId, String curFormId) {
        DynamicObject billType;
        QFilter equalTemplateType = new QFilter(PARAM_TEMPLATETYPE, "=", (Object)templateType).or(new QFilter(PARAM_TEMPLATETYPE, "is null", null));
        Long userId = Long.parseLong(RequestContext.getOrCreate().getUserId());
        QFilter validScope = new QFilter("applyscope", "=", (Object)"0").or("creator", "=", (Object)userId).or(new QFilter("applyscope", "=", (Object)"1").and("users.fbasedataid.id", "in", (Object)userId));
        QFilter availableTemplate = new QFilter("enable", "=", (Object)"1");
        QFilter filter = new QFilter(FIELD_BIZOBJ_NUMBER, "=", (Object)entityId).and(equalTemplateType).and(validScope).and(availableTemplate);
        if (billTypeId != null && !billTypeId.equals(0L) && (billType = BusinessDataServiceHelper.loadSingleFromCache((Object)billTypeId, (String)BOS_BILLTYPE)) != null) {
            DynamicObjectCollection coll = billType.getDynamicObjectCollection(ENTRY_IMPORTTPL);
            ArrayList<Long> ids = new ArrayList<Long>();
            for (DynamicObject obj : coll) {
                ids.add((Long)obj.get(FIELD_BASEDATA_ID_ID));
            }
            if (!ids.isEmpty()) {
                filter = filter.and(new QFilter(FIELD_ID, "in", ids));
            }
        }
        String formAppId = this.getModel().getDataEntityType().getAppId();
        QFilter dataRule = DataRulePermissionUtil.getDataRule((long)RequestContext.get().getCurrUserId(), (String)formAppId, (String)BOS_IMPORT_TEMPLATE);
        if (dataRule != null) {
            filter.and(dataRule);
        }
        QFilter applyLayoutFilter = new QFilter(APPLY_LAYOUT, "=", (Object)curFormId).or(APPLY_LAYOUT, "=", (Object)"");
        filter.and(applyLayoutFilter);
        QFilter customFilter = ImportPluginUtils.fireGetTemplateCustomFilter((TemplateFilterArgs)new TemplateFilterArgs(entityId, curFormId), (String)entityId);
        if (customFilter != null) {
            filter.and(customFilter);
        }
        return filter;
    }

    public void afterBindData(EventObject e) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.selectRows(0, true);
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                try {
                    this.pushBillTempalte();
                    break;
                }
                catch (IOException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
                }
            }
            case "newtemplate": {
                BillList list = (BillList)this.getControl(BILLLISTAP);
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(list.getEntityId());
                parameter.setCustomParam("bindEntityId", this.getView().getFormShowParameter().getCustomParam(PARAM_BINDENTITYID));
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_NEWTEMPLATE));
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.clearSelection();
        list.refreshData();
    }

    private void pushBillTempalte() throws IOException {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BINDENTITYID);
        if (!this.checkPermission(billFormId)) {
            return;
        }
        String importPlugin = (String)this.getView().getFormShowParameter().getCustomParam("ImportPlugin");
        String importPluginType = (String)this.getView().getFormShowParameter().getCustomParam("ImportPlugin_type");
        String extendData = (String)this.getView().getFormShowParameter().getCustomParam("ExtendData");
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Object[] templateIds = billList.getSelectedRows().getPrimaryKeyValues();
        if (templateIds == null || templateIds.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"DownloadTemplatePlugin_8", (String)BOS_IMPORT, (Object[])new Object[0]));
            return;
        }
        int maxTemplate = this.getMaxDownloadTemplateCountProperty();
        if (templateIds.length > maxTemplate) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u540c\u65f6\u4e0b\u8f7d%s\u4e2a\u6a21\u677f\u3002", (String)"DownloadTemplatePlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]), maxTemplate));
            return;
        }
        LocalDate now = LocalDate.now();
        if (StringUtils.isBlank((CharSequence)billFormId)) {
            this.getView().showMessage(this.RES_TYPE_NOT_SUPPORT);
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        DynamicObject templateData = null;
        String ctxPath = RequestContext.get().getClientFullContextPath();
        Map templateDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])templateIds, (String)BOS_IMPORT_TEMPLATE);
        for (Object templateId : templateIds) {
            String errMsg;
            templateData = (DynamicObject)templateDynamicObjectMap.get(templateId);
            String fileName = this.RES_TEMPLATE_PREFIX;
            fileName = templateData != null ? fileName + templateData.get(FIELD_NAME) : fileName + mainEntityType.getDisplayName();
            if (RequestContext.get().getLang() == Lang.zh_CN || RequestContext.get().getLang() == Lang.zh_TW) {
                fileName = fileName.replaceAll(" ", "");
            }
            if (StringUtils.isNotBlank((CharSequence)(errMsg = this.checkPlugin(importPlugin, importPluginType, templateData)))) {
                this.getView().showErrorNotification(errMsg);
                return;
            }
            String encodePlugin = EncryptUtils.encodeBase64((String)importPlugin);
            if (StringUtils.isBlank((CharSequence)importPluginType)) {
                importPluginType = "";
            }
            this.getView().download(ctxPath + (ctxPath.endsWith("/") ? "" : "/") + "form/export.do?templateid=" + templateId + "&formid=" + billFormId + "&plugin=" + encodePlugin + "&importPluginType=" + importPluginType + "&filename=" + URLEncoder.encode(fileName + "_" + String.format("%02d", now.getMonthValue()) + String.format("%02d", now.getDayOfMonth()) + ".xlsx", "UTF-8").replaceAll("\\+", "%20") + "&extenddata=" + extendData + "&routeappid=" + this.getView().getFormShowParameter().getServiceAppId() + "&a=templateId");
            this.getView().sendFormAction(this.getView());
        }
    }

    private boolean checkPermission(String billFormId) {
        try {
            boolean hasPermission = new ExportPermissionService().checkPermission(new ExportPermissionParam(Long.valueOf(RequestContext.get().getCurrUserId()), billFormId, "47150e89000000ac"));
            if (!hasPermission) {
                this.getView().showErrorNotification(FilePremissionUtil.genNoPermissionTips((String)billFormId, (String)"47150e89000000ac"));
                return false;
            }
        }
        catch (Exception e) {
            log.error("DownloadTemplatePlugin.pushBillTempalte() occur Exception: " + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private String checkPlugin(String importPlugin, String importPluginType, DynamicObject templateData) {
        String errorMsg = this.getImportPluginInstanceResult(importPlugin, importPluginType);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        if (templateData != null) {
            String plugins = templateData.getString(PLUGIN);
            List pluginsTmp = JSONObject.parseArray((String)plugins, Plugin.class);
            if (pluginsTmp == null) {
                return "";
            }
            String curPlugin = "";
            try {
                for (Plugin plugin : pluginsTmp) {
                    if (!plugin.isEnabled()) continue;
                    curPlugin = plugin.getClassName();
                    if (plugin.getType() == 4) {
                        ScriptProxyFactory.createPluginProxy((String)curPlugin, ProjectInitializerManager::getEngineAutoDebug);
                        continue;
                    }
                    TypesContainer.createInstance((String)curPlugin);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return String.format(ResManager.loadKDString((String)"\u6a21\u677f\u63d2\u4ef6%s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff0c\u8bf7\u68c0\u67e5\u63d2\u4ef6\u3002", (String)"ImportTemplatePlugin_30", (String)BOS_IMPORT, (Object[])new Object[0]), curPlugin);
            }
        }
        return "";
    }

    private String getImportPluginInstanceResult(String importPlugin, String importPluginType) {
        try {
            if (StringUtils.isBlank((CharSequence)importPlugin)) {
                return "";
            }
            if (StringUtils.equals((CharSequence)importPluginType, (CharSequence)String.valueOf(4))) {
                ScriptProxyFactory.createPluginProxy((String)importPlugin, ProjectInitializerManager::getEngineAutoDebug);
                return "";
            }
            TypesContainer.createInstance((String)importPlugin);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6%s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff0c\u8bf7\u68c0\u67e5\u63d2\u4ef6\u3002", (String)"DownloadTemplatePlugin_6", (String)BOS_IMPORT, (Object[])new Object[0]), importPlugin);
        }
        return "";
    }

    private int getMaxDownloadTemplateCountProperty() {
        try {
            return Integer.parseInt(System.getProperty("max.download.template.count", "20"));
        }
        catch (NumberFormatException e) {
            log.warn((Throwable)e);
            return 20;
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Long pkId = (Long)billList.getFocusRowPkId();
        switch (e.getFieldName()) {
            case "name": {
                if (pkId == 0L) {
                    this.getView().showTipNotification(this.RES_FULL_TEMPLATE_NOT_EDITABLE);
                    return;
                }
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(billList.getEntityId());
                parameter.setStatus(OperationStatus.EDIT);
                parameter.setPkId((Object)pkId);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewtemplate"));
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "temporaryfield": {
                BillList billlist = (BillList)e.getSource();
                DynamicObject row = BusinessDataServiceHelper.loadSingle((Object)billlist.getCurrentSelectedRowInfo().getPrimaryKeyValue(), (DynamicObjectType)billlist.getEntityType());
                DynamicObjectCollection attachments = row.getDynamicObjectCollection(FIELD_ATTACHMENTFIELD);
                attachments.forEach(attach -> {
                    DynamicObject attachment = attach.getDynamicObject(FIELD_BASEDATA_ID);
                    String url = attachment.getString(FIELD_URL);
                    if (StringUtils.isNotBlank((CharSequence)url)) {
                        String attachmentFullUrl = UrlService.getAttachmentFullUrl((String)url);
                        String entityNum = billlist.getEntityType().getName();
                        if (StringUtils.isNotBlank((CharSequence)entityNum)) {
                            String appId = EntityMetadataCache.getDataEntityType((String)entityNum).getAppId();
                            attachmentFullUrl = attachmentFullUrl + "&fId=" + entityNum + "&appId=" + appId;
                        }
                        this.getView().download(attachmentFullUrl);
                    }
                });
                break;
            }
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs evt) {
        final FormShowParameter showParameter = this.getView().getFormShowParameter();
        evt.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                String billFormId;
                DynamicObjectCollection data = super.getData(start, limit);
                if (data.isEmpty() && StringUtils.isNotBlank((CharSequence)(billFormId = (String)showParameter.getCustomParam(DownloadTemplatePlugin.PARAM_BINDENTITYID)))) {
                    DynamicObject obj = data.addNew();
                    obj.set(DownloadTemplatePlugin.FIELD_ID, (Object)0);
                    obj.set(DownloadTemplatePlugin.FIELD_NAME, (Object)DownloadTemplatePlugin.this.RES_FULL_TEMPLATE);
                    obj.set(DownloadTemplatePlugin.FIELD_COMMENT, (Object)DownloadTemplatePlugin.this.RES_FULL_TEMPLATE_NOT_EDITABLE);
                }
                return data;
            }
        });
    }
}

