/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ImportDetailPlugin
extends AbstractBillPlugIn
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(ImportDetailPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"labelap"});
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        progress.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        String jsonData = (String)this.getModel().getValue("data");
        this.refreshByData(jsonData);
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        progress.start();
    }

    private void refreshByData(String jsonData) {
        if (StringUtils.isBlank((CharSequence)jsonData)) {
            return;
        }
        JSONObject data = JSON.parseObject((String)jsonData);
        int total = 0;
        int failed = 0;
        String errMsg = "";
        try {
            JSONObject info = data.getJSONObject("info");
            StringBuilder sb = new StringBuilder();
            for (Object obj : info.values()) {
                ImportLogger logger = (ImportLogger)JSONObject.parseObject((String)((JSONObject)obj).toJSONString(), ImportLogger.class);
                total += logger.getTotal();
                failed += logger.getFailed();
                sb.append(logger);
            }
            errMsg = sb.toString();
        }
        catch (Exception e) {
            errMsg = data.getString("info");
        }
        this.getModel().setValue("total", (Object)total);
        this.getModel().setValue("failed", (Object)failed);
        this.getModel().setValue("log", (Object)errMsg);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        this.getModel().setDataChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void click(EventObject evt) {
        if ("labelap".equals(((Control)evt.getSource()).getKey())) {
            String jsonData = (String)this.getModel().getValue("data");
            if (StringUtils.isBlank((CharSequence)jsonData)) {
                return;
            }
            JSONObject data = JSON.parseObject((String)jsonData);
            try {
                JSONObject info = data.getJSONObject("info");
                StringBuilder sb = new StringBuilder();
                int errFileCount = 0;
                for (Object obj : info.values()) {
                    ImportLogger logger = (ImportLogger)JSONObject.parseObject((String)((JSONObject)obj).toJSONString(), ImportLogger.class);
                    IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    if (!StringUtils.isNotBlank((CharSequence)logger.getErrFile())) continue;
                    proxy.addAction("download", (Object)logger.getErrFile());
                    ++errFileCount;
                }
                if (errFileCount == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u4f9b\u4e0b\u8f7d\u7684\u9519\u8bef\u6570\u636e\u6587\u4ef6\u3002", (String)"ImportDetailPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showMessage(ResManager.loadKDString((String)"\u4ece\u65e5\u5fd7\u4e2d\u63d0\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u53ef\u80fd\u65e5\u5fd7\u683c\u5f0f\u5316\u592a\u65e7\uff0c\u8bf7\u5c1d\u8bd5\u4ece\u65e5\u5fd7\u4e2d\u624b\u52a8\u63d0\u53d6\u5230\u5730\u5740\u680f\u4e0b\u8f7d\u3002", (String)"ImportDetailPlugin_1", (String)"bos-form-business", (Object[])new Object[0]));
            }
        }
    }

    public void onProgress(ProgressEvent evt) {
        IDataModel model = this.getModel();
        Object pk = model.getDataEntity().getPkValue();
        try {
            DynamicObject dataObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)model.getDataEntityType().getName(), (String)"status,progress,endtime");
            if (dataObj != null) {
                int progress = dataObj.getInt("progress");
                model.setValue("progress", (Object)progress);
                model.setValue("status", (Object)dataObj.getString("status"));
                model.setValue("endtime", (Object)dataObj.getString("endtime"));
                if (progress >= 100) {
                    evt.setProgress(100);
                    dataObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)model.getDataEntityType().getName(), (String)"data");
                    if (dataObj != null) {
                        this.refreshByData((String)dataObj.get("data"));
                    }
                }
            }
        }
        catch (Exception e) {
            evt.setProgress(100);
            this.getView().showErrMessage(this.getExceptionStackTrace(e), e.toString());
        }
    }

    /*
     * Exception decompiling
     */
    public String getExceptionStackTrace(Throwable e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

