/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.list.IListView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.svc.util.ImportLogDeleteFileUtil;
import kd.bos.svc.util.PermissionParam;
import kd.bos.url.UrlService;
import kd.bos.web.actions.utils.FilePremissionUtil;

public class ImportLogPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public static final String IMPORTENTRY = "2";
    private static final Log log = LogFactory.getLog(ImportLogPlugin.class);
    private static final String BOS_IMPORT = "bos-import";
    private static final String IMPORTURLS = "importurls";
    private static final String IMPORTLOGS = "importlogs";
    private static final String FORM_ID = "bos_importlog";
    private static final String REPORT_ICON = "reporticon";
    private static final String BTN_DOWNLOAD_REPORT = "btndownloadreport";
    private static final String PERM_ITEM_ID = "4715e1f1000000ac";
    private static final String IS_DELETED = "isdeleted";
    private static final String IS_FROM_LOG_MENU = "isfromlogmenu";
    private static final int MAX_LENGTH_PER_LOG = 5000;
    private boolean isImportSucceed = false;

    public void initialize() {
        this.addClickListeners(new String[]{"btnexporterror", "btnexporterrorentry", BTN_DOWNLOAD_REPORT});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(IMPORTURLS);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        DynamicObject reportRecord;
        this.refreshByData();
        String importstatus = (String)this.getModel().getValue("importstatus");
        if ("1".equals(importstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsuspend"});
        }
        String importType = (String)this.getModel().getValue("importtype");
        CardEntry cardEntry = (CardEntry)this.getControl(IMPORTURLS);
        if (StringUtils.equalsIgnoreCase((CharSequence)importType, (CharSequence)IMPORTENTRY)) {
            cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), 0, new String[]{"entryimgexport", "btnexporterrorentry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"logsflex"});
        } else {
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), 0, new String[]{"entryimgexport", "btnexporterrorentry"});
        }
        if (this.getModel().getValue("importstatus").equals("0")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"logsflex"});
        }
        if ((reportRecord = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_report_record", (String)"url", (QFilter[])new QFilter[]{new QFilter("uniquekey", "=", (Object)String.valueOf(this.getModel().getValue("id"))).and(new QFilter("status", "=", (Object)"S"))})) == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_DOWNLOAD_REPORT});
        }
        if (this.isImportSucceed || this.getModel().getValue(IS_DELETED).equals("1")) {
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), 0, new String[]{"entryimgexport", "btnexporterrorentry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap", "btnexporterror"});
        }
        ImportOperationLog.getInstance().createAppLog(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam("ParentEntityId"), ImportOperationLog.OperationEnum.IMPORT_RESULT_VIEW.getOpNameBridge(), ImportOperationLog.OperationEnum.IMPORT_RESULT_VIEW.getOpDescFormatBridge(), new String[0]);
    }

    public void afterLoadData(EventObject e) {
        JSONObject data;
        String jsonData;
        if (!this.parentIsCurBillListView()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
        }
        if (StringUtils.isBlank((CharSequence)(jsonData = (String)this.getModel().getValue("data")))) {
            return;
        }
        try {
            data = JSON.parseObject((String)jsonData);
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c\u4e2d\u7684\u9519\u8bef\u4fe1\u606f\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5220\u9664\u8be5\u6570\u636e\u3002", (String)"ImportLogPlugin_7", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        JSONObject info = data.getJSONObject("info");
        Iterator iterator = info.values().iterator();
        JSONObject infoJson = (JSONObject)iterator.next();
        String srcFile = infoJson.getString("srcFile");
        String filename = srcFile.substring(srcFile.lastIndexOf(47) + 1);
        this.getPageCache().put("srcFile", filename);
        String errFile = infoJson.getString("errFile");
        String logCache = infoJson.getString("logCache");
        this.getPageCache().put("logCache", logCache);
        if (StringUtils.isEmpty((CharSequence)errFile)) {
            this.isImportSucceed = true;
        }
        Date createTime = (Date)this.getModel().getValue("createtime");
        Date finishTime = (Date)this.getModel().getValue("modifytime");
        this.getModel().setValue("usetime", (Object)this.getUseTime(createTime, finishTime));
    }

    private String parseErrFileDownLoadUrl() {
        String attachId;
        boolean checkFilePermission = ((IAttachmentService)ServiceFactory.getService(IAttachmentService.class)).checkFilePermission();
        if (checkFilePermission) {
            String entityNum = (String)this.getView().getFormShowParameter().getCustomParam("ParentEntityId");
            if (StringUtils.isNotBlank((CharSequence)entityNum)) {
                String appId = EntityMetadataCache.getDataEntityType((String)entityNum).getAppId();
                String logEntityNum = this.getModel().getDataEntityType().getName();
                Object logPkId = this.getModel().getValue("id");
                String fileType = "";
                attachId = PermissionParam.genAttacId((String)appId, (String)entityNum, (String)logEntityNum, (Object)logPkId, (String)fileType);
            } else {
                log.warn("this.getView().getFormShowParameter().getCustomParam(\"ParentEntityId\") is blank ");
                attachId = this.getModel().getValue("id") + "@" + this.getModel().getDataEntityType().getName();
                attachId = Base64.getEncoder().encodeToString(attachId.getBytes(StandardCharsets.UTF_8));
            }
        } else {
            attachId = this.getModel().getValue("id") + "@" + this.getModel().getDataEntityType().getName();
            attachId = Base64.getEncoder().encodeToString(attachId.getBytes(StandardCharsets.UTF_8));
        }
        return UrlService.getDomainContextUrl() + "/attachment/download.do?attachId=" + attachId;
    }

    private void refreshByData() {
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get("logCache"))) {
            return;
        }
        IDataModel model = this.getModel();
        int total = Integer.parseInt(this.getModel().getValue("total").toString());
        int failed = Integer.parseInt(this.getModel().getValue("failed").toString());
        try {
            model.batchCreateNewEntryRow(IMPORTURLS, 1);
            model.batchCreateNewEntryRow(IMPORTLOGS, 1);
            int i = 0;
            ArrayList<Integer> emptyRows = new ArrayList<Integer>();
            String srcFile = this.getPageCache().get("srcFile");
            String filename = srcFile.substring(srcFile.lastIndexOf(47) + 1);
            model.setValue("filename", (Object)filename, i);
            model.setValue("succeedcount", (Object)(total - failed), i);
            model.setValue("failedcount", (Object)failed, i);
            String logStr = this.getPageCache().get("logCache");
            if (StringUtils.isNotBlank((CharSequence)logStr)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("logCache", (Object)logStr);
                ImportLogger importLogger = (ImportLogger)jsonObject.toJavaObject(ImportLogger.class);
                logStr = importLogger.toString();
                model.setValue("logtitle", (Object)filename, i);
                String tooLongStr = ResManager.loadKDString((String)"...\u5f53\u524d\u5806\u6808\u9519\u8bef\u63d0\u793a\u4fe1\u606f\u8d85\u957f\uff0c\u5df2\u505a\u622a\u65ad\u5904\u7406\uff0c\u5982\u9700\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u534f\u52a9\u67e5\u770bmonitor\u3002", (String)"ImportLogPlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]);
                model.setValue("log", (Object)(logStr.length() <= 5000 ? logStr : logStr.substring(0, 5000) + tooLongStr), i);
            } else {
                emptyRows.add(i);
            }
            if (emptyRows.size() < ++i) {
                int[] emptyArr = new int[]{};
                model.deleteEntryRows(IMPORTLOGS, emptyArr);
                this.getView().setVisible(Boolean.TRUE, new String[]{"logsflex"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"logsflex"});
            }
        }
        catch (Exception e) {
            log.error("[\u8f6c\u5316\u5bfc\u5165\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25\uff1a]" + e);
            String errMsg = this.getPageCache().get("info");
            model.setValue("log", (Object)errMsg);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        this.getModel().setDataChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void click(EventObject evt) {
        if ("btnexporterror".equals(((Control)evt.getSource()).getKey()) || "btnexporterrorentry".equals(((Control)evt.getSource()).getKey())) {
            Object isDeleted = this.getModel().getValue(IS_DELETED);
            if (StringUtils.equals((CharSequence)"1", (CharSequence)((String)isDeleted))) {
                String msg = ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u5220\u9664\u3002", (String)"ImportLogPlugin_6", (String)BOS_IMPORT, (Object[])new Object[0]);
                this.getView().showTipNotification(msg, Integer.valueOf(3000));
                return;
            }
            if (ImportLogDeleteFileUtil.isFromLogMenu((FormShowParameter)this.getView().getFormShowParameter()) && !ImportLogDeleteFileUtil.checkDeletePermission((String)this.getView().getFormShowParameter().getAppId(), (String)FORM_ID, (String)PERM_ITEM_ID)) {
                String msg = ImportLogDeleteFileUtil.getNoDeletePermissionMsg((String)FORM_ID);
                this.getView().showErrorNotification(msg);
                return;
            }
            String dataValue = (String)this.getModel().getValue("data");
            if (StringUtils.isBlank((CharSequence)dataValue)) {
                return;
            }
            String errFileDownLoadAttId = this.parseErrFileDownLoadUrl();
            try {
                int errFileCount = 0;
                DynamicObject userObj = (DynamicObject)this.getModel().getValue("creator");
                String createId = userObj.getString("id");
                String curUserId = RequestContext.get().getUserId();
                if (ImportLogDeleteFileUtil.isFromLogMenu((FormShowParameter)this.getView().getFormShowParameter()) || StringUtils.equals((CharSequence)createId, (CharSequence)curUserId)) {
                    boolean checkFilePermission = ((IAttachmentService)ServiceFactory.getService(IAttachmentService.class)).checkFilePermission();
                    IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    if (StringUtils.isBlank((CharSequence)errFileDownLoadAttId)) {
                        return;
                    }
                    String downloadUrl = errFileDownLoadAttId + "&a=t";
                    if (checkFilePermission) {
                        String attachIdOld = UrlUtil.getParam((String)errFileDownLoadAttId, (String)"attachId");
                        List permissionParamList = PermissionParam.getPermissionParamList((String)attachIdOld);
                        Map permMap = (Map)permissionParamList.get(0);
                        String attachIdNew = PermissionParam.cachePermissionParam((Map)permMap);
                        if (!FilePremissionUtil.hasEntityPermission((List)permissionParamList).booleanValue()) {
                            String permissionItem = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"Permission_IMPT", (String)BOS_IMPORT, (Object[])new Object[0]);
                            String nopermissiontips = FilePremissionUtil.genNoPermissionTips((String)this.getBizEntityId(), (String)permissionItem);
                            this.getView().showErrorNotification(nopermissiontips);
                            return;
                        }
                        downloadUrl = errFileDownLoadAttId.replace(attachIdOld, attachIdNew) + "&a=t";
                    }
                    downloadUrl = ImportLogDeleteFileUtil.wrapUrl((FormShowParameter)this.getView().getFormShowParameter(), (String)downloadUrl);
                    proxy.addAction("download", (Object)downloadUrl);
                    ++errFileCount;
                    this.createOperationLog(new MultiLangEnumBridge("\u5bfc\u51fa\u9519\u8bef\u6570\u636e", "ImportLogPlugin_8", BOS_IMPORT), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u5bfc\u51fa\u9519\u8bef\u6570\u636e%s\u6210\u529f", "ImportLogPlugin_9", BOS_IMPORT), String.valueOf(this.getModel().getValue("filename", 0)));
                } else {
                    this.getView().showMessage("No permission!");
                    this.createOperationLog(new MultiLangEnumBridge("\u5bfc\u51fa\u9519\u8bef\u6570\u636e", "ImportLogPlugin_8", BOS_IMPORT), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u5bfc\u51fa\u9519\u8bef\u6570\u636e%s\u5931\u8d25", "ImportLogPlugin_10", BOS_IMPORT), String.valueOf(this.getModel().getValue("filename", 0)));
                }
                if (errFileCount == 0) {
                    this.createOperationLog(new MultiLangEnumBridge("\u5bfc\u51fa\u9519\u8bef\u6570\u636e", "ImportLogPlugin_8", BOS_IMPORT), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u5bfc\u51fa\u9519\u8bef\u6570\u636e%s\u5931\u8d25", "ImportLogPlugin_10", BOS_IMPORT), String.valueOf(this.getModel().getValue("filename", 0)));
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u4f9b\u4e0b\u8f7d\u7684\u9519\u8bef\u6570\u636e\u6587\u4ef6\u3002", (String)"ImportLogPlugin_0", (String)BOS_IMPORT, (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.createOperationLog(new MultiLangEnumBridge("\u5bfc\u51fa\u9519\u8bef\u6570\u636e", "ImportLogPlugin_8", BOS_IMPORT), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u5bfc\u51fa\u9519\u8bef\u6570\u636e%s\u5931\u8d25", "ImportLogPlugin_10", BOS_IMPORT), String.valueOf(this.getModel().getValue("filename", 0)));
                this.getView().showMessage(ResManager.loadKDString((String)"\u4ece\u65e5\u5fd7\u4e2d\u63d0\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u53ef\u80fd\u65e5\u5fd7\u683c\u5f0f\u5316\u592a\u65e7\uff0c\u8bf7\u5c1d\u8bd5\u4ece\u65e5\u5fd7\u4e2d\u624b\u52a8\u63d0\u53d6\u5230\u5730\u5740\u680f\u4e0b\u8f7d\u3002", (String)"ImportLogPlugin_1", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("btnsuspend".equals(evt.getItemKey())) {
            DynamicObject sourceObj = (DynamicObject)this.getView().getModel().getValue("sourceobj");
            String billFormId = sourceObj.getString("number");
            boolean abnormal = !StringUtils.isBlank((CharSequence)billFormId);
            String appCacheTaskIdKey = "IMPT_TASKID_" + billFormId + "_" + this.getView().getModel().getDataEntity().getPkValue();
            String appId = EntityMetadataCache.getDataEntityType((String)billFormId).getAppId();
            String taskId = (String)AppCache.get((String)appId).get(appCacheTaskIdKey, String.class);
            if (StringUtils.isBlank((CharSequence)taskId)) {
                abnormal = false;
            }
            if (!abnormal) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5df2\u7ecf\u5f02\u5e38\u7ed3\u675f\u3002", (String)"ImportLogPlugin_14", (String)BOS_IMPORT, (Object[])new Object[0]));
                return;
            }
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo == null || StringUtils.isBlank((CharSequence)taskInfo.getStatus()) || TaskStatusConstant.isEnd((String)taskInfo.getStatus())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5df2\u7ecf\u5f02\u5e38\u7ed3\u675f\u3002", (String)"ImportLogPlugin_14", (String)BOS_IMPORT, (Object[])new Object[0]));
                return;
            }
            AppCache.get((String)appId).put("IMPT_SUSPEND_" + billFormId + "_" + this.getView().getModel().getDataEntity().getPkValue(), (Object)("IMPT_SUSPEND" + billFormId));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u4e2d\u6b62\u6210\u529f\u3002", (String)"ImportLogPlugin_20", (String)BOS_IMPORT, (Object[])new Object[0]));
            this.createOperationLog(new MultiLangEnumBridge("\u5bfc\u5165\u4e2d\u6b62\u6210\u529f", "ImportLogPlugin_18", BOS_IMPORT), new MultiLangEnumBridge("\u5bfc\u5165\u4e2d\u6b62\u6210\u529f\uff0c\u65e5\u5fd7\u7f16\u7801\uff1a%s", "ImportLogPlugin_19", BOS_IMPORT), String.valueOf(this.getModel().getValue("billno")));
        } else if (BTN_DOWNLOAD_REPORT.equals(evt.getItemKey())) {
            Object logPkId = this.getModel().getValue("id");
            DynamicObject reportRecord = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_report_record", (String)"url", (QFilter[])new QFilter[]{new QFilter("uniquekey", "=", (Object)String.valueOf(logPkId)).and(new QFilter("status", "=", (Object)"S"))});
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u5165\u76d1\u63a7\u62a5\u544a\u6210\u529f\u3002", "ImportLogPlugin_15", BOS_IMPORT);
            if (reportRecord == null) {
                opDesc = new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u5165\u76d1\u63a7\u62a5\u544a\u5931\u8d25\uff0c\u6682\u65e0\u62a5\u544a\u53ef\u4e0b\u8f7d\u3002", "ImportLogPlugin_16", BOS_IMPORT);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u62a5\u544a\u53ef\u4e0b\u8f7d\u3002", (String)"NO_MONITOR_REPORT", (String)BOS_IMPORT, (Object[])new Object[0]));
            } else {
                this.getView().download(UrlService.getAttachmentFullUrl((String)reportRecord.getString("url")));
            }
            this.createOperationLog(new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u5165\u76d1\u63a7\u62a5\u544a", "ImportLogPlugin_17", BOS_IMPORT), opDesc, new String[0]);
        }
    }

    /*
     * Exception decompiling
     */
    public String getExceptionStackTrace(Throwable e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getUseTime(Date createtime, Date finishTime) {
        String secondDes = ResManager.loadKDString((String)"\u79d2", (String)"ImportLogPlugin_2", (String)BOS_IMPORT, (Object[])new Object[0]);
        String minuteDes = ResManager.loadKDString((String)"\u5206\u949f", (String)"ImportLogPlugin_3", (String)BOS_IMPORT, (Object[])new Object[0]);
        String hourDes = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"ImportLogPlugin_4", (String)BOS_IMPORT, (Object[])new Object[0]);
        String useTime = "1" + secondDes;
        if (null != createtime && null != finishTime) {
            long between = (finishTime.getTime() - createtime.getTime()) / 1000L;
            if (between != 0L) {
                StringBuilder sb = new StringBuilder();
                long hour = between / 3600L;
                long minute = between % 3600L / 60L;
                long second = between % 60L;
                if (hour != 0L) {
                    sb.append(hour).append(" ").append(hourDes);
                    sb.append(minute).append(" ").append(minuteDes);
                    sb.append(second).append(" ").append(secondDes);
                } else if (minute != 0L) {
                    sb.append(minute).append(" ").append(minuteDes);
                    sb.append(second).append(" ").append(secondDes);
                } else {
                    sb.append(second).append(" ").append(secondDes);
                }
                useTime = sb.toString();
            }
        } else {
            useTime = "";
        }
        return useTime;
    }

    private boolean parentIsCurBillListView() {
        IFormView view = this.getView();
        String parentPageId = view.getFormShowParameter().getParentPageId();
        if (StringUtils.isBlank((CharSequence)parentPageId)) {
            return false;
        }
        IFormView parentView = view.getViewNoPlugin(parentPageId);
        String formId = view.getEntityId();
        if (parentView instanceof AbstractListView) {
            String parentBillId = ((IListView)parentView).getBillFormId();
            return StringUtils.equals((CharSequence)formId, (CharSequence)parentBillId);
        }
        return false;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("filename".equals(evt.getFieldName())) {
            if (ImportLogDeleteFileUtil.isFromLogMenu((FormShowParameter)this.getView().getFormShowParameter()) && !ImportLogDeleteFileUtil.checkDeletePermission((String)this.getView().getFormShowParameter().getAppId(), (String)FORM_ID, (String)PERM_ITEM_ID)) {
                String msg = ImportLogDeleteFileUtil.getNoDeletePermissionMsg((String)FORM_ID);
                this.getView().showErrorNotification(msg);
                return;
            }
            Object isDeleted = this.getModel().getValue(IS_DELETED);
            if (StringUtils.equals((CharSequence)"1", (CharSequence)((String)isDeleted))) {
                String msg = ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u5220\u9664\u3002", (String)"ImportLogPlugin_6", (String)BOS_IMPORT, (Object[])new Object[0]);
                this.getView().showTipNotification(msg, Integer.valueOf(3000));
                return;
            }
            String jsonData = (String)this.getModel().getValue("data");
            if (StringUtils.isBlank((CharSequence)jsonData)) {
                return;
            }
            JSONObject data = JSON.parseObject((String)jsonData);
            JSONObject info = data.getJSONObject("info");
            Set pathSet = info.keySet();
            for (String path : pathSet) {
                String attachId;
                if (StringUtils.isBlank((CharSequence)path)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"path\u4e3a\u7a7a\u3002", (String)"ImportLogPlugin_11", (String)BOS_IMPORT, (Object[])new Object[0]));
                    continue;
                }
                boolean checkFilePermission = ((IAttachmentService)ServiceFactory.getService(IAttachmentService.class)).checkFilePermission();
                if (checkFilePermission) {
                    String entityNum = (String)this.getView().getFormShowParameter().getCustomParam("ParentEntityId");
                    if (StringUtils.isNotBlank((CharSequence)entityNum)) {
                        String fileType;
                        Object logPkId;
                        String logEntityNum;
                        String appId = EntityMetadataCache.getDataEntityType((String)entityNum).getAppId();
                        attachId = PermissionParam.genAttacId((String)appId, (String)entityNum, (String)(logEntityNum = FORM_ID), (Object)(logPkId = this.getModel().getValue("id")), (String)(fileType = "srcFile"));
                        if (!FilePremissionUtil.hasEntityPermission((List)PermissionParam.getPermissionParamList((String)attachId)).booleanValue()) {
                            String permissionItem = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"Permission_IMPT", (String)BOS_IMPORT, (Object[])new Object[0]);
                            String nopermissiontips = FilePremissionUtil.genNoPermissionTips((String)this.getBizEntityId(), (String)permissionItem);
                            this.getView().showErrorNotification(nopermissiontips);
                            return;
                        }
                    } else {
                        log.warn("this.getView().getFormShowParameter().getCustomParam(\"ParentEntityId\") is blank ");
                        attachId = this.getModel().getValue("id") + "@bos_importlog@srcFile";
                        attachId = Base64.getEncoder().encodeToString(attachId.getBytes(StandardCharsets.UTF_8));
                    }
                } else {
                    attachId = this.getModel().getValue("id") + "@bos_importlog@srcFile";
                    attachId = Base64.getEncoder().encodeToString(attachId.getBytes(StandardCharsets.UTF_8));
                }
                String url = UrlService.getDomainContextUrl() + "/attachment/download.do?attachId=" + attachId;
                url = ImportLogDeleteFileUtil.wrapUrl((FormShowParameter)this.getView().getFormShowParameter(), (String)url);
                this.getView().download(url);
                this.createOperationLog(new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u5165\u6587\u4ef6", "ImportLogPlugin_12", BOS_IMPORT), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u4e0b\u8f7d\u5bfc\u5165\u6587\u4ef6%s\u6210\u529f", "ImportLogPlugin_13", BOS_IMPORT), String.valueOf(this.getModel().getValue("filename", 0)));
            }
        }
    }

    private void createOperationLog(MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(this.getView().getFormShowParameter().getAppId());
        appLogInfo.setBizObjID(this.getBizEntityId());
        appLogInfo.setOpName("import", opNameBridge);
        appLogInfo.setOpDesc(opDescBridge, opDescArgs);
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        service.addLog((AppLogInfo)appLogInfo);
    }

    private String getBizEntityId() {
        Object parentEntityId = this.getView().getFormShowParameter().getCustomParam("ParentEntityId");
        if (parentEntityId == null || StringUtils.isBlank((CharSequence)parentEntityId.toString())) {
            return this.getView().getEntityId();
        }
        return parentEntityId.toString();
    }
}

