/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.IImportDataPluginSupportKS;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.script.ProjectInitializerManager;
import kd.sdk.kingscript.host.HostObjectUtil;
import kd.sdk.kingscript.host.ScriptProxyFactory;

public class ImportStartData {
    public static final String CHECKRIGHTAPPID = "CheckRightAppId";
    public static final String LISTNAME = "ListName";
    public static final String IMPORTPLUGIN_TYPE = "ImportPlugin_type";
    public static final String BILLFORMID = "BillFormId";
    public static final String IMPORTPLUGIN = "ImportPlugin";
    public static final String KEYFIELDS = "keyfields";
    public static final String PAGECACHE_FOR_IMPORT_START_DATA = "importStartData";
    private ImportStartFieldControlEnum fieldControl;
    private boolean fieldLock;
    private boolean busiPluginSetField;
    private ImportStartTypeEnum importTypeEnum;
    private List<ComboItem> keyfieldItems;
    private String keyfields;
    private List<String> lockKeys;
    private CustomParamData customParamData;
    private String keyfieldsFromBillParam;

    public ImportStartData() {
    }

    private ImportStartData(AbstractFormPlugin formPlugin) {
        this.keyfieldItems = new ArrayList<ComboItem>(0);
        this.lockKeys = new ArrayList<String>(0);
        this.importTypeEnum = ImportStartTypeEnum.NEW;
        this.resolve(formPlugin);
    }

    public static void getInstance(AbstractFormPlugin formPlugin, Consumer<ImportStartData> consumer) {
        ImportStartData instants = ImportStartData.getInstance(formPlugin);
        consumer.accept(instants);
        ImportStartData.refresh(formPlugin.getPageCache(), instants);
    }

    private static ImportStartData getInstance(AbstractFormPlugin formPlugin) {
        IPageCache pageCache = formPlugin.getPageCache();
        String jsonString = pageCache.get(PAGECACHE_FOR_IMPORT_START_DATA);
        if (StringUtils.isNotBlank((CharSequence)jsonString)) {
            return (ImportStartData)JSON.parseObject((String)jsonString, ImportStartData.class);
        }
        return new ImportStartData(formPlugin);
    }

    private static void refresh(IPageCache pageCache, ImportStartData importStartData) {
        String jsonString = JSON.toJSONString((Object)importStartData);
        pageCache.put(PAGECACHE_FOR_IMPORT_START_DATA, jsonString);
    }

    public void resolve(AbstractFormPlugin formPlugin) {
        IImportDataPlugin pluginCheck;
        IImportDataPlugin plugin;
        this.customParamData = new CustomParamData(formPlugin);
        String pluginName = this.customParamData.pluginName;
        if (StringUtils.isBlank((CharSequence)pluginName)) {
            return;
        }
        if (StringUtils.equals((CharSequence)this.customParamData.getImportPluginType(), (CharSequence)String.valueOf(4))) {
            plugin = (IImportDataPlugin)ScriptProxyFactory.createPluginProxy((String)pluginName, ProjectInitializerManager::getEngineAutoDebug);
            pluginCheck = (IImportDataPlugin)HostObjectUtil.getHostObject((Object)plugin);
        } else {
            pluginCheck = plugin = (IImportDataPlugin)TypesContainer.getOrRegisterSingletonInstance((String)pluginName);
        }
        if (pluginCheck instanceof BatchImportPlugin) {
            IImportDataPluginSupportKS batchPlugin = (IImportDataPluginSupportKS)plugin;
            Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)this.customParamData.billFormId).getEntityTypeId());
            ImportContext importContext = new ImportContext(formPlugin.getView(), null, this.customParamData.appid, this.customParamData.checkrightappid, this.customParamData.listName, this.customParamData.billFormId, ops.getSave(), null);
            importContext.setFormShowParameterAppId(this.customParamData.formShowParameterAppId);
            batchPlugin.setContext(RequestContext.get(), importContext, null);
            String pluginImportType = batchPlugin.getDefaultImportType();
            this.importTypeEnum = ImportStartTypeEnum.getEnum(pluginImportType);
            this.keyfieldItems = new ArrayList<ComboItem>(batchPlugin.getOverrideFieldsConfig());
            this.keyfields = batchPlugin.getDefaultKeyFields();
            this.lockKeys = batchPlugin.getDefaultLockUIs();
            if (StringUtils.isNotBlank((CharSequence)this.keyfields)) {
                this.busiPluginSetField = true;
                this.fieldControl = ImportStartFieldControlEnum.FORM_BUSINESS;
                if (this.lockKeys.contains(KEYFIELDS)) {
                    this.fieldLock = true;
                }
            }
        }
    }

    public ImportStartFieldControlEnum getFieldControl() {
        return this.fieldControl;
    }

    public boolean isFieldLock() {
        return this.fieldLock;
    }

    public boolean isBusiPluginSetField() {
        return this.busiPluginSetField;
    }

    public ImportStartTypeEnum getImportTypeEnum() {
        return this.importTypeEnum;
    }

    public List<ComboItem> getKeyfieldItems() {
        return this.keyfieldItems;
    }

    public String getKeyfields() {
        return this.keyfields;
    }

    public List<String> getLockKeys() {
        return this.lockKeys;
    }

    public CustomParamData getCustomParamData() {
        return this.customParamData;
    }

    public void setKeyfields(String keyfields) {
        this.keyfields = keyfields;
    }

    public void setFieldControl(ImportStartFieldControlEnum fieldControl) {
        this.fieldControl = fieldControl;
    }

    public void setImportTypeEnum(ImportStartTypeEnum importTypeEnum) {
        this.importTypeEnum = importTypeEnum;
    }

    public void setCustomParamData(CustomParamData customParamData) {
        this.customParamData = customParamData;
    }

    public void setFieldLock(boolean fieldLock) {
        this.fieldLock = fieldLock;
    }

    public void setBusiPluginSetField(boolean busiPluginSetField) {
        this.busiPluginSetField = busiPluginSetField;
    }

    public void setKeyfieldItems(List<ComboItem> keyfieldItems) {
        this.keyfieldItems = keyfieldItems;
    }

    public void setLockKeys(List<String> lockKeys) {
        this.lockKeys = lockKeys;
    }

    public void setKeyfieldsFromBillParam(String keyfieldsFromBillParam) {
        this.keyfieldsFromBillParam = keyfieldsFromBillParam;
    }

    public String getKeyfieldsFromBillParam() {
        return this.keyfieldsFromBillParam;
    }

    public static enum ImportStartFieldControlEnum {
        FORM_BUSINESS(1),
        FORM_BILLPARAM(2);

        private final int type;

        private ImportStartFieldControlEnum(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum ImportStartTypeEnum {
        NEW("new"),
        OVERRIDE("override"),
        OVERRIDENEW("overridenew"),
        DEFAULT("");

        private final String type;

        private ImportStartTypeEnum(String desc) {
            this.type = desc;
        }

        public static ImportStartTypeEnum getEnum(String desc) {
            for (ImportStartTypeEnum value : ImportStartTypeEnum.values()) {
                if (!value.getType().equals(desc)) continue;
                return value;
            }
            return DEFAULT;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class CustomParamData {
        protected String appid;
        protected String checkrightappid;
        protected String billFormId;
        protected String listName;
        protected String importPluginType;
        protected String pluginName;
        protected String serviceAppId;
        protected String formShowParameterAppId;

        public CustomParamData() {
        }

        protected CustomParamData(AbstractFormPlugin formPlugin) {
            this.resolve(formPlugin);
        }

        public void resolve(AbstractFormPlugin formPlugin) {
            FormShowParameter showParam = formPlugin.getView().getFormShowParameter();
            this.appid = (String)showParam.getCustomParam("ServiceAppId");
            this.checkrightappid = (String)showParam.getCustomParam(ImportStartData.CHECKRIGHTAPPID);
            this.billFormId = (String)showParam.getCustomParam(ImportStartData.BILLFORMID);
            this.listName = (String)showParam.getCustomParam(ImportStartData.LISTNAME);
            this.importPluginType = (String)showParam.getCustomParam(ImportStartData.IMPORTPLUGIN_TYPE);
            this.pluginName = this.getImportPlugin(showParam);
            this.serviceAppId = showParam.getServiceAppId();
            this.formShowParameterAppId = showParam.getAppId();
        }

        private String getImportPlugin(FormShowParameter showParam) {
            List plugins;
            String pluginName = (String)showParam.getCustomParam(ImportStartData.IMPORTPLUGIN);
            if (StringUtils.isBlank((CharSequence)pluginName) && (plugins = (List)showParam.getCustomParam("plugins")) != null) {
                for (Map p : plugins) {
                    if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                    return (String)p.get("ClassName");
                }
            }
            return pluginName;
        }

        public String getAppid() {
            return this.appid;
        }

        public String getCheckrightappid() {
            return this.checkrightappid;
        }

        public String getBillFormId() {
            return this.billFormId;
        }

        public String getListName() {
            return this.listName;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getServiceAppId() {
            return this.serviceAppId;
        }

        public String getFormShowParameterAppId() {
            return this.formShowParameterAppId;
        }

        public String getImportPluginType() {
            return this.importPluginType;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public void setCheckrightappid(String checkrightappid) {
            this.checkrightappid = checkrightappid;
        }

        public void setBillFormId(String billFormId) {
            this.billFormId = billFormId;
        }

        public void setListName(String listName) {
            this.listName = listName;
        }

        public void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        public void setServiceAppId(String serviceAppId) {
            this.serviceAppId = serviceAppId;
        }

        public void setFormShowParameterAppId(String formShowParameterAppId) {
            this.formShowParameterAppId = formShowParameterAppId;
        }
    }
}

