/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NameVersionEntryType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.BeforeTogetherMoveEntryRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AttachmentCountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RichTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.utils.ImportPluginUtils;
import kd.sdk.kingscript.host.ScriptProxyFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportTemplatePlugin
extends AbstractBillPlugIn
implements TabSelectListener {
    private static final String ISPRESET = "ispreset";
    private static final String VECTORAP = "vectorap";
    private static final String FLEXPANELWARN = "flexpanelwarn";
    private static Log log = LogFactory.getLog(ImportTemplatePlugin.class);
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String IMPORTPROPNAME = "importpropname";
    private static final String EXPORTPROPMAP = "exportPropMap";
    private static final String FIELD_IMPORTPROP = "importprop";
    private static final String EXPORTPROP = "exportprop";
    private static final String EXPORTPROPNAME = "exportpropname";
    private static final String FIILED_PLUGIN = "plugin";
    private static final String EXPORTFORMATNAME = "exportformatname";
    private static final String EXPORTFORMAT = "exportformat";
    private static final String TOOLBAR = "advcontoolbarap";
    private static final String TOOLBAR_TBMAIN = "tbmain";
    private static final String BOS_POPCOMBO = "bos_popcombo";
    private static final String BOS_FORMATSELECT = "bos_formatselect";
    private static final String BOS_POPCOMBO_MAXSELECT = "maxselect";
    private static final String BOS_POPCOMBO_ITEMS = "items";
    private static final String BOS_POPCOMBO_VALUES = "values";
    private static final String APPLY_LAYOUT = "applylayout";
    private static final String CALLBACK_SELECTREFPROPS = "selectrefprops";
    private static final String CALLBACK_SELECTFORMAT = "selectformat";
    private static final String CALLBACK_DESSETTING = "des_setting";
    private static final String TEMPLATETYPE_IMPT = "IMPT";
    private static final String TEMPLATETYPE_EXPT = "EXPT";
    private static final String BOS_IMPORT = "bos-import";
    private static final String FIELD_TEMPLATETYPE = "templatetype";
    private static final String FIELD_BIZOBJ = "bizobject";
    private static final String FIELD_BIZOBJ_ID = "bizobject_Id";
    private static final String FIELD_ENABLEIMPT = "enableimport";
    private static final String FIELD_ISIMPORT = "isimport";
    private static final String FIELD_ISMUSTINPUT = "ismustinput";
    private static final String FIELD_ID = "id";
    private static final String FIELD_PID = "pid";
    private static final String FIELD_ENTITYDESCRIPTION = "entitydescription";
    private static final String FIELD_SEQ = "seq";
    private static final String FIELD_SOURCE_ENTITY = "sourceentity";
    private static final String FIELD_TARGET_ENTITY = "targetentity";
    private static final String FIELD_SOURCE_NAME = "sourcename";
    private static final String FIELD_ENTITYNAME = "entityname";
    private static final String FIELD_ENTITYNUMBER = "entitynumber";
    private static final String FIELD_ISFIELD = "isfield";
    private static final String FIELD_ISBASEDATA = "isbasedata";
    private static final String FIELD_ISDATE = "isdate";
    private static final String FIELD_CONTROLFIELD = "controlfield";
    private static final String FIELD_COOLWIDTH = "colwidth";
    private static final String PANEL_ATTACHMENT = "flexpanelap";
    private static final String PANEL_PARAM = "parampanel";
    private static final String BTN_DOWNLOAD = "btndownload_new";
    private static final String BTN_MOVEUP = "advconbaritemap";
    private static final String BTN_MOVEDOWN = "advconbaritemap1";
    private static final String BTN_MOVE_UP = "moveup";
    private static final String BTN_MOVE_DOWN = "movedown";
    private static final String OPERATION_MOVE_UP = "moveentryup";
    private static final String OPERATION_MOVE_DOWN = "moveentrydown";
    private static final String BILL_HEAD = "billhead";
    private static final String TAB_FIELD_SELECT = "field_tabpage";
    private static final String TAB_ATT_PANEL_SELECT = "attpanel_tabpage";
    private static final String ATT_PANEL_TREE_ENTRY = "attpanel_treeentry";
    private static final String ATT_NAME = "att_name";
    private static final String ATT_NUMBER = "att_number";
    private static final String ATT_IS_INPUT = "att_isinput";
    private static final String ATT_IS_IMPORT = "att_isimport";
    private static final String ATT_COL_WIDTH = "att_colwidth";
    private static final String ATT_DESCRIPTION = "att_description";
    private static final String ATT_PANEL_ENTITY_ROWS = "attpanel_treeentry_entity_row";
    private static final String PARAM_BINDENTITYID = "bindEntityId";
    private static final String PARAM_CUSTOMTEMPLATE = "customTemplate";
    private static final String SAVE_AND_NEW_BIZOBJECT = "saveAndNewBizObject";
    private static final String BOS_MULTILANG_DES_SETTING = "bos_multilang_des_setting";
    private static final String SIMPLEFIELD = "simpleField";
    private static final String ISMULILANGTEXT = "isMuliLangText";
    private final String RES_TEMPLATE_PREFIX = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"ImportTemplatePlugin_0", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_IF_IMPORT = ResManager.loadKDString((String)"\u662f\u5426\u5bfc\u5165", (String)"ImportTemplatePlugin_1", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_IF_EXPORT = ResManager.loadKDString((String)"\u662f\u5426\u5bfc\u51fa", (String)"ImportTemplatePlugin_2", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_BILLHEAD_NAME = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ImportTemplatePlugin_3", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_ID_NAME = ResManager.loadKDString((String)"\u5185\u7801", (String)"ImportTemplatePlugin_4", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_SELECT_PROPS = ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"ImportTemplatePlugin_5", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_SAVE_TEMPLATE = ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u6a21\u677f\u540e\u4e0b\u8f7d\u3002", (String)"ImportTemplatePlugin_6", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_BIZOBJ_NOT_FOUND = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4e1a\u52a1\u5bf9\u8c61\u7684\u7f16\u7801", (String)"ImportTemplatePlugin_7", (String)"bos-import", (Object[])new Object[0]);
    private final Map<String, String> dataRangeMap = new HashMap<String, String>(16);
    private final Map<String, Map<String, IDataEntityProperty>> acrossPropMap = new HashMap<String, Map<String, IDataEntityProperty>>(16);
    private static final String FIELD_NUMBER = "number";
    private final Map<String, IDataEntityProperty> newPropMap = new HashMap<String, IDataEntityProperty>();
    private final Set<String> entryCollection = new HashSet<String>();
    private final Set<String> subEntryCollection = new HashSet<String>();
    private boolean isNewAdd = true;
    private final Map<String, Integer[]> entityIndexMapping = new HashMap<String, Integer[]>();

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        boolean isFormDB = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        boolean bl = this.isNewAdd = !isFormDB;
        if ("saveandnew".equals(formOp.getOption().getVariables().get("orioperationkey"))) {
            String bizObject = (String)((DynamicObject)this.getModel().getValue(FIELD_BIZOBJ)).get(FIELD_NUMBER);
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            this.getView().getViewNoPlugin(parentPageId).getPageCache().put(SAVE_AND_NEW_BIZOBJECT, bizObject);
        }
        if ("save".equals(operateKey = formOp.getOperateKey())) {
            Object msg;
            IDataModel model = this.getModel();
            String bizObjectId = (String)model.getValue(FIELD_BIZOBJ_ID);
            if (StringUtils.isBlank((CharSequence)bizObjectId)) {
                String msg2 = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u3002", (String)"ImportTemplatePlugin_40", (String)BOS_IMPORT, (Object[])new Object[0]);
                args.setCancel(true);
                args.setCancelMessage(msg2);
                this.getView().showTipNotification(msg2);
                return;
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)bizObjectId);
            DataEntityPropertyCollection properties = entityType.getProperties();
            boolean isImport = TEMPLATETYPE_IMPT.equals(model.getValue(FIELD_TEMPLATETYPE));
            DynamicObjectCollection collection = model.getEntryEntity(TREEENTRYENTITY);
            boolean hasHeadPropExport = false;
            boolean hasSubEntryButNoParent = false;
            String needEnableField = null;
            HashMap<String, Boolean> entryFieldEnableMap = new HashMap<String, Boolean>();
            HashMap<String, String> subEntrysParentEnableMap = new HashMap<String, String>();
            for (DynamicObject obj : collection) {
                Boolean isEnable = obj.getBoolean(FIELD_ISIMPORT);
                String entitynumber = obj.getString(FIELD_ENTITYNUMBER);
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)entitynumber);
                IDataEntityProperty propindexsProperty = entityType.findProperty(entitynumber);
                if (isEnable.booleanValue() && iDataEntityProperty != null && !(iDataEntityProperty instanceof EntryProp)) {
                    hasHeadPropExport = true;
                }
                if (iDataEntityProperty instanceof EntryProp) {
                    entryFieldEnableMap.put(iDataEntityProperty.getName(), isEnable);
                }
                if (isEnable.booleanValue() && !(propindexsProperty instanceof SubEntryProp) && propindexsProperty != null && propindexsProperty.getParent() instanceof EntryType) {
                    String entryName = propindexsProperty.getParent().getName();
                    entryFieldEnableMap.put(entryName, Boolean.TRUE);
                }
                if (!isEnable.booleanValue() || propindexsProperty == null || !(propindexsProperty.getParent() instanceof SubEntryType)) continue;
                IDataEntityType subEntry = propindexsProperty.getParent();
                IDataEntityType parentEntry = subEntry.getParent();
                subEntrysParentEnableMap.put(subEntry.getName(), parentEntry.getName());
            }
            if (!hasHeadPropExport) {
                msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934\u5fc5\u987b\u81f3\u5c11\u5f00\u542f\u4e00\u4e2a\u5b57\u6bb5\u7684\u201c%s\u201d\u5c5e\u6027\u3002", (String)"ImportTemplatePlugin_8", (String)BOS_IMPORT, (Object[])new Object[0]), isImport ? this.RES_IF_IMPORT : this.RES_IF_EXPORT);
                args.setCancel(true);
                args.setCancelMessage((String)msg);
                this.getView().showErrorNotification((String)msg);
            }
            for (String parentEntry : subEntrysParentEnableMap.values()) {
                Boolean aBoolean = (Boolean)entryFieldEnableMap.get(parentEntry);
                if (aBoolean == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u7248\u4e2d\u672a\u68c0\u7d22\u5230\u5b50\u5355\u636e\u4f53\u7684\u7236\u6807\u8bc6\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u6a21\u7248\u518d\u8fdb\u884c\u5c1d\u8bd5", (String)"ImportTemplatePlugin_9", (String)BOS_IMPORT, (Object[])new Object[0]));
                }
                if (aBoolean.booleanValue()) continue;
                hasSubEntryButNoParent = true;
                needEnableField = parentEntry;
                break;
            }
            if (hasSubEntryButNoParent) {
                msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u201c%1$s(%2$s)\u201d\u4e0b\u5b58\u5728\u5b50\u5355\u636e\u4f53\u5f00\u542f\u4e86\u67d0\u5b57\u6bb5\u7684\u5c5e\u6027\uff0c\u5219\u7236\u5355\u636e\u4f53\u5fc5\u987b\u81f3\u5c11\u5f00\u542f\u4e00\u4e2a\u5b57\u6bb5\u7684\u201c%3$s\u201d\u5c5e\u6027\u3002", (String)"ImportTemplatePlugin_10", (String)BOS_IMPORT, (Object[])new Object[0]), ((IDataEntityProperty)properties.get(needEnableField)).getDisplayName(), needEnableField, isImport ? this.RES_IF_IMPORT : this.RES_IF_EXPORT);
                args.setCancel(true);
                args.setCancelMessage((String)msg);
                this.getView().showErrorNotification((String)msg);
            }
            if (!isFormDB) {
                this.getModel().setValue("enable", (Object)1);
            }
        }
        boolean isChange = this.getModel().getDataChanged();
        Object enable = this.getModel().getValue("enable");
        if (isFormDB && isChange) {
            switch (operateKey) {
                case "enable": {
                    if (!enable.equals("0")) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u66f4\u6539\u5185\u5bb9\u672a\u4fdd\u5b58\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u542f\u7528\u3002", (String)"ImportTemplatePlugin_100", (String)BOS_IMPORT, (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                case "disable": {
                    if (!enable.equals("1")) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u66f4\u6539\u5185\u5bb9\u672a\u4fdd\u5b58\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u7981\u7528\u3002", (String)"ImportTemplatePlugin_101", (String)BOS_IMPORT, (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FIELD_ENTITYDESCRIPTION});
        this.addClickListeners(new String[]{EXPORTPROPNAME, FIILED_PLUGIN});
        this.addClickListeners(new String[]{EXPORTFORMATNAME});
        this.addClickListeners(new String[]{VECTORAP});
        this.addItemClickListeners(new String[]{TOOLBAR});
        this.addItemClickListeners(new String[]{TOOLBAR_TBMAIN});
        Tab tab = (Tab)this.getView().getControl("select_tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isFromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        this.getView().setVisible(Boolean.valueOf(isFromDatabase), new String[]{"bar_new", "bar_disable"});
    }

    public void click(EventObject evt) {
        if (!(evt.getSource() instanceof Control)) {
            return;
        }
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (EXPORTPROPNAME.equals(key)) {
            this.showSelectExportPropForm();
        } else if (EXPORTFORMATNAME.equals(key)) {
            this.showSelectExportFormatForm();
        } else if (FIELD_ENTITYDESCRIPTION.equals(key)) {
            this.showSelectDesSettingForm();
        } else if (FIILED_PLUGIN.equals(key)) {
            this.showPlugin();
        } else if (VECTORAP.equals(key)) {
            this.hiddenWarnFlexAp();
        }
    }

    private void hiddenWarnFlexAp() {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELWARN});
    }

    private void showSelectDesSettingForm() {
        String importPropNumber;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(BOS_MULTILANG_DES_SETTING);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY);
        String desValue = String.valueOf(this.getModel().getValue(FIELD_ENTITYDESCRIPTION, entryCurrentRowIndex));
        boolean isbasedata = (Boolean)this.getModel().getValue(FIELD_ISBASEDATA, entryCurrentRowIndex);
        Object importPropNumberValue = this.getModel().getValue(FIELD_IMPORTPROP, entryCurrentRowIndex);
        String importPropName = importPropNumber = importPropNumberValue == null ? "" : String.valueOf(importPropNumberValue);
        String exportPropNumber = String.valueOf(this.getModel().getValue(EXPORTPROP, entryCurrentRowIndex));
        String exportPropName = String.valueOf(this.getModel().getValue(EXPORTPROPNAME, entryCurrentRowIndex));
        boolean simpleField = StringUtils.isBlank((CharSequence)(importPropNumber + importPropName + exportPropNumber + exportPropName));
        boolean isMuliLangText = this.isMuliLangText(entryCurrentRowIndex);
        if (simpleField && isbasedata) {
            simpleField = false;
            exportPropNumber = "number,name";
            exportPropName = ResManager.loadKDString((String)"\u7f16\u7801\uff0c\u540d\u79f0", (String)"ImportTemplatePlugin_35", (String)BOS_IMPORT, (Object[])new Object[0]);
        }
        Map<String, String> exportPropMap = this.getExportPropMap(importPropNumber, importPropName, exportPropNumber, exportPropName, entryCurrentRowIndex, simpleField, isMuliLangText);
        showParameter.setCustomParam(SIMPLEFIELD, (Object)(simpleField && !isMuliLangText ? 1 : 0));
        showParameter.setCustomParam(FIELD_ENTITYDESCRIPTION, (Object)desValue);
        showParameter.setCustomParam(EXPORTPROPMAP, (Object)SerializationUtils.toJsonString(exportPropMap));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_DESSETTING));
        this.getView().showForm(showParameter);
    }

    private boolean isMuliLangText(int entryCurrentRowIndex) {
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((String)this.getModel().getValue(FIELD_BIZOBJ_ID)));
            String entityNum = (String)this.getModel().getEntryRowEntity(TREEENTRYENTITY, entryCurrentRowIndex).get(FIELD_ENTITYNUMBER);
            DynamicProperty dataEntityProperty = dataEntityType.getProperty(entityNum);
            return dataEntityProperty instanceof MuliLangTextProp;
        }
        catch (Exception e) {
            log.error("get entryCurrentRow dataentityType error : " + e);
            return false;
        }
    }

    private void showSelectExportPropForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(this.RES_SELECT_PROPS);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(BOS_POPCOMBO);
        showParameter.setCustomParam(BOS_POPCOMBO_MAXSELECT, (Object)20);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY);
        String propName = this.getFieldNumber(entryCurrentRowIndex);
        List<ComboItem> comboItems = this.getRefProps(propName);
        if (comboItems == null) {
            return;
        }
        showParameter.setCustomParam(BOS_POPCOMBO_ITEMS, comboItems);
        String valStr = (String)this.getModel().getValue(EXPORTPROP);
        if (StringUtils.isNotBlank((CharSequence)valStr)) {
            showParameter.setCustomParam(BOS_POPCOMBO_VALUES, Arrays.asList(valStr.split(",")));
        }
        String templatetype = (String)this.getModel().getValue(FIELD_TEMPLATETYPE);
        showParameter.setCustomParam(FIELD_TEMPLATETYPE, (Object)templatetype);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_SELECTREFPROPS));
        this.getView().showForm(showParameter);
    }

    private void showSelectExportFormatForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u683c\u5f0f", (String)"ImportTemplatePlugin_36", (String)BOS_IMPORT, (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(BOS_FORMATSELECT);
        showParameter.setCustomParam(BOS_POPCOMBO_MAXSELECT, (Object)20);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY);
        String propName = this.getFieldNumber(entryCurrentRowIndex);
        List<ComboItem> formatItems = this.getExportFormats(propName);
        if (formatItems == null) {
            return;
        }
        showParameter.setCustomParam(BOS_POPCOMBO_ITEMS, formatItems);
        String valStr = (String)this.getModel().getValue(EXPORTFORMAT);
        if (StringUtils.isNotBlank((CharSequence)valStr)) {
            showParameter.setCustomParam(BOS_POPCOMBO_VALUES, Arrays.asList(valStr.split(",")));
        }
        String templatetype = (String)this.getModel().getValue(FIELD_TEMPLATETYPE);
        showParameter.setCustomParam(FIELD_TEMPLATETYPE, (Object)templatetype);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_SELECTFORMAT));
        this.getView().showForm(showParameter);
    }

    private Map<String, String> getExportPropMap(String importPropNumber, String importPropName, String exportPropNumber, String exportPropName, int entryCurrentRowIndex, boolean simpleField, boolean isMuliLangText) {
        LinkedHashMap<String, String> exportPropMap = new LinkedHashMap<String, String>();
        String fieldNumber = (String)this.getModel().getValue(FIELD_ENTITYNUMBER, entryCurrentRowIndex);
        String fieldName = (String)this.getModel().getValue(FIELD_ENTITYNAME, entryCurrentRowIndex);
        fieldName = fieldName.replace("*", "");
        if (isMuliLangText) {
            List enabledLang = InteServiceHelper.getMultiLangEnabledLang();
            for (EnabledLang lang : enabledLang) {
                exportPropMap.put(lang.getNumber(), lang.getName());
            }
            return exportPropMap;
        }
        if (simpleField) {
            exportPropMap.put(fieldNumber, fieldName);
            return exportPropMap;
        }
        ComboProp comboProp = (ComboProp)this.getModel().getEntryEntity(TREEENTRYENTITY).getDynamicObjectType().getProperty(FIELD_IMPORTPROP);
        List comboItems = comboProp.getComboItems();
        StringBuilder importPropNameBuilder = new StringBuilder();
        for (ValueMapItem comboItem : comboItems) {
            if (!importPropName.contains(comboItem.getValue())) continue;
            importPropNameBuilder.append(",").append(comboItem.getName().getLocaleValue());
        }
        if (importPropNameBuilder.length() > 0) {
            importPropName = importPropNameBuilder.substring(1);
        }
        String exportPropNumberString = importPropNumber + "," + exportPropNumber;
        String exportPropNameString = importPropName + "," + exportPropName;
        String[] exportPropNumberArray = exportPropNumberString.split(",", -1);
        String[] exportPropNameArray = exportPropNameString.split(",", -1);
        for (int i = 0; i < exportPropNumberArray.length; ++i) {
            if (StringUtils.isBlank((CharSequence)fieldNumber) || StringUtils.isBlank((CharSequence)exportPropNumberArray[i])) continue;
            String propNumber = fieldNumber + "." + exportPropNumberArray[i];
            String propName = fieldName + "." + exportPropNameArray[i];
            exportPropMap.put(propNumber, propName);
        }
        return exportPropMap;
    }

    private void showPlugin() {
        Object value = this.getModel().getValue(FIILED_PLUGIN);
        String formId = this.getView().getFormShowParameter().getFormId();
        List<?> plugins = this.getPluginsArray(value);
        FormShowParameter formShowParameter = this.buildShowParams(formId, plugins, new CloseCallBack((IFormPlugin)this, FIILED_PLUGIN));
        this.getView().showForm(formShowParameter);
    }

    private List<?> getPluginsArray(Object val) {
        List plugins = new ArrayList();
        if (val != null && StringUtils.isNotEmpty((CharSequence)val.toString())) {
            plugins = SerializationUtils.fromJsonStringToList((String)val.toString(), Map.class);
        }
        return plugins;
    }

    private FormShowParameter buildShowParams(String formId, List<?> plugins, CloseCallBack callback) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("ide_plugins");
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setCustomParam("value", plugins);
        showParam.setCustomParam("formId", (Object)formId);
        showParam.setCustomParam("scriptfiltertype", (Object)"importTemplatePlugin");
        showParam.setCloseCallBack(callback);
        return showParam;
    }

    private List<ComboItem> getRefProps(String propName) {
        String refpropStr = this.getPageCache().get("refprops_" + propName);
        if (refpropStr == null) {
            return null;
        }
        List refItems = SerializationUtils.fromJsonStringToList((String)refpropStr, ComboItem.class);
        return refItems;
    }

    private List<ComboItem> getExportFormats(String propName) {
        String exportformatStr = this.getPageCache().get("exportformats_" + propName);
        if (exportformatStr == null) {
            return null;
        }
        List formatItems = SerializationUtils.fromJsonStringToList((String)exportformatStr, ComboItem.class);
        return formatItems;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        Map value;
        String actionId = closedCallBackEvent.getActionId();
        if (CALLBACK_DESSETTING.equals(actionId)) {
            String resultDes = (String)closedCallBackEvent.getReturnData();
            if (resultDes != null) {
                this.getModel().setValue(FIELD_ENTITYDESCRIPTION, (Object)resultDes, this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY));
            }
        } else if (CALLBACK_SELECTREFPROPS.equals(actionId)) {
            List retdata = (List)closedCallBackEvent.getReturnData();
            if (retdata != null) {
                IDataModel model = this.getModel();
                this.setExportProps(model, retdata, model.getEntryCurrentRowIndex(TREEENTRYENTITY));
            }
        } else if (CALLBACK_SELECTFORMAT.equals(actionId)) {
            List retdata = (List)closedCallBackEvent.getReturnData();
            if (retdata != null) {
                IDataModel model = this.getModel();
                this.setExportFormat(model, retdata, model.getEntryCurrentRowIndex(TREEENTRYENTITY));
            }
        } else if (FIILED_PLUGIN.equals(closedCallBackEvent.getActionId()) && (value = (Map)(returnData = closedCallBackEvent.getReturnData())) != null && value.get("value") != null && value.get("value") instanceof List) {
            List plugins = (List)value.get("value");
            String pluginString = "";
            if (!plugins.isEmpty()) {
                pluginString = SerializationUtils.toJsonString((Object)plugins);
            }
            this.getModel().setValue(FIILED_PLUGIN, (Object)pluginString);
        }
    }

    private void setExportProps(IDataModel model, List<String> exportprops, int i) {
        ArrayList<String> captions = new ArrayList<String>();
        if (exportprops != null && !exportprops.isEmpty()) {
            String propName = this.getFieldNumber(i);
            for (ComboItem item : this.getRefProps(propName)) {
                if (!exportprops.contains(item.getValue())) continue;
                LocaleString disp = item.getCaption();
                captions.add(StringUtils.isNotBlank((Object)disp) ? disp.toString() : item.getValue());
            }
        }
        model.setValue(EXPORTPROP, (Object)(exportprops == null ? null : String.join((CharSequence)",", exportprops)), i);
        model.setValue(EXPORTPROPNAME, (Object)String.join((CharSequence)",", captions), i);
    }

    private void setExportFormat(IDataModel model, List<String> exportformat, int i) {
        ArrayList<String> captions = new ArrayList<String>();
        if (exportformat != null && !exportformat.isEmpty()) {
            String propName = this.getFieldNumber(i);
            for (ComboItem item : this.getExportFormats(propName)) {
                if (!exportformat.contains(item.getValue())) continue;
                LocaleString disp = item.getCaption();
                captions.add(StringUtils.isNotBlank((Object)disp) ? disp.toString() : item.getValue());
            }
            if (captions.isEmpty()) {
                for (String format : exportformat) {
                    captions.add(format);
                }
            }
        }
        model.setValue(EXPORTFORMAT, (Object)(exportformat == null ? null : String.join((CharSequence)",", exportformat)), i);
        model.setValue(EXPORTFORMATNAME, (Object)String.join((CharSequence)",", captions), i);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        if (((IBillModel)model).isFromImport()) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELWARN});
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IPageCache parentPageCache = this.getView().getViewNoPlugin(parentPageId).getPageCache();
        String bizObject = parentPageCache.get(SAVE_AND_NEW_BIZOBJECT);
        if (StringUtils.isNotBlank((CharSequence)bizObject)) {
            model.setValue(FIELD_BIZOBJ, (Object)bizObject);
            parentPageCache.remove(SAVE_AND_NEW_BIZOBJECT);
            this.setDefaultNumber(bizObject);
            this.buildAndRestoreFieldTree(model);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        String templateType = (String)this.getView().getFormShowParameter().getCustomParam(FIELD_TEMPLATETYPE);
        if (StringUtils.isNotBlank((CharSequence)templateType)) {
            this.getModel().setValue(FIELD_TEMPLATETYPE, (Object)templateType);
        }
        boolean isImport = TEMPLATETYPE_IMPT.equals(model.getValue(FIELD_TEMPLATETYPE));
        this.setImportOrExportColumnTitle(isImport);
        this.getView().setVisible(Boolean.valueOf(isImport), new String[]{FIELD_ISMUSTINPUT, PANEL_ATTACHMENT, BTN_DOWNLOAD, FIELD_IMPORTPROP, PANEL_PARAM, FIELD_ENTITYDESCRIPTION});
        this.getView().setVisible(Boolean.valueOf(!isImport), new String[]{EXPORTFORMATNAME});
        if (StringUtils.isBlank((CharSequence)bizObject) && StringUtils.isBlank((Object)this.getModel().getValue(FIELD_BIZOBJ))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_SOURCE_NAME});
        }
        this.setExportPropNameTips(isImport);
        this.getView().setVisible(Boolean.FALSE, new String[]{"users"});
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BINDENTITYID);
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            this.getModel().setValue(FIELD_BIZOBJ, (Object)entityId);
            DynamicObject bizobject = (DynamicObject)model.getValue(FIELD_BIZOBJ);
            boolean enableimport = (Boolean)bizobject.get(FIELD_ENABLEIMPT);
            if (enableimport) {
                model.setValue(FIELD_ENABLEIMPT, (Object)"1");
            } else {
                model.setValue(FIELD_ENABLEIMPT, (Object)"0");
            }
            if (!Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(PARAM_CUSTOMTEMPLATE))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_BIZOBJ});
            }
            this.setDefaultNumber(entityId);
            this.initApplyLayoutCombo(entityId);
            this.buildBillTreeFieldsExt(model, entityId, null);
            this.rebuildFieldTreeValueAndStyle(model, null, isImport);
            DynamicObjectCollection dynamicObjectCollection = model.getDataEntity().getDynamicObjectCollection(TREEENTRYENTITY);
            for (int row = 0; row < dynamicObjectCollection.size(); ++row) {
                String controlfield = (String)model.getValue(FIELD_CONTROLFIELD, row);
                Boolean isMustInput = (Boolean)((DynamicObject)dynamicObjectCollection.get(row)).get(FIELD_ISMUSTINPUT);
                if (!isMustInput.booleanValue() || !StringUtils.isNotBlank((CharSequence)controlfield)) continue;
                this.handleControlField(model, proxy, controlfield, FIELD_ISMUSTINPUT, true);
                this.handleControlField(model, proxy, controlfield, FIELD_ISIMPORT, true);
            }
        }
    }

    private void initApplyLayoutCombo(String bizObject) {
        List<ComboItem> comboItems = this.getLayoutComboItems(bizObject, true);
        ComboEdit editor = (ComboEdit)this.getView().getControl(APPLY_LAYOUT);
        if (editor != null) {
            editor.setComboItems(comboItems);
        }
    }

    private List<ComboItem> getLayoutComboItems(String bizObject, boolean isNeedDefault) {
        final ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        if (isNeedDefault) {
            DynamicObject applyLayout = (DynamicObject)this.getModel().getValue(FIELD_BIZOBJ);
            ComboItem defItem = new ComboItem(new LocaleString(applyLayout.getString("name")), bizObject);
            comboItems.add(defItem);
        }
        String sql = "select t0.fnumber, t1.fname   from t_meta_formdesign t0   left join t_meta_formdesign_l t1 on (t0.fid = t1.fid and t1.flocaleid = ?)   left join t_meta_entitydesign t2 on (t0.fentityid = t2.fid and t0.fnumber <> t2.fnumber)  where t0.ftype <> ?    and t2.fnumber = ?    and t0.fmodeltype <> ? ";
        Object[] sqlParams = new SqlParameter[]{new SqlParameter(":FLocaleId", 12, (Object)Lang.get().toString()), new SqlParameter(":FType", 12, (Object)"2"), new SqlParameter(":FNumber", 12, (Object)bizObject), new SqlParameter(":FModelType", 12, (Object)"MobileBillFormModel")};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String number = rs.getString(1);
                    String name = rs.getString(2);
                    ComboItem item = new ComboItem(new LocaleString(name), number);
                    comboItems.add(item);
                }
                return true;
            }
        };
        DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParams, (ResultSetHandler)action);
        return comboItems;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        List arr;
        List<String> layoutList;
        Map data = e.getSourceData();
        Object applyLayout = data.get(APPLY_LAYOUT);
        if (StringUtils.isNotBlank(applyLayout) && CollectionUtils.isNotEmpty(layoutList = this.getLayoutList(data)) && !layoutList.contains(applyLayout)) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u9002\u7528\u5355\u636e\u5e03\u5c40\u4e0d\u5b58\u5728\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ImportTemplatePlugin_47", (String)BOS_IMPORT, (Object[])new Object[0]));
            e.setCancel(true);
        }
        if (CollectionUtils.isEmpty((Collection)(arr = (List)data.get(TREEENTRYENTITY)))) {
            return;
        }
        for (Map row : arr) {
            if (!StringUtils.isNotBlank(row.get(EXPORTPROP))) continue;
            row.put(EXPORTPROPNAME, "stopruleclearexportpropforimport");
        }
    }

    private List<String> getLayoutList(Map<String, Object> data) {
        ArrayList<String> layouts = new ArrayList<String>();
        Object bizObject = data.get(FIELD_BIZOBJ);
        if (null == bizObject) {
            return layouts;
        }
        Object number = ((Map)bizObject).get(FIELD_NUMBER);
        if (number == null) {
            return layouts;
        }
        List<ComboItem> layoutComboItems = this.getLayoutComboItems((String)number, false);
        for (ComboItem layoutComboItem : layoutComboItems) {
            String value = layoutComboItem.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            layouts.add(value);
        }
        layouts.add((String)number);
        return layouts;
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        LinkedHashMap attachmentInfo;
        if (e.getSource() instanceof AttachmentEdit && ((attachmentInfo = (LinkedHashMap)((ArrayList)e.getValue()).get(0)).get("delete") == null || !((Boolean)attachmentInfo.get("delete")).booleanValue())) {
            this.resolveExcel(attachmentInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveExcel(LinkedHashMap attachmentInfo) {
        block6: {
            String url = (String)attachmentInfo.get("url");
            String fileName = (String)attachmentInfo.get("name");
            TempFileCache downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream inputStream = null;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ByteArrayInputStream newInputStream = null;
            try {
                inputStream = downLoad.getInputStream(url);
                XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
                for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                    XSSFSheet sheetAt = workbook.getSheetAt(i);
                    this.ExcelSecurityVerification(sheetAt);
                }
                workbook.write((OutputStream)outputStream);
                newInputStream = new ByteArrayInputStream(outputStream.toByteArray());
                int timeout = 7200;
                String newUrl = downLoad.saveAsUrl(fileName, (InputStream)newInputStream, timeout);
                newUrl = url.split("\\?")[0] + "?" + newUrl.split("\\?")[1];
                attachmentInfo.put("url", newUrl);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                break block6;
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                IOUtils.closeQuietly(newInputStream);
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly((InputStream)newInputStream);
        }
    }

    private void ExcelSecurityVerification(XSSFSheet sheet) {
        if (sheet.getPhysicalNumberOfRows() == 0) {
            return;
        }
        int firstRow = sheet.getFirstRowNum();
        int lastRow = sheet.getLastRowNum();
        for (int i = firstRow; i <= lastRow; ++i) {
            int firstColumn = sheet.getRow(i).getFirstCellNum();
            short lastColumn = sheet.getRow(i).getLastCellNum();
            for (int j = firstColumn; j < lastColumn; ++j) {
                XSSFCell cell = sheet.getRow(i).getCell(j);
                if (cell == null) continue;
                String cellStr = cell.toString();
                if (!Pattern.compile(".*[a-zA-Z=+\\\\\\-&@].*").matcher(cellStr).find()) continue;
                cell.removeFormula();
                cell.getCellStyle().setDataFormat(49);
                cell.setCellValue(cellStr);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        boolean isPreSet = (Boolean)model.getValue(ISPRESET);
        if (isPreSet) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELWARN, ISPRESET});
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("dragEntryRow", false);
            this.getView().updateControlMetadata(TREEENTRYENTITY, map);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELWARN});
        }
        this.buildAndRestoreFieldTree(model);
        this.hideUsersIfNotSpecScope(model);
        model.setDataChanged(false);
    }

    public void afterCopyData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELWARN});
        this.buildAndRestoreFieldTree(this.getModel());
        this.hideUsersIfNotSpecScope(this.getModel());
    }

    private void setExportPropNameTips(boolean isImport) {
        HashMap<String, String> tips = new HashMap<String, String>();
        tips.put("type", "text");
        if (isImport) {
            tips.put("content", (String)new LocaleString(ResManager.loadKDString((String)"\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u65f6\uff0c\u914d\u7f6e\u9700\u8981\u5bfc\u51fa\u7684\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u503c\u3002", (String)"ImportTemplatePlugin_11", (String)BOS_IMPORT, (Object[])new Object[0])));
        } else {
            tips.put("content", (String)new LocaleString(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u65f6\uff0c\u914d\u7f6e\u9700\u8981\u5bfc\u51fa\u7684\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u503c\u3002", (String)"ImportTemplatePlugin_12", (String)BOS_IMPORT, (Object[])new Object[0])));
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntryGrid.setColumnProperty(EXPORTPROPNAME, "tips", tips);
    }

    private void hideUsersIfNotSpecScope(IDataModel model) {
        this.getView().setVisible(Boolean.valueOf("1".equals(model.getValue("applyscope"))), new String[]{"users"});
    }

    private void buildAndRestoreFieldTree(IDataModel model) {
        String templateType = (String)model.getValue(FIELD_TEMPLATETYPE);
        boolean isImport = TEMPLATETYPE_IMPT.equals(templateType);
        this.setExportPropNameTips(isImport);
        if (StringUtils.isBlank((CharSequence)templateType)) {
            model.setValue(FIELD_TEMPLATETYPE, (Object)TEMPLATETYPE_IMPT);
        } else {
            this.setImportOrExportColumnTitle(isImport);
            this.getView().setVisible(Boolean.valueOf(isImport), new String[]{FIELD_ISMUSTINPUT, PANEL_ATTACHMENT, BTN_DOWNLOAD, FIELD_IMPORTPROP, PANEL_PARAM, ATT_IS_INPUT, FIELD_ENTITYDESCRIPTION});
            this.getView().setVisible(Boolean.valueOf(!isImport), new String[]{EXPORTFORMATNAME});
        }
        String bizEntityId = (String)model.getValue(FIELD_BIZOBJ_ID);
        DynamicObject bizobject = (DynamicObject)model.getValue(FIELD_BIZOBJ);
        boolean enableimport = (Boolean)bizobject.get(FIELD_ENABLEIMPT);
        if (enableimport) {
            model.setValue(FIELD_ENABLEIMPT, (Object)"1");
        } else {
            model.setValue(FIELD_ENABLEIMPT, (Object)"0");
        }
        if (StringUtils.isNotBlank((CharSequence)bizEntityId)) {
            LinkedHashMap<String, Map<String, Object>> dataMap = new LinkedHashMap<String, Map<String, Object>>();
            this.collectFieldTreeEntryData(model, dataMap);
            this.collectAttachmentPanelTreeEntryData(dataMap);
            this.buildBillTreeFieldsExt(model, bizEntityId, dataMap);
            this.rebuildFieldTreeValueAndStyle(model, dataMap, isImport);
            this.rebuildAttachmentPanelTreeValueAndStyle(dataMap);
            this.initApplyLayoutCombo(bizEntityId);
        }
    }

    private void collectFieldTreeEntryData(IDataModel model, Map<String, Map<String, Object>> dataMap) {
        DynamicObjectCollection dynColl = model.getEntryEntity(TREEENTRYENTITY);
        String root = "";
        for (DynamicObject dyn : dynColl) {
            Long pid = dyn.getLong(FIELD_PID);
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put(FIELD_ID, dyn.getPkValue());
            data.put(FIELD_PID, pid);
            data.put(FIELD_ENTITYDESCRIPTION, dyn.getString(FIELD_ENTITYDESCRIPTION));
            data.put(FIELD_ISMUSTINPUT, dyn.getBoolean(FIELD_ISMUSTINPUT));
            data.put(FIELD_ISIMPORT, dyn.getBoolean(FIELD_ISIMPORT));
            data.put(FIELD_IMPORTPROP, dyn.getString(FIELD_IMPORTPROP));
            data.put(EXPORTPROP, dyn.getString(EXPORTPROP));
            data.put(EXPORTFORMATNAME, dyn.getString(EXPORTFORMATNAME));
            data.put(EXPORTFORMAT, dyn.getString(EXPORTFORMAT));
            data.put(FIELD_ISFIELD, dyn.getBoolean(FIELD_ISFIELD));
            data.put(FIELD_ISBASEDATA, dyn.getBoolean(FIELD_ISBASEDATA));
            data.put(FIELD_ISDATE, dyn.getBoolean(FIELD_ISDATE));
            data.put(FIELD_COOLWIDTH, dyn.getInt(FIELD_COOLWIDTH));
            data.put(FIELD_SEQ, dyn.getInt(FIELD_SEQ));
            String sourceEntity = dyn.getString(FIELD_SOURCE_ENTITY);
            if (pid == null || pid == 0L) {
                root = dyn.getString(FIELD_ENTITYNUMBER);
                dataMap.put(root, data);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)sourceEntity)) {
                data.put(FIELD_TARGET_ENTITY, root);
                data.put(FIELD_SOURCE_NAME, dyn.getString(FIELD_SOURCE_NAME));
                data.put(FIELD_SOURCE_ENTITY, sourceEntity);
                String sourceRoot = StringUtils.split((String)sourceEntity, (String)".")[0];
                dataMap.put(sourceRoot + "." + dyn.getString(FIELD_ENTITYNUMBER), data);
                continue;
            }
            dataMap.put(root + "." + dyn.getString(FIELD_ENTITYNUMBER), data);
        }
    }

    private void collectAttachmentPanelTreeEntryData(Map<String, Map<String, Object>> dataMap) {
        DynamicObjectCollection attCollection = this.getModel().getEntryEntity(ATT_PANEL_TREE_ENTRY);
        String entityNumber = "";
        for (DynamicObject dynamicObject : attCollection) {
            long pid = dynamicObject.getLong(FIELD_PID);
            String attNumber = dynamicObject.getString(ATT_NUMBER);
            HashMap<String, Object> rowData = new HashMap<String, Object>(16);
            rowData.put(FIELD_ID, dynamicObject.getPkValue());
            rowData.put(FIELD_PID, pid);
            rowData.put(ATT_IS_INPUT, dynamicObject.getBoolean(ATT_IS_INPUT));
            rowData.put(ATT_IS_IMPORT, dynamicObject.getBoolean(ATT_IS_IMPORT));
            rowData.put(ATT_COL_WIDTH, dynamicObject.getInt(ATT_COL_WIDTH));
            rowData.put(ATT_DESCRIPTION, dynamicObject.get(ATT_DESCRIPTION));
            if (pid == 0L) {
                entityNumber = ATT_PANEL_TREE_ENTRY + attNumber;
                dataMap.put(entityNumber, rowData);
                continue;
            }
            dataMap.put(entityNumber + "." + attNumber, rowData);
        }
    }

    private void rebuildFieldTreeValueAndStyle(IDataModel model, Map<String, Map<String, Object>> dataMap, boolean isImport) {
        DynamicObjectCollection dynColl = model.getEntryEntity(TREEENTRYENTITY);
        int i = 0;
        String root = "";
        for (DynamicObject dyn : dynColl) {
            boolean isbasedata = (Boolean)model.getValue(FIELD_ISBASEDATA, i);
            boolean isdate = (Boolean)model.getValue(FIELD_ISDATE, i);
            if (dataMap != null) {
                String entityName = dyn.getString(FIELD_ENTITYNUMBER);
                Long pid = dyn.getLong(FIELD_PID);
                String sourceEntity = dyn.getString(FIELD_SOURCE_ENTITY);
                String fullEntityName = entityName;
                if (pid == null || pid == 0L) {
                    root = entityName;
                } else {
                    fullEntityName = root + "." + entityName;
                    if (StringUtils.isNotBlank((CharSequence)sourceEntity)) {
                        fullEntityName = StringUtils.split((String)sourceEntity, (String)".")[0] + "." + entityName;
                    }
                }
                Map<String, Object> data = dataMap.get(fullEntityName);
                if (data != null) {
                    model.setValue(FIELD_ENTITYDESCRIPTION, data.get(FIELD_ENTITYDESCRIPTION), i);
                    model.setValue(FIELD_ISMUSTINPUT, data.get(FIELD_ISMUSTINPUT), i);
                    model.setValue(FIELD_ISIMPORT, data.get(FIELD_ISIMPORT), i);
                    model.setValue(FIELD_COOLWIDTH, data.get(FIELD_COOLWIDTH), i);
                    model.setValue(FIELD_SOURCE_NAME, data.get(FIELD_SOURCE_NAME), i);
                    model.setValue(FIELD_SOURCE_ENTITY, data.get(FIELD_SOURCE_ENTITY), i);
                    if (isbasedata) {
                        model.setValue(FIELD_IMPORTPROP, isImport ? data.get(FIELD_IMPORTPROP) : "", i);
                        this.setExportProps(model, StringUtils.isNotBlank((Object)data.get(EXPORTPROP)) ? Arrays.asList(data.get(EXPORTPROP).toString().split(",")) : null, i);
                    } else if (isdate) {
                        model.setValue(FIELD_IMPORTPROP, isImport ? data.get(FIELD_IMPORTPROP) : "", i);
                        this.setExportFormat(model, StringUtils.isNotBlank((Object)data.get(EXPORTFORMATNAME)) ? Arrays.asList(data.get(EXPORTFORMAT).toString().split(",")) : null, i);
                    } else {
                        model.setValue(FIELD_IMPORTPROP, null, i);
                        this.setExportProps(model, null, i);
                    }
                }
            }
            if (!isbasedata) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{FIELD_IMPORTPROP, EXPORTPROPNAME});
            }
            if (!isdate) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{EXPORTFORMATNAME});
            }
            ++i;
        }
    }

    private void rebuildAttachmentPanelTreeValueAndStyle(Map<String, Map<String, Object>> dataMap) {
        if (MapUtils.isEmpty(dataMap)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection collection = model.getEntryEntity(ATT_PANEL_TREE_ENTRY);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        String curEntityNumber = "";
        int index = 0;
        for (DynamicObject dynamicObject : collection) {
            long pid = dynamicObject.getLong(FIELD_PID);
            String attNumber = dynamicObject.getString(ATT_NUMBER);
            String fullNumber = curEntityNumber;
            if (pid == 0L) {
                curEntityNumber = ATT_PANEL_TREE_ENTRY + attNumber;
            } else {
                fullNumber = curEntityNumber + "." + attNumber;
            }
            Map<String, Object> rowMap = dataMap.get(fullNumber);
            if (MapUtils.isNotEmpty(rowMap)) {
                model.setValue(ATT_COL_WIDTH, rowMap.get(ATT_COL_WIDTH), index);
                model.setValue(ATT_DESCRIPTION, rowMap.get(ATT_DESCRIPTION), index);
                model.setValue(ATT_IS_INPUT, rowMap.get(ATT_IS_INPUT), index);
                model.setValue(ATT_IS_IMPORT, rowMap.get(ATT_IS_IMPORT), index);
            }
            ++index;
        }
        this.rebuildImportAndInputCheck();
    }

    private void rebuildImportAndInputCheck() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ATT_PANEL_TREE_ENTRY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        boolean isAllImport = true;
        boolean isAllInput = true;
        int entityRow = 0;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject row = (DynamicObject)entryEntity.get(i);
            long pid = row.getLong(FIELD_PID);
            if (pid == 0L) {
                if (i > 0) {
                    model.setValue(ATT_IS_INPUT, (Object)isAllInput, entityRow);
                    model.setValue(ATT_IS_IMPORT, (Object)isAllImport, entityRow);
                }
                entityRow = i;
                isAllImport = true;
                isAllInput = true;
                continue;
            }
            if (!row.getBoolean(ATT_IS_INPUT)) {
                isAllInput = false;
            }
            if (row.getBoolean(ATT_IS_IMPORT)) continue;
            isAllImport = false;
        }
        model.setValue(ATT_IS_INPUT, (Object)isAllInput, entityRow);
        model.setValue(ATT_IS_IMPORT, (Object)isAllImport, entityRow);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        String propertyName = e.getProperty().getName();
        int row = e.getChangeSet()[0].getRowIndex();
        boolean isimport = FIELD_ISIMPORT.equalsIgnoreCase(propertyName);
        if (FIELD_BIZOBJ.equalsIgnoreCase(propertyName)) {
            DynamicObject bizObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (bizObj != null) {
                String entityId = bizObj.getString(((BasedataEntityType)bizObj.getDataEntityType()).getNumberProperty());
                this.setDefaultNumber(entityId);
                this.initApplyLayoutCombo(entityId);
                this.getModel().setValue(APPLY_LAYOUT, (Object)"");
                this.getView().getFormShowParameter().setCustomParam(PARAM_BINDENTITYID, (Object)entityId);
                this.getView().getFormShowParameter().setCustomParam(PARAM_CUSTOMTEMPLATE, (Object)Boolean.TRUE);
                this.buildBillTreeFieldsExt(model, entityId, null);
                this.rebuildFieldTreeValueAndStyle(model, null, isimport);
            }
        } else if (isimport || FIELD_ISMUSTINPUT.equalsIgnoreCase(propertyName)) {
            boolean isCheckMustInput;
            String controlfield;
            boolean val = (Boolean)model.getValue(propertyName, row);
            boolean isField = Boolean.TRUE.equals(model.getValue(FIELD_ISFIELD, row));
            if (!isField) {
                ImportPluginUtils.checkChildren(model, proxy, propertyName, val, row, TREEENTRYENTITY);
            }
            if (StringUtils.isNotBlank((CharSequence)(controlfield = (String)model.getValue(FIELD_CONTROLFIELD, row)))) {
                this.handleControlField(model, proxy, controlfield, propertyName, val);
            } else if (!val) {
                String fieldName = (String)model.getValue(FIELD_ENTITYNUMBER, row);
                String controlFieldsCache = this.getPageCache().get(fieldName);
                if (StringUtils.isNotBlank((CharSequence)controlFieldsCache)) {
                    List controlFieldRks = JSON.parseArray((String)controlFieldsCache, Integer.class);
                    for (Integer rk : controlFieldRks) {
                        model.setValue(propertyName, (Object)val, rk.intValue());
                    }
                }
            }
            ImportPluginUtils.checkParent(model, proxy, propertyName, val, row, TREEENTRYENTITY);
            boolean bl = isCheckMustInput = !isimport && val;
            if (isCheckMustInput) {
                String syncPropertyName = FIELD_ISIMPORT;
                model.setValue(syncPropertyName, (Object)val, row);
                if (!isField) {
                    ImportPluginUtils.checkChildren(model, proxy, syncPropertyName, val, row, TREEENTRYENTITY);
                }
                ImportPluginUtils.checkParent(model, proxy, syncPropertyName, val, row, TREEENTRYENTITY);
            }
        } else if (FIELD_TEMPLATETYPE.equalsIgnoreCase(propertyName)) {
            String bizEntityId = (String)model.getValue(FIELD_BIZOBJ_ID);
            boolean isImport = TEMPLATETYPE_IMPT.equals(e.getChangeSet()[0].getNewValue());
            if (StringUtils.isNotBlank((CharSequence)bizEntityId)) {
                this.setDefaultNumber(bizEntityId);
                this.buildBillTreeFieldsExt(model, bizEntityId, null);
                this.rebuildFieldTreeValueAndStyle(model, null, isImport);
            }
            this.setImportOrExportColumnTitle(isImport);
            this.getView().setVisible(Boolean.valueOf(isImport), new String[]{FIELD_ISMUSTINPUT, PANEL_ATTACHMENT, BTN_DOWNLOAD, FIELD_IMPORTPROP, PANEL_PARAM, ATT_IS_INPUT, FIELD_ENTITYDESCRIPTION});
            this.getView().setVisible(Boolean.valueOf(!isImport), new String[]{EXPORTFORMATNAME});
            this.setExportPropNameTips(isImport);
        } else if ("applyscope".equalsIgnoreCase(propertyName)) {
            this.hideUsersIfNotSpecScope(model);
        } else if (StringUtils.equals((CharSequence)ATT_IS_IMPORT, (CharSequence)propertyName) || StringUtils.equals((CharSequence)ATT_IS_INPUT, (CharSequence)propertyName)) {
            int[] entityRows;
            boolean val = (Boolean)model.getValue(propertyName, row);
            ImportPluginUtils.checkParent(model, proxy, propertyName, val, row, ATT_PANEL_TREE_ENTRY);
            ImportPluginUtils.checkChildren(model, proxy, propertyName, val, row, ATT_PANEL_TREE_ENTRY);
            if (StringUtils.equals((CharSequence)ATT_IS_INPUT, (CharSequence)propertyName) && val) {
                model.setValue(ATT_IS_IMPORT, (Object)val, row);
            }
            for (int entityRow : entityRows = this.getAttPanelEntityRows()) {
                this.getView().setEnable(Boolean.valueOf(false), entityRow, new String[]{ATT_COL_WIDTH, ATT_DESCRIPTION});
            }
            this.getView().updateView(ATT_PANEL_TREE_ENTRY);
        }
    }

    private void setImportOrExportColumnTitle(boolean isImport) {
        EntryGrid grid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        grid.setColumnProperty(FIELD_ISIMPORT, "header", (Object)new LocaleString(isImport ? this.RES_IF_IMPORT : this.RES_IF_EXPORT));
        EntryGrid attGrid = (EntryGrid)this.getControl(ATT_PANEL_TREE_ENTRY);
        attGrid.setColumnProperty(ATT_IS_IMPORT, "header", (Object)new LocaleString(isImport ? this.RES_IF_IMPORT : this.RES_IF_EXPORT));
    }

    private void handleControlField(IDataModel model, IClientViewProxy proxy, String controlfield, String propertyName, boolean val) {
        if (!val) {
            return;
        }
        int count = model.getEntryRowCount(TREEENTRYENTITY);
        for (int i = 0; i < count; ++i) {
            String entityName = (String)model.getValue(FIELD_ENTITYNUMBER, i);
            if (!controlfield.equals(entityName)) continue;
            model.beginInit();
            model.setValue(propertyName, (Object)val, i);
            model.endInit();
            ImportPluginUtils.update(proxy, propertyName, val, i);
            break;
        }
    }

    private void setDefaultNumber(String entityId) {
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            String billno = entityId + "_" + this.getModel().getValue(FIELD_TEMPLATETYPE);
            String currentIsv = ISVService.getISVInfo().getId();
            if ("kingdee".equals(currentIsv)) {
                billno = billno + "_S";
            }
            this.getModel().setValue(FIELD_NUMBER, (Object)billno);
        }
    }

    private void buildBillTreeFieldsExt(IDataModel model, String number, Map<String, Map<String, Object>> dataMap) {
        model.beginInit();
        model.deleteEntryData(TREEENTRYENTITY);
        model.deleteEntryData(ATT_PANEL_TREE_ENTRY);
        model.endInit();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        ArrayList<MainEntityType> entityTypes = new ArrayList<MainEntityType>();
        boolean isQueryEntity = false;
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            entityTypes.add(queryType.getMainEntityType());
            entityTypes.addAll(queryType.getAllJoinEntityType());
            isQueryEntity = true;
        } else {
            entityTypes.add(mainType);
        }
        Map<String, MainEntityType> mainEntityMap = entityTypes.stream().collect(Collectors.toMap(DynamicObjectType::getName, entityType -> entityType));
        this.setMovedAcrossPropMap(dataMap, mainEntityMap);
        for (MainEntityType mainEntityType : entityTypes) {
            this.getPageCache().put("rootEntityNumber", mainEntityType.getName());
            List<ControlAp<?>> controlAps = this.getFormMetadata(mainEntityType.getName());
            this.buildFldTreeRowExt(controlAps, mainEntityType, dataMap);
            this.buildAttachmentPanelTreeEntry(controlAps, mainEntityType, dataMap);
        }
        boolean isImport = TEMPLATETYPE_IMPT.equalsIgnoreCase((String)model.getValue(FIELD_TEMPLATETYPE));
        this.getView().setVisible(Boolean.valueOf(isQueryEntity && isImport), new String[]{FIELD_SOURCE_NAME});
        this.getView().updateView(TREEENTRYENTITY);
        this.getView().updateView(ATT_PANEL_TREE_ENTRY);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        grid.setCollapse(false);
        TreeEntryGrid attGrid = (TreeEntryGrid)this.getControl(ATT_PANEL_TREE_ENTRY);
        attGrid.setCollapse(false);
    }

    private void buildAttachmentPanelTreeEntry(List<ControlAp<?>> controlAps, MainEntityType mainEntityType, Map<String, Map<String, Object>> dataMap) {
        if (CollectionUtils.isEmpty(controlAps)) {
            return;
        }
        ArrayList<AttachmentPanelAp> attachmentPanelAps = new ArrayList<AttachmentPanelAp>();
        controlAps.forEach(controlAp -> {
            if (controlAp instanceof AttachmentPanelAp) {
                attachmentPanelAps.add((AttachmentPanelAp)controlAp);
            }
        });
        if (CollectionUtils.isEmpty(attachmentPanelAps)) {
            return;
        }
        int entityRow = this.initAttachmentPanelEntityRow(mainEntityType, dataMap);
        this.initAttachmentPanelRows(attachmentPanelAps, entityRow, mainEntityType, dataMap);
    }

    private int initAttachmentPanelEntityRow(MainEntityType mainEntityType, Map<String, Map<String, Object>> dataMap) {
        IDataModel model = this.getModel();
        model.beginInit();
        int newEntityRow = model.createNewEntryRow(ATT_PANEL_TREE_ENTRY);
        model.endInit();
        model.setValue(ATT_NAME, (Object)mainEntityType.getDisplayName().getLocaleValue(), newEntityRow);
        model.setValue(ATT_NUMBER, (Object)mainEntityType.getName(), newEntityRow);
        this.fillExistingRowIdAndPid(model, ATT_PANEL_TREE_ENTRY + mainEntityType.getName(), dataMap, ATT_PANEL_TREE_ENTRY, newEntityRow);
        this.getView().setEnable(Boolean.valueOf(false), newEntityRow, new String[]{ATT_COL_WIDTH, ATT_DESCRIPTION});
        this.cacheAttPanelEntityRows(newEntityRow);
        return newEntityRow;
    }

    private void cacheAttPanelEntityRows(int newEntityRow) {
        String rows = this.getPageCache().get(ATT_PANEL_ENTITY_ROWS);
        rows = StringUtils.isNotBlank((CharSequence)rows) ? rows + "," + newEntityRow : String.valueOf(newEntityRow);
        this.getPageCache().put(ATT_PANEL_ENTITY_ROWS, rows);
    }

    private int[] getAttPanelEntityRows() {
        String rows = this.getPageCache().get(ATT_PANEL_ENTITY_ROWS);
        if (StringUtils.isBlank((CharSequence)rows)) {
            return new int[]{0};
        }
        String[] split = rows.split(",");
        int[] cacheRows = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            cacheRows[i] = Integer.parseInt(split[i]);
        }
        return cacheRows;
    }

    private void initAttachmentPanelRows(List<AttachmentPanelAp> attachmentPanelAps, int entityRow, MainEntityType mainEntityType, Map<String, Map<String, Object>> dataMap) {
        IDataModel model = this.getModel();
        model.beginInit();
        int[] insertEntryRow = model.batchInsertEntryRow(ATT_PANEL_TREE_ENTRY, entityRow, attachmentPanelAps.size());
        model.endInit();
        for (int i = 0; i < attachmentPanelAps.size(); ++i) {
            AttachmentPanelAp attachmentPanelAp = attachmentPanelAps.get(i);
            model.setValue(ATT_NAME, (Object)attachmentPanelAp.getName().getLocaleValue(), insertEntryRow[i]);
            model.setValue(ATT_NUMBER, (Object)attachmentPanelAp.getKey(), insertEntryRow[i]);
            String fullNumber = ATT_PANEL_TREE_ENTRY + mainEntityType.getName() + "." + attachmentPanelAp.getKey();
            this.fillExistingRowIdAndPid(model, fullNumber, dataMap, ATT_PANEL_TREE_ENTRY, insertEntryRow[i]);
        }
    }

    private void setMovedAcrossPropMap(Map<String, Map<String, Object>> dataMap, Map<String, MainEntityType> mainEntityMap) {
        if (dataMap == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> entry : dataMap.entrySet()) {
            String field = entry.getKey();
            Map<String, Object> dataValue = entry.getValue();
            Object source = dataValue.get(FIELD_SOURCE_ENTITY);
            if (StringUtils.isBlank((Object)source)) continue;
            String[] strings = StringUtils.split((String)field, (String)".");
            String targetEntity = (String)dataValue.get(FIELD_TARGET_ENTITY);
            Map<String, IDataEntityProperty> entityProp = this.acrossPropMap.get(targetEntity);
            if (entityProp == null) {
                entityProp = new HashMap<String, IDataEntityProperty>(1);
            }
            entityProp.put(field, mainEntityMap.get(strings[0]).findProperty(strings[1]));
            this.acrossPropMap.put(targetEntity, entityProp);
        }
    }

    private void buildFldTreeRowExt(List<ControlAp<?>> controlAps, MainEntityType mainType, Map<String, Map<String, Object>> dataMap) {
        IDataModel model = this.getModel();
        List<EntityItem<?>> newItems = this.filterEntityItems(model, mainType);
        model.beginInit();
        Integer[] pRow = new Integer[]{model.createNewEntryRow(TREEENTRYENTITY), null};
        model.endInit();
        this.fillExistingRowIdAndPid(model, mainType.getName(), dataMap, TREEENTRYENTITY, pRow[0]);
        this.entityIndexMapping.put(mainType.getName(), pRow);
        this.fillPartialFieldsInfo(model, mainType.getDisplayName().toString(), mainType.getName(), pRow[0]);
        this.buildEntryTreeRow(model, mainType, dataMap, newItems, controlAps, pRow);
    }

    private void buildEntryTreeRow(IDataModel model, MainEntityType mainType, Map<String, Map<String, Object>> dataMap, List<EntityItem<?>> newItems, List<ControlAp<?>> aps, Integer[] pRow) {
        boolean[] isAllCheck = new boolean[]{false};
        int[] row = new int[]{-1};
        HashMap entrys = new HashMap();
        String rootEntityNumber = this.getPageCache().get("rootEntityNumber");
        Set entryMap = mainType.getAllEntities().entrySet();
        if (MapUtils.isNotEmpty(dataMap)) {
            for (Map.Entry entry : entryMap) {
                String entityName = (String)entry.getKey();
                String propFullName = StringUtils.equals((CharSequence)rootEntityNumber, (CharSequence)entityName) ? entityName : rootEntityNumber + "." + entityName;
                if (!dataMap.containsKey(propFullName)) continue;
                Integer seq = Integer.parseInt(dataMap.get(propFullName).get(FIELD_SEQ) + "");
                entrys.put(seq, entry);
            }
            Set seq = entrys.keySet();
            Object[] objectArray = seq.toArray(new Integer[0]);
            Arrays.sort(objectArray);
            for (Object eSeq : objectArray) {
                Map.Entry entry = (Map.Entry)entrys.get(eSeq);
                this.buildEntryCollection(entry);
                this.entitySortAndBulid(model, mainType, dataMap, newItems, aps, pRow, row, isAllCheck, entry);
            }
        } else {
            for (Map.Entry<String, EntityType> entry : mainType.getAllEntities().entrySet()) {
                this.buildEntryCollection(entry);
                this.entitySortAndBulid(model, mainType, dataMap, newItems, aps, pRow, row, isAllCheck, entry);
            }
        }
        this.getPageCache().put("entryCollection", this.entryCollection.toString());
        this.getPageCache().put("subEntryCollection", this.subEntryCollection.toString());
        if (row[0] > 0) {
            model.beginInit();
            model.deleteEntryRow(TREEENTRYENTITY, row[0]);
            model.endInit();
        }
        if (isAllCheck[0]) {
            model.setValue(FIELD_ISMUSTINPUT, (Object)Boolean.TRUE, pRow[0].intValue());
            model.setValue(FIELD_ISIMPORT, (Object)Boolean.TRUE, pRow[0].intValue());
        }
    }

    private void buildEntryCollection(Map.Entry<String, EntityType> entry) {
        if (entry.getValue() instanceof SubEntryType) {
            this.subEntryCollection.add(entry.getKey());
        } else if (entry.getValue() instanceof EntryType) {
            this.entryCollection.add(entry.getKey());
        }
    }

    private void entitySortAndBulid(IDataModel model, MainEntityType mainType, Map<String, Map<String, Object>> dataMap, List<EntityItem<?>> newItems, List<ControlAp<?>> aps, Integer[] pRow, int[] row, boolean[] isAllCheck, Map.Entry<String, EntityType> entry) {
        IDataEntityType parentType;
        EntityType entityType = entry.getValue();
        if (entityType instanceof LinkEntryType || entityType instanceof NameVersionEntryType) {
            return;
        }
        String entityNodeId = entityType.getName();
        String entityNodeName = "";
        if (entityType.getDisplayName() != null) {
            entityNodeName = entityType.getDisplayName().toString();
        }
        if (entityType instanceof MainEntityType) {
            entityNodeName = this.RES_BILLHEAD_NAME;
            entityNodeId = BILL_HEAD;
        }
        pRow = this.entityIndexMapping.get((parentType = entityType.getParent()) != null ? parentType.getName() : entityType.getName());
        if (row[0] < 0) {
            model.beginInit();
            row[0] = model.insertEntryRow(TREEENTRYENTITY, pRow[0].intValue());
            model.endInit();
        }
        this.fillExistingRowIdAndPid(model, mainType.getName() + "." + entityNodeId, dataMap, TREEENTRYENTITY, row[0]);
        List<IDataEntityProperty> properties = entityType.getFields().values().stream().filter(prop -> entityType instanceof QueryEntityType && !(prop instanceof JoinProperty) || this.isPropertyImport(newItems, (IDataEntityProperty)prop)).collect(Collectors.toList());
        this.getSortProperties(properties, aps, dataMap != null ? dataMap.keySet() : null, entityType);
        boolean isAllChildrenCheck = true;
        if (!properties.isEmpty()) {
            isAllChildrenCheck = this.buildEntryFieldTreeRow(model, mainType, dataMap, row[0], entry.getKey(), entityNodeId, entityNodeName, properties);
            if (!isAllChildrenCheck) {
                isAllCheck[0] = Boolean.FALSE;
            }
            row[0] = -1;
        }
    }

    private boolean buildEntryFieldTreeRow(IDataModel model, MainEntityType mainType, Map<String, Map<String, Object>> dataMap, int row, String entryKey, String entityNodeId, String entityNodeName, List<IDataEntityProperty> properties) {
        boolean isAllChildrenCheck = true;
        model.beginInit();
        int[] rows = model.batchInsertEntryRow(TREEENTRYENTITY, row, properties.size());
        model.endInit();
        int i = 0;
        for (IDataEntityProperty property : properties) {
            if (!this.BuildFldTreeNode(model, property, rows[i], mainType, dataMap)) {
                isAllChildrenCheck = false;
            }
            ++i;
        }
        this.fillPartialFieldsInfo(model, entityNodeName, entityNodeId, row);
        model.setValue(FIELD_ISMUSTINPUT, (Object)isAllChildrenCheck, row);
        model.setValue(FIELD_ISIMPORT, (Object)isAllChildrenCheck, row);
        if (!this.entityIndexMapping.containsKey(entryKey)) {
            this.entityIndexMapping.put(entryKey, new Integer[]{row, rows[rows.length - 1]});
        }
        return isAllChildrenCheck;
    }

    private void fillPartialFieldsInfo(IDataModel model, String entityName, String entityNumber, int row) {
        model.setValue(FIELD_ENTITYNAME, (Object)entityName, row);
        model.setValue(FIELD_ENTITYNUMBER, (Object)entityNumber, row);
        model.setValue(FIELD_ISFIELD, (Object)Boolean.FALSE, row);
        this.getView().setEnable(Boolean.FALSE, row, new String[]{FIELD_IMPORTPROP, EXPORTPROPNAME});
    }

    private List<EntityItem<?>> filterEntityItems(IDataModel model, MainEntityType mainType) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        boolean isEXPT = TEMPLATETYPE_EXPT.equalsIgnoreCase((String)model.getValue(FIELD_TEMPLATETYPE));
        return entityItems.stream().filter(item -> item instanceof Field && (isEXPT ? ((Field)item).getFeatures().isExportable() : ((Field)item).getFeatures().isImportable())).collect(Collectors.toList());
    }

    private void fillExistingRowIdAndPid(IDataModel model, String nodeName, Map<String, Map<String, Object>> dataMap, String entryEntity, int row) {
        if (dataMap != null && !dataMap.isEmpty()) {
            DynamicObject rowObj = model.getEntryRowEntity(entryEntity, row);
            Map<String, Object> rootData = dataMap.get(nodeName);
            if (rootData != null) {
                rowObj.set(FIELD_ID, rootData.get(FIELD_ID));
                rowObj.set(FIELD_PID, rootData.get(FIELD_PID));
            }
        }
    }

    private boolean isPropertyImport(List<EntityItem<?>> newItems, IDataEntityProperty prop) {
        if (prop instanceof AttachmentCountProp || prop instanceof RichTextProp || FIELD_ID.equalsIgnoreCase(prop.getName()) || FIELD_SEQ.equalsIgnoreCase(prop.getName())) {
            return false;
        }
        String controlKey = null;
        if (prop instanceof FlexProp) {
            controlKey = ((FlexProp)prop).getBasePropertyKey();
        } else if (prop instanceof ItemClassProp) {
            controlKey = ((ItemClassProp)prop).getTypePropName();
        }
        boolean existControlField = false;
        boolean existProp = false;
        for (EntityItem<?> item : newItems) {
            DateRangeField field;
            if (item instanceof DateRangeField) {
                field = (DateRangeField)item;
                if (field.getStartDateFieldKey().equals(prop.getName()) || field.getEndDateFieldKey().equals(prop.getName())) {
                    this.dataRangeMap.put(prop.getParent().getName() + "." + prop.getName(), field.getKey());
                    existProp = true;
                    break;
                }
            } else if (item instanceof TimeRangeField && ((field = (TimeRangeField)item).getStartDateFieldKey().equals(prop.getName()) || field.getEndDateFieldKey().equals(prop.getName()))) {
                this.dataRangeMap.put(prop.getParent().getName() + "." + prop.getName(), field.getKey());
                existProp = true;
                break;
            }
            if (controlKey != null && controlKey.equals(item.getKey())) {
                existControlField = true;
            }
            if (!prop.getName().equals(item.getKey())) continue;
            existProp = true;
            if (controlKey != null && !existControlField) continue;
            break;
        }
        return existProp && (controlKey == null || existControlField);
    }

    private void getSortProperties(List<IDataEntityProperty> properties, List<ControlAp<?>> aps, Set<String> currSort, EntityType entityType) {
        int j = 0;
        block0: for (ControlAp<?> ap : aps) {
            if (!(ap instanceof FieldAp)) continue;
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty prop = properties.get(i);
                if (ap.getKey().equals(prop.getName())) {
                    Collections.swap(properties, i, j++);
                    continue block0;
                }
                IDataEntityType rootEntityType = prop.getParent();
                while (rootEntityType.getParent() != null) {
                    rootEntityType = rootEntityType.getParent();
                }
                String propFullName = rootEntityType.getName() + "." + prop.getName();
                if (!this.dataRangeMap.containsKey(propFullName) || !this.dataRangeMap.get(propFullName).equals(ap.getKey())) continue;
                Collections.swap(properties, i, j++);
            }
        }
        ArrayList<Object> mustInputProps = new ArrayList<Object>();
        ArrayList<IDataEntityProperty> notMustInputProps = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty propertie : properties) {
            if (propertie instanceof FieldProp && ((FieldProp)propertie).isMustInput()) {
                mustInputProps.add(propertie);
                continue;
            }
            notMustInputProps.add(propertie);
        }
        mustInputProps.addAll(notMustInputProps);
        properties.clear();
        properties.addAll(mustInputProps);
        if (currSort != null) {
            this.sortPropertiesByDataMap(properties, currSort, entityType);
            this.getNewPropMap(properties, currSort, entityType);
        }
        if (entityType != null && !TEMPLATETYPE_EXPT.equalsIgnoreCase((String)this.getModel().getValue(FIELD_TEMPLATETYPE))) {
            if (entityType instanceof TreeEntryType) {
                properties.add(0, (IDataEntityProperty)entityType.getProperty(FIELD_PID));
            }
            properties.add(0, (IDataEntityProperty)entityType.getPrimaryKey());
        }
    }

    private void sortPropertiesByDataMap(List<IDataEntityProperty> properties, Set<String> currSort, EntityType entityType) {
        String rootEntityNumber = this.getPageCache().get("rootEntityNumber");
        int j = 0;
        ArrayList<String> currSortList = new ArrayList<String>(currSort);
        if (currSortList.size() > 0) {
            String pkFullName = entityType.getName() + "." + entityType.getPrimaryKey().getName();
            if (!(entityType instanceof MainEntityType)) {
                pkFullName = rootEntityNumber + "." + pkFullName;
            }
            if (!currSortList.contains(pkFullName)) {
                currSortList.add(1, pkFullName);
            }
            if (entityType instanceof MainEntityType) {
                this.handleAcrossedProperties(properties, rootEntityNumber);
            }
            block0: for (String key : currSortList) {
                for (int i = 0; i < properties.size(); ++i) {
                    IDataEntityProperty prop = properties.get(i);
                    String propFullName = prop.getName().equals(entityType.getPrimaryKey().getName()) ? pkFullName : rootEntityNumber + "." + prop.getName();
                    String newProp = prop.getParent().getName() + "." + prop.getName();
                    if (this.acrossPropMap.containsKey(rootEntityNumber) && this.acrossPropMap.get(rootEntityNumber).containsKey(newProp)) {
                        propFullName = newProp;
                    }
                    if (key.equals(propFullName)) {
                        Collections.swap(properties, i, j++);
                        continue block0;
                    }
                    if (!this.dataRangeMap.containsKey(propFullName) || !this.dataRangeMap.get(propFullName).equals(key)) continue;
                    Collections.swap(properties, i, j++);
                }
            }
        }
    }

    private String setPropFullName(EntityType entityType, IDataEntityProperty prop) {
        String rootEntityNumber = this.getPageCache().get("rootEntityNumber");
        String pkFullName = entityType.getName() + "." + entityType.getPrimaryKey().getName();
        if (!(entityType instanceof MainEntityType)) {
            pkFullName = rootEntityNumber + "." + pkFullName;
        }
        String propFullName = prop.getName().equals(entityType.getPrimaryKey().getName()) ? pkFullName : rootEntityNumber + "." + prop.getName();
        return propFullName;
    }

    private void getNewPropMap(List<IDataEntityProperty> properties, Set<String> currSort, EntityType entityType) {
        ArrayList<String> currSortList = new ArrayList<String>(currSort);
        if (currSortList.size() > 0) {
            boolean isNewPropMap = false;
            for (String key : currSortList) {
                for (int i = 0; i < properties.size(); ++i) {
                    IDataEntityProperty prop = properties.get(i);
                    String propFullName = this.setPropFullName(entityType, prop);
                    if (isNewPropMap || this.newPropMap.containsKey(propFullName)) continue;
                    this.newPropMap.put(propFullName, prop);
                }
                isNewPropMap = true;
                this.newPropMap.remove(key);
            }
        }
    }

    private void handleAcrossedProperties(List<IDataEntityProperty> properties, String rootEntityNumber) {
        for (Map.Entry<String, Map<String, IDataEntityProperty>> entry : this.acrossPropMap.entrySet()) {
            String entityNumber = entry.getKey();
            if (!StringUtils.equals((CharSequence)rootEntityNumber, (CharSequence)entityNumber)) {
                for (IDataEntityProperty property : entry.getValue().values()) {
                    properties.remove(property);
                }
                continue;
            }
            if (!this.acrossPropMap.containsKey(rootEntityNumber)) continue;
            for (IDataEntityProperty property : this.acrossPropMap.get(rootEntityNumber).values()) {
                if (property == null) continue;
                properties.add(property);
            }
        }
    }

    private List<ControlAp<?>> getFormMetadata(String formId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List aps = formMetadata.getItems();
        Collections.sort(aps, new Comparator<ControlAp<?>>(){

            @Override
            public int compare(ControlAp<?> o1, ControlAp<?> o2) {
                int compareValue = 0;
                compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
                if (compareValue != 0) {
                    return compareValue;
                }
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
        return aps;
    }

    private boolean BuildFldTreeNode(IDataModel model, IDataEntityProperty fldProperty, int row, MainEntityType mainType, Map<String, Map<String, Object>> dataMap) {
        String controlfield;
        ArrayList<String> defaultItemCaption;
        ArrayList<String> defaultItemValue;
        List<ComboItem> defaultItem;
        DynamicProperty prop = (DynamicProperty)fldProperty;
        String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
        String entityNumber = prop.getName();
        if (prop == prop.getParent().getPrimaryKey()) {
            fldNodeName = this.RES_ID_NAME;
            if (prop.getParent() instanceof EntryType) {
                entityNumber = prop.getParent().getName() + "." + prop.getName();
            }
        } else if (prop.getName().equals(FIELD_PID) && prop.getParent() instanceof TreeEntryType) {
            fldNodeName = ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ImportTemplatePlugin_13", (String)BOS_IMPORT, (Object[])new Object[0]);
            entityNumber = prop.getParent().getName() + "." + prop.getName();
        }
        if (fldProperty instanceof FieldProp && ((FieldProp)fldProperty).isMustInput() || fldProperty instanceof BasedataProp && ((BasedataProp)fldProperty).isMustInput() || fldProperty instanceof MulBasedataProp && ((MulBasedataProp)fldProperty).isMustInput()) {
            fldNodeName = fldNodeName + "*";
        }
        boolean isbasedata = false;
        boolean isdate = false;
        if (fldProperty instanceof FlexProp) {
            isbasedata = false;
        } else if (fldProperty instanceof AttachmentProp) {
            isbasedata = false;
        } else if (fldProperty instanceof IBasedataField) {
            isbasedata = true;
        } else if (fldProperty instanceof DateTimeProp || fldProperty instanceof TimeProp) {
            isdate = true;
        }
        if (isbasedata) {
            defaultItem = this.cacheRefProps(fldProperty);
            defaultItemValue = new ArrayList<String>(defaultItem.size());
            defaultItemCaption = new ArrayList<String>(defaultItem.size());
            for (ComboItem item : defaultItem) {
                defaultItemValue.add(item.getValue());
                defaultItemCaption.add(item.getCaption().toString());
            }
            if (TEMPLATETYPE_IMPT.equals(model.getValue(FIELD_TEMPLATETYPE))) {
                model.setValue(FIELD_IMPORTPROP, (Object)FIELD_NUMBER, row);
            } else {
                model.setValue(FIELD_IMPORTPROP, null, row);
            }
            if (defaultItem != null) {
                model.setValue(EXPORTPROP, (Object)String.join((CharSequence)",", defaultItemValue), row);
                model.setValue(EXPORTPROPNAME, (Object)String.join((CharSequence)",", defaultItemCaption), row);
            }
            model.setValue(FIELD_ISBASEDATA, (Object)isbasedata, row);
        } else if (isdate) {
            defaultItem = this.cacheDateEptFormat(fldProperty);
            defaultItemValue = new ArrayList(defaultItem.size());
            defaultItemCaption = new ArrayList(defaultItem.size());
            for (ComboItem item : defaultItem) {
                defaultItemValue.add(item.getValue());
                defaultItemCaption.add(item.getCaption().toString());
            }
            if (defaultItem != null) {
                model.setValue(EXPORTFORMAT, (Object)String.join((CharSequence)",", defaultItemValue), row);
                model.setValue(EXPORTFORMATNAME, (Object)String.join((CharSequence)",", defaultItemCaption), row);
            }
            model.setValue(FIELD_ISDATE, (Object)isdate, row);
        } else {
            model.setValue(FIELD_IMPORTPROP, null, row);
            model.setValue(EXPORTPROP, null, row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{FIELD_IMPORTPROP, EXPORTPROPNAME});
            model.setValue(FIELD_ISBASEDATA, (Object)Boolean.FALSE, row);
            model.setValue(FIELD_ISDATE, (Object)Boolean.FALSE, row);
        }
        if (dataMap != null) {
            DynamicObject rowObj = model.getEntryRowEntity(TREEENTRYENTITY, row);
            this.restoreExistedRowInfo(mainType, dataMap, prop, entityNumber, rowObj);
        }
        model.setValue(FIELD_ENTITYNAME, (Object)fldNodeName, row);
        boolean ismustinput = fldNodeName.endsWith("*");
        String propFullName = this.setPropFullName((EntityType)mainType, (IDataEntityProperty)prop);
        boolean isNewProp = this.newPropMap.containsKey(propFullName);
        if (ismustinput && !isNewProp) {
            model.setValue(FIELD_ISMUSTINPUT, (Object)Boolean.TRUE, row);
            model.setValue(FIELD_ISIMPORT, (Object)Boolean.TRUE, row);
        }
        model.setValue(FIELD_ENTITYNUMBER, (Object)entityNumber, row);
        model.setValue(FIELD_ISFIELD, (Object)Boolean.TRUE, row);
        if (prop instanceof ItemClassProp) {
            controlfield = ((ItemClassProp)prop).getTypePropName();
            this.cacheControlField(model, controlfield, row);
        } else if (prop instanceof FlexProp) {
            controlfield = ((FlexProp)prop).getBasePropertyKey();
            this.cacheControlField(model, controlfield, row);
        }
        return ismustinput;
    }

    private void restoreExistedRowInfo(MainEntityType mainType, Map<String, Map<String, Object>> dataMap, DynamicProperty prop, String entityNumber, DynamicObject rowObj) {
        Map<String, Object> fieldRow;
        String mainEntityName = mainType.getName();
        String fullPropNumber = mainEntityName + "." + entityNumber;
        String curPropNumber = prop.getParent().getName() + "." + entityNumber;
        boolean isAcross = false;
        if (this.acrossPropMap.containsKey(mainEntityName) && this.acrossPropMap.get(mainEntityName).containsKey(curPropNumber)) {
            fullPropNumber = curPropNumber;
            isAcross = true;
        }
        if ((fieldRow = dataMap.get(fullPropNumber)) != null) {
            if (!isAcross) {
                rowObj.set(FIELD_ID, fieldRow.get(FIELD_ID));
                rowObj.set(FIELD_PID, fieldRow.get(FIELD_PID));
            }
            rowObj.set(FIELD_SOURCE_ENTITY, fieldRow.get(FIELD_SOURCE_ENTITY));
            rowObj.set(FIELD_SOURCE_NAME, fieldRow.get(FIELD_SOURCE_NAME));
        }
    }

    private void cacheControlField(IDataModel model, String controlfield, int row) {
        if (StringUtils.isNotBlank((CharSequence)controlfield)) {
            String controlFieldsCache = this.getPageCache().get(controlfield);
            List<Integer> rks = StringUtils.isNotBlank((CharSequence)controlFieldsCache) ? JSON.parseArray((String)controlFieldsCache, Integer.class) : new ArrayList();
            rks.add(row);
            this.getPageCache().put(controlfield, JSON.toJSONString(rks));
            model.setValue(FIELD_CONTROLFIELD, (Object)controlfield, row);
        }
    }

    private List<ComboItem> cacheRefProps(IDataEntityProperty fldProperty) {
        String templateType = (String)this.getModel().getValue(FIELD_TEMPLATETYPE);
        ArrayList<ComboItem> dispComboList = new ArrayList<ComboItem>();
        ComboItem dispCombo = null;
        ArrayList<ComboItem> refItems = new ArrayList<ComboItem>();
        if (fldProperty instanceof ItemClassProp || fldProperty instanceof FlexProp) {
            refItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ImportTemplatePlugin_14", (String)BOS_IMPORT, (Object[])new Object[0])), "name"));
            refItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ImportTemplatePlugin_15", (String)BOS_IMPORT, (Object[])new Object[0])), FIELD_NUMBER));
            dispComboList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ImportTemplatePlugin_14", (String)BOS_IMPORT, (Object[])new Object[0])), "name"));
            if (TEMPLATETYPE_EXPT.equals(templateType)) {
                dispComboList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ImportTemplatePlugin_15", (String)BOS_IMPORT, (Object[])new Object[0])), FIELD_NUMBER));
            }
        } else {
            BasedataEntityType type = (BasedataEntityType)((IBasedataField)fldProperty).getComplexType();
            for (IDataEntityProperty refProp : type.getProperties()) {
                if (refProp instanceof AttachmentProp || !(refProp instanceof IFieldHandle) || !((IFieldHandle)refProp).isExportable()) continue;
                LocaleString disp = refProp.getDisplayName();
                ComboItem temp = new ComboItem(StringUtils.isNotBlank((Object)disp) ? disp : new LocaleString(refProp.getName()), refProp.getName());
                String nameProperty = type.getNameProperty();
                String numberProperty = type.getNumberProperty();
                if (refProp.getName().equals(nameProperty)) {
                    dispCombo = temp;
                    dispComboList.add(dispCombo);
                }
                if (TEMPLATETYPE_EXPT.equals(templateType) && refProp.getName().equals(numberProperty)) {
                    dispComboList.add(temp);
                }
                refItems.add(temp);
                if (!(fldProperty instanceof MaterielProp) || type.getMasteridType() != 2 || !StringUtils.equals((CharSequence)type.getMasteridPropName(), (CharSequence)refProp.getName())) continue;
                refItems.addAll(this.handleMaterielProp(refProp));
            }
        }
        this.getPageCache().put("refprops_" + fldProperty.getName(), SerializationUtils.toJsonString(refItems));
        return dispComboList;
    }

    private List<ComboItem> cacheDateEptFormat(IDataEntityProperty fldProperty) {
        String templateType = (String)this.getModel().getValue(FIELD_TEMPLATETYPE);
        ArrayList<ComboItem> dispComboList = new ArrayList<ComboItem>();
        ArrayList<ComboItem> refItems = new ArrayList<ComboItem>();
        if (fldProperty instanceof DateProp) {
            refItems.add(new ComboItem(new LocaleString("yyyy-MM-dd"), "dateformat1"));
            if (RequestContext.get().getLang().equals((Object)Lang.zh_CN)) {
                refItems.add(new ComboItem(new LocaleString("yyyy\u5e74MM\u6708dd\u65e5"), "dateformat2"));
            }
            refItems.add(new ComboItem(new LocaleString("yyyy/MM/dd"), "dateformat3"));
            refItems.add(new ComboItem(new LocaleString("yy-MM/dd"), "dateformat4"));
            refItems.add(new ComboItem(new LocaleString("yyyy"), "dateformat5"));
            dispComboList.add(new ComboItem(new LocaleString("yyyy-MM-dd"), "dateformat1"));
        } else if (fldProperty instanceof DateTimeProp) {
            refItems.add(new ComboItem(new LocaleString("yyyy-MM-dd HH:mm:ss"), "dateformat6"));
            if (RequestContext.get().getLang().equals((Object)Lang.zh_CN)) {
                refItems.add(new ComboItem(new LocaleString("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"), "dateformat7"));
            }
            refItems.add(new ComboItem(new LocaleString("yy/MM/dd HH-mm-ss"), "dateformat8"));
            dispComboList.add(new ComboItem(new LocaleString("yyyy-MM-dd HH:mm:ss"), "dateformat6"));
        } else if (fldProperty instanceof TimeProp) {
            refItems.add(new ComboItem(new LocaleString("HH:mm:ss"), "dateformat9"));
            if (RequestContext.get().getLang().equals((Object)Lang.zh_CN)) {
                refItems.add(new ComboItem(new LocaleString("HH\u65f6mm\u5206ss\u79d2"), "dateformat10"));
            }
            refItems.add(new ComboItem(new LocaleString("HH-mm-ss"), "dateformat11"));
            refItems.add(new ComboItem(new LocaleString("HH:mm"), "dateformat12"));
            refItems.add(new ComboItem(new LocaleString("mm:ss"), "dateformat13"));
            refItems.add(new ComboItem(new LocaleString("HH:mm:ssa"), "dateformat14"));
            dispComboList.add(new ComboItem(new LocaleString("HH:mm:ss"), "dateformat9"));
        }
        this.getPageCache().put("exportformats_" + fldProperty.getName(), SerializationUtils.toJsonString(refItems));
        return dispComboList;
    }

    private List<ComboItem> handleMaterielProp(IDataEntityProperty materielProp) {
        BasedataEntityType type = (BasedataEntityType)((IBasedataField)materielProp).getComplexType();
        ArrayList<ComboItem> materielItems = new ArrayList<ComboItem>();
        String materielName = materielProp.getName();
        LocaleString displayName = materielProp.getDisplayName();
        for (IDataEntityProperty refProp : type.getProperties()) {
            if (refProp instanceof AttachmentProp || !(refProp instanceof IFieldHandle) || !((IFieldHandle)refProp).isExportable()) continue;
            LocaleString name = refProp.getDisplayName();
            String appendName = materielName + "." + refProp.getName();
            if (StringUtils.isNotBlank((Object)displayName) && StringUtils.isNotBlank((Object)name)) {
                appendName = displayName + "." + name.toString();
            }
            ComboItem temp = new ComboItem(new LocaleString(appendName), materielName + "." + refProp.getName());
            materielItems.add(temp);
        }
        return materielItems;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        boolean existBizObj = this.isExistBizObj();
        if (!existBizObj && StringUtils.equals((CharSequence)itemKey, (CharSequence)BTN_DOWNLOAD)) {
            this.getView().showTipNotification(this.RES_SAVE_TEMPLATE);
            return;
        }
        if (!existBizObj && (StringUtils.equals((CharSequence)itemKey, (CharSequence)BTN_MOVE_UP) || StringUtils.equals((CharSequence)itemKey, (CharSequence)BTN_MOVE_DOWN))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"ImportTemplatePlugin_18", (String)BOS_IMPORT, (Object[])new Object[0]));
            return;
        }
        try {
            switch (itemKey) {
                case "btndownload_new": {
                    this.pushBillTempalte();
                    break;
                }
                case "moveup": {
                    this.moveEntryUp();
                    break;
                }
                case "movedown": {
                    this.moveEntryDown();
                }
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)TAB_FIELD_SELECT)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_MOVE_UP, BTN_MOVE_DOWN});
            return;
        }
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)TAB_ATT_PANEL_SELECT)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_MOVE_UP, BTN_MOVE_DOWN});
        }
    }

    private boolean isExistBizObj() {
        BasedataProp bizObjProp = (BasedataProp)this.getModel().getProperty(FIELD_BIZOBJ);
        DynamicObject bizObj = (DynamicObject)this.getModel().getValue(bizObjProp.getName());
        return bizObj != null;
    }

    private void moveEntryUp() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowsIndex = proxy.getEntryState(TREEENTRYENTITY).getSelectedRows();
        if (rowsIndex.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ImportLogDeleteFileListPlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]));
            return;
        }
        Arrays.sort(rowsIndex);
        if (this.isRowIdOrPid(rowsIndex)) {
            return;
        }
        if (this.isBillHead(rowsIndex)) {
            return;
        }
        if (this.isSubEntry(rowsIndex)) {
            return;
        }
        String bizNumber = String.valueOf(this.getModel().getValue(FIELD_BIZOBJ_ID));
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizNumber);
        boolean isImport = TEMPLATETYPE_IMPT.equalsIgnoreCase(String.valueOf(this.getModel().getValue(FIELD_TEMPLATETYPE)));
        if (mainEntityType instanceof QueryEntityType && isImport) {
            if (!this.isAllowMoveEntryUp(rowsIndex)) {
                return;
            }
            int index = this.getUpCrossEntityRowIndex(rowsIndex);
            if (index > -1) {
                DynamicObject moveRow = this.moveQueryEntityEntryUp(rowsIndex, index);
                this.resetAcrossMoveRowStyles(moveRow, proxy, isImport, rowsIndex[0]);
                return;
            }
        }
        if (!this.isDownIdOrPidRow(rowsIndex)) {
            this.getView().invokeOperation(OPERATION_MOVE_UP);
        }
    }

    private boolean isBillHead(int[] rowsIndex) {
        int minRow = Arrays.stream(rowsIndex).min().getAsInt();
        Object curpid = this.getPid(minRow);
        if (Long.parseLong(curpid.toString()) != 0L && minRow != 0) {
            Object frontpid = this.getPid(minRow - 1);
            Object billHeadPid = this.getPid(2);
            String entityNumber = this.getFieldNumber(minRow);
            String toRowNumber = this.getFieldNumber(minRow - 1);
            String entrystr = this.getPageCache().get("entryCollection");
            List<String> entryNumber = Arrays.asList(entrystr.substring(1, entrystr.length() - 1).split(", "));
            if (frontpid.equals(billHeadPid) && entryNumber.contains(entityNumber) && !entryNumber.contains(toRowNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u5fc5\u987b\u5728\u5355\u636e\u5934\u4e4b\u540e\u3002", (String)"ImportTemplatePlugin_31", (String)BOS_IMPORT, (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private boolean isSubEntry(int[] rowsIndex) {
        int minRow = Arrays.stream(rowsIndex).min().getAsInt();
        int maxRow = Arrays.stream(rowsIndex).max().getAsInt();
        Object curpid = this.getPid(minRow);
        if (Long.parseLong(curpid.toString()) != 0L && minRow != 0) {
            Object frontpid = this.getPid(minRow - 1);
            String entityNumber = this.getFieldNumber(maxRow);
            String toRowEntityNumber = this.getFieldNumber(minRow - 1);
            String subEntrystr = this.getPageCache().get("subEntryCollection");
            List<String> subEntryNumber = Arrays.asList(subEntrystr.substring(1, subEntrystr.length() - 1).split(", "));
            if (frontpid.equals(curpid) && subEntryNumber.contains(entityNumber) && !subEntryNumber.contains(toRowEntityNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u5355\u636e\u4f53\u5fc5\u987b\u5728\u7236\u5355\u636e\u4f53\u5b57\u6bb5\u4e4b\u540e\u3002", (String)"ImportTemplatePlugin_33", (String)BOS_IMPORT, (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private Object getPid(int row) {
        DynamicObject rowdyn = this.getModel().getEntryRowEntity(TREEENTRYENTITY, row);
        if (rowdyn != null) {
            return rowdyn.get(FIELD_PID);
        }
        return -1;
    }

    private String getFieldNumber(int rowIndex) {
        return String.valueOf(this.getModel().getValue(FIELD_ENTITYNUMBER, rowIndex));
    }

    private boolean isAllowMoveEntryUp(int[] rowsIndex) {
        IFormView view = this.getView();
        int minRow = Arrays.stream(rowsIndex).min().getAsInt();
        if (minRow <= 2) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u9996\u884c\uff0c\u65e0\u6cd5\u4e0a\u79fb\u3002", (String)"ImportTemplatePlugin_41", (String)BOS_IMPORT, (Object[])new Object[0]));
            return false;
        }
        Object pid = this.getPid(minRow);
        for (int index : rowsIndex) {
            if (pid.equals(this.getPid(index))) continue;
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8de8\u8282\u70b9\u4e0a\u79fb\u3002", (String)"ImportTemplatePlugin_42", (String)BOS_IMPORT, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private int getUpCrossEntityRowIndex(int[] rowsIndex) {
        String entityNumber = "";
        int result = -1;
        for (int index : rowsIndex) {
            if (index <= 1) continue;
            entityNumber = this.getFieldNumber(index - 1);
            if (FIELD_ID.equals(entityNumber) || entityNumber.endsWith(".id") || entityNumber.endsWith(".pid")) {
                entityNumber = this.getFieldNumber(index - 2);
            }
            if (!BILL_HEAD.equals(entityNumber)) continue;
            return index;
        }
        return result;
    }

    private DynamicObject moveQueryEntityEntryUp(int[] rowsIndex, int index) {
        int insertIndex = -1;
        int billHeadIndex = -1;
        int startIndex = index;
        String pId = "";
        DynamicObject resultRow = null;
        if (rowsIndex.length > 1) {
            for (int i = 0; i < rowsIndex.length - 1 && rowsIndex[i] + 1 == rowsIndex[i + 1]; ++i) {
                ++index;
            }
            int[] moveIndex = Arrays.copyOfRange(rowsIndex, 1, rowsIndex.length);
            this.getModel().moveEntryRowsUp(TREEENTRYENTITY, moveIndex);
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (int i = startIndex - 2; i > 0; --i) {
            DynamicObject preRow;
            pId = ((DynamicObject)collection.get(i)).getString(FIELD_PID);
            if (pId.equals((preRow = (DynamicObject)collection.get(i - 1)).getString(FIELD_PID))) continue;
            if (pId.equals(preRow.getString(FIELD_ID)) && BILL_HEAD.equals(preRow.getString(FIELD_ENTITYNUMBER))) {
                billHeadIndex = i - 1;
                DynamicObject moveRow = (DynamicObject)collection.get(index);
                Map<String, String> curEntity = this.getEntityNumber(index, collection);
                Map<String, String> moveToEntity = this.getEntityNumber(insertIndex, collection);
                if (this.isExistPropNumber(collection, moveRow.getString(FIELD_ENTITYNUMBER), StringUtils.split((String)moveToEntity.get(FIELD_ENTITYNUMBER), (String)".")[0])) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5b9e\u4f53\u5df2\u5b58\u5728\u5b57\u6bb5\u201c%s\u201d\u3002", (String)"ImportTemplatePlugin_22", (String)BOS_IMPORT, (Object[])new Object[0]), moveRow.getString(FIELD_ENTITYNUMBER)));
                    return resultRow;
                }
                this.handleSourceEntityField(moveRow, curEntity, moveToEntity);
                moveRow.set(FIELD_SEQ, (Object)(insertIndex + 1));
                moveRow.set(FIELD_PID, (Object)pId);
                while (index > insertIndex) {
                    DynamicObject tempRow = (DynamicObject)collection.get(index - 1);
                    tempRow.set(FIELD_SEQ, (Object)(index + 1));
                    Collections.swap(collection, index - 1, index);
                    resultRow = (DynamicObject)collection.get(--index);
                }
                this.getModel().updateEntryCache(collection);
                break;
            }
            insertIndex = i;
        }
        if (billHeadIndex == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u5176\u4ed6\u5c5e\u6027\u4e0d\u80fd\u6539\u53d8\u5185\u7801\u5c5e\u6027\u7684\u4f4d\u7f6e\u3002", (String)"ImportTemplatePlugin_17", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        return resultRow;
    }

    private boolean isExistPropNumber(DynamicObjectCollection collection, String propNumber, String moveToMainEntity) {
        HashMap entityTreeMap = new HashMap();
        String entityNumber = "";
        String mainEntityNumber = "";
        for (DynamicObject row : collection) {
            entityNumber = row.getString(FIELD_ENTITYNUMBER);
            if (!StringUtils.isNotBlank((CharSequence)entityNumber)) continue;
            if (row.get(FIELD_PID) == null || row.getLong(FIELD_PID) == 0L) {
                mainEntityNumber = entityNumber;
                entityTreeMap.put(entityNumber, new ArrayList());
                continue;
            }
            ((List)entityTreeMap.get(mainEntityNumber)).add(entityNumber);
        }
        return entityTreeMap.containsKey(mainEntityNumber) && ((List)entityTreeMap.get(moveToMainEntity)).contains(propNumber);
    }

    private void handleSourceEntityField(DynamicObject moveRow, Map<String, String> curEntity, Map<String, String> moveToEntity) {
        String sourceEntity = moveRow.getString(FIELD_SOURCE_ENTITY);
        if (StringUtils.isNotBlank((CharSequence)sourceEntity)) {
            String sourceNumber = StringUtils.split((String)sourceEntity, (String)".")[0];
            if (StringUtils.equals((CharSequence)moveToEntity.get(FIELD_ENTITYNUMBER), (CharSequence)sourceNumber)) {
                moveRow.set(FIELD_SOURCE_ENTITY, (Object)"");
                moveRow.set(FIELD_SOURCE_NAME, (Object)"");
            }
            return;
        }
        sourceEntity = curEntity.get(FIELD_ENTITYNUMBER) + "." + BILL_HEAD;
        moveRow.set(FIELD_SOURCE_ENTITY, (Object)sourceEntity);
        moveRow.set(FIELD_SOURCE_NAME, (Object)(curEntity.get(FIELD_ENTITYNAME) + "." + this.RES_BILLHEAD_NAME));
    }

    private void moveEntryDown() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowsIndex = proxy.getEntryState(TREEENTRYENTITY).getSelectedRows();
        if (rowsIndex.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ImportLogDeleteFileListPlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]));
            return;
        }
        Arrays.sort(rowsIndex);
        if (this.isRowIdOrPid(rowsIndex)) {
            return;
        }
        if (this.selectRowIsBillHead(rowsIndex)) {
            return;
        }
        if (this.selectRowIsEntry(rowsIndex)) {
            return;
        }
        String bizNumber = String.valueOf(this.getModel().getValue(FIELD_BIZOBJ_ID));
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizNumber);
        boolean isImport = TEMPLATETYPE_IMPT.equalsIgnoreCase(String.valueOf(this.getModel().getValue(FIELD_TEMPLATETYPE)));
        if (mainEntityType instanceof QueryEntityType && isImport) {
            if (!this.isAllowMoveEntryDown(rowsIndex)) {
                return;
            }
            int index = this.getDownCrossEntityRowIndex(rowsIndex);
            if (index > -1) {
                DynamicObject moveRow = this.moveQueryEntityEntryDown(rowsIndex, index);
                this.resetAcrossMoveRowStyles(moveRow, proxy, isImport, rowsIndex[rowsIndex.length - 1] - 1);
                return;
            }
        }
        this.getView().invokeOperation(OPERATION_MOVE_DOWN);
    }

    private boolean selectRowIsBillHead(int[] rowsIndex) {
        if (Arrays.binarySearch(rowsIndex, 1) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5934\u4e0d\u53ef\u4ee5\u79fb\u52a8\u3002", (String)"ImportTemplatePlugin_32", (String)BOS_IMPORT, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean selectRowIsEntry(int[] rowsIndex) {
        for (int maxRow : rowsIndex) {
            Object curpid = this.getPid(maxRow);
            Object nextpid = this.getPid(maxRow + 1);
            if (Long.parseLong(nextpid.toString()) == -1L) {
                return false;
            }
            String currentRowNumber = this.getFieldNumber(maxRow);
            String entityNumber = this.getFieldNumber(maxRow + 1);
            String subEntrystr = this.getPageCache().get("subEntryCollection");
            List<String> subEntryNumber = Arrays.asList(subEntrystr.substring(1, subEntrystr.length() - 1).split(", "));
            if (!nextpid.equals(curpid) || !subEntryNumber.contains(entityNumber) || subEntryNumber.contains(currentRowNumber)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u5355\u636e\u4f53\u5b57\u6bb5\u5fc5\u987b\u5728\u5b50\u5355\u636e\u4f53\u4e4b\u524d\u3002", (String)"ImportTemplatePlugin_34", (String)BOS_IMPORT, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isAllowMoveEntryDown(int[] rowsIndex) {
        int rowCount;
        IDataModel model = this.getModel();
        int maxRow = Arrays.stream(rowsIndex).max().getAsInt();
        if (maxRow >= (rowCount = model.getEntryRowCount(TREEENTRYENTITY)) - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u672b\u884c\uff0c\u65e0\u6cd5\u4e0b\u79fb\u3002", (String)"ImportTemplatePlugin_43", (String)BOS_IMPORT, (Object[])new Object[0]));
            return false;
        }
        Object pid = this.getPid(maxRow);
        for (int index : rowsIndex) {
            if (pid.equals(this.getPid(index))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8de8\u8282\u70b9\u4e0b\u79fb\u3002", (String)"ImportTemplatePlugin_44", (String)BOS_IMPORT, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private int getDownCrossEntityRowIndex(int[] rowsIndex) {
        IDataModel model = this.getModel();
        int index = -1;
        int maxRow = Arrays.stream(rowsIndex).max().getAsInt();
        DynamicObjectCollection collection = model.getEntryEntity(TREEENTRYENTITY);
        DynamicObject maxRowDy = (DynamicObject)collection.get(maxRow);
        if (maxRowDy.get(FIELD_PID) == null || maxRowDy.getLong(FIELD_PID) == 0L) {
            return index;
        }
        for (int preRow = maxRow - 1; preRow >= 0; --preRow) {
            if (!maxRowDy.get(FIELD_PID).equals(((DynamicObject)collection.get(preRow)).get(FIELD_ID))) continue;
            if (BILL_HEAD.equals(model.getValue(FIELD_ENTITYNUMBER, preRow))) break;
            return index;
        }
        DynamicObject nextRowDy = null;
        if (maxRow + 1 < collection.size()) {
            nextRowDy = (DynamicObject)collection.get(maxRow + 1);
        }
        if (maxRowDy != null && nextRowDy != null && !maxRowDy.get(FIELD_PID).equals(nextRowDy.get(FIELD_PID))) {
            String entityNumber = "";
            while (maxRow < collection.size()) {
                if (BILL_HEAD.equals(model.getValue(FIELD_ENTITYNUMBER, maxRow + 1))) {
                    index = maxRow + 1;
                    entityNumber = String.valueOf(model.getValue(FIELD_ENTITYNUMBER, index + 1));
                    if (!FIELD_ID.equals(entityNumber) && !entityNumber.endsWith(".id") && !entityNumber.endsWith(".pid")) break;
                    ++index;
                    break;
                }
                ++maxRow;
            }
        }
        return index;
    }

    private DynamicObject moveQueryEntityEntryDown(int[] rowsIndex, int index) {
        DynamicObject resultRow = null;
        int moveLength = rowsIndex.length;
        if (moveLength > 1) {
            for (int i = rowsIndex.length - 1; i > 0 && rowsIndex[i] - 1 == rowsIndex[i - 1]; --i) {
                moveLength = i - 1;
            }
            this.getModel().moveEntryRowsDown(TREEENTRYENTITY, Arrays.copyOfRange(rowsIndex, 0, moveLength));
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity(TREEENTRYENTITY);
        int moveIndex = Arrays.stream(rowsIndex).max().getAsInt();
        DynamicObject moveRow = (DynamicObject)collection.get(moveIndex);
        Map<String, String> curEntity = this.getEntityNumber(moveIndex, collection);
        Map<String, String> moveToEntity = this.getEntityNumber(index, collection);
        if (this.isExistPropNumber(collection, moveRow.getString(FIELD_ENTITYNUMBER), StringUtils.split((String)moveToEntity.get(FIELD_ENTITYNUMBER), (String)".")[0])) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5b9e\u4f53\u5df2\u5b58\u5728\u5b57\u6bb5\u201c%s\u201d\u3002", (String)"ImportTemplatePlugin_22", (String)BOS_IMPORT, (Object[])new Object[0]), moveRow.getString(FIELD_ENTITYNUMBER)));
            return resultRow;
        }
        this.handleSourceEntityField(moveRow, curEntity, moveToEntity);
        moveRow.set(FIELD_PID, ((DynamicObject)collection.get(index)).get(FIELD_PID));
        moveRow.set(FIELD_SEQ, (Object)(index + 1));
        DynamicObject nextRow = null;
        while (moveIndex < index) {
            nextRow = (DynamicObject)collection.get(moveIndex + 1);
            nextRow.set(FIELD_SEQ, (Object)moveIndex);
            Collections.swap(collection, moveIndex, moveIndex + 1);
            resultRow = (DynamicObject)collection.get(++moveIndex);
        }
        this.getModel().updateEntryCache(collection);
        return resultRow;
    }

    private Map<String, String> getEntityNumber(int index, DynamicObjectCollection collection) {
        HashMap<String, String> entityMap = new HashMap<String, String>(2);
        while (index > 0) {
            String curEntityNum = ((DynamicObject)collection.get(index)).getString(FIELD_ENTITYNUMBER);
            if (StringUtils.equals((CharSequence)curEntityNum, (CharSequence)BILL_HEAD)) {
                DynamicObject entityDyn = (DynamicObject)collection.get(index - 1);
                entityMap.put(FIELD_ENTITYNUMBER, entityDyn.getString(FIELD_ENTITYNUMBER));
                entityMap.put(FIELD_ENTITYNAME, entityDyn.getString(FIELD_ENTITYNAME));
                break;
            }
            --index;
        }
        return entityMap;
    }

    private void resetAcrossMoveRowStyles(DynamicObject moveRow, IClientViewProxy proxy, boolean isImportTemp, int preIndex) {
        if (moveRow == null) {
            return;
        }
        int moveRowInt = moveRow.getInt(FIELD_SEQ) - 1;
        this.rebuildFieldTreeValueAndStyle(this.getModel(), null, isImportTemp);
        DynamicObject preRow = this.getModel().getEntryRowEntity(TREEENTRYENTITY, preIndex);
        boolean preIsImport = preRow.getBoolean(FIELD_ISIMPORT);
        boolean preIsMustInput = preRow.getBoolean(FIELD_ISMUSTINPUT);
        ImportPluginUtils.checkParent(this.getModel(), proxy, FIELD_ISIMPORT, preIsImport, preIndex, TREEENTRYENTITY);
        ImportPluginUtils.checkParent(this.getModel(), proxy, FIELD_ISMUSTINPUT, preIsMustInput, preIndex, TREEENTRYENTITY);
        boolean isImport = moveRow.getBoolean(FIELD_ISIMPORT);
        boolean isMustInput = moveRow.getBoolean(FIELD_ISMUSTINPUT);
        ImportPluginUtils.checkParent(this.getModel(), proxy, FIELD_ISIMPORT, isImport, moveRowInt, TREEENTRYENTITY);
        ImportPluginUtils.checkParent(this.getModel(), proxy, FIELD_ISMUSTINPUT, isMustInput, moveRowInt, TREEENTRYENTITY);
        this.getView().updateView(TREEENTRYENTITY);
        this.focusMoveRow(moveRow, proxy, moveRowInt);
    }

    private void focusMoveRow(DynamicObject moveRow, IClientViewProxy proxy, int moveRowInt) {
        String pid = moveRow.getString(FIELD_PID);
        DynamicObjectCollection collection = this.getModel().getEntryEntity(TREEENTRYENTITY);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        for (int i = moveRowInt; i > 0; --i) {
            if (!StringUtils.equals((CharSequence)pid, (CharSequence)((DynamicObject)collection.get(i)).getString(FIELD_ID))) continue;
            grid.focus(i, moveRowInt);
        }
        proxy.getEntryState(TREEENTRYENTITY).selectRow(moveRowInt);
    }

    private boolean isRowIdOrPid(int[] rowsIndex) {
        IDataModel model = this.getModel();
        String entityNumber = "";
        for (int index : rowsIndex) {
            entityNumber = String.valueOf(model.getValue(FIELD_ENTITYNUMBER, index));
            if (!FIELD_ID.equals(entityNumber) && !entityNumber.endsWith(".id") && !entityNumber.endsWith(".pid")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u7801\u5c5e\u6027\u4e0d\u80fd\u4e0a\u4e0b\u79fb\u52a8\u3002", (String)"ImportTemplatePlugin_16", (String)BOS_IMPORT, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isDownIdOrPidRow(int[] rowsIndex) {
        String entityNumber = "";
        for (int index : rowsIndex) {
            if (index <= 0 || !FIELD_ID.equals(entityNumber = (String)this.getModel().getValue(FIELD_ENTITYNUMBER, index - 1)) && !entityNumber.endsWith(".id") && !entityNumber.endsWith(".pid")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u5176\u4ed6\u5c5e\u6027\u4e0d\u80fd\u6539\u53d8\u5185\u7801\u5c5e\u6027\u7684\u4f4d\u7f6e\u3002", (String)"ImportTemplatePlugin_17", (String)BOS_IMPORT, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkProperty() {
        IDataModel model = this.getModel();
        String templatetype = (String)model.getValue(FIELD_TEMPLATETYPE);
        if (StringUtils.isBlank((CharSequence)templatetype)) {
            return true;
        }
        DynamicObjectCollection dyncol = model.getEntryEntity(TREEENTRYENTITY);
        StringBuilder tips = new StringBuilder();
        for (DynamicObject dyn : dyncol) {
            boolean basedataImport;
            String importprop = dyn.getString(FIELD_IMPORTPROP);
            String exportpropname = dyn.getString(EXPORTPROPNAME);
            boolean bl = basedataImport = dyn.getBoolean(FIELD_ISIMPORT) && dyn.getBoolean(FIELD_ISBASEDATA);
            if (basedataImport && TEMPLATETYPE_IMPT.equalsIgnoreCase(templatetype) && StringUtils.isBlank((CharSequence)importprop) && StringUtils.isBlank((CharSequence)exportpropname)) {
                if (tips.length() > 0) {
                    tips.insert(0, '\u201c' + dyn.getString(FIELD_ENTITYNAME) + '\u201d');
                } else {
                    tips.append('\u201c').append(dyn.getString(FIELD_ENTITYNAME)).append('\u201d').append(ResManager.loadKDString((String)"\u5b57\u6bb5\u8bbe\u7f6e\u4e86\u5141\u8bb8\u5bfc\u5165\uff0c\u4f46\u6ca1\u6709\u8bbe\u7f6e\u5bfc\u5165\u5c5e\u6027\u6216\u5bfc\u51fa\u5c5e\u6027\uff0c\u5c06\u6309\u9ed8\u8ba4\u7f16\u7801\u548c\u540d\u79f0\u5904\u7406\u3002", (String)"ImportTemplatePlugin_19", (String)BOS_IMPORT, (Object[])new Object[0]));
                }
            }
            if (!basedataImport || !TEMPLATETYPE_EXPT.equalsIgnoreCase(templatetype) || !StringUtils.isBlank((CharSequence)exportpropname)) continue;
            if (tips.length() > 0) {
                tips.insert(0, '\u201c' + dyn.getString(FIELD_ENTITYNAME) + '\u201d');
                continue;
            }
            tips.append('\u201c').append(dyn.getString(FIELD_ENTITYNAME)).append('\u201d').append(ResManager.loadKDString((String)"\u5b57\u6bb5\u8bbe\u7f6e\u4e86\u5141\u8bb8\u5bfc\u51fa\uff0c\u4f46\u6ca1\u6709\u8bbe\u7f6e\u5bfc\u51fa\u5c5e\u6027\uff0c\u5c06\u6309\u9ed8\u8ba4\u5bfc\u51fa\u7f16\u7801\u548c\u540d\u79f0\u5904\u7406\u3002", (String)"ImportTemplatePlugin_20", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        if (tips.length() > 0) {
            tips.insert(0, ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ImportTemplatePlugin_21", (String)BOS_IMPORT, (Object[])new Object[0]));
            this.getView().showTipNotification(tips.toString());
            return false;
        }
        return true;
    }

    private void pushBillTempalte() throws IOException {
        BasedataProp bizObjProp = (BasedataProp)this.getModel().getProperty(FIELD_BIZOBJ);
        DynamicObject bizobj = (DynamicObject)this.getModel().getValue(bizObjProp.getName());
        String billFormId = bizobj.getString(bizObjProp.getNumberProp());
        LocalDate now = LocalDate.now();
        if (!StringUtils.isBlank((CharSequence)billFormId)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billFormId);
            DynamicObject templateData = null;
            Long tId = (Long)this.getModel().getDataEntity().getPkValue();
            if (tId == null || tId <= 0L) {
                this.getView().showTipNotification(this.RES_SAVE_TEMPLATE);
                return;
            }
            String ctxPath = RequestContext.get().getClientFullContextPath();
            if (tId > 0L) {
                templateData = BusinessDataServiceHelper.loadSingle((Object)tId, (String)"bos_importtemplate");
            }
            String fileName = this.RES_TEMPLATE_PREFIX;
            fileName = templateData != null ? fileName + templateData.get("name") : fileName + mainEntityType.getDisplayName();
            String errMsg = this.checkPlugin(templateData);
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                this.getView().showErrorNotification(errMsg);
                return;
            }
            if (RequestContext.get().getLang() == Lang.zh_CN || RequestContext.get().getLang() == Lang.zh_TW) {
                fileName = fileName.replaceAll(" ", "");
            }
            this.getView().download(ctxPath + (ctxPath.endsWith("/") ? "" : "/") + "form/export.do?templateid=" + tId + "&formid=" + billFormId + "&filename=" + URLEncoder.encode(fileName + "_" + String.format("%02d", now.getMonthValue()).replaceAll("\\+", "%20") + String.format("%02d", now.getDayOfMonth()) + ".xlsx", "UTF-8") + "&extenddata=&routeappid=" + this.getView().getFormShowParameter().getServiceAppId() + "&a=t");
            this.getView().sendFormAction(this.getView());
        } else {
            this.getView().showTipNotification(this.RES_BIZOBJ_NOT_FOUND);
        }
    }

    private String checkPlugin(DynamicObject templateData) {
        if (templateData != null) {
            String plugins = templateData.getString(FIILED_PLUGIN);
            List pluginsTmp = JSONObject.parseArray((String)plugins, Plugin.class);
            if (pluginsTmp == null) {
                return "";
            }
            String curPlugin = "";
            try {
                for (Plugin plugin : pluginsTmp) {
                    if (!plugin.isEnabled()) continue;
                    curPlugin = plugin.getClassName();
                    if (plugin.getType() == 4) {
                        ScriptProxyFactory.createPluginProxy((String)curPlugin, ProjectInitializerManager::getEngineAutoDebug);
                        continue;
                    }
                    TypesContainer.createInstance((String)curPlugin);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return String.format(ResManager.loadKDString((String)"\u6a21\u677f\u63d2\u4ef6%s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff0c\u8bf7\u68c0\u67e5\u63d2\u4ef6\u3002", (String)"ImportTemplatePlugin_30", (String)BOS_IMPORT, (Object[])new Object[0]), curPlugin);
            }
        }
        return "";
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        boolean isFormDB = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        this.getView().setVisible(Boolean.valueOf(isFormDB), new String[]{"bar_new", "bar_disable"});
        if (OPERATION_MOVE_UP.equalsIgnoreCase(evt.getOperateKey()) || OPERATION_MOVE_DOWN.equalsIgnoreCase(evt.getOperateKey())) {
            IDataModel model = this.getModel();
            boolean isImport = TEMPLATETYPE_IMPT.equals(model.getValue(FIELD_TEMPLATETYPE));
            this.rebuildFieldTreeValueAndStyle(model, null, isImport);
            return;
        }
        OperationResult opResult = evt.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            if (this.isNewAdd) {
                this.getModel().setValue("enable", (Object)"");
            }
            return;
        }
        FormOperate formOp = (FormOperate)evt.getSource();
        if (("saveandnew".equals(formOp.getOption().getVariables().get("orioperationkey")) || "save".equals(formOp.getOperateKey())) && !this.checkProperty()) {
            opResult.setShowMessage(false);
        }
    }

    @Deprecated
    public void buildBillTreeFields(IDataModel model, IClientViewProxy proxy, String number, boolean isIncludePKField, boolean isOnlyPhysicsField, Set<String> currSort) {
    }

    @Deprecated
    public boolean buildFldTreeRow(IDataModel model, IClientViewProxy proxy, MainEntityType mainType, boolean isIncludePKField, boolean isOnlyPhysicsField, Set<String> currSort) {
        return true;
    }

    public void beforeTogetherMoveEntryRow(BeforeTogetherMoveEntryRowEventArgs e) {
        boolean isQueryEntity;
        boolean notChange;
        int toIndex;
        int[] fromIndex = e.getFormIndexs();
        boolean isUpMove = fromIndex[0] >= (toIndex = e.getToIndex());
        boolean bl = notChange = fromIndex[fromIndex.length - 1] == toIndex;
        if (this.isRowIdOrPid(fromIndex)) {
            e.setCancel(true);
            return;
        }
        if (isUpMove) {
            if (this.isBillHead(fromIndex, ++toIndex) || this.isSubEntry(fromIndex, toIndex) || this.isDownIdOrPidRow(fromIndex, toIndex, notChange) || ImportPluginUtils.notAllowMoveEntryUp(this.getView(), e.getEntryProp().getName(), fromIndex)) {
                e.setCancel(true);
                return;
            }
        } else if (this.selectRowIsBillHead(fromIndex) || this.selectRowIsEntry(fromIndex, toIndex) || ImportPluginUtils.notAllowMoveEntryDown(this.getView(), e.getEntryProp().getName(), fromIndex)) {
            e.setCancel(true);
            return;
        }
        if (0 != toIndex && toIndex - 1 == fromIndex[fromIndex.length - 1] && ImportPluginUtils.notAllowMoveEntryDown(this.getView(), e.getEntryProp().getName(), fromIndex)) {
            e.setCancel(true);
            return;
        }
        String bizNumber = String.valueOf(this.getModel().getValue(FIELD_BIZOBJ_ID));
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizNumber);
        boolean isImport = TEMPLATETYPE_IMPT.equalsIgnoreCase(String.valueOf(this.getModel().getValue(FIELD_TEMPLATETYPE)));
        boolean bl2 = isQueryEntity = mainEntityType instanceof QueryEntityType && isImport;
        if (isQueryEntity) {
            if (isUpMove && !this.isAllowMoveEntryUp(fromIndex)) {
                e.setCancel(true);
                return;
            }
            if (!isUpMove && !this.isAllowMoveEntryDown(fromIndex)) {
                e.setCancel(true);
                return;
            }
        }
        super.beforeTogetherMoveEntryRow(e);
    }

    private boolean isDownIdOrPidRow(int[] rowsIndex, int toIndex, boolean notChange) {
        if (notChange) {
            return false;
        }
        int fromRow = Arrays.stream(rowsIndex).min().getAsInt();
        boolean toRowIsEntry = this.moveRowIsEntry(toIndex - 1);
        boolean toRowIsSubEntry = this.moveRowIsSubEntry(toIndex - 1);
        boolean fromRowIsEntry = this.moveRowIsEntry(fromRow);
        boolean fromRowIsSubEntry = this.moveRowIsSubEntry(fromRow);
        if (toRowIsEntry && fromRowIsEntry || toRowIsSubEntry && fromRowIsSubEntry) {
            return false;
        }
        boolean isImport = TEMPLATETYPE_IMPT.equalsIgnoreCase(String.valueOf(this.getModel().getValue(FIELD_TEMPLATETYPE)));
        Object fromRowPid = this.getPid(fromRow);
        Object toRowId = this.getCurrentId(toIndex - 1);
        if (isImport && fromRowPid.equals(toRowId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u5176\u4ed6\u5c5e\u6027\u4e0d\u80fd\u6539\u53d8\u5185\u7801\u5c5e\u6027\u7684\u4f4d\u7f6e\u3002", (String)"ImportTemplatePlugin_17", (String)BOS_IMPORT, (Object[])new Object[0]));
            return true;
        }
        String entityNumber = (String)this.getModel().getValue(FIELD_ENTITYNUMBER, toIndex);
        if (null != entityNumber && (FIELD_ID.equals(entityNumber) || entityNumber.endsWith(".id") || entityNumber.endsWith(".pid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u5176\u4ed6\u5c5e\u6027\u4e0d\u80fd\u6539\u53d8\u5185\u7801\u5c5e\u6027\u7684\u4f4d\u7f6e\u3002", (String)"ImportTemplatePlugin_17", (String)BOS_IMPORT, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isSubEntry(int[] rowsIndex, int toIndex) {
        int fromRow = Arrays.stream(rowsIndex).max().getAsInt();
        Object fromRowPid = this.getPid(fromRow);
        if (Long.parseLong(fromRowPid.toString()) != 0L && fromRow != 0) {
            Object toRowPid = this.getPid(toIndex - 1);
            String fromRowNumber = this.getFieldNumber(fromRow);
            String toRowNumber = this.getFieldNumber(toIndex);
            String subEntryList = this.getPageCache().get("subEntryCollection");
            List<String> subEntryNumber = Arrays.asList(subEntryList.substring(1, subEntryList.length() - 1).split(", "));
            if (toRowPid.equals(fromRowPid) && subEntryNumber.contains(fromRowNumber) && !subEntryNumber.contains(toRowNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u5355\u636e\u4f53\u5fc5\u987b\u5728\u7236\u5355\u636e\u4f53\u5b57\u6bb5\u4e4b\u540e\u3002", (String)"ImportTemplatePlugin_33", (String)BOS_IMPORT, (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private boolean selectRowIsEntry(int[] rowsIndex, int toIndex) {
        int maxRow = Arrays.stream(rowsIndex).min().getAsInt();
        Object fromRowPid = this.getPid(maxRow);
        Object toRowPid = this.getPid(toIndex);
        if (Long.parseLong(toRowPid.toString()) == -1L) {
            return false;
        }
        String fromRowNumber = this.getFieldNumber(maxRow);
        String entityNumber = this.getFieldNumber(toIndex);
        String subEntryList = this.getPageCache().get("subEntryCollection");
        List<String> subEntryNumber = Arrays.asList(subEntryList.substring(1, subEntryList.length() - 1).split(", "));
        if (toRowPid.equals(fromRowPid) && subEntryNumber.contains(entityNumber) && !subEntryNumber.contains(fromRowNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u5355\u636e\u4f53\u5b57\u6bb5\u5fc5\u987b\u5728\u5b50\u5355\u636e\u4f53\u4e4b\u524d\u3002", (String)"ImportTemplatePlugin_34", (String)BOS_IMPORT, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isBillHead(int[] rowsIndex, int toIndex) {
        int minRow = Arrays.stream(rowsIndex).min().getAsInt();
        Object fromRowPid = this.getPid(minRow);
        if (Long.parseLong(fromRowPid.toString()) != 0L && minRow != 0) {
            String fieldNumber = this.getFieldNumber(toIndex);
            String entityNumber = this.getFieldNumber(minRow);
            String entryList = this.getPageCache().get("entryCollection");
            List<String> entryNumber = Arrays.asList(entryList.substring(1, entryList.length() - 1).split(", "));
            if (BILL_HEAD.equals(fieldNumber) && entryNumber.contains(entityNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u5fc5\u987b\u5728\u5355\u636e\u5934\u4e4b\u540e\u3002", (String)"ImportTemplatePlugin_31", (String)BOS_IMPORT, (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private Object getCurrentId(int currentRow) {
        DynamicObject rowObj = this.getModel().getEntryRowEntity(TREEENTRYENTITY, currentRow);
        if (rowObj != null) {
            return rowObj.get(FIELD_ID);
        }
        return -1;
    }

    private boolean moveRowIsEntry(int row) {
        String entryList = this.getPageCache().get("entryCollection");
        List<String> entryNumbers = Arrays.asList(entryList.substring(1, entryList.length() - 1).split(", "));
        String entityNumber = this.getFieldNumber(row);
        return entryNumbers.contains(entityNumber);
    }

    private boolean moveRowIsSubEntry(int row) {
        String subEntryList = this.getPageCache().get("subEntryCollection");
        List<String> subEntryNumbers = Arrays.asList(subEntryList.substring(1, subEntryList.length() - 1).split(", "));
        String entityNumber = this.getFieldNumber(row);
        return subEntryNumbers.contains(entityNumber);
    }
}

