/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.export.util.ConvertUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.impt.background.ImportProgress;
import kd.bos.form.impt.background.ImportProgressImpl;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.ImportPermissionPlugin;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.lang.Lang;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mvc.list.ListView;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.svc.util.PermissionParam;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.web.actions.utils.FilePremissionUtil;

public class ImportingPlugin
extends ImportPermissionPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(ImportingPlugin.class);
    private static final String IMPORT_PROGRESS_ID = "IMPORT_PROGRESS_ID";
    private static final String BTN_OK = "btnok";
    private static final String BT_EXPORT_EXCEL_ERR_MSG = "btndetails";
    private static final String BT_SHOW_RESULT = "btnresult";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String SUCCESSPANEL = "successpanel";
    private static final String BTNSUSPEND = "btnsuspend";
    private static final String FAILPANEL = "failpanel";
    private static final String BTNCLOSE = "buttonap";
    private static final String IKNONWBTN = "iknonwbtn";
    private static final String BOS_IMPORTLOG = "bos_importlog";
    private static final String SUSPENDPANEL = "suspendpanel";
    private static final String BILLFORMID = "BillFormId";
    private static final String BOS_IMPORT = "bos-import";
    private static final String TO_BACKGROUND = "btncancel";
    private static final String IMPORTDATA = "1";
    private static final String IMPORTTYPE = "importtype";
    private static final String CHECK_START_KEY = "CHECK_START_KEY";
    private static final String START_MARK = "START_MARK";
    private static final String CHECK_FINISHED_KEY = "CHECK_FINISHED_KEY";
    private static final String FINISHED_MARK = "START_MARK";
    private static final String CONFIRMED_TOBACKGROUND_OR_SUSPEND = "CLOSE_CONFIRMED_TOBACKGROUND_OR_SUSPEND";
    private static final String CONFIRMED_SUSPEND = "CLOSE_CONFIRMED_SUSPEND";
    private static final String CONFIRMED_TOBACKGROUND = "CLOSE_CONFIRMED_TOBACKGROUND";
    private static final String ALLSUCCESSLABEL = "labelap10";
    private boolean canClose = false;
    public static final String CUSTPARAM_CONTEXT = "requestcontext";
    public static final String CUSTPARAM_ENTITYNAME = "ListName";
    public static final String CACHEKEY_JOBFORMINFO = "import_jobforminfo";
    public static final String CACHEKEY_TASKID = "import_taskid";
    private static final String CACHEKEY_ISSTART = "isstart";
    public static final String CUSTPARAM_ENTITYNUMBER = "entitynumber";
    private static final String BACKGROUND_ACTIONID = "background_actionid";
    private ImportProgress importProgress;
    private static final String EXPORTAPP = "imp-exp";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK, BT_EXPORT_EXCEL_ERR_MSG, BT_SHOW_RESULT, BTNSUSPEND, TO_BACKGROUND});
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{FAILPANEL, SUCCESSPANEL, BTNCLOSE, IKNONWBTN, BTN_OK, SUSPENDPANEL});
        FormShowParameter params = this.getView().getFormShowParameter();
        String billFormId = (String)params.getCustomParam(BILLFORMID);
        String listName = (String)params.getCustomParam(CUSTPARAM_ENTITYNAME);
        String logId = (String)params.getCustomParam("logId");
        Label title = (Label)this.getControl("title");
        title.setText(listName);
        if (StringUtils.isEmpty((CharSequence)logId)) {
            Object logIdObj = this.createImportlog(billFormId, listName);
            logId = logIdObj.toString();
        }
        this.getPageCache().put(IMPORT_PROGRESS_ID, logId);
        ProgressBar progress = (ProgressBar)this.getControl(PROGRESSBARAP);
        try {
            progress.start();
        }
        catch (Throwable ex) {
            log.error(ex);
            progress.setPercent(100, ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad", (String)"ImportingPlugin_0", (String)BOS_IMPORT, (Object[])new Object[0]));
            String errMsg = ex instanceof KDBizException ? ex.getMessage() : ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportingPlugin_1", (String)BOS_IMPORT, (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            ImportLogHelper.append((Object)logId, (String)errMsg);
            this.createOperationLogByImportDetail(Boolean.FALSE, 0, 0);
        }
    }

    private void dispatchTask(Object logId) {
        JobFormInfo jobFormInfo = this.buildJobFormInfo(logId);
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
        this.getAppCache(this.getView()).put(this.getTaskIdKey(this.getView()), (Object)taskId);
    }

    private JobFormInfo buildJobFormInfo(Object logId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u5bfc\u5165 - %s", (String)"ImportDataProgressFormPlugin_1", (String)BOS_IMPORT, (Object[])new Object[0]), this.getEntityName()));
        LocaleString tmpLocalString = ResManager.getLocaleString((String)"\u5bfc\u5165 - %s", (String)"ImportDataProgressFormPlugin_1", (String)BOS_IMPORT);
        for (Map.Entry entry : tmpLocalString.entrySet()) {
            tmpLocalString.setItem((String)entry.getKey(), (Object)String.format((String)entry.getValue(), this.getEntityName()));
        }
        jobInfo.setlName(tmpLocalString);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
        if (StringUtils.isNotBlank((CharSequence)routeAppId)) {
            String subRouteAppId = routeAppId + ".import";
            if (subRouteAppId.equals(ServiceLookup.getServiceAppId((String)subRouteAppId))) {
                routeAppId = subRouteAppId;
            } else if (ServiceLookup.hasDeployedAppId((String)EXPORTAPP)) {
                routeAppId = EXPORTAPP;
            }
        }
        log.debug("buildJobFormInfo ---- routeAppId : " + routeAppId);
        jobInfo.setAppId(routeAppId);
        jobInfo.setTaskClassname("kd.bos.form.plugin.impt.ImportService");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CUSTPARAM_CONTEXT, RequestContext.get());
        params.put("pageId", this.getView().getPageId());
        params.put("logId", logId);
        params.put(BILLFORMID, this.getView().getFormShowParameter().getCustomParam(BILLFORMID));
        params.put("Url", this.getView().getFormShowParameter().getCustomParam("Url"));
        params.put("imgZipUrl", this.getView().getFormShowParameter().getCustomParam("imgZipUrl"));
        params.put("attZipUrl", this.getView().getFormShowParameter().getCustomParam("attZipUrl"));
        params.put("concurrentID", this.getView().getFormShowParameter().getCustomParam("concurrentID"));
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        jobFormInfo.getParams().put("logId", logId);
        if (this.getView().getFormShowParameter().getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(this.getView().getFormShowParameter().getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.plugin.expt.ExportCallBack", BACKGROUND_ACTIONID);
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setClickClassName("kd.bos.form.impt.background.ImportTaskClick");
        return jobFormInfo;
    }

    private String getEntityName() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNAME);
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(CACHEKEY_JOBFORMINFO);
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put(CACHEKEY_JOBFORMINFO, str);
        }
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }

    public void onProgress(ProgressEvent evt) {
        TaskInfo taskInfo;
        String taskInfoData;
        this.markStart();
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        String logId = this.getPageCache().get(IMPORT_PROGRESS_ID);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask(logId);
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        int importProgress = 0;
        String cacheLogStr = this.getPageCache().get("Cached_Import_Logger");
        if (StringUtils.isEmpty((CharSequence)cacheLogStr) && StringUtils.isNotEmpty((CharSequence)taskId) && StringUtils.isNotEmpty((CharSequence)(taskInfoData = (taskInfo = ScheduleServiceHelper.queryTask((String)taskId)).getData()))) {
            cacheLogStr = taskInfoData;
        }
        log.debug("Cached_Import_Logger<----" + cacheLogStr);
        IFormView view = this.getView();
        JSONObject info = JSON.parseObject((String)cacheLogStr);
        if (info != null) {
            importProgress = info.getIntValue("progress");
            if (importProgress < 0 || info.containsKey((Object)"err")) {
                String err = info.containsKey((Object)"err") ? (String)info.get((Object)"err") : ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u9047\u5230\u672a\u77e5\u9519\u8bef", (String)"ImportingPlugin_2", (String)BOS_IMPORT, (Object[])new Object[0]);
                view.showErrorNotification(err);
                ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
                progressbar.stop();
                this.createOperationLogByImportDetail(Boolean.FALSE, 0, 0);
                this.getImportProgress().fail(ResManager.loadKDString((String)"\u7236\u5217\u8868\u5df2\u7ecf\u5173\u95ed\uff0c\u65e0\u6cd5\u83b7\u53d6\u9700\u8981\u5bfc\u5165\u7684\u5355\u636e", (String)"ImportDataProgressFormPlugin_3", (String)BOS_IMPORT, (Object[])new Object[0]));
                return;
            }
            Label currRow = (Label)this.getControl("currentrow");
            Label rowCount = (Label)this.getControl("rowcount");
            Label handleCount = (Label)this.getControl("handlecount");
            Label handleRow = (Label)this.getControl("handlerow");
            int row = info.getIntValue("curRowNum");
            int lastrow = Math.max(0, info.getIntValue("totalRowNum"));
            view.setVisible(Boolean.TRUE, new String[]{BTNSUSPEND, TO_BACKGROUND});
            view.setVisible(Boolean.FALSE, new String[]{BTNCLOSE, IKNONWBTN});
            int total = info.getIntValue("total");
            int totalRow = info.getIntValue("totalRow");
            if (row >= 0) {
                currRow.setText("" + row);
                rowCount.setText("" + lastrow);
            }
            handleCount.setText("" + total);
            handleRow.setText("" + totalRow);
            if (importProgress >= 100) {
                this.markFinished();
                view.hideLoading();
                view.setVisible(Boolean.FALSE, new String[]{"importpanel", TO_BACKGROUND, BTNSUSPEND, SUSPENDPANEL});
                int failed = info.getIntValue("failed");
                if (failed > 0) {
                    view.setVisible(Boolean.TRUE, new String[]{BTNCLOSE});
                    view.setVisible(Boolean.FALSE, new String[]{IKNONWBTN});
                    Label success = (Label)this.getControl("success");
                    Label fail = (Label)this.getControl("failed");
                    success.setText("" + (total - failed));
                    fail.setText("" + failed);
                    view.setVisible(Boolean.TRUE, new String[]{FAILPANEL});
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)view.getFormShowParameter().getCustomParam("OperateKey")))) {
                        view.setVisible(Boolean.TRUE, new String[]{BTN_OK});
                    }
                    HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
                    notHidden.put("gr", 1);
                    view.updateControlMetadata(FAILPANEL, notHidden);
                } else {
                    view.setVisible(Boolean.TRUE, new String[]{IKNONWBTN});
                    view.setVisible(Boolean.FALSE, new String[]{BTNCLOSE});
                    Label success = (Label)this.getControl("successall");
                    success.setText("" + total);
                    if (total == 0) {
                        Label allSuccessLabel = (Label)this.getControl(ALLSUCCESSLABEL);
                        allSuccessLabel.setText(ResManager.loadKDString((String)"\u5355\u636e\u5934\u65e0\u6709\u6548\u6570\u636e\uff0c\u5bfc\u5165", (String)"ImportingPlugin_14", (String)BOS_IMPORT, (Object[])new Object[0]));
                    }
                    view.setVisible(Boolean.TRUE, new String[]{SUCCESSPANEL});
                    HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
                    notHidden.put("gr", 1);
                    view.updateControlMetadata(SUCCESSPANEL, notHidden);
                }
                this.getAppCache(view).remove(this.getSuspendKey(view));
                this.createOperationLogByImportDetail(Boolean.TRUE, total - failed, failed);
                this.releaseLimitLock();
            }
            if (lastrow > 0) {
                HashMap<String, Integer> meta = new HashMap<String, Integer>();
                meta.put("itime", 3000);
                view.updateControlMetadata(PROGRESSBARAP, meta);
            }
        }
        evt.setProgress(importProgress);
    }

    public ImportProgress getImportProgress() {
        if (this.importProgress == null) {
            this.importProgress = new ImportProgressImpl(this.getTaskId());
        }
        return this.importProgress;
    }

    private void createOperationLog(boolean status, String fileName) {
        if (status) {
            ImportOperationLog.getInstance().createAppLog(this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.EXPORT_ERROR_DATA_FROM_IMPORT_STOP_SUCCESS.getOpNameBridge(), ImportOperationLog.OperationEnum.EXPORT_ERROR_DATA_FROM_IMPORT_STOP_SUCCESS.getOpDescFormatBridge(), new String[]{fileName});
            return;
        }
        ImportOperationLog.getInstance().createAppLog(this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.EXPORT_ERROR_DATA_FROM_IMPORT_STOP_FAIL.getOpNameBridge(), ImportOperationLog.OperationEnum.EXPORT_ERROR_DATA_FROM_IMPORT_STOP_FAIL.getOpDescFormatBridge(), new String[]{fileName});
    }

    private void createOperationLogByViewImportResult(boolean status) {
        if (status) {
            ImportOperationLog.getInstance().createAppLog(this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.VIEW_IMPORT_RESULT_FROM_IMPORT_STOP_SUCCESS.getOpNameBridge(), ImportOperationLog.OperationEnum.VIEW_IMPORT_RESULT_FROM_IMPORT_STOP_SUCCESS.getOpDescFormatBridge(), new String[0]);
            return;
        }
        ImportOperationLog.getInstance().createAppLog(this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.VIEW_IMPORT_RESULT_FROM_IMPORT_STOP_FAIL.getOpNameBridge(), ImportOperationLog.OperationEnum.VIEW_IMPORT_RESULT_FROM_IMPORT_STOP_FAIL.getOpDescFormatBridge(), new String[0]);
    }

    private void createOperationLogByImportDetail(Boolean success, int successCount, int failCount) {
        if (!success.booleanValue()) {
            ImportOperationLog.getInstance().createAppLog((String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.IMPORT_START_FAIL.getOpNameBridge(), ImportOperationLog.OperationEnum.IMPORT_START_FAIL.getOpDescFormatBridge(), new String[0]);
            return;
        }
        MultiLangEnumBridge opDesc = failCount == 0 ? ImportOperationLog.OperationEnum.IMPORT_RESULT_SUCCESS.getOpDescFormatBridge() : (successCount == 0 ? ImportOperationLog.OperationEnum.IMPORT_RESULT_FAIL.getOpDescFormatBridge() : ImportOperationLog.OperationEnum.IMPORT_RESULT.getOpDescFormatBridge());
        ImportOperationLog.getInstance().createAppLog(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.IMPORT_RESULT.getOpNameBridge(), opDesc, new String[]{String.valueOf(successCount), String.valueOf(failCount)});
    }

    private void createOperationLogByImportAgain(boolean status) {
        if (status) {
            ImportOperationLog.getInstance().createAppLog((String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.IMPORT_AGAIN_FROMIMPORT_STOP_SUCCESS.getOpNameBridge(), ImportOperationLog.OperationEnum.IMPORT_AGAIN_FROMIMPORT_STOP_SUCCESS.getOpDescFormatBridge(), new String[0]);
            return;
        }
        ImportOperationLog.getInstance().createAppLog((String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.IMPORT_AGAIN_FROMIMPORT_STOP_FAIL.getOpNameBridge(), ImportOperationLog.OperationEnum.IMPORT_AGAIN_FROMIMPORT_STOP_FAIL.getOpDescFormatBridge(), new String[0]);
    }

    private IAppCache getAppCache(IFormView view) {
        String billFormId = (String)view.getFormShowParameter().getCustomParam(BILLFORMID);
        String appId = EntityMetadataCache.getDataEntityType((String)billFormId).getAppId();
        return AppCache.get((String)appId);
    }

    private String getSuspendKey(IFormView view) {
        String logId = this.getPageCache().get(IMPORT_PROGRESS_ID);
        String billFormId = (String)view.getFormShowParameter().getCustomParam(BILLFORMID);
        return "IMPT_SUSPEND_" + billFormId + "_" + logId;
    }

    private String getTaskIdKey(IFormView view) {
        String logId = this.getPageCache().get(IMPORT_PROGRESS_ID);
        String billFormId = (String)view.getFormShowParameter().getCustomParam(BILLFORMID);
        return "IMPT_TASKID_" + billFormId + "_" + logId;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.canClose) {
            return;
        }
        if (this.isSuspending()) {
            return;
        }
        if (this.checkIsFinished()) {
            return;
        }
        HashMap<Integer, String> btNameMap = new HashMap<Integer, String>(16);
        btNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u8f6c\u5165\u540e\u53f0", (String)"ImportingPlugin_9", (String)BOS_IMPORT, (Object[])new Object[0]));
        btNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"ImportingPlugin_10", (String)BOS_IMPORT, (Object[])new Object[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6b63\u5728\u51c6\u5907\u5bfc\u5165\u6570\u636e\uff0c\u60a8\u70b9\u51fb\u4e86\u5173\u95ed\uff0c\u8bf7\u786e\u8ba4\u662f\u7ec8\u6b62\u8fd8\u662f\u8f6c\u5165\u540e\u53f0\uff1f", (String)"ImportingPlugin_11", (String)BOS_IMPORT, (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CONFIRMED_TOBACKGROUND_OR_SUSPEND, (IFormPlugin)this), btNameMap);
        this.canClose = true;
        this.stopBar();
        e.setCancel(true);
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.stop();
    }

    private boolean isSuspending() {
        IFormView view = this.getView();
        return this.getAppCache(view).get(this.getSuspendKey(view), String.class) != null;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        String callBackId;
        super.confirmCallBack(messageboxclosedevent);
        switch (callBackId = messageboxclosedevent.getCallBackId()) {
            case "CLOSE_CONFIRMED_TOBACKGROUND_OR_SUSPEND": {
                this.confirmToBackGroundOrSuspend(messageboxclosedevent);
                break;
            }
            case "CLOSE_CONFIRMED_TOBACKGROUND": {
                this.confirmToBackGround(messageboxclosedevent);
                break;
            }
            case "CLOSE_CONFIRMED_SUSPEND": {
                this.confirmSuspend(messageboxclosedevent);
                break;
            }
        }
    }

    private void confirmSuspend(MessageBoxClosedEvent messageboxclosedevent) {
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.suspendImport();
        }
    }

    private void confirmToBackGround(MessageBoxClosedEvent messageboxclosedevent) {
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        }
    }

    private void confirmToBackGroundOrSuspend(MessageBoxClosedEvent messageboxclosedevent) {
        if (messageboxclosedevent.getResult() == MessageBoxResult.Cancel) {
            this.suspendImport();
            return;
        }
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        }
    }

    private void suspendImport() {
        IFormView view = this.getView();
        IFormView parentView = this.getParentView();
        if (parentView != null) {
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"ImportingPlugin_8", (String)BOS_IMPORT, (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            this.suspendLog();
        }
        this.getAppCache(view).put(this.getSuspendKey(view), (Object)this.getSuspendKey(view));
        TaskClientProxy.delTask((JobFormInfo)this.getJobFormInfo(), (String)this.getTaskId(), null);
        this.releaseLimitLock();
        this.closeForm();
    }

    private IFormView getParentView() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        return this.getView().getViewNoPlugin(parentPageId);
    }

    private void releaseLimitLock() {
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("concurrentID")))) {
            ConcurrencyLimiter.release((String)((String)this.getView().getFormShowParameter().getCustomParam("concurrentID")));
        }
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (TaskClientProxy.isExistTask((String)taskId)) {
            return;
        }
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
        BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
        ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
    }

    public void click(EventObject evt) {
        String controlKey;
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        OperationResult result = new OperationResult();
        String orgIdsStr = (String)currShowParameter.getCustomParam("MainOrgIds");
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId((String)currShowParameter.getCustomParam("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSONObject.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId((String)currShowParameter.getCustomParam("RealPermissionEntityId")).setCurrentEntityId((String)currShowParameter.getCustomParam(BILLFORMID)).setOperateName((String)currShowParameter.getCustomParam("OperateName")).setPermissionItemId((String)currShowParameter.getCustomParam("PermissionItemId")).setResult(result);
        switch (controlKey = ((Control)evt.getSource()).getKey()) {
            case "btndetails": {
                this.exportExcelErrMsg(result, importPermissionParamBuidler);
                break;
            }
            case "btnok": {
                this.continueImport(result, importPermissionParamBuidler);
                break;
            }
            case "btnresult": {
                this.showImportResult(result, importPermissionParamBuidler);
                break;
            }
            case "btnsuspend": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u7ec8\u6b62\u5bfc\u5165\u4efb\u52a1\uff1f", (String)"ImportingPlugin_12", (String)BOS_IMPORT, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMED_SUSPEND, (IFormPlugin)this));
                break;
            }
            case "btncancel": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u5bfc\u5165\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"ImportingPlugin_13", (String)BOS_IMPORT, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMED_TOBACKGROUND, (IFormPlugin)this));
                break;
            }
        }
    }

    private void showImportResult(OperationResult result, ImportPermissionParam.Buidler importPermissionParamBuidler) {
        if (!this.validatePermission(importPermissionParamBuidler.build())) {
            this.createOperationLogByViewImportResult(false);
            this.doFailCheckRight(result);
            return;
        }
        IFormView view = this.getView();
        String parentPageId = view.getFormShowParameter().getParentPageId();
        IFormView parentView = view.getViewNoPlugin(parentPageId);
        String pkId = this.getPageCache().get(IMPORT_PROGRESS_ID);
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(BOS_IMPORTLOG);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setParentPageId(view.getFormShowParameter().getParentPageId());
        parameter.setPkId((Object)pkId);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getCustomParams().put("ParentEntityId", view.getFormShowParameter().getCustomParam("RealPermissionEntityId"));
        parentView.showForm((FormShowParameter)parameter);
        view.sendFormAction(parentView);
        view.close();
        this.createOperationLogByViewImportResult(true);
    }

    private void continueImport(OperationResult result, ImportPermissionParam.Buidler importPermissionParamBuidler) {
        if (!this.validatePermission(importPermissionParamBuidler.build())) {
            this.createOperationLogByImportAgain(false);
            this.doFailCheckRight(result);
            return;
        }
        IFormView view = this.getView();
        FormShowParameter parameter = view.getFormShowParameter();
        IFormView parentView = view.getViewNoPlugin(parameter.getParentPageId());
        parentView.invokeOperation((String)parameter.getCustomParam("OperateKey"));
        view.close();
        view.sendFormAction(parentView);
        this.createOperationLogByImportAgain(true);
    }

    private void exportExcelErrMsg(OperationResult result, ImportPermissionParam.Buidler importPermissionParamBuidler) {
        String jsonData;
        DynamicObject taskData;
        if (!this.validatePermission(importPermissionParamBuidler.build())) {
            this.doFailCheckRight(result);
            return;
        }
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID);
        String pk = this.getPageCache().get(ImportDataTask.getCacheKey(billFormId, this.getView().getPageId()));
        if (StringUtils.isBlank((CharSequence)pk)) {
            pk = (String)this.getView().getFormShowParameter().getCustomParam("logId");
        }
        if ((taskData = BusinessDataServiceHelper.loadSingle((Object)pk, (String)BOS_IMPORTLOG, (String)"data")) == null || StringUtils.isBlank((CharSequence)(jsonData = taskData.getString("data")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ImportingPlugin_3", (String)BOS_IMPORT, (Object[])new Object[0]));
            return;
        }
        JSONObject data = JSON.parseObject((String)jsonData);
        log.debug("exportExcelErrMsg data is " + SerializationUtils.toJsonString((Object)data));
        try {
            JSONObject info = data.getJSONObject("info");
            for (Object obj : info.values()) {
                ImportLogger logger = (ImportLogger)JSONObject.parseObject((String)((JSONObject)obj).toJSONString(), ImportLogger.class);
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                if (StringUtils.isNotBlank((CharSequence)logger.getErrFile())) {
                    String attachId;
                    String entityNum = "";
                    String appId = "";
                    boolean checkFilePermission = ((IAttachmentService)ServiceFactory.getService(IAttachmentService.class)).checkFilePermission();
                    if (checkFilePermission) {
                        if (this.getParentView() instanceof ListView) {
                            entityNum = (String)this.getView().getFormShowParameter().getCustomParam("RealPermissionEntityId");
                            entityNum = StringUtils.isNotBlank((CharSequence)entityNum) ? entityNum : ((ListView)this.getParentView()).getBillFormId();
                            appId = EntityMetadataCache.getDataEntityType((String)entityNum).getAppId();
                            String logEntityNum = BOS_IMPORTLOG;
                            String logPkId = taskData.getString("id");
                            String fileType = "";
                            attachId = PermissionParam.genAttacId((String)appId, (String)entityNum, (String)logEntityNum, (Object)logPkId, (String)fileType);
                            List permissionParamList = PermissionParam.getPermissionParamList((String)attachId);
                            log.debug("attachId is " + attachId + ", permissionParamList is  " + permissionParamList);
                            if (!FilePremissionUtil.hasEntityPermission((List)PermissionParam.getPermissionParamList((String)attachId)).booleanValue()) {
                                String permissionItem = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"Permission_IMPT", (String)BOS_IMPORT, (Object[])new Object[0]);
                                String nopermissiontips = FilePremissionUtil.genNoPermissionTips((String)entityNum, (String)permissionItem);
                                this.getView().showErrorNotification(nopermissiontips);
                                return;
                            }
                        } else {
                            String parentViewName = this.getParentView() != null ? this.getParentView().getEntityId() : this.getView().getEntityId();
                            log.warn("export parentView is not support " + parentViewName);
                            attachId = taskData.getString("id") + "@bos_importlog";
                            attachId = Base64.getEncoder().encodeToString(attachId.getBytes(StandardCharsets.UTF_8));
                        }
                    } else {
                        attachId = taskData.getString("id") + "@bos_importlog";
                        attachId = Base64.getEncoder().encodeToString(attachId.getBytes(StandardCharsets.UTF_8));
                    }
                    proxy.addAction("download", (Object)(UrlService.getDomainContextUrl() + "/attachment/download.do?attachId=" + attachId + "&appId=" + appId + "&fId=" + entityNum + "&a=t"));
                    this.createOperationLog(true, ConvertUtil.convertFileNameFromUrl((String)logger.getErrFile(), (String)"unresolved.xlsx", (String)""));
                    continue;
                }
                if (logger.getFailed() > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"ImportingPlugin_4", (String)BOS_IMPORT, (Object[])new Object[0]));
                    continue;
                }
                String msg = logger.toString().trim();
                if (msg.isEmpty()) continue;
                this.getView().showErrorNotification(msg);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ece\u65e5\u5fd7\u4e2d\u63d0\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u53ef\u80fd\u65e5\u5fd7\u683c\u5f0f\u5316\u592a\u65e7\uff0c\u8bf7\u5c1d\u8bd5\u4ece\u65e5\u5fd7\u4e2d\u624b\u52a8\u63d0\u53d6\u5230\u5730\u5740\u680f\u4e0b\u8f7d\u3002", (String)"ImportingPlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_JOBFORMINFO) ? (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_JOBFORMINFO) : this.getPageCache().get(CACHEKEY_JOBFORMINFO);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private void closeForm() {
        this.canClose = true;
        this.getView().close();
    }

    private Object createImportlog(String billFormId, String name) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)BOS_IMPORTLOG);
        DynamicObject dyn = (DynamicObject)objType.createInstance();
        dyn.set("name", (Object)name);
        dyn.set("billstatus", (Object)"C");
        dyn.set("importstatus", (Object)"0");
        dyn.set("createtime", (Object)new TimeService().now());
        dyn.set(IMPORTTYPE, (Object)IMPORTDATA);
        if (StringUtils.isNotBlank((CharSequence)billFormId)) {
            dyn.set("sourceObj_id", (Object)billFormId);
        }
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber(BOS_IMPORTLOG, dyn, null);
        dyn.set("billno", (Object)billno);
        dyn = (DynamicObject)BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn})[0];
        this.getPageCache().put(ImportDataTask.getCacheKey(billFormId, this.getView().getPageId()), String.valueOf(dyn.getPkValue()));
        return dyn.getPkValue();
    }

    private void markStart() {
        this.getPageCache().remove(CHECK_FINISHED_KEY);
        this.getPageCache().put(CHECK_START_KEY, "START_MARK");
    }

    private void markFinished() {
        this.getPageCache().remove(CHECK_START_KEY);
        this.getPageCache().put(CHECK_FINISHED_KEY, "START_MARK");
    }

    private boolean checkIsStart() {
        return "START_MARK".equals(this.getPageCache().get(CHECK_START_KEY));
    }

    private boolean checkIsFinished() {
        return "START_MARK".equals(this.getPageCache().get(CHECK_FINISHED_KEY));
    }

    private void suspendLog() {
        ImportOperationLog.getInstance().createAppLog(this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.IMPORT_SUSPEND.getOpNameBridge(), ImportOperationLog.OperationEnum.IMPORT_SUSPEND.getOpDescFormatBridge(), new String[0]);
    }
}

