/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry;

import java.io.IOException;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.exportentry.ImportEntryModelExporter;
import kd.bos.form.exportentry.ImportEntryWriterBuilder;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class ImportEntryTemplateDownloadPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ImportEntryTemplateDownloadPlugin.class);
    private static final String BTN_DOWNLOAD = "btndownload";
    private static final String FIELD_BIZOBJ = "bizobject";
    private static final String TOOLBAR = "advcontoolbarap";
    private static final String TOOLBAR_TBMAIN = "tbmain";
    private static final String bosImportEntryTemplate = "bos_importentry_template";
    private final String RES_SAVE_TEMPLATE = ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u6a21\u677f\u540e\u4e0b\u8f7d\u3002", (String)"ImportTemplatePlugin_6", (String)"bos-import", (Object[])new Object[0]);
    private final String RES_TEMPLATE_PREFIX = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"ImportTemplatePlugin_0", (String)"bos-import", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBAR});
        this.addItemClickListeners(new String[]{TOOLBAR_TBMAIN});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (BTN_DOWNLOAD.equals(evt.getItemKey())) {
            try {
                this.pushBillTempalte();
            }
            catch (IOException e) {
                log.error((Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushBillTempalte() throws IOException {
        Long templateId;
        BasedataProp bizObjProp = (BasedataProp)this.getModel().getProperty(FIELD_BIZOBJ);
        DynamicObject bizobj = (DynamicObject)this.getModel().getValue(bizObjProp.getName());
        if (bizobj == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4e1a\u52a1\u5bf9\u8c61", (String)"ImportTemplatePlugin_18", (String)"bos-import", (Object[])new Object[0]));
            return;
        }
        String billFormId = bizobj.getString(bizObjProp.getNumberProp());
        if (StringUtils.isBlank((CharSequence)billFormId)) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        String fileName = this.createFileName(mainEntityType, templateId = (Long)this.getModel().getDataEntity().getPkValue());
        if (fileName == null) {
            return;
        }
        ExportWriterFormat format = new ImportEntryWriterBuilder().build(billFormId, templateId.longValue());
        try (ImportEntryModelExporter dataExporter = new ImportEntryModelExporter(format);){
            dataExporter.init(null);
            dataExporter.write();
            String url = dataExporter.flush(this.getModel().getDataEntityType(), fileName);
            url = UrlService.getAttachmentFullUrl((String)url);
            this.getView().download(url);
            this.getView().sendFormAction(this.getView());
        }
    }

    private String createFileName(MainEntityType mainEntityType, Long templateId) {
        if (templateId == null || templateId <= 0L) {
            this.getView().showTipNotification(this.RES_SAVE_TEMPLATE);
            return null;
        }
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)bosImportEntryTemplate);
        String fileName = this.RES_TEMPLATE_PREFIX;
        fileName = templateData != null ? fileName + templateData.get("name") : fileName + mainEntityType.getDisplayName();
        return fileName;
    }
}

