/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeTogetherMoveEntryRowEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.importentry.ImportEntryTemplateCreatePlugin;
import kd.bos.form.plugin.importentry.model.ImportTreeRowInfo;
import kd.bos.form.plugin.importentry.model.ImportTreeRowTypeEnum;
import kd.bos.form.plugin.importentry.model.ImportTreeRowView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.utils.ImportPluginUtils;

public class ImportEntryTemplateVerifySavePlugin
extends ImportEntryTemplateCreatePlugin {
    private static final Log log = LogFactory.getLog(ImportEntryTemplateVerifySavePlugin.class);
    private static final String OPERATEKEY_SAVE = "save";
    private static final String TREEENTRYTABLENAME = "t_bas_importentry_tree";
    private boolean isNewAdd = true;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        boolean isFormDB = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        this.isNewAdd = !isFormDB;
        boolean isChange = this.getModel().getDataChanged();
        Object enable = this.getModel().getValue("enable");
        if (isFormDB && isChange) {
            switch (operateKey) {
                case "enable": {
                    if (!enable.equals("0")) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u66f4\u6539\u5185\u5bb9\u672a\u4fdd\u5b58\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u542f\u7528\u3002", (String)"ImportTemplatePlugin_100", (String)"bos-import", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                case "disable": {
                    if (!enable.equals("1")) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u66f4\u6539\u5185\u5bb9\u672a\u4fdd\u5b58\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u7981\u7528\u3002", (String)"ImportTemplatePlugin_101", (String)"bos-import", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
            }
        }
        if (!StringUtils.equals((CharSequence)OPERATEKEY_SAVE, (CharSequence)formOperate.getOperateKey())) {
            return;
        }
        if (!isFormDB) {
            this.getModel().setValue("enable", (Object)1);
        }
        String bizObjectId = (String)this.getModel().getValue("bizobject_Id");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)bizObjectId);
        ImportTreeRowInfo importTreeRowInfo = this.getCacheOfImportTreeRowInfo(entityType, false);
        this.verfy(args, entityType, this.treeRowFactory.convertInfoToView(importTreeRowInfo));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (StringUtils.equals((CharSequence)OPERATEKEY_SAVE, (CharSequence)afterDoOperationEventArgs.getOperateKey())) {
            OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
            if (opResult != null && opResult.isSuccess()) {
                this.getPageCache().remove("PAGECACHE_KEY_IMPORTSTOREDATA");
                return;
            }
            if (this.isNewAdd) {
                this.getModel().setValue("enable", (Object)"");
            }
        }
    }

    private void verfy(BeforeDoOperationEventArgs args, MainEntityType entityType, ImportTreeRowView importTreeRowView) {
        try {
            this.verifyHasAnyImport(entityType, importTreeRowView);
            this.verifyHasEntryPropAtSubEntry(entityType, importTreeRowView);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            args.setCancel(true);
            args.setCancelMessage(e.getMessage());
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void verifyHasAnyImport(MainEntityType entityType, ImportTreeRowView importTreeRowView) {
        List isImport = importTreeRowView.getTreeRowInfosAtRow().values().stream().filter(val -> {
            Object value = this.getModel().getValue("isimport", val.getRow());
            return value == Boolean.TRUE;
        }).collect(Collectors.toList());
        if (isImport.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u5f00\u542f\u4e00\u4e2a\u5b57\u6bb5\u7684\u201c\u662f\u5426\u5bfc\u5165\u201d\u5c5e\u6027\u3002", (String)"ImportTemplatePlugin_23", (String)"bos-import", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void verifyHasEntryPropAtSubEntry(MainEntityType mainEntityType, ImportTreeRowView importTreeRowView) {
        Map<String, List<ImportTreeRowView.RowView>> importEntryTreeRowInfosAtEntityNumber = importTreeRowView.getTreeRowInfosAtRow().values().stream().filter(val -> val.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.SUBENTITY_PROPERTY).filter(val -> {
            Object value = this.getModel().getValue("isimport", val.getRow());
            return value == Boolean.TRUE;
        }).collect(Collectors.groupingBy(ImportTreeRowView.RowView::getEntityNumber));
        if (CollectionUtils.isEmpty(importEntryTreeRowInfosAtEntityNumber.keySet())) {
            return;
        }
        for (Map.Entry<String, List<ImportTreeRowView.RowView>> entry : importEntryTreeRowInfosAtEntityNumber.entrySet()) {
            Optional first = entry.getValue().stream().findFirst();
            if (!first.isPresent()) continue;
            ImportTreeRowView.RowView rowView = (ImportTreeRowView.RowView)first.get();
            EntityType subEntryType = rowView.getEntityType(mainEntityType);
            IDataEntityType entryType = subEntryType.getParent();
            this.verifyHasEntryProp(importTreeRowView, entryType);
        }
    }

    private void verifyHasEntryProp(ImportTreeRowView importTreeRowView, IDataEntityType entryType) {
        Optional<ImportTreeRowView.RowView> enableIsImportTreeRowInfo = importTreeRowView.getTreeRowInfosAtRow().values().stream().filter(val -> val.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.ENTITY_PROPERTY).filter(val -> val.getEntityNumber().equals(entryType.getName())).filter(val -> {
            Object value = this.getModel().getValue("isimport", val.getRow());
            return value == Boolean.TRUE;
        }).findAny();
        if (!enableIsImportTreeRowInfo.isPresent()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u201c%1$s(%2$s)\u201d\u4e0b\u5b58\u5728\u5b50\u5355\u636e\u4f53\u5f00\u542f\u4e86\u67d0\u5b57\u6bb5\u7684\u5c5e\u6027\uff0c\u5219\u7236\u5355\u636e\u4f53\u5fc5\u987b\u81f3\u5c11\u5f00\u542f\u4e00\u4e2a\u5b57\u6bb5\u7684\u201c%3$s\u201d\u5c5e\u6027\u3002", (String)"ImportTemplatePlugin_10", (String)"bos-import", (Object[])new Object[0]), entryType.getDisplayName(), entryType.getName(), this.RES_IF_IMPORT));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        if ((evt.getItemKey().equals("advconbaritemap") || evt.getItemKey().equals("advconbaritemap1")) && selectRows.length == 0) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ImportLogDeleteFileListPlugin_5", (String)"bos-import", (Object[])new Object[0]));
            return;
        }
        switch (evt.getItemKey()) {
            case "advconbaritemap": {
                ImportTreeRowView rowViews = this.getRowViews();
                boolean isEntryEntity = this.isEntryEntity(rowViews);
                if (isEntryEntity) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u4e0d\u80fd\u4e0a\u4e0b\u79fb\u52a8\u3002", (String)"ImportTemplatePlugin_26", (String)"bos-import", (Object[])new Object[0]));
                }
                if (this.isRowIdOrPid()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914did\u5c5e\u6027\u4e0d\u80fd\u4e0a\u4e0b\u79fb\u52a8\u3002", (String)"ImportEntryTemplatePlugin_16", (String)"bos-import", (Object[])new Object[0]));
                }
                if (this.isDownIdOrPidRow()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u5176\u4ed6\u5c5e\u6027\u4e0d\u80fd\u6539\u53d8\u5339\u914did\u5c5e\u6027\u7684\u4f4d\u7f6e\u3002", (String)"ImportEntryTemplatePlugin_17", (String)"bos-import", (Object[])new Object[0]));
                }
                evt.setCancel(this.isRowIdOrPid() || this.isDownIdOrPidRow() || isEntryEntity);
                break;
            }
            case "advconbaritemap1": {
                ImportTreeRowView rowViews1 = this.getRowViews();
                boolean isEntryEntity1 = this.isEntryEntity(rowViews1);
                boolean isWithEntryEntity = this.isWithEntryEntity(rowViews1, 1);
                if (isEntryEntity1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u4e0d\u80fd\u4e0a\u4e0b\u79fb\u52a8\u3002", (String)"ImportTemplatePlugin_26", (String)"bos-import", (Object[])new Object[0]));
                }
                if (isWithEntryEntity) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u8de8\u5355\u636e\u4f53\u79fb\u52a8\u5c5e\u6027\u3002", (String)"ImportTemplatePlugin_27", (String)"bos-import", (Object[])new Object[0]));
                }
                if (this.isRowIdOrPid()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914did\u5c5e\u6027\u4e0d\u80fd\u4e0a\u4e0b\u79fb\u52a8\u3002", (String)"ImportEntryTemplatePlugin_16", (String)"bos-import", (Object[])new Object[0]));
                }
                evt.setCancel(this.isRowIdOrPid() || isEntryEntity1 || isWithEntryEntity);
                break;
            }
        }
    }

    private boolean isEntryEntity(ImportTreeRowView rowViews) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        if (rowViews == null || rowViews.getTreeRowInfosAtRow().size() == 0) {
            return false;
        }
        String propertyNumber = rowViews.getTreeRowInfosAtRow().get(entryCurrentRowIndex).getPropertyNumber();
        return StringUtils.isEmpty((CharSequence)propertyNumber);
    }

    private ImportTreeRowView getRowViews() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        if (entryCurrentRowIndex == 0) {
            return null;
        }
        String entityId = (String)this.getModel().getValue("bizobject_Id");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        ImportTreeRowInfo importTreeRowInfo = this.getCacheOfImportTreeRowInfo(dataEntityType, false);
        ImportTreeRowView importTreeRowView = this.treeRowFactory.convertInfoToView(importTreeRowInfo);
        return importTreeRowView;
    }

    private boolean isWithEntryEntity(ImportTreeRowView rowViews, int step) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        int entryNextRowIndex = selectRows[selectRows.length - 1] + step;
        if (entryNextRowIndex == 0) {
            return false;
        }
        if (rowViews == null || rowViews.getTreeRowInfosAtRow().size() == 0) {
            return false;
        }
        ImportTreeRowView.RowView rowView = rowViews.getTreeRowInfosAtRow().get(entryNextRowIndex);
        if (rowView == null) {
            return false;
        }
        String propertyNumber = rowView.getPropertyNumber();
        return StringUtils.isEmpty((CharSequence)propertyNumber);
    }

    private boolean isRowIdOrPid() {
        IDataModel model = this.getModel();
        String entityNumber = (String)model.getValue("entitynumber", model.getEntryCurrentRowIndex("treeentryentity"));
        return "id".equals(entityNumber) || entityNumber.endsWith(".id") || entityNumber.endsWith(".pid") || entityNumber.endsWith(".$matchid$");
    }

    private boolean isDownIdOrPidRow() {
        IDataModel model = this.getModel();
        int rk = model.getEntryCurrentRowIndex("treeentryentity");
        if (rk > 0) {
            String entityNumber = (String)model.getValue("entitynumber", rk - 1);
            return "id".equals(entityNumber) || entityNumber.endsWith(".id") || entityNumber.endsWith(".pid") || entityNumber.endsWith(".$matchid$");
        }
        return false;
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryUp(e);
        this.reSort();
        this.focusMoveRow(e.getRowIndexs(), -1);
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryDown(e);
        this.reSort();
        this.focusMoveRow(e.getRowIndexs(), 1);
    }

    private void focusMoveRow(int[] rowIndexs, int step) {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = new int[rowIndexs.length];
        for (int i = 0; i < rowIndexs.length; ++i) {
            selectRows[i] = rowIndexs[i] + step;
        }
        grid.focus(selectRows[rowIndexs.length - 1], selectRows[rowIndexs.length - 1]);
        grid.selectRows(selectRows, selectRows[rowIndexs.length - 1]);
    }

    private void reSort() {
        this.getModel().beginInit();
        String entityId = (String)this.getModel().getValue("bizobject_Id");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        ImportTreeRowInfo importTreeRowInfo = this.getCacheOfImportTreeRowInfo(dataEntityType, false);
        Optional<Map<String, Map<String, Object>>> storeDatas = this.loadDataEntiyFromModel();
        importTreeRowInfo.comparatorTreeRowInfo(storeDatas.get());
        this.refreshCacheOfImportEntryTreeInfo(importTreeRowInfo);
        this.functionWhenInitModel(v -> this.getModel().deleteEntryData("treeentryentity"));
        ImportTreeRowView importTreeRowView = this.treeRowFactory.convertInfoToView(importTreeRowInfo);
        this.createEntryRow(dataEntityType, importTreeRowView);
        this.restoreTreeRowPkIdInfosFromStore(importTreeRowView, storeDatas.get());
        this.restoreTreeRowImportInfosFromStore(importTreeRowView, storeDatas.get());
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
        this.getView().updateView("treeentryentity");
    }

    public void beforeTogetherMoveEntryRow(BeforeTogetherMoveEntryRowEventArgs e) {
        int toIndex;
        int[] fromIndex = e.getFormIndexs();
        boolean notChange = fromIndex[fromIndex.length - 1] == (toIndex = e.getToIndex());
        boolean isUpMove = fromIndex[0] >= toIndex;
        boolean containsEntryEntity = this.containsEntryEntity(fromIndex);
        if (containsEntryEntity) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u4e0d\u80fd\u4e0a\u4e0b\u79fb\u52a8\u3002", (String)"ImportTemplatePlugin_26", (String)"bos-import", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (this.isRowIdOrPid(fromIndex)) {
            e.setCancel(true);
            return;
        }
        if (isUpMove) {
            if (this.isDownIdOrPidRow(++toIndex, notChange) || ImportPluginUtils.notAllowMoveEntryUp(this.getView(), e.getEntryProp().getName(), fromIndex)) {
                e.setCancel(true);
                return;
            }
        } else if (ImportPluginUtils.notAllowMoveEntryDown(this.getView(), e.getEntryProp().getName(), fromIndex)) {
            e.setCancel(true);
            return;
        }
        if (0 != toIndex && toIndex == fromIndex[fromIndex.length - 1] && ImportPluginUtils.notAllowMoveEntryDown(this.getView(), e.getEntryProp().getName(), fromIndex)) {
            e.setCancel(true);
            return;
        }
        super.beforeTogetherMoveEntryRow(e);
    }

    private boolean isRowIdOrPid(int[] rowsIndex) {
        IDataModel model = this.getModel();
        String entityNumber = "";
        for (int index : rowsIndex) {
            entityNumber = String.valueOf(model.getValue("entitynumber", index));
            if (!"id".equals(entityNumber) && !entityNumber.endsWith(".id") && !entityNumber.endsWith(".pid") && !entityNumber.endsWith(".$matchid$")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914did\u5c5e\u6027\u4e0d\u80fd\u4e0a\u4e0b\u79fb\u52a8\u3002", (String)"ImportEntryTemplatePlugin_16", (String)"bos-import", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean containsEntryEntity(int[] fromRows) {
        String entityId = (String)this.getModel().getValue("bizobject_Id");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        ImportTreeRowInfo importTreeRowInfo = this.getCacheOfImportTreeRowInfo(dataEntityType, false);
        ImportTreeRowView importTreeRowView = this.treeRowFactory.convertInfoToView(importTreeRowInfo);
        for (int entryCurrentRowIndex : fromRows) {
            if (importTreeRowView == null || importTreeRowView.getTreeRowInfosAtRow().size() == 0) {
                return false;
            }
            String propertyNumber = importTreeRowView.getTreeRowInfosAtRow().get(entryCurrentRowIndex).getPropertyNumber();
            if (!StringUtils.isEmpty((CharSequence)propertyNumber)) continue;
            return true;
        }
        return false;
    }

    private boolean isDownIdOrPidRow(int toIndex, boolean notChange) {
        String entityNumber = (String)this.getModel().getValue("entitynumber", toIndex);
        if (notChange) {
            return false;
        }
        if (null != entityNumber && ("id".equals(entityNumber) || entityNumber.endsWith(".id") || entityNumber.endsWith(".pid") || entityNumber.endsWith(".$matchid$"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u5176\u4ed6\u5c5e\u6027\u4e0d\u80fd\u6539\u53d8\u5339\u914did\u5c5e\u6027\u7684\u4f4d\u7f6e\u3002", (String)"ImportEntryTemplatePlugin_17", (String)"bos-import", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

